/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.SQLFunctionDatabase;
import ghidra.features.bsim.query.client.BSimSqlClause;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.protocol.BSimFilter;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SQLEffects {
    private boolean exetable = false;
    private boolean pathtable = false;
    private int filterMask = 0;
    private int filterValue = 0;
    private Map<BSimFilterType, List<String>> wherelist = new TreeMap<BSimFilterType, List<String>>();
    private List<String> linkClauses = new ArrayList<String>();

    public void setExeTable() {
        this.exetable = true;
    }

    public void setPathTable() {
        this.pathtable = true;
    }

    public void addFunctionFilter(int flag, boolean val) {
        this.filterMask |= flag;
        if (val) {
            this.filterValue |= flag;
        }
    }

    private void generateWhereClause(BSimFilter exefilter, IDSQLResolution[] idres, SQLFunctionDatabase db) throws SQLException {
        for (int i = 0; i < exefilter.numAtoms(); ++i) {
            FilterAtom atom = exefilter.getAtom(i);
            atom.type.gatherSQLEffect(this, atom, idres[i]);
        }
        if (this.filterMask != 0) {
            StringBuilder buf = new StringBuilder();
            String maskedFlags = db.formatBitAndSQL("desctable.flags", Integer.toString(this.filterMask));
            buf.append(maskedFlags).append(" = ").append(this.filterValue);
            this.addLink(buf.toString());
        }
        if (this.exetable) {
            this.addLink("desctable.id_exe = exetable.id");
        }
        if (this.pathtable) {
            this.addLink("exetable.path = pathtable.id");
        }
    }

    private String buildWhereClause() {
        StringBuilder builder = new StringBuilder();
        if (!this.linkClauses.isEmpty()) {
            builder.append(" AND (");
            boolean printAnd = false;
            for (String link : this.linkClauses) {
                if (printAnd) {
                    builder.append(" AND ");
                }
                builder.append(link);
                printAnd = true;
            }
            builder.append(')');
        }
        for (Map.Entry<BSimFilterType, List<String>> entry : this.wherelist.entrySet()) {
            builder.append(" AND ");
            BSimFilterType filter = entry.getKey();
            String finalClause = filter.buildSQLCombinedClause(entry.getValue());
            builder.append(finalClause);
        }
        return builder.toString();
    }

    private String buildTableClause() {
        StringBuilder buf = new StringBuilder();
        if (this.exetable) {
            buf.append(",exetable");
        }
        if (this.pathtable) {
            buf.append(",pathtable");
        }
        return buf.toString();
    }

    public void addLink(String value) {
        this.linkClauses.add(value);
    }

    public void addWhere(BSimFilterType filter, String val) {
        List<String> list = this.wherelist.get(filter);
        if (list == null) {
            list = new ArrayList<String>();
            this.wherelist.put(filter, list);
        }
        list.add(val);
    }

    public static BSimSqlClause createFilter(BSimFilter exeFilter, IDSQLResolution[] idres, SQLFunctionDatabase db) throws SQLException {
        String tableclause = null;
        String whereclause = null;
        SQLEffects effects = new SQLEffects();
        effects.generateWhereClause(exeFilter, idres, db);
        whereclause = effects.buildWhereClause();
        if (whereclause == null || whereclause.length() == 0) {
            return null;
        }
        tableclause = effects.buildTableClause();
        return new BSimSqlClause(tableclause, whereclause);
    }
}

