/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.PIC30_ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.PIC30_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import java.util.Map;

public class PIC30_ElfRelocationHandler
extends AbstractElfRelocationHandler<PIC30_ElfRelocationType, PIC30_ElfRelocationContext> {
    private Boolean isEDSVariant = null;

    public PIC30_ElfRelocationHandler() {
        super(PIC30_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 118;
    }

    public PIC30_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new PIC30_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    private boolean isEDSVariant(PIC30_ElfRelocationContext elfRelocationContext) {
        if (this.isEDSVariant == null) {
            Register reg = elfRelocationContext.program.getRegister("DSRPAG");
            this.isEDSVariant = reg != null && reg.getAddressSpace().isMemorySpace();
        }
        return this.isEDSVariant;
    }

    protected RelocationResult relocate(PIC30_ElfRelocationContext elfRelocationContext, ElfRelocation relocation, PIC30_ElfRelocationType type, Address relocationAddress, ElfSymbol elfSymbol, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int addend = (int)relocation.getAddend();
        long relocWordOffset = (int)relocationAddress.getAddressableWordOffset();
        int oldValue = memory.getInt(relocationAddress);
        short oldShortValue = memory.getShort(relocationAddress);
        int byteLength = 2;
        switch (type) {
            case R_PIC30_16: 
            case R_PIC30_FILE_REG_WORD: {
                int newValue = (int)symbolValue + addend + oldShortValue;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case R_PIC30_32: {
                int newValue = (int)symbolValue + addend + oldValue;
                memory.setInt(relocationAddress, newValue);
                byteLength = 4;
                break;
            }
            case R_PIC30_FILE_REG_BYTE: 
            case R_PIC30_FILE_REG: {
                int reloc = (int)symbolValue;
                reloc += addend;
                reloc += oldShortValue;
                int newValue = (reloc &= 0x1FFF) | oldShortValue & 0xFFFFE000;
                memory.setShort(relocationAddress, (short)newValue);
                break;
            }
            case R_PIC30_FILE_REG_WORD_WITH_DST: {
                int reloc = (int)symbolValue >> 1;
                reloc += addend;
                reloc += oldValue >> 4;
                int newValue = (reloc &= Short.MAX_VALUE) << 4 | oldValue & 0xFFF8000F;
                memory.setInt(relocationAddress, newValue);
                byteLength = 4;
                break;
            }
            case R_PIC30_WORD: 
            case R_PIC30_WORD_TBLOFFSET: {
                int reloc = (int)symbolValue;
                reloc += addend;
                reloc += oldValue >> 4;
                int newValue = (reloc &= 0xFFFF) << 4 | oldValue & 0xFFF0000F;
                memory.setInt(relocationAddress, newValue);
                byteLength = 4;
                break;
            }
            case R_PIC30_WORD_TBLPAGE: {
                int reloc = (int)symbolValue >> 16;
                reloc += addend;
                reloc += oldValue >> 4;
                reloc &= 0xFFFF;
                if (this.isEDSVariant(elfRelocationContext)) {
                    reloc |= 0x100;
                }
                int newValue = reloc << 4 | oldValue & 0xFFF0000F;
                memory.setInt(relocationAddress, newValue);
                byteLength = 4;
                break;
            }
            case R_PIC30_PCREL_BRANCH: {
                int newValue = (int)(symbolValue - relocWordOffset + (long)oldShortValue - 2L);
                memory.setShort(relocationAddress, (short)((newValue >>>= 1) & 0xFFFF));
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, relocation.getSymbolIndex(), symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

