/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashBasicDirectoryInode;
import ghidra.file.formats.squashfs.SquashBasicFileInode;
import ghidra.file.formats.squashfs.SquashExtendedDirectoryInode;
import ghidra.file.formats.squashfs.SquashExtendedFileInode;
import ghidra.file.formats.squashfs.SquashInode;
import ghidra.file.formats.squashfs.SquashOtherInode;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import ghidra.file.formats.squashfs.SquashSymlinkInode;
import ghidra.file.formats.squashfs.SquashUtils;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SquashInodeTable {
    private final SquashInode[] inodes;
    private long rootInodeOffset;
    private SquashInode rootInode;

    public SquashInodeTable(BinaryReader reader, SquashSuperBlock superBlock, TaskMonitor monitor) throws IOException, CancelledException {
        reader.setPointerIndex(superBlock.getInodeTableStart());
        reader = this.decompressInodeTable(reader, superBlock.getDirectoryTableStart(), superBlock, monitor);
        this.inodes = new SquashInode[(int)superBlock.getInodeCount() + 1];
        this.inodes[0] = null;
        while (reader.hasNext()) {
            monitor.checkCancelled();
            boolean isRootInode = reader.getPointerIndex() == this.rootInodeOffset;
            short inodeType = reader.peekNextShort();
            SquashInode tempInode = switch (inodeType) {
                case 2 -> new SquashBasicFileInode(reader, superBlock, false);
                case 9 -> new SquashExtendedFileInode(reader, superBlock);
                case 1 -> new SquashBasicDirectoryInode(reader, superBlock, false);
                case 8 -> new SquashExtendedDirectoryInode(reader, superBlock);
                case 3 -> new SquashSymlinkInode(reader, superBlock, false);
                case 10 -> new SquashSymlinkInode(reader, superBlock, true);
                default -> new SquashOtherInode(reader, superBlock, inodeType);
            };
            int tempInodeNumber = tempInode.getNumber();
            if (tempInodeNumber == 0 || (long)tempInodeNumber > superBlock.getInodeCount()) {
                throw new IOException("Invalid inode number found: " + tempInodeNumber);
            }
            this.inodes[tempInode.getNumber()] = tempInode;
            if (!isRootInode) continue;
            this.rootInode = tempInode;
        }
    }

    public SquashInode[] getInodes() {
        return this.inodes;
    }

    public SquashInode getInodeByNumber(int inodeNumber) {
        return this.inodes[inodeNumber];
    }

    public SquashInode getRootInode() {
        return this.rootInode;
    }

    public void buildRelationships(TaskMonitor monitor) throws CancelledException {
        for (int i = this.inodes.length - 1; i > 0; --i) {
            SquashBasicDirectoryInode dirInode;
            monitor.checkCancelled();
            SquashInode currentInode = this.inodes[i];
            if (!currentInode.isDir() || (dirInode = (SquashBasicDirectoryInode)currentInode).isParentRoot()) continue;
            dirInode.setParent(this.inodes[dirInode.getParentInodeNumber()]);
        }
    }

    private BinaryReader decompressInodeTable(BinaryReader reader, long endAddress, SquashSuperBlock superBlock, TaskMonitor monitor) throws IOException, CancelledException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int totalUncompressedBytes = 0;
        while (reader.getPointerIndex() < endAddress) {
            monitor.checkCancelled();
            if (reader.getPointerIndex() - superBlock.getInodeTableStart() == superBlock.getRootInodeBlockLocation()) {
                this.rootInodeOffset = (long)totalUncompressedBytes + superBlock.getRootInodeOffset();
            }
            byte[] bytes = SquashUtils.decompressBlock(reader, superBlock.getCompressionType(), monitor);
            bos.write(bytes);
            totalUncompressedBytes += bytes.length;
        }
        return SquashUtils.byteArrayToReader(bos.toByteArray());
    }
}

