/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.deprecation.DocumentedFailure;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JavaInstallationCapability;
import org.gradle.internal.jvm.inspection.JavaInstallationRegistry;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadataComparator;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.jvm.inspection.JvmToolchainMetadata;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.install.JvmInstallationMetadataMatcher;

@ServiceScope(value={Scope.Build.class})
public class JavaToolchainQueryService {
    private static final JavaToolchainSpecInternal.Key FALLBACK_TOOLCHAIN_KEY = new JavaToolchainSpecInternal.Key(){

        public String toString() {
            return "FallbackToolchainSpecKey";
        }
    };
    private final FileFactory fileFactory;
    private final JvmMetadataDetector detector;
    private final JavaToolchainProvisioningService installService;
    private final ConcurrentMap<ToolchainLookupKey, Object> matchingToolchains;
    private final JavaToolchainSpec fallbackToolchainSpec;
    private final File currentJavaHome;
    private final JavaInstallationRegistry registry;

    @Inject
    public JavaToolchainQueryService(JvmMetadataDetector detector, FileFactory fileFactory, JavaToolchainProvisioningService provisioningService, JavaInstallationRegistry registry, CurrentJvmToolchainSpec fallbackToolchainSpec) {
        this(detector, fileFactory, provisioningService, registry, fallbackToolchainSpec, Jvm.current().getJavaHome());
    }

    @VisibleForTesting
    JavaToolchainQueryService(JvmMetadataDetector detector, FileFactory fileFactory, JavaToolchainProvisioningService provisioningService, JavaInstallationRegistry registry, JavaToolchainSpec fallbackToolchainSpec, File currentJavaHome) {
        this.detector = detector;
        this.fileFactory = fileFactory;
        this.installService = provisioningService;
        this.matchingToolchains = new ConcurrentHashMap<ToolchainLookupKey, Object>();
        this.fallbackToolchainSpec = fallbackToolchainSpec;
        this.currentJavaHome = currentJavaHome;
        this.registry = registry;
    }

    public ProviderInternal<JavaToolchain> findMatchingToolchain(JavaToolchainSpec filter) {
        return this.findMatchingToolchain(filter, Collections.emptySet());
    }

    public ProviderInternal<JavaToolchain> findMatchingToolchain(JavaToolchainSpec filter, Set<JavaInstallationCapability> requiredCapabilities) {
        JavaToolchainSpecInternal filterInternal = (JavaToolchainSpecInternal)Objects.requireNonNull(filter);
        return new DefaultProvider(() -> this.resolveToolchain(filterInternal, requiredCapabilities));
    }

    private JavaToolchain resolveToolchain(JavaToolchainSpecInternal requestedSpec, Set<JavaInstallationCapability> requiredCapabilities) throws Exception {
        JavaToolchainSpec actualSpec;
        requestedSpec.finalizeProperties();
        if (!requestedSpec.isValid()) {
            throw ((DocumentedFailure.Builder)DocumentedFailure.builder().withSummary("Using toolchain specifications without setting a language version is not supported.").withAdvice("Consider configuring the language version.").withUpgradeGuideSection(7, "invalid_toolchain_specification_deprecation")).build();
        }
        boolean useFallback = !requestedSpec.isConfigured();
        JavaToolchainSpecInternal.Key actualSpecKey = useFallback ? FALLBACK_TOOLCHAIN_KEY : requestedSpec.toKey();
        ToolchainLookupKey actualKey = new ToolchainLookupKey(actualSpecKey, requiredCapabilities);
        Object resolutionResult = this.matchingToolchains.computeIfAbsent(actualKey, arg_0 -> this.lambda$resolveToolchain$1(actualSpec = useFallback ? this.fallbackToolchainSpec : requestedSpec, requiredCapabilities, useFallback, arg_0));
        if (resolutionResult instanceof Exception) {
            throw (Exception)resolutionResult;
        }
        return (JavaToolchain)resolutionResult;
    }

    private Set<JavaInstallationCapability> transformCapabilities(JavaToolchainSpec actualSpec, Set<JavaInstallationCapability> requiredCapabilities) {
        if (((Boolean)actualSpec.getNativeImageCapable().getOrElse((Object)false)).booleanValue()) {
            ImmutableSet.Builder capabilityBuilder = new ImmutableSet.Builder();
            capabilityBuilder.addAll(requiredCapabilities);
            capabilityBuilder.add((Object)JavaInstallationCapability.NATIVE_IMAGE);
            return capabilityBuilder.build();
        }
        return requiredCapabilities;
    }

    private JavaToolchain query(JavaToolchainSpec spec, Set<JavaInstallationCapability> requiredCapabilities, boolean isFallback) {
        if (spec instanceof CurrentJvmToolchainSpec) {
            return this.asToolchainOrThrow(InstallationLocation.autoDetected((File)this.currentJavaHome, (String)"current JVM"), spec, requiredCapabilities, isFallback);
        }
        if (spec instanceof SpecificInstallationToolchainSpec) {
            return this.asToolchainOrThrow(InstallationLocation.userDefined((File)((SpecificInstallationToolchainSpec)spec).getJavaHome(), (String)"specific installation"), spec, requiredCapabilities, false);
        }
        return this.findInstalledToolchain(spec, requiredCapabilities).orElseGet(() -> this.downloadToolchain(spec, requiredCapabilities));
    }

    private Optional<JavaToolchain> findInstalledToolchain(JavaToolchainSpec spec, Set<JavaInstallationCapability> requiredCapabilities) {
        JvmInstallationMetadataMatcher matcher = new JvmInstallationMetadataMatcher(spec, requiredCapabilities);
        return this.registry.toolchains().stream().filter(result -> result.metadata.isValidInstallation()).filter(result -> matcher.test(result.metadata)).min(Comparator.comparing(result -> result.metadata, new JvmInstallationMetadataComparator(this.currentJavaHome))).map(result -> {
            this.warnIfAutoProvisionedToolchainUsedWithoutRepositoryDefinitions((JvmToolchainMetadata)result);
            return new JavaToolchain(result.metadata, this.fileFactory, new JavaToolchainInput(spec), false);
        });
    }

    private void warnIfAutoProvisionedToolchainUsedWithoutRepositoryDefinitions(JvmToolchainMetadata candidate) {
        InstallationLocation javaHome = candidate.location;
        boolean autoDetectedToolchain = javaHome.isAutoProvisioned();
        if (autoDetectedToolchain && this.installService.isAutoDownloadEnabled() && !this.installService.hasConfiguredToolchainRepositories()) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)String.format("Using toolchain '%s' installed via auto-provisioning without toolchain repositories.", candidate.metadata.getDisplayName())).withAdvice("Add toolchain repositories to this build.")).withContext("Builds may fail when this toolchain is not available in other environments.")).willBecomeAnErrorInGradle10().withUserManual("toolchains", "sub:download_repositories")).nagUser();
        }
    }

    private JavaToolchain downloadToolchain(JavaToolchainSpec spec, Set<JavaInstallationCapability> requiredCapabilities) {
        File installation = this.installService.tryInstall(spec);
        InstallationLocation downloadedInstallation = InstallationLocation.autoProvisioned((File)installation, (String)"provisioned toolchain");
        JavaToolchain downloadedToolchain = this.asToolchainOrThrow(downloadedInstallation, spec, requiredCapabilities, false);
        this.registry.addInstallation(downloadedInstallation);
        return downloadedToolchain;
    }

    private JavaToolchain asToolchainOrThrow(InstallationLocation javaHome, JavaToolchainSpec spec, Set<JavaInstallationCapability> requiredCapabilities, boolean isFallback) {
        JvmInstallationMetadata metadata = this.detector.getMetadata(javaHome);
        if (!metadata.isValidInstallation()) {
            throw new GradleException("Toolchain installation '" + javaHome.getLocation() + "' could not be probed: " + metadata.getErrorMessage(), metadata.getErrorCause());
        }
        if (!metadata.getCapabilities().containsAll(requiredCapabilities)) {
            throw new GradleException("Toolchain installation '" + javaHome.getLocation() + "' does not provide the required capabilities: " + requiredCapabilities);
        }
        return new JavaToolchain(metadata, this.fileFactory, new JavaToolchainInput(spec), isFallback);
    }

    private /* synthetic */ Object lambda$resolveToolchain$1(JavaToolchainSpec actualSpec, Set requiredCapabilities, boolean useFallback, ToolchainLookupKey key) {
        try {
            return this.query(actualSpec, this.transformCapabilities(actualSpec, requiredCapabilities), useFallback);
        }
        catch (Exception e) {
            return e;
        }
    }

    private static final class ToolchainLookupKey {
        private final JavaToolchainSpecInternal.Key specKey;
        private final Set<JavaInstallationCapability> requiredCapabilities;

        private ToolchainLookupKey(JavaToolchainSpecInternal.Key specKey, Set<JavaInstallationCapability> requiredCapabilities) {
            this.specKey = specKey;
            this.requiredCapabilities = Sets.immutableEnumSet(requiredCapabilities);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToolchainLookupKey that = (ToolchainLookupKey)o;
            return Objects.equals(this.specKey, that.specKey) && Objects.equals(this.requiredCapabilities, that.requiredCapabilities);
        }

        public int hashCode() {
            return Objects.hash(this.specKey, this.requiredCapabilities);
        }

        public String toString() {
            return "ToolchainLookupKey{specKey=" + this.specKey + ", requiredCapabilities=" + this.requiredCapabilities + '}';
        }
    }
}

