/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jsampler.CC;
import org.jsampler.DefaultLSConsoleModel;
import org.jsampler.HF;
import org.jsampler.JSPrefs;
import org.jsampler.LSConsoleModel;
import org.jsampler.LscpUtils;
import org.jsampler.OrchestraInstrument;
import org.jsampler.event.LSConsoleEvent;
import org.jsampler.event.LSConsoleListener;
import org.jsampler.view.std.LSConsoleTextPane;

public class JSLSConsolePane
extends JPanel {
    private AutocompleteMode autocompleteMode = AutocompleteMode.AUTOCOMPLETE;
    private Window owner;
    private final LSConsoleTextPane console = new LSConsoleTextPane();
    private final JPanel inputPane = new JPanel();
    private final JLabel lInput = new JLabel();
    private final JTextField tfSearch = new JTextField();
    private final CmdLineTextField tfInput = new CmdLineTextField();
    private AutoCompleteWindow autoCompleteWindow;
    private final LSConsoleModel model = new DefaultLSConsoleModel();
    private boolean processingSearch = false;
    protected JPanel mainPane = new JPanel();
    private final SearchHandler searchHandler = new SearchHandler();
    private final Handler eventHandler = new Handler();

    public JSLSConsolePane(Window window) {
        this.setOwner(window);
        this.setLayout(new BorderLayout());
        int n = this.preferences().getIntProperty("LSConsole.historySize");
        this.model.setCommandHistorySize(n);
        this.loadConsoleHistory();
        this.mainPane.setOpaque(false);
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 1));
        n = this.preferences().getIntProperty("LSConsole.backgroundColor");
        this.setBackgroundColor(new Color(n));
        n = this.preferences().getIntProperty("LSConsole.textColor");
        this.setTextColor(new Color(n));
        this.mainPane.add(new JScrollPane(this.console));
        this.inputPane.setLayout(new BoxLayout(this.inputPane, 0));
        this.inputPane.setBorder(this.tfInput.getBorder());
        this.tfInput.setBorder(BorderFactory.createEmptyBorder());
        this.tfSearch.setBorder(BorderFactory.createEmptyBorder());
        this.lInput.setOpaque(false);
        this.lInput.setVisible(false);
        this.inputPane.add(this.lInput);
        Dimension dimension = new Dimension(Short.MAX_VALUE, this.tfSearch.getPreferredSize().height);
        this.tfSearch.setMaximumSize(dimension);
        this.tfSearch.setVisible(false);
        this.tfSearch.setFocusTraversalKeysEnabled(false);
        this.inputPane.add(this.tfSearch);
        dimension = new Dimension(Short.MAX_VALUE, this.tfInput.getPreferredSize().height);
        this.tfInput.setMaximumSize(dimension);
        this.tfInput.setFocusTraversalKeysEnabled(false);
        this.inputPane.add(this.tfInput);
        this.mainPane.add(this.inputPane);
        this.add(this.mainPane);
        this.tfInput.addActionListener(this.getHandler());
        this.tfInput.getDocument().addDocumentListener(this.getHandler());
        this.getModel().addLSConsoleListener(this.getHandler());
        this.tfSearch.addActionListener(new Actions("applySearch"));
        this.installKeyboardListeners();
    }

    private JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private void installKeyboardListeners() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        this.tfInput.getInputMap(0).put(keyStroke, "autocomplete");
        this.tfInput.getActionMap().put("autocomplete", new Actions("autocomplete"));
        keyStroke = KeyStroke.getKeyStroke(82, 2);
        this.tfInput.getInputMap(0).put(keyStroke, "historySearch");
        this.tfInput.getActionMap().put("historySearch", new Actions("historySearch"));
        keyStroke = KeyStroke.getKeyStroke(70, 2);
        this.tfInput.getInputMap(0).put(keyStroke, "cmdListSearch");
        this.tfInput.getActionMap().put("cmdListSearch", new Actions("cmdListSearch"));
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.tfInput.getInputMap(0).put(keyStroke, "moveUp");
        this.tfInput.getActionMap().put("moveUp", new Actions("moveUp"));
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        this.tfInput.getInputMap(0).put(keyStroke, "moveDown");
        this.tfInput.getActionMap().put("moveDown", new Actions("moveDown"));
        keyStroke = KeyStroke.getKeyStroke(36, 0);
        this.tfInput.getInputMap(0).put(keyStroke, "moveHome");
        this.tfInput.getActionMap().put("moveHome", new Actions("moveHome"));
        keyStroke = KeyStroke.getKeyStroke(35, 0);
        this.tfInput.getInputMap(0).put(keyStroke, "moveEnd");
        this.tfInput.getActionMap().put("moveEnd", new Actions("moveEnd"));
        keyStroke = KeyStroke.getKeyStroke(76, 2);
        this.tfInput.getInputMap(0).put(keyStroke, "clearConsole");
        this.tfInput.getActionMap().put("clearConsole", new Actions("clearConsole"));
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.tfInput.getInputMap(1).put(keyStroke, "cancelSelection");
        this.tfInput.getActionMap().put("cancelSelection", new Actions("cancelSelection"));
        keyStroke = KeyStroke.getKeyStroke(68, 2);
        this.tfInput.getInputMap(0).put(keyStroke, "quitSession");
        this.tfInput.getActionMap().put("quitSession", new Actions("quitSession"));
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.tfSearch.getInputMap(0).put(keyStroke, "moveUp");
        this.tfSearch.getActionMap().put("moveUp", new Actions("moveUp"));
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        this.tfSearch.getInputMap(0).put(keyStroke, "moveDown");
        this.tfSearch.getActionMap().put("moveDown", new Actions("moveDown"));
        keyStroke = KeyStroke.getKeyStroke(36, 0);
        this.tfSearch.getInputMap(0).put(keyStroke, "moveHome");
        this.tfSearch.getActionMap().put("moveHome", new Actions("moveHome"));
        keyStroke = KeyStroke.getKeyStroke(35, 0);
        this.tfSearch.getInputMap(0).put(keyStroke, "moveEnd");
        this.tfSearch.getActionMap().put("moveEnd", new Actions("moveEnd"));
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.tfSearch.getInputMap(1).put(keyStroke, "cancelSearch");
        this.tfSearch.getActionMap().put("cancelSearch", new Actions("cancelSearch"));
    }

    public void disconnect() {
        if (this.model != null) {
            ((DefaultLSConsoleModel)this.model).disconnect();
        }
    }

    private void loadConsoleHistory() {
        String string = CC.getJSamplerHome();
        if (string == null) {
            return;
        }
        File file = new File(string + File.separator + "console_history");
        if (!file.isFile()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            string = bufferedReader.readLine();
            while (string != null) {
                this.getModel().addToCommandHistory(string);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
    }

    protected JTextPane getLSConsoleTextPane() {
        return this.console;
    }

    public void saveConsoleHistory() {
        if (CC.getJSamplerHome() == null) {
            return;
        }
        try {
            String string = CC.getJSamplerHome() + File.separator + "console_history";
            FileOutputStream fileOutputStream = new FileOutputStream(string, false);
            for (String string2 : this.getModel().getCommandHistory()) {
                fileOutputStream.write(string2.getBytes("US-ASCII"));
                fileOutputStream.write(10);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
    }

    public static void clearConsoleHistory() {
        String string = CC.getJSamplerHome();
        if (string == null) {
            return;
        }
        File file = new File(string + File.separator + "console_history");
        if (file.isFile()) {
            file.delete();
        }
    }

    public LSConsoleModel getModel() {
        return this.model;
    }

    public void setTextColor(Color color) {
        this.console.setTextColor(color);
        this.lInput.setForeground(color);
        this.tfInput.setForeground(color);
        this.tfSearch.setForeground(color);
        this.autoCompleteWindow.setTextColor(color);
    }

    public Color getTextColor() {
        return this.console.getTextColor();
    }

    public void setBackgroundColor(Color color) {
        this.console.setBackground(color);
        this.lInput.setBackground(color);
        this.inputPane.setBackground(color);
        this.tfInput.setBackground(color);
        this.tfSearch.setBackground(color);
        this.autoCompleteWindow.setBackgroundColor(color);
    }

    public Color getBackgroundColor() {
        return this.console.getBackground();
    }

    public void setNotifyColor(Color color) {
        this.console.setNotifyColor(color);
    }

    public void setWarningColor(Color color) {
        this.console.setWarningColor(color);
    }

    public void setErrorColor(Color color) {
        this.console.setErrorColor(color);
    }

    public void setOwner(Window window) {
        if (this.autoCompleteWindow != null && this.autoCompleteWindow.isVisible()) {
            this.autoCompleteWindow.setVisible(false);
        }
        this.autoCompleteWindow = new AutoCompleteWindow(window);
        if (this.getOwner() != null) {
            this.getOwner().removeWindowListener(this.getHandler());
        }
        window.addWindowListener(this.getHandler());
        this.owner = window;
    }

    public Window getOwner() {
        return this.owner;
    }

    public void hideAutoCompleteWindow() {
        this.autoCompleteWindow.setVisible(false);
    }

    protected void quitSession() {
        this.getModel().clearSessionHistory();
        this.console.setText("");
    }

    private SearchHandler getSearchHandler() {
        return this.searchHandler;
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private void commandChanged(String string) {
        if (!this.tfInput.getText().equals(this.getModel().getCommandLineText())) {
            this.tfInput.setText(this.getModel().getCommandLineText());
        }
        if (LscpUtils.spellCheck(this.tfInput.getText())) {
            this.tfInput.setForeground(this.console.getTextColor());
        } else {
            this.tfInput.setForeground(this.console.getErrorColor());
            if (this.autoCompleteWindow.isVisible()) {
                this.autoCompleteWindow.setVisible(false);
            }
        }
        if (this.autoCompleteWindow.isVisible()) {
            this.processAutoComplete(string);
        }
    }

    private boolean isProcessingSearch() {
        return this.processingSearch;
    }

    private void setProcessingSearch(boolean bl) {
        this.processingSearch = bl;
    }

    private void processAutoComplete() {
        this.processAutoComplete(null);
    }

    private void processAutoComplete(String string) {
        String[] stringArray;
        String string2 = this.getModel().getCommandLineText();
        switch (this.autocompleteMode) {
            case AUTOCOMPLETE: {
                break;
            }
            case HISTORY_SEARCH: 
            case CMD_LIST_SEARCH: {
                if (!this.autoCompleteWindow.isVisible()) break;
                return;
            }
        }
        this.autocompleteMode = AutocompleteMode.AUTOCOMPLETE;
        try {
            stringArray = LscpUtils.getCompletionPossibilities(string2);
        }
        catch (IllegalStateException illegalStateException) {
            this.autoCompleteWindow.setVisible(false);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (stringArray.length == 0) {
            this.autoCompleteWindow.setVisible(false);
            return;
        }
        if (stringArray.length == 1) {
            if (string != null && string.startsWith(string2)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSLSConsolePane.this.tfInput.setText(stringArray[0]);
                }
            });
            return;
        }
        this.autoCompleteWindow.setCommandList(stringArray);
        this.autoCompleteWindow.setVisible(true);
    }

    private void startHistorySearch() {
        this.autocompleteMode = AutocompleteMode.HISTORY_SEARCH;
        this.lInput.setText("History Search: ");
        this.startSearch();
    }

    private void startCmdListSearch() {
        this.autocompleteMode = AutocompleteMode.CMD_LIST_SEARCH;
        this.lInput.setText("Command List Search: ");
        this.startSearch();
    }

    private void startSearch() {
        if (!this.isProcessingSearch()) {
            this.tfSearch.getDocument().addDocumentListener(this.getSearchHandler());
        }
        this.setProcessingSearch(true);
        this.lInput.setVisible(true);
        this.tfInput.setVisible(false);
        this.tfSearch.setText(this.getModel().getCommandLineText());
        this.tfSearch.setVisible(true);
        this.tfSearch.requestFocusInWindow();
        this.revalidate();
        this.repaint();
        this.processSearch();
    }

    private void processSearch() {
        String[] stringArray = null;
        switch (this.autocompleteMode) {
            case HISTORY_SEARCH: {
                stringArray = this.getModel().searchCommandHistory(this.tfSearch.getText());
                break;
            }
            case CMD_LIST_SEARCH: {
                stringArray = this.getModel().searchCommandList(this.tfSearch.getText());
            }
        }
        this.autoCompleteWindow.setCommandList(stringArray);
        this.autoCompleteWindow.setVisible(stringArray.length > 0);
    }

    private void stopSearch(boolean bl) {
        this.setProcessingSearch(false);
        this.tfSearch.getDocument().removeDocumentListener(this.getSearchHandler());
        this.lInput.setVisible(false);
        this.lInput.setText("");
        this.tfSearch.setVisible(false);
        this.tfInput.setVisible(true);
        this.tfInput.requestFocusInWindow();
        this.revalidate();
        this.repaint();
        if (bl) {
            this.autoCompleteWindow.setVisible(false);
            return;
        }
        if (this.autoCompleteWindow.isVisible()) {
            this.autoCompleteWindow.applySelection();
        } else {
            this.getModel().setCommandLineText(this.tfSearch.getText());
        }
    }

    private class AutoCompleteWindow
    extends JWindow {
        private int MAX_HEIGHT;
        private JList list;
        private JScrollPane scrollPane;
        private final Handler eventHandler;

        AutoCompleteWindow(Window window) {
            super(window);
            this.MAX_HEIGHT = 140;
            this.list = new JList();
            this.eventHandler = new Handler();
            window.addComponentListener(this.getHandler());
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (AutoCompleteWindow.this.list.getSelectedIndex() != -1) {
                        AutoCompleteWindow.this.applySelection();
                    }
                }
            });
            this.list.setSelectionMode(0);
            this.scrollPane = new JScrollPane(this.list);
            this.scrollPane.setPreferredSize(new Dimension(this.scrollPane.getPreferredSize().width, this.MAX_HEIGHT));
            this.add(this.scrollPane);
            int n = 1;
            this.getRootPane().getInputMap(n).put(KeyStroke.getKeyStroke(10, 0), "applySelection");
            this.getRootPane().getActionMap().put("applySelection", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutoCompleteWindow.this.applySelection();
                }
            });
        }

        public void setCommandList(String[] stringArray) {
            int n;
            this.list.setListData(stringArray);
            if (stringArray.length > 0) {
                this.list.setSelectedIndex(0);
            }
            if ((n = this.list.getPreferredSize().height + 6) > this.MAX_HEIGHT) {
                n = this.MAX_HEIGHT;
            }
            if (n == this.scrollPane.getSize().height) {
                return;
            }
            this.scrollPane.setPreferredSize(new Dimension(this.scrollPane.getPreferredSize().width, n));
            this.scrollPane.setMaximumSize(new Dimension(this.scrollPane.getPreferredSize().width, n));
            this.setVisible(false);
            this.setSize(this.getSize().width, n);
            this.setVisible(true);
        }

        @Override
        public void setVisible(boolean bl) {
            if (bl) {
                this.updateLocation0();
            }
            super.setVisible(bl);
        }

        public void selectNextItem() {
            int n = this.list.getModel().getSize();
            if (n == 0) {
                return;
            }
            int n2 = this.list.getSelectedIndex();
            if (n2 == -1 || n2 == n - 1) {
                this.list.setSelectedIndex(0);
            } else {
                this.list.setSelectedIndex(n2 + 1);
            }
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }

        public void selectPreviousItem() {
            int n = this.list.getModel().getSize();
            if (n == 0) {
                return;
            }
            int n2 = this.list.getSelectedIndex();
            if (n2 == -1 || n2 == 0) {
                this.list.setSelectedIndex(n - 1);
            } else {
                this.list.setSelectedIndex(n2 - 1);
            }
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }

        public void selectFirstItem() {
            int n = this.list.getModel().getSize();
            if (n == 0) {
                return;
            }
            this.list.setSelectedIndex(0);
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }

        public void selectLastItem() {
            int n = this.list.getModel().getSize();
            if (n == 0) {
                return;
            }
            this.list.setSelectedIndex(n - 1);
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }

        public void setTextColor(Color color) {
            this.list.setForeground(color);
        }

        public void setBackgroundColor(Color color) {
            this.list.setBackground(color);
        }

        private void updateLocation() {
            if (!this.isVisible()) {
                return;
            }
            this.updateLocation0();
        }

        private void updateLocation0() {
            Dimension dimension = new Dimension(((JSLSConsolePane)JSLSConsolePane.this).inputPane.getSize().width - 6, this.getSize().height);
            this.setPreferredSize(dimension);
            Point point = JSLSConsolePane.this.inputPane.getLocationOnScreen();
            this.pack();
            this.setLocation(point.x + 3, point.y - this.getSize().height);
        }

        private void applySelection() {
            Object e = this.list.getSelectedValue();
            if (e != null) {
                JSLSConsolePane.this.tfInput.setText(e.toString());
            }
            this.setVisible(false);
        }

        private Handler getHandler() {
            return this.eventHandler;
        }

        private class Handler
        extends ComponentAdapter {
            private Handler() {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                AutoCompleteWindow.this.updateLocation();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AutoCompleteWindow.this.updateLocation();
            }
        }
    }

    protected class Actions
    extends AbstractAction {
        public static final String AUTOCOMPLETE = "autocomplete";
        public static final String HISTORY_SEARCH = "historySearch";
        public static final String CMD_LIST_SEARCH = "cmdListSearch";
        public static final String CANCEL_SEARCH = "cancelSearch";
        public static final String APPLY_SEARCH = "applySearch";
        public static final String MOVE_UP = "moveUp";
        public static final String MOVE_DOWN = "moveDown";
        public static final String MOVE_HOME = "moveHome";
        public static final String MOVE_END = "moveEnd";
        public static final String CANCEL_SELECTION = "cancelSelection";
        public static final String CLEAR_CONSOLE = "clearConsole";
        public static final String CLEAR_SESSION_HISTORY = "clearSessionHistory";
        public static final String CLEAR_COMMAND_HISTORY = "clearCommandHistory";
        public static final String QUIT_SESSION = "quitSession";

        public Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getValue("Name").toString();
            if (string == AUTOCOMPLETE) {
                JSLSConsolePane.this.processAutoComplete();
            } else if (string == HISTORY_SEARCH) {
                JSLSConsolePane.this.startHistorySearch();
            } else if (string == CMD_LIST_SEARCH) {
                JSLSConsolePane.this.startCmdListSearch();
            } else if (string == CANCEL_SEARCH) {
                JSLSConsolePane.this.stopSearch(true);
            } else if (string == APPLY_SEARCH) {
                JSLSConsolePane.this.stopSearch(false);
            } else if (string == MOVE_UP) {
                if (JSLSConsolePane.this.autoCompleteWindow.isVisible()) {
                    JSLSConsolePane.this.autoCompleteWindow.selectPreviousItem();
                    return;
                }
                JSLSConsolePane.this.getModel().browseCommandHistoryUp();
            } else if (string == MOVE_DOWN) {
                if (JSLSConsolePane.this.autoCompleteWindow.isVisible()) {
                    JSLSConsolePane.this.autoCompleteWindow.selectNextItem();
                    return;
                }
                JSLSConsolePane.this.getModel().browseCommandHistoryDown();
            } else if (string == MOVE_HOME) {
                if (JSLSConsolePane.this.autoCompleteWindow.isVisible()) {
                    JSLSConsolePane.this.autoCompleteWindow.selectFirstItem();
                    return;
                }
                JTextField jTextField = JSLSConsolePane.this.tfInput.isVisible() ? JSLSConsolePane.this.tfInput : JSLSConsolePane.this.tfSearch;
                jTextField.setCaretPosition(0);
            } else if (string == MOVE_END) {
                if (JSLSConsolePane.this.autoCompleteWindow.isVisible()) {
                    JSLSConsolePane.this.autoCompleteWindow.selectLastItem();
                    return;
                }
                JTextField jTextField = JSLSConsolePane.this.tfInput.isVisible() ? JSLSConsolePane.this.tfInput : JSLSConsolePane.this.tfSearch;
                jTextField.setCaretPosition(jTextField.getText().length());
            } else if (string == CANCEL_SELECTION) {
                JSLSConsolePane.this.autoCompleteWindow.setVisible(false);
            } else if (string == CLEAR_CONSOLE) {
                JSLSConsolePane.this.console.setText("");
            } else if (string == CLEAR_SESSION_HISTORY) {
                JSLSConsolePane.this.getModel().clearSessionHistory();
            } else if (string == CLEAR_COMMAND_HISTORY) {
                JSLSConsolePane.this.getModel().clearCommandHistory();
            } else if (string == QUIT_SESSION) {
                JSLSConsolePane.this.quitSession();
            }
        }
    }

    private class Handler
    extends WindowAdapter
    implements ActionListener,
    DocumentListener,
    LSConsoleListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JSLSConsolePane.this.autoCompleteWindow.isVisible()) {
                JSLSConsolePane.this.autoCompleteWindow.applySelection();
            } else {
                JSLSConsolePane.this.getModel().execCommand();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSLSConsolePane.this.getModel().setCommandLineText(JSLSConsolePane.this.tfInput.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSLSConsolePane.this.getModel().setCommandLineText(JSLSConsolePane.this.tfInput.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSLSConsolePane.this.getModel().setCommandLineText(JSLSConsolePane.this.tfInput.getText());
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (JSLSConsolePane.this.autocompleteMode == AutocompleteMode.AUTOCOMPLETE) {
                JSLSConsolePane.this.tfInput.requestFocusInWindow();
            } else {
                JSLSConsolePane.this.tfSearch.requestFocusInWindow();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            JSLSConsolePane.this.autoCompleteWindow.setVisible(false);
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            JSLSConsolePane.this.autoCompleteWindow.setVisible(false);
        }

        @Override
        public void commandLineTextChanged(LSConsoleEvent lSConsoleEvent) {
            JSLSConsolePane.this.commandChanged(lSConsoleEvent.getPreviousCommandLineText());
        }

        @Override
        public void commandExecuted(LSConsoleEvent lSConsoleEvent) {
            JSLSConsolePane.this.console.addCommand(JSLSConsolePane.this.getModel().getLastExecutedCommand());
        }

        @Override
        public void responseReceived(LSConsoleEvent lSConsoleEvent) {
            JSLSConsolePane.this.console.addCommandResponse(lSConsoleEvent.getResponse());
        }
    }

    private class SearchHandler
    implements DocumentListener {
        private SearchHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSLSConsolePane.this.processSearch();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSLSConsolePane.this.processSearch();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSLSConsolePane.this.processSearch();
        }
    }

    public class CmdLineTextField
    extends JTextField {
        CmdLineTextField() {
            this.setTransferHandler(new TransferHandler("instrumentLoad"));
        }

        public String getInstrumentLoad() {
            return this.getSelectedText();
        }

        public void setInstrumentLoad(String string) {
            if (string == null) {
                return;
            }
            if (!OrchestraInstrument.isDnDString(string)) {
                this.replaceSelection(string);
                return;
            }
            String[] stringArray = string.split("\n");
            if (stringArray.length < 6) {
                return;
            }
            String string2 = "LOAD INSTRUMENT NON_MODAL '" + stringArray[4] + "' " + stringArray[5] + " ";
            JSLSConsolePane.this.getModel().setCommandLineText(string2);
            this.requestFocus();
        }
    }

    private static enum AutocompleteMode {
        AUTOCOMPLETE,
        HISTORY_SEARCH,
        CMD_LIST_SEARCH;

    }
}

