/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.function.Consumer;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.server.common.MetadataVersion;

public final class ImageWriterOptions {
    private final MetadataVersion metadataVersion;
    private final Consumer<UnwritableMetadataException> lossHandler;
    private final boolean isEligibleLeaderReplicasEnabled;

    private ImageWriterOptions(MetadataVersion metadataVersion, Consumer<UnwritableMetadataException> lossHandler, boolean isEligibleLeaderReplicasEnabled) {
        this.metadataVersion = metadataVersion;
        this.lossHandler = lossHandler;
        this.isEligibleLeaderReplicasEnabled = isEligibleLeaderReplicasEnabled;
    }

    public MetadataVersion metadataVersion() {
        return this.metadataVersion;
    }

    public boolean isEligibleLeaderReplicasEnabled() {
        return this.isEligibleLeaderReplicasEnabled;
    }

    public void handleLoss(String loss) {
        this.lossHandler.accept(new UnwritableMetadataException(this.metadataVersion, loss));
    }

    public static class Builder {
        private MetadataVersion metadataVersion;
        private Consumer<UnwritableMetadataException> lossHandler = e -> {
            throw e;
        };
        private boolean isEligibleLeaderReplicasEnabled = false;

        public Builder(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
        }

        public Builder(MetadataImage image) {
            this.metadataVersion = image.features().metadataVersionOrThrow();
            this.isEligibleLeaderReplicasEnabled = image.features().isElrEnabled();
        }

        public Builder setMetadataVersion(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
            return this;
        }

        public Builder setEligibleLeaderReplicasEnabled(boolean isEligibleLeaderReplicasEnabled) {
            this.isEligibleLeaderReplicasEnabled = isEligibleLeaderReplicasEnabled;
            return this;
        }

        public MetadataVersion metadataVersion() {
            return this.metadataVersion;
        }

        public boolean isEligibleLeaderReplicasEnabled() {
            return this.isEligibleLeaderReplicasEnabled;
        }

        public Builder setLossHandler(Consumer<UnwritableMetadataException> lossHandler) {
            this.lossHandler = lossHandler;
            return this;
        }

        public ImageWriterOptions build() {
            return new ImageWriterOptions(this.metadataVersion, this.lossHandler, this.isEligibleLeaderReplicasEnabled);
        }
    }
}

