/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.ChangedDeserializer;
import org.apache.kafka.streams.kstream.internals.ChangedSerializer;
import org.apache.kafka.streams.kstream.internals.graph.BaseRepartitionNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopicProperties;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class GroupedTableOperationRepartitionNode<K, V>
extends BaseRepartitionNode<K, V> {
    private GroupedTableOperationRepartitionNode(String nodeName, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String sourceName, String repartitionTopic, ProcessorParameters<K, V, K, V> processorParameters) {
        super(nodeName, sourceName, processorParameters, keySerde, valueSerde, sinkName, repartitionTopic, null, InternalTopicProperties.empty());
    }

    @Override
    Serializer<V> valueSerializer() {
        Serializer valueSerializer = super.valueSerializer();
        return this.unsafeCastChangedToValueSerializer(valueSerializer);
    }

    private Serializer<V> unsafeCastChangedToValueSerializer(Serializer<V> valueSerializer) {
        return new ChangedSerializer<V>(valueSerializer);
    }

    @Override
    Deserializer<V> valueDeserializer() {
        Deserializer valueDeserializer = super.valueDeserializer();
        return this.unsafeCastChangedToValueDeserializer(valueDeserializer);
    }

    private Deserializer<V> unsafeCastChangedToValueDeserializer(Deserializer<? extends V> valueDeserializer) {
        return new ChangedDeserializer<V>(valueDeserializer);
    }

    @Override
    public String toString() {
        return "GroupedTableOperationRepartitionNode{} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        topologyBuilder.addInternalTopic(this.repartitionTopic, this.internalTopicProperties);
        topologyBuilder.addSink(this.sinkName, this.repartitionTopic, this.keySerializer(), this.valueSerializer(), null, this.parentNodeNames());
        topologyBuilder.addSource(null, this.sourceName, (TimestampExtractor)new FailOnInvalidTimestamp(), this.keyDeserializer(), this.valueDeserializer(), this.repartitionTopic);
    }

    public static <K, V> GroupedTableOperationRepartitionNodeBuilder<K, V> groupedTableOperationNodeBuilder() {
        return new GroupedTableOperationRepartitionNodeBuilder();
    }

    public static final class GroupedTableOperationRepartitionNodeBuilder<K, V>
    extends BaseRepartitionNode.BaseRepartitionNodeBuilder<K, V, GroupedTableOperationRepartitionNode<K, V>> {
        @Override
        public GroupedTableOperationRepartitionNode<K, V> build() {
            return new GroupedTableOperationRepartitionNode(this.nodeName, this.keySerde, this.valueSerde, this.sinkName, this.sourceName, this.repartitionTopic, this.processorParameters);
        }
    }
}

