/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rule.MatchLabel;
import org.opensearch.rule.attribute_extractor.AttributeExtractor;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.storage.AttributeValueStore;

public final class PrincipalAttribute
extends Enum<PrincipalAttribute>
implements Attribute {
    public static final /* enum */ PrincipalAttribute PRINCIPAL = new PrincipalAttribute("principal");
    public static final String USERNAME = "username";
    public static final String ROLE = "role";
    private static final Map<String, Float> WEIGHTED_SUBFIELDS;
    private final String name;
    private static final /* synthetic */ PrincipalAttribute[] $VALUES;

    public static PrincipalAttribute[] values() {
        return (PrincipalAttribute[])$VALUES.clone();
    }

    public static PrincipalAttribute valueOf(String name) {
        return Enum.valueOf(PrincipalAttribute.class, name);
    }

    private PrincipalAttribute(String name) {
        this.name = name;
        this.validateAttribute();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Float> getWeightedSubfields() {
        return WEIGHTED_SUBFIELDS;
    }

    public Set<String> fromXContentParseAttributeValues(XContentParser parser) throws IOException {
        HashSet<String> resultSet = new HashSet<String>();
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "Expected START_OBJECT token for " + this.getName() + " attribute but got " + String.valueOf(parser.currentToken()));
        }
        Set<String> allowedSubfieldsName = WEIGHTED_SUBFIELDS.keySet();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String subFieldName = parser.currentName();
            parser.nextToken();
            if (!allowedSubfieldsName.contains(subFieldName)) {
                throw new XContentParseException(parser.getTokenLocation(), "Invalid field: " + subFieldName + ". Allowed fields are: " + String.join((CharSequence)", ", allowedSubfieldsName));
            }
            resultSet.addAll(super.fromXContentParseAttributeValues(parser).stream().map(s -> subFieldName + "|" + s).collect(Collectors.toSet()));
        }
        return resultSet;
    }

    public void toXContentWriteAttributeValues(XContentBuilder builder, Set<String> values) throws IOException {
        builder.startObject(this.getName());
        HashMap<String, Set> grouped = new HashMap<String, Set>();
        for (String string : values) {
            String[] parts = this.parsePrincipalValue(string);
            assert (parts.length == 2);
            grouped.computeIfAbsent(parts[0], k -> new HashSet()).add(parts[1]);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            builder.array((String)entry.getKey(), ((Set)entry.getValue()).toArray(new String[0]));
        }
        builder.endObject();
    }

    public List<MatchLabel<String>> findAttributeMatches(AttributeExtractor<String> attributeExtractor, AttributeValueStore<String, String> attributeValueStore) {
        HashMap<String, Float> scoreMap = new HashMap<String, Float>();
        for (String value : attributeExtractor.extract()) {
            Set matches = attributeValueStore.getExactMatch((Object)value);
            String subField = this.parsePrincipalValue(value)[0];
            assert (WEIGHTED_SUBFIELDS.containsKey(subField));
            for (String label : matches) {
                scoreMap.merge(label, WEIGHTED_SUBFIELDS.get(subField), Float::sum);
            }
        }
        return scoreMap.entrySet().stream().map(e -> new MatchLabel((Object)((String)e.getKey()), ((Float)e.getValue()).floatValue())).sorted((a, b) -> Float.compare(b.getMatchScore(), a.getMatchScore())).collect(Collectors.toList());
    }

    private String[] parsePrincipalValue(String principalValue) {
        return principalValue.split("\\|", 2);
    }

    private static /* synthetic */ PrincipalAttribute[] $values() {
        return new PrincipalAttribute[]{PRINCIPAL};
    }

    static {
        $VALUES = PrincipalAttribute.$values();
        WEIGHTED_SUBFIELDS = Map.of(USERNAME, Float.valueOf(1.0f), ROLE, Float.valueOf(0.09f));
    }
}

