/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.tls.TlsContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLConnection
implements BCSSLConnection {
    private static final AtomicLong CONNECTION_IDS = new AtomicLong(0L);
    protected final ProvTlsPeer tlsPeer;

    static long allocateConnectionID() {
        return CONNECTION_IDS.incrementAndGet();
    }

    ProvSSLConnection(ProvTlsPeer provTlsPeer) {
        this.tlsPeer = provTlsPeer;
    }

    public byte[] exportKeyingMaterial(String string, byte[] byArray, int n) {
        return this.getTlsContext().exportKeyingMaterial(string, byArray, n);
    }

    @Override
    public String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.getTlsContext().getSecurityParametersConnection());
    }

    @Override
    public byte[] getChannelBinding(String string) {
        if (string.equals("tls-exporter")) {
            return this.getTlsContext().exportChannelBinding(3);
        }
        if (string.equals("tls-server-end-point")) {
            return this.getTlsContext().exportChannelBinding(0);
        }
        if (string.equals("tls-unique")) {
            return this.getTlsContext().exportChannelBinding(1);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getID() {
        return this.tlsPeer.getID();
    }

    @Override
    public ProvSSLSession getSession() {
        return this.tlsPeer.getSession();
    }

    protected TlsContext getTlsContext() {
        return this.tlsPeer.getTlsContext();
    }
}

