/* libdmapsharing-4.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Dmap", gir_namespace = "Dmap", gir_version = "4.0", lower_case_cprefix = "dmap_")]
namespace Dmap {
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_av_connection_get_type ()")]
	public class AvConnection : Dmap.Connection {
		[CCode (has_construct_function = false)]
		public AvConnection (string name, string host, uint port, owned Dmap.Db db, owned Dmap.RecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_av_share_get_type ()")]
	public class AvShare : Dmap.Share {
		[CCode (has_construct_function = false)]
		public AvShare (string name, string? password, Dmap.Db db, Dmap.ContainerDb container_db, string? transcode_mimetype);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_connection_get_type ()")]
	public class Connection : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Connection ();
		public void authenticate_message (Soup.Session session, Soup.Message message, Soup.Auth auth, string password);
		public Soup.MessageHeaders get_headers (string uri);
		public unowned GLib.SList<Dmap.Playlist?> get_playlists ();
		[NoWrapper]
		public virtual Dmap.ContentCode get_protocol_version_cc ();
		[NoWrapper]
		public virtual string get_query_metadata ();
		public bool is_connected ();
		public void start ([CCode (scope = "async")] Dmap.ConnectionFunc callback);
		public void stop ([CCode (scope = "async")] Dmap.ConnectionFunc callback);
		[NoAccessorMethod]
		public GLib.Uri base_uri { owned get; set; }
		[NoAccessorMethod]
		public int database_id { get; set; }
		[NoAccessorMethod]
		public Dmap.Db db { owned get; construct; }
		[NoAccessorMethod]
		public double dmap_version { get; set; }
		[NoAccessorMethod]
		public Dmap.RecordFactory factory { owned get; construct; }
		[NoAccessorMethod]
		public string host { owned get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		[NoAccessorMethod]
		public string password { set; }
		[NoAccessorMethod]
		public uint port { get; construct; }
		[NoAccessorMethod]
		public int revision_number { get; set; }
		[NoAccessorMethod]
		public int session_id { get; set; }
		[NoAccessorMethod]
		public string username { owned get; construct; }
		public virtual signal void authenticate (string name, Soup.Session p0, Soup.Message p1, Soup.Auth p2, bool p3);
		public virtual signal void connected ();
		public virtual signal void connecting (ulong state, float progress);
		public virtual signal void disconnected ();
		public signal void error (void* object);
		public virtual signal void operation_done ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_control_connection_get_type ()")]
	public class ControlConnection : Dmap.Connection {
		[CCode (has_construct_function = false)]
		public ControlConnection (string name, string host, uint port, Dmap.Db db, Dmap.RecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_control_share_get_type ()")]
	public class ControlShare : Dmap.Share {
		[CCode (has_construct_function = false)]
		public ControlShare (string library_name, Dmap.ControlPlayer player, Dmap.Db db, Dmap.ContainerDb container_db);
		public void pair (string service_name, string passcode);
		public void player_updated ();
		public bool start_lookup () throws GLib.Error;
		public bool stop_lookup () throws GLib.Error;
		[NoAccessorMethod]
		public string library_name { owned get; set; }
		[NoAccessorMethod]
		public GLib.Object player { owned get; construct; }
		public virtual signal void add_guid (string guid);
		public virtual signal bool lookup_guid (string guid);
		public virtual signal void remote_found (string service_name, string remote_name);
		public virtual signal void remote_lost (string service_name);
		public virtual signal void remote_paired (string service_name, bool connected);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_image_connection_get_type ()")]
	public class ImageConnection : Dmap.Connection {
		[CCode (has_construct_function = false)]
		public ImageConnection (string name, string host, uint port, Dmap.Db db, Dmap.RecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_image_share_get_type ()")]
	public class ImageShare : Dmap.Share {
		[CCode (has_construct_function = false)]
		public ImageShare (string name, string? password, void* db, void* container_db, string? transcode_mimetype);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_mdns_browser_get_type ()")]
	public class MdnsBrowser : GLib.Object {
		[CCode (has_construct_function = false)]
		public MdnsBrowser (Dmap.MdnsServiceType type);
		public Dmap.MdnsServiceType get_service_type ();
		public unowned GLib.SList<Dmap.MdnsService> get_services ();
		public bool start () throws GLib.Error;
		public bool stop () throws GLib.Error;
		public virtual signal void service_added (Dmap.MdnsService service);
		public virtual signal void service_removed (string service);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_mdns_publisher_get_type ()")]
	public class MdnsPublisher : GLib.Object {
		[CCode (has_construct_function = false)]
		public MdnsPublisher ();
		public bool publish (string name, uint port, string type_of_service, bool password_required, string txt_records) throws GLib.Error;
		public bool rename_at_port (uint port, string name) throws GLib.Error;
		public bool withdraw (uint port) throws GLib.Error;
		public virtual signal void name_collision (string name);
		public virtual signal void published (string name);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_mdns_service_get_type ()")]
	public class MdnsService : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MdnsService ();
		[NoAccessorMethod]
		public string host { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string pair { owned get; set; }
		[NoAccessorMethod]
		public bool password_protected { get; set; }
		[NoAccessorMethod]
		public uint port { get; set; }
		[NoAccessorMethod]
		public string service_name { owned get; set; }
		[NoAccessorMethod]
		public uint transport_protocol { get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_share_get_type ()")]
	public abstract class Share : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Share ();
		[NoWrapper]
		public virtual void content_codes (Soup.ServerMessage message, string path);
		[NoWrapper]
		public virtual void ctrl_int (Soup.ServerMessage message, string path, GLib.HashTable<void*,void*> query);
		[NoWrapper]
		public virtual void databases (Soup.Server server, Soup.ServerMessage message, string path, GLib.HashTable<void*,void*> query);
		[NoWrapper]
		public virtual void databases_browse_xxx (Soup.ServerMessage msg, string path, GLib.HashTable<void*,void*> query);
		[NoWrapper]
		public virtual void databases_items_xxx (Soup.Server server, Soup.ServerMessage msg, string path);
		public static void free_filter (GLib.SList<GLib.SList<void*>> filter);
		[NoWrapper]
		public virtual uint get_desired_port ();
		[NoWrapper]
		public virtual void* get_meta_data_map ();
		[NoWrapper]
		public virtual unowned string get_type_of_service ();
		[NoWrapper]
		public virtual void login (Soup.ServerMessage message, string path, GLib.HashTable<void*,void*> query);
		[NoWrapper]
		public virtual void logout (Soup.ServerMessage message, string path, GLib.HashTable<void*,void*> query);
		[NoWrapper]
		public virtual void message_add_standard_headers (Soup.ServerMessage msg);
		[NoWrapper]
		public virtual void name_collision (Dmap.MdnsPublisher publisher, string name);
		public bool publish () throws GLib.Error;
		[NoWrapper]
		public virtual void published (Dmap.MdnsPublisher publisher, string name);
		public bool serve () throws GLib.Error;
		[NoWrapper]
		public virtual void server_info (Soup.ServerMessage message, string path);
		[NoWrapper]
		public virtual void update (Soup.ServerMessage message, string path, GLib.HashTable<void*,void*> query);
		[NoAccessorMethod]
		public uint auth_method { get; set; }
		[NoAccessorMethod]
		public Dmap.ContainerDb container_db { owned get; construct; }
		[NoAccessorMethod]
		public Dmap.Db db { owned get; construct; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint revision_number { get; set; }
		[NoAccessorMethod]
		public Soup.Server server { owned get; }
		[NoAccessorMethod]
		public string transcode_mimetype { owned get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] txt_records { owned get; set; }
		public signal void error (void* object);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_id = "dmap_transcode_stream_get_type ()")]
	public class TranscodeStream : GLib.InputStream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public TranscodeStream (string transcode_mimetype, GLib.InputStream src_stream);
		[NoWrapper]
		public virtual void kill_pipeline ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_cname = "DmapAvRecordInterface", type_id = "dmap_av_record_get_type ()")]
	public interface AvRecord : GLib.Object {
		public static int cmp_by_album (void* a, void* b, Dmap.Db db);
		public abstract bool itunes_compat ();
		public abstract GLib.InputStream read () throws GLib.Error;
		[NoAccessorMethod]
		public abstract int bitrate { get; set; }
		[NoAccessorMethod]
		public abstract int disc { get; set; }
		[NoAccessorMethod]
		public abstract int duration { get; set; }
		[NoAccessorMethod]
		public abstract uint64 filesize { get; set; }
		[NoAccessorMethod]
		public abstract int firstseen { get; set; }
		[NoAccessorMethod]
		public abstract string format { owned get; set; }
		[NoAccessorMethod]
		public abstract bool has_video { get; set; }
		[NoAccessorMethod]
		public abstract GLib.Array<void*> hash { owned get; set; }
		[NoAccessorMethod]
		public abstract string location { owned get; set; }
		[NoAccessorMethod]
		public abstract Dmap.MediaKind mediakind { get; set; }
		[NoAccessorMethod]
		public abstract int mtime { get; set; }
		[NoAccessorMethod]
		public abstract int rating { get; set; }
		[NoAccessorMethod]
		public abstract string songalbum { owned get; set; }
		[NoAccessorMethod]
		public abstract int64 songalbumid { get; set; }
		[NoAccessorMethod]
		public abstract string songartist { owned get; set; }
		[NoAccessorMethod]
		public abstract string songgenre { owned get; set; }
		[NoAccessorMethod]
		public abstract string sort_album { owned get; set; }
		[NoAccessorMethod]
		public abstract string sort_artist { owned get; set; }
		[NoAccessorMethod]
		public abstract string title { owned get; set; }
		[NoAccessorMethod]
		public abstract int track { get; set; }
		[NoAccessorMethod]
		public abstract int year { get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_cname = "DmapContainerDbInterface", type_id = "dmap_container_db_get_type ()")]
	public interface ContainerDb : GLib.Object {
		public abstract void add (Dmap.ContainerRecord record) throws GLib.Error;
		[NoWrapper]
		public abstract int64 count ();
		public abstract void @foreach (Dmap.IdContainerRecordFunc func);
		public abstract Dmap.ContainerRecord lookup_by_id (uint id);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_cname = "DmapContainerRecordInterface", type_id = "dmap_container_record_get_type ()")]
	public interface ContainerRecord : GLib.Object {
		public abstract void add_entry (Dmap.Record record, int id) throws GLib.Error;
		public abstract Dmap.Db get_entries ();
		public abstract uint64 get_entry_count ();
		public abstract uint get_id ();
		[NoAccessorMethod]
		public abstract string name { owned get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_cname = "DmapControlPlayerInterface", type_id = "dmap_control_player_get_type ()")]
	public interface ControlPlayer : GLib.Object {
		public abstract void cue_clear ();
		public abstract void cue_play (GLib.List<Dmap.Record> records, uint index);
		public abstract void next_item ();
		public abstract unowned string now_playing_artwork (uint width, uint height);
		public abstract unowned Dmap.AvRecord now_playing_record ();
		public abstract void pause ();
		public abstract void play_pause ();
		public abstract void prev_item ();
		[NoAccessorMethod]
		public abstract Dmap.ControlPlayState play_state { get; set; }
		[NoAccessorMethod]
		public abstract ulong playing_time { get; set; }
		[NoAccessorMethod]
		public abstract Dmap.ControlRepeatState repeat_state { get; set; }
		[NoAccessorMethod]
		public abstract bool shuffle_state { get; set; }
		[NoAccessorMethod]
		public abstract ulong volume { get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_cname = "DmapDbInterface", type_id = "dmap_db_get_type ()")]
	public interface Db : GLib.Object {
		public abstract uint add (Dmap.Record record) throws GLib.Error;
		public abstract uint add_path (string path) throws GLib.Error;
		public abstract uint add_with_id (Dmap.Record record, uint id) throws GLib.Error;
		public GLib.HashTable<uint,Dmap.Record> apply_filter (GLib.SList<Dmap.DbFilterDefinition?> filter_def);
		[NoWrapper]
		public abstract int64 count ();
		public abstract void @foreach (Dmap.IdRecordFunc func);
		public abstract Dmap.Record lookup_by_id (uint id);
		public abstract uint lookup_id_by_location (string location);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_cname = "DmapImageRecordInterface", type_id = "dmap_image_record_get_type ()")]
	public interface ImageRecord : GLib.Object {
		public abstract GLib.InputStream read () throws GLib.Error;
		[NoAccessorMethod]
		public abstract string aspect_ratio { owned get; set; }
		[NoAccessorMethod]
		public abstract string comments { owned get; set; }
		[NoAccessorMethod]
		public abstract int creation_date { get; set; }
		[NoAccessorMethod]
		public abstract string filename { owned get; set; }
		[NoAccessorMethod]
		public abstract string format { owned get; set; }
		[NoAccessorMethod]
		public abstract GLib.Array<void*> hash { owned get; set; }
		[NoAccessorMethod]
		public abstract int large_filesize { get; set; }
		[NoAccessorMethod]
		public abstract string location { owned get; set; }
		[NoAccessorMethod]
		public abstract int pixel_height { get; set; }
		[NoAccessorMethod]
		public abstract int pixel_width { get; set; }
		[NoAccessorMethod]
		public abstract int rating { get; set; }
		[NoAccessorMethod]
		public abstract GLib.Array<void*> thumbnail { owned get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_cname = "DmapRecordInterface", type_id = "dmap_record_get_type ()")]
	public interface Record : GLib.Object {
		public abstract bool set_from_blob (GLib.Array<uint8> blob);
		public abstract GLib.Array<uint8> to_blob ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", type_cname = "DmapRecordFactoryInterface", type_id = "dmap_record_factory_get_type ()")]
	public interface RecordFactory : GLib.Object {
		public abstract Dmap.Record create () throws GLib.Error;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[SimpleType]
	public struct Bits : uint64 {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_type_id = false)]
	public struct DbFilterDefinition {
		public weak string key;
		public weak string value;
		public bool negate;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_type_id = false)]
	public struct HashContext {
		[CCode (array_length = false)]
		public weak uint32 buf[4];
		[CCode (array_length = false)]
		public weak uint32 bits[2];
		[CCode (array_length = false)]
		public weak uint8 @in[64];
		public int version;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_type_id = false)]
	public struct MetaDataMap {
		public weak string tag;
		public uint md;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_type_id = false)]
	public struct MlclBits {
		public weak GLib.Node mlcl;
		public Dmap.Bits bits;
		public weak Dmap.Share share;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_type_id = false)]
	public struct Playlist {
		public weak string name;
		public int id;
		public weak GLib.List<void*> uris;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_", type_id = "dmap_connection_state_get_type ()")]
	public enum ConnectionState {
		GET_INFO,
		LOGIN,
		GET_REVISION_NUMBER,
		GET_DB_INFO,
		GET_MEDIA,
		GET_PLAYLISTS,
		GET_PLAYLIST_ENTRIES,
		LOGOUT,
		DONE
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_", type_id = "dmap_content_code_get_type ()")]
	public enum ContentCode {
		CC_INVALID,
		RAW,
		CC_MDCL,
		CC_MEDS,
		CC_MSTT,
		CC_MIID,
		CC_MINM,
		CC_MIKD,
		CC_MPER,
		CC_MCON,
		CC_MCTI,
		CC_MPCO,
		CC_MSTS,
		CC_MIMC,
		CC_MCTC,
		CC_MRCO,
		CC_MTCO,
		CC_MLCL,
		CC_MLIT,
		CC_MBCL,
		CC_MSRV,
		CC_MSAU,
		CC_MSLR,
		CC_MPRO,
		CC_MSAL,
		CC_MSUP,
		CC_MSPI,
		CC_MSEX,
		CC_MSBR,
		CC_MSQY,
		CC_MSIX,
		CC_MSRS,
		CC_MSTM,
		CC_MSDC,
		CC_MCCR,
		CC_MCNM,
		CC_MCNA,
		CC_MCTY,
		CC_MLOG,
		CC_MLID,
		CC_MUPD,
		CC_MUSR,
		CC_MUTY,
		CC_MUDL,
		CC_MSMA,
		CC_FQUESCH,
		CC_MDBK,
		CC_APRO,
		CC_AVDB,
		CC_ABRO,
		CC_ABAL,
		CC_ABAR,
		CC_ABCP,
		CC_ABGN,
		CC_ADBS,
		CC_ASAL,
		CC_ASAI,
		CC_ASAA,
		CC_ASAR,
		CC_ASBT,
		CC_ASBR,
		CC_ASCM,
		CC_ASCO,
		CC_ASDA,
		CC_ASDM,
		CC_ASDC,
		CC_ASDN,
		CC_ASDB,
		CC_ASEQ,
		CC_ASFM,
		CC_ASGN,
		CC_ASDT,
		CC_ASRV,
		CC_ASSR,
		CC_ASSZ,
		CC_ASST,
		CC_ASSP,
		CC_ASTM,
		CC_ASTC,
		CC_ASTN,
		CC_ASUR,
		CC_ASYR,
		CC_ASDK,
		CC_ASUL,
		CC_ASSU,
		CC_ASSA,
		CC_APLY,
		CC_ABPL,
		CC_APSO,
		CC_PRSV,
		CC_ARIF,
		CC_MSAS,
		CC_AGRP,
		CC_AGAL,
		CC_ASCP,
		CC_PPRO,
		CC_PASP,
		CC_PFDT,
		CC_PICD,
		CC_PIMF,
		CC_PFMT,
		CC_PIFS,
		CC_PLSZ,
		CC_PHGT,
		CC_PWTH,
		CC_PRAT,
		CC_PCMT,
		CC_PRET,
		CC_AECS,
		CC_AESV,
		CC_AEHV,
		CC_AESP,
		CC_AEPP,
		CC_AEPS,
		CC_AESG,
		CC_AEMK,
		CC_AEMK2,
		CC_AEFP,
		CC_ATED,
		CC_ASGR,
		CC_AEMQ,
		CC_AESL,
		CC_AESR,
		CC_AETR,
		CC_MSED,
		CC_CMPA,
		CC_CMNM,
		CC_CMTY,
		CC_CMPG,
		CC_CACI,
		CC_CAPS,
		CC_CASH,
		CC_CARP,
		CC_CAAS,
		CC_CAAR,
		CC_CAIA,
		CC_CANP,
		CC_CANN,
		CC_CANA,
		CC_CANL,
		CC_CANG,
		CC_CANT,
		CC_CASP,
		CC_CASS,
		CC_CAST,
		CC_CASU,
		CC_CASG,
		CC_CACR,
		CC_CMCP,
		CC_CMGT,
		CC_CMIK,
		CC_CMSP,
		CC_CMST,
		CC_CMSV,
		CC_CMSR,
		CC_CMMK,
		CC_CMVO,
		CC_CMPR,
		CC_CAPR,
		CC_AEFR,
		CC_CAOV,
		CC_CMRL,
		CC_CAHP,
		CC_CAIV,
		CC_CAVC
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_CONTROL_PLAY_", type_id = "dmap_control_play_state_get_type ()")]
	public enum ControlPlayState {
		STOPPED,
		PAUSED,
		PLAYING
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_CONTROL_REPEAT_", type_id = "dmap_control_repeat_state_get_type ()")]
	public enum ControlRepeatState {
		NONE,
		SINGLE,
		ALL
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_DB_ID_", type_id = "dmap_db_id_get_type ()")]
	public enum DbId {
		BAD
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_SERVICE_TRANSPORT_PROTOCOL_", type_id = "dmap_mdns_service_transport_protocol_get_type ()")]
	public enum MdnsServiceTransportProtocol {
		TCP,
		UDP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_SERVICE_TYPE_", type_id = "dmap_mdns_service_type_get_type ()")]
	public enum MdnsServiceType {
		INVALID,
		DAAP,
		DPAP,
		DACP,
		RAOP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MEDIA_KIND_", type_id = "dmap_media_kind_get_type ()")]
	public enum MediaKind {
		MUSIC,
		MOVIE,
		PODCAST,
		TV_SHOW
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_SHARE_AUTH_METHOD_", type_id = "dmap_share_auth_method_get_type ()")]
	public enum ShareAuthMethod {
		NONE,
		NAME_AND_PASSWORD,
		PASSWORD
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_STATUS_", type_id = "dmap_error_get_type ()")]
	public errordomain Error {
		OK,
		FAILED,
		INVALID_CONTENT_CODE,
		INVALID_CONTENT_CODE_SIZE,
		RESPONSE_TOO_SHORT,
		BAD_FORMAT,
		BAD_BROWSE_CATEGORY,
		RECORD_MISSING_FIELD,
		DB_BAD_ID,
		OPEN_FAILED,
		CLOSE_FAILED,
		SEEK_FAILED,
		NUM_ERRORS;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_ERROR_", type_id = "dmap_mdns_browser_error_get_type ()")]
	public errordomain MdnsBrowserError {
		NOT_RUNNING,
		FAILED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_PUBLISHER_ERROR_", type_id = "dmap_mdns_publisher_error_get_type ()")]
	public errordomain MdnsPublisherError {
		NOT_RUNNING,
		FAILED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", instance_pos = 3.9)]
	public delegate void ConnectionFunc (Dmap.Connection connection, bool result, string reason);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", instance_pos = 2.9)]
	public delegate void IdContainerRecordFunc (uint id, Dmap.ContainerRecord record);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", instance_pos = 2.9)]
	public delegate void IdRecordFunc (uint id, Dmap.Record record);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "DMAP_HASH_SIZE")]
	public const int HASH_SIZE;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Version (replacement = "AvRecord.cmp_by_album")]
	public static int av_record_cmp_by_album (void* a, void* b, Dmap.Db db);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Version (replacement = "Error.quark")]
	public static GLib.Quark error_quark ();
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void md5_generate (short version_major, uint8 url, uint8 hash_select, uint8 @out, int request_id);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void md5_progressive_final (Dmap.HashContext context, uint8 digest);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void md5_progressive_init (Dmap.HashContext context);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void md5_progressive_to_string (uint8 digest, string string);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void md5_progressive_update (Dmap.HashContext context, uint8 buffer, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Version (replacement = "MdnsBrowserError.quark")]
	public static GLib.Quark mdns_browser_error_quark ();
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Version (replacement = "MdnsPublisherError.quark")]
	public static GLib.Quark mdns_publisher_error_quark ();
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static string utils_mime_to_format (string transcode_mimetype);
}
