/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.GrammarProjection;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.Scorer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectionScorer
implements Scorer {
    protected GrammarProjection gp;
    protected Scorer scorer;
    protected Edge tempEdge = new Edge();
    protected Hook tempHook = new Hook();

    protected Edge project(Edge edge) {
        this.tempEdge.start = edge.start;
        this.tempEdge.end = edge.end;
        this.tempEdge.state = this.gp.project(edge.state);
        this.tempEdge.head = edge.head;
        this.tempEdge.tag = edge.tag;
        return this.tempEdge;
    }

    protected Hook project(Hook hook) {
        this.tempHook.start = hook.start;
        this.tempHook.end = hook.end;
        this.tempHook.state = this.gp.project(hook.state);
        this.tempHook.head = hook.head;
        this.tempHook.tag = hook.tag;
        this.tempHook.subState = this.gp.project(hook.subState);
        return this.tempHook;
    }

    @Override
    public double oScore(Edge edge) {
        return this.scorer.oScore(this.project(edge));
    }

    @Override
    public double iScore(Edge edge) {
        return this.scorer.iScore(this.project(edge));
    }

    @Override
    public boolean oPossible(Hook hook) {
        return this.scorer.oPossible(this.project(hook));
    }

    @Override
    public boolean iPossible(Hook hook) {
        return this.scorer.iPossible(this.project(hook));
    }

    @Override
    public boolean parse(List<? extends HasWord> words) {
        return this.scorer.parse(words);
    }

    public ProjectionScorer(Scorer scorer, GrammarProjection gp) {
        this.scorer = scorer;
        this.gp = gp;
    }
}

