<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authnz_ldap - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authnz_ldap</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authnz_ldap.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authnz_ldap.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Permet d'utiliser un annuaire LDAP pour l'authentification
HTTP de base.</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authnz_ldap_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authnz_ldap.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Dosponible depuis les versions 2.1 et suprieures
d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet aux frontaux d'authentification comme
    <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> d'authentifier les utilisateurs via
    un annuaire ldap.</p>

    <p><code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> supporte les fonctionnalits
    suivantes :</p>

    <ul>
      <li>Support vrifi du <a href="http://www.openldap.org/">OpenLDAP SDK</a> (versions 1.x et
      2.x), du <a href="http://developer.novell.com/ndk/cldap.htm">
      Novell LDAP SDK</a> et du SDK <a href="http://www.iplanet.com/downloads/developer/">iPlanet
      (Netscape)</a>.</li>

      <li>Implmentation de politiques d'autorisation complexes en les
      dfinissant via des filtres LDAP.</li>

      <li>Mise en oeuvre d'une mise en cache des oprations LDAP
      labore via <a href="mod_ldap.html">mod_ldap</a>.</li>

      <li>Support de LDAP via SSL (ncessite le SDK Netscape) ou TLS
      (ncessite le SDK OpenLDAP 2.x ou le SDK LDAP Novell).</li>
    </ul>

    <p>Lorsqu'on utilise <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>, ce module est
    invoqu en affectant la valeur <code>ldap</code>  la directive
    <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code>.</p>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#contents">Sommaire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#gcaveats">Mises en garde  caractre gnral</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#operation">Mode opratoire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requiredirectives">Les directives requises</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#usingtls">Utilisation de TLS</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#usingssl">Utilisation de SSL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#exposed">Mise  disposition des informations de
connexion</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#activedirectory">Utilisation d'Active
Directory</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#frontpage">Utilisation de Microsoft
    FrontPage avec mod_authnz_ldap</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authldapauthorizeprefix">AuthLDAPAuthorizePrefix</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapbindauthoritative">AuthLDAPBindAuthoritative</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapbinddn">AuthLDAPBindDN</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapbindpassword">AuthLDAPBindPassword</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapcharsetconfig">AuthLDAPCharsetConfig</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapcompareasuser">AuthLDAPCompareAsUser</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapcomparednonserver">AuthLDAPCompareDNOnServer</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapdereferencealiases">AuthLDAPDereferenceAliases</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapgroupattribute">AuthLDAPGroupAttribute</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapgroupattributeisdn">AuthLDAPGroupAttributeIsDN</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapinitialbindasuser">AuthLDAPInitialBindAsUser</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapinitialbindpattern">AuthLDAPInitialBindPattern</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapmaxsubgroupdepth">AuthLDAPMaxSubGroupDepth</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapremoteuserattribute">AuthLDAPRemoteUserAttribute</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapremoteuserisdn">AuthLDAPRemoteUserIsDN</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapsearchasuser">AuthLDAPSearchAsUser</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapsubgroupattribute">AuthLDAPSubGroupAttribute</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapsubgroupclass">AuthLDAPSubGroupClass</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authldapurl">AuthLDAPUrl</a></li>
</ul>
<h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code></li>
<li><code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code></li>
<li><code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code></li>
<li><code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="contents" id="contents">Sommaire</a></h2>

    <ul>
    <li> <a href="#gcaveats">Mises en garde  caractre gnral</a> </li>
      <li> <a href="#operation">Mode opratoire</a>

        <ul>
          <li><a href="#authenphase">La phase
	  d'authentification</a></li>

          <li><a href="#authorphase">La phase d'autorisation</a></li>
        </ul>
      </li>

      <li>
        <a href="#requiredirectives">Les directives requises</a>

        <ul>
          <li><a href="#requser">Require ldap-user</a></li>
          <li><a href="#reqgroup">Require ldap-group</a></li>
          <li><a href="#reqdn">Require ldap-dn</a></li>
          <li><a href="#reqattribute">Require ldap-attribute</a></li>
          <li><a href="#reqfilter">Require ldap-filter</a></li>
        </ul>
      </li>

      <li><a href="#examples">Exemples</a></li>
      <li><a href="#usingtls">Utilisation de TLS</a></li>
      <li><a href="#usingssl">Utilisation de SSL</a></li>
      <li><a href="#exposed">Mise  disposition des informations de
      connexion</a></li>
      <li><a href="#activedirectory">Utilisation d'Active Directory</a></li>
      <li>
        <a href="#frontpage">Utilisation de Microsoft FrontPage avec
        <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code></a>

        <ul>
          <li><a href="#howitworks">Comment a marche</a></li>
          <li><a href="#fpcaveats">Mises en garde</a></li>
        </ul>
      </li>
    </ul>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="gcaveats" id="gcaveats">Mises en garde  caractre gnral</a></h2>
<p>Ce module effectue une mise en cache des rsultats du processus
d'authentification et d'autorisation en fonction de la configuration du
module <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code>. Les modifications effectues au niveau
du serveur LDAP d'arrire-plan comme les
verrouillages ou rvocations d'utilisateurs, les changements de mot de
passe, ou les changements d'appartenance  un groupe (et cette liste
n'est pas exhaustive), ne seront pas immdiatement propages jusqu'au
serveur HTTP. Consultez les directives du module
<code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> pour plus de dtails  propos de la
configuration de la mise en cache.
</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="operation" id="operation">Mode opratoire</a></h2>

    <p>L'utilisateur se voit accorder l'accs selon un processus en deux
    phases. La premire phase est l'authentification, au cours de
    laquelle le fournisseur d'authentification
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> vrifie que les informations de
    connexion de l'utilisateur sont valides. Elle est aussi connue sous
    le nom de phase de <em>recherche/connexion</em> (NdT : en anglais ou
    dans le code source : <em>search/bind</em>). La deuxime
    phase est l'autorisation, au cours de laquelle
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> dtermine si l'utilisateur
    authentifi a la permission d'accder  la ressource considre.
    Elle est aussi connue sous le nom de phase de
    <em>comparaison</em> (<em>compare</em>).</p>

    <p><code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> comporte un fournisseur
    d'authentification authn_ldap et un gestionnaire d'autorisation
    authz_ldap. Le fournisseur d'authentification authn_ldap peut tre
    invoqu en affectant la valeur <code>ldap</code>  la directive
    <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code>. Le
    gestionnaire d'autorisation authz_ldap enrichit la liste des types
    d'autorisations de la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> en y ajoutant les
    valeurs <code>ldap-user</code>, <code>ldap-dn</code> et
    <code>ldap-group</code>.</p>

<h3><a name="authenphase" id="authenphase">La phase d'authentification</a></h3>

    <p>Au cours de la phase d'authentification,
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> recherche une entre de l'annuaire
    LDAP qui correspond au nom d'utilisateur fourni par le client HTTP.
    Si une correspondance unique est trouve,
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> tente de se connecter au serveur
    hbergeant l'annuaire LDAP en utilisant le DN de l'entre et le mot
    de passe fourni par le client HTTP. Comme ce processus effectue tout
    d'abord une recherche, puis une connexion, il est aussi connu sous
    le nom de phase de recherche/connexion. Voici le dtail des tapes
    constituant la phase de recherche/connexion :</p>

    <ol>
      <li>Confection d'un filtre de recherche en combinant les attribut
      et filtre dfinis par la directive <code class="directive"><a href="#authldapurl">AuthLDAPURL</a></code> avec le nom d'utilisateur et le mot de
      passe fournis par le client HTTP.</li>

      <li>Recherche dans l'annuaire LDAP en utilisant le filtre
      confectionn prcdemment. Si le rsultat de la recherche est
      ngatif ou comporte plusieurs entres, refus ou restriction de
      l'accs.</li>

      <li>Extraction du DN (distinguished name) de l'entre issue du
      rsultat de la recherche, et tentative de connexion au serveur
      LDAP en utilisant ce DN et le mot de passe fournis par le client
      HTTP. Si la connexion choue, refus ou restriction de
      l'accs.</li>
    </ol>

    <p>Les directives utilises durant la phase de recherche/connexion
    sont les suivantes :</p>

    <table>
      
      <tr>
        <td><code class="directive"><a href="#authldapurl">AuthLDAPURL</a></code></td>

        <td>Spcifie le serveur LDAP, le DN de base, l'attribut 
	utiliser pour la recherche, ainsi que les filtres de recherche
	supplmentaires.</td>
      </tr>

      <tr>
        <td><code class="directive"><a href="#authldapbinddn">AuthLDAPBindDN</a></code></td>

        <td>Un DN optionnel pour se connecter durant la phase de
	recherche.</td>
      </tr>

      <tr>
        <td><code class="directive"><a href="#authldapbindpassword">AuthLDAPBindPassword</a></code></td>

        <td>Un mot de passe optionnel pour se connecter durant la phase
	de recherche.</td>
      </tr>
    </table>


<h3><a name="authorphase" id="authorphase">La phase d'autorisation</a></h3>

    <p>Au cours de la phase d'autorisation,
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> tente de dterminer si
    l'utilisateur est autoris  accder  la ressource considre. Une
    grande partie de cette vrification consiste pour
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> en des oprations de comparaison au
    niveau du serveur LDAP. C'est pourquoi cette phase est aussi connue
    sous le nom de phase de comparaison.
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> accepte les directives <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> suivantes pour
    dterminer si les informations de connexion permettent d'accorder
    l'accs  l'utilisateur :</p>

    <ul>
      <li>Avec la directive <a href="#reqgroup"><code>Require ldap-user</code></a>,
      l'autorisation d'accs est accorde si le nom d'utilisateur
      spcifi par la directive correspond au nom d'utilisateur fourni
      par le client.</li>

      <li>Avec la directive <a href="#reqdn"><code>Require
      ldap-dn</code></a>, l'autorisation d'accs est accorde si le DN
      spcifi par la directive correspond au DN extrait du rsultat de
      la recherche dans l'annuaire LDAP.</li>

      <li>Avec la directive <a href="#reqgroup"><code>Require ldap-group</code></a>,
      l'autorisation d'accs est accorde si le DN extrait du rsultat de
      la recherche dans l'annuaire LDAP (ou le nom d'utilisateur fourni
      par le client) appartient au groupe LDAP spcifi par la
      directive, ou ventuellement  un de ses sous-groupes.</li>

      <li>Avec la directive <a href="#reqattribute">
      <code>Require ldap-attribute</code></a>, l'autorisation d'accs
      est accorde si la valeur de l'attribut extraite de la recherche
      dans l'annuaire LDAP correspond  la valeur spcifie par la
      directive.</li>

      <li>Avec la directive <a href="#reqfilter">
      <code>Require ldap-filter</code></a>, l'autorisation d'accs
      est accorde si le filtre de recherche renvoie un objet
      utilisateur unique qui corresponde au DN de l'utilisateur
      authentifi.</li>

      <li>dans tous les autres cas, refus ou restriction de
      l'accs.</li>
    </ul>

    <p>Sous rserve du chargement de modules d'autorisation
    supplmentaires, d'autres valeurs de la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> peuvent tre
    spcifies.</p>

    <ul>
        <li>L'accs est accord  tous les utilisateurs authentifis si
	une directive <a href="#requser"><code>Require
	valid-user</code></a> est prsente (ncessite le module
	<code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code>).</li>

        <li>Avec la directive <a href="#reqgroup"><code>Require group</code></a>, l'autorisation
	d'accs est accorde si le module
	<code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code> a t charg et si la
	directive <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code> a t
	dfinie.</li>

        <li>etc...</li>
     </ul>


    <p>Durant la phase de comparaison, <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code>
    utilise les directives suivantes :</p>

    <table>
      
      <tr>
        <td><code class="directive"><a href="#authldapurl">AuthLDAPURL</a></code>
	</td>

        <td>On utilise l'attribut spcifi dans l'URL pour les
	oprations de comparaison inities par la directive
	<code>Require ldap-user</code>.</td>
      </tr>

      <tr>
        <td><code class="directive"><a href="#authldapcomparednonserver">AuthLDAPCompareDNOnServer</a></code></td>

        <td>Dtermine le comportement de la directive <code>Require
	ldap-dn</code>.</td>
      </tr>

      <tr>
        <td><code class="directive"><a href="#authldapgroupattribute">AuthLDAPGroupAttribute</a></code></td>

        <td>Dtermine l'attribut utilis pour les oprations de
	comparaison inities par la directive <code>Require
	ldap-group</code>.</td>
      </tr>

      <tr>
        <td><code class="directive"><a href="#authldapgroupattributeisdn">AuthLDAPGroupAttributeIsDN</a></code></td>

        <td>Spcifie si l'on doit utiliser le DN ou le nom de
	l'utilisateur lors des oprations de comparaison inities par la
	directive <code>Require ldap-group</code>.</td>
      </tr>

      <tr>
        <td><code class="directive"><a href="#authldapmaxsubgroupdepth">AuthLDAPMaxSubGroupDepth</a></code></td>

        <td>Dtermine la profondeur maximale de l'arborescence des
	sous-groupes qui seront valus au cours des oprations de
	comparaisons inities par la directive <code>Require
	ldap-group</code>.</td>
      </tr>

      <tr>
        <td><code class="directive"><a href="#authldapsubgroupattribute">AuthLDAPSubGroupAttribute</a></code></td>

        <td>Dtermine l'attribut  utiliser lors de l'extraction de
	membres de sous-groupes du groupe courant au cours des
	oprations de comparaison inities par la directive
	<code>Require ldap-group</code>.</td>
      </tr>

      <tr>
        <td><code class="directive"><a href="#authldapsubgroupclass">AuthLDAPSubGroupClass</a></code></td>

        <td>Spcifie les valeurs de classe d'objet LDAP  utiliser pour
	dterminer si les objets extraits de l'annuaire sont bien des
	objets de type groupe (et non des objets de type utilisateur),
	au cours du traitement des sous-groupes initi par la directive
	<code>Require ldap-group</code>.</td>
      </tr>
    </table>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="requiredirectives" id="requiredirectives">Les directives requises</a></h2>

    <p>Les directives <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> d'Apache sont utilises
    au cours de la phase d'autorisation afin de s'assurer que
    l'utilisateur est autoris  accder  une ressource.
    mod_authnz_ldap enrichit la liste des types d'autorisations avec les
    valeurs <code>ldap-user</code>, <code>ldap-dn</code>,
    <code>ldap-group</code>, <code>ldap-attribute</code> et
    <code>ldap-filter</code>. D'autres types d'autorisations sont
    disponibles, sous rserve du chargement de modules d'autorisation
    supplmentaires.</p>

    <p>Depuis la version 2.4.8, les directives require LDAP supportent
    les <a href="../expr.html">expressions</a>.</p>

<h3><a name="requser" id="requser">Require ldap-user</a></h3>

    <p>La directive <code>Require ldap-user</code> permet de spcifier
    les noms des utilisateurs autoriss  accder  la ressource.
    Lorsque <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> a extrait un DN unique de
    l'annuaire LDAP, il effectue une opration de comparaison LDAP en
    utilisant le nom d'utilisateur spcifi par la directive
    <code>Require ldap-user</code>, pour vrifier si ce nom
    d'utilisateur correspond  l'entre LDAP extraite. On peut accorder
    l'accs  plusieurs utilisateurs en plaant plusieurs nom
    d'utilisateurs sur la mme ligne spars par des espaces. Si un nom
    d'utilisateur contient des espaces, il doit tre entour de
    guillemets. On peut aussi accorder l'accs  plusieurs utilisateurs
    en utilisant une directive <code>Require ldap-user</code> par
    utilisateur. Par exemple, avec la directive <code class="directive"><a href="#authldapurl">AuthLDAPURL</a></code> dfinie 
    <code>ldap://ldap/o=Example?cn</code> (spcifiant donc que l'attribut
    <code>cn</code> sera utilis pour les recherches), on pourra
    utiliser les directives Require suivantes pour restreindre l'accs
    :</p>
<pre class="prettyprint lang-config">Require ldap-user "Barbara Jenson"
Require ldap-user "Fred User"
Require ldap-user "Joe Manager"</pre>


    <p>De par la manire dont <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> traite
    cette directive, Barbara Jenson peut s'authentifier comme
    <em>Barbara Jenson</em>, <em>Babs Jenson</em> ou tout autre
    <code>cn</code> sous lequel elle est enregistre dans l'annuaire
    LDAP. Une seule ligne <code>Require ldap-user</code> suffit pour
    toutes les valeurs de l'attribut dans l'entre LDAP de
    l'utilisateur.</p>

    <p>Si l'attribut <code>uid</code> avait t spcifi  la place de
    l'attribut <code>cn</code> dans l'URL prcdente, les trois lignes
    ci-dessus auraient p tre condenses en une seule ligne :</p>
<pre class="prettyprint lang-config">Require ldap-user bjenson fuser jmanager</pre>



<h3><a name="reqgroup" id="reqgroup">Require ldap-group</a></h3>

    <p>Cette directive permet de spcifier un groupe LDAP dont les
    membres auront l'autorisation d'accs. Elle prend comme argument le
    DN du groupe LDAP. Note : n'entourez pas le nom du groupe avec des
    guillemets. Par exemple, supposons que l'entre suivante existe dans
    l'annuaire LDAP :</p>
<div class="example"><pre>dn: cn=Administrators, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Barbara Jenson, o=Example
uniqueMember: cn=Fred User, o=Example</pre></div>

    <p>La directive suivante autoriserait alors l'accs  Fred et
    Barbara :</p>
<pre class="prettyprint lang-config">Require ldap-group cn=Administrators, o=Example</pre>


    <p>Les membres peuvent aussi se trouver dans les sous-groupes du
    groupe LDAP spcifi si la directive <code class="directive"><a href="#authldapmaxsubgroupdepth">AuthLDAPMaxSubGroupDepth</a></code> a t
    dfinie  une valeur suprieure  0. Par exemple, supposons que les
    entres suivantes existent dans l'annuaire LDAP :</p>
<div class="example"><pre>dn: cn=Employees, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Managers, o=Example
uniqueMember: cn=Administrators, o=Example
uniqueMember: cn=Users, o=Example

dn: cn=Managers, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Bob Ellis, o=Example
uniqueMember: cn=Tom Jackson, o=Example

dn: cn=Administrators, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Barbara Jenson, o=Example
uniqueMember: cn=Fred User, o=Example

dn: cn=Users, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Allan Jefferson, o=Example
uniqueMember: cn=Paul Tilley, o=Example
uniqueMember: cn=Temporary Employees, o=Example

dn: cn=Temporary Employees, o=Example
objectClass: groupOfUniqueNames
uniqueMember: cn=Jim Swenson, o=Example
uniqueMember: cn=Elliot Rhodes, o=Example</pre></div>

    <p>Les directives suivantes autoriseraient alors l'accs  Bob
    Ellis, Tom Jackson, Barbara Jenson, Fred User, Allan Jefferson, et
    Paul Tilley, mais l'interdiraient  Jim Swenson, ou Elliot Rhodes
    (car ils sont situs dans un sous-groupe de niveau de profondeur 2)
    :</p>
<pre class="prettyprint lang-config">Require ldap-group cn=Employees, o=Example
AuthLDAPMaxSubGroupDepth 1</pre>


    <p>Le comportement de cette directive est modifi par les directives
    <code class="directive"><a href="#authldapgroupattribute">AuthLDAPGroupAttribute</a></code>,
    <code class="directive"><a href="#authldapgroupattributeisdn">AuthLDAPGroupAttributeIsDN</a></code>,
    <code class="directive"><a href="#authldapmaxsubgroupdepth">AuthLDAPMaxSubGroupDepth</a></code>,
    <code class="directive"><a href="#authldapsubgroupattribute">AuthLDAPSubGroupAttribute</a></code>, et
    <code class="directive"><a href="#authldapsubgroupclass">AuthLDAPSubGroupClass</a></code>.</p>


<h3><a name="reqdn" id="reqdn">Require ldap-dn</a></h3>

    <p>La directive <code>Require ldap-dn</code> permet 
    l'administrateur d'accorder l'utorisation d'accs en fonction du DN.
    Elle permet de spcifier un DN pour lequel l'accs est autoris. Si
    le DN extrait de
    l'annuaire correspond au DN spcifi par la directive <code>Require
    ldap-dn</code>, l'autorisation d'accs est accorde. Note :
    n'entourez pas Le DN de guillemets.</p>

    <p>La directive suivante accorderait l'accs  un DN spcifique
    :</p>
<pre class="prettyprint lang-config">Require ldap-dn cn=Barbara Jenson, o=Example</pre>


    <p>Le comportement ce cette directive est modifi par la directive
    <code class="directive"><a href="#authldapcomparednonserver">AuthLDAPCompareDNOnServer</a></code>.</p>


<h3><a name="reqattribute" id="reqattribute">Require ldap-attribute</a></h3>

    <p>La directive <code>Require ldap-attribute</code> permet 
    l'administrateur d'accorder l'autorisation d'accs en fonction des
    attributs de l'utilisateur authentifi dans l'annuaire LDAP. Si la
    valeur de l'attribut dans l'annuaire correspond  la valeur
    spcifie par la directive, l'autorisation d'accs est accorde.</p>

    <p>La directive suivante accorderait l'autorisation d'accs  tout
    utilisateur dont l'attribut employeeType a pour valeur "actif" :</p>

    <pre class="prettyprint lang-config">Require ldap-attribute employeeType=active</pre>


    <p>Plusieurs paires attribut/valeur peuvent tre spcifies par une
    mme directive en les sparant par des espaces, ou en dfinissant
    plusieurs directives <code>Require ldap-attribute</code>. La logique
    sous-jacente  une liste de paires attribut/valeur est une opration
    OU. L'autorisation d'accs sera accorde si au moins une paire
    attribut/valeur de la liste spcifie correspond  la paire
    attribut/valeur de l'utilisateur authentifi. Si elle contient des
    espaces, la valeur, et seulement la valeur, doit tre entoure de
    guillemets.</p>

    <p>La directive suivante accorderait l'autorisation d'accs  tout
    utilisateur dont l'attribut city aurait pour valeur "San Jose", ou
    donc l'attribut status aurait pour valeur "actif" :</p>

    <pre class="prettyprint lang-config">Require ldap-attribute city="San Jose" status=active</pre>




<h3><a name="reqfilter" id="reqfilter">Require ldap-filter</a></h3>

    <p>La directive <code>Require ldap-filter</code> permet 
    l'administrateur d'accorder l'autorisation d'accs en fonction d'un
    filtre de recherche LDAP complexe. L'autorisation d'accs est
    accorde si le DN renvoy par le filtre de recherche correspond au
    DN de l'utilisateur authentifi.</p>

    <p>La directive suivante accorderait l'autorisation d'accs  tout
    utilisateur possdant un tlphone cellulaire et faisant partie du
    dpartement "marketing" :</p>

    <pre class="prettyprint lang-config">Require ldap-filter &amp;(cell=*)(department=marketing)</pre>


    <p>Alors que la directive <code>Require ldap-attribute</code> se
    contente d'une simple comparaison d'attributs, la directive
    <code>Require ldap-filter</code> effectue une opration de recherche
    dans l'annuaire LDAP en utilisant le filtre de recherche spcifi.
    Si une simple comparaison d'attributs suffit, l'opration de
    comparaison effectue par <code>ldap-attribute</code> sera plus
    rapide que l'opration de recherche effectue par
    <code>ldap-filter</code>, en particulier dans le cas d'un annuaire
    LDAP de grande taille.</p>



</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>

    <ul>
      <li>
        Accorde l'autorisation d'accs  tout utilisateur prsent dans
	l'annuaire LDAP, en utilisant son UID pour effectuer la
	recherche :
<pre class="prettyprint lang-config">AuthLDAPURL "ldap://ldap1.example.com:389/ou=People, o=Example?uid?sub?(objectClass=*)"
Require valid-user</pre>

      </li>

      <li>
        L'exemple suivant est similaire au prcdent, mais les champs
	dont les valeurs par dfaut conviennent sont omis. Notez aussi
	la prsence d'un annuaire LDAP redondant :
<pre class="prettyprint lang-config">AuthLDAPURL "ldap://ldap1.example.com ldap2.example.com/ou=People, o=Example"
Require valid-user</pre>

      </li>

      <li>
        Encore un exemple similaire aux prcdents, mais cette fois,
	c'est l'attribut cn qui est utilis pour la recherche  la place
	de l'UID. Notez que ceci peut poser problme si plusieurs
	utilisateurs de l'annuaire partagent le mme <code>cn</code>,
	car une recherche sur le <code>cn</code> <strong>doit</strong>
	retourner une entre et une seule. C'est pourquoi cette
	approche n'est pas recommande : il est prfrable de choisir un
	attribut de votre annuaire dont l'unicit soit garantie, comme
	<code>uid</code>.
<pre class="prettyprint lang-config">AuthLDAPURL "ldap://ldap.example.com/ou=People, o=Example?cn"
Require valid-user</pre>

      </li>

      <li>
        Accorde l'autorisation d'accs  tout utilisateur appartenant au
	groupe Administrateurs. Les utilisateurs doivent s'authentifier
	en utilisant leur UID :
<pre class="prettyprint lang-config">AuthLDAPURL ldap://ldap.example.com/o=Example?uid
Require ldap-group cn=Administrators, o=Example</pre>

      </li>

      <li>
      Accorde l'accs  tout utilisateur appartenant au groupe dont le
      nom correspond au nom d'hte du serveur virtuel. Dans cet exemple,
      on utilise une <a href="../expr.html">expression</a> pour
      construire le filtre.
<pre class="prettyprint lang-config">AuthLDAPURL ldap://ldap.example.com/o=Example?uid
Require ldap-group cn=%{SERVER_NAME}, o=Example</pre>

      </li>

      <li>
        Pour l'exemple suivant, on suppose que tout utilisateur de chez
	Example qui dispose d'un bippeur alphanumrique possdera un
	attribut LDAP <code>qpagePagerID</code>. Seuls ces utilisateurs
	(authentifis via leur UID) se verront accorder l'autorisation
	d'accs :
<pre class="prettyprint lang-config">AuthLDAPURL ldap://ldap.example.com/o=Example?uid??(qpagePagerID=*)
Require valid-user</pre>

      </li>

      <li>
        <p>L'exemple suivant illustre la puissance des filtres pour
	effectuer des requtes complexes. Sans les filtres, il aurait
	t ncessaire de crer un nouveau groupe LDAP et de s'assurer
	de la synchronisation des membres du groupe avec les
	utilisateurs possdant un bippeur. Tout devient limpide avec les
	filtres. Nous avons pour but d'accorder l'autorisation d'accs 
	tout utilisateur disposant d'un bippeur ainsi qu' Joe Manager
	qui ne possde pas de bippeur, mais doit tout de mme pouvoir
	accder  la ressource :</p>
<pre class="prettyprint lang-config">AuthLDAPURL ldap://ldap.example.com/o=Example?uid??(|(qpagePagerID=*)(uid=jmanager))
Require valid-user</pre>


        <p>Ce dernier exemple peut sembler confus au premier abord ; en
	fait, il permet de mieux comprendre  quoi doit ressembler le
	filtre en fonction de l'utilisateur qui se connecte. Si Fred
	User se connecte en tant que <code>fuser</code>, le filtre devra
	ressembler  :</p>

        <div class="example"><p><code>(&amp;(|(qpagePagerID=*)(uid=jmanager))(uid=fuser))</code></p></div>

        <p>Un recherche avec le filtre ci-dessus ne retournera un
	rsultat positif que si <em>fuser</em> dispose d'un bippeur. Si
	Joe Manager se connecte en tant que <em>jmanager</em>, le filtre
	devra ressembler  :</p>

        <div class="example"><p><code>(&amp;(|(qpagePagerID=*)(uid=jmanager))(uid=jmanager))</code></p></div>

        <p>Un recherche avec le filtre ci-dessus retournera un
	rsultat positif que <em>jmanager</em> dispose d'un
	bippeur ou non</p>
      </li>
    </ul>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="usingtls" id="usingtls">Utilisation de TLS</a></h2>

    <p>Pour l'utilisation de TLS, voir les directives du module
    <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> <code class="directive"><a href="../mod/mod_ldap.html#ldaptrustedclientcert">LDAPTrustedClientCert</a></code>, <code class="directive"><a href="../mod/mod_ldap.html#ldaptrustedglobalcert">LDAPTrustedGlobalCert</a></code> et <code class="directive"><a href="../mod/mod_ldap.html#ldaptrustedmode">LDAPTrustedMode</a></code>.</p>

    <p>Un second paramtre optionnel peut tre ajout  la directive
    <code class="directive"><a href="#authldapurl">AuthLDAPURL</a></code> pour
    remplacer le type de connexion par dfaut dfini par la directive
    <code class="directive"><a href="../mod/mod_ldap.html#ldaptrustedmode">LDAPTrustedMode</a></code>. Ceci
    permettra de promouvoir la connexion tablie via une URL du type
    <em>ldap://</em> au statut de connection scurise sur le mme
    port.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="usingssl" id="usingssl">Utilisation de SSL</a></h2>

    <p>Pour l'utilisation de SSL, voir les directives du module
    <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> <code class="directive"><a href="../mod/mod_ldap.html#ldaptrustedclientcert">LDAPTrustedClientCert</a></code>, <code class="directive"><a href="../mod/mod_ldap.html#ldaptrustedglobalcert">LDAPTrustedGlobalCert</a></code> et <code class="directive"><a href="../mod/mod_ldap.html#ldaptrustedmode">LDAPTrustedMode</a></code>.</p>

    <p>Pour spcifier un serveur LDAP scuris, utilisez
    <em>ldaps://</em> au lieu de
    <em>ldap://</em> dans la directive <code class="directive"><a href="#authldapurl">AuthLDAPURL</a></code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="exposed" id="exposed">Mise  disposition des informations de
connexion</a></h2>

    <p>Au cours du processus d'<em>authentification</em>, les attributs LDAP
    spcifis par la directive <code class="directive"><a href="#authldapurl">authldapurl</a></code> sont enregistrs
    dans des variables d'environnement prfixes par la chane
    "AUTHENTICATE_".</p>

    <p>Au cours du processus d'<em>autorisation</em>, les attributs LDAP
    spcifis par la directive <code class="directive"><a href="#authldapurl">authldapurl</a></code> sont enregistrs
    dans des variables d'environnement prfixes par la chane
    "AUTHORIZE_".</p>

    <p>Si les champs attribut contiennent le nom, le CN et le numro de
    tlphone d'un utilisateur, un programme CGI pourra accder  ces
    informations sans devoir effectuer une autre requte LDAP pour
    les extraire de l'annuaire.</p>

    <p>Ceci a pour effet de simplifier considrablement le code et la
    configuration ncessaire de certaines applications web.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="activedirectory" id="activedirectory">Utilisation d'Active
Directory</a></h2>

    <p>Active Directory peut supporter plusieurs domaines  la fois.
    Pour faire la distinction entre les utilisateurs de plusieurs
    domaines, on peut ajouter  l'entre de l'utilisateur dans
    l'annuaire un identifiant appel Nom
    Principal d'Utilisateur (User Principle Name ou UPN). Cet UPN se
    compose en gnral du nom de compte de l'utilisateur, suivi du nom
    du domaine considr, par exemple <em>untel@nz.example.com</em>.</p>

    <p>Vous voudrez probablement configurer le module
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> afin de pouvoir authentifier les
    utilisateurs de n'importe quel domaine de la fort Active Directory.
    Ainsi, <em>untel@nz.example.com</em> et
    <em>untel@au.example.com</em> pourront tre authentifis en une
    seule fois par la mme requte.</p>

    <p>Pour y parvenir, on utilise le concept de Catalogue Global
    d'Active Directory. Ce Catalogue Global est une copie en lecture
    seule des attributs slectionns de tous les serveurs de la fort
    Active Directory. Une requte vers le
    Catalogue Global permet donc d'atteindre tous les domaines en une
    seule fois, sans avoir  se connecter aux diffrents serveurs, via
    des liaisons dont certaines peuvent tre lentes.</p>

    <p>Lorsqu'il est activ, la Catalogue Global est un serveur
    d'annuaire indpendant accessible sur le port 3268 (3269 pour SSL).
    Pour rechercher un utilisateur, effectuez une recherche sur
    l'attribut <em>userPrincipalName</em>, avec une base de recherche
    vide, comme suit :</p>

<pre class="prettyprint lang-config">AuthLDAPBindDN apache@example.com
AuthLDAPBindPassword password
AuthLDAPURL ldap://10.0.0.1:3268/?userPrincipalName?sub</pre>


    <p>Les utilisateurs devront s'authentifier en entrant leur UPN, de
    la forme<em>untel@nz.example.com</em>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="frontpage" id="frontpage">Utilisation de Microsoft
    FrontPage avec mod_authnz_ldap</a></h2>

    <p>Normalement, FrontPage utilise des fichiers utilisateur/groupe
    spcifiques  FrontPage-web (c'est  dire les modules
    <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code> et
    <code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code>) pour effectuer toute
    l'authentification. Malheureusement, il ne suffit pas de modifier
    l'authentification LDAP en ajoutant les directives appropries, car
    ceci corromprait les formulaires de <em>Permissions</em> dans le
    client FrontPage, qui sont censs modifier les fichiers
    d'autorisation standards au format texte.</p>

    <p>Lorsqu'un site web FrontPage a t cr, lui adjoindre
    l'authentification LDAP consiste  ajouter les directives suivantes
     <em>chaque</em> fichier <code>.htaccess</code> qui sera cr dans
    le site web :</p>
<pre class="prettyprint lang-config">AuthLDAPURL       "the url"
AuthGroupFile     "mygroupfile"
Require group     "mygroupfile"</pre>


<h3><a name="howitworks" id="howitworks">Comment a marche</a></h3>

    <p>FrontPage restreint l'accs  un site web en ajoutant la
    directive <code>Require valid-user</code> aux fichiers
    <code>.htaccess</code>. La directive <code>Require valid-user</code>
    permettra l'accs  tout utilisateur valide <em>du point de vue
    LDAP</em>. Cela signifie que tout utilisateur possdant une entre
    dans l'annuaire LDAP sera considr comme valide, alors que
    FrontPage ne considre comme valides que les utilisateurs
    enregistrs dans le fichier des utilisateurs local. En remplaant
    l'autorisation par groupe LDAP par une autorisation par fichier de
    groupe, Apache sera en mesure de consulter le fichier des
    utilisateurs local (gr par FrontPage) - au lieu de l'annuaire LDAP
    - lors du processus d'autorisation des utilisateurs.</p>

    <p>Une fois les directives ajoutes selon ce qui prcde, les
    utilisateurs FrontPage pourront effectuer toutes les oprations de
    gestion  partir du client FrontPage.</p>


<h3><a name="fpcaveats" id="fpcaveats">Avertissements</a></h3>

    <ul>
      <li>Lors du choix de l'URL LDAP, l'attribut  utiliser pour
      l'authentification doit aussi tre valide pour le fichier des
      utilisateurs de <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>. A cette fin,
      l'UID est idal.</li>

      <li>Lorsqu'ils ajoutent des utilisateurs via FrontPage, les
      administrateurs de FrontPage doivent choisir des noms
      d'utilisateurs qui existent dj dans l'annuaire LDAP (pour des
      raisons videntes). De mme, le mot de passe que l'administrateur
      entre dans le formulaire est ignor, car pour l'authentification,
      Apache utilise le mot de passe de l'annuaire LDAP, et non le mot
      de passe enregistr dans le fichier des utilisateurs, ce qui peut
      semer la confusion parmi les administrateurs web.</li>

      
      <li>Pour supporter FrontPage, Apache doit tre compil avec
      <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>, <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>
      et <code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code>. Ceci est d au fait
      qu'Apache doit utiliser le fichier de groupes de
      <code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code> pour dterminer le niveau
      d'accs d'un utilisateur au site web FrontPage.</li>

      <li>Les directives doivent tre places dans les fichiers
      <code>.htaccess</code>. Elles ne fonctionneront pas si vous les
      placez dans une section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> ou <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>. Ceci est d au fait que pour savoir
      o se trouve la liste des utilisateurs valides,
      <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> doit tre en mesure d'atteindre
      la directive <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code> qui se trouve
      dans les fichiers <code>.htaccess</code> de FrontPage. Si les directives
      de <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> ne sont pas situes dans le
      mme fichier <code>.htaccess</code> que les directives FrontPage,
      la configuration ne fonctionnera pas, car
      <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> ne sera jamais en mesure de
      traiter le fichier <code>.htaccess</code>, et par consquent ne
      pourra jamais trouver le fichier des utilisateurs gr par
      FrontPage.</li>
    </ul>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapauthorizeprefix" id="authldapauthorizeprefix">Directive</a> <a name="AuthLDAPAuthorizePrefix" id="AuthLDAPAuthorizePrefix">AuthLDAPAuthorizePrefix</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie le prfixe ajout aux variables d'environnement
durant la phase d'autorisation</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPAuthorizePrefix <em>prfixe</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPAuthorizePrefix AUTHORIZE_</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.6</td></tr>
</table>
    <p>Cette directive permet de spcifier le prfixe ajout aux
    variables d'environnement durant la phase d'autorisation. Si la
    valeur spcifie est <em>AUTHENTICATE_</em>, les utilisateurs de ces
    variables d'environnement verront les mmes informations, que le
    serveur effectue une authentification, une autorisation, ou les
    deux.</p>

    <div class="note"><h3>Note</h3>
    Aucune variable d'autorisation n'est dfinie lorsqu'un utilisateur
    s'est vu autoriser l'accs via la directive <code>Require
    valid-user</code>.
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapbindauthoritative" id="authldapbindauthoritative">Directive</a> <a name="AuthLDAPBindAuthoritative" id="AuthLDAPBindAuthoritative">AuthLDAPBindAuthoritative</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si l'on doit utiliser d'autres fournisseurs
d'authentification lorsque le serveur ne peut pas valider les donnes
d'authentification de l'utilisateur, alors que ce dernier possde un
DN.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPBindAuthoritative<em>off|on</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPBindAuthoritative on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Par dfaut, des fournisseurs d'authentification sont appels
    si un utilisateur ne possde pas de DN, mais ne le sont pas si
    l'utilisateur possde un DN et si son mot de passe ne peut pas tre
    vrifi lors d'une connexion au serveur LDAP. Si la directive
    <code class="directive"><a href="#authldapbindauthoritative">AuthLDAPBindAuthoritative</a></code> est
    dfinie  <em>off</em>, d'autres modules d'authentification
    configurs auront une chance de valider le mot de passe de
    l'utilisateur si la tentative de connexion au serveur LDAP choue
    pour une raison quelconque (avec les donnes d'authentification
    fournies).</p>
    <p>Ceci permet aux utilisateurs prsent  la fois dans l'annuaire
    LDAP et dans un fichier <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code> de s'authentifier
    lorsque le serveur LDAP est disponible, alors que le compte de
    l'utilisateur est verrouill ou que son mot de passe est
    inutilisable pour une raison quelconque.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code></li>
<li><code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapbinddn" id="authldapbinddn">Directive</a> <a name="AuthLDAPBindDN" id="AuthLDAPBindDN">AuthLDAPBindDN</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Un DN optionnel pour se connecter au serveur
LDAP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPBindDN <em>dn</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Cette directive permet de dfinir un DN optionnel pour se
    connecter au serveur afin d'y rechercher des entres. Si aucun DN
    n'est spcifi, <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> tentera une
    connexion anonyme.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapbindpassword" id="authldapbindpassword">Directive</a> <a name="AuthLDAPBindPassword" id="AuthLDAPBindPassword">AuthLDAPBindPassword</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Mot de passe  utiliser en conjonction avec le DN de
connexion</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPBindPassword <em>mot-de-passe</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td><em>exec:</em> est disponible depuis la version 2.4.5 du
serveur HTTP Apache.</td></tr>
</table>
    <p>Cette directive permet de spcifier un mot de passe  utiliser en
    conjonction avec le DN de connexion. Notez que ce mot de passe
    constitue en gnral une donne sensible, et doit donc tre protg
    de manire approprie. Vous ne devez utiliser les directives
    <code class="directive"><a href="#authldapbinddn">AuthLDAPBindDN</a></code> et <code class="directive"><a href="#authldapbindpassword">AuthLDAPBindPassword</a></code> que si
    vous en avez vraiment besoin pour effectuer une recherche dans
    l'annuaire.</p>

    <p>Si la valeur spcifie dbute par "exec:", la commande qui suit sera
    excute, et la premire ligne renvoye par la commande sur la
    sortie standard sera utilise comme mot de passe.</p>
<pre class="prettyprint lang-config"># Mot de passe spcifi directement
AuthLDAPBindPassword secret

# Excution de /path/to/program pour obtenir le mot de passe
AuthLDAPBindPassword exec:/path/to/program

# Excution de /path/to/otherProgram avec un argument pour obtenir le mot de passe
AuthLDAPBindPassword "exec:/path/to/otherProgram argument1"</pre>



</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapcharsetconfig" id="authldapcharsetconfig">Directive</a> <a name="AuthLDAPCharsetConfig" id="AuthLDAPCharsetConfig">AuthLDAPCharsetConfig</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Chemin du fichier de configuration de la correspondance
langage/jeu de caractres</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPCharsetConfig <em>chemin-fichier</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>La directive <code class="directive">AuthLDAPCharsetConfig</code> permet
    de dfinir le chemin du fichier de configuration de la
    correspondance langage/jeu de caractres. <var>chemin-fichier</var>
    est un chemin relatif au rpertoire dfini par la directive
    <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code>. Ce fichier contient une liste
    de correspondances extension de langage/jeu de caractres. La
    plupart des administrateurs utilisent le fichier
    <code>charset.conv</code> fourni qui associe les extensions de
    langage courantes  leurs jeux de caractres.</p>

    <p>Le fichier contient des lignes au format suivant :</p>

    <div class="example"><p><code>
      <var>extension de langage</var> <var>jeu de caractres</var>
      [<var>Nom du langage</var>] ...
    </code></p></div>

    <p>L'extension est insensible  la casse. Les lignes vides et les
    lignes commenant par un dise (<code>#</code>) sont ignores.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapcompareasuser" id="authldapcompareasuser">Directive</a> <a name="AuthLDAPCompareAsUser" id="AuthLDAPCompareAsUser">AuthLDAPCompareAsUser</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilisation des donnes d'authentification de l'utilisateur
pour effectuer les comparaisons pour l'attribution des autorisations</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPCompareAsUser on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPCompareAsUser off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version version 2.3.6</td></tr>
</table>
    <p>Lorsque cette directive est dfinie, et si
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> a authentifi l'utilisateur, les
    recherches LDAP pour les autorisations utilisent le nom distinctif
    trouv (DN) et le mot de passe d'authentification basique HTTP de
    l'utilisateur authentifi au lieu des donnes d'authentification
    configures au niveau du serveur.</p>

    <p>Les vrifications d'autorisation <em>ldap-attribute</em>,
    <em>ldap-user</em>, et <em>ldap-group</em> (niveau simple seulement)
    utilisent des comparaisons.</p>

    <p>Cette directive n'a d'effet sur les comparaisons effectues au
    cours des traitements de groupe imbriqus, et lorsque la directive
    <code class="directive"><a href="#authldapsearchasuser">AuthLDAPSearchAsUser</a></code>
    est aussi active.</p>

    <p>Cette directive ne doit tre utilise que si votre serveur LDAP
     n'autorise pas les recherches anonymes, ou si vous ne pouvez pas
     utiliser de nom d'utilisateur ddi via la directive <code class="directive"><a href="#authldapbinddn">AuthLDAPBindDN</a></code>.
     </p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#authldapinitialbindasuser">AuthLDAPInitialBindAsUser</a></code></li>
<li><code class="directive"><a href="#authldapsearchasuser">AuthLDAPSearchAsUser</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapcomparednonserver" id="authldapcomparednonserver">Directive</a> <a name="AuthLDAPCompareDNOnServer" id="AuthLDAPCompareDNOnServer">AuthLDAPCompareDNOnServer</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise le serveur LDAP pour comparer les DNs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPCompareDNOnServer on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPCompareDNOnServer on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Lorsque cette directive est dfinie  on,
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> utilise le serveur LDAP pour
    comparer les DNs. Il s'agit de la seule mthode infaillible pour
    comparer les DNs. <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> va rechercher
    dans l'annuaire le DN spcifi par la directive <a href="#reqdn"><code>Require dn</code></a>, puis extraire ce DN et le
    comparer avec le DN extrait de l'entre de l'utilisateur. Si cette
    directive est  off, <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> effectue une
    simple comparaison de chanes. Cette dernire approche peut produire
    des faux ngatifs, mais elle est beaucoup plus rapide. Notez
    cependant que le cache de <code class="module"><a href="../mod/mod_ldap.html">mod_ldap</a></code> peut acclrer
    la comparaison de DNs dans la plupart des situations.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapdereferencealiases" id="authldapdereferencealiases">Directive</a> <a name="AuthLDAPDereferenceAliases" id="AuthLDAPDereferenceAliases">AuthLDAPDereferenceAliases</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td> quel moment le module va drfrencer les
alias</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPDereferenceAliases never|searching|finding|always</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPDereferenceAliases always</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier  quel moment
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> va drfrencer les alias au cours
    des oprations lies  LDAP. La valeur par dfaut est
    <code>always</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapgroupattribute" id="authldapgroupattribute">Directive</a> <a name="AuthLDAPGroupAttribute" id="AuthLDAPGroupAttribute">AuthLDAPGroupAttribute</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'attribut LDAP utilis pour vrifier l'appartenance d'un
utilisateur  un groupe.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPGroupAttribute <em>attribut</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPGroupAttribute member uniquemember</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Cette directive permet de spcifier quel attribut LDAP est
    utilis pour vrifier l'appartenance d'un utilisateur  un
    groupe. On peut spcifier plusieurs attributs en rptant cette
    directive plusieurs fois. Si la directive n'est pas dfinie,
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> utilise les attributs
    <code>member</code> et <code>uniquemember</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapgroupattributeisdn" id="authldapgroupattributeisdn">Directive</a> <a name="AuthLDAPGroupAttributeIsDN" id="AuthLDAPGroupAttributeIsDN">AuthLDAPGroupAttributeIsDN</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise le DN de l'utilisateur pour vrifier son
appartenance  un groupe</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPGroupAttributeIsDN on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPGroupAttributeIsDN on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Lorsqu'elle est dfinie  <code>on</code>, cette directive
    indique que c'est le DN de l'utilisateur qui doit tre utilis pour
    vrifier son appartenance  un groupe. Dans le cas contraire, c'est
    le nom de l'utilisateur qui sera utilis. Par exemple, supposons que
    le client envoie le nom d'utilisateur <code>bjenson</code>, qui
    correspond au DN LDAP <code>cn=Babs Jenson,o=Example</code>. Si la
    directive est  <code>on</code>, <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> va
    vrifier si <code>cn=Babs Jenson, o=Example</code> est un membre du
    groupe. Dans le cas contraire, <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code>
    vrifiera si <code>bjenson</code> est un membre du groupe.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapinitialbindasuser" id="authldapinitialbindasuser">Directive</a> <a name="AuthLDAPInitialBindAsUser" id="AuthLDAPInitialBindAsUser">AuthLDAPInitialBindAsUser</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine si le serveur effectue la recherche initiale du
DN en utilisant le nom propre de l'utilisateur pour l'authentification
de base
et non de manire anonyme, ou en utilisant des donnes d'authentification
codes en dur pour le serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPInitialBindAsUser <em>off|on</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPInitialBindAsUser off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.6</td></tr>
</table>
    <p>Par dfaut, le serveur convertit le nom d'utilisateur pour
    l'authentification de base en nom distinctif LDAP (DN) soit de
    manire anonyme, soit avec un couple nom/mot de passe ddi. Cette
    directive permet de forcer le serveur  utiliser les vritables nom
    d'utilisateur et mot de passe fournis par l'utilisateur pour
    effectuer la recherche initiale du DN.</p>

     <p>Si le nom d'utilisateur ne peut pas s'authentifier directement
     et ncessite de lgres modifications, voir la directive <code class="directive"><a href="#authldapinitialbindpattern">AuthLDAPInitialBindPattern</a></code>.</p>

     <p>Cette directive ne doit tre utilise que si votre serveur LDAP
     n'autorise pas les recherches anonymes, ou si vous ne pouvez pas
     utiliser de nom d'utilisateur ddi via la directive <code class="directive"><a href="#authldapbinddn">AuthLDAPBindDN</a></code>.
     </p>

     <div class="note"><h3>Non disponible dans la cas d'une autorisation seule</h3>
         On ne peut utiliser cette directive que si ce module
	 effectue une authentification, et n'a aucun effet si ce module
	 n'est utilis que pour les processus d'autorisation.
     </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#authldapinitialbindpattern">AuthLDAPInitialBindPattern</a></code></li>
<li><code class="directive"><a href="#authldapbinddn">AuthLDAPBindDN</a></code></li>
<li><code class="directive"><a href="#authldapcompareasuser">AuthLDAPCompareAsUser</a></code></li>
<li><code class="directive"><a href="#authldapsearchasuser">AuthLDAPSearchAsUser</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapinitialbindpattern" id="authldapinitialbindpattern">Directive</a> <a name="AuthLDAPInitialBindPattern" id="AuthLDAPInitialBindPattern">AuthLDAPInitialBindPattern</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie la modification a apporter au nom d'utilisateur
pour l'authentification de base lors de l'authentification auprs du
serveur LDAP pour effectuer une recherche de DN</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPInitialBindPattern<em><var>regex</var> <var>substitution</var></em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPInitialBindPattern (.*) $1 (nom de l'utilisateur
distant utilis tel quel)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.6</td></tr>
</table>
    <p>Si la directive <code class="directive"><a href="#authldapinitialbindasuser">AuthLDAPInitialBindAsUser</a></code> est
    dfinie  <em>ON</em>, le nom utilisateur pour l'authentification de
    base sera transform selon l'expression rationnelle
    <var>regex</var> et l'argument <var>substitution</var> spcifis.</p>

    <p>L'expression rationnelle est compare au nom d'utilisateur pour
    l'authentification de base courant. L'argument
    <var>substitution</var> peut contenir des rfrences arrires, mais
    n'effectue aucune autre interpolation de variable.</p>

    <p>Cette directive ne doit tre utilise que si votre serveur LDAP
     n'autorise pas les recherches anonymes, ou si vous ne pouvez pas
     utiliser de nom d'utilisateur ddi via la directive <code class="directive"><a href="#authldapbinddn">AuthLDAPBindDN</a></code>.
     </p>

    <pre class="prettyprint lang-config">AuthLDAPInitialBindPattern (.+) $1@example.com</pre>

    <pre class="prettyprint lang-config">AuthLDAPInitialBindPattern (.+) cn=$1,dc=example,dc=com</pre>


    <div class="note"><h3>Non disponible dans la cas d'une autorisation seule</h3>
         On ne peut utiliser cette directive que si ce module
	 effectue une authentification, et n'a aucun effet si ce module
	 n'est utilis que pour les processus d'autorisation.
     </div>
    <div class="note"><h3>Dbogage</h3>
        Le DN de substitution est enregistr dans la variable
	d'environnement <em>LDAP_BINDASUSER</em>. Si l'expression
	rationnelle ne convient pas, le nom d'utilisateur est utilis
	tel quel.
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="../mod/mod_authnnz_ldap.html#authldapinitialbindasuser">AuthLDAPInitialBindAsUser</a></code></li>
<li><code class="directive"><a href="../mod/mod_authnnz_ldap.html#authldapbinddn">AuthLDAPBindDN</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapmaxsubgroupdepth" id="authldapmaxsubgroupdepth">Directive</a> <a name="AuthLDAPMaxSubGroupDepth" id="AuthLDAPMaxSubGroupDepth">AuthLDAPMaxSubGroupDepth</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie la profondeur d'imbrication des sous-groupes
maximale prise en compte avant l'abandon de la recherche de
l'utilisateur.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPMaxSubGroupDepth <var>Nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPMaxSubGroupDepth 10</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.3.0 du serveur HTTP
Apache</td></tr>
</table>
   <p>Lorsque cette directive est dfinie  une valeur <code>X</code>
   non nulle, en combinaison avec l'utilisation de la directive
   <code>Require ldap-group DN-groupe</code>, les donnes de connexion
   fournies seront utilises pour vrifier l'appartenance de
   l'utilisateur  l'objet de l'annuaire <code>DN-groupe</code> ou 
   tout sous-groupe du groupe courant en tenant compte de la profondeur
   d'imbrication maximale <code>X</code> spcifie par la directive.</p>
   <p>Se rfrer  la section <a href="#reqgroup"><code>Require
   ldap-group</code></a> pour un exemple plus dtaill.</p>

   <div class="note"><h3>Performances dans le cas des groupes imbriqus</h3>
   <p>Lorsque les directives
   <code class="directive">AuthLDAPSubGroupAttribute</code> et
   <code class="directive">AuthLDAPGroupAttribute</code> se recouvrent (comme
   c'est le cas par dfaut et requis par les schmas LDAP courants), la
   recherche de sous-groupes au sein de grands groupes peut tre trs
   longue. Si vos groupes sont trs grands et non imbriqus, dfinissez
   la directive <code class="directive">AuthLDAPMaxSubGroupDepth</code>  0.</p>
   </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapremoteuserattribute" id="authldapremoteuserattribute">Directive</a> <a name="AuthLDAPRemoteUserAttribute" id="AuthLDAPRemoteUserAttribute">AuthLDAPRemoteUserAttribute</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie l'attribut dont la valeur renvoye au cours de la
requte de l'utilisateur sera utilise pour dfinir la variable
d'environnement REMOTE_USER</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPRemoteUserAttribute uid</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Lorsque cette directive est dfinie, la variable d'environnement
    <code>REMOTE_USER</code> sera dfinie  la valeur de l'attribut
    spcifi. Assurez-vous que cet attribut soit bien inclus dans la
    liste d'attributs spcifis dans la dfinition de AuthLDAPUrl ; dans
    le cas contraire, cette directive n'aurait aucun effet. Si elle est
    prsente, cette directive l'emporte sur AuthLDAPRemoteUserIsDN. Elle
    peut s'avrer utile par exemple, si vous souhaitez que les
    utilisateurs se connectent  un site web en utilisant leur adresse
    email, alors qu'une application sous-jacente ncessite un nom
    d'utilisateur comme identifiant.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapremoteuserisdn" id="authldapremoteuserisdn">Directive</a> <a name="AuthLDAPRemoteUserIsDN" id="AuthLDAPRemoteUserIsDN">AuthLDAPRemoteUserIsDN</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise le DN de l'utilisateur pour dfinir la variable
d'environnement REMOTE_USER</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPRemoteUserIsDN on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPRemoteUserIsDN off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Lorsque cette directive est  on, la variable d'environnement
    <code>REMOTE_USER</code> sera dfinie avec la valeur du DN complet
    de l'utilisateur authentifi, et non plus avec simplement le nom
    d'utilisateur fourni par le client. Elle est dfinie  off par
    dfaut.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapsearchasuser" id="authldapsearchasuser">Directive</a> <a name="AuthLDAPSearchAsUser" id="AuthLDAPSearchAsUser">AuthLDAPSearchAsUser</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise les donnes d'authentification de l'utilisateur
pour la recherche des autorisations</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPSearchAsUser on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPSearchAsUser off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.6</td></tr>
</table>
    <p>Lorsque cette directive est dfinie, et si
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> a authentifi l'utilisateur, les
    recherches LDAP pour dfinir les autorisations utilisent le nom
    distinctif (DN) trouv et le mot de passe pour l'authentification de
    base HTTP de l'utilisateur authentifi, au lieu des donnes
    d'authentification configures au niveau du serveur.</p>

    <p>Les vrifications d'autorisation <em>ldap-filter</em> et
    <em>ldap-dn</em> utilisent des recherches.</p>

    <p>Cette directive n'a d'effet sur les comparaisons effectues au
    cours des traitements de groupe imbriqus, et lorsque la directive
    <code class="directive"><a href="#authldapcompareasuser">AuthLDAPCompareAsUser</a></code>
    est aussi active.</p>

     <p>Cette directive ne doit tre utilise que si votre serveur LDAP
     n'autorise pas les recherches anonymes, ou si vous ne pouvez pas
     utiliser de nom d'utilisateur ddi via la directive <code class="directive"><a href="#authldapbinddn">AuthLDAPBindDN</a></code>.
     </p>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#authldapinitialbindasuser">AuthLDAPInitialBindAsUser</a></code></li>
<li><code class="directive"><a href="#authldapcompareasuser">AuthLDAPCompareAsUser</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapsubgroupattribute" id="authldapsubgroupattribute">Directive</a> <a name="AuthLDAPSubGroupAttribute" id="AuthLDAPSubGroupAttribute">AuthLDAPSubGroupAttribute</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie les noms d'attribut, un par directive, utiliss
pour diffrencier les membres du groupe courant qui sont eux-mmes des
groupes.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPSubGroupAttribute <em>attribut</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPSubgroupAttribute member uniquemember</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.3.0 du serveur HTTP
Apache</td></tr>
</table>
    <p>Un objet groupe LDAP peut contenir des membres qui sont des
    utilisateurs et des membres qui sont eux-mmes des groupes (appels
    sous-groupes ou groupes imbriqus). La directive
    <code>AuthLDAPSubGroupAttribute</code> spcifie l'attribut utilis
    pour identifier les groupes, alors que la directive
    <code>AuthLDAPGroupAttribute</code> spcifie l'attribut utilis
    pour identifier les utilisateurs. On peut spcifier plusieurs
    attributs en rptant la directive plusieurs fois. Si elle n'est pas
    dfinie, <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> utilise les attributs
    <code>member</code> et <code>uniqueMember</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapsubgroupclass" id="authldapsubgroupclass">Directive</a> <a name="AuthLDAPSubGroupClass" id="AuthLDAPSubGroupClass">AuthLDAPSubGroupClass</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie quelles valeurs d'objectClass LDAP identifient les
objets de l'annuaire qui sont des groupes au cours du traitement des
sous-groupes.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPSubGroupClass <em>ObjectClass-LDAP</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthLDAPSubGroupClass groupOfNames groupOfUniqueNames</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.3.0 du serveur HTTP
Apache</td></tr>
</table>
    <p>Un objet groupe LDAP peut contenir des membres qui sont des
    utilisateurs et des membres qui sont eux-mmes des groupes (appels
    sous-groupes ou groupes imbriqus). La directive
    <code>AuthLDAPSubGroupAttribute</code> permet d'identifier les
    membres qui sont des sous-groupes du groupe courant ( l'oppos des
    membres utilisateurs). La directive
    <code>AuthLDAPSubGroupClass</code> permet de spcifier les valeurs
    d'objectClass LDAP utilises pour vrifier que certains membres sont
    en fait des objets groupe. Les sous-groupes ainsi identifis peuvent
    alors faire l'objet d'une recherche d'autres membres utilisateurs ou
    sous-groupes. On peut spcifier plusieurs attributs en rptant
    cette directive plusieurs fois. Si cette directive n'est pas
    dfinie, <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> utilise les attributs
    <code>groupOfNames</code> et <code>groupOfUniqueNames</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authldapurl" id="authldapurl">Directive</a> <a name="AuthLDAPUrl" id="AuthLDAPUrl">AuthLDAPUrl</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'URL permettant de spcifier les paramtres de la
recherche LDAP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthLDAPUrl <em>url [NONE|SSL|TLS|STARTTLS]</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_ldap</td></tr>
</table>
    <p>Une URL conforme  la RFC 2255 qui permet de spcifier les
    paramtres  utiliser pour la recherche dans l'annuaire LDAP. La
    syntaxe de l'URL est :</p>
<div class="example"><p><code>ldap://hte:port/DN-de-base?attribut?porte?filtre</code></p></div>
    <p>Si vous souhaitez mettre  la disposition d'Apache plusieurs URLs
    LDAP, la syntaxe sera :</p>
<pre class="prettyprint lang-config">AuthLDAPUrl "ldap://ldap1.example.com ldap2.example.com/dc=..."</pre>

<p><em><strong>Mise en garde : </strong>Si vous spcifiez plusieurs
serveurs, vous devez en entourer la liste avec des guillemets ; dans le
cas contraire, vous gnrerez une erreur : "AuthLDAPURL takes one
argument, URL to define LDAP connection..".</em> Vous pouvez bien
entendu ajouter des paramtres de recherche  chacun des serveurs
spcifis.</p>

<dl>
<dt>ldap</dt>

        <dd>Pour ldap non scuris, utilisez la chane
	<code>ldap</code>. Pour ldap scuris, utilisez  la place la
	chane <code>ldaps</code>. LDAP scuris n'est disponible que si
	Apache a t li avec une bibliothque LDAP supportant SSL.</dd>

<dt>hte:port</dt>

        <dd>
          <p>Il s'agit du nom/port du serveur ldap
	  (dont la valeur par dfaut est
	  <code>localhost:389</code> pour <code>ldap</code>, et
	  <code>localhost:636</code> pour <code>ldaps</code>). Pour
	  spcifier plusieurs serveurs LDAP redondants, indiquez
	  simplement leur liste en les sparant par des espaces.
	  <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> tentera alors de se connecter
	   chacun des serveurs jusqu' ce qu'il parvienne  se
	  connecter avec succs. Notez qu'en cas de multiples serveurs
	  LDAP, l'ensemble de l'URL LDAP doit tre entoure de
	  guillemets.</p>

          <p>lorsqu'une connection a t tablie avec un serveur, elle
	  reste active pendant toute la dure de vie du processus
	  <code class="program"><a href="../programs/httpd.html">httpd</a></code>, ou jusqu' ce que le serveur LDAP
	  cesse de fonctionner.</p>

          <p>Si le serveur LDAP cesse de fonctionner, et ainsi
	  interrompt une
	  connexion existante, <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> tentera
	  de se reconnecter en commenant par le premier serveur de la
	  liste, et ainsi de suite avec les serveurs redondants
	  suivants. Notez que ce processus n'a rien  voir avec une
	  vritable recherche de type round-robin.</p>
        </dd>

<dt>DN-de-base</dt>
        <dd>Le DN de la branche de l'annuaire  partir de laquelle
	toutes les recherches seront lances. Il doit au moins
	correspondre  la racine de votre annuaire, mais vous pouvez
	aussi indiquer une branche plus spcifique.</dd>

<dt>attribut</dt>

        <dd>Il s'agit de l'attribut  utiliser pour la recherche.
	Bien que la RFC
	2255 autorise une liste d'attributs spars par des virgules,
	seul le premier sera retenu, sans tenir compte des autres
	attributs fournis. Si aucun attribut n'est fourni, l'attribut
	par dfaut est <code>uid</code>. Il est judicieux de choisir un
	attribut dont la valeur sera unique parmi toutes les entres de
	la branche de l'annuaire que vous aurez dfinie. Tous les
	attributs spcifis seront enregistrs dans des variables
	d'environnement avec le prfixe AUTHENTICATE_, afin de pouvoir
	tre utiliss par d'autres modules.</dd>

<dt>porte</dt>

        <dd>Il s'agit de la porte de la recherche. Elle peut prendre
	les valeurs <code>one</code> ou <code>sub</code>. Notez que la
	RFC 2255 supporte aussi une porte de valeur <code>base</code>,
	mais cette dernire n'est pas supporte par le module. Si la
	porte n'est pas dfinie, ou si elle est dfinie 
	<code>base</code>, c'est la valeur de porte par dfaut
	<code>sub</code> qui sera utilise.</dd>

<dt>filtre</dt>

        <dd>Il s'agit d'un filtre de recherche LDAP valide. Si aucun
	filtre n'est spcifi, le filtre par dfaut
	<code>(objectClass=*)</code> sera utilis, ce qui corrspond 
	une recherche de tous les types d'objets de l'arborescence. La
	taille des filtres est limite  environ 8000 caractres (valeur
	de la macro <code>MAX_STRING_LEN</code> dans le code source
	d'Apache), ce qui s'avre plus que suffisant pour la plupart des
	applications. Depuis la version 2.4.10, il est possible
	d'utiliser le paramtre "none" pour spcifier qu'aucun filtre
	n'est activ ; ce paramtre est obligatoire avec certains
	serveurs LDAP primitifs.</dd>
</dl>

    <p>Pour une recherche, les attribut, filtre et nom d'utilisateur
    fournis par le client HTTP sont combins pour crer un filtre de
    recherche du style :
    <code>(&amp;(<em>filtre</em>)(<em>attribut</em>
    =<em>nom-utilisateur</em>))</code>.</p>

    <p>Par exemple, considrons l'URL
    <code>ldap://ldap.example.com/o=Example?cn?sub?(posixid=*)</code>.
    Lorsqu'un client tentera de se connecter en utilisant le nom
    d'utilisateur <code>Babs Jenson</code>, le filtre de recherche sera
    : <code>(&amp;(posixid=*)(cn=Babs Jenson))</code>.</p>

    <p>On peut encore ajouter un paramtre optionnel pour permettre 
    l'URL LDAP de surcharger le type de connexion. Ce paramtre peut
    prendre l'une des valeurs suivantes :</p>

<dl>
    <dt>NONE</dt>
        <dd>tablit une connexion non scurise sur le port LDAP par
	dfaut, ce qui est quivalent  <code>ldap://</code> sur le port
	389.</dd>
    <dt>SSL</dt>
        <dd>tablit une connexion scurise sur le port LDAP scuris
	par dfaut, ce qui est quivalent  <code>ldaps://</code>.</dd>
    <dt>TLS | STARTTLS</dt>
        <dd>tablit une connexion scurise par lvation de niveau sur
	le port LDAP par dfaut. Cette connexion sera initialise sur le
	port 389 par dfaut, puis leve  un niveau de connexion
	scurise sur le mme port.</dd>
</dl>

    <p>Voir plus haut pour des exemples d'URLs dfinies par la directive
    <code class="directive"><a href="#authldapurl">AuthLDAPURL</a></code>.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authnz_ldap.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authnz_ldap.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authnz_ldap.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>