/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.CreationTool;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.FloatingTextField;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class TextTool
extends CreationTool {
    private FloatingTextField myTextField;
    private TextHolder myTypingTarget;
    private Figure mySelectedFigure;

    public TextTool(DrawingEditor drawingEditor, Figure figure) {
        super(drawingEditor, figure);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.setView((DrawingView)mouseEvent.getSource());
        if (this.getTypingTarget() != null) {
            this.editor().toolDone();
            return;
        }
        TextHolder textHolder = null;
        Figure figure = this.drawing().findFigureInside(n, n2);
        if (figure != null) {
            textHolder = figure.getTextHolder();
            this.setSelectedFigure(figure);
        }
        if (textHolder != null && textHolder.acceptsTyping()) {
            this.beginEdit(textHolder);
        } else {
            super.mouseDown(mouseEvent, n, n2);
            this.view().checkDamage();
            this.beginEdit(this.getCreatedFigure().getTextHolder());
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (!this.isActive()) {
            this.editor().toolDone();
        }
    }

    public void deactivate() {
        this.endEdit();
        super.deactivate();
    }

    public void activate() {
        super.activate();
    }

    public boolean isActive() {
        return this.getTypingTarget() != null;
    }

    protected void beginEdit(TextHolder textHolder) {
        if (this.getFloatingTextField() == null) {
            this.setFloatingTextField(this.createFloatingTextField());
        }
        if (textHolder != this.getTypingTarget() && this.getTypingTarget() != null) {
            this.endEdit();
        }
        this.getFloatingTextField().createOverlay((Container)((Object)this.view()), textHolder.getFont());
        this.getFloatingTextField().setBounds(this.fieldBounds(textHolder), textHolder.getText());
        this.setTypingTarget(textHolder);
    }

    protected void endEdit() {
        if (this.getTypingTarget() != null) {
            if (this.getAddedFigure() != null) {
                if (!this.isDeleteTextFigure()) {
                    this.setUndoActivity(this.createPasteUndoActivity());
                    this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
                    this.getTypingTarget().setText(this.getFloatingTextField().getText());
                }
            } else if (this.isDeleteTextFigure()) {
                this.setUndoActivity(this.createDeleteUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getSelectedFigure()));
                this.getUndoActivity().redo();
            } else {
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getTypingTarget().getRepresentingFigure()));
                this.getTypingTarget().setText(this.getFloatingTextField().getText());
                ((UndoActivity)this.getUndoActivity()).setBackupText(this.getTypingTarget().getText());
            }
            this.setTypingTarget(null);
            this.getFloatingTextField().endOverlay();
        } else {
            this.setUndoActivity(null);
        }
        this.setAddedFigure(null);
        this.setCreatedFigure(null);
        this.setSelectedFigure(null);
    }

    protected boolean isDeleteTextFigure() {
        return this.getFloatingTextField().getText().length() == 0;
    }

    private Rectangle fieldBounds(TextHolder textHolder) {
        Rectangle rectangle = textHolder.textDisplayBox();
        int n = textHolder.overlayColumns();
        Dimension dimension = this.getFloatingTextField().getPreferredSize(n);
        return new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height);
    }

    protected void setTypingTarget(TextHolder textHolder) {
        this.myTypingTarget = textHolder;
    }

    protected TextHolder getTypingTarget() {
        return this.myTypingTarget;
    }

    private void setSelectedFigure(Figure figure) {
        this.mySelectedFigure = figure;
    }

    protected Figure getSelectedFigure() {
        return this.mySelectedFigure;
    }

    private FloatingTextField createFloatingTextField() {
        return new FloatingTextField();
    }

    private void setFloatingTextField(FloatingTextField floatingTextField) {
        this.myTextField = floatingTextField;
    }

    protected FloatingTextField getFloatingTextField() {
        return this.myTextField;
    }

    protected Undoable createDeleteUndoActivity() {
        DeleteCommand deleteCommand = new DeleteCommand("Delete", this.editor());
        return new DeleteCommand.UndoActivity(deleteCommand);
    }

    protected Undoable createPasteUndoActivity() {
        return new PasteCommand.UndoActivity(this.view());
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getTypingTarget().getText());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private String myOriginalText;
        private String myBackupText;

        public UndoActivity(DrawingView drawingView, String string) {
            super(drawingView);
            this.setOriginalText(string);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.setText(this.getOriginalText());
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.setText(this.getBackupText());
            return true;
        }

        protected boolean isValidText(String string) {
            return string != null && string.length() > 0;
        }

        protected void setText(String string) {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (figure.getTextHolder() == null) continue;
                figure.getTextHolder().setText(string);
            }
        }

        public void setBackupText(String string) {
            this.myBackupText = string;
        }

        public String getBackupText() {
            return this.myBackupText;
        }

        public void setOriginalText(String string) {
            this.myOriginalText = string;
        }

        public String getOriginalText() {
            return this.myOriginalText;
        }
    }
}

