/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.state;

import com.nvidia.cuda.ide.debug.mi.vo.UncoalescedWarpInfo;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRange;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.ElementQuery;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.model.query.LogicalVerticalCondition;
import com.nvidia.cuda.ide.debug.model.state.ICudaQueries;
import com.nvidia.cuda.ide.debug.model.state.SourceLocation;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class WarpsStateManager {
    private final ICudaApplication application;
    private final ICudaQueries queries;
    private final ConcurrentMap<Integer, UncoalescedWarpInfo> warpRecords = new ConcurrentHashMap<Integer, UncoalescedWarpInfo>();

    public WarpsStateManager(ICudaApplication application, ICudaQueries queries) {
        this.application = application;
        this.queries = queries;
    }

    public void ensureWarpsUpToDate(IDMContext ctx, short deviceId, short sm, short warp, RequestMonitor rm) {
        int key = Warp.getWarpKey(deviceId, sm, warp);
        if (!this.warpRecords.containsKey(key)) {
            this.queries.queryWarps(ctx, deviceId, sm, new WarpsReconciler((Executor)this.queries.getExecutor(), key, rm, sm, deviceId));
            return;
        }
        rm.done();
    }

    protected void fillWarpState(Warp warp, final DataRequestMonitor<CudaRuntimeInformation> rm) {
        short deviceId = warp.getDeviceId();
        short smId = warp.getSMId();
        short id = warp.getId();
        int key = WarpsStateManager.createWarpKey(warp);
        final CudaRuntimeInformation info = new CudaRuntimeInformation(deviceId, smId, id, -1, CudaThreadState.RUNNING);
        UncoalescedWarpInfo warpInfo = (UncoalescedWarpInfo)this.warpRecords.get(key);
        long activeLanes = warpInfo.getActiveLanesMask();
        info.setActiveLanes(DebugUtil.bitCount(activeLanes));
        info.setDivergentLanes(DebugUtil.bitCount(warpInfo.getDivergentLanesMask()));
        Kernel kernel = this.application.getKernel(warpInfo.getKernelId());
        if (kernel != null) {
            info.setKernelId((short)kernel.getId());
            info.setBlockIdx(warpInfo.getBlockIdx());
            this.application.getSourceLocation(warp, deviceId, smId, warp.getId(), DebugUtil.findFirstBit(activeLanes), new DataRequestMonitor<SourceLocation>((Executor)this.queries.getExecutor(), rm){

                protected void handleSuccess() {
                    if (this.getData() != null) {
                        info.setSourceLocation((SourceLocation)this.getData());
                    }
                    rm.setData((Object)info);
                    rm.done();
                }
            });
        } else {
            rm.setData((Object)info);
            rm.done();
        }
    }

    public void getWarpState(final Warp warp, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.ensureWarpsUpToDate(warp, warp.getDeviceId(), warp.getSMId(), warp.getId(), new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                WarpsStateManager.this.fillWarpState(warp, (DataRequestMonitor<CudaRuntimeInformation>)this.val$rm);
            }
        });
    }

    public void invalidate() {
        this.warpRecords.clear();
    }

    protected void parseWarpsState(short deviceId, short sm, UncoalescedWarpInfo[] warps) {
        UncoalescedWarpInfo[] uncoalescedWarpInfoArray = warps;
        int n = warps.length;
        int n2 = 0;
        while (n2 < n) {
            UncoalescedWarpInfo entry = uncoalescedWarpInfoArray[n2];
            int key = Warp.getWarpKey(deviceId, sm, entry.getWarp());
            this.warpRecords.put(key, entry);
            ++n2;
        }
    }

    public CudaThreadState getLaneState(Warp warp, short id) {
        UncoalescedWarpInfo warpInfo = (UncoalescedWarpInfo)this.warpRecords.get(WarpsStateManager.createWarpKey(warp));
        if (warpInfo != null) {
            long laneMask = 1L << id;
            if ((warpInfo.getDivergentLanesMask() & laneMask) != 0L) {
                return CudaThreadState.DIVERGENT;
            }
            if ((warpInfo.getActiveLanesMask() & laneMask) != 0L) {
                return CudaThreadState.RUNNING;
            }
        }
        return CudaThreadState.INACTIVE;
    }

    private static int createWarpKey(Warp warp) {
        return Warp.getWarpKey(warp.getDeviceId(), warp.getSMId(), warp.getId());
    }

    public long getWarpPC(short device, short sm, short warp) {
        return ((UncoalescedWarpInfo)this.warpRecords.get(Warp.getWarpKey(device, sm, warp))).getPC();
    }

    public CudaThreadState getLaneState(short device, short sm, short warp, short lane) {
        int key = Warp.getWarpKey(device, sm, warp);
        Long divergence = ((UncoalescedWarpInfo)this.warpRecords.get(key)).getDivergentLanesMask();
        if (divergence != null) {
            boolean laneFlag = (divergence >> lane & 1L) == 1L;
            return laneFlag ? CudaThreadState.DIVERGENT : CudaThreadState.RUNNING;
        }
        return CudaThreadState.RUNNING;
    }

    public void buildWarpQuery(final Warp warp, final IElementQuery query, final DataRequestMonitor<IElementQuery> rm) {
        final byte[] lanes = query.filterLanes(warp);
        if (lanes != null && lanes.length == 0) {
            rm.setData((Object)ElementQuery.NONE);
            rm.done();
        }
        try {
            warp.getLane((short)0).getState(new DataRequestMonitor<CudaRuntimeInformation>((Executor)this.queries.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)WarpsStateManager.this.buildQuery(warp, query, lanes, (CudaRuntimeInformation)this.getData()));
                    rm.done();
                }
            });
        }
        catch (CudaException e) {
            rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
        }
    }

    protected IElementQuery buildQuery(Warp warp, IElementQuery query, byte[] lanes, CudaRuntimeInformation data) {
        UncoalescedWarpInfo info = (UncoalescedWarpInfo)this.warpRecords.get(WarpsStateManager.createWarpKey(warp));
        long kernel = info.getKernelId();
        if (kernel < 0L) {
            return ElementQuery.NONE;
        }
        CudaDim dim = ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)warp, ICudaApplication.class)).getKernel(kernel).getBlockDim();
        long ordinal = dim.getOrdinal(data.getThreadIdx());
        Device device = (Device)DMContexts.getAncestorOfType((IDMContext)warp, Device.class);
        if (lanes == null) {
            long endOrdinal = ordinal + (long)device.getLaneCount() - 1L;
            int dimMax = dim.elementCount() - 1;
            CudaCoord end = dim.getCoord(Math.min(endOrdinal, (long)dimMax));
            return new ElementQuery(new LogicalVerticalCondition(kernel, info.getBlockIdx(), new CudaRange(data.getThreadIdx(), end)));
        }
        IElementQuery[] queries = new IElementQuery[lanes.length];
        int i = 0;
        byte[] byArray = lanes;
        int n = lanes.length;
        int n2 = 0;
        while (n2 < n) {
            byte id = byArray[n2];
            CudaCoord c = dim.getCoord(ordinal + (long)id);
            queries[i++] = new ElementQuery(new LogicalVerticalCondition(kernel, info.getBlockIdx(), c));
            ++n2;
        }
        IElementQuery q = ElementQuery.or(queries);
        return q;
    }

    private final class WarpsReconciler
    extends DataRequestMonitor<UncoalescedWarpInfo[]> {
        private final short deviceId;
        private final int key;
        private final RequestMonitor rm;
        private final short sm;

        private WarpsReconciler(Executor executor, int key, RequestMonitor rm, short sm, short deviceId) {
            super(executor, rm);
            this.key = key;
            this.rm = rm;
            this.sm = sm;
            this.deviceId = deviceId;
        }

        protected void handleSuccess() {
            if (this.isSuccess() && !WarpsStateManager.this.warpRecords.containsKey(this.key)) {
                WarpsStateManager.this.parseWarpsState(this.deviceId, this.sm, (UncoalescedWarpInfo[])this.getData());
            }
            this.rm.done();
        }
    }
}

