/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.model.RegionOfInterest;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineRuler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.Disposable;
import org.eclipse.jface.action.Action;

public class DeleteRegionOfInterestAction
extends Action
implements Disposable {
    private Session session;
    private final boolean deleteAll;

    public DeleteRegionOfInterestAction(Session session, boolean deleteAll) {
        super(deleteAll ? ViperMessages.DeleteAllRegionOfInterest_Label : ViperMessages.DeleteSelectedRegionOfInterest_Label);
        this.session = session;
        this.deleteAll = deleteAll;
        this.setToolTipText(deleteAll ? ViperMessages.DeleteAllRegionOfInterest_Tooltip : ViperMessages.DeleteSelectedRegionOfInterest_Tooltip);
        this.setId(deleteAll ? "com.nvidia.viper.deleteallroi" : "com.nvidia.viper.deleteselroi");
    }

    public void dispose() {
        this.session = null;
    }

    public void run() {
        TimelineRuler ruler = this.session.getHorizontalRuler();
        if (ruler != null) {
            List<RegionOfInterest> rois = ruler.getRegionsOfInterest();
            ArrayList<RegionOfInterest> deleteRois = new ArrayList<RegionOfInterest>(rois.size());
            for (RegionOfInterest roi : rois) {
                if (!this.deleteAll && !roi.isSelected()) continue;
                deleteRois.add(roi);
            }
            ruler.removeRegionsOfInterest(deleteRois);
        }
    }
}

