/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.editor.RulerColumnBase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class BarChartColumn
extends RulerColumnBase {
    public static final int DEFAULT_WIDTH = 110;
    private static final int BAR_HMARGIN = 5;
    private static final int BAR_VMARGIN = 2;
    public static final String COLUMN_HEADER = "Execution Count";

    public BarChartColumn() {
        this(110);
    }

    public BarChartColumn(int width) {
        this.setWidth(width);
    }

    @Override
    protected String getToolTipText(int lineNumber) {
        if (this.viewer != null && this.viewer.getInstructionExecuted(lineNumber) > 0L) {
            int inactivePercent = this.getInactiveThreadRatio(lineNumber, 100L);
            int predOffPercent = this.getPredOffThreadRatio(lineNumber, 100L);
            int activePercent = 100 - inactivePercent - predOffPercent;
            long totalThreads = this.viewer.getInstructionExecuted(lineNumber) * 32L;
            long inactiveThreads = this.getInactiveThreadRatio(lineNumber, totalThreads);
            long predOffThreads = this.getPredOffThreadRatio(lineNumber, totalThreads);
            long activeThreads = totalThreads - inactiveThreads - predOffThreads;
            if (predOffPercent >= 0 && inactivePercent >= 0 && activePercent >= 0) {
                String tooltipStr = String.format(ViperMessages.SourceSassBarChart_Tooltip, inactivePercent, inactiveThreads, totalThreads, predOffPercent, predOffThreads, totalThreads, activePercent, activeThreads, totalThreads);
                return tooltipStr;
            }
        }
        return null;
    }

    private int getInactiveThreadRatio(int line, long factor) {
        long instructionExecuted = this.viewer.getInstructionExecuted(line);
        if (instructionExecuted > 0L) {
            long totalThreads = instructionExecuted * 32L;
            long inactiveThreads = totalThreads - this.viewer.getThreadInstructionExecuted(line);
            int inactive = (int)((double)inactiveThreads / (double)totalThreads * (double)factor);
            return inactive;
        }
        return 0;
    }

    private int getPredOffThreadRatio(int line, long factor) {
        long instructionExecuted = this.viewer.getInstructionExecuted(line);
        if (instructionExecuted > 0L) {
            long totalThreads = instructionExecuted * 32L;
            long inactiveThreads = totalThreads - this.viewer.getThreadInstructionExecuted(line);
            long predFalseThreads = totalThreads - inactiveThreads - this.viewer.getNoPredicateOff(line);
            int predFalse = (int)((double)predFalseThreads / (double)totalThreads * (double)factor);
            return predFalse;
        }
        return 0;
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        super.paintLine(gc, modelLine, widgetLine, linePixel, lineHeight);
        if (this.viewer != null && this.viewer.getInstructionExecuted(widgetLine) > 0L) {
            int activeWidth;
            int predFalseWidth;
            int barBorderY = linePixel + 2;
            int maxWidth = this.getWidth() - 10;
            int height = lineHeight - 4;
            int barWidth = this.getRelativeWidth(widgetLine, maxWidth);
            int inactiveWidth = this.getInactiveThreadRatio(widgetLine, barWidth);
            if (inactiveWidth > 0) {
                gc.setBackground(ViperColors.COLOR_INACTIVE_THREADS);
                gc.fillRectangle(5, barBorderY, inactiveWidth, height);
            }
            if ((predFalseWidth = this.getPredOffThreadRatio(widgetLine, barWidth)) > 0) {
                gc.setBackground(ViperColors.COLOR_PRED_OFF_THREADS);
                gc.fillRectangle(5 + inactiveWidth, barBorderY, predFalseWidth, height);
            }
            if ((activeWidth = barWidth - inactiveWidth - predFalseWidth) > 0) {
                gc.setBackground(new Color(null, 128, 255, 128));
                gc.fillRectangle(5 + inactiveWidth + predFalseWidth, barBorderY, activeWidth, height);
            }
            gc.setForeground(ViperColors.COLOR_GRAPH_BORDER);
            gc.drawRectangle(5, barBorderY, maxWidth, height);
            this.drawMarkerAtEnd(widgetLine, gc, this.viewer, this.getWidth() - 1, lineHeight + linePixel, this.getWidth() - 1, barBorderY);
        }
    }

    private int getRelativeWidth(int widgetLine, int maxWidth) {
        return (int)((double)this.viewer.getInstructionExecuted(widgetLine) * (double)maxWidth / (double)this.viewer.getMaxInstructionExecuted());
    }

    @Override
    protected void updateColumn() {
        this.redraw();
    }

    @Override
    public int getColumnIndex() {
        return 5;
    }

    @Override
    protected boolean isHotspotPresent() {
        return AnalysisResultSourceLevelKind.INSTRUCTION_EXECUTION_KIND.equals((Object)this.viewer.getCurrentAnnotationKind());
    }
}

