/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ManagedCProjectNature
implements IProjectNature {
    public static final String BUILDER_NAME = "genmakebuilder";
    public static final String BUILDER_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "." + "genmakebuilder";
    public static final String MNG_NATURE_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".managedBuildNature";
    private IProject project;

    public static void addManagedNature(IProject project, IProgressMonitor monitor) throws CoreException {
        ManagedCProjectNature.addNature(project, MNG_NATURE_ID, monitor);
    }

    public static void addManagedBuilder(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            ICommand command = commands[i];
            if (command.getBuilderName().equals("org.eclipse.cdt.core.cbuilder")) {
                Vector<ICommand> vec = new Vector<ICommand>(Arrays.asList(commands));
                vec.removeElementAt(i);
                vec.trimToSize();
                ICommand[] tempCommands = vec.toArray(new ICommand[commands.length - 1]);
                description.setBuildSpec(tempCommands);
                break;
            }
            ++i;
        }
        commands = description.getBuildSpec();
        boolean found = false;
        int i2 = 0;
        while (i2 < commands.length) {
            if (commands[i2].getBuilderName().equals(ManagedCProjectNature.getBuilderID())) {
                found = true;
                break;
            }
            ++i2;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(ManagedCProjectNature.getBuilderID());
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (natureId.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static IProjectDescription setBuildSpec(IProjectDescription description, ICommand newCommand) {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldCommand = ManagedCProjectNature.getBuildSpec(description, newCommand.getBuilderName());
        if (oldCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = newCommand;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i].getBuilderName().equals(oldCommand.getBuilderName())) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        return description;
    }

    public static ICommand getBuildSpec(IProjectDescription description, String builderID) {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public static String getBuilderID() {
        ManagedBuilderCorePlugin.getDefault();
        if (Platform.getExtensionRegistry().getExtension(BUILDER_NAME) != null) {
            return String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "." + BUILDER_NAME;
        }
        return BUILDER_ID;
    }

    public void configure() throws CoreException {
        ManagedCProjectNature.addManagedBuilder(this.project, (IProgressMonitor)new NullProgressMonitor());
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public static void removeManagedNature(IProject project, IProgressMonitor mon) throws CoreException {
        ManagedCProjectNature.removeNature(project, MNG_NATURE_ID, mon);
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
        newNatures.remove(natureId);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, monitor);
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

