/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.core.runtime.IPath;

public class MacroEntry
extends APathEntry
implements IMacroEntry {
    String macroName;
    String macroValue;

    public MacroEntry(IPath path, IPath baseRef, String macroName, String macroValue, IPath[] exclusionPatterns, boolean isExported) {
        super(64, null, baseRef, path, exclusionPatterns, isExported);
        if (macroName == null) {
            throw new IllegalArgumentException("Macro name cannot be null");
        }
        this.macroName = macroName;
        this.macroValue = macroValue == null ? "" : macroValue;
    }

    @Override
    public String getMacroName() {
        return this.macroName;
    }

    @Override
    public String getMacroValue() {
        return this.macroValue;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.macroName == null ? 0 : this.macroName.hashCode());
        result = 31 * result + (this.macroValue == null ? 0 : this.macroValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IMacroEntry) {
            IMacroEntry otherEntry = (IMacroEntry)obj;
            if (!super.equals(otherEntry)) {
                return false;
            }
            if (this.macroName == null ? otherEntry.getMacroName() != null : !this.macroName.equals(otherEntry.getMacroName())) {
                return false;
            }
            return !(this.macroValue == null ? otherEntry.getMacroValue() != null : !this.macroValue.equals(otherEntry.getMacroValue()));
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.macroName != null && this.macroName.length() > 0) {
            sb.append(" name:").append(this.macroName);
        }
        if (this.macroValue != null && this.macroValue.length() > 0) {
            sb.append(" value:").append(this.macroValue);
        }
        return sb.toString();
    }
}

