/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxContainer;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxMacroExpansion;

class ASTMacroExpansionLocation
implements IASTMacroExpansionLocation,
IASTMacroExpansion {
    private LocationCtxMacroExpansion fContext;
    private int fOffset;
    private int fLength;

    public ASTMacroExpansionLocation(LocationCtxMacroExpansion macroExpansionCtx, int offset, int length) {
        this.fContext = macroExpansionCtx;
        this.fOffset = offset;
        this.fLength = length;
    }

    @Override
    public IASTPreprocessorMacroExpansion getExpansion() {
        return this.fContext.getExpansion();
    }

    @Override
    public IASTNodeLocation[] getExpansionLocations() {
        IASTNodeLocation[] iASTNodeLocationArray;
        IASTFileLocation fl = this.asFileLocation();
        if (fl == null) {
            iASTNodeLocationArray = new IASTNodeLocation[]{};
        } else {
            IASTNodeLocation[] iASTNodeLocationArray2 = new IASTNodeLocation[1];
            iASTNodeLocationArray = iASTNodeLocationArray2;
            iASTNodeLocationArray2[0] = fl;
        }
        return iASTNodeLocationArray;
    }

    @Override
    public IASTPreprocessorMacroDefinition getMacroDefinition() {
        return this.fContext.getMacroDefinition();
    }

    @Override
    public IASTName getMacroReference() {
        return this.fContext.getMacroReference();
    }

    @Override
    public IASTFileLocation asFileLocation() {
        return ((LocationCtxContainer)this.fContext.getParent()).createFileLocation(this.fContext.fOffsetInParent, this.fContext.fEndOffsetInParent - this.fContext.fOffsetInParent);
    }

    @Override
    public int getNodeLength() {
        return this.fLength;
    }

    @Override
    public int getNodeOffset() {
        return this.fOffset;
    }

    public String toString() {
        return String.valueOf(this.fContext.getMacroDefinition().getName().toString()) + "[" + this.fOffset + "," + (this.fOffset + this.fLength) + "]";
    }

    public IASTImageLocation getImageLocation() {
        return this.fContext.getImageLocation(this.fOffset, this.fLength);
    }
}

