/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.regex.Pattern;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.TextualPropertyType;
import org.eclipse.birt.report.model.util.StyleUtil;

public class StringPropertyType
extends TextualPropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.string";
    private static final String HIDE_RULE_FORMAT_PATTERN = "[$_a-zA-Z][\\.$_a-zA-Z0-9]*";
    private static final Pattern hideRuleFormatPattern = Pattern.compile("[$_a-zA-Z][\\.$_a-zA-Z0-9]*", 2);

    public StringPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    @Override
    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        String stringValue = this.trimString(value.toString(), defn.getTrimOption());
        if ("fontFamily".equals(defn.getName())) {
            return StyleUtil.handleFontFamily(defn, stringValue);
        }
        if ("format".equals(defn.getName())) {
            IStructureDefn hideRuleStruct = MetaDataDictionary.getInstance().getStructure("HideRule");
            IPropertyDefn formatProperty = null;
            if (hideRuleStruct != null) {
                formatProperty = hideRuleStruct.getMember("format");
            }
            if (defn == formatProperty) {
                return this.validateHideRuleFormat(stringValue);
            }
        }
        return stringValue;
    }

    private Object validateHideRuleFormat(String value) throws PropertyValueException {
        if (StringUtil.isBlank(value)) {
            return value;
        }
        if (!hideRuleFormatPattern.matcher(value).matches()) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", this.getTypeCode());
        }
        return value;
    }

    @Override
    public int getTypeCode() {
        return 0;
    }

    @Override
    public String getName() {
        return "string";
    }

    @Override
    public double toDouble(Module module, Object value) {
        return 0.0;
    }

    @Override
    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.decode((String)value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

