/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard.project;

import com.nvidia.cuda.ide.build.core.Cpu;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTarget;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTargetsList;
import com.nvidia.cuda.ide.wizard.ICudaGetLocalArchitecture;
import java.net.URI;
import java.util.Collections;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.ui.wizards.CDTMainWizardPage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class RemoteConfigWizardPage
extends WizardPage
implements ICudaGetLocalArchitecture {
    private RemoteTargetsList body;
    private RemoteTarget localTarget;
    private final CDTMainWizardPage firstPage;

    public RemoteConfigWizardPage(CDTMainWizardPage firstPage) {
        super("Remote Systems", "Target Systems", null);
        this.firstPage = firstPage;
        this.setDescription("Select project build target systems");
    }

    public void createControl(Composite parent) {
        this.body = new RemoteTargetsList(parent, 0, true);
        this.localTarget = RemoteTarget.forConnection(this.body, null, null, null);
        this.body.setTargets(Collections.singleton(this.localTarget));
        new DataBindingContext().bindValue(this.body.getStatus(), (IObservableValue)new StatusObservable());
        this.setControl((Control)this.body);
    }

    private static String getTCName() {
        Object obj = MBSCustomPageManager.getPageProperty((String)"org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", (String)"toolchain");
        if (!(obj instanceof Iterable)) {
            return null;
        }
        for (Object o : (Iterable)obj) {
            if (!(o instanceof IToolChain)) continue;
            return ((IToolChain)o).getName();
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            URI location = this.firstPage.getProjectLocation();
            String projectLocation = location != null ? location.getPath() : this.firstPage.getLocationPath().append(this.firstPage.getProjectName()).toOSString();
            this.body.setLocalProjectLocation(projectLocation);
            this.localTarget.setProjectLocation(projectLocation);
            this.localTarget.setToolkitName(RemoteConfigWizardPage.getTCName());
        }
        super.setVisible(visible);
    }

    public void setup(IProject project) {
        this.body.setup(project);
    }

    public String getLocalArchitecture() {
        Cpu cpu = this.localTarget.getCpu();
        if (cpu == Cpu.ARM) {
            return "armv7l";
        }
        return "native";
    }

    public class StatusObservable
    extends AbstractObservableValue
    implements IObservableValue {
        public Object getValueType() {
            return IStatus.class;
        }

        protected Object doGetValue() {
            throw new UnsupportedOperationException();
        }

        protected void doSetValue(Object value) {
            IStatus status = (IStatus)value;
            if (status != null && status.getSeverity() == 4) {
                RemoteConfigWizardPage.this.setErrorMessage(status.getMessage());
                RemoteConfigWizardPage.this.setPageComplete(false);
            } else {
                RemoteConfigWizardPage.this.setErrorMessage(null);
                RemoteConfigWizardPage.this.setPageComplete(true);
            }
        }
    }
}

