/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.launch;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.Messages;
import com.nvidia.cuda.ide.remote.internal.ui.launch.AbstractRemoteTab;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.RemoteConnectionToolkitWizard;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import com.nvidia.cuda.ide.remote.ui.launch.LaunchMode;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class RemoteRunTab
extends AbstractRemoteTab {
    private Button btnManageToolkits;
    private Text commands = null;
    private ICudaToolkit toolkit = null;
    private Text toolkits;
    private ICudaRemoteDebugConstants.ExecutableTransferMode cached;

    @Override
    protected void apply(ILaunchConfigurationWorkingCopy config) {
        if (this.commands != null) {
            config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, this.commands.getText());
        }
    }

    @Override
    protected void connectionSelected(IStructuredSelection selection) {
        IRemoteConnection connection = (IRemoteConnection)CoreUtil.getSelectedObject((ISelection)selection, IRemoteConnection.class);
        this.setToolkit(this.getToolkit(connection));
        this.btnManageToolkits.setEnabled(connection != null);
    }

    public void createControl(Composite parent) {
        Composite pane = new Composite(parent, 0);
        this.setControl((Control)pane);
        pane.setLayout((Layout)new GridLayout(3, false));
        this.createConnectionsCombo(pane);
        Label lblNewLabel = new Label(pane, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText(Messages.RemoteExecutableTab_label_remote_toolkit);
        this.toolkits = new Text(pane, 2056);
        this.toolkits.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnManageToolkits = new Button(pane, 0);
        this.btnManageToolkits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteRunTab.this.manageToolkits();
            }
        });
        this.btnManageToolkits.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnManageToolkits.setText(Messages.RemoteExecutableTab_button_manage);
        this.createButtons(pane);
        this.createRemoteExecutableEntry(pane);
        if ("debug".equals(this.getLaunchConfigurationDialog().getMode())) {
            this.createPortEntry(pane);
            Label lblAdditionalCommandsTo = new Label(pane, 0);
            lblAdditionalCommandsTo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
            lblAdditionalCommandsTo.setText(Messages.RemoteExecutableTab_label_prelaunch_commands);
            this.commands = new Text(pane, 2048);
            this.commands.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RemoteRunTab.this.validate();
                }
            });
            GridData gd_commands = new GridData(4, 0x1000000, true, false, 3, 1);
            gd_commands.widthHint = 50;
            this.commands.setLayoutData((Object)gd_commands);
        }
        this.selectConnection((IStructuredSelection)StructuredSelection.EMPTY);
    }

    @Override
    protected String getPageId() {
        return "com.nvidia.cuda.ide.remote.remoteSystem";
    }

    @Override
    protected ICudaRemoteDebugConstants.ExecutableTransferMode getSelectedTransfer(ICudaRemoteDebugConstants.ExecutableTransferMode selectedMode) {
        if (this.isDebugging()) {
            return super.getSelectedTransfer(selectedMode);
        }
        return selectedMode == ICudaRemoteDebugConstants.ExecutableTransferMode.Upload ? ICudaRemoteDebugConstants.ExecutableTransferMode.Upload : this.cached;
    }

    private boolean isDebugging() {
        return LaunchMode.fromPlatformString(this.getLaunchConfigurationDialog().getMode()) == LaunchMode.DEBUG;
    }

    @Override
    protected ICudaRemoteDebugConstants.ExecutableTransferMode getLaunchConfigurationTransferMode(ILaunchConfiguration config) {
        ICudaRemoteDebugConstants.ExecutableTransferMode mode = super.getLaunchConfigurationTransferMode(config);
        this.cached = mode == ICudaRemoteDebugConstants.ExecutableTransferMode.Upload ? ICudaRemoteDebugConstants.ExecutableTransferMode.Download : mode;
        if (this.isDebugging() || mode == ICudaRemoteDebugConstants.ExecutableTransferMode.Upload) {
            return mode;
        }
        return ICudaRemoteDebugConstants.ExecutableTransferMode.Download;
    }

    @Override
    protected void initialize(ILaunchConfiguration config, IRemoteConnection connection) throws CoreException {
        if (this.commands != null) {
            this.commands.setText(config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, ""));
        }
        this.setToolkit(this.getToolkit(connection));
    }

    private ICudaToolkit getToolkit(final IRemoteConnection connection) {
        if (connection != null) {
            try {
                return (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                    public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                        return service.getToolkit(connection.getName());
                    }
                });
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
                return null;
            }
        }
        return null;
    }

    private void manageToolkits() {
        IRemoteConnection connection = this.connections.getSelection();
        if (connection != null) {
            RemoteConnectionToolkitWizard wizard = new RemoteConnectionToolkitWizard(connection);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                this.setToolkit(wizard.getCudaToolkit());
            }
        }
    }

    private void setToolkit(ICudaToolkit toolkit) {
        this.toolkit = toolkit;
        this.toolkits.setText(toolkit != null ? toolkit.getName() : "");
        this.validate();
    }

    @Override
    protected String validateChild() {
        if (this.toolkit == null) {
            return Messages.RemoteExecutableTab_error_no_toolkit_selected;
        }
        return null;
    }

    @Override
    protected Button[] createTransferButtons(final Composite composite) {
        return LaunchMode.fromPlatformString(this.getLaunchConfigurationDialog().getMode()).visit(new LaunchMode.Visitor<Button[]>(){

            @Override
            public Button[] debug() {
                return new Button[]{RemoteRunTab.this.createButton(composite, Messages.RemoteDebug_mode_uploadExe, ICudaRemoteDebugConstants.ExecutableTransferMode.Upload), RemoteRunTab.this.createButton(composite, Messages.RemoteDebug_mode_downloadExe, ICudaRemoteDebugConstants.ExecutableTransferMode.Download), RemoteRunTab.this.createButton(composite, Messages.RemoteDebug_mode_noTransferExe, ICudaRemoteDebugConstants.ExecutableTransferMode.Notransfer)};
            }

            @Override
            public Button[] run() {
                return new Button[]{RemoteRunTab.this.createButton(composite, Messages.RemoteDebug_mode_uploadExe, ICudaRemoteDebugConstants.ExecutableTransferMode.Upload), RemoteRunTab.this.createButton(composite, Messages.RemoteRun_mode_doNotTransfer, ICudaRemoteDebugConstants.ExecutableTransferMode.Download)};
            }

            @Override
            public Button[] profile() {
                return new Button[]{RemoteRunTab.this.createButton(composite, Messages.RemoteDebug_mode_uploadExe, ICudaRemoteDebugConstants.ExecutableTransferMode.Upload), RemoteRunTab.this.createButton(composite, Messages.RemoteProfile_mode_doNotTransfer, ICudaRemoteDebugConstants.ExecutableTransferMode.Download)};
            }
        });
    }
}

