/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ShutdownSequence
extends Sequence {
    private String fSessionId;
    private Sequence.Step[] fSteps;

    public ShutdownSequence(DsfExecutor executor, String sessionId, RequestMonitor requestMonitor) {
        super(executor, requestMonitor);
        this.fSessionId = sessionId;
        this.fSteps = this.createSteps();
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private Sequence.Step[] createSteps() {
        IDsfService[] services = this.getServices();
        Sequence.Step[] steps = new ServiceShutdownStep[services.length];
        int i = 0;
        while (i < steps.length) {
            steps[i] = new ServiceShutdownStep(services[i]);
            ++i;
        }
        return steps;
    }

    private IDsfService[] getServices() {
        IDsfService[] result = new IDsfService[]{};
        try {
            ServiceReference[] serviceRefs = GdbPlugin.getBundleContext().getServiceReferences(IDsfService.class.getName(), String.format("(%s=%s)", "org.eclipse.cdt.dsf.service.IService.session_id", this.fSessionId).intern());
            if (serviceRefs != null) {
                ArrayList<IDsfService> services = new ArrayList<IDsfService>(serviceRefs.length);
                ServiceReference[] serviceReferenceArray = serviceRefs;
                int n = serviceRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    Object serviceObj = GdbPlugin.getBundleContext().getService(ref);
                    if (serviceObj instanceof IDsfService) {
                        services.add((IDsfService)serviceObj);
                    }
                    ++n2;
                }
                Collections.sort(services, new Comparator<IDsfService>(){

                    @Override
                    public int compare(IDsfService o1, IDsfService o2) {
                        return o2.getStartupNumber() - o1.getStartupNumber();
                    }
                });
                result = services.toArray(new IDsfService[services.size()]);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return result;
    }

    class ServiceShutdownStep
    extends Sequence.Step {
        IDsfService fService;

        ServiceShutdownStep(IDsfService service) {
            this.fService = service;
        }

        public void execute(final RequestMonitor rm) {
            this.fService.shutdown(new RequestMonitor((Executor)ShutdownSequence.this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        GdbPlugin.getDefault().getLog().log(this.getStatus());
                    }
                    rm.done();
                }
            });
        }
    }
}

