/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expertsystem;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultKernelBounds;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.expertsystem.KernelInstanceStage;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.ITimelineInterval;

public class BoundsStage
extends KernelInstanceStage
implements IExpertSystemStage {
    public BoundsStage(ExpertSystem expertSystem) {
        super(expertSystem);
    }

    @Override
    public ExpertSystemStageKind getStageKind() {
        return ExpertSystemStageKind.BOUNDS;
    }

    @Override
    public String getTitle(ResultOutput otpt) {
        return ViperMessages.ExpertSystem_Bounds_Title;
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        AnalysisResultKernelBounds boundsResult;
        String desc = super.getDescription(otpt);
        if (ResultOutput.REPORT.equals((Object)otpt) && (boundsResult = this.getBoundsResult()) != null) {
            switch (boundsResult.getBound()) {
                case BALANCED_COMPUTE_MEMORY: 
                case COMPUTE: {
                    desc = String.valueOf(desc) + " " + ViperMessages.KernelBounds_Compute_Report_Desc;
                    break;
                }
                case MEMORY: {
                    desc = String.valueOf(desc) + " " + ViperMessages.KernelBounds_Memory_Report_Desc;
                    break;
                }
                case LATENCY: {
                    desc = String.valueOf(desc) + " " + ViperMessages.KernelBounds_Latency_Report_Desc;
                }
            }
        }
        return desc;
    }

    public static ExpertSystemStepAction getAnalysisRunAction(boolean force) {
        return new ExpertSystemStepAction(new ExpertSystemStepAction(force, AnalysisStage.KERNEL_INSTANCE_BOUNDS));
    }

    @Override
    public ExpertSystemStepAction update() {
        this.stageDesc = ViperMessages.ExpertSystem_Bounds_Desc;
        this.numSteps = 0;
        this.stepTitles = null;
        this.stepDescs = null;
        this.stepActions = null;
        ExpertSystemStepAction updateAction = ExpertSystemStepAction.NONE;
        ITimelineInterval kernel = this.getSelectedInDepthKernel();
        AnalysisResultIntervalNoData failResult = this.getFailResult();
        AnalysisResultKernelBounds boundsResult = this.getBoundsResult();
        if (kernel == null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescNoKernel;
            updateAction = ExpertSystemStepAction.CLEAR_RESULTS;
        } else if (failResult != null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescFailResult;
            this.numSteps = 0;
            this.stepTitles = null;
            this.stepDescs = null;
            this.stepActions = null;
            updateAction = new ExpertSystemStepAction(AnalysisStage.KERNEL_INSTANCE_BOUNDS, AnalysisResultIntervalNoData.class);
        } else if (boundsResult == null) {
            this.stageDesc = ViperMessages.ExpertSystem_DescNoResult;
            this.numSteps = 1;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_StepNoResult_Title};
            this.stepDescs = new String[]{ViperMessages.ExpertSystem_StepNoResult_Desc};
            this.stepActions = new ExpertSystemStepAction[]{KernelInstanceStage.getAnalysisRunAction(false)};
            updateAction = ExpertSystemStepAction.CLEAR_RESULTS;
        } else {
            AnalysisResultKernelBounds.Bound secondaryBound0;
            AnalysisResultKernelBounds.Bound primaryBound = boundsResult.getBound();
            AnalysisResultKernelBounds.Bound bound = secondaryBound0 = primaryBound == AnalysisResultKernelBounds.Bound.COMPUTE ? AnalysisResultKernelBounds.Bound.LATENCY : AnalysisResultKernelBounds.Bound.COMPUTE;
            AnalysisResultKernelBounds.Bound secondaryBound1 = primaryBound == AnalysisResultKernelBounds.Bound.COMPUTE ? AnalysisResultKernelBounds.Bound.MEMORY : (primaryBound == AnalysisResultKernelBounds.Bound.LATENCY ? AnalysisResultKernelBounds.Bound.MEMORY : AnalysisResultKernelBounds.Bound.LATENCY);
            updateAction = new ExpertSystemStepAction(AnalysisStage.KERNEL_INSTANCE_BOUNDS, null);
            String kdesc = primaryBound == AnalysisResultKernelBounds.Bound.NONE ? ViperMessages.ExpertSystem_Bounds_DescNoLimiter : ViperMessages.ExpertSystem_Bounds_DescLimiter;
            String name = this.getTruncatedName(kernel, 30);
            kdesc = name != null ? kdesc.replace("%KERNELNAME%", name) : kdesc.replace("%KERNELNAME%", "<unknown>");
            kdesc = kdesc.replace("%BOUND%", this.getBoundDisplayName(boundsResult.getBound(), false));
            this.stageDesc = String.valueOf(this.stageDesc) + " " + kdesc;
            String primaryDesc = ViperMessages.ExpertSystem_Bounds_StepPrimary_Desc;
            primaryDesc = primaryDesc.replace("%BOUND%", this.getBoundDisplayName(primaryBound, false));
            String secondaryDesc = ViperMessages.ExpertSystem_Bounds_StepSecondary_Desc;
            secondaryDesc = secondaryDesc.replace("%BOUND0%", this.getBoundDisplayName(secondaryBound0, true));
            secondaryDesc = secondaryDesc.replace("%BOUND1%", this.getBoundDisplayName(secondaryBound1, false));
            switch (boundsResult.getBound()) {
                case NONE: {
                    this.numSteps = 4;
                    this.stepTitles = new String[]{this.getStepTitleForBound(AnalysisResultKernelBounds.Bound.COMPUTE), this.getStepTitleForBound(AnalysisResultKernelBounds.Bound.MEMORY), this.getStepTitleForBound(AnalysisResultKernelBounds.Bound.LATENCY), ViperMessages.ExpertSystem_StepRerun_Title};
                    String[] stringArray = new String[4];
                    stringArray[2] = ViperMessages.ExpertSystem_Bounds_StepNoLimiter_Desc;
                    stringArray[3] = ViperMessages.ExpertSystem_StepRerun_Desc;
                    this.stepDescs = stringArray;
                    this.stepActions = new ExpertSystemStepAction[]{this.getStepActionForBound(AnalysisResultKernelBounds.Bound.COMPUTE), this.getStepActionForBound(AnalysisResultKernelBounds.Bound.MEMORY), this.getStepActionForBound(AnalysisResultKernelBounds.Bound.LATENCY), KernelInstanceStage.getAnalysisRunAction(true)};
                    break;
                }
                case BALANCED_COMPUTE_MEMORY: {
                    this.numSteps = 4;
                    this.stepTitles = new String[]{this.getStepTitleForBound(AnalysisResultKernelBounds.Bound.COMPUTE), this.getStepTitleForBound(AnalysisResultKernelBounds.Bound.MEMORY), this.getStepTitleForBound(AnalysisResultKernelBounds.Bound.LATENCY), ViperMessages.ExpertSystem_StepRerun_Title};
                    String[] stringArray = new String[4];
                    stringArray[1] = ViperMessages.ExpertSystem_Bounds_StepBalanced_Desc;
                    stringArray[2] = ViperMessages.ExpertSystem_Bounds_StepNotLatency_Desc;
                    stringArray[3] = ViperMessages.ExpertSystem_StepRerun_Desc;
                    this.stepDescs = stringArray;
                    this.stepActions = new ExpertSystemStepAction[]{this.getStepActionForBound(AnalysisResultKernelBounds.Bound.COMPUTE), this.getStepActionForBound(AnalysisResultKernelBounds.Bound.MEMORY), this.getStepActionForBound(AnalysisResultKernelBounds.Bound.LATENCY), KernelInstanceStage.getAnalysisRunAction(true)};
                    break;
                }
                case COMPUTE: 
                case MEMORY: 
                case LATENCY: {
                    this.numSteps = 4;
                    this.stepTitles = new String[]{this.getStepTitleForBound(primaryBound), this.getStepTitleForBound(secondaryBound0), this.getStepTitleForBound(secondaryBound1), ViperMessages.ExpertSystem_StepRerun_Title};
                    String[] stringArray = new String[4];
                    stringArray[0] = primaryDesc;
                    stringArray[2] = secondaryDesc;
                    stringArray[3] = ViperMessages.ExpertSystem_StepRerun_Desc;
                    this.stepDescs = stringArray;
                    this.stepActions = new ExpertSystemStepAction[]{this.getStepActionForBound(primaryBound), this.getStepActionForBound(secondaryBound0), this.getStepActionForBound(secondaryBound1), KernelInstanceStage.getAnalysisRunAction(true)};
                    break;
                }
                default: {
                    ViperExceptionHandler.logError("unexpected bound result " + (Object)((Object)boundsResult.getBound()));
                }
            }
        }
        return updateAction;
    }

    private String getStepTitleForBound(AnalysisResultKernelBounds.Bound bound) {
        switch (bound) {
            case LATENCY: {
                return ViperMessages.ExpertSystem_Bounds_StepLatency_Title;
            }
            case COMPUTE: {
                return ViperMessages.ExpertSystem_Bounds_StepCompute_Title;
            }
            case MEMORY: {
                return ViperMessages.ExpertSystem_Bounds_StepMemory_Title;
            }
        }
        return "<unknown>";
    }

    private ExpertSystemStepAction getStepActionForBound(AnalysisResultKernelBounds.Bound bound) {
        switch (bound) {
            case LATENCY: {
                return new ExpertSystemStepAction(ExpertSystemStageKind.LATENCY);
            }
            case COMPUTE: {
                return new ExpertSystemStepAction(ExpertSystemStageKind.COMPUTE);
            }
            case MEMORY: {
                return new ExpertSystemStepAction(ExpertSystemStageKind.MEMORY);
            }
        }
        return ExpertSystemStepAction.NONE;
    }

    private String getBoundDisplayName(AnalysisResultKernelBounds.Bound bound, boolean upper) {
        switch (bound) {
            case NONE: {
                return upper ? "None" : "none";
            }
            case BALANCED_COMPUTE_MEMORY: {
                return upper ? "Both compute and memory bandwidth" : "both compute and memory bandwidth";
            }
            case COMPUTE: {
                return upper ? "Compute" : "compute";
            }
            case MEMORY: {
                return upper ? "Memory bandwidth" : "memory bandwidth";
            }
            case LATENCY: {
                return upper ? "Instruction and memory latency" : "instruction and memory latency";
            }
        }
        return "<unknown>";
    }

    private AnalysisResultIntervalNoData getFailResult() {
        return (AnalysisResultIntervalNoData)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_BOUNDS, AnalysisResultIntervalNoData.class);
    }

    private AnalysisResultKernelBounds getBoundsResult() {
        return (AnalysisResultKernelBounds)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_BOUNDS, AnalysisResultKernelBounds.class);
    }
}

