/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.ERandomAccessFile;

public class AR {
    protected String filename;
    protected ERandomAccessFile efile;
    protected long strtbl_pos = -1L;
    private ARHeader[] headers;

    public void dispose() {
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
            }
        }
        catch (IOException iOException) {}
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public static boolean isARHeader(byte[] ident) {
        return ident.length >= 7 && ident[0] == 33 && ident[1] == 60 && ident[2] == 97 && ident[3] == 114 && ident[4] == 99 && ident[5] == 104 && ident[6] == 62;
    }

    public AR(String filename) throws IOException {
        this.filename = filename;
        boolean goodAr = false;
        try {
            this.efile = new ERandomAccessFile(filename, "r");
            byte[] hdrBytes = new byte[7];
            this.efile.readFully(hdrBytes);
            goodAr = AR.isARHeader(hdrBytes);
            if (!goodAr) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
            }
            this.efile.readLine();
        }
        finally {
            if (!goodAr && this.efile != null) {
                this.efile.close();
                this.efile = null;
            }
        }
    }

    private void loadHeaders() throws IOException {
        if (this.headers != null) {
            return;
        }
        Vector<ARHeader> v = new Vector<ARHeader>();
        try {
            while (this.efile.getFilePointer() < this.efile.length()) {
                ARHeader header = new ARHeader();
                String name = header.getObjectName();
                long pos = this.efile.getFilePointer();
                if (name.charAt(0) != '/') {
                    v.add(header);
                }
                if (name.compareTo("//") == 0) {
                    this.strtbl_pos = pos;
                }
                if ((pos += header.getSize()) % 2L != 0L) {
                    ++pos;
                }
                this.efile.seek(pos);
            }
        }
        catch (IOException iOException) {}
        this.headers = v.toArray(new ARHeader[0]);
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.headers;
    }

    private boolean stringInStrings(String str, String[] set) {
        int i = 0;
        while (i < set.length) {
            if (str.compareTo(set[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] extractFiles(String outdir, String[] names) throws IOException {
        Vector<String> names_used = new Vector<String>();
        this.loadHeaders();
        int count = 0;
        int i = 0;
        while (i < this.headers.length) {
            String object_name = this.headers[i].getObjectName();
            if (names == null || this.stringInStrings(object_name, names)) {
                object_name = count + "_" + object_name;
                ++count;
                byte[] data = this.headers[i].getObjectData();
                File output = new File(outdir, object_name);
                names_used.add(object_name);
                RandomAccessFile rfile = new RandomAccessFile(output, "rw");
                rfile.write(data);
                rfile.close();
            }
            ++i;
        }
        return names_used.toArray(new String[0]);
    }

    public String[] extractFiles(String outdir) throws IOException {
        return this.extractFiles(outdir, null);
    }

    public class ARHeader {
        private static final int NAME_IDX = 0;
        private static final int NAME_LEN = 16;
        private static final int SIZE_IDX = 48;
        private static final int SIZE_LEN = 10;
        private static final int HEADER_LEN = 60;
        private String object_name;
        private long size;
        private long obj_offset;

        private String removeBlanks(String str) {
            return str.trim();
        }

        private String nameFromStringTable(long offset) throws IOException {
            StringBuffer name = new StringBuffer(0);
            long pos = AR.this.efile.getFilePointer();
            try {
                if (AR.this.strtbl_pos != -1L) {
                    byte temp;
                    AR.this.efile.seek(AR.this.strtbl_pos + offset);
                    while ((temp = AR.this.efile.readByte()) != 10) {
                        name.append((char)temp);
                    }
                }
            }
            finally {
                AR.this.efile.seek(pos);
            }
            return name.toString();
        }

        ARHeader() throws IOException {
            int len;
            byte[] buf = new byte[60];
            AR.this.efile.readFully(buf);
            this.obj_offset = AR.this.efile.getFilePointer();
            this.object_name = this.removeBlanks(new String(buf, 0, 16));
            this.size = Long.parseLong(this.removeBlanks(new String(buf, 48, 10)));
            if (AR.this.strtbl_pos != -1L && this.object_name.length() > 1 && this.object_name.charAt(0) == '/') {
                try {
                    long offset = Long.parseLong(this.object_name.substring(1));
                    this.object_name = this.nameFromStringTable(offset);
                }
                catch (Exception exception) {}
            }
            if ((len = this.object_name.length()) > 2 && this.object_name.charAt(len - 1) == '/') {
                this.object_name = this.object_name.substring(0, len - 1);
            }
        }

        public String getObjectName() {
            return this.object_name;
        }

        public long getSize() {
            return this.size;
        }

        public String getArchiveName() {
            return AR.this.filename;
        }

        public long getObjectDataOffset() {
            return this.obj_offset;
        }

        public byte[] getObjectData() throws IOException {
            byte[] temp = new byte[(int)this.size];
            if (AR.this.efile != null) {
                AR.this.efile.seek(this.obj_offset);
                AR.this.efile.read(temp);
            } else {
                AR.this.efile = new ERandomAccessFile(AR.this.filename, "r");
                AR.this.efile.seek(this.obj_offset);
                AR.this.efile.read(temp);
                AR.this.efile.close();
                AR.this.efile = null;
            }
            return temp;
        }
    }
}

