/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import com.ibm.icu.text.Bidi;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.dom.AbstractStyle;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.TextArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.IInlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;

public class LineLayout
extends InlineStackingLayout
implements IInlineStackingLayout {
    private byte baseLevel = 0;
    protected int lineCount = 0;
    protected int currentPosition = 0;
    protected boolean breakAfterRelayout = false;
    protected boolean lineFinished = true;
    protected HashMap positionMap = new HashMap();
    protected ContainerArea last = null;
    protected int expectedIP = 0;
    protected IReportItemExecutor unfinishedExecutor = null;
    protected boolean isEmpty = true;
    protected int lineHeight;

    public LineLayout(LayoutEngineContext context, ContainerLayout parent) {
        super(context, parent, null);
        this.isInBlockStacking = false;
    }

    @Override
    protected void createRoot() {
        this.currentContext.root = AreaFactory.createLineArea(this.context.getReport());
        ++this.lineCount;
    }

    @Override
    protected void initialize() {
        int currentIP = 0;
        if (this.contextList.size() > 0) {
            currentIP = ((ContainerLayout.ContainerContext)this.contextList.get((int)(this.contextList.size() - 1))).currentIP;
        }
        this.currentContext = new ContainerLayout.ContainerContext();
        this.currentContext.currentIP = currentIP;
        this.contextList.add(this.currentContext);
        this.createRoot();
        this.currentContext.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        this.currentContext.maxAvaHeight = this.parent.getCurrentMaxContentHeight();
        this.currentContext.root.setWidth(this.parent.getCurrentMaxContentWidth());
        this.lineHeight = ((BlockStackingLayout)this.parent).getLineHeight();
        if (this.parent.content != null && "rtl".equals(this.parent.content.getComputedStyle().getDirection())) {
            this.baseLevel = 1;
        }
    }

    @Override
    public void setTextIndent(ITextContent content) {
        if (this.isEmpty && content != null) {
            IStyle contentStyle = content.getComputedStyle();
            this.currentContext.currentIP = this.getDimensionValue(contentStyle.getProperty(20), this.currentContext.maxAvaWidth);
        }
    }

    @Override
    public boolean endLine() throws BirtException {
        this.closeLayout(false);
        this.initialize();
        this.currentContext.currentIP = 0;
        return true;
    }

    @Override
    protected void closeLayout() throws BirtException {
        this.closeLayout(true);
    }

    protected void closeLayout(boolean isLastLine) throws BirtException {
        int size = this.contextList.size();
        if (size == 1) {
            this.currentContext = (ContainerLayout.ContainerContext)this.contextList.removeFirst();
            this.currentContext.root.setHeight(Math.max(this.currentContext.root.getHeight(), this.lineHeight));
            if (this.currentContext.root.getChildrenCount() > 0) {
                this.align(this.currentContext, isLastLine);
                boolean succeed = this.parent.addArea((AbstractArea)this.currentContext.root, this.parent.contextList.size() - 1);
                if (succeed) {
                    return;
                }
                this.parent.autoPageBreak();
                this.parent.addToRoot((AbstractArea)this.currentContext.root, this.parent.contextList.size() - 1);
                if (this.isInBlockStacking && this.parent.contextList.size() > 1) {
                    this.parent.closeExcludingLast();
                }
            }
        } else {
            int i = 0;
            while (i < size) {
                this.currentContext = (ContainerLayout.ContainerContext)this.contextList.removeFirst();
                if (this.currentContext.root.getChildrenCount() > 0) {
                    this.parent.addToRoot((AbstractArea)this.currentContext.root, i);
                }
                ++i;
            }
            if (this.parent.isInBlockStacking) {
                this.parent.closeLayout();
            }
        }
    }

    @Override
    public void addToRoot(AbstractArea area) {
        int height;
        area.setAllocatedPosition(this.currentContext.currentIP, this.currentContext.currentBP);
        this.currentContext.currentIP += area.getAllocatedWidth();
        if (this.currentContext.currentIP > this.currentContext.root.getWidth()) {
            this.currentContext.root.setWidth(this.currentContext.currentIP);
        }
        if (this.currentContext.currentBP + (height = area.getAllocatedHeight()) > this.currentContext.root.getHeight()) {
            this.currentContext.root.setHeight(this.currentContext.currentBP + height);
        }
        this.currentContext.root.addChild(area);
        this.isEmpty = false;
        this.lineFinished = false;
    }

    protected void align(ContainerLayout.ContainerContext currentContext, boolean lastLine) {
        assert (this.parent instanceof BlockStackingLayout);
        String align = ((BlockStackingLayout)this.parent).getTextAlign();
        boolean isRightAligned = BidiAlignmentResolver.isRightAligned(((BlockStackingLayout)this.parent).content, align, lastLine);
        if (isRightAligned || "center".equalsIgnoreCase(align)) {
            int spacing = currentContext.root.getWidth() - currentContext.currentIP;
            Iterator iter = currentContext.root.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                if (spacing <= 0) continue;
                if (isRightAligned) {
                    area.setAllocatedPosition(spacing + area.getAllocatedX(), area.getAllocatedY());
                    continue;
                }
                if (!"center".equalsIgnoreCase(align)) continue;
                area.setAllocatedPosition(spacing / 2 + area.getAllocatedX(), area.getAllocatedY());
            }
        } else if ("justify".equalsIgnoreCase(align) && !lastLine) {
            this.justify(currentContext);
        }
        if (this.context.getBidiProcessing()) {
            this.reorderVisually(currentContext.root);
        }
        this.verticalAlign();
    }

    private int adjustWordSpacing(int wordSpacing, ContainerArea area) {
        Iterator iter = area.getChildren();
        int delta = 0;
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            if (child instanceof TextArea) {
                String text = ((TextArea)child).getText();
                int blankNumber = text.split(" ").length - 1;
                if (blankNumber <= 0) continue;
                IStyle style = child.getStyle();
                int original = this.getDimensionValue(style.getProperty(59));
                AreaStyle areaStyle = new AreaStyle((AbstractStyle)style);
                areaStyle.setProperty(59, new FloatValue(1, original + wordSpacing));
                ((TextArea)child).setStyle(areaStyle);
                int spacing = wordSpacing * blankNumber;
                child.setWidth(child.getWidth() + spacing);
                child.setPosition(child.getX() + delta, child.getY());
                delta += spacing;
                continue;
            }
            if (child instanceof ContainerArea) {
                child.setPosition(child.getX() + delta, child.getY());
                int spacing = this.adjustWordSpacing(wordSpacing, (ContainerArea)child);
                child.setWidth(child.getWidth() + spacing);
                delta += spacing;
                continue;
            }
            child.setPosition(child.getX() + delta, child.getY());
        }
        return delta;
    }

    private int adjustLetterSpacing(int letterSpacing, ContainerArea area) {
        Iterator iter = area.getChildren();
        int delta = 0;
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            if (child instanceof TextArea) {
                String text = ((TextArea)child).getText();
                int letterNumber = text.length() > 1 ? text.length() - 1 : 0;
                IStyle style = child.getStyle();
                int original = this.getDimensionValue(style.getProperty(44));
                AreaStyle areaStyle = new AreaStyle((AbstractStyle)style);
                areaStyle.setProperty(44, new FloatValue(1, original + letterSpacing));
                ((TextArea)child).setStyle(areaStyle);
                int spacing = letterSpacing * letterNumber;
                child.setWidth(child.getWidth() + spacing);
                child.setPosition(child.getX() + delta, child.getY());
                delta += spacing;
                continue;
            }
            if (child instanceof ContainerArea) {
                child.setPosition(child.getX() + delta, child.getY());
                int spacing = this.adjustLetterSpacing(letterSpacing, (ContainerArea)child);
                child.setWidth(child.getWidth() + spacing);
                delta += spacing;
                continue;
            }
            child.setPosition(child.getX() + delta, child.getY());
        }
        return delta;
    }

    private int getBlankNumber(ContainerArea area) {
        int count = 0;
        Iterator iter = area.getChildren();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            if (child instanceof TextArea) {
                String text = ((TextArea)child).getText();
                count = count + text.split(" ").length - 1;
                continue;
            }
            if (!(child instanceof ContainerArea)) continue;
            count += this.getBlankNumber((ContainerArea)child);
        }
        return count;
    }

    private int getLetterNumber(ContainerArea area) {
        int count = 0;
        Iterator iter = area.getChildren();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            if (child instanceof TextArea) {
                String text = ((TextArea)child).getText();
                count = (text.length() > 1 ? text.length() - 1 : 0) - 1;
                continue;
            }
            if (!(child instanceof ContainerArea)) continue;
            count += this.getLetterNumber((ContainerArea)child);
        }
        return count;
    }

    protected void justify(ContainerLayout.ContainerContext currentContext) {
        int spacing = currentContext.root.getContentWidth() - currentContext.currentIP;
        int blankNumber = this.getBlankNumber(currentContext.root);
        if (blankNumber > 0) {
            int wordSpacing = spacing / blankNumber;
            this.adjustWordSpacing(wordSpacing, currentContext.root);
        } else {
            int letterNumber = this.getLetterNumber(currentContext.root);
            if (letterNumber > 0) {
                int letterSpacing = spacing / letterNumber;
                this.adjustLetterSpacing(letterSpacing, currentContext.root);
            }
        }
    }

    @Override
    public int getMaxLineWidth() {
        return this.currentContext.maxAvaWidth;
    }

    @Override
    public boolean isEmptyLine() {
        return this.isRootEmpty();
    }

    private void reorderVisually(ContainerArea parent) {
        int n = parent.getChildrenCount();
        if (n == 0) {
            return;
        }
        int i = 0;
        Object[] children = new AbstractArea[n];
        byte[] levels = new byte[n];
        Iterator iter = parent.getChildren();
        while (i < n && iter.hasNext()) {
            children[i] = (AbstractArea)iter.next();
            if (children[i] instanceof TextArea) {
                levels[i] = (byte)((TextArea)children[i]).getRunLevel();
            } else {
                levels[i] = this.baseLevel;
                if (children[i] instanceof ContainerArea) {
                    this.reorderVisually((ContainerArea)children[i]);
                }
            }
            ++i;
        }
        if (n > 1) {
            int x = children[0].getAllocatedX();
            Bidi.reorderVisually((byte[])levels, (int)0, (Object[])children, (int)0, (int)n);
            i = 0;
            while (i < n - 1) {
                ((AbstractArea)children[i]).setAllocatedPosition(x, ((AbstractArea)children[i]).getAllocatedY());
                x += ((AbstractArea)children[i]).getAllocatedWidth();
                ++i;
            }
            ((AbstractArea)children[i]).setAllocatedPosition(x, ((AbstractArea)children[i]).getAllocatedY());
        }
    }
}

