# FindNET search and find the libnet library path
#
# Usage:
#
#  find_package(NET)
#  ...
#  target_link_libraries(... ${NET_LIB})
#
# The following variables are to be set:
#   CMAKE_INCLUDE_PATH - find the pthread.h
#   CMAKE_LIBRARY_PATH - find the library
#
# Variable defined by this module:
#   NET_INCLUDE_DIR - header directory
#   NET_LIB         - library to link
#
# Copyright 2014 <Giuseppe Marco Randazzo> gmrandazzo@gmail.com
#
# Redistribution AND use is allowed according to the terms of the BSD 3 clause

find_path(NET_INCLUDE_DIR NAMES libnet.h HINTS ${CMAKE_INCLUDE_PATH})

find_library(NET_LIB NAMES net HINTS ${CMAKE_LIBRARY_PATH})

if(NET_INCLUDE_DIR AND NET_LIB)
  message(STATUS "Found libnet")
  include_directories(${NET_INCLUDE_DIR})
else(NET_INCLUDE_DIR AND NET_LIB)
  message(FATAL_ERROR "Could not find libnet-1.1! Please Visit: http://libnet.sourceforge.net/ or see in the arpon 'INSTALL' file")
endif(NET_INCLUDE_DIR AND NET_LIB)
