/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Comparator;
import net.sf.saxon.Platform;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.value.AtomicValue;

public class CollatingAtomicComparer
implements AtomicComparer {
    private Comparator collator;
    private Platform platform;
    private boolean canReturnCollationKeys;

    public CollatingAtomicComparer(Comparator comparator, Platform platform) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.platform = platform;
        this.canReturnCollationKeys = platform.canReturnCollationKeys(this.collator);
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return this.collator.compare(((AtomicValue)object).getStringValue(), ((AtomicValue)object2).getStringValue());
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compare(atomicValue, atomicValue2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        if (this.canReturnCollationKeys) {
            return new ComparisonKey(513, this.platform.getCollationKey(this.collator, atomicValue.getStringValue()));
        }
        return new ComparisonKey(513, atomicValue.getStringValue());
    }
}

