.\" DO NOT MODIFY THIS FILE!  It was generated by help2man 1.40.4.
.TH DGREP "1" "July 2013" "dateutils 0.2.5" "User Commands"
.SH NAME
dgrep - Find date or time matches in input stream
.SH SYNOPSIS
.B dgrep
[\fIOPTION\fR]... \fIEXPRESSION\fR
.SH DESCRIPTION
dgrep 0.2.5
.PP
Grep standard input for lines that match EXPRESSION.
.PP
EXPRESSION may be date/times prefixed with an operator `<', `<=', '=', '>=',
\&'>', `!=', `<>' (if omitted defaults to `='),
which will match lines with date/times which are older, older\-equal, equal,
newer\-equal, newer, or not equal respectively.
.PP
EXPRESSION may also be format specifiers infixed by above operators
and suffixed by a value (e.g. `%a="Wed"') which matches lines whose
%a representation (weekday name abbreviated) is "Wed".
.PP
EXPRESSION may be statements as described above concatenated through `&&' (for
conjunction) or `||' (disjunction), both of which may be parenthesised as per
usual to change precedence (`&&' goes over `||').
.PP
If multiple date/times occur on the same line and any one of them fulfills the
criteria then the line is considered a match and will be output.
.TP
\fB\-h\fR, \fB\-\-help\fR
Print help and exit
.TP
\fB\-V\fR, \fB\-\-version\fR
Print version and exit
.TP
\fB\-q\fR, \fB\-\-quiet\fR
Suppress message about date/time and duration
parser errors.
.TP
\fB\-i\fR, \fB\-\-input\-format\fR=\fISTRING\fR
Input format, can be used multiple times.
Each date/time will be passed to the input
format parsers in the order they are given, if a
date/time can be read successfully with a given
input format specifier string, that value will
be used.
.TP
\fB\-e\fR, \fB\-\-backslash\-escapes\fR
Enable interpretation of backslash escapes in the
output and input format specifier strings.
.TP
\fB\-o\fR, \fB\-\-only\-matching\fR
Show only the part of a line matching DATE.
.IP
Group: op
.IP
Operations can be specified by options as well.
In all cases EXPRESSION must be a date/time and no concatenation is through
conjunction (`&&') or disjunction (`||') operators is possible.
.IP
This serves solely as a means of convenience, e.g. the dtest tool has a
similar syntax.
.TP
\fB\-\-eq\fR
Lines match when date/times are equal to
EXPRESSION.
.TP
\fB\-\-ne\fR
Lines match when date/times are not the same as
EXPRESSION.
.TP
\fB\-\-gt\fR
Lines match when date/times are newer than
EXPRESSION.
.TP
\fB\-\-lt\fR
Lines match when date/times are older than
EXPRESSION.
.TP
\fB\-\-ge\fR
Lines match when date/times are newer than or
equal EXPRESSION.
.TP
\fB\-\-le\fR
Lines match when date/times are older than or
equal EXPRESSION.
.TP
\fB\-\-nt\fR
Lines match when date/times are newer than or
equal EXPRESSION.
.TP
\fB\-\-ot\fR
Lines match when date/times are older than or
equal EXPRESSION.
.SH EXAMPLES

  % dgrep 2012-03-01 <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-03-01


  % dgrep '<2012-03-01' <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-02-28
  2012-02-29


  % dgrep \!=2012-03-01 <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-02-28
  2012-02-29
  2012-03-02


  % dgrep =2012-03-01 <<EOF
  Feb	2012-02-28
  Feb	2012-02-29	leap day
  Mar	2012-03-01
  Mar	2012-03-02
  EOF
  Mar	2012-03-01


  % dgrep -o \<2012-03-01 <<EOF
  Feb	2012-02-28
  Feb	2012-02-29	leap day
  Mar	2012-03-01
  Mar	2012-03-02
  EOF
  2012-02-28
  2012-02-29


  % dgrep '>=12:00:00' <<EOF
  fileA	11:59:58
  fileB	11:59:59	leap second?
  fileNOON	12:00:00	new version
  fileC	12:03:12
  EOF
  fileNOON	12:00:00	new version
  fileC	12:03:12


  % dgrep -o '>=12:00:00' <<EOF
  fileA	11:59:58
  fileB	11:59:59	leap second?
  fileNOON	12:00:00	new version
  fileC	12:03:12
  EOF
  12:00:00
  12:03:12


  % dgrep 2012-03-01 <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-03-01T10:00:00


  % dgrep '<2012-03-01' <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00


  % dgrep 2012-03-01T10:00:00 <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-03-01T10:00:00


  % dgrep '<2012-03-01T14:00:00' <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
.SH "FORMAT SPECS"

Format specs in dateutils are similar to posix' strftime().

However, due to a broader range of supported calendars dateutils must
employ different rules.

Date specs:
  %a  The abbreviated weekday name
  %A  The full weekday name
  %_a The weekday name shortened to a single character (MTWRFAS)
  %b  The abbreviated month name
  %B  The full month name
  %_b The month name shortened to a single character (FGHJKMNQUVXZ)
  %c  The count of the weekday within the month (range 00 to 05)
  %C  The count of the weekday within the year (range 00 to 53)
  %d  The day of the month, 2 digits (range 00 to 31)
  %D  The day of the year, 3 digits (range 000 to 366)
  %F  Equivalent to %Y-%m-%d (ymd's canonical format)
  %j  Equivalent to %D
  %m  The month in the current calendar (range 00 to 19)
  %Q  The quarter of the year (range Q1 to Q4)
  %q  The number of the quarter (range 01 to 04)
  %s  The number of seconds since the Epoch.
  %u  The weekday as number (range 01 to 07, Sunday being 07)
  %U  The week count, first day of week is Sun (range 00 to 53)
  %V  The ISO week count, first day of week is Mon (range 01 to 53)
  %w  The weekday as number (range 00 to 06, Sunday being 00)
  %W  The week count, first day of week is Mon (range 00 to 53)
  %y  The year without a century (range 00 to 99)
  %Y  The year including the century

  %Od The day as roman numerals
  %Om The month as roman numerals
  %Oy The two digit year as roman numerals
  %OY The year including the century as roman numerals

  %rs In time systems whose Epoch is different from the unix Epoch, this
      selects the number of seconds since then.
  %rY In calendars with years that don't coincide with the Gregorian
      years, this selects the calendar's year.

  %dth  The day of the month as an ordinal number, 1st, 2nd, 3rd, etc.
  %mth  The month of the year as an ordinal number, 1st, 2nd, 3rd, etc.

  %db The business day of the month (since last month's ultimo)
  %dB Number of business days until this month's ultimo

Time specs:
  %H  The hour of the day using a 24h clock, 2 digits (range 00 to 23)
  %I  The hour of the day using a 12h clock, 2 digits (range 01 to 12)
  %M  The minute (range 00 to 59)
  %N  The nanoseconds (range 000000000 to 999999999)
  %p  The string AM or PM, noon is PM and midnight is AM.
  %P  Like %p but in lowercase
  %S  The second (range 00 to 60, 60 is for leap seconds)
  %T  Equivalent to %H:%M:%S

General specs:
  %n  A newline character
  %t  A tab character
  %%  A literal % character

Modifiers:
  %O  Modifier to turn decimal numbers into Roman numerals
  %r  Modifier to turn units into real units
  th  Suffix.  Read and print ordinal numbers
  b   Treat date as business date

By design dates before 1601-01-01 are not supported.

For conformity here is a list of calendar spec names and their meaning:
  ymd   %Y-%m-%d
  ymcw  %Y-%m-%c-%w
  ywd   %rY-W%V-%u
  bizda %Y-%m-%db
.SH AUTHOR
Written by Sebastian Freundt <freundt@fresse.org>
.SH "REPORTING BUGS"
Report bugs to: https://github.com/hroptatyr/dateutils/issues
.SH "SEE ALSO"
The full documentation for
.B dgrep
is maintained as a Texinfo manual.  If the
.B info
and
.B dgrep
programs are properly installed at your site, the command
.IP
.B info (dateutils)dgrep
.PP
should give you access to the complete manual.
