#ifndef INC_ASTPair_hpp__
#define INC_ASTPair_hpp__

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1999
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1999
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */
#include "Antlr/config.hpp"
#include "Antlr/AST.hpp"

/** ASTPair:  utility class used for manipulating a pair of ASTs
  * representing the current AST root and current AST sibling.
  * This exists to compensate for the lack of pointers or 'var'
  * arguments in Java.
  *
  * OK, so we can do those things in C++, but it seems easier
  * to stick with the Java way for now.
  */
class ASTPair {
public:
	RefAST root;		// current root of tree
	RefAST child;		// current child to which siblings are added

	/** Make sure that child is the last sibling */
	void advanceChildToEnd() {
		if (child) {
			while (child->getNextSibling()) {
				child = child->getNextSibling();
			}
		}
	}
//	/** Copy an ASTPair.  Don't call it clone() because we want type-safety */
//	ASTPair copy() {
//		ASTPair tmp = new ASTPair();
//		tmp.root = root;
//		tmp.child = child;
//		return tmp;
//	}
	std::string toString() const {
		std::string r = !root ? std::string("null") : root->getText();
		std::string c = !child ? std::string("null") : child->getText();
		return "["+r+","+c+"]";
	}	
};

#endif //INC_ASTPair_hpp__

