package org.jboss.cache.loader;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups = {"functional"})
public class LocalDelegatingCacheLoaderTest extends CacheLoaderTestsBase
{
   CacheSPI delegating_cache;

   protected void configureCache() throws Exception
   {
      delegating_cache = (CacheSPI) new DefaultCacheFactory().createCache(false);
      delegating_cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
      delegating_cache.create();
      delegating_cache.start();

      LocalDelegatingCacheLoaderConfig cfg = new LocalDelegatingCacheLoaderConfig();
      cfg.setDelegate(delegating_cache);
      cfg.setAsync(false);
      cfg.setFetchPersistentState(false);
      CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
      cacheLoaderConfig.addIndividualCacheLoaderConfig(cfg);
      cache.getConfiguration().setCacheLoaderConfig(cacheLoaderConfig);
   }

   protected void postConfigure()
   {
      CacheLoader ldr = loader;
      LocalDelegatingCacheLoader ldcl = null;
      do
      {
         if (ldr instanceof LocalDelegatingCacheLoader)
         {
            ldcl = (LocalDelegatingCacheLoader) ldr;
         }
         else
         {
            if (ldr instanceof AbstractDelegatingCacheLoader)
            {
               // look deeper in the delegate chain
               ldr = ((AbstractDelegatingCacheLoader) ldr).getCacheLoader();
            }
            else
            {
               // can't dig any deeper!
               break;
            }
         }
      } while (ldcl == null);

      ldcl.setDelegateCache(delegating_cache);
   }

   @AfterMethod(alwaysRun = true)
   public void tearDown() throws Exception
   {
      super.tearDown();
      delegating_cache.stop();
      delegating_cache.destroy();
   }

   @Test(groups = {"functional"}, enabled = false)
   public void testLoadAndStore() throws Exception
   {
      //TODO intentional overload since this test does not pass
      //http://jira.jboss.com/jira/browse/JBCACHE-851
   }

   public void testPartialLoadAndStore()
   {
      // do nothing
   }

   public void testBuddyBackupStore()
   {
      // do nothing
   }

   public void testCacheLoaderThreadSafety()
   {
      // do nothing
   }

   public void testCacheLoaderThreadSafetyMultipleFqns()
   {
      // do nothing
   }
}
