/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.spi.management.recording;

//$Id: RecordFilter.java 5483 2008-01-16 21:57:35Z thomas.diesler@jboss.com $

/**
 * A record filter
 * 
 * @author alessio.soldano@jboss.com
 * @since 8-Dec-2007
 */
public interface RecordFilter extends Cloneable
{
   /**
    * Returns true if the filter matches the given record.
    */
   boolean match(Record record);
   
   /**
    * RecordFilters must override Object.clone()
    */
   Object clone() throws CloneNotSupportedException;
}
