/*
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_lta.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t21, t22, t24, t26;
  double t27, t29, t30, t31, t37, t41;

#ifndef XC_DONT_COMPILE_VXC
  double t42, t47, t48, t53, t56, t57, t58, t62;

#ifndef XC_DONT_COMPILE_FXC
  double t69, t73, t78, t84, t89, t92, t93, t94;
  double t98, t103;

#ifndef XC_DONT_COMPILE_KXC
  double t106, t108, t113, t120, t125, t135, t140, t146;
  double t154, t158, t159, t163, t167, t172;

#ifndef XC_DONT_COMPILE_LXC
  double t177, t182, t192, t197, t215, t233, t250, t253;
  double t254, t272;
#endif

#endif

#endif

#endif

#endif


  mgga_x_lta_params *params;

  assert(p->params != NULL);
  params = (mgga_x_lta_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t24 = t19 * t19;
  t26 = 0.1e1 / t24 / rho[0];
  t27 = M_CBRT6;
  t29 = M_PI * M_PI;
  t30 = POW_1_3(t29);
  t31 = t30 * t30;
  t37 = pow(0.5e1 / 0.9e1 * tau[0] * t22 * t26 * t27 / t31, 0.4e1 / 0.5e1 * params->ltafrac);
  t41 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t18 * t19 * t37);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t41;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t42 = 0.1e1 / t24;
  t47 = t7 * t18;
  t48 = t42 * t37;
  t53 = my_piecewise3(t3, 0, -t7 * t18 * t42 * t37 / 0.8e1 + t47 * t48 * params->ltafrac / 0.2e1);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * rho[0] * t53 + 0.2e1 * t41;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = 0.0e0;

  t56 = t19 * t37;
  t57 = 0.1e1 / tau[0];
  t58 = params->ltafrac * t57;
  t62 = my_piecewise3(t3, 0, -0.3e1 / 0.10e2 * t47 * t56 * t58);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = 0.2e1 * rho[0] * t62;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t69 = t26 * t37;
  t73 = params->ltafrac * params->ltafrac;
  t78 = my_piecewise3(t3, 0, t7 * t18 * t26 * t37 / 0.12e2 - t47 * t69 * params->ltafrac / 0.6e1 - 0.2e1 / 0.3e1 * t47 * t69 * t73);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * rho[0] * t78 + 0.4e1 * t53;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = 0.0e0;

  t84 = t73 * t57;
  t89 = my_piecewise3(t3, 0, -t47 * t48 * t58 / 0.10e2 + 0.2e1 / 0.5e1 * t47 * t48 * t84);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = 0.2e1 * rho[0] * t89 + 0.2e1 * t62;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = 0.0e0;

  t92 = tau[0] * tau[0];
  t93 = 0.1e1 / t92;
  t94 = t73 * t93;
  t98 = params->ltafrac * t93;
  t103 = my_piecewise3(t3, 0, -0.6e1 / 0.25e2 * t47 * t56 * t94 + 0.3e1 / 0.10e2 * t47 * t56 * t98);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = 0.2e1 * rho[0] * t103;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t106 = rho[0] * rho[0];
  t108 = 0.1e1 / t24 / t106;
  t113 = t108 * t37;
  t120 = t73 * params->ltafrac;
  t125 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t18 * t108 * t37 + t47 * t113 * params->ltafrac / 0.6e1 + 0.4e1 / 0.3e1 * t47 * t113 * t73 + 0.8e1 / 0.9e1 * t47 * t113 * t120);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * rho[0] * t125 + 0.6e1 * t78;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = 0.0e0;

  t135 = t120 * t57;
  t140 = my_piecewise3(t3, 0, t47 * t69 * t58 / 0.15e2 - 0.2e1 / 0.15e2 * t47 * t69 * t84 - 0.8e1 / 0.15e2 * t47 * t69 * t135);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = 0.2e1 * rho[0] * t140 + 0.4e1 * t89;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = 0.0e0;

  t146 = t120 * t93;
  t154 = my_piecewise3(t3, 0, -0.12e2 / 0.25e2 * t47 * t48 * t94 + 0.8e1 / 0.25e2 * t47 * t48 * t146 + t47 * t48 * t98 / 0.10e2);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = 0.2e1 * rho[0] * t154 + 0.2e1 * t103;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = 0.0e0;

  t158 = 0.1e1 / t92 / tau[0];
  t159 = t120 * t158;
  t163 = t73 * t158;
  t167 = params->ltafrac * t158;
  t172 = my_piecewise3(t3, 0, -0.24e2 / 0.125e3 * t47 * t56 * t159 + 0.18e2 / 0.25e2 * t47 * t56 * t163 - 0.3e1 / 0.5e1 * t47 * t56 * t167);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = 0.2e1 * rho[0] * t172;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t177 = 0.1e1 / t24 / t106 / rho[0];
  t182 = t177 * t37;
  t192 = t73 * t73;
  t197 = my_piecewise3(t3, 0, 0.10e2 / 0.27e2 * t7 * t18 * t177 * t37 - 0.7e1 / 0.27e2 * t47 * t182 * params->ltafrac - 0.34e2 / 0.9e1 * t47 * t182 * t73 - 0.112e3 / 0.27e2 * t47 * t182 * t120 - 0.32e2 / 0.27e2 * t47 * t182 * t192);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * rho[0] * t197 + 0.8e1 * t125;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = 0.0e0;

  t215 = my_piecewise3(t3, 0, -t47 * t113 * t58 / 0.9e1 + 0.2e1 / 0.15e2 * t47 * t113 * t84 + 0.16e2 / 0.15e2 * t47 * t113 * t135 + 0.32e2 / 0.45e2 * t47 * t113 * t192 * t57);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = 0.2e1 * rho[0] * t215 + 0.6e1 * t140;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = 0.0e0;

  t233 = my_piecewise3(t3, 0, 0.14e2 / 0.75e2 * t47 * t69 * t94 + 0.32e2 / 0.75e2 * t47 * t69 * t146 - 0.32e2 / 0.75e2 * t47 * t69 * t192 * t93 - t47 * t69 * t98 / 0.15e2);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = 0.2e1 * rho[0] * t233 + 0.4e1 * t154;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = 0.0e0;

  t250 = my_piecewise3(t3, 0, -0.128e3 / 0.125e3 * t47 * t48 * t159 + 0.32e2 / 0.125e3 * t47 * t48 * t192 * t158 + 0.26e2 / 0.25e2 * t47 * t48 * t163 - t47 * t48 * t167 / 0.5e1);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = 0.2e1 * rho[0] * t250 + 0.2e1 * t172;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = 0.0e0;

  t253 = t92 * t92;
  t254 = 0.1e1 / t253;
  t272 = my_piecewise3(t3, 0, -0.96e2 / 0.625e3 * t47 * t56 * t192 * t254 + 0.144e3 / 0.125e3 * t47 * t56 * t120 * t254 - 0.66e2 / 0.25e2 * t47 * t56 * t73 * t254 + 0.9e1 / 0.5e1 * t47 * t56 * params->ltafrac * t254);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = 0.2e1 * rho[0] * t272;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t34, t35;
  double t36, t37, t39, t42, t43, t47, t48, t49;
  double t51, t52, t53, t54, t56, t57, t58, t59;
  double t65, t69;

#ifndef XC_DONT_COMPILE_VXC
  double t70, t71, t72, t74, t77, t78, t82, t83;
  double t84, t87, t88, t89, t90, t91, t92, t96;
  double t97, t99, t102, t103, t107, t110, t112, t116;
  double t119, t120, t125, t127, t130, t131, t135, t136;
  double t137, t138, t139, t143, t146, t147, t148, t151;
  double t152, t153, t154, t157;

#ifndef XC_DONT_COMPILE_FXC
  double t160, t161, t162, t165, t166, t167, t170, t174;
  double t175, t179, t181, t183, t186, t187, t190, t191;
  double t192, t193, t195, t196, t197, t198, t199, t202;
  double t203, t207, t208, t209, t210, t213, t216, t220;
  double t221, t225, t227, t229, t232, t234, t237, t241;
  double t245, t246, t250, t252, t254, t260, t261, t265;
  double t269, t270, t274, t276, t279, t282, t283, t284;
  double t287, t292, t297, t301, t302, t308, t309, t314;
  double t318, t319, t324, t327, t328, t329, t330, t333;
  double t334, t338, t343, t345, t346, t347, t349, t353;
  double t357, t359, t361, t366, t370, t371, t373, t377;
  double t379, t380, t381, t382, t385, t386, t390, t391;
  double t392, t393, t394, t397, t398, t402;

#ifndef XC_DONT_COMPILE_KXC
  double t407, t411, t414, t418, t419, t421, t422, t423;
  double t426, t429, t432, t433, t434, t436, t437, t440;
  double t441, t444, t447, t448, t449, t452, t456, t463;
  double t464, t466, t467, t470, t471, t473, t474, t476;
  double t477, t480, t483, t486, t490, t497, t501, t506;
  double t508, t511, t512, t513, t516, t521, t522, t524;
  double t528, t536, t537, t541, t544, t555, t556, t557;
  double t560, t565, t567, t571, t579, t582, t586, t590;
  double t591, t592, t593, t596, t599, t604, t608, t612;
  double t619, t621, t628, t629, t634, t638, t642, t649;
  double t652, t654, t660, t661, t665, t666, t668, t669;
  double t674, t681, t685, t693, t694, t701, t705, t713;
  double t714, t715, t718, t728, t729, t732, t733, t735;
  double t736, t742, t744, t747, t749, t750, t751, t753;
  double t754, t755, t758, t762, t767, t769, t771, t773;
  double t777, t779, t785, t789, t792, t795, t796, t799;
  double t806, t812, t816, t817, t818, t821, t825, t829;
  double t831, t832, t833, t838, t840, t841, t845, t849;
  double t851, t854, t856, t858, t865, t869, t870, t875;
  double t879, t882, t883, t884, t887, t888, t891, t892;
  double t896, t898, t899, t900, t903, t904, t907, t908;
  double t912;

#ifndef XC_DONT_COMPILE_LXC
  double t915, t917, t918, t924, t930, t931, t934, t938;
  double t945, t949, t953, t956, t960, t961, t963, t968;
  double t973, t975, t976, t985, t987, t995, t1000, t1002;
  double t1007, t1012, t1015, t1017, t1019, t1021, t1023, t1024;
  double t1026, t1027, t1033, t1038, t1041, t1045, t1052, t1056;
  double t1060, t1065, t1067, t1088, t1089, t1091, t1095, t1102;
  double t1106, t1107, t1110, t1121, t1125, t1126, t1129, t1132;
  double t1133, t1134, t1145, t1147, t1164, t1166, t1170, t1177;
  double t1181, t1182, t1185, t1190, t1193, t1195, t1196, t1197;
  double t1199, t1201, t1202, t1219, t1232, t1236, t1243, t1247;
  double t1257, t1259, t1269, t1271, t1272, t1275, t1277, t1279;
  double t1281, t1284, t1294, t1307, t1311, t1318, t1322, t1333;
  double t1339, t1341, t1362, t1366, t1373, t1375, t1384, t1385;
  double t1388, t1406, t1410, t1419, t1431, t1437, t1439, t1442;
  double t1445, t1448, t1450, t1453, t1455, t1460, t1465, t1472;
  double t1476, t1485, t1486, t1491, t1498, t1502, t1512, t1513;
  double t1534, t1537, t1552, t1554, t1559, t1565, t1567, t1569;
  double t1571, t1572, t1576, t1581, t1583, t1595, t1596, t1601;
  double t1603, t1607, t1609, t1611, t1615, t1619, t1623, t1634;
  double t1635, t1637, t1641, t1642, t1651, t1653, t1656, t1660;
  double t1669, t1673, t1680, t1686, t1690, t1692, t1693, t1701;
  double t1706, t1707, t1730, t1731, t1736, t1742, t1743, t1745;
  double t1754, t1760, t1761, t1766, t1767, t1772, t1776, t1779;
  double t1783, t1785, t1789, t1797, t1803, t1804, t1808, t1813;
  double t1817, t1822, t1824, t1825, t1835, t1844, t1860, t1861;
  double t1867, t1868, t1876, t1884, t1889, t1895, t1900, t1905;
  double t1907, t1916, t1920, t1935, t1937, t1938, t1956, t1957;
  double t1958, t1976;
#endif

#endif

#endif

#endif

#endif


  mgga_x_lta_params *params;

  assert(p->params != NULL);
  params = (mgga_x_lta_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = POW_1_3(rho[0]);
  t30 = t29 * t29;
  t34 = M_CBRT6;
  t35 = M_PI * M_PI;
  t36 = POW_1_3(t35);
  t37 = t36 * t36;
  t39 = t34 / t37;
  t42 = 0.4e1 / 0.5e1 * params->ltafrac;
  t43 = pow(0.5e1 / 0.9e1 * tau[0] / t30 / rho[0] * t39, t42);
  t47 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t43);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t17;
  t51 = my_piecewise5(t15, t12, t11, t16, t49 * t8);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t23, t54 * t52);
  t57 = t56 * t27;
  t58 = POW_1_3(rho[1]);
  t59 = t58 * t58;
  t65 = pow(0.5e1 / 0.9e1 * tau[1] / t59 / rho[1] * t39, t42);
  t69 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t57 * t65);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t47 + t69;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t70 = t7 * t7;
  t71 = 0.1e1 / t70;
  t72 = t17 * t71;
  t74 = my_piecewise5(t11, 0, t15, 0, t8 - t72);
  t77 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t74);
  t78 = t77 * t27;
  t82 = t27 * t27;
  t83 = 0.1e1 / t82;
  t84 = t26 * t83;
  t87 = t6 * t84 * t43 / 0.8e1;
  t88 = t6 * t26;
  t89 = t27 * t43;
  t90 = 0.1e1 / rho[0];
  t91 = params->ltafrac * t90;
  t92 = t89 * t91;
  t96 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t78 * t43 - t87 + t88 * t92 / 0.2e1);
  t97 = t49 * t71;
  t99 = my_piecewise5(t15, 0, t11, 0, -t8 - t97);
  t102 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t99);
  t103 = t102 * t27;
  t107 = t56 * t83;
  t110 = t6 * t107 * t65 / 0.8e1;
  t112 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t103 * t65 - t110);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t47 + t69 + t7 * (t96 + t112);

  t116 = my_piecewise5(t11, 0, t15, 0, -t8 - t72);
  t119 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t116);
  t120 = t119 * t27;
  t125 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t120 * t43 - t87);
  t127 = my_piecewise5(t15, 0, t11, 0, t8 - t97);
  t130 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t127);
  t131 = t130 * t27;
  t135 = t6 * t56;
  t136 = t27 * t65;
  t137 = 0.1e1 / rho[1];
  t138 = params->ltafrac * t137;
  t139 = t136 * t138;
  t143 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t131 * t65 - t110 + t135 * t139 / 0.2e1);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t47 + t69 + t7 * (t125 + t143);

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[1] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[2] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[1] = 0.0e0;

  t146 = 0.1e1 / tau[0];
  t147 = params->ltafrac * t146;
  t148 = t89 * t147;
  t151 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t88 * t148);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = t7 * t151;

  t152 = 0.1e1 / tau[1];
  t153 = params->ltafrac * t152;
  t154 = t136 * t153;
  t157 = my_piecewise3(t48, 0, -0.3e1 / 0.10e2 * t135 * t154);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[1] = t7 * t157;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t160 = t24 * t24;
  t161 = 0.1e1 / t160;
  t162 = t74 * t74;
  t165 = t70 * t7;
  t166 = 0.1e1 / t165;
  t167 = t17 * t166;
  t170 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t71 + 0.2e1 * t167);
  t174 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t161 * t162 + 0.4e1 / 0.3e1 * t24 * t170);
  t175 = t174 * t27;
  t179 = t77 * t83;
  t181 = t6 * t179 * t43;
  t183 = t6 * t77;
  t186 = 0.1e1 / t82 / t7;
  t187 = t26 * t186;
  t190 = t6 * t187 * t43 / 0.12e2;
  t191 = t83 * t43;
  t192 = t191 * t91;
  t193 = t88 * t192;
  t195 = params->ltafrac * params->ltafrac;
  t196 = rho[0] * rho[0];
  t197 = 0.1e1 / t196;
  t198 = t195 * t197;
  t199 = t89 * t198;
  t202 = params->ltafrac * t197;
  t203 = t89 * t202;
  t207 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t175 * t43 - t181 / 0.4e1 + t183 * t92 + t190 + t193 / 0.3e1 - 0.2e1 / 0.3e1 * t88 * t199 - t88 * t203 / 0.2e1);
  t208 = t54 * t54;
  t209 = 0.1e1 / t208;
  t210 = t99 * t99;
  t213 = t49 * t166;
  t216 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t71 + 0.2e1 * t213);
  t220 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t209 * t210 + 0.4e1 / 0.3e1 * t54 * t216);
  t221 = t220 * t27;
  t225 = t102 * t83;
  t227 = t6 * t225 * t65;
  t229 = t56 * t186;
  t232 = t6 * t229 * t65 / 0.12e2;
  t234 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t221 * t65 - t227 / 0.4e1 + t232);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t96 + 0.2e1 * t112 + t7 * (t207 + t234);

  t237 = t161 * t116;
  t241 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t167);
  t245 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t237 * t74 + 0.4e1 / 0.3e1 * t24 * t241);
  t246 = t245 * t27;
  t250 = t119 * t83;
  t252 = t6 * t250 * t43;
  t254 = t6 * t119;
  t260 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t246 * t43 - t252 / 0.8e1 + t254 * t92 / 0.2e1 - t181 / 0.8e1 + t190 + t193 / 0.6e1);
  t261 = t209 * t127;
  t265 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t213);
  t269 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t261 * t99 + 0.4e1 / 0.3e1 * t54 * t265);
  t270 = t269 * t27;
  t274 = t130 * t83;
  t276 = t6 * t274 * t65;
  t279 = t6 * t102;
  t282 = t83 * t65;
  t283 = t282 * t138;
  t284 = t135 * t283;
  t287 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t270 * t65 - t276 / 0.8e1 - t227 / 0.8e1 + t232 + t279 * t139 / 0.2e1 + t284 / 0.6e1);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t96 + t112 + t125 + t143 + t7 * (t260 + t287);

  t292 = t116 * t116;
  t297 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t71 + 0.2e1 * t167);
  t301 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t161 * t292 + 0.4e1 / 0.3e1 * t24 * t297);
  t302 = t301 * t27;
  t308 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t302 * t43 - t252 / 0.4e1 + t190);
  t309 = t127 * t127;
  t314 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t71 + 0.2e1 * t213);
  t318 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t209 * t309 + 0.4e1 / 0.3e1 * t54 * t314);
  t319 = t318 * t27;
  t324 = t6 * t130;
  t327 = rho[1] * rho[1];
  t328 = 0.1e1 / t327;
  t329 = t195 * t328;
  t330 = t136 * t329;
  t333 = params->ltafrac * t328;
  t334 = t136 * t333;
  t338 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t319 * t65 - t276 / 0.4e1 + t324 * t139 + t232 + t284 / 0.3e1 - 0.2e1 / 0.3e1 * t135 * t330 - t135 * t334 / 0.2e1);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t125 + 0.2e1 * t143 + t7 * (t308 + t338);

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[3] = 0.0e0;

  t343 = t191 * t147;
  t345 = t88 * t343 / 0.10e2;
  t346 = t6 * t28;
  t347 = t43 * t195;
  t349 = t347 * t90 * t146;
  t353 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t183 * t148 - t345 + 0.2e1 / 0.5e1 * t346 * t349);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = t7 * t353 + t151;

  t357 = t282 * t153;
  t359 = t135 * t357 / 0.10e2;
  t361 = my_piecewise3(t48, 0, -0.3e1 / 0.10e2 * t279 * t154 - t359);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[1] = t7 * t361 + t157;

  t366 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t254 * t148 - t345);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[2] = t7 * t366 + t151;

  t370 = t6 * t57;
  t371 = t65 * t195;
  t373 = t371 * t137 * t152;
  t377 = my_piecewise3(t48, 0, -0.3e1 / 0.10e2 * t324 * t154 - t359 + 0.2e1 / 0.5e1 * t370 * t373);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[3] = t7 * t377 + t157;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[3] = 0.0e0;

  t379 = tau[0] * tau[0];
  t380 = 0.1e1 / t379;
  t381 = t195 * t380;
  t382 = t89 * t381;
  t385 = params->ltafrac * t380;
  t386 = t89 * t385;
  t390 = my_piecewise3(t2, 0, -0.6e1 / 0.25e2 * t88 * t382 + 0.3e1 / 0.10e2 * t88 * t386);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = t7 * t390;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[1] = 0.0e0;

  t391 = tau[1] * tau[1];
  t392 = 0.1e1 / t391;
  t393 = t195 * t392;
  t394 = t136 * t393;
  t397 = params->ltafrac * t392;
  t398 = t136 * t397;
  t402 = my_piecewise3(t48, 0, -0.6e1 / 0.25e2 * t135 * t394 + 0.3e1 / 0.10e2 * t135 * t398);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[2] = t7 * t402;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t407 = t6 * t174 * t83 * t43;
  t411 = t6 * t77 * t186 * t43;
  t414 = 0.1e1 / t82 / t70;
  t418 = 0.5e1 / 0.36e2 * t6 * t26 * t414 * t43;
  t419 = t195 * params->ltafrac;
  t421 = 0.1e1 / t196 / rho[0];
  t422 = t419 * t421;
  t423 = t89 * t422;
  t426 = t6 * t174;
  t429 = t183 * t192;
  t432 = t186 * t43;
  t433 = t432 * t91;
  t434 = t88 * t433;
  t436 = t191 * t198;
  t437 = t88 * t436;
  t440 = 0.1e1 / t160 / t20;
  t441 = t162 * t74;
  t444 = t161 * t74;
  t447 = t70 * t70;
  t448 = 0.1e1 / t447;
  t449 = t17 * t448;
  t452 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t166 - 0.6e1 * t449);
  t456 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t440 * t441 + 0.4e1 / 0.3e1 * t444 * t170 + 0.4e1 / 0.3e1 * t24 * t452);
  t463 = t191 * t202;
  t464 = t88 * t463;
  t466 = t195 * t421;
  t467 = t89 * t466;
  t470 = params->ltafrac * t421;
  t471 = t89 * t470;
  t473 = -0.3e1 / 0.8e1 * t407 + t411 / 0.4e1 - t418 + 0.8e1 / 0.9e1 * t88 * t423 + 0.3e1 / 0.2e1 * t426 * t92 + t429 - 0.2e1 * t183 * t199 - t434 / 0.3e1 - 0.2e1 / 0.3e1 * t437 - 0.3e1 / 0.8e1 * t6 * t456 * t27 * t43 - 0.3e1 / 0.2e1 * t183 * t203 - t464 / 0.2e1 + 0.2e1 * t88 * t467 + t88 * t471;
  t474 = my_piecewise3(t2, 0, t473);
  t476 = 0.1e1 / t208 / t52;
  t477 = t210 * t99;
  t480 = t209 * t99;
  t483 = t49 * t448;
  t486 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t166 - 0.6e1 * t483);
  t490 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t476 * t477 + 0.4e1 / 0.3e1 * t480 * t216 + 0.4e1 / 0.3e1 * t54 * t486);
  t497 = t6 * t220 * t83 * t65;
  t501 = t6 * t102 * t186 * t65;
  t506 = 0.5e1 / 0.36e2 * t6 * t56 * t414 * t65;
  t508 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t490 * t27 * t65 - 0.3e1 / 0.8e1 * t497 + t501 / 0.4e1 - t506);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t207 + 0.3e1 * t234 + t7 * (t474 + t508);

  t511 = 0.2e1 * t260;
  t512 = 0.2e1 * t287;
  t513 = t440 * t116;
  t516 = t161 * t241;
  t521 = 0.2e1 * t166;
  t522 = 0.6e1 * t449;
  t524 = my_piecewise5(t11, 0, t15, 0, t521 - t522);
  t528 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t513 * t162 + 0.8e1 / 0.9e1 * t516 * t74 + 0.4e1 / 0.9e1 * t237 * t170 + 0.4e1 / 0.3e1 * t24 * t524);
  t536 = t6 * t245 * t83 * t43 / 0.4e1;
  t537 = t6 * t245;
  t541 = t6 * t119 * t186 * t43;
  t544 = t254 * t192 / 0.3e1;
  t555 = -0.3e1 / 0.8e1 * t6 * t528 * t27 * t43 - t536 + t537 * t92 + t541 / 0.12e2 + t544 - 0.2e1 / 0.3e1 * t254 * t199 - t254 * t203 / 0.2e1 - t407 / 0.8e1 + t411 / 0.6e1 + t429 / 0.3e1 - t418 - 0.2e1 / 0.9e1 * t434 - 0.2e1 / 0.9e1 * t437 - t464 / 0.6e1;
  t556 = my_piecewise3(t2, 0, t555);
  t557 = t476 * t127;
  t560 = t209 * t265;
  t565 = 0.6e1 * t483;
  t567 = my_piecewise5(t15, 0, t11, 0, -t521 - t565);
  t571 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t557 * t210 + 0.8e1 / 0.9e1 * t560 * t99 + 0.4e1 / 0.9e1 * t261 * t216 + 0.4e1 / 0.3e1 * t54 * t567);
  t579 = t6 * t269 * t83 * t65 / 0.4e1;
  t582 = t6 * t130 * t186 * t65;
  t586 = t6 * t220;
  t590 = t279 * t283 / 0.3e1;
  t591 = t186 * t65;
  t592 = t591 * t138;
  t593 = t135 * t592;
  t596 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t571 * t27 * t65 - t579 + t582 / 0.12e2 - t497 / 0.8e1 + t501 / 0.6e1 - t506 + t586 * t139 / 0.2e1 + t590 - t593 / 0.9e1);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t207 + t234 + t511 + t512 + t7 * (t556 + t596);

  t599 = t440 * t292;
  t604 = t161 * t297;
  t608 = my_piecewise5(t11, 0, t15, 0, -t521 - t522);
  t612 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t599 * t74 + 0.8e1 / 0.9e1 * t237 * t241 + 0.4e1 / 0.9e1 * t604 * t74 + 0.4e1 / 0.3e1 * t24 * t608);
  t619 = t6 * t301 * t83 * t43;
  t621 = t6 * t301;
  t628 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t612 * t27 * t43 - t619 / 0.8e1 + t621 * t92 / 0.2e1 - t536 + t541 / 0.6e1 + t544 + t411 / 0.12e2 - t418 - t434 / 0.9e1);
  t629 = t476 * t309;
  t634 = t209 * t314;
  t638 = my_piecewise5(t15, 0, t11, 0, t521 - t565);
  t642 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t629 * t99 + 0.8e1 / 0.9e1 * t261 * t265 + 0.4e1 / 0.9e1 * t634 * t99 + 0.4e1 / 0.3e1 * t54 * t638);
  t649 = t6 * t318 * t83 * t65;
  t652 = t6 * t269;
  t654 = t324 * t283;
  t660 = t282 * t329;
  t661 = t135 * t660;
  t665 = t282 * t333;
  t666 = t135 * t665;
  t668 = -0.3e1 / 0.8e1 * t6 * t642 * t27 * t65 - t649 / 0.8e1 - t579 + t582 / 0.6e1 + t652 * t139 + t654 / 0.3e1 + t501 / 0.12e2 - t506 + t590 - 0.2e1 / 0.9e1 * t593 - 0.2e1 / 0.3e1 * t279 * t330 - 0.2e1 / 0.9e1 * t661 - t279 * t334 / 0.2e1 - t666 / 0.6e1;
  t669 = my_piecewise3(t48, 0, t668);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t511 + t512 + t308 + t338 + t7 * (t628 + t669);

  t674 = t292 * t116;
  t681 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t166 - 0.6e1 * t449);
  t685 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t440 * t674 + 0.4e1 / 0.3e1 * t237 * t297 + 0.4e1 / 0.3e1 * t24 * t681);
  t693 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t685 * t27 * t43 - 0.3e1 / 0.8e1 * t619 + t541 / 0.4e1 - t418);
  t694 = t309 * t127;
  t701 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t166 - 0.6e1 * t483);
  t705 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t476 * t694 + 0.4e1 / 0.3e1 * t261 * t314 + 0.4e1 / 0.3e1 * t54 * t701);
  t713 = 0.1e1 / t327 / rho[1];
  t714 = t419 * t713;
  t715 = t136 * t714;
  t718 = t6 * t318;
  t728 = t195 * t713;
  t729 = t136 * t728;
  t732 = params->ltafrac * t713;
  t733 = t136 * t732;
  t735 = -0.3e1 / 0.8e1 * t6 * t705 * t27 * t65 - 0.3e1 / 0.8e1 * t649 - t506 + t582 / 0.4e1 + 0.8e1 / 0.9e1 * t135 * t715 + 0.3e1 / 0.2e1 * t718 * t139 - 0.2e1 * t324 * t330 - t593 / 0.3e1 + t654 - 0.2e1 / 0.3e1 * t661 - t666 / 0.2e1 - 0.3e1 / 0.2e1 * t324 * t334 + 0.2e1 * t135 * t729 + t135 * t733;
  t736 = my_piecewise3(t48, 0, t735);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t308 + 0.3e1 * t338 + t7 * (t693 + t736);

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[5] = 0.0e0;

  t742 = t183 * t343;
  t744 = t6 * t78;
  t747 = t432 * t147;
  t749 = t88 * t747 / 0.15e2;
  t750 = t6 * t84;
  t751 = t750 * t349;
  t753 = t43 * t419;
  t754 = t197 * t146;
  t755 = t753 * t754;
  t758 = t347 * t754;
  t762 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t426 * t148 - t742 / 0.5e1 + 0.4e1 / 0.5e1 * t744 * t349 + t749 + 0.4e1 / 0.15e2 * t751 - 0.8e1 / 0.15e2 * t346 * t755 - 0.2e1 / 0.5e1 * t346 * t758);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = t7 * t762 + 0.2e1 * t353;

  t767 = t279 * t357;
  t769 = t591 * t153;
  t771 = t135 * t769 / 0.15e2;
  t773 = my_piecewise3(t48, 0, -0.3e1 / 0.10e2 * t586 * t154 - t767 / 0.5e1 + t771);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[1] = t7 * t773 + 0.2e1 * t361;

  t777 = t254 * t343;
  t779 = t6 * t120;
  t785 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t537 * t148 - t777 / 0.10e2 + 0.2e1 / 0.5e1 * t779 * t349 - t742 / 0.10e2 + t749 + 0.2e1 / 0.15e2 * t751);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[2] = t7 * t785 + t353 + t366;

  t789 = t324 * t357;
  t792 = t6 * t103;
  t795 = t6 * t107;
  t796 = t795 * t373;
  t799 = my_piecewise3(t48, 0, -0.3e1 / 0.10e2 * t652 * t154 - t789 / 0.10e2 - t767 / 0.10e2 + t771 + 0.2e1 / 0.5e1 * t792 * t373 + 0.2e1 / 0.15e2 * t796);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[3] = t7 * t799 + t361 + t377;

  t806 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t621 * t148 - t777 / 0.5e1 + t749);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[4] = t7 * t806 + 0.2e1 * t366;

  t812 = t6 * t131;
  t816 = t65 * t419;
  t817 = t328 * t152;
  t818 = t816 * t817;
  t821 = t371 * t817;
  t825 = my_piecewise3(t48, 0, -0.3e1 / 0.10e2 * t718 * t154 - t789 / 0.5e1 + 0.4e1 / 0.5e1 * t812 * t373 + t771 + 0.4e1 / 0.15e2 * t796 - 0.8e1 / 0.15e2 * t370 * t818 - 0.2e1 / 0.5e1 * t370 * t821);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[5] = t7 * t825 + 0.2e1 * t377;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[7] = 0.0e0;

  t829 = t191 * t381;
  t831 = 0.2e1 / 0.25e2 * t88 * t829;
  t832 = t90 * t380;
  t833 = t753 * t832;
  t838 = t191 * t385;
  t840 = t88 * t838 / 0.10e2;
  t841 = t347 * t832;
  t845 = my_piecewise3(t2, 0, -0.6e1 / 0.25e2 * t183 * t382 - t831 + 0.8e1 / 0.25e2 * t346 * t833 + 0.3e1 / 0.10e2 * t183 * t386 + t840 - 0.2e1 / 0.5e1 * t346 * t841);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = t7 * t845 + t390;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[1] = 0.0e0;

  t849 = t282 * t393;
  t851 = 0.2e1 / 0.25e2 * t135 * t849;
  t854 = t282 * t397;
  t856 = t135 * t854 / 0.10e2;
  t858 = my_piecewise3(t48, 0, -0.6e1 / 0.25e2 * t279 * t394 - t851 + 0.3e1 / 0.10e2 * t279 * t398 + t856);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[2] = t7 * t858 + t402;

  t865 = my_piecewise3(t2, 0, -0.6e1 / 0.25e2 * t254 * t382 - t831 + 0.3e1 / 0.10e2 * t254 * t386 + t840);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[3] = t7 * t865 + t390;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[4] = 0.0e0;

  t869 = t137 * t392;
  t870 = t816 * t869;
  t875 = t371 * t869;
  t879 = my_piecewise3(t48, 0, -0.6e1 / 0.25e2 * t324 * t394 - t851 + 0.8e1 / 0.25e2 * t370 * t870 + 0.3e1 / 0.10e2 * t324 * t398 + t856 - 0.2e1 / 0.5e1 * t370 * t875);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[5] = t7 * t879 + t402;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[5] = 0.0e0;

  t882 = 0.1e1 / t379 / tau[0];
  t883 = t419 * t882;
  t884 = t89 * t883;
  t887 = t195 * t882;
  t888 = t89 * t887;
  t891 = params->ltafrac * t882;
  t892 = t89 * t891;
  t896 = my_piecewise3(t2, 0, -0.24e2 / 0.125e3 * t88 * t884 + 0.18e2 / 0.25e2 * t88 * t888 - 0.3e1 / 0.5e1 * t88 * t892);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = t7 * t896;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[2] = 0.0e0;

  t898 = 0.1e1 / t391 / tau[1];
  t899 = t419 * t898;
  t900 = t136 * t899;
  t903 = t195 * t898;
  t904 = t136 * t903;
  t907 = params->ltafrac * t898;
  t908 = t136 * t907;
  t912 = my_piecewise3(t48, 0, -0.24e2 / 0.125e3 * t135 * t900 + 0.18e2 / 0.25e2 * t135 * t904 - 0.3e1 / 0.5e1 * t135 * t908);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[3] = t7 * t912;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t915 = t20 * t20;
  t917 = 0.1e1 / t160 / t915;
  t918 = t162 * t162;
  t924 = t170 * t170;
  t930 = 0.1e1 / t447 / t7;
  t931 = t17 * t930;
  t934 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t448 + 0.24e2 * t931);
  t938 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t917 * t918 - 0.16e2 / 0.9e1 * t440 * t162 * t170 + 0.4e1 / 0.3e1 * t161 * t924 + 0.16e2 / 0.9e1 * t444 * t452 + 0.4e1 / 0.3e1 * t24 * t934);
  t945 = t6 * t456 * t83 * t43;
  t949 = t6 * t174 * t186 * t43;
  t953 = t6 * t77 * t414 * t43;
  t956 = 0.1e1 / t82 / t165;
  t960 = 0.10e2 / 0.27e2 * t6 * t26 * t956 * t43;
  t961 = t414 * t43;
  t963 = t88 * t961 * t91;
  t968 = t88 * t191 * t466;
  t973 = t88 * t191 * t470;
  t975 = t196 * t196;
  t976 = 0.1e1 / t975;
  t985 = -0.3e1 / 0.8e1 * t6 * t938 * t27 * t43 - t945 / 0.2e1 + t949 / 0.2e1 - 0.5e1 / 0.9e1 * t953 + t960 + 0.20e2 / 0.27e2 * t963 + 0.32e2 / 0.9e1 * t183 * t423 + 0.8e1 / 0.3e1 * t968 + 0.4e1 * t183 * t471 + 0.4e1 / 0.3e1 * t973 - 0.22e2 / 0.3e1 * t88 * t89 * t195 * t976 - 0.3e1 * t88 * t89 * params->ltafrac * t976;
  t987 = t88 * t191 * t422;
  t995 = t183 * t463;
  t1000 = t88 * t432 * t202;
  t1002 = t195 * t195;
  t1007 = t6 * t456;
  t1012 = t183 * t436;
  t1015 = t88 * t432 * t198;
  t1017 = t426 * t192;
  t1019 = t183 * t433;
  t1021 = 0.32e2 / 0.27e2 * t987 - 0.16e2 / 0.3e1 * t88 * t89 * t419 * t976 - 0.3e1 * t426 * t203 - 0.2e1 * t995 + 0.8e1 * t183 * t467 + 0.2e1 / 0.3e1 * t1000 - 0.32e2 / 0.27e2 * t88 * t89 * t1002 * t976 + 0.2e1 * t1007 * t92 - 0.4e1 * t426 * t199 - 0.8e1 / 0.3e1 * t1012 + 0.8e1 / 0.9e1 * t1015 + 0.2e1 * t1017 - 0.4e1 / 0.3e1 * t1019;
  t1023 = my_piecewise3(t2, 0, t985 + t1021);
  t1024 = t52 * t52;
  t1026 = 0.1e1 / t208 / t1024;
  t1027 = t210 * t210;
  t1033 = t216 * t216;
  t1038 = t49 * t930;
  t1041 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t448 + 0.24e2 * t1038);
  t1045 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1026 * t1027 - 0.16e2 / 0.9e1 * t476 * t210 * t216 + 0.4e1 / 0.3e1 * t209 * t1033 + 0.16e2 / 0.9e1 * t480 * t486 + 0.4e1 / 0.3e1 * t54 * t1041);
  t1052 = t6 * t490 * t83 * t65;
  t1056 = t6 * t220 * t186 * t65;
  t1060 = t6 * t102 * t414 * t65;
  t1065 = 0.10e2 / 0.27e2 * t6 * t56 * t956 * t65;
  t1067 = my_piecewise3(t48, 0, -0.3e1 / 0.8e1 * t6 * t1045 * t27 * t65 - t1052 / 0.2e1 + t1056 / 0.2e1 - 0.5e1 / 0.9e1 * t1060 + t1065);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t474 + 0.4e1 * t508 + t7 * (t1023 + t1067);

  t1088 = 0.12e2 * t448;
  t1089 = 0.24e2 * t931;
  t1091 = my_piecewise5(t11, 0, t15, 0, -t1088 + t1089);
  t1095 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t917 * t116 * t441 - 0.8e1 / 0.9e1 * t440 * t241 * t162 - 0.8e1 / 0.9e1 * t513 * t74 * t170 + 0.4e1 / 0.3e1 * t161 * t524 * t74 + 0.4e1 / 0.3e1 * t516 * t170 + 0.4e1 / 0.9e1 * t237 * t452 + 0.4e1 / 0.3e1 * t24 * t1091);
  t1102 = t6 * t528 * t83 * t43;
  t1106 = t6 * t245 * t186 * t43;
  t1107 = t1106 / 0.4e1;
  t1110 = t6 * t119 * t414 * t43;
  t1121 = t254 * t463;
  t1125 = -0.3e1 / 0.8e1 * t6 * t1095 * t27 * t43 - 0.3e1 / 0.8e1 * t1102 + t1107 - 0.5e1 / 0.36e2 * t1110 - t945 / 0.8e1 + t949 / 0.4e1 - 0.5e1 / 0.12e2 * t953 + t960 + 0.5e1 / 0.9e1 * t963 + 0.2e1 * t254 * t467 + t254 * t471 - 0.3e1 / 0.2e1 * t537 * t203 - t1121 / 0.2e1 + 0.8e1 / 0.9e1 * t254 * t423;
  t1126 = t6 * t528;
  t1129 = t537 * t192;
  t1132 = t254 * t433;
  t1133 = t1132 / 0.3e1;
  t1134 = t254 * t436;
  t1145 = 0.3e1 / 0.2e1 * t1126 * t92 + t1129 - 0.2e1 * t537 * t199 - t1133 - 0.2e1 / 0.3e1 * t1134 + 0.2e1 / 0.3e1 * t968 + t973 / 0.3e1 + 0.8e1 / 0.27e2 * t987 - t995 / 0.2e1 + t1000 / 0.3e1 - 0.2e1 / 0.3e1 * t1012 + 0.4e1 / 0.9e1 * t1015 + t1017 / 0.2e1 - 0.2e1 / 0.3e1 * t1019;
  t1147 = my_piecewise3(t2, 0, t1125 + t1145);
  t1164 = 0.24e2 * t1038;
  t1166 = my_piecewise5(t15, 0, t11, 0, t1088 + t1164);
  t1170 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1026 * t127 * t477 - 0.8e1 / 0.9e1 * t476 * t265 * t210 - 0.8e1 / 0.9e1 * t557 * t99 * t216 + 0.4e1 / 0.3e1 * t209 * t567 * t99 + 0.4e1 / 0.3e1 * t560 * t216 + 0.4e1 / 0.9e1 * t261 * t486 + 0.4e1 / 0.3e1 * t54 * t1166);
  t1177 = t6 * t571 * t83 * t65;
  t1181 = t6 * t269 * t186 * t65;
  t1182 = t1181 / 0.4e1;
  t1185 = t6 * t130 * t414 * t65;
  t1190 = t6 * t490;
  t1193 = t586 * t283;
  t1195 = t279 * t592;
  t1196 = t1195 / 0.3e1;
  t1197 = t414 * t65;
  t1199 = t135 * t1197 * t138;
  t1201 = -0.3e1 / 0.8e1 * t6 * t1170 * t27 * t65 - 0.3e1 / 0.8e1 * t1177 + t1182 - 0.5e1 / 0.36e2 * t1185 - t1052 / 0.8e1 + t1056 / 0.4e1 - 0.5e1 / 0.12e2 * t1060 + t1065 + t1190 * t139 / 0.2e1 + t1193 / 0.2e1 - t1196 + 0.5e1 / 0.27e2 * t1199;
  t1202 = my_piecewise3(t48, 0, t1201);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t474 + t508 + 0.3e1 * t556 + 0.3e1 * t596 + t7 * (t1147 + t1202);

  t1219 = t241 * t241;
  t1232 = my_piecewise5(t11, 0, t15, 0, t1089);
  t1236 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t917 * t292 * t162 - 0.32e2 / 0.27e2 * t513 * t74 * t241 - 0.8e1 / 0.27e2 * t599 * t170 + 0.8e1 / 0.9e1 * t161 * t1219 + 0.8e1 / 0.9e1 * t237 * t524 - 0.8e1 / 0.27e2 * t440 * t297 * t162 + 0.8e1 / 0.9e1 * t161 * t608 * t74 + 0.4e1 / 0.9e1 * t604 * t170 + 0.4e1 / 0.3e1 * t24 * t1232);
  t1243 = t6 * t612 * t83 * t43;
  t1247 = t6 * t301 * t186 * t43;
  t1257 = t6 * t612;
  t1259 = t621 * t192;
  t1269 = -t1121 / 0.3e1 + t1000 / 0.9e1 + t1257 * t92 + t1259 / 0.3e1 - 0.2e1 / 0.3e1 * t621 * t199 + 0.2e1 / 0.3e1 * t1129 - 0.4e1 / 0.9e1 * t1132 - 0.4e1 / 0.9e1 * t1134 + 0.4e1 / 0.27e2 * t1015 - 0.2e1 / 0.9e1 * t1019 + 0.10e2 / 0.27e2 * t963;
  t1271 = my_piecewise3(t2, 0, -t621 * t203 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t1236 * t27 * t43 - t1243 / 0.4e1 + t1247 / 0.12e2 - t1102 / 0.4e1 + t1106 / 0.3e1 - 0.5e1 / 0.18e2 * t1110 + t949 / 0.12e2 - 0.5e1 / 0.18e2 * t953 + t960 + t1269);
  t1272 = t279 * t665;
  t1275 = t135 * t591 * t333;
  t1277 = t652 * t283;
  t1279 = t324 * t592;
  t1281 = t279 * t660;
  t1284 = t135 * t591 * t329;
  t1294 = t265 * t265;
  t1307 = my_piecewise5(t15, 0, t11, 0, t1164);
  t1311 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1026 * t309 * t210 - 0.32e2 / 0.27e2 * t557 * t99 * t265 - 0.8e1 / 0.27e2 * t629 * t216 + 0.8e1 / 0.9e1 * t209 * t1294 + 0.8e1 / 0.9e1 * t261 * t567 - 0.8e1 / 0.27e2 * t476 * t314 * t210 + 0.8e1 / 0.9e1 * t209 * t638 * t99 + 0.4e1 / 0.9e1 * t634 * t216 + 0.4e1 / 0.3e1 * t54 * t1307);
  t1318 = t6 * t642 * t83 * t65;
  t1322 = t6 * t318 * t186 * t65;
  t1333 = t6 * t571;
  t1339 = t1181 / 0.3e1 - 0.5e1 / 0.18e2 * t1185 + t1056 / 0.12e2 - 0.5e1 / 0.18e2 * t1060 + t1065 + t1193 / 0.3e1 - 0.4e1 / 0.9e1 * t1195 + 0.10e2 / 0.27e2 * t1199 + t1333 * t139 - 0.2e1 / 0.3e1 * t586 * t330 - t586 * t334 / 0.2e1;
  t1341 = my_piecewise3(t48, 0, -t1272 / 0.3e1 + t1275 / 0.9e1 + 0.2e1 / 0.3e1 * t1277 - 0.2e1 / 0.9e1 * t1279 - 0.4e1 / 0.9e1 * t1281 + 0.4e1 / 0.27e2 * t1284 - 0.3e1 / 0.8e1 * t6 * t1311 * t27 * t65 - t1318 / 0.4e1 + t1322 / 0.12e2 - t1177 / 0.4e1 + t1339);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t556 + 0.2e1 * t596 + 0.2e1 * t628 + 0.2e1 * t669 + t7 * (t1271 + t1341);

  t1362 = my_piecewise5(t11, 0, t15, 0, t1088 + t1089);
  t1366 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t917 * t674 * t74 - 0.8e1 / 0.9e1 * t599 * t241 - 0.8e1 / 0.9e1 * t513 * t297 * t74 + 0.4e1 / 0.3e1 * t516 * t297 + 0.4e1 / 0.3e1 * t237 * t608 + 0.4e1 / 0.9e1 * t161 * t681 * t74 + 0.4e1 / 0.3e1 * t24 * t1362);
  t1373 = t6 * t685 * t83 * t43;
  t1375 = t6 * t685;
  t1384 = -0.3e1 / 0.8e1 * t6 * t1366 * t27 * t43 - t1373 / 0.8e1 + t1375 * t92 / 0.2e1 - 0.3e1 / 0.8e1 * t1243 + t1247 / 0.4e1 + t1259 / 0.2e1 + t1107 - 0.5e1 / 0.12e2 * t1110 - t1133 - 0.5e1 / 0.36e2 * t953 + t960 + 0.5e1 / 0.27e2 * t963;
  t1385 = my_piecewise3(t2, 0, t1384);
  t1388 = t6 * t705 * t83 * t65;
  t1406 = my_piecewise5(t15, 0, t11, 0, -t1088 + t1164);
  t1410 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1026 * t694 * t99 - 0.8e1 / 0.9e1 * t629 * t265 - 0.8e1 / 0.9e1 * t557 * t314 * t99 + 0.4e1 / 0.3e1 * t560 * t314 + 0.4e1 / 0.3e1 * t261 * t638 + 0.4e1 / 0.9e1 * t209 * t701 * t99 + 0.4e1 / 0.3e1 * t54 * t1406);
  t1419 = t6 * t642;
  t1431 = -t1388 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t1410 * t27 * t65 - 0.3e1 / 0.8e1 * t1318 + t1322 / 0.4e1 + t1182 - 0.5e1 / 0.12e2 * t1185 - 0.5e1 / 0.36e2 * t1060 + t1065 + 0.3e1 / 0.2e1 * t1419 * t139 - 0.2e1 * t652 * t330 - 0.3e1 / 0.2e1 * t652 * t334 + 0.2e1 * t279 * t729 + t279 * t733 + 0.8e1 / 0.9e1 * t279 * t715;
  t1437 = t324 * t660;
  t1439 = t324 * t665;
  t1442 = t135 * t282 * t728;
  t1445 = t135 * t282 * t732;
  t1448 = t135 * t282 * t714;
  t1450 = t718 * t283;
  t1453 = -t1272 / 0.2e1 + t1275 / 0.3e1 + t1277 - 0.2e1 / 0.3e1 * t1279 - 0.2e1 / 0.3e1 * t1281 + 0.4e1 / 0.9e1 * t1284 - 0.2e1 / 0.3e1 * t1437 - t1439 / 0.2e1 + 0.2e1 / 0.3e1 * t1442 + t1445 / 0.3e1 + 0.8e1 / 0.27e2 * t1448 + t1450 / 0.2e1 - t1196 + 0.5e1 / 0.9e1 * t1199;
  t1455 = my_piecewise3(t48, 0, t1431 + t1453);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t628 + 0.3e1 * t669 + t693 + t736 + t7 * (t1385 + t1455);

  t1460 = t292 * t292;
  t1465 = t297 * t297;
  t1472 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t448 + 0.24e2 * t931);
  t1476 = my_piecewise3(t21, 0, 0.40e2 / 0.81e2 * t917 * t1460 - 0.16e2 / 0.9e1 * t599 * t297 + 0.4e1 / 0.3e1 * t161 * t1465 + 0.16e2 / 0.9e1 * t237 * t681 + 0.4e1 / 0.3e1 * t24 * t1472);
  t1485 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1476 * t27 * t43 - t1373 / 0.2e1 + t1247 / 0.2e1 - 0.5e1 / 0.9e1 * t1110 + t960);
  t1486 = t309 * t309;
  t1491 = t314 * t314;
  t1498 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t448 + 0.24e2 * t1038);
  t1502 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1026 * t1486 - 0.16e2 / 0.9e1 * t629 * t314 + 0.4e1 / 0.3e1 * t209 * t1491 + 0.16e2 / 0.9e1 * t261 * t701 + 0.4e1 / 0.3e1 * t54 * t1498);
  t1512 = t327 * t327;
  t1513 = 0.1e1 / t1512;
  t1534 = -0.3e1 / 0.8e1 * t6 * t1502 * t27 * t65 - t1388 / 0.2e1 + t1322 / 0.2e1 - 0.5e1 / 0.9e1 * t1185 + t1065 + 0.4e1 * t324 * t733 - 0.22e2 / 0.3e1 * t135 * t136 * t195 * t1513 - 0.3e1 * t135 * t136 * params->ltafrac * t1513 - 0.16e2 / 0.3e1 * t135 * t136 * t419 * t1513 - 0.3e1 * t718 * t334 + 0.8e1 * t324 * t729 - 0.32e2 / 0.27e2 * t135 * t136 * t1002 * t1513;
  t1537 = t6 * t705;
  t1552 = -0.4e1 * t718 * t330 + 0.2e1 * t1537 * t139 + 0.32e2 / 0.9e1 * t324 * t715 + 0.2e1 / 0.3e1 * t1275 - 0.4e1 / 0.3e1 * t1279 + 0.8e1 / 0.9e1 * t1284 - 0.8e1 / 0.3e1 * t1437 - 0.2e1 * t1439 + 0.8e1 / 0.3e1 * t1442 + 0.4e1 / 0.3e1 * t1445 + 0.32e2 / 0.27e2 * t1448 + 0.2e1 * t1450 + 0.20e2 / 0.27e2 * t1199;
  t1554 = my_piecewise3(t48, 0, t1534 + t1552);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t693 + 0.4e1 * t736 + t7 * (t1485 + t1554);

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[7] = 0.0e0;

  t1559 = t6 * t179 * t349;
  t1565 = t88 * t961 * t147 / 0.9e1;
  t1567 = t6 * t187 * t349;
  t1569 = t750 * t755;
  t1571 = t43 * t1002;
  t1572 = t421 * t146;
  t1576 = t426 * t343;
  t1581 = t183 * t747;
  t1583 = t750 * t758;
  t1595 = 0.4e1 / 0.5e1 * t1559 - 0.8e1 / 0.5e1 * t744 * t755 - t1565 - 0.4e1 / 0.15e2 * t1567 - 0.8e1 / 0.15e2 * t1569 + 0.32e2 / 0.45e2 * t346 * t1571 * t1572 - 0.3e1 / 0.10e2 * t1576 + 0.6e1 / 0.5e1 * t6 * t175 * t349 + t1581 / 0.5e1 - 0.2e1 / 0.5e1 * t1583 + 0.8e1 / 0.5e1 * t346 * t753 * t1572 + 0.4e1 / 0.5e1 * t346 * t347 * t1572 - 0.6e1 / 0.5e1 * t744 * t758 - 0.3e1 / 0.10e2 * t1007 * t148;
  t1596 = my_piecewise3(t2, 0, t1595);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = t7 * t1596 + 0.3e1 * t762;

  t1601 = t586 * t357;
  t1603 = t279 * t769;
  t1607 = t135 * t1197 * t153 / 0.9e1;
  t1609 = my_piecewise3(t48, 0, -0.3e1 / 0.10e2 * t1190 * t154 - 0.3e1 / 0.10e2 * t1601 + t1603 / 0.5e1 - t1607);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[1] = t7 * t1609 + 0.3e1 * t773;

  t1611 = 0.2e1 * t785;
  t1615 = t537 * t343 / 0.5e1;
  t1619 = t254 * t747;
  t1623 = 0.4e1 / 0.15e2 * t6 * t250 * t349;
  t1634 = -0.3e1 / 0.10e2 * t1126 * t148 - t1615 + 0.4e1 / 0.5e1 * t6 * t246 * t349 + t1619 / 0.15e2 + t1623 - 0.8e1 / 0.15e2 * t779 * t755 - 0.2e1 / 0.5e1 * t779 * t758 - t1576 / 0.10e2 + 0.2e1 / 0.15e2 * t1581 + 0.4e1 / 0.15e2 * t1559 - t1565 - 0.8e1 / 0.45e2 * t1567 - 0.8e1 / 0.45e2 * t1569 - 0.2e1 / 0.15e2 * t1583;
  t1635 = my_piecewise3(t2, 0, t1634);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[2] = t7 * t1635 + t1611 + t762;

  t1637 = 0.2e1 * t799;
  t1641 = t652 * t357 / 0.5e1;
  t1642 = t324 * t769;
  t1651 = 0.4e1 / 0.15e2 * t6 * t225 * t373;
  t1653 = t6 * t229 * t373;
  t1656 = my_piecewise3(t48, 0, -0.3e1 / 0.10e2 * t1333 * t154 - t1641 + t1642 / 0.15e2 - t1601 / 0.10e2 + 0.2e1 / 0.15e2 * t1603 - t1607 + 0.2e1 / 0.5e1 * t6 * t221 * t373 + t1651 - 0.4e1 / 0.45e2 * t1653);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[3] = t7 * t1656 + t1637 + t773;

  t1660 = t621 * t343;
  t1669 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t1257 * t148 - t1660 / 0.10e2 + 0.2e1 / 0.5e1 * t6 * t302 * t349 - t1615 + 0.2e1 / 0.15e2 * t1619 + t1623 + t1581 / 0.15e2 - t1565 - 0.4e1 / 0.45e2 * t1567);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[4] = t7 * t1669 + t1611 + t806;

  t1673 = t718 * t357;
  t1680 = t6 * t274 * t373;
  t1686 = t795 * t818;
  t1690 = t795 * t821;
  t1692 = -0.3e1 / 0.10e2 * t1419 * t154 - t1673 / 0.10e2 - t1641 + 0.2e1 / 0.15e2 * t1642 + 0.4e1 / 0.5e1 * t6 * t270 * t373 + 0.4e1 / 0.15e2 * t1680 + t1603 / 0.15e2 - t1607 + t1651 - 0.8e1 / 0.45e2 * t1653 - 0.8e1 / 0.15e2 * t792 * t818 - 0.8e1 / 0.45e2 * t1686 - 0.2e1 / 0.5e1 * t792 * t821 - 0.2e1 / 0.15e2 * t1690;
  t1693 = my_piecewise3(t48, 0, t1692);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[5] = t7 * t1693 + t1637 + t825;

  t1701 = my_piecewise3(t2, 0, -0.3e1 / 0.10e2 * t1375 * t148 - 0.3e1 / 0.10e2 * t1660 + t1619 / 0.5e1 - t1565);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[6] = t7 * t1701 + 0.3e1 * t806;

  t1706 = t65 * t1002;
  t1707 = t713 * t152;
  t1730 = -0.3e1 / 0.10e2 * t1537 * t154 + 0.32e2 / 0.45e2 * t370 * t1706 * t1707 + 0.6e1 / 0.5e1 * t6 * t319 * t373 - 0.8e1 / 0.5e1 * t812 * t818 - 0.3e1 / 0.10e2 * t1673 + t1642 / 0.5e1 - t1607 + 0.8e1 / 0.5e1 * t370 * t816 * t1707 + 0.4e1 / 0.5e1 * t370 * t371 * t1707 - 0.2e1 / 0.5e1 * t1690 - 0.6e1 / 0.5e1 * t812 * t821 - 0.4e1 / 0.15e2 * t1653 + 0.4e1 / 0.5e1 * t1680 - 0.8e1 / 0.15e2 * t1686;
  t1731 = my_piecewise3(t48, 0, t1730);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[7] = t7 * t1731 + 0.3e1 * t825;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[11] = 0.0e0;

  t1736 = t183 * t829;
  t1742 = 0.4e1 / 0.75e2 * t88 * t432 * t381;
  t1743 = t750 * t833;
  t1745 = t197 * t380;
  t1754 = t183 * t838;
  t1760 = t88 * t432 * t385 / 0.15e2;
  t1761 = t750 * t841;
  t1766 = -0.6e1 / 0.25e2 * t426 * t382 - 0.4e1 / 0.25e2 * t1736 + 0.16e2 / 0.25e2 * t744 * t833 + t1742 + 0.16e2 / 0.75e2 * t1743 - 0.32e2 / 0.75e2 * t346 * t1571 * t1745 + 0.16e2 / 0.75e2 * t346 * t753 * t1745 + 0.3e1 / 0.10e2 * t426 * t386 + t1754 / 0.5e1 - 0.4e1 / 0.5e1 * t744 * t841 - t1760 - 0.4e1 / 0.15e2 * t1761 + 0.2e1 / 0.5e1 * t346 * t347 * t1745;
  t1767 = my_piecewise3(t2, 0, t1766);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = t7 * t1767 + 0.2e1 * t845;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[1] = 0.0e0;

  t1772 = t279 * t849;
  t1776 = 0.4e1 / 0.75e2 * t135 * t591 * t393;
  t1779 = t279 * t854;
  t1783 = t135 * t591 * t397 / 0.15e2;
  t1785 = my_piecewise3(t48, 0, -0.6e1 / 0.25e2 * t586 * t394 - 0.4e1 / 0.25e2 * t1772 + t1776 + 0.3e1 / 0.10e2 * t586 * t398 + t1779 / 0.5e1 - t1783);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[2] = t7 * t1785 + 0.2e1 * t858;

  t1789 = t254 * t829;
  t1797 = t254 * t838;
  t1803 = -0.6e1 / 0.25e2 * t537 * t382 - 0.2e1 / 0.25e2 * t1789 + 0.8e1 / 0.25e2 * t779 * t833 - 0.2e1 / 0.25e2 * t1736 + t1742 + 0.8e1 / 0.75e2 * t1743 + 0.3e1 / 0.10e2 * t537 * t386 + t1797 / 0.10e2 - 0.2e1 / 0.5e1 * t779 * t841 + t1754 / 0.10e2 - t1760 - 0.2e1 / 0.15e2 * t1761;
  t1804 = my_piecewise3(t2, 0, t1803);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[3] = t7 * t1804 + t845 + t865;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[4] = 0.0e0;

  t1808 = t324 * t849;
  t1813 = t795 * t870;
  t1817 = t324 * t854;
  t1822 = t795 * t875;
  t1824 = -0.6e1 / 0.25e2 * t652 * t394 - 0.2e1 / 0.25e2 * t1808 - 0.2e1 / 0.25e2 * t1772 + t1776 + 0.8e1 / 0.25e2 * t792 * t870 + 0.8e1 / 0.75e2 * t1813 + 0.3e1 / 0.10e2 * t652 * t398 + t1817 / 0.10e2 + t1779 / 0.10e2 - t1783 - 0.2e1 / 0.5e1 * t792 * t875 - 0.2e1 / 0.15e2 * t1822;
  t1825 = my_piecewise3(t48, 0, t1824);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[5] = t7 * t1825 + t858 + t879;

  t1835 = my_piecewise3(t2, 0, -0.6e1 / 0.25e2 * t621 * t382 - 0.4e1 / 0.25e2 * t1789 + t1742 + 0.3e1 / 0.10e2 * t621 * t386 + t1797 / 0.5e1 - t1760);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[6] = t7 * t1835 + 0.2e1 * t865;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[7] = 0.0e0;

  t1844 = t328 * t392;
  t1860 = -0.6e1 / 0.25e2 * t718 * t394 - 0.4e1 / 0.25e2 * t1808 + 0.16e2 / 0.25e2 * t812 * t870 + t1776 + 0.16e2 / 0.75e2 * t1813 - 0.32e2 / 0.75e2 * t370 * t1706 * t1844 + 0.16e2 / 0.75e2 * t370 * t816 * t1844 + 0.3e1 / 0.10e2 * t718 * t398 + t1817 / 0.5e1 - 0.4e1 / 0.5e1 * t812 * t875 - t1783 - 0.4e1 / 0.15e2 * t1822 + 0.2e1 / 0.5e1 * t370 * t371 * t1844;
  t1861 = my_piecewise3(t48, 0, t1860);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[8] = t7 * t1861 + 0.2e1 * t879;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[11] = 0.0e0;

  t1867 = 0.8e1 / 0.125e3 * t88 * t191 * t883;
  t1868 = t90 * t882;
  t1876 = 0.6e1 / 0.25e2 * t88 * t191 * t887;
  t1884 = t88 * t191 * t891 / 0.5e1;
  t1889 = my_piecewise3(t2, 0, -0.24e2 / 0.125e3 * t183 * t884 - t1867 + 0.32e2 / 0.125e3 * t346 * t1571 * t1868 + 0.18e2 / 0.25e2 * t183 * t888 + t1876 - 0.24e2 / 0.25e2 * t346 * t753 * t1868 - 0.3e1 / 0.5e1 * t183 * t892 - t1884 + 0.4e1 / 0.5e1 * t346 * t347 * t1868);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = t7 * t1889 + t896;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[2] = 0.0e0;

  t1895 = 0.8e1 / 0.125e3 * t135 * t282 * t899;
  t1900 = 0.6e1 / 0.25e2 * t135 * t282 * t903;
  t1905 = t135 * t282 * t907 / 0.5e1;
  t1907 = my_piecewise3(t48, 0, -0.24e2 / 0.125e3 * t279 * t900 - t1895 + 0.18e2 / 0.25e2 * t279 * t904 + t1900 - 0.3e1 / 0.5e1 * t279 * t908 - t1905);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[3] = t7 * t1907 + t912;

  t1916 = my_piecewise3(t2, 0, -0.24e2 / 0.125e3 * t254 * t884 - t1867 + 0.18e2 / 0.25e2 * t254 * t888 + t1876 - 0.3e1 / 0.5e1 * t254 * t892 - t1884);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[4] = t7 * t1916 + t896;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[6] = 0.0e0;

  t1920 = t137 * t898;
  t1935 = my_piecewise3(t48, 0, -0.24e2 / 0.125e3 * t324 * t900 - t1895 + 0.32e2 / 0.125e3 * t370 * t1706 * t1920 + 0.18e2 / 0.25e2 * t324 * t904 + t1900 - 0.24e2 / 0.25e2 * t370 * t816 * t1920 - 0.3e1 / 0.5e1 * t324 * t908 - t1905 + 0.4e1 / 0.5e1 * t370 * t371 * t1920);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[7] = t7 * t1935 + t912;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[7] = 0.0e0;

  t1937 = t379 * t379;
  t1938 = 0.1e1 / t1937;
  t1956 = my_piecewise3(t2, 0, -0.96e2 / 0.625e3 * t88 * t89 * t1002 * t1938 + 0.144e3 / 0.125e3 * t88 * t89 * t419 * t1938 - 0.66e2 / 0.25e2 * t88 * t89 * t195 * t1938 + 0.9e1 / 0.5e1 * t88 * t89 * params->ltafrac * t1938);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = t7 * t1956;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[3] = 0.0e0;

  t1957 = t391 * t391;
  t1958 = 0.1e1 / t1957;
  t1976 = my_piecewise3(t48, 0, -0.96e2 / 0.625e3 * t135 * t136 * t1002 * t1958 + 0.144e3 / 0.125e3 * t135 * t136 * t419 * t1958 - 0.66e2 / 0.25e2 * t135 * t136 * t195 * t1958 + 0.9e1 / 0.5e1 * t135 * t136 * params->ltafrac * t1958);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[4] = t7 * t1976;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

