# mixin-deep [![NPM version](https://badge.fury.io/js/mixin-deep.svg)](http://badge.fury.io/js/mixin-deep)

> Deeply mix the properties of objects into the first object. Like merge-deep, but doesn't clone.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i mixin-deep --save
```

Install with [bower](http://bower.io/)

```sh
$ bower install mixin-deep --save
```

## Usage

```js
var mixinDeep = require('mixin-deep');

mixinDeep({a: {aa: 'aa'}}, {a: {bb: 'bb'}}, {a: {cc: 'cc'}});
//=> { a: { aa: 'aa', bb: 'bb', cc: 'cc' } }
```

## Related projects

* [assign-deep](https://www.npmjs.com/package/assign-deep): Deeply assign the enumerable properties of source objects to a destination object. | [homepage](https://github.com/jonschlinkert/assign-deep)
* [defaults-deep](https://www.npmjs.com/package/defaults-deep): Like `extend` but recursively copies only the missing properties/values to the target object. | [homepage](https://github.com/jonschlinkert/defaults-deep)
* [extend-shallow](https://www.npmjs.com/package/extend-shallow): Extend an object with the properties of additional objects. node.js/javascript util. | [homepage](https://github.com/jonschlinkert/extend-shallow)
* [merge-deep](https://www.npmjs.com/package/merge-deep): Recursively merge values in a javascript object. | [homepage](https://github.com/jonschlinkert/merge-deep)
* [omit-deep](https://www.npmjs.com/package/omit-deep): Recursively omit the specified key or keys from an object. | [homepage](https://github.com/jonschlinkert/omit-deep)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/mixin-deep/issues/new).

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on August 28, 2015._
