###############################################################################
# OpenVAS Vulnerability Test
# $Id: cacti_34991.nasl 7671 2010-05-12 17:34:03Z mime $
#
# Cacti 'data_input.php' Cross Site Scripting Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100205);
 script_tag(name:"cvss_base", value:"4.3");
 script_cve_id("CVE-2008-0783");
 script_bugtraq_id(34991);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Cacti 'data_input.php' Cross Site Scripting Vulnerability");
 desc = "

 Overview:
  Cacti is prone to a cross-site scripting vulnerability because the
  application fails to sufficiently sanitize user-supplied input.

  An attacker may leverage this issue to execute arbitrary script code
  in the browser of an unsuspecting user in the context of the
  affected site. This may let the attacker steal cookie-based
  authentication credentials and launch other attacks.

  Versions prior to Cacti 0.8.7b are vulnerable. 

 See also:
  http://www.securityfocus.com/bid/34991

 Solution:
  Updates are available. Please see http://cacti.net/ for more
  information.  

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Cacti Version < 0.8.7b");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("cacti_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if(!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/cacti")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "0.8.7b")) {
      security_warning(port:port);
      exit(0);
  }  

} 

exit(0);
