# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1222-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57686);
 script_cve_id("CVE-2006-5815", "CVE-2006-6170", "CVE-2006-6171");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1222-2 (proftpd)";
 script_name(name);

 desc = "The remote host is missing an update to proftpd
announced via advisory DSA 1222-2.

Due to technical problems yesterday's proftpd update lacked a build for
the amd64 architecture, which is now available.

Several remote vulnerabilities have been discovered in the proftpd FTP
daemon, which may lead to the execution of arbitrary code or denial
of service. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2006-5815

It was discovered that a buffer overflow in the sreplace() function
may lead to denial of service and possibly the execution of arbitrary
code.

CVE-2006-6170

It was discovered that a buffer overflow in the mod_tls addon module
may lead to the execution of arbitrary code.

CVE-2006-6171

It was discovered that insufficient validation of FTP command buffer
size limits may lead to denial of service. Due to unclear information
this issue was already fixed in DSA-1218 as CVE-2006-5815.

For the stable distribution (sarge) these problem has been fixed in version
1.2.10-15sarge3.

For the unstable distribution (sid) this problem has been fixed in
version 1.3.0-16 of the proftpd-dfsg package.

We recommend that you upgrade your proftpd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201222-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1222-2 (proftpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"proftpd-doc", ver:"1.2.10-15sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd", ver:"1.2.10-15sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-common", ver:"1.2.10-15sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-ldap", ver:"1.2.10-15sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mysql", ver:"1.2.10-15sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-pgsql", ver:"1.2.10-15sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
