# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 919-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56011);
 script_cve_id("CVE-2005-4077", "CVE-2005-3185");
 script_bugtraq_id(15756,15102,15647);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 919-1 (curl)";
 script_name(name);

 desc = "The remote host is missing an update to curl
announced via advisory DSA 919-1.

Several problems were discovered in libcurl, a multi-protocol file
transfer library.  The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2005-3185

A vulnerability has been discovered a buffer overflow in libcurl
that could allow the execution of arbitrary code.

CVE-2005-4077

Stefan Esser discovered several off-by-one errors that allows
local users to trigger a buffer overflow and cause a denial of
service or bypass PHP security restrictions via certain URLs.

For the old stable distribution (woody) these problems have been fixed in
version 7.9.5-1woody1.

For the stable distribution (sarge) these problems have been fixed in
version 7.13.2-2sarge4.  This update also includes a bugfix against
data corruption.

For the unstable distribution (sid) these problems have been fixed in
version 7.15.1-1.

We recommend that you upgrade your libcurl packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20919-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 919-1 (curl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"curl", ver:"7.9.5-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl-dev", ver:"7.9.5-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl2", ver:"7.9.5-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"curl", ver:"7.13.2-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3", ver:"7.13.2-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dbg", ver:"7.13.2-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-dev", ver:"7.13.2-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcurl3-gssapi", ver:"7.13.2-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
