# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0059 (xterm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63116);
 script_cve_id("CVE-2003-0063", "CVE-2003-0071", "CVE-2008-2383");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 9 FEDORA-2009-0059 (xterm)";
 script_name(name);

 desc = "The remote host is missing an update to xterm
announced via advisory FEDORA-2009-0059.

Update Information:

This update fixes the following security issue:    CRLF injection vulnerability
in xterm allows user-assisted attackers to execute arbitrary commands via LF
(aka \n) characters surrounding a command name within a Device Control Request
Status String (DECRQSS) escape sequence in a text file, a related issue to
CVE-2003-0063 and CVE-2003-0071.

ChangeLog:

* Tue Jan  6 2009 Miroslav Lichvar  238-1
- update to 238 (#479000, CVE-2008-2383)
- set default values of allowWindowOps and allowFontOps resources to false

References:

[ 1 ] Bug #479000 - xterm executes arbitrary commands
https://bugzilla.redhat.com/show_bug.cgi?id=479000

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xterm' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0059

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-0059 (xterm)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xterm", rpm:"xterm~238~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm-debuginfo", rpm:"xterm-debuginfo~238~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
