#
#VID 4d837296-cc28-11d8-a54c-02e0185c0b53
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52440);
 script_bugtraq_id(8004,8005,8006);
 script_cve_id("CVE-2004-0623");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: gnats";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: gnats

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.securiteam.com/unixfocus/5CP0N0UAAA.html
http://secunia.com/advisories/9096
http://x82.inetcop.org/h0me/adv1sor1es/INCSA.2003-0x82-018-GNATS-bt.txt
http://www.gnu.org/software/gnats/gnats.html
http://www.osvdb.org/2190
http://www.osvdb.org/4600
http://www.osvdb.org/4601
http://www.osvdb.org/4607
http://www.securityfocus.com/archive/1/326337
http://www.vuxml.org/freebsd/4d837296-cc28-11d8-a54c-02e0185c0b53.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gnats";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gnats");
if(!isnull(bver) && revcomp(a:bver, b:"3.113.1_9")<=0) {
    security_note(0, data:"Package gnats version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
