#
#VID f7e8d2ca-410e-40b2-8748-3abd021e44a9
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52994);
 script_bugtraq_id(12316);
 script_cve_id("CVE-2005-0079");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: xtrlock";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: xtrlock

CVE-2005-0079
Buffer overflow in xtrlock 2.0 allows local users to cause a denial of
service (application crash) and hijack the desktop session.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.debian.org/security/2005/dsa-649
http://xforce.iss.net/xforce/xfdb/18991
http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=278191
http://www.vuxml.org/freebsd/f7e8d2ca-410e-40b2-8748-3abd021e44a9.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: xtrlock";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"xtrlock");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.10")<0) {
    security_note(0, data:"Package xtrlock version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
