###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wireshark_smb_dos_vuln_lin.nasl 6340 2009-12-23 13:49:51Z dec $
#
# Wireshark SMB Dissectors Denial of Service Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900991);
  script_version("$Revision: 7621 $: 1.0");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4377");
  script_bugtraq_id(37407);
  script_name("Wireshark SMB Dissectors Denial of Service Vulnerability (Linux)");
  desc = "
  Overview: This host is installed with Wireshark and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  Error occurs in the SMB and SMB2 dissectors while processing malformed
  packets.

  Impact:
  Successful exploitation will allow attackers to trick the user to render the
  crafted malicious capture packet thus causing Denial of Serivce attack.

  Impact Level: System/Application

  Affected Software/OS:
  Wireshark version 0.9.0 to 1.2.4 on Linux.

  Fix: Upgrade to Wireshark version 1.2.5,
  http://www.wireshark.org/download.html

  References:
  http://secunia.com/advisories/37842
  http://www.vupen.com/english/advisories/2009/3596
  http://www.wireshark.org/security/wnpa-sec-2009-09.html
  https://bugs.wireshark.org/bugzilla/show_bug.cgi?id=4301
  http://www.wireshark.org/download/automated/captures/fuzz-2009-12-07-11141.pcap

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  script_require_keys("Wireshark/Linux/Ver");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Linux/Ver");
if(!sharkVer){
  exit(0);
}

# Grep for Wireshark version 0.9.0 to 1.2.4
if(version_in_range(version:sharkVer, test_version:"0.9.0",
                                     test_version2:"1.2.4")){
  security_warning(0);
}
