/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMimeType.h"

#include "DOMMimeType.h"
#include "DOMPlugin.h"
#include "JSDOMPlugin.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMMimeType);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMMimeTypeTableValues[6] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeType), (intptr_t)0 THUNK_GENERATOR(0) },
    { "suffixes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeSuffixes), (intptr_t)0 THUNK_GENERATOR(0) },
    { "description", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeDescription), (intptr_t)0 THUNK_GENERATOR(0) },
    { "enabledPlugin", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeEnabledPlugin), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMMimeTypeTable = { 16, 15, JSDOMMimeTypeTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMMimeTypeConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMMimeTypeConstructorTable = { 1, 0, JSDOMMimeTypeConstructorTableValues, 0 };
class JSDOMMimeTypeConstructor : public DOMConstructorObject {
public:
    JSDOMMimeTypeConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMMimeTypeConstructor::s_info = { "MimeTypeConstructor", &DOMConstructorObject::s_info, &JSDOMMimeTypeConstructorTable, 0 };

JSDOMMimeTypeConstructor::JSDOMMimeTypeConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMMimeTypePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMMimeTypeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMMimeTypeConstructor, JSDOMWrapper>(exec, &JSDOMMimeTypeConstructorTable, this, propertyName, slot);
}

bool JSDOMMimeTypeConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMMimeTypeConstructor, JSDOMWrapper>(exec, &JSDOMMimeTypeConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMMimeTypePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMMimeTypePrototypeTable = { 1, 0, JSDOMMimeTypePrototypeTableValues, 0 };
const ClassInfo JSDOMMimeTypePrototype::s_info = { "MimeTypePrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSDOMMimeTypePrototypeTable, 0 };

JSObject* JSDOMMimeTypePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMMimeType>(exec, globalObject);
}

const ClassInfo JSDOMMimeType::s_info = { "MimeType", &JSDOMWrapper::s_info, &JSDOMMimeTypeTable, 0 };

JSDOMMimeType::JSDOMMimeType(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMMimeType> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMMimeType::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMMimeTypePrototype(exec->globalData(), globalObject, JSDOMMimeTypePrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSDOMMimeType::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMMimeType, Base>(exec, &JSDOMMimeTypeTable, this, propertyName, slot);
}

bool JSDOMMimeType::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMMimeType, Base>(exec, &JSDOMMimeTypeTable, this, propertyName, descriptor);
}

JSValue jsDOMMimeTypeType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMMimeType* castedThis = static_cast<JSDOMMimeType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeType* imp = static_cast<DOMMimeType*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}


JSValue jsDOMMimeTypeSuffixes(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMMimeType* castedThis = static_cast<JSDOMMimeType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeType* imp = static_cast<DOMMimeType*>(castedThis->impl());
    JSValue result = jsString(exec, imp->suffixes());
    return result;
}


JSValue jsDOMMimeTypeDescription(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMMimeType* castedThis = static_cast<JSDOMMimeType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeType* imp = static_cast<DOMMimeType*>(castedThis->impl());
    JSValue result = jsString(exec, imp->description());
    return result;
}


JSValue jsDOMMimeTypeEnabledPlugin(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMMimeType* castedThis = static_cast<JSDOMMimeType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMMimeType* imp = static_cast<DOMMimeType*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->enabledPlugin()));
    return result;
}


JSValue jsDOMMimeTypeConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMMimeType* domObject = static_cast<JSDOMMimeType*>(asObject(slotBase));
    return JSDOMMimeType::getConstructor(exec, domObject->globalObject());
}

JSValue JSDOMMimeType::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMimeTypeConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMMimeType* impl)
{
    return wrap<JSDOMMimeType>(exec, globalObject, impl);
}

DOMMimeType* toDOMMimeType(JSC::JSValue value)
{
    return value.inherits(&JSDOMMimeType::s_info) ? static_cast<JSDOMMimeType*>(asObject(value))->impl() : 0;
}

}
