# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class CheckNameAvailabilityRequest(_serialization.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(_serialization.Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.voiceservices.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is not available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicates if the resource name is available.
        :paramtype name_available: bool
        :keyword reason: The reason why the given name is not available. Known values are: "Invalid"
         and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.voiceservices.models.CheckNameAvailabilityReason
        :keyword message: Detailed reason why the given name is not available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.voiceservices.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.voiceservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class CommunicationsGateway(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A CommunicationsGateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.voiceservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: Resource provisioning state. Known values are: "Succeeded", "Failed",
     and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.voiceservices.models.ProvisioningState
    :ivar status: The current status of the deployment. Known values are: "ChangePending" and
     "Complete".
    :vartype status: str or ~azure.mgmt.voiceservices.models.Status
    :ivar service_locations: The regions in which to deploy the resources needed for Teams Calling.
    :vartype service_locations: list[~azure.mgmt.voiceservices.models.ServiceRegionProperties]
    :ivar connectivity: How to connect back to the operator network, e.g. MAPS. "PublicAddress"
    :vartype connectivity: str or ~azure.mgmt.voiceservices.models.Connectivity
    :ivar codecs: Voice codecs to support.
    :vartype codecs: list[str or ~azure.mgmt.voiceservices.models.TeamsCodecs]
    :ivar e911_type: How to handle 911 calls. Known values are: "Standard" and "DirectToEsrp".
    :vartype e911_type: str or ~azure.mgmt.voiceservices.models.E911Type
    :ivar platforms: What platforms to support.
    :vartype platforms: list[str or ~azure.mgmt.voiceservices.models.CommunicationsPlatform]
    :ivar api_bridge: Details of API bridge functionality, if required.
    :vartype api_bridge: JSON
    :ivar auto_generated_domain_name_label_scope: The scope at which the auto-generated domain name
     can be re-used. Known values are: "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse", and
     "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.voiceservices.models.AutoGeneratedDomainNameLabelScope
    :ivar auto_generated_domain_name_label: The autogenerated label used as part of the FQDNs for
     accessing the Communications Gateway.
    :vartype auto_generated_domain_name_label: str
    :ivar teams_voicemail_pilot_number: This number is used in Teams Phone Mobile scenarios for
     access to the voicemail IVR from the native dialer.
    :vartype teams_voicemail_pilot_number: str
    :ivar on_prem_mcp_enabled: Whether an on-premises Mobile Control Point is in use.
    :vartype on_prem_mcp_enabled: bool
    :ivar emergency_dial_strings: A list of dial strings used for emergency calling.
    :vartype emergency_dial_strings: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "platforms": {"min_items": 1},
        "auto_generated_domain_name_label": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "service_locations": {"key": "properties.serviceLocations", "type": "[ServiceRegionProperties]"},
        "connectivity": {"key": "properties.connectivity", "type": "str"},
        "codecs": {"key": "properties.codecs", "type": "[str]"},
        "e911_type": {"key": "properties.e911Type", "type": "str"},
        "platforms": {"key": "properties.platforms", "type": "[str]"},
        "api_bridge": {"key": "properties.apiBridge", "type": "object"},
        "auto_generated_domain_name_label_scope": {
            "key": "properties.autoGeneratedDomainNameLabelScope",
            "type": "str",
        },
        "auto_generated_domain_name_label": {"key": "properties.autoGeneratedDomainNameLabel", "type": "str"},
        "teams_voicemail_pilot_number": {"key": "properties.teamsVoicemailPilotNumber", "type": "str"},
        "on_prem_mcp_enabled": {"key": "properties.onPremMcpEnabled", "type": "bool"},
        "emergency_dial_strings": {"key": "properties.emergencyDialStrings", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        service_locations: Optional[List["_models.ServiceRegionProperties"]] = None,
        connectivity: Optional[Union[str, "_models.Connectivity"]] = None,
        codecs: Optional[List[Union[str, "_models.TeamsCodecs"]]] = None,
        e911_type: Optional[Union[str, "_models.E911Type"]] = None,
        platforms: Optional[List[Union[str, "_models.CommunicationsPlatform"]]] = None,
        api_bridge: Optional[JSON] = None,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        teams_voicemail_pilot_number: Optional[str] = None,
        on_prem_mcp_enabled: bool = False,
        emergency_dial_strings: List[str] = ["911", "933"],
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword service_locations: The regions in which to deploy the resources needed for Teams
         Calling.
        :paramtype service_locations: list[~azure.mgmt.voiceservices.models.ServiceRegionProperties]
        :keyword connectivity: How to connect back to the operator network, e.g. MAPS. "PublicAddress"
        :paramtype connectivity: str or ~azure.mgmt.voiceservices.models.Connectivity
        :keyword codecs: Voice codecs to support.
        :paramtype codecs: list[str or ~azure.mgmt.voiceservices.models.TeamsCodecs]
        :keyword e911_type: How to handle 911 calls. Known values are: "Standard" and "DirectToEsrp".
        :paramtype e911_type: str or ~azure.mgmt.voiceservices.models.E911Type
        :keyword platforms: What platforms to support.
        :paramtype platforms: list[str or ~azure.mgmt.voiceservices.models.CommunicationsPlatform]
        :keyword api_bridge: Details of API bridge functionality, if required.
        :paramtype api_bridge: JSON
        :keyword auto_generated_domain_name_label_scope: The scope at which the auto-generated domain
         name can be re-used. Known values are: "TenantReuse", "SubscriptionReuse",
         "ResourceGroupReuse", and "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.voiceservices.models.AutoGeneratedDomainNameLabelScope
        :keyword teams_voicemail_pilot_number: This number is used in Teams Phone Mobile scenarios for
         access to the voicemail IVR from the native dialer.
        :paramtype teams_voicemail_pilot_number: str
        :keyword on_prem_mcp_enabled: Whether an on-premises Mobile Control Point is in use.
        :paramtype on_prem_mcp_enabled: bool
        :keyword emergency_dial_strings: A list of dial strings used for emergency calling.
        :paramtype emergency_dial_strings: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.status = None
        self.service_locations = service_locations
        self.connectivity = connectivity
        self.codecs = codecs
        self.e911_type = e911_type
        self.platforms = platforms
        self.api_bridge = api_bridge
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope
        self.auto_generated_domain_name_label = None
        self.teams_voicemail_pilot_number = teams_voicemail_pilot_number
        self.on_prem_mcp_enabled = on_prem_mcp_enabled
        self.emergency_dial_strings = emergency_dial_strings


class CommunicationsGatewayListResult(_serialization.Model):
    """The response of a CommunicationsGateway list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The CommunicationsGateway items on this page. Required.
    :vartype value: list[~azure.mgmt.voiceservices.models.CommunicationsGateway]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CommunicationsGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CommunicationsGateway"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The CommunicationsGateway items on this page. Required.
        :paramtype value: list[~azure.mgmt.voiceservices.models.CommunicationsGateway]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CommunicationsGatewayUpdate(_serialization.Model):
    """The type used for update operations of the CommunicationsGateway.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.voiceservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.voiceservices.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.voiceservices.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.voiceservices.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.voiceservices.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.voiceservices.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.voiceservices.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.voiceservices.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.voiceservices.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrimaryRegionProperties(_serialization.Model):
    """The configuration used in this region as primary, and other regions as backup.

    All required parameters must be populated in order to send to Azure.

    :ivar operator_addresses: IP address to use to contact the operator network from this region.
     Required.
    :vartype operator_addresses: list[str]
    :ivar esrp_addresses: IP address to use to contact the ESRP from this region.
    :vartype esrp_addresses: list[str]
    :ivar allowed_signaling_source_address_prefixes: The allowed source IP address or CIDR ranges
     for signaling.
    :vartype allowed_signaling_source_address_prefixes: list[str]
    :ivar allowed_media_source_address_prefixes: The allowed source IP address or CIDR ranges for
     media.
    :vartype allowed_media_source_address_prefixes: list[str]
    """

    _validation = {
        "operator_addresses": {"required": True},
    }

    _attribute_map = {
        "operator_addresses": {"key": "operatorAddresses", "type": "[str]"},
        "esrp_addresses": {"key": "esrpAddresses", "type": "[str]"},
        "allowed_signaling_source_address_prefixes": {"key": "allowedSignalingSourceAddressPrefixes", "type": "[str]"},
        "allowed_media_source_address_prefixes": {"key": "allowedMediaSourceAddressPrefixes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        operator_addresses: List[str],
        esrp_addresses: Optional[List[str]] = None,
        allowed_signaling_source_address_prefixes: List[str] = [],
        allowed_media_source_address_prefixes: List[str] = [],
        **kwargs: Any
    ) -> None:
        """
        :keyword operator_addresses: IP address to use to contact the operator network from this
         region. Required.
        :paramtype operator_addresses: list[str]
        :keyword esrp_addresses: IP address to use to contact the ESRP from this region.
        :paramtype esrp_addresses: list[str]
        :keyword allowed_signaling_source_address_prefixes: The allowed source IP address or CIDR
         ranges for signaling.
        :paramtype allowed_signaling_source_address_prefixes: list[str]
        :keyword allowed_media_source_address_prefixes: The allowed source IP address or CIDR ranges
         for media.
        :paramtype allowed_media_source_address_prefixes: list[str]
        """
        super().__init__(**kwargs)
        self.operator_addresses = operator_addresses
        self.esrp_addresses = esrp_addresses
        self.allowed_signaling_source_address_prefixes = allowed_signaling_source_address_prefixes
        self.allowed_media_source_address_prefixes = allowed_media_source_address_prefixes


class ServiceRegionProperties(_serialization.Model):
    """The service region configuration needed for Teams Callings.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the region in which the resources needed for Teams Calling will be
     deployed. Required.
    :vartype name: str
    :ivar primary_region_properties: The configuration used in this region as primary, and other
     regions as backup. Required.
    :vartype primary_region_properties: ~azure.mgmt.voiceservices.models.PrimaryRegionProperties
    """

    _validation = {
        "name": {"required": True},
        "primary_region_properties": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "primary_region_properties": {"key": "primaryRegionProperties", "type": "PrimaryRegionProperties"},
    }

    def __init__(
        self, *, name: str, primary_region_properties: "_models.PrimaryRegionProperties", **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the region in which the resources needed for Teams Calling will be
         deployed. Required.
        :paramtype name: str
        :keyword primary_region_properties: The configuration used in this region as primary, and other
         regions as backup. Required.
        :paramtype primary_region_properties: ~azure.mgmt.voiceservices.models.PrimaryRegionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.primary_region_properties = primary_region_properties


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.voiceservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.voiceservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.voiceservices.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.voiceservices.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TestLine(TrackedResource):
    """A TestLine resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.voiceservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: Resource provisioning state. Known values are: "Succeeded", "Failed",
     and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.voiceservices.models.ProvisioningState
    :ivar phone_number: The phone number.
    :vartype phone_number: str
    :ivar purpose: Purpose of this test line, e.g. automated or manual testing. Known values are:
     "Manual" and "Automated".
    :vartype purpose: str or ~azure.mgmt.voiceservices.models.TestLinePurpose
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "phone_number": {"key": "properties.phoneNumber", "type": "str"},
        "purpose": {"key": "properties.purpose", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        phone_number: Optional[str] = None,
        purpose: Optional[Union[str, "_models.TestLinePurpose"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword phone_number: The phone number.
        :paramtype phone_number: str
        :keyword purpose: Purpose of this test line, e.g. automated or manual testing. Known values
         are: "Manual" and "Automated".
        :paramtype purpose: str or ~azure.mgmt.voiceservices.models.TestLinePurpose
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.phone_number = phone_number
        self.purpose = purpose


class TestLineListResult(_serialization.Model):
    """The response of a TestLine list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The TestLine items on this page. Required.
    :vartype value: list[~azure.mgmt.voiceservices.models.TestLine]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TestLine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.TestLine"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The TestLine items on this page. Required.
        :paramtype value: list[~azure.mgmt.voiceservices.models.TestLine]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TestLineUpdate(_serialization.Model):
    """The type used for update operations of the TestLine.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
