// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_METRICS_FIELD_TRIALS_PROVIDER_H_
#define COMPONENTS_METRICS_FIELD_TRIALS_PROVIDER_H_

#include "base/strings/string_piece.h"
#include "base/time/time.h"
#include "components/metrics/metrics_provider.h"
#include "third_party/metrics_proto/chrome_user_metrics_extension.pb.h"

// TODO(crbug/507665): Once MetricsProvider/SystemProfileProto are moved into
// //services/metrics, then //components/variations can depend on them, and
// this should be moved there.
namespace variations {

class SyntheticTrialRegistry;
struct ActiveGroupId;

class FieldTrialsProvider : public metrics::MetricsProvider {
 public:
  // |registry| must outlive this metrics provider.
  FieldTrialsProvider(SyntheticTrialRegistry* registry,
                      base::StringPiece suffix);
  ~FieldTrialsProvider() override;

  // metrics::MetricsProvider:
  void ProvideSystemProfileMetrics(
      metrics::SystemProfileProto* system_profile_proto) override;
  void ProvideSystemProfileMetricsWithLogCreationTime(
      base::TimeTicks log_creation_time,
      metrics::SystemProfileProto* system_profile_proto) override;
  void ProvideCurrentSessionData(
      metrics::ChromeUserMetricsExtension* uma_proto) override;

  // Sets |log_creation_time_| to |time|.
  void SetLogCreationTimeForTesting(base::TimeTicks time);

 private:
  // Overrideable for testing.
  virtual void GetFieldTrialIds(
      std::vector<ActiveGroupId>* field_trial_ids) const;

  // Gets active FieldTrials and SyntheticFieldTrials and populates
  // |system_profile_proto| with them.
  void GetAndWriteFieldTrials(
      metrics::SystemProfileProto* system_profile_proto) const;

  // The most recent time passed to
  // ProvideSystemProfileMetricsWithLogCreationTime().
  base::TimeTicks log_creation_time_;

  SyntheticTrialRegistry* registry_;

  // Suffix used for the field trial names before they are hashed for uploads.
  std::string suffix_;

  DISALLOW_COPY_AND_ASSIGN(FieldTrialsProvider);
};

}  // namespace variations

#endif  // COMPONENTS_METRICS_FIELD_TRIALS_PROVIDER_H_
