use core::convert::From;
impl From<u32> for arm_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => arm_insn::ARM_INS_INVALID,
            1 => arm_insn::ARM_INS_ADC,
            2 => arm_insn::ARM_INS_ADD,
            3 => arm_insn::ARM_INS_ADR,
            4 => arm_insn::ARM_INS_AESD,
            5 => arm_insn::ARM_INS_AESE,
            6 => arm_insn::ARM_INS_AESIMC,
            7 => arm_insn::ARM_INS_AESMC,
            8 => arm_insn::ARM_INS_AND,
            9 => arm_insn::ARM_INS_BFC,
            10 => arm_insn::ARM_INS_BFI,
            11 => arm_insn::ARM_INS_BIC,
            12 => arm_insn::ARM_INS_BKPT,
            13 => arm_insn::ARM_INS_BL,
            14 => arm_insn::ARM_INS_BLX,
            15 => arm_insn::ARM_INS_BX,
            16 => arm_insn::ARM_INS_BXJ,
            17 => arm_insn::ARM_INS_B,
            18 => arm_insn::ARM_INS_CDP,
            19 => arm_insn::ARM_INS_CDP2,
            20 => arm_insn::ARM_INS_CLREX,
            21 => arm_insn::ARM_INS_CLZ,
            22 => arm_insn::ARM_INS_CMN,
            23 => arm_insn::ARM_INS_CMP,
            24 => arm_insn::ARM_INS_CPS,
            25 => arm_insn::ARM_INS_CRC32B,
            26 => arm_insn::ARM_INS_CRC32CB,
            27 => arm_insn::ARM_INS_CRC32CH,
            28 => arm_insn::ARM_INS_CRC32CW,
            29 => arm_insn::ARM_INS_CRC32H,
            30 => arm_insn::ARM_INS_CRC32W,
            31 => arm_insn::ARM_INS_DBG,
            32 => arm_insn::ARM_INS_DMB,
            33 => arm_insn::ARM_INS_DSB,
            34 => arm_insn::ARM_INS_EOR,
            35 => arm_insn::ARM_INS_ERET,
            36 => arm_insn::ARM_INS_VMOV,
            37 => arm_insn::ARM_INS_FLDMDBX,
            38 => arm_insn::ARM_INS_FLDMIAX,
            39 => arm_insn::ARM_INS_VMRS,
            40 => arm_insn::ARM_INS_FSTMDBX,
            41 => arm_insn::ARM_INS_FSTMIAX,
            42 => arm_insn::ARM_INS_HINT,
            43 => arm_insn::ARM_INS_HLT,
            44 => arm_insn::ARM_INS_HVC,
            45 => arm_insn::ARM_INS_ISB,
            46 => arm_insn::ARM_INS_LDA,
            47 => arm_insn::ARM_INS_LDAB,
            48 => arm_insn::ARM_INS_LDAEX,
            49 => arm_insn::ARM_INS_LDAEXB,
            50 => arm_insn::ARM_INS_LDAEXD,
            51 => arm_insn::ARM_INS_LDAEXH,
            52 => arm_insn::ARM_INS_LDAH,
            53 => arm_insn::ARM_INS_LDC2L,
            54 => arm_insn::ARM_INS_LDC2,
            55 => arm_insn::ARM_INS_LDCL,
            56 => arm_insn::ARM_INS_LDC,
            57 => arm_insn::ARM_INS_LDMDA,
            58 => arm_insn::ARM_INS_LDMDB,
            59 => arm_insn::ARM_INS_LDM,
            60 => arm_insn::ARM_INS_LDMIB,
            61 => arm_insn::ARM_INS_LDRBT,
            62 => arm_insn::ARM_INS_LDRB,
            63 => arm_insn::ARM_INS_LDRD,
            64 => arm_insn::ARM_INS_LDREX,
            65 => arm_insn::ARM_INS_LDREXB,
            66 => arm_insn::ARM_INS_LDREXD,
            67 => arm_insn::ARM_INS_LDREXH,
            68 => arm_insn::ARM_INS_LDRH,
            69 => arm_insn::ARM_INS_LDRHT,
            70 => arm_insn::ARM_INS_LDRSB,
            71 => arm_insn::ARM_INS_LDRSBT,
            72 => arm_insn::ARM_INS_LDRSH,
            73 => arm_insn::ARM_INS_LDRSHT,
            74 => arm_insn::ARM_INS_LDRT,
            75 => arm_insn::ARM_INS_LDR,
            76 => arm_insn::ARM_INS_MCR,
            77 => arm_insn::ARM_INS_MCR2,
            78 => arm_insn::ARM_INS_MCRR,
            79 => arm_insn::ARM_INS_MCRR2,
            80 => arm_insn::ARM_INS_MLA,
            81 => arm_insn::ARM_INS_MLS,
            82 => arm_insn::ARM_INS_MOV,
            83 => arm_insn::ARM_INS_MOVT,
            84 => arm_insn::ARM_INS_MOVW,
            85 => arm_insn::ARM_INS_MRC,
            86 => arm_insn::ARM_INS_MRC2,
            87 => arm_insn::ARM_INS_MRRC,
            88 => arm_insn::ARM_INS_MRRC2,
            89 => arm_insn::ARM_INS_MRS,
            90 => arm_insn::ARM_INS_MSR,
            91 => arm_insn::ARM_INS_MUL,
            92 => arm_insn::ARM_INS_MVN,
            93 => arm_insn::ARM_INS_ORR,
            94 => arm_insn::ARM_INS_PKHBT,
            95 => arm_insn::ARM_INS_PKHTB,
            96 => arm_insn::ARM_INS_PLDW,
            97 => arm_insn::ARM_INS_PLD,
            98 => arm_insn::ARM_INS_PLI,
            99 => arm_insn::ARM_INS_QADD,
            100 => arm_insn::ARM_INS_QADD16,
            101 => arm_insn::ARM_INS_QADD8,
            102 => arm_insn::ARM_INS_QASX,
            103 => arm_insn::ARM_INS_QDADD,
            104 => arm_insn::ARM_INS_QDSUB,
            105 => arm_insn::ARM_INS_QSAX,
            106 => arm_insn::ARM_INS_QSUB,
            107 => arm_insn::ARM_INS_QSUB16,
            108 => arm_insn::ARM_INS_QSUB8,
            109 => arm_insn::ARM_INS_RBIT,
            110 => arm_insn::ARM_INS_REV,
            111 => arm_insn::ARM_INS_REV16,
            112 => arm_insn::ARM_INS_REVSH,
            113 => arm_insn::ARM_INS_RFEDA,
            114 => arm_insn::ARM_INS_RFEDB,
            115 => arm_insn::ARM_INS_RFEIA,
            116 => arm_insn::ARM_INS_RFEIB,
            117 => arm_insn::ARM_INS_RSB,
            118 => arm_insn::ARM_INS_RSC,
            119 => arm_insn::ARM_INS_SADD16,
            120 => arm_insn::ARM_INS_SADD8,
            121 => arm_insn::ARM_INS_SASX,
            122 => arm_insn::ARM_INS_SBC,
            123 => arm_insn::ARM_INS_SBFX,
            124 => arm_insn::ARM_INS_SDIV,
            125 => arm_insn::ARM_INS_SEL,
            126 => arm_insn::ARM_INS_SETEND,
            127 => arm_insn::ARM_INS_SHA1C,
            128 => arm_insn::ARM_INS_SHA1H,
            129 => arm_insn::ARM_INS_SHA1M,
            130 => arm_insn::ARM_INS_SHA1P,
            131 => arm_insn::ARM_INS_SHA1SU0,
            132 => arm_insn::ARM_INS_SHA1SU1,
            133 => arm_insn::ARM_INS_SHA256H,
            134 => arm_insn::ARM_INS_SHA256H2,
            135 => arm_insn::ARM_INS_SHA256SU0,
            136 => arm_insn::ARM_INS_SHA256SU1,
            137 => arm_insn::ARM_INS_SHADD16,
            138 => arm_insn::ARM_INS_SHADD8,
            139 => arm_insn::ARM_INS_SHASX,
            140 => arm_insn::ARM_INS_SHSAX,
            141 => arm_insn::ARM_INS_SHSUB16,
            142 => arm_insn::ARM_INS_SHSUB8,
            143 => arm_insn::ARM_INS_SMC,
            144 => arm_insn::ARM_INS_SMLABB,
            145 => arm_insn::ARM_INS_SMLABT,
            146 => arm_insn::ARM_INS_SMLAD,
            147 => arm_insn::ARM_INS_SMLADX,
            148 => arm_insn::ARM_INS_SMLAL,
            149 => arm_insn::ARM_INS_SMLALBB,
            150 => arm_insn::ARM_INS_SMLALBT,
            151 => arm_insn::ARM_INS_SMLALD,
            152 => arm_insn::ARM_INS_SMLALDX,
            153 => arm_insn::ARM_INS_SMLALTB,
            154 => arm_insn::ARM_INS_SMLALTT,
            155 => arm_insn::ARM_INS_SMLATB,
            156 => arm_insn::ARM_INS_SMLATT,
            157 => arm_insn::ARM_INS_SMLAWB,
            158 => arm_insn::ARM_INS_SMLAWT,
            159 => arm_insn::ARM_INS_SMLSD,
            160 => arm_insn::ARM_INS_SMLSDX,
            161 => arm_insn::ARM_INS_SMLSLD,
            162 => arm_insn::ARM_INS_SMLSLDX,
            163 => arm_insn::ARM_INS_SMMLA,
            164 => arm_insn::ARM_INS_SMMLAR,
            165 => arm_insn::ARM_INS_SMMLS,
            166 => arm_insn::ARM_INS_SMMLSR,
            167 => arm_insn::ARM_INS_SMMUL,
            168 => arm_insn::ARM_INS_SMMULR,
            169 => arm_insn::ARM_INS_SMUAD,
            170 => arm_insn::ARM_INS_SMUADX,
            171 => arm_insn::ARM_INS_SMULBB,
            172 => arm_insn::ARM_INS_SMULBT,
            173 => arm_insn::ARM_INS_SMULL,
            174 => arm_insn::ARM_INS_SMULTB,
            175 => arm_insn::ARM_INS_SMULTT,
            176 => arm_insn::ARM_INS_SMULWB,
            177 => arm_insn::ARM_INS_SMULWT,
            178 => arm_insn::ARM_INS_SMUSD,
            179 => arm_insn::ARM_INS_SMUSDX,
            180 => arm_insn::ARM_INS_SRSDA,
            181 => arm_insn::ARM_INS_SRSDB,
            182 => arm_insn::ARM_INS_SRSIA,
            183 => arm_insn::ARM_INS_SRSIB,
            184 => arm_insn::ARM_INS_SSAT,
            185 => arm_insn::ARM_INS_SSAT16,
            186 => arm_insn::ARM_INS_SSAX,
            187 => arm_insn::ARM_INS_SSUB16,
            188 => arm_insn::ARM_INS_SSUB8,
            189 => arm_insn::ARM_INS_STC2L,
            190 => arm_insn::ARM_INS_STC2,
            191 => arm_insn::ARM_INS_STCL,
            192 => arm_insn::ARM_INS_STC,
            193 => arm_insn::ARM_INS_STL,
            194 => arm_insn::ARM_INS_STLB,
            195 => arm_insn::ARM_INS_STLEX,
            196 => arm_insn::ARM_INS_STLEXB,
            197 => arm_insn::ARM_INS_STLEXD,
            198 => arm_insn::ARM_INS_STLEXH,
            199 => arm_insn::ARM_INS_STLH,
            200 => arm_insn::ARM_INS_STMDA,
            201 => arm_insn::ARM_INS_STMDB,
            202 => arm_insn::ARM_INS_STM,
            203 => arm_insn::ARM_INS_STMIB,
            204 => arm_insn::ARM_INS_STRBT,
            205 => arm_insn::ARM_INS_STRB,
            206 => arm_insn::ARM_INS_STRD,
            207 => arm_insn::ARM_INS_STREX,
            208 => arm_insn::ARM_INS_STREXB,
            209 => arm_insn::ARM_INS_STREXD,
            210 => arm_insn::ARM_INS_STREXH,
            211 => arm_insn::ARM_INS_STRH,
            212 => arm_insn::ARM_INS_STRHT,
            213 => arm_insn::ARM_INS_STRT,
            214 => arm_insn::ARM_INS_STR,
            215 => arm_insn::ARM_INS_SUB,
            216 => arm_insn::ARM_INS_SVC,
            217 => arm_insn::ARM_INS_SWP,
            218 => arm_insn::ARM_INS_SWPB,
            219 => arm_insn::ARM_INS_SXTAB,
            220 => arm_insn::ARM_INS_SXTAB16,
            221 => arm_insn::ARM_INS_SXTAH,
            222 => arm_insn::ARM_INS_SXTB,
            223 => arm_insn::ARM_INS_SXTB16,
            224 => arm_insn::ARM_INS_SXTH,
            225 => arm_insn::ARM_INS_TEQ,
            226 => arm_insn::ARM_INS_TRAP,
            227 => arm_insn::ARM_INS_TST,
            228 => arm_insn::ARM_INS_UADD16,
            229 => arm_insn::ARM_INS_UADD8,
            230 => arm_insn::ARM_INS_UASX,
            231 => arm_insn::ARM_INS_UBFX,
            232 => arm_insn::ARM_INS_UDF,
            233 => arm_insn::ARM_INS_UDIV,
            234 => arm_insn::ARM_INS_UHADD16,
            235 => arm_insn::ARM_INS_UHADD8,
            236 => arm_insn::ARM_INS_UHASX,
            237 => arm_insn::ARM_INS_UHSAX,
            238 => arm_insn::ARM_INS_UHSUB16,
            239 => arm_insn::ARM_INS_UHSUB8,
            240 => arm_insn::ARM_INS_UMAAL,
            241 => arm_insn::ARM_INS_UMLAL,
            242 => arm_insn::ARM_INS_UMULL,
            243 => arm_insn::ARM_INS_UQADD16,
            244 => arm_insn::ARM_INS_UQADD8,
            245 => arm_insn::ARM_INS_UQASX,
            246 => arm_insn::ARM_INS_UQSAX,
            247 => arm_insn::ARM_INS_UQSUB16,
            248 => arm_insn::ARM_INS_UQSUB8,
            249 => arm_insn::ARM_INS_USAD8,
            250 => arm_insn::ARM_INS_USADA8,
            251 => arm_insn::ARM_INS_USAT,
            252 => arm_insn::ARM_INS_USAT16,
            253 => arm_insn::ARM_INS_USAX,
            254 => arm_insn::ARM_INS_USUB16,
            255 => arm_insn::ARM_INS_USUB8,
            256 => arm_insn::ARM_INS_UXTAB,
            257 => arm_insn::ARM_INS_UXTAB16,
            258 => arm_insn::ARM_INS_UXTAH,
            259 => arm_insn::ARM_INS_UXTB,
            260 => arm_insn::ARM_INS_UXTB16,
            261 => arm_insn::ARM_INS_UXTH,
            262 => arm_insn::ARM_INS_VABAL,
            263 => arm_insn::ARM_INS_VABA,
            264 => arm_insn::ARM_INS_VABDL,
            265 => arm_insn::ARM_INS_VABD,
            266 => arm_insn::ARM_INS_VABS,
            267 => arm_insn::ARM_INS_VACGE,
            268 => arm_insn::ARM_INS_VACGT,
            269 => arm_insn::ARM_INS_VADD,
            270 => arm_insn::ARM_INS_VADDHN,
            271 => arm_insn::ARM_INS_VADDL,
            272 => arm_insn::ARM_INS_VADDW,
            273 => arm_insn::ARM_INS_VAND,
            274 => arm_insn::ARM_INS_VBIC,
            275 => arm_insn::ARM_INS_VBIF,
            276 => arm_insn::ARM_INS_VBIT,
            277 => arm_insn::ARM_INS_VBSL,
            278 => arm_insn::ARM_INS_VCEQ,
            279 => arm_insn::ARM_INS_VCGE,
            280 => arm_insn::ARM_INS_VCGT,
            281 => arm_insn::ARM_INS_VCLE,
            282 => arm_insn::ARM_INS_VCLS,
            283 => arm_insn::ARM_INS_VCLT,
            284 => arm_insn::ARM_INS_VCLZ,
            285 => arm_insn::ARM_INS_VCMP,
            286 => arm_insn::ARM_INS_VCMPE,
            287 => arm_insn::ARM_INS_VCNT,
            288 => arm_insn::ARM_INS_VCVTA,
            289 => arm_insn::ARM_INS_VCVTB,
            290 => arm_insn::ARM_INS_VCVT,
            291 => arm_insn::ARM_INS_VCVTM,
            292 => arm_insn::ARM_INS_VCVTN,
            293 => arm_insn::ARM_INS_VCVTP,
            294 => arm_insn::ARM_INS_VCVTT,
            295 => arm_insn::ARM_INS_VDIV,
            296 => arm_insn::ARM_INS_VDUP,
            297 => arm_insn::ARM_INS_VEOR,
            298 => arm_insn::ARM_INS_VEXT,
            299 => arm_insn::ARM_INS_VFMA,
            300 => arm_insn::ARM_INS_VFMS,
            301 => arm_insn::ARM_INS_VFNMA,
            302 => arm_insn::ARM_INS_VFNMS,
            303 => arm_insn::ARM_INS_VHADD,
            304 => arm_insn::ARM_INS_VHSUB,
            305 => arm_insn::ARM_INS_VLD1,
            306 => arm_insn::ARM_INS_VLD2,
            307 => arm_insn::ARM_INS_VLD3,
            308 => arm_insn::ARM_INS_VLD4,
            309 => arm_insn::ARM_INS_VLDMDB,
            310 => arm_insn::ARM_INS_VLDMIA,
            311 => arm_insn::ARM_INS_VLDR,
            312 => arm_insn::ARM_INS_VMAXNM,
            313 => arm_insn::ARM_INS_VMAX,
            314 => arm_insn::ARM_INS_VMINNM,
            315 => arm_insn::ARM_INS_VMIN,
            316 => arm_insn::ARM_INS_VMLA,
            317 => arm_insn::ARM_INS_VMLAL,
            318 => arm_insn::ARM_INS_VMLS,
            319 => arm_insn::ARM_INS_VMLSL,
            320 => arm_insn::ARM_INS_VMOVL,
            321 => arm_insn::ARM_INS_VMOVN,
            322 => arm_insn::ARM_INS_VMSR,
            323 => arm_insn::ARM_INS_VMUL,
            324 => arm_insn::ARM_INS_VMULL,
            325 => arm_insn::ARM_INS_VMVN,
            326 => arm_insn::ARM_INS_VNEG,
            327 => arm_insn::ARM_INS_VNMLA,
            328 => arm_insn::ARM_INS_VNMLS,
            329 => arm_insn::ARM_INS_VNMUL,
            330 => arm_insn::ARM_INS_VORN,
            331 => arm_insn::ARM_INS_VORR,
            332 => arm_insn::ARM_INS_VPADAL,
            333 => arm_insn::ARM_INS_VPADDL,
            334 => arm_insn::ARM_INS_VPADD,
            335 => arm_insn::ARM_INS_VPMAX,
            336 => arm_insn::ARM_INS_VPMIN,
            337 => arm_insn::ARM_INS_VQABS,
            338 => arm_insn::ARM_INS_VQADD,
            339 => arm_insn::ARM_INS_VQDMLAL,
            340 => arm_insn::ARM_INS_VQDMLSL,
            341 => arm_insn::ARM_INS_VQDMULH,
            342 => arm_insn::ARM_INS_VQDMULL,
            343 => arm_insn::ARM_INS_VQMOVUN,
            344 => arm_insn::ARM_INS_VQMOVN,
            345 => arm_insn::ARM_INS_VQNEG,
            346 => arm_insn::ARM_INS_VQRDMULH,
            347 => arm_insn::ARM_INS_VQRSHL,
            348 => arm_insn::ARM_INS_VQRSHRN,
            349 => arm_insn::ARM_INS_VQRSHRUN,
            350 => arm_insn::ARM_INS_VQSHL,
            351 => arm_insn::ARM_INS_VQSHLU,
            352 => arm_insn::ARM_INS_VQSHRN,
            353 => arm_insn::ARM_INS_VQSHRUN,
            354 => arm_insn::ARM_INS_VQSUB,
            355 => arm_insn::ARM_INS_VRADDHN,
            356 => arm_insn::ARM_INS_VRECPE,
            357 => arm_insn::ARM_INS_VRECPS,
            358 => arm_insn::ARM_INS_VREV16,
            359 => arm_insn::ARM_INS_VREV32,
            360 => arm_insn::ARM_INS_VREV64,
            361 => arm_insn::ARM_INS_VRHADD,
            362 => arm_insn::ARM_INS_VRINTA,
            363 => arm_insn::ARM_INS_VRINTM,
            364 => arm_insn::ARM_INS_VRINTN,
            365 => arm_insn::ARM_INS_VRINTP,
            366 => arm_insn::ARM_INS_VRINTR,
            367 => arm_insn::ARM_INS_VRINTX,
            368 => arm_insn::ARM_INS_VRINTZ,
            369 => arm_insn::ARM_INS_VRSHL,
            370 => arm_insn::ARM_INS_VRSHRN,
            371 => arm_insn::ARM_INS_VRSHR,
            372 => arm_insn::ARM_INS_VRSQRTE,
            373 => arm_insn::ARM_INS_VRSQRTS,
            374 => arm_insn::ARM_INS_VRSRA,
            375 => arm_insn::ARM_INS_VRSUBHN,
            376 => arm_insn::ARM_INS_VSELEQ,
            377 => arm_insn::ARM_INS_VSELGE,
            378 => arm_insn::ARM_INS_VSELGT,
            379 => arm_insn::ARM_INS_VSELVS,
            380 => arm_insn::ARM_INS_VSHLL,
            381 => arm_insn::ARM_INS_VSHL,
            382 => arm_insn::ARM_INS_VSHRN,
            383 => arm_insn::ARM_INS_VSHR,
            384 => arm_insn::ARM_INS_VSLI,
            385 => arm_insn::ARM_INS_VSQRT,
            386 => arm_insn::ARM_INS_VSRA,
            387 => arm_insn::ARM_INS_VSRI,
            388 => arm_insn::ARM_INS_VST1,
            389 => arm_insn::ARM_INS_VST2,
            390 => arm_insn::ARM_INS_VST3,
            391 => arm_insn::ARM_INS_VST4,
            392 => arm_insn::ARM_INS_VSTMDB,
            393 => arm_insn::ARM_INS_VSTMIA,
            394 => arm_insn::ARM_INS_VSTR,
            395 => arm_insn::ARM_INS_VSUB,
            396 => arm_insn::ARM_INS_VSUBHN,
            397 => arm_insn::ARM_INS_VSUBL,
            398 => arm_insn::ARM_INS_VSUBW,
            399 => arm_insn::ARM_INS_VSWP,
            400 => arm_insn::ARM_INS_VTBL,
            401 => arm_insn::ARM_INS_VTBX,
            402 => arm_insn::ARM_INS_VCVTR,
            403 => arm_insn::ARM_INS_VTRN,
            404 => arm_insn::ARM_INS_VTST,
            405 => arm_insn::ARM_INS_VUZP,
            406 => arm_insn::ARM_INS_VZIP,
            407 => arm_insn::ARM_INS_ADDW,
            408 => arm_insn::ARM_INS_ASR,
            409 => arm_insn::ARM_INS_DCPS1,
            410 => arm_insn::ARM_INS_DCPS2,
            411 => arm_insn::ARM_INS_DCPS3,
            412 => arm_insn::ARM_INS_IT,
            413 => arm_insn::ARM_INS_LSL,
            414 => arm_insn::ARM_INS_LSR,
            415 => arm_insn::ARM_INS_ORN,
            416 => arm_insn::ARM_INS_ROR,
            417 => arm_insn::ARM_INS_RRX,
            418 => arm_insn::ARM_INS_SUBW,
            419 => arm_insn::ARM_INS_TBB,
            420 => arm_insn::ARM_INS_TBH,
            421 => arm_insn::ARM_INS_CBNZ,
            422 => arm_insn::ARM_INS_CBZ,
            423 => arm_insn::ARM_INS_POP,
            424 => arm_insn::ARM_INS_PUSH,
            425 => arm_insn::ARM_INS_NOP,
            426 => arm_insn::ARM_INS_YIELD,
            427 => arm_insn::ARM_INS_WFE,
            428 => arm_insn::ARM_INS_WFI,
            429 => arm_insn::ARM_INS_SEV,
            430 => arm_insn::ARM_INS_SEVL,
            431 => arm_insn::ARM_INS_VPUSH,
            432 => arm_insn::ARM_INS_VPOP,
            433 => arm_insn::ARM_INS_ENDING,
            _ => arm_insn::ARM_INS_INVALID,
        }
    }
}
impl From<u32> for arm64_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => arm64_insn::ARM64_INS_INVALID,
            1 => arm64_insn::ARM64_INS_ABS,
            2 => arm64_insn::ARM64_INS_ADC,
            3 => arm64_insn::ARM64_INS_ADDHN,
            4 => arm64_insn::ARM64_INS_ADDHN2,
            5 => arm64_insn::ARM64_INS_ADDP,
            6 => arm64_insn::ARM64_INS_ADD,
            7 => arm64_insn::ARM64_INS_ADDV,
            8 => arm64_insn::ARM64_INS_ADR,
            9 => arm64_insn::ARM64_INS_ADRP,
            10 => arm64_insn::ARM64_INS_AESD,
            11 => arm64_insn::ARM64_INS_AESE,
            12 => arm64_insn::ARM64_INS_AESIMC,
            13 => arm64_insn::ARM64_INS_AESMC,
            14 => arm64_insn::ARM64_INS_AND,
            15 => arm64_insn::ARM64_INS_ASR,
            16 => arm64_insn::ARM64_INS_B,
            17 => arm64_insn::ARM64_INS_BFM,
            18 => arm64_insn::ARM64_INS_BIC,
            19 => arm64_insn::ARM64_INS_BIF,
            20 => arm64_insn::ARM64_INS_BIT,
            21 => arm64_insn::ARM64_INS_BL,
            22 => arm64_insn::ARM64_INS_BLR,
            23 => arm64_insn::ARM64_INS_BR,
            24 => arm64_insn::ARM64_INS_BRK,
            25 => arm64_insn::ARM64_INS_BSL,
            26 => arm64_insn::ARM64_INS_CBNZ,
            27 => arm64_insn::ARM64_INS_CBZ,
            28 => arm64_insn::ARM64_INS_CCMN,
            29 => arm64_insn::ARM64_INS_CCMP,
            30 => arm64_insn::ARM64_INS_CLREX,
            31 => arm64_insn::ARM64_INS_CLS,
            32 => arm64_insn::ARM64_INS_CLZ,
            33 => arm64_insn::ARM64_INS_CMEQ,
            34 => arm64_insn::ARM64_INS_CMGE,
            35 => arm64_insn::ARM64_INS_CMGT,
            36 => arm64_insn::ARM64_INS_CMHI,
            37 => arm64_insn::ARM64_INS_CMHS,
            38 => arm64_insn::ARM64_INS_CMLE,
            39 => arm64_insn::ARM64_INS_CMLT,
            40 => arm64_insn::ARM64_INS_CMTST,
            41 => arm64_insn::ARM64_INS_CNT,
            42 => arm64_insn::ARM64_INS_MOV,
            43 => arm64_insn::ARM64_INS_CRC32B,
            44 => arm64_insn::ARM64_INS_CRC32CB,
            45 => arm64_insn::ARM64_INS_CRC32CH,
            46 => arm64_insn::ARM64_INS_CRC32CW,
            47 => arm64_insn::ARM64_INS_CRC32CX,
            48 => arm64_insn::ARM64_INS_CRC32H,
            49 => arm64_insn::ARM64_INS_CRC32W,
            50 => arm64_insn::ARM64_INS_CRC32X,
            51 => arm64_insn::ARM64_INS_CSEL,
            52 => arm64_insn::ARM64_INS_CSINC,
            53 => arm64_insn::ARM64_INS_CSINV,
            54 => arm64_insn::ARM64_INS_CSNEG,
            55 => arm64_insn::ARM64_INS_DCPS1,
            56 => arm64_insn::ARM64_INS_DCPS2,
            57 => arm64_insn::ARM64_INS_DCPS3,
            58 => arm64_insn::ARM64_INS_DMB,
            59 => arm64_insn::ARM64_INS_DRPS,
            60 => arm64_insn::ARM64_INS_DSB,
            61 => arm64_insn::ARM64_INS_DUP,
            62 => arm64_insn::ARM64_INS_EON,
            63 => arm64_insn::ARM64_INS_EOR,
            64 => arm64_insn::ARM64_INS_ERET,
            65 => arm64_insn::ARM64_INS_EXTR,
            66 => arm64_insn::ARM64_INS_EXT,
            67 => arm64_insn::ARM64_INS_FABD,
            68 => arm64_insn::ARM64_INS_FABS,
            69 => arm64_insn::ARM64_INS_FACGE,
            70 => arm64_insn::ARM64_INS_FACGT,
            71 => arm64_insn::ARM64_INS_FADD,
            72 => arm64_insn::ARM64_INS_FADDP,
            73 => arm64_insn::ARM64_INS_FCCMP,
            74 => arm64_insn::ARM64_INS_FCCMPE,
            75 => arm64_insn::ARM64_INS_FCMEQ,
            76 => arm64_insn::ARM64_INS_FCMGE,
            77 => arm64_insn::ARM64_INS_FCMGT,
            78 => arm64_insn::ARM64_INS_FCMLE,
            79 => arm64_insn::ARM64_INS_FCMLT,
            80 => arm64_insn::ARM64_INS_FCMP,
            81 => arm64_insn::ARM64_INS_FCMPE,
            82 => arm64_insn::ARM64_INS_FCSEL,
            83 => arm64_insn::ARM64_INS_FCVTAS,
            84 => arm64_insn::ARM64_INS_FCVTAU,
            85 => arm64_insn::ARM64_INS_FCVT,
            86 => arm64_insn::ARM64_INS_FCVTL,
            87 => arm64_insn::ARM64_INS_FCVTL2,
            88 => arm64_insn::ARM64_INS_FCVTMS,
            89 => arm64_insn::ARM64_INS_FCVTMU,
            90 => arm64_insn::ARM64_INS_FCVTNS,
            91 => arm64_insn::ARM64_INS_FCVTNU,
            92 => arm64_insn::ARM64_INS_FCVTN,
            93 => arm64_insn::ARM64_INS_FCVTN2,
            94 => arm64_insn::ARM64_INS_FCVTPS,
            95 => arm64_insn::ARM64_INS_FCVTPU,
            96 => arm64_insn::ARM64_INS_FCVTXN,
            97 => arm64_insn::ARM64_INS_FCVTXN2,
            98 => arm64_insn::ARM64_INS_FCVTZS,
            99 => arm64_insn::ARM64_INS_FCVTZU,
            100 => arm64_insn::ARM64_INS_FDIV,
            101 => arm64_insn::ARM64_INS_FMADD,
            102 => arm64_insn::ARM64_INS_FMAX,
            103 => arm64_insn::ARM64_INS_FMAXNM,
            104 => arm64_insn::ARM64_INS_FMAXNMP,
            105 => arm64_insn::ARM64_INS_FMAXNMV,
            106 => arm64_insn::ARM64_INS_FMAXP,
            107 => arm64_insn::ARM64_INS_FMAXV,
            108 => arm64_insn::ARM64_INS_FMIN,
            109 => arm64_insn::ARM64_INS_FMINNM,
            110 => arm64_insn::ARM64_INS_FMINNMP,
            111 => arm64_insn::ARM64_INS_FMINNMV,
            112 => arm64_insn::ARM64_INS_FMINP,
            113 => arm64_insn::ARM64_INS_FMINV,
            114 => arm64_insn::ARM64_INS_FMLA,
            115 => arm64_insn::ARM64_INS_FMLS,
            116 => arm64_insn::ARM64_INS_FMOV,
            117 => arm64_insn::ARM64_INS_FMSUB,
            118 => arm64_insn::ARM64_INS_FMUL,
            119 => arm64_insn::ARM64_INS_FMULX,
            120 => arm64_insn::ARM64_INS_FNEG,
            121 => arm64_insn::ARM64_INS_FNMADD,
            122 => arm64_insn::ARM64_INS_FNMSUB,
            123 => arm64_insn::ARM64_INS_FNMUL,
            124 => arm64_insn::ARM64_INS_FRECPE,
            125 => arm64_insn::ARM64_INS_FRECPS,
            126 => arm64_insn::ARM64_INS_FRECPX,
            127 => arm64_insn::ARM64_INS_FRINTA,
            128 => arm64_insn::ARM64_INS_FRINTI,
            129 => arm64_insn::ARM64_INS_FRINTM,
            130 => arm64_insn::ARM64_INS_FRINTN,
            131 => arm64_insn::ARM64_INS_FRINTP,
            132 => arm64_insn::ARM64_INS_FRINTX,
            133 => arm64_insn::ARM64_INS_FRINTZ,
            134 => arm64_insn::ARM64_INS_FRSQRTE,
            135 => arm64_insn::ARM64_INS_FRSQRTS,
            136 => arm64_insn::ARM64_INS_FSQRT,
            137 => arm64_insn::ARM64_INS_FSUB,
            138 => arm64_insn::ARM64_INS_HINT,
            139 => arm64_insn::ARM64_INS_HLT,
            140 => arm64_insn::ARM64_INS_HVC,
            141 => arm64_insn::ARM64_INS_INS,
            142 => arm64_insn::ARM64_INS_ISB,
            143 => arm64_insn::ARM64_INS_LD1,
            144 => arm64_insn::ARM64_INS_LD1R,
            145 => arm64_insn::ARM64_INS_LD2R,
            146 => arm64_insn::ARM64_INS_LD2,
            147 => arm64_insn::ARM64_INS_LD3R,
            148 => arm64_insn::ARM64_INS_LD3,
            149 => arm64_insn::ARM64_INS_LD4,
            150 => arm64_insn::ARM64_INS_LD4R,
            151 => arm64_insn::ARM64_INS_LDARB,
            152 => arm64_insn::ARM64_INS_LDARH,
            153 => arm64_insn::ARM64_INS_LDAR,
            154 => arm64_insn::ARM64_INS_LDAXP,
            155 => arm64_insn::ARM64_INS_LDAXRB,
            156 => arm64_insn::ARM64_INS_LDAXRH,
            157 => arm64_insn::ARM64_INS_LDAXR,
            158 => arm64_insn::ARM64_INS_LDNP,
            159 => arm64_insn::ARM64_INS_LDP,
            160 => arm64_insn::ARM64_INS_LDPSW,
            161 => arm64_insn::ARM64_INS_LDRB,
            162 => arm64_insn::ARM64_INS_LDR,
            163 => arm64_insn::ARM64_INS_LDRH,
            164 => arm64_insn::ARM64_INS_LDRSB,
            165 => arm64_insn::ARM64_INS_LDRSH,
            166 => arm64_insn::ARM64_INS_LDRSW,
            167 => arm64_insn::ARM64_INS_LDTRB,
            168 => arm64_insn::ARM64_INS_LDTRH,
            169 => arm64_insn::ARM64_INS_LDTRSB,
            170 => arm64_insn::ARM64_INS_LDTRSH,
            171 => arm64_insn::ARM64_INS_LDTRSW,
            172 => arm64_insn::ARM64_INS_LDTR,
            173 => arm64_insn::ARM64_INS_LDURB,
            174 => arm64_insn::ARM64_INS_LDUR,
            175 => arm64_insn::ARM64_INS_LDURH,
            176 => arm64_insn::ARM64_INS_LDURSB,
            177 => arm64_insn::ARM64_INS_LDURSH,
            178 => arm64_insn::ARM64_INS_LDURSW,
            179 => arm64_insn::ARM64_INS_LDXP,
            180 => arm64_insn::ARM64_INS_LDXRB,
            181 => arm64_insn::ARM64_INS_LDXRH,
            182 => arm64_insn::ARM64_INS_LDXR,
            183 => arm64_insn::ARM64_INS_LSL,
            184 => arm64_insn::ARM64_INS_LSR,
            185 => arm64_insn::ARM64_INS_MADD,
            186 => arm64_insn::ARM64_INS_MLA,
            187 => arm64_insn::ARM64_INS_MLS,
            188 => arm64_insn::ARM64_INS_MOVI,
            189 => arm64_insn::ARM64_INS_MOVK,
            190 => arm64_insn::ARM64_INS_MOVN,
            191 => arm64_insn::ARM64_INS_MOVZ,
            192 => arm64_insn::ARM64_INS_MRS,
            193 => arm64_insn::ARM64_INS_MSR,
            194 => arm64_insn::ARM64_INS_MSUB,
            195 => arm64_insn::ARM64_INS_MUL,
            196 => arm64_insn::ARM64_INS_MVNI,
            197 => arm64_insn::ARM64_INS_NEG,
            198 => arm64_insn::ARM64_INS_NOT,
            199 => arm64_insn::ARM64_INS_ORN,
            200 => arm64_insn::ARM64_INS_ORR,
            201 => arm64_insn::ARM64_INS_PMULL2,
            202 => arm64_insn::ARM64_INS_PMULL,
            203 => arm64_insn::ARM64_INS_PMUL,
            204 => arm64_insn::ARM64_INS_PRFM,
            205 => arm64_insn::ARM64_INS_PRFUM,
            206 => arm64_insn::ARM64_INS_RADDHN,
            207 => arm64_insn::ARM64_INS_RADDHN2,
            208 => arm64_insn::ARM64_INS_RBIT,
            209 => arm64_insn::ARM64_INS_RET,
            210 => arm64_insn::ARM64_INS_REV16,
            211 => arm64_insn::ARM64_INS_REV32,
            212 => arm64_insn::ARM64_INS_REV64,
            213 => arm64_insn::ARM64_INS_REV,
            214 => arm64_insn::ARM64_INS_ROR,
            215 => arm64_insn::ARM64_INS_RSHRN2,
            216 => arm64_insn::ARM64_INS_RSHRN,
            217 => arm64_insn::ARM64_INS_RSUBHN,
            218 => arm64_insn::ARM64_INS_RSUBHN2,
            219 => arm64_insn::ARM64_INS_SABAL2,
            220 => arm64_insn::ARM64_INS_SABAL,
            221 => arm64_insn::ARM64_INS_SABA,
            222 => arm64_insn::ARM64_INS_SABDL2,
            223 => arm64_insn::ARM64_INS_SABDL,
            224 => arm64_insn::ARM64_INS_SABD,
            225 => arm64_insn::ARM64_INS_SADALP,
            226 => arm64_insn::ARM64_INS_SADDLP,
            227 => arm64_insn::ARM64_INS_SADDLV,
            228 => arm64_insn::ARM64_INS_SADDL2,
            229 => arm64_insn::ARM64_INS_SADDL,
            230 => arm64_insn::ARM64_INS_SADDW2,
            231 => arm64_insn::ARM64_INS_SADDW,
            232 => arm64_insn::ARM64_INS_SBC,
            233 => arm64_insn::ARM64_INS_SBFM,
            234 => arm64_insn::ARM64_INS_SCVTF,
            235 => arm64_insn::ARM64_INS_SDIV,
            236 => arm64_insn::ARM64_INS_SHA1C,
            237 => arm64_insn::ARM64_INS_SHA1H,
            238 => arm64_insn::ARM64_INS_SHA1M,
            239 => arm64_insn::ARM64_INS_SHA1P,
            240 => arm64_insn::ARM64_INS_SHA1SU0,
            241 => arm64_insn::ARM64_INS_SHA1SU1,
            242 => arm64_insn::ARM64_INS_SHA256H2,
            243 => arm64_insn::ARM64_INS_SHA256H,
            244 => arm64_insn::ARM64_INS_SHA256SU0,
            245 => arm64_insn::ARM64_INS_SHA256SU1,
            246 => arm64_insn::ARM64_INS_SHADD,
            247 => arm64_insn::ARM64_INS_SHLL2,
            248 => arm64_insn::ARM64_INS_SHLL,
            249 => arm64_insn::ARM64_INS_SHL,
            250 => arm64_insn::ARM64_INS_SHRN2,
            251 => arm64_insn::ARM64_INS_SHRN,
            252 => arm64_insn::ARM64_INS_SHSUB,
            253 => arm64_insn::ARM64_INS_SLI,
            254 => arm64_insn::ARM64_INS_SMADDL,
            255 => arm64_insn::ARM64_INS_SMAXP,
            256 => arm64_insn::ARM64_INS_SMAXV,
            257 => arm64_insn::ARM64_INS_SMAX,
            258 => arm64_insn::ARM64_INS_SMC,
            259 => arm64_insn::ARM64_INS_SMINP,
            260 => arm64_insn::ARM64_INS_SMINV,
            261 => arm64_insn::ARM64_INS_SMIN,
            262 => arm64_insn::ARM64_INS_SMLAL2,
            263 => arm64_insn::ARM64_INS_SMLAL,
            264 => arm64_insn::ARM64_INS_SMLSL2,
            265 => arm64_insn::ARM64_INS_SMLSL,
            266 => arm64_insn::ARM64_INS_SMOV,
            267 => arm64_insn::ARM64_INS_SMSUBL,
            268 => arm64_insn::ARM64_INS_SMULH,
            269 => arm64_insn::ARM64_INS_SMULL2,
            270 => arm64_insn::ARM64_INS_SMULL,
            271 => arm64_insn::ARM64_INS_SQABS,
            272 => arm64_insn::ARM64_INS_SQADD,
            273 => arm64_insn::ARM64_INS_SQDMLAL,
            274 => arm64_insn::ARM64_INS_SQDMLAL2,
            275 => arm64_insn::ARM64_INS_SQDMLSL,
            276 => arm64_insn::ARM64_INS_SQDMLSL2,
            277 => arm64_insn::ARM64_INS_SQDMULH,
            278 => arm64_insn::ARM64_INS_SQDMULL,
            279 => arm64_insn::ARM64_INS_SQDMULL2,
            280 => arm64_insn::ARM64_INS_SQNEG,
            281 => arm64_insn::ARM64_INS_SQRDMULH,
            282 => arm64_insn::ARM64_INS_SQRSHL,
            283 => arm64_insn::ARM64_INS_SQRSHRN,
            284 => arm64_insn::ARM64_INS_SQRSHRN2,
            285 => arm64_insn::ARM64_INS_SQRSHRUN,
            286 => arm64_insn::ARM64_INS_SQRSHRUN2,
            287 => arm64_insn::ARM64_INS_SQSHLU,
            288 => arm64_insn::ARM64_INS_SQSHL,
            289 => arm64_insn::ARM64_INS_SQSHRN,
            290 => arm64_insn::ARM64_INS_SQSHRN2,
            291 => arm64_insn::ARM64_INS_SQSHRUN,
            292 => arm64_insn::ARM64_INS_SQSHRUN2,
            293 => arm64_insn::ARM64_INS_SQSUB,
            294 => arm64_insn::ARM64_INS_SQXTN2,
            295 => arm64_insn::ARM64_INS_SQXTN,
            296 => arm64_insn::ARM64_INS_SQXTUN2,
            297 => arm64_insn::ARM64_INS_SQXTUN,
            298 => arm64_insn::ARM64_INS_SRHADD,
            299 => arm64_insn::ARM64_INS_SRI,
            300 => arm64_insn::ARM64_INS_SRSHL,
            301 => arm64_insn::ARM64_INS_SRSHR,
            302 => arm64_insn::ARM64_INS_SRSRA,
            303 => arm64_insn::ARM64_INS_SSHLL2,
            304 => arm64_insn::ARM64_INS_SSHLL,
            305 => arm64_insn::ARM64_INS_SSHL,
            306 => arm64_insn::ARM64_INS_SSHR,
            307 => arm64_insn::ARM64_INS_SSRA,
            308 => arm64_insn::ARM64_INS_SSUBL2,
            309 => arm64_insn::ARM64_INS_SSUBL,
            310 => arm64_insn::ARM64_INS_SSUBW2,
            311 => arm64_insn::ARM64_INS_SSUBW,
            312 => arm64_insn::ARM64_INS_ST1,
            313 => arm64_insn::ARM64_INS_ST2,
            314 => arm64_insn::ARM64_INS_ST3,
            315 => arm64_insn::ARM64_INS_ST4,
            316 => arm64_insn::ARM64_INS_STLRB,
            317 => arm64_insn::ARM64_INS_STLRH,
            318 => arm64_insn::ARM64_INS_STLR,
            319 => arm64_insn::ARM64_INS_STLXP,
            320 => arm64_insn::ARM64_INS_STLXRB,
            321 => arm64_insn::ARM64_INS_STLXRH,
            322 => arm64_insn::ARM64_INS_STLXR,
            323 => arm64_insn::ARM64_INS_STNP,
            324 => arm64_insn::ARM64_INS_STP,
            325 => arm64_insn::ARM64_INS_STRB,
            326 => arm64_insn::ARM64_INS_STR,
            327 => arm64_insn::ARM64_INS_STRH,
            328 => arm64_insn::ARM64_INS_STTRB,
            329 => arm64_insn::ARM64_INS_STTRH,
            330 => arm64_insn::ARM64_INS_STTR,
            331 => arm64_insn::ARM64_INS_STURB,
            332 => arm64_insn::ARM64_INS_STUR,
            333 => arm64_insn::ARM64_INS_STURH,
            334 => arm64_insn::ARM64_INS_STXP,
            335 => arm64_insn::ARM64_INS_STXRB,
            336 => arm64_insn::ARM64_INS_STXRH,
            337 => arm64_insn::ARM64_INS_STXR,
            338 => arm64_insn::ARM64_INS_SUBHN,
            339 => arm64_insn::ARM64_INS_SUBHN2,
            340 => arm64_insn::ARM64_INS_SUB,
            341 => arm64_insn::ARM64_INS_SUQADD,
            342 => arm64_insn::ARM64_INS_SVC,
            343 => arm64_insn::ARM64_INS_SYSL,
            344 => arm64_insn::ARM64_INS_SYS,
            345 => arm64_insn::ARM64_INS_TBL,
            346 => arm64_insn::ARM64_INS_TBNZ,
            347 => arm64_insn::ARM64_INS_TBX,
            348 => arm64_insn::ARM64_INS_TBZ,
            349 => arm64_insn::ARM64_INS_TRN1,
            350 => arm64_insn::ARM64_INS_TRN2,
            351 => arm64_insn::ARM64_INS_UABAL2,
            352 => arm64_insn::ARM64_INS_UABAL,
            353 => arm64_insn::ARM64_INS_UABA,
            354 => arm64_insn::ARM64_INS_UABDL2,
            355 => arm64_insn::ARM64_INS_UABDL,
            356 => arm64_insn::ARM64_INS_UABD,
            357 => arm64_insn::ARM64_INS_UADALP,
            358 => arm64_insn::ARM64_INS_UADDLP,
            359 => arm64_insn::ARM64_INS_UADDLV,
            360 => arm64_insn::ARM64_INS_UADDL2,
            361 => arm64_insn::ARM64_INS_UADDL,
            362 => arm64_insn::ARM64_INS_UADDW2,
            363 => arm64_insn::ARM64_INS_UADDW,
            364 => arm64_insn::ARM64_INS_UBFM,
            365 => arm64_insn::ARM64_INS_UCVTF,
            366 => arm64_insn::ARM64_INS_UDIV,
            367 => arm64_insn::ARM64_INS_UHADD,
            368 => arm64_insn::ARM64_INS_UHSUB,
            369 => arm64_insn::ARM64_INS_UMADDL,
            370 => arm64_insn::ARM64_INS_UMAXP,
            371 => arm64_insn::ARM64_INS_UMAXV,
            372 => arm64_insn::ARM64_INS_UMAX,
            373 => arm64_insn::ARM64_INS_UMINP,
            374 => arm64_insn::ARM64_INS_UMINV,
            375 => arm64_insn::ARM64_INS_UMIN,
            376 => arm64_insn::ARM64_INS_UMLAL2,
            377 => arm64_insn::ARM64_INS_UMLAL,
            378 => arm64_insn::ARM64_INS_UMLSL2,
            379 => arm64_insn::ARM64_INS_UMLSL,
            380 => arm64_insn::ARM64_INS_UMOV,
            381 => arm64_insn::ARM64_INS_UMSUBL,
            382 => arm64_insn::ARM64_INS_UMULH,
            383 => arm64_insn::ARM64_INS_UMULL2,
            384 => arm64_insn::ARM64_INS_UMULL,
            385 => arm64_insn::ARM64_INS_UQADD,
            386 => arm64_insn::ARM64_INS_UQRSHL,
            387 => arm64_insn::ARM64_INS_UQRSHRN,
            388 => arm64_insn::ARM64_INS_UQRSHRN2,
            389 => arm64_insn::ARM64_INS_UQSHL,
            390 => arm64_insn::ARM64_INS_UQSHRN,
            391 => arm64_insn::ARM64_INS_UQSHRN2,
            392 => arm64_insn::ARM64_INS_UQSUB,
            393 => arm64_insn::ARM64_INS_UQXTN2,
            394 => arm64_insn::ARM64_INS_UQXTN,
            395 => arm64_insn::ARM64_INS_URECPE,
            396 => arm64_insn::ARM64_INS_URHADD,
            397 => arm64_insn::ARM64_INS_URSHL,
            398 => arm64_insn::ARM64_INS_URSHR,
            399 => arm64_insn::ARM64_INS_URSQRTE,
            400 => arm64_insn::ARM64_INS_URSRA,
            401 => arm64_insn::ARM64_INS_USHLL2,
            402 => arm64_insn::ARM64_INS_USHLL,
            403 => arm64_insn::ARM64_INS_USHL,
            404 => arm64_insn::ARM64_INS_USHR,
            405 => arm64_insn::ARM64_INS_USQADD,
            406 => arm64_insn::ARM64_INS_USRA,
            407 => arm64_insn::ARM64_INS_USUBL2,
            408 => arm64_insn::ARM64_INS_USUBL,
            409 => arm64_insn::ARM64_INS_USUBW2,
            410 => arm64_insn::ARM64_INS_USUBW,
            411 => arm64_insn::ARM64_INS_UZP1,
            412 => arm64_insn::ARM64_INS_UZP2,
            413 => arm64_insn::ARM64_INS_XTN2,
            414 => arm64_insn::ARM64_INS_XTN,
            415 => arm64_insn::ARM64_INS_ZIP1,
            416 => arm64_insn::ARM64_INS_ZIP2,
            417 => arm64_insn::ARM64_INS_MNEG,
            418 => arm64_insn::ARM64_INS_UMNEGL,
            419 => arm64_insn::ARM64_INS_SMNEGL,
            420 => arm64_insn::ARM64_INS_NOP,
            421 => arm64_insn::ARM64_INS_YIELD,
            422 => arm64_insn::ARM64_INS_WFE,
            423 => arm64_insn::ARM64_INS_WFI,
            424 => arm64_insn::ARM64_INS_SEV,
            425 => arm64_insn::ARM64_INS_SEVL,
            426 => arm64_insn::ARM64_INS_NGC,
            427 => arm64_insn::ARM64_INS_SBFIZ,
            428 => arm64_insn::ARM64_INS_UBFIZ,
            429 => arm64_insn::ARM64_INS_SBFX,
            430 => arm64_insn::ARM64_INS_UBFX,
            431 => arm64_insn::ARM64_INS_BFI,
            432 => arm64_insn::ARM64_INS_BFXIL,
            433 => arm64_insn::ARM64_INS_CMN,
            434 => arm64_insn::ARM64_INS_MVN,
            435 => arm64_insn::ARM64_INS_TST,
            436 => arm64_insn::ARM64_INS_CSET,
            437 => arm64_insn::ARM64_INS_CINC,
            438 => arm64_insn::ARM64_INS_CSETM,
            439 => arm64_insn::ARM64_INS_CINV,
            440 => arm64_insn::ARM64_INS_CNEG,
            441 => arm64_insn::ARM64_INS_SXTB,
            442 => arm64_insn::ARM64_INS_SXTH,
            443 => arm64_insn::ARM64_INS_SXTW,
            444 => arm64_insn::ARM64_INS_CMP,
            445 => arm64_insn::ARM64_INS_UXTB,
            446 => arm64_insn::ARM64_INS_UXTH,
            447 => arm64_insn::ARM64_INS_UXTW,
            448 => arm64_insn::ARM64_INS_IC,
            449 => arm64_insn::ARM64_INS_DC,
            450 => arm64_insn::ARM64_INS_AT,
            451 => arm64_insn::ARM64_INS_TLBI,
            452 => arm64_insn::ARM64_INS_NEGS,
            453 => arm64_insn::ARM64_INS_NGCS,
            454 => arm64_insn::ARM64_INS_ENDING,
            _ => arm64_insn::ARM64_INS_INVALID,
        }
    }
}
impl From<u32> for evm_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => evm_insn::EVM_INS_STOP,
            1 => evm_insn::EVM_INS_ADD,
            2 => evm_insn::EVM_INS_MUL,
            3 => evm_insn::EVM_INS_SUB,
            4 => evm_insn::EVM_INS_DIV,
            5 => evm_insn::EVM_INS_SDIV,
            6 => evm_insn::EVM_INS_MOD,
            7 => evm_insn::EVM_INS_SMOD,
            8 => evm_insn::EVM_INS_ADDMOD,
            9 => evm_insn::EVM_INS_MULMOD,
            10 => evm_insn::EVM_INS_EXP,
            11 => evm_insn::EVM_INS_SIGNEXTEND,
            16 => evm_insn::EVM_INS_LT,
            17 => evm_insn::EVM_INS_GT,
            18 => evm_insn::EVM_INS_SLT,
            19 => evm_insn::EVM_INS_SGT,
            20 => evm_insn::EVM_INS_EQ,
            21 => evm_insn::EVM_INS_ISZERO,
            22 => evm_insn::EVM_INS_AND,
            23 => evm_insn::EVM_INS_OR,
            24 => evm_insn::EVM_INS_XOR,
            25 => evm_insn::EVM_INS_NOT,
            26 => evm_insn::EVM_INS_BYTE,
            32 => evm_insn::EVM_INS_SHA3,
            48 => evm_insn::EVM_INS_ADDRESS,
            49 => evm_insn::EVM_INS_BALANCE,
            50 => evm_insn::EVM_INS_ORIGIN,
            51 => evm_insn::EVM_INS_CALLER,
            52 => evm_insn::EVM_INS_CALLVALUE,
            53 => evm_insn::EVM_INS_CALLDATALOAD,
            54 => evm_insn::EVM_INS_CALLDATASIZE,
            55 => evm_insn::EVM_INS_CALLDATACOPY,
            56 => evm_insn::EVM_INS_CODESIZE,
            57 => evm_insn::EVM_INS_CODECOPY,
            58 => evm_insn::EVM_INS_GASPRICE,
            59 => evm_insn::EVM_INS_EXTCODESIZE,
            60 => evm_insn::EVM_INS_EXTCODECOPY,
            61 => evm_insn::EVM_INS_RETURNDATASIZE,
            62 => evm_insn::EVM_INS_RETURNDATACOPY,
            64 => evm_insn::EVM_INS_BLOCKHASH,
            65 => evm_insn::EVM_INS_COINBASE,
            66 => evm_insn::EVM_INS_TIMESTAMP,
            67 => evm_insn::EVM_INS_NUMBER,
            68 => evm_insn::EVM_INS_DIFFICULTY,
            69 => evm_insn::EVM_INS_GASLIMIT,
            80 => evm_insn::EVM_INS_POP,
            81 => evm_insn::EVM_INS_MLOAD,
            82 => evm_insn::EVM_INS_MSTORE,
            83 => evm_insn::EVM_INS_MSTORE8,
            84 => evm_insn::EVM_INS_SLOAD,
            85 => evm_insn::EVM_INS_SSTORE,
            86 => evm_insn::EVM_INS_JUMP,
            87 => evm_insn::EVM_INS_JUMPI,
            88 => evm_insn::EVM_INS_PC,
            89 => evm_insn::EVM_INS_MSIZE,
            90 => evm_insn::EVM_INS_GAS,
            91 => evm_insn::EVM_INS_JUMPDEST,
            96 => evm_insn::EVM_INS_PUSH1,
            97 => evm_insn::EVM_INS_PUSH2,
            98 => evm_insn::EVM_INS_PUSH3,
            99 => evm_insn::EVM_INS_PUSH4,
            100 => evm_insn::EVM_INS_PUSH5,
            101 => evm_insn::EVM_INS_PUSH6,
            102 => evm_insn::EVM_INS_PUSH7,
            103 => evm_insn::EVM_INS_PUSH8,
            104 => evm_insn::EVM_INS_PUSH9,
            105 => evm_insn::EVM_INS_PUSH10,
            106 => evm_insn::EVM_INS_PUSH11,
            107 => evm_insn::EVM_INS_PUSH12,
            108 => evm_insn::EVM_INS_PUSH13,
            109 => evm_insn::EVM_INS_PUSH14,
            110 => evm_insn::EVM_INS_PUSH15,
            111 => evm_insn::EVM_INS_PUSH16,
            112 => evm_insn::EVM_INS_PUSH17,
            113 => evm_insn::EVM_INS_PUSH18,
            114 => evm_insn::EVM_INS_PUSH19,
            115 => evm_insn::EVM_INS_PUSH20,
            116 => evm_insn::EVM_INS_PUSH21,
            117 => evm_insn::EVM_INS_PUSH22,
            118 => evm_insn::EVM_INS_PUSH23,
            119 => evm_insn::EVM_INS_PUSH24,
            120 => evm_insn::EVM_INS_PUSH25,
            121 => evm_insn::EVM_INS_PUSH26,
            122 => evm_insn::EVM_INS_PUSH27,
            123 => evm_insn::EVM_INS_PUSH28,
            124 => evm_insn::EVM_INS_PUSH29,
            125 => evm_insn::EVM_INS_PUSH30,
            126 => evm_insn::EVM_INS_PUSH31,
            127 => evm_insn::EVM_INS_PUSH32,
            128 => evm_insn::EVM_INS_DUP1,
            129 => evm_insn::EVM_INS_DUP2,
            130 => evm_insn::EVM_INS_DUP3,
            131 => evm_insn::EVM_INS_DUP4,
            132 => evm_insn::EVM_INS_DUP5,
            133 => evm_insn::EVM_INS_DUP6,
            134 => evm_insn::EVM_INS_DUP7,
            135 => evm_insn::EVM_INS_DUP8,
            136 => evm_insn::EVM_INS_DUP9,
            137 => evm_insn::EVM_INS_DUP10,
            138 => evm_insn::EVM_INS_DUP11,
            139 => evm_insn::EVM_INS_DUP12,
            140 => evm_insn::EVM_INS_DUP13,
            141 => evm_insn::EVM_INS_DUP14,
            142 => evm_insn::EVM_INS_DUP15,
            143 => evm_insn::EVM_INS_DUP16,
            144 => evm_insn::EVM_INS_SWAP1,
            145 => evm_insn::EVM_INS_SWAP2,
            146 => evm_insn::EVM_INS_SWAP3,
            147 => evm_insn::EVM_INS_SWAP4,
            148 => evm_insn::EVM_INS_SWAP5,
            149 => evm_insn::EVM_INS_SWAP6,
            150 => evm_insn::EVM_INS_SWAP7,
            151 => evm_insn::EVM_INS_SWAP8,
            152 => evm_insn::EVM_INS_SWAP9,
            153 => evm_insn::EVM_INS_SWAP10,
            154 => evm_insn::EVM_INS_SWAP11,
            155 => evm_insn::EVM_INS_SWAP12,
            156 => evm_insn::EVM_INS_SWAP13,
            157 => evm_insn::EVM_INS_SWAP14,
            158 => evm_insn::EVM_INS_SWAP15,
            159 => evm_insn::EVM_INS_SWAP16,
            160 => evm_insn::EVM_INS_LOG0,
            161 => evm_insn::EVM_INS_LOG1,
            162 => evm_insn::EVM_INS_LOG2,
            163 => evm_insn::EVM_INS_LOG3,
            164 => evm_insn::EVM_INS_LOG4,
            240 => evm_insn::EVM_INS_CREATE,
            241 => evm_insn::EVM_INS_CALL,
            242 => evm_insn::EVM_INS_CALLCODE,
            243 => evm_insn::EVM_INS_RETURN,
            244 => evm_insn::EVM_INS_DELEGATECALL,
            245 => evm_insn::EVM_INS_CALLBLACKBOX,
            250 => evm_insn::EVM_INS_STATICCALL,
            253 => evm_insn::EVM_INS_REVERT,
            255 => evm_insn::EVM_INS_SUICIDE,
            512 => evm_insn::EVM_INS_INVALID,
            513 => evm_insn::EVM_INS_ENDING,
            _ => evm_insn::EVM_INS_INVALID,
        }
    }
}
impl From<u32> for m680x_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => m680x_insn::M680X_INS_INVLD,
            1 => m680x_insn::M680X_INS_ABA,
            2 => m680x_insn::M680X_INS_ABX,
            3 => m680x_insn::M680X_INS_ABY,
            4 => m680x_insn::M680X_INS_ADC,
            5 => m680x_insn::M680X_INS_ADCA,
            6 => m680x_insn::M680X_INS_ADCB,
            7 => m680x_insn::M680X_INS_ADCD,
            8 => m680x_insn::M680X_INS_ADCR,
            9 => m680x_insn::M680X_INS_ADD,
            10 => m680x_insn::M680X_INS_ADDA,
            11 => m680x_insn::M680X_INS_ADDB,
            12 => m680x_insn::M680X_INS_ADDD,
            13 => m680x_insn::M680X_INS_ADDE,
            14 => m680x_insn::M680X_INS_ADDF,
            15 => m680x_insn::M680X_INS_ADDR,
            16 => m680x_insn::M680X_INS_ADDW,
            17 => m680x_insn::M680X_INS_AIM,
            18 => m680x_insn::M680X_INS_AIS,
            19 => m680x_insn::M680X_INS_AIX,
            20 => m680x_insn::M680X_INS_AND,
            21 => m680x_insn::M680X_INS_ANDA,
            22 => m680x_insn::M680X_INS_ANDB,
            23 => m680x_insn::M680X_INS_ANDCC,
            24 => m680x_insn::M680X_INS_ANDD,
            25 => m680x_insn::M680X_INS_ANDR,
            26 => m680x_insn::M680X_INS_ASL,
            27 => m680x_insn::M680X_INS_ASLA,
            28 => m680x_insn::M680X_INS_ASLB,
            29 => m680x_insn::M680X_INS_ASLD,
            30 => m680x_insn::M680X_INS_ASR,
            31 => m680x_insn::M680X_INS_ASRA,
            32 => m680x_insn::M680X_INS_ASRB,
            33 => m680x_insn::M680X_INS_ASRD,
            34 => m680x_insn::M680X_INS_ASRX,
            35 => m680x_insn::M680X_INS_BAND,
            36 => m680x_insn::M680X_INS_BCC,
            37 => m680x_insn::M680X_INS_BCLR,
            38 => m680x_insn::M680X_INS_BCS,
            39 => m680x_insn::M680X_INS_BEOR,
            40 => m680x_insn::M680X_INS_BEQ,
            41 => m680x_insn::M680X_INS_BGE,
            42 => m680x_insn::M680X_INS_BGND,
            43 => m680x_insn::M680X_INS_BGT,
            44 => m680x_insn::M680X_INS_BHCC,
            45 => m680x_insn::M680X_INS_BHCS,
            46 => m680x_insn::M680X_INS_BHI,
            47 => m680x_insn::M680X_INS_BIAND,
            48 => m680x_insn::M680X_INS_BIEOR,
            49 => m680x_insn::M680X_INS_BIH,
            50 => m680x_insn::M680X_INS_BIL,
            51 => m680x_insn::M680X_INS_BIOR,
            52 => m680x_insn::M680X_INS_BIT,
            53 => m680x_insn::M680X_INS_BITA,
            54 => m680x_insn::M680X_INS_BITB,
            55 => m680x_insn::M680X_INS_BITD,
            56 => m680x_insn::M680X_INS_BITMD,
            57 => m680x_insn::M680X_INS_BLE,
            58 => m680x_insn::M680X_INS_BLS,
            59 => m680x_insn::M680X_INS_BLT,
            60 => m680x_insn::M680X_INS_BMC,
            61 => m680x_insn::M680X_INS_BMI,
            62 => m680x_insn::M680X_INS_BMS,
            63 => m680x_insn::M680X_INS_BNE,
            64 => m680x_insn::M680X_INS_BOR,
            65 => m680x_insn::M680X_INS_BPL,
            66 => m680x_insn::M680X_INS_BRCLR,
            67 => m680x_insn::M680X_INS_BRSET,
            68 => m680x_insn::M680X_INS_BRA,
            69 => m680x_insn::M680X_INS_BRN,
            70 => m680x_insn::M680X_INS_BSET,
            71 => m680x_insn::M680X_INS_BSR,
            72 => m680x_insn::M680X_INS_BVC,
            73 => m680x_insn::M680X_INS_BVS,
            74 => m680x_insn::M680X_INS_CALL,
            75 => m680x_insn::M680X_INS_CBA,
            76 => m680x_insn::M680X_INS_CBEQ,
            77 => m680x_insn::M680X_INS_CBEQA,
            78 => m680x_insn::M680X_INS_CBEQX,
            79 => m680x_insn::M680X_INS_CLC,
            80 => m680x_insn::M680X_INS_CLI,
            81 => m680x_insn::M680X_INS_CLR,
            82 => m680x_insn::M680X_INS_CLRA,
            83 => m680x_insn::M680X_INS_CLRB,
            84 => m680x_insn::M680X_INS_CLRD,
            85 => m680x_insn::M680X_INS_CLRE,
            86 => m680x_insn::M680X_INS_CLRF,
            87 => m680x_insn::M680X_INS_CLRH,
            88 => m680x_insn::M680X_INS_CLRW,
            89 => m680x_insn::M680X_INS_CLRX,
            90 => m680x_insn::M680X_INS_CLV,
            91 => m680x_insn::M680X_INS_CMP,
            92 => m680x_insn::M680X_INS_CMPA,
            93 => m680x_insn::M680X_INS_CMPB,
            94 => m680x_insn::M680X_INS_CMPD,
            95 => m680x_insn::M680X_INS_CMPE,
            96 => m680x_insn::M680X_INS_CMPF,
            97 => m680x_insn::M680X_INS_CMPR,
            98 => m680x_insn::M680X_INS_CMPS,
            99 => m680x_insn::M680X_INS_CMPU,
            100 => m680x_insn::M680X_INS_CMPW,
            101 => m680x_insn::M680X_INS_CMPX,
            102 => m680x_insn::M680X_INS_CMPY,
            103 => m680x_insn::M680X_INS_COM,
            104 => m680x_insn::M680X_INS_COMA,
            105 => m680x_insn::M680X_INS_COMB,
            106 => m680x_insn::M680X_INS_COMD,
            107 => m680x_insn::M680X_INS_COME,
            108 => m680x_insn::M680X_INS_COMF,
            109 => m680x_insn::M680X_INS_COMW,
            110 => m680x_insn::M680X_INS_COMX,
            111 => m680x_insn::M680X_INS_CPD,
            112 => m680x_insn::M680X_INS_CPHX,
            113 => m680x_insn::M680X_INS_CPS,
            114 => m680x_insn::M680X_INS_CPX,
            115 => m680x_insn::M680X_INS_CPY,
            116 => m680x_insn::M680X_INS_CWAI,
            117 => m680x_insn::M680X_INS_DAA,
            118 => m680x_insn::M680X_INS_DBEQ,
            119 => m680x_insn::M680X_INS_DBNE,
            120 => m680x_insn::M680X_INS_DBNZ,
            121 => m680x_insn::M680X_INS_DBNZA,
            122 => m680x_insn::M680X_INS_DBNZX,
            123 => m680x_insn::M680X_INS_DEC,
            124 => m680x_insn::M680X_INS_DECA,
            125 => m680x_insn::M680X_INS_DECB,
            126 => m680x_insn::M680X_INS_DECD,
            127 => m680x_insn::M680X_INS_DECE,
            128 => m680x_insn::M680X_INS_DECF,
            129 => m680x_insn::M680X_INS_DECW,
            130 => m680x_insn::M680X_INS_DECX,
            131 => m680x_insn::M680X_INS_DES,
            132 => m680x_insn::M680X_INS_DEX,
            133 => m680x_insn::M680X_INS_DEY,
            134 => m680x_insn::M680X_INS_DIV,
            135 => m680x_insn::M680X_INS_DIVD,
            136 => m680x_insn::M680X_INS_DIVQ,
            137 => m680x_insn::M680X_INS_EDIV,
            138 => m680x_insn::M680X_INS_EDIVS,
            139 => m680x_insn::M680X_INS_EIM,
            140 => m680x_insn::M680X_INS_EMACS,
            141 => m680x_insn::M680X_INS_EMAXD,
            142 => m680x_insn::M680X_INS_EMAXM,
            143 => m680x_insn::M680X_INS_EMIND,
            144 => m680x_insn::M680X_INS_EMINM,
            145 => m680x_insn::M680X_INS_EMUL,
            146 => m680x_insn::M680X_INS_EMULS,
            147 => m680x_insn::M680X_INS_EOR,
            148 => m680x_insn::M680X_INS_EORA,
            149 => m680x_insn::M680X_INS_EORB,
            150 => m680x_insn::M680X_INS_EORD,
            151 => m680x_insn::M680X_INS_EORR,
            152 => m680x_insn::M680X_INS_ETBL,
            153 => m680x_insn::M680X_INS_EXG,
            154 => m680x_insn::M680X_INS_FDIV,
            155 => m680x_insn::M680X_INS_IBEQ,
            156 => m680x_insn::M680X_INS_IBNE,
            157 => m680x_insn::M680X_INS_IDIV,
            158 => m680x_insn::M680X_INS_IDIVS,
            159 => m680x_insn::M680X_INS_ILLGL,
            160 => m680x_insn::M680X_INS_INC,
            161 => m680x_insn::M680X_INS_INCA,
            162 => m680x_insn::M680X_INS_INCB,
            163 => m680x_insn::M680X_INS_INCD,
            164 => m680x_insn::M680X_INS_INCE,
            165 => m680x_insn::M680X_INS_INCF,
            166 => m680x_insn::M680X_INS_INCW,
            167 => m680x_insn::M680X_INS_INCX,
            168 => m680x_insn::M680X_INS_INS,
            169 => m680x_insn::M680X_INS_INX,
            170 => m680x_insn::M680X_INS_INY,
            171 => m680x_insn::M680X_INS_JMP,
            172 => m680x_insn::M680X_INS_JSR,
            173 => m680x_insn::M680X_INS_LBCC,
            174 => m680x_insn::M680X_INS_LBCS,
            175 => m680x_insn::M680X_INS_LBEQ,
            176 => m680x_insn::M680X_INS_LBGE,
            177 => m680x_insn::M680X_INS_LBGT,
            178 => m680x_insn::M680X_INS_LBHI,
            179 => m680x_insn::M680X_INS_LBLE,
            180 => m680x_insn::M680X_INS_LBLS,
            181 => m680x_insn::M680X_INS_LBLT,
            182 => m680x_insn::M680X_INS_LBMI,
            183 => m680x_insn::M680X_INS_LBNE,
            184 => m680x_insn::M680X_INS_LBPL,
            185 => m680x_insn::M680X_INS_LBRA,
            186 => m680x_insn::M680X_INS_LBRN,
            187 => m680x_insn::M680X_INS_LBSR,
            188 => m680x_insn::M680X_INS_LBVC,
            189 => m680x_insn::M680X_INS_LBVS,
            190 => m680x_insn::M680X_INS_LDA,
            191 => m680x_insn::M680X_INS_LDAA,
            192 => m680x_insn::M680X_INS_LDAB,
            193 => m680x_insn::M680X_INS_LDB,
            194 => m680x_insn::M680X_INS_LDBT,
            195 => m680x_insn::M680X_INS_LDD,
            196 => m680x_insn::M680X_INS_LDE,
            197 => m680x_insn::M680X_INS_LDF,
            198 => m680x_insn::M680X_INS_LDHX,
            199 => m680x_insn::M680X_INS_LDMD,
            200 => m680x_insn::M680X_INS_LDQ,
            201 => m680x_insn::M680X_INS_LDS,
            202 => m680x_insn::M680X_INS_LDU,
            203 => m680x_insn::M680X_INS_LDW,
            204 => m680x_insn::M680X_INS_LDX,
            205 => m680x_insn::M680X_INS_LDY,
            206 => m680x_insn::M680X_INS_LEAS,
            207 => m680x_insn::M680X_INS_LEAU,
            208 => m680x_insn::M680X_INS_LEAX,
            209 => m680x_insn::M680X_INS_LEAY,
            210 => m680x_insn::M680X_INS_LSL,
            211 => m680x_insn::M680X_INS_LSLA,
            212 => m680x_insn::M680X_INS_LSLB,
            213 => m680x_insn::M680X_INS_LSLD,
            214 => m680x_insn::M680X_INS_LSLX,
            215 => m680x_insn::M680X_INS_LSR,
            216 => m680x_insn::M680X_INS_LSRA,
            217 => m680x_insn::M680X_INS_LSRB,
            218 => m680x_insn::M680X_INS_LSRD,
            219 => m680x_insn::M680X_INS_LSRW,
            220 => m680x_insn::M680X_INS_LSRX,
            221 => m680x_insn::M680X_INS_MAXA,
            222 => m680x_insn::M680X_INS_MAXM,
            223 => m680x_insn::M680X_INS_MEM,
            224 => m680x_insn::M680X_INS_MINA,
            225 => m680x_insn::M680X_INS_MINM,
            226 => m680x_insn::M680X_INS_MOV,
            227 => m680x_insn::M680X_INS_MOVB,
            228 => m680x_insn::M680X_INS_MOVW,
            229 => m680x_insn::M680X_INS_MUL,
            230 => m680x_insn::M680X_INS_MULD,
            231 => m680x_insn::M680X_INS_NEG,
            232 => m680x_insn::M680X_INS_NEGA,
            233 => m680x_insn::M680X_INS_NEGB,
            234 => m680x_insn::M680X_INS_NEGD,
            235 => m680x_insn::M680X_INS_NEGX,
            236 => m680x_insn::M680X_INS_NOP,
            237 => m680x_insn::M680X_INS_NSA,
            238 => m680x_insn::M680X_INS_OIM,
            239 => m680x_insn::M680X_INS_ORA,
            240 => m680x_insn::M680X_INS_ORAA,
            241 => m680x_insn::M680X_INS_ORAB,
            242 => m680x_insn::M680X_INS_ORB,
            243 => m680x_insn::M680X_INS_ORCC,
            244 => m680x_insn::M680X_INS_ORD,
            245 => m680x_insn::M680X_INS_ORR,
            246 => m680x_insn::M680X_INS_PSHA,
            247 => m680x_insn::M680X_INS_PSHB,
            248 => m680x_insn::M680X_INS_PSHC,
            249 => m680x_insn::M680X_INS_PSHD,
            250 => m680x_insn::M680X_INS_PSHH,
            251 => m680x_insn::M680X_INS_PSHS,
            252 => m680x_insn::M680X_INS_PSHSW,
            253 => m680x_insn::M680X_INS_PSHU,
            254 => m680x_insn::M680X_INS_PSHUW,
            255 => m680x_insn::M680X_INS_PSHX,
            256 => m680x_insn::M680X_INS_PSHY,
            257 => m680x_insn::M680X_INS_PULA,
            258 => m680x_insn::M680X_INS_PULB,
            259 => m680x_insn::M680X_INS_PULC,
            260 => m680x_insn::M680X_INS_PULD,
            261 => m680x_insn::M680X_INS_PULH,
            262 => m680x_insn::M680X_INS_PULS,
            263 => m680x_insn::M680X_INS_PULSW,
            264 => m680x_insn::M680X_INS_PULU,
            265 => m680x_insn::M680X_INS_PULUW,
            266 => m680x_insn::M680X_INS_PULX,
            267 => m680x_insn::M680X_INS_PULY,
            268 => m680x_insn::M680X_INS_REV,
            269 => m680x_insn::M680X_INS_REVW,
            270 => m680x_insn::M680X_INS_ROL,
            271 => m680x_insn::M680X_INS_ROLA,
            272 => m680x_insn::M680X_INS_ROLB,
            273 => m680x_insn::M680X_INS_ROLD,
            274 => m680x_insn::M680X_INS_ROLW,
            275 => m680x_insn::M680X_INS_ROLX,
            276 => m680x_insn::M680X_INS_ROR,
            277 => m680x_insn::M680X_INS_RORA,
            278 => m680x_insn::M680X_INS_RORB,
            279 => m680x_insn::M680X_INS_RORD,
            280 => m680x_insn::M680X_INS_RORW,
            281 => m680x_insn::M680X_INS_RORX,
            282 => m680x_insn::M680X_INS_RSP,
            283 => m680x_insn::M680X_INS_RTC,
            284 => m680x_insn::M680X_INS_RTI,
            285 => m680x_insn::M680X_INS_RTS,
            286 => m680x_insn::M680X_INS_SBA,
            287 => m680x_insn::M680X_INS_SBC,
            288 => m680x_insn::M680X_INS_SBCA,
            289 => m680x_insn::M680X_INS_SBCB,
            290 => m680x_insn::M680X_INS_SBCD,
            291 => m680x_insn::M680X_INS_SBCR,
            292 => m680x_insn::M680X_INS_SEC,
            293 => m680x_insn::M680X_INS_SEI,
            294 => m680x_insn::M680X_INS_SEV,
            295 => m680x_insn::M680X_INS_SEX,
            296 => m680x_insn::M680X_INS_SEXW,
            297 => m680x_insn::M680X_INS_SLP,
            298 => m680x_insn::M680X_INS_STA,
            299 => m680x_insn::M680X_INS_STAA,
            300 => m680x_insn::M680X_INS_STAB,
            301 => m680x_insn::M680X_INS_STB,
            302 => m680x_insn::M680X_INS_STBT,
            303 => m680x_insn::M680X_INS_STD,
            304 => m680x_insn::M680X_INS_STE,
            305 => m680x_insn::M680X_INS_STF,
            306 => m680x_insn::M680X_INS_STOP,
            307 => m680x_insn::M680X_INS_STHX,
            308 => m680x_insn::M680X_INS_STQ,
            309 => m680x_insn::M680X_INS_STS,
            310 => m680x_insn::M680X_INS_STU,
            311 => m680x_insn::M680X_INS_STW,
            312 => m680x_insn::M680X_INS_STX,
            313 => m680x_insn::M680X_INS_STY,
            314 => m680x_insn::M680X_INS_SUB,
            315 => m680x_insn::M680X_INS_SUBA,
            316 => m680x_insn::M680X_INS_SUBB,
            317 => m680x_insn::M680X_INS_SUBD,
            318 => m680x_insn::M680X_INS_SUBE,
            319 => m680x_insn::M680X_INS_SUBF,
            320 => m680x_insn::M680X_INS_SUBR,
            321 => m680x_insn::M680X_INS_SUBW,
            322 => m680x_insn::M680X_INS_SWI,
            323 => m680x_insn::M680X_INS_SWI2,
            324 => m680x_insn::M680X_INS_SWI3,
            325 => m680x_insn::M680X_INS_SYNC,
            326 => m680x_insn::M680X_INS_TAB,
            327 => m680x_insn::M680X_INS_TAP,
            328 => m680x_insn::M680X_INS_TAX,
            329 => m680x_insn::M680X_INS_TBA,
            330 => m680x_insn::M680X_INS_TBEQ,
            331 => m680x_insn::M680X_INS_TBL,
            332 => m680x_insn::M680X_INS_TBNE,
            333 => m680x_insn::M680X_INS_TEST,
            334 => m680x_insn::M680X_INS_TFM,
            335 => m680x_insn::M680X_INS_TFR,
            336 => m680x_insn::M680X_INS_TIM,
            337 => m680x_insn::M680X_INS_TPA,
            338 => m680x_insn::M680X_INS_TST,
            339 => m680x_insn::M680X_INS_TSTA,
            340 => m680x_insn::M680X_INS_TSTB,
            341 => m680x_insn::M680X_INS_TSTD,
            342 => m680x_insn::M680X_INS_TSTE,
            343 => m680x_insn::M680X_INS_TSTF,
            344 => m680x_insn::M680X_INS_TSTW,
            345 => m680x_insn::M680X_INS_TSTX,
            346 => m680x_insn::M680X_INS_TSX,
            347 => m680x_insn::M680X_INS_TSY,
            348 => m680x_insn::M680X_INS_TXA,
            349 => m680x_insn::M680X_INS_TXS,
            350 => m680x_insn::M680X_INS_TYS,
            351 => m680x_insn::M680X_INS_WAI,
            352 => m680x_insn::M680X_INS_WAIT,
            353 => m680x_insn::M680X_INS_WAV,
            354 => m680x_insn::M680X_INS_WAVR,
            355 => m680x_insn::M680X_INS_XGDX,
            356 => m680x_insn::M680X_INS_XGDY,
            357 => m680x_insn::M680X_INS_ENDING,
            _ => m680x_insn::M680X_INS_INVLD,
        }
    }
}
impl From<u32> for m68k_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => m68k_insn::M68K_INS_INVALID,
            1 => m68k_insn::M68K_INS_ABCD,
            2 => m68k_insn::M68K_INS_ADD,
            3 => m68k_insn::M68K_INS_ADDA,
            4 => m68k_insn::M68K_INS_ADDI,
            5 => m68k_insn::M68K_INS_ADDQ,
            6 => m68k_insn::M68K_INS_ADDX,
            7 => m68k_insn::M68K_INS_AND,
            8 => m68k_insn::M68K_INS_ANDI,
            9 => m68k_insn::M68K_INS_ASL,
            10 => m68k_insn::M68K_INS_ASR,
            11 => m68k_insn::M68K_INS_BHS,
            12 => m68k_insn::M68K_INS_BLO,
            13 => m68k_insn::M68K_INS_BHI,
            14 => m68k_insn::M68K_INS_BLS,
            15 => m68k_insn::M68K_INS_BCC,
            16 => m68k_insn::M68K_INS_BCS,
            17 => m68k_insn::M68K_INS_BNE,
            18 => m68k_insn::M68K_INS_BEQ,
            19 => m68k_insn::M68K_INS_BVC,
            20 => m68k_insn::M68K_INS_BVS,
            21 => m68k_insn::M68K_INS_BPL,
            22 => m68k_insn::M68K_INS_BMI,
            23 => m68k_insn::M68K_INS_BGE,
            24 => m68k_insn::M68K_INS_BLT,
            25 => m68k_insn::M68K_INS_BGT,
            26 => m68k_insn::M68K_INS_BLE,
            27 => m68k_insn::M68K_INS_BRA,
            28 => m68k_insn::M68K_INS_BSR,
            29 => m68k_insn::M68K_INS_BCHG,
            30 => m68k_insn::M68K_INS_BCLR,
            31 => m68k_insn::M68K_INS_BSET,
            32 => m68k_insn::M68K_INS_BTST,
            33 => m68k_insn::M68K_INS_BFCHG,
            34 => m68k_insn::M68K_INS_BFCLR,
            35 => m68k_insn::M68K_INS_BFEXTS,
            36 => m68k_insn::M68K_INS_BFEXTU,
            37 => m68k_insn::M68K_INS_BFFFO,
            38 => m68k_insn::M68K_INS_BFINS,
            39 => m68k_insn::M68K_INS_BFSET,
            40 => m68k_insn::M68K_INS_BFTST,
            41 => m68k_insn::M68K_INS_BKPT,
            42 => m68k_insn::M68K_INS_CALLM,
            43 => m68k_insn::M68K_INS_CAS,
            44 => m68k_insn::M68K_INS_CAS2,
            45 => m68k_insn::M68K_INS_CHK,
            46 => m68k_insn::M68K_INS_CHK2,
            47 => m68k_insn::M68K_INS_CLR,
            48 => m68k_insn::M68K_INS_CMP,
            49 => m68k_insn::M68K_INS_CMPA,
            50 => m68k_insn::M68K_INS_CMPI,
            51 => m68k_insn::M68K_INS_CMPM,
            52 => m68k_insn::M68K_INS_CMP2,
            53 => m68k_insn::M68K_INS_CINVL,
            54 => m68k_insn::M68K_INS_CINVP,
            55 => m68k_insn::M68K_INS_CINVA,
            56 => m68k_insn::M68K_INS_CPUSHL,
            57 => m68k_insn::M68K_INS_CPUSHP,
            58 => m68k_insn::M68K_INS_CPUSHA,
            59 => m68k_insn::M68K_INS_DBT,
            60 => m68k_insn::M68K_INS_DBF,
            61 => m68k_insn::M68K_INS_DBHI,
            62 => m68k_insn::M68K_INS_DBLS,
            63 => m68k_insn::M68K_INS_DBCC,
            64 => m68k_insn::M68K_INS_DBCS,
            65 => m68k_insn::M68K_INS_DBNE,
            66 => m68k_insn::M68K_INS_DBEQ,
            67 => m68k_insn::M68K_INS_DBVC,
            68 => m68k_insn::M68K_INS_DBVS,
            69 => m68k_insn::M68K_INS_DBPL,
            70 => m68k_insn::M68K_INS_DBMI,
            71 => m68k_insn::M68K_INS_DBGE,
            72 => m68k_insn::M68K_INS_DBLT,
            73 => m68k_insn::M68K_INS_DBGT,
            74 => m68k_insn::M68K_INS_DBLE,
            75 => m68k_insn::M68K_INS_DBRA,
            76 => m68k_insn::M68K_INS_DIVS,
            77 => m68k_insn::M68K_INS_DIVSL,
            78 => m68k_insn::M68K_INS_DIVU,
            79 => m68k_insn::M68K_INS_DIVUL,
            80 => m68k_insn::M68K_INS_EOR,
            81 => m68k_insn::M68K_INS_EORI,
            82 => m68k_insn::M68K_INS_EXG,
            83 => m68k_insn::M68K_INS_EXT,
            84 => m68k_insn::M68K_INS_EXTB,
            85 => m68k_insn::M68K_INS_FABS,
            86 => m68k_insn::M68K_INS_FSABS,
            87 => m68k_insn::M68K_INS_FDABS,
            88 => m68k_insn::M68K_INS_FACOS,
            89 => m68k_insn::M68K_INS_FADD,
            90 => m68k_insn::M68K_INS_FSADD,
            91 => m68k_insn::M68K_INS_FDADD,
            92 => m68k_insn::M68K_INS_FASIN,
            93 => m68k_insn::M68K_INS_FATAN,
            94 => m68k_insn::M68K_INS_FATANH,
            95 => m68k_insn::M68K_INS_FBF,
            96 => m68k_insn::M68K_INS_FBEQ,
            97 => m68k_insn::M68K_INS_FBOGT,
            98 => m68k_insn::M68K_INS_FBOGE,
            99 => m68k_insn::M68K_INS_FBOLT,
            100 => m68k_insn::M68K_INS_FBOLE,
            101 => m68k_insn::M68K_INS_FBOGL,
            102 => m68k_insn::M68K_INS_FBOR,
            103 => m68k_insn::M68K_INS_FBUN,
            104 => m68k_insn::M68K_INS_FBUEQ,
            105 => m68k_insn::M68K_INS_FBUGT,
            106 => m68k_insn::M68K_INS_FBUGE,
            107 => m68k_insn::M68K_INS_FBULT,
            108 => m68k_insn::M68K_INS_FBULE,
            109 => m68k_insn::M68K_INS_FBNE,
            110 => m68k_insn::M68K_INS_FBT,
            111 => m68k_insn::M68K_INS_FBSF,
            112 => m68k_insn::M68K_INS_FBSEQ,
            113 => m68k_insn::M68K_INS_FBGT,
            114 => m68k_insn::M68K_INS_FBGE,
            115 => m68k_insn::M68K_INS_FBLT,
            116 => m68k_insn::M68K_INS_FBLE,
            117 => m68k_insn::M68K_INS_FBGL,
            118 => m68k_insn::M68K_INS_FBGLE,
            119 => m68k_insn::M68K_INS_FBNGLE,
            120 => m68k_insn::M68K_INS_FBNGL,
            121 => m68k_insn::M68K_INS_FBNLE,
            122 => m68k_insn::M68K_INS_FBNLT,
            123 => m68k_insn::M68K_INS_FBNGE,
            124 => m68k_insn::M68K_INS_FBNGT,
            125 => m68k_insn::M68K_INS_FBSNE,
            126 => m68k_insn::M68K_INS_FBST,
            127 => m68k_insn::M68K_INS_FCMP,
            128 => m68k_insn::M68K_INS_FCOS,
            129 => m68k_insn::M68K_INS_FCOSH,
            130 => m68k_insn::M68K_INS_FDBF,
            131 => m68k_insn::M68K_INS_FDBEQ,
            132 => m68k_insn::M68K_INS_FDBOGT,
            133 => m68k_insn::M68K_INS_FDBOGE,
            134 => m68k_insn::M68K_INS_FDBOLT,
            135 => m68k_insn::M68K_INS_FDBOLE,
            136 => m68k_insn::M68K_INS_FDBOGL,
            137 => m68k_insn::M68K_INS_FDBOR,
            138 => m68k_insn::M68K_INS_FDBUN,
            139 => m68k_insn::M68K_INS_FDBUEQ,
            140 => m68k_insn::M68K_INS_FDBUGT,
            141 => m68k_insn::M68K_INS_FDBUGE,
            142 => m68k_insn::M68K_INS_FDBULT,
            143 => m68k_insn::M68K_INS_FDBULE,
            144 => m68k_insn::M68K_INS_FDBNE,
            145 => m68k_insn::M68K_INS_FDBT,
            146 => m68k_insn::M68K_INS_FDBSF,
            147 => m68k_insn::M68K_INS_FDBSEQ,
            148 => m68k_insn::M68K_INS_FDBGT,
            149 => m68k_insn::M68K_INS_FDBGE,
            150 => m68k_insn::M68K_INS_FDBLT,
            151 => m68k_insn::M68K_INS_FDBLE,
            152 => m68k_insn::M68K_INS_FDBGL,
            153 => m68k_insn::M68K_INS_FDBGLE,
            154 => m68k_insn::M68K_INS_FDBNGLE,
            155 => m68k_insn::M68K_INS_FDBNGL,
            156 => m68k_insn::M68K_INS_FDBNLE,
            157 => m68k_insn::M68K_INS_FDBNLT,
            158 => m68k_insn::M68K_INS_FDBNGE,
            159 => m68k_insn::M68K_INS_FDBNGT,
            160 => m68k_insn::M68K_INS_FDBSNE,
            161 => m68k_insn::M68K_INS_FDBST,
            162 => m68k_insn::M68K_INS_FDIV,
            163 => m68k_insn::M68K_INS_FSDIV,
            164 => m68k_insn::M68K_INS_FDDIV,
            165 => m68k_insn::M68K_INS_FETOX,
            166 => m68k_insn::M68K_INS_FETOXM1,
            167 => m68k_insn::M68K_INS_FGETEXP,
            168 => m68k_insn::M68K_INS_FGETMAN,
            169 => m68k_insn::M68K_INS_FINT,
            170 => m68k_insn::M68K_INS_FINTRZ,
            171 => m68k_insn::M68K_INS_FLOG10,
            172 => m68k_insn::M68K_INS_FLOG2,
            173 => m68k_insn::M68K_INS_FLOGN,
            174 => m68k_insn::M68K_INS_FLOGNP1,
            175 => m68k_insn::M68K_INS_FMOD,
            176 => m68k_insn::M68K_INS_FMOVE,
            177 => m68k_insn::M68K_INS_FSMOVE,
            178 => m68k_insn::M68K_INS_FDMOVE,
            179 => m68k_insn::M68K_INS_FMOVECR,
            180 => m68k_insn::M68K_INS_FMOVEM,
            181 => m68k_insn::M68K_INS_FMUL,
            182 => m68k_insn::M68K_INS_FSMUL,
            183 => m68k_insn::M68K_INS_FDMUL,
            184 => m68k_insn::M68K_INS_FNEG,
            185 => m68k_insn::M68K_INS_FSNEG,
            186 => m68k_insn::M68K_INS_FDNEG,
            187 => m68k_insn::M68K_INS_FNOP,
            188 => m68k_insn::M68K_INS_FREM,
            189 => m68k_insn::M68K_INS_FRESTORE,
            190 => m68k_insn::M68K_INS_FSAVE,
            191 => m68k_insn::M68K_INS_FSCALE,
            192 => m68k_insn::M68K_INS_FSGLDIV,
            193 => m68k_insn::M68K_INS_FSGLMUL,
            194 => m68k_insn::M68K_INS_FSIN,
            195 => m68k_insn::M68K_INS_FSINCOS,
            196 => m68k_insn::M68K_INS_FSINH,
            197 => m68k_insn::M68K_INS_FSQRT,
            198 => m68k_insn::M68K_INS_FSSQRT,
            199 => m68k_insn::M68K_INS_FDSQRT,
            200 => m68k_insn::M68K_INS_FSF,
            201 => m68k_insn::M68K_INS_FSBEQ,
            202 => m68k_insn::M68K_INS_FSOGT,
            203 => m68k_insn::M68K_INS_FSOGE,
            204 => m68k_insn::M68K_INS_FSOLT,
            205 => m68k_insn::M68K_INS_FSOLE,
            206 => m68k_insn::M68K_INS_FSOGL,
            207 => m68k_insn::M68K_INS_FSOR,
            208 => m68k_insn::M68K_INS_FSUN,
            209 => m68k_insn::M68K_INS_FSUEQ,
            210 => m68k_insn::M68K_INS_FSUGT,
            211 => m68k_insn::M68K_INS_FSUGE,
            212 => m68k_insn::M68K_INS_FSULT,
            213 => m68k_insn::M68K_INS_FSULE,
            214 => m68k_insn::M68K_INS_FSNE,
            215 => m68k_insn::M68K_INS_FST,
            216 => m68k_insn::M68K_INS_FSSF,
            217 => m68k_insn::M68K_INS_FSSEQ,
            218 => m68k_insn::M68K_INS_FSGT,
            219 => m68k_insn::M68K_INS_FSGE,
            220 => m68k_insn::M68K_INS_FSLT,
            221 => m68k_insn::M68K_INS_FSLE,
            222 => m68k_insn::M68K_INS_FSGL,
            223 => m68k_insn::M68K_INS_FSGLE,
            224 => m68k_insn::M68K_INS_FSNGLE,
            225 => m68k_insn::M68K_INS_FSNGL,
            226 => m68k_insn::M68K_INS_FSNLE,
            227 => m68k_insn::M68K_INS_FSNLT,
            228 => m68k_insn::M68K_INS_FSNGE,
            229 => m68k_insn::M68K_INS_FSNGT,
            230 => m68k_insn::M68K_INS_FSSNE,
            231 => m68k_insn::M68K_INS_FSST,
            232 => m68k_insn::M68K_INS_FSUB,
            233 => m68k_insn::M68K_INS_FSSUB,
            234 => m68k_insn::M68K_INS_FDSUB,
            235 => m68k_insn::M68K_INS_FTAN,
            236 => m68k_insn::M68K_INS_FTANH,
            237 => m68k_insn::M68K_INS_FTENTOX,
            238 => m68k_insn::M68K_INS_FTRAPF,
            239 => m68k_insn::M68K_INS_FTRAPEQ,
            240 => m68k_insn::M68K_INS_FTRAPOGT,
            241 => m68k_insn::M68K_INS_FTRAPOGE,
            242 => m68k_insn::M68K_INS_FTRAPOLT,
            243 => m68k_insn::M68K_INS_FTRAPOLE,
            244 => m68k_insn::M68K_INS_FTRAPOGL,
            245 => m68k_insn::M68K_INS_FTRAPOR,
            246 => m68k_insn::M68K_INS_FTRAPUN,
            247 => m68k_insn::M68K_INS_FTRAPUEQ,
            248 => m68k_insn::M68K_INS_FTRAPUGT,
            249 => m68k_insn::M68K_INS_FTRAPUGE,
            250 => m68k_insn::M68K_INS_FTRAPULT,
            251 => m68k_insn::M68K_INS_FTRAPULE,
            252 => m68k_insn::M68K_INS_FTRAPNE,
            253 => m68k_insn::M68K_INS_FTRAPT,
            254 => m68k_insn::M68K_INS_FTRAPSF,
            255 => m68k_insn::M68K_INS_FTRAPSEQ,
            256 => m68k_insn::M68K_INS_FTRAPGT,
            257 => m68k_insn::M68K_INS_FTRAPGE,
            258 => m68k_insn::M68K_INS_FTRAPLT,
            259 => m68k_insn::M68K_INS_FTRAPLE,
            260 => m68k_insn::M68K_INS_FTRAPGL,
            261 => m68k_insn::M68K_INS_FTRAPGLE,
            262 => m68k_insn::M68K_INS_FTRAPNGLE,
            263 => m68k_insn::M68K_INS_FTRAPNGL,
            264 => m68k_insn::M68K_INS_FTRAPNLE,
            265 => m68k_insn::M68K_INS_FTRAPNLT,
            266 => m68k_insn::M68K_INS_FTRAPNGE,
            267 => m68k_insn::M68K_INS_FTRAPNGT,
            268 => m68k_insn::M68K_INS_FTRAPSNE,
            269 => m68k_insn::M68K_INS_FTRAPST,
            270 => m68k_insn::M68K_INS_FTST,
            271 => m68k_insn::M68K_INS_FTWOTOX,
            272 => m68k_insn::M68K_INS_HALT,
            273 => m68k_insn::M68K_INS_ILLEGAL,
            274 => m68k_insn::M68K_INS_JMP,
            275 => m68k_insn::M68K_INS_JSR,
            276 => m68k_insn::M68K_INS_LEA,
            277 => m68k_insn::M68K_INS_LINK,
            278 => m68k_insn::M68K_INS_LPSTOP,
            279 => m68k_insn::M68K_INS_LSL,
            280 => m68k_insn::M68K_INS_LSR,
            281 => m68k_insn::M68K_INS_MOVE,
            282 => m68k_insn::M68K_INS_MOVEA,
            283 => m68k_insn::M68K_INS_MOVEC,
            284 => m68k_insn::M68K_INS_MOVEM,
            285 => m68k_insn::M68K_INS_MOVEP,
            286 => m68k_insn::M68K_INS_MOVEQ,
            287 => m68k_insn::M68K_INS_MOVES,
            288 => m68k_insn::M68K_INS_MOVE16,
            289 => m68k_insn::M68K_INS_MULS,
            290 => m68k_insn::M68K_INS_MULU,
            291 => m68k_insn::M68K_INS_NBCD,
            292 => m68k_insn::M68K_INS_NEG,
            293 => m68k_insn::M68K_INS_NEGX,
            294 => m68k_insn::M68K_INS_NOP,
            295 => m68k_insn::M68K_INS_NOT,
            296 => m68k_insn::M68K_INS_OR,
            297 => m68k_insn::M68K_INS_ORI,
            298 => m68k_insn::M68K_INS_PACK,
            299 => m68k_insn::M68K_INS_PEA,
            300 => m68k_insn::M68K_INS_PFLUSH,
            301 => m68k_insn::M68K_INS_PFLUSHA,
            302 => m68k_insn::M68K_INS_PFLUSHAN,
            303 => m68k_insn::M68K_INS_PFLUSHN,
            304 => m68k_insn::M68K_INS_PLOADR,
            305 => m68k_insn::M68K_INS_PLOADW,
            306 => m68k_insn::M68K_INS_PLPAR,
            307 => m68k_insn::M68K_INS_PLPAW,
            308 => m68k_insn::M68K_INS_PMOVE,
            309 => m68k_insn::M68K_INS_PMOVEFD,
            310 => m68k_insn::M68K_INS_PTESTR,
            311 => m68k_insn::M68K_INS_PTESTW,
            312 => m68k_insn::M68K_INS_PULSE,
            313 => m68k_insn::M68K_INS_REMS,
            314 => m68k_insn::M68K_INS_REMU,
            315 => m68k_insn::M68K_INS_RESET,
            316 => m68k_insn::M68K_INS_ROL,
            317 => m68k_insn::M68K_INS_ROR,
            318 => m68k_insn::M68K_INS_ROXL,
            319 => m68k_insn::M68K_INS_ROXR,
            320 => m68k_insn::M68K_INS_RTD,
            321 => m68k_insn::M68K_INS_RTE,
            322 => m68k_insn::M68K_INS_RTM,
            323 => m68k_insn::M68K_INS_RTR,
            324 => m68k_insn::M68K_INS_RTS,
            325 => m68k_insn::M68K_INS_SBCD,
            326 => m68k_insn::M68K_INS_ST,
            327 => m68k_insn::M68K_INS_SF,
            328 => m68k_insn::M68K_INS_SHI,
            329 => m68k_insn::M68K_INS_SLS,
            330 => m68k_insn::M68K_INS_SCC,
            331 => m68k_insn::M68K_INS_SHS,
            332 => m68k_insn::M68K_INS_SCS,
            333 => m68k_insn::M68K_INS_SLO,
            334 => m68k_insn::M68K_INS_SNE,
            335 => m68k_insn::M68K_INS_SEQ,
            336 => m68k_insn::M68K_INS_SVC,
            337 => m68k_insn::M68K_INS_SVS,
            338 => m68k_insn::M68K_INS_SPL,
            339 => m68k_insn::M68K_INS_SMI,
            340 => m68k_insn::M68K_INS_SGE,
            341 => m68k_insn::M68K_INS_SLT,
            342 => m68k_insn::M68K_INS_SGT,
            343 => m68k_insn::M68K_INS_SLE,
            344 => m68k_insn::M68K_INS_STOP,
            345 => m68k_insn::M68K_INS_SUB,
            346 => m68k_insn::M68K_INS_SUBA,
            347 => m68k_insn::M68K_INS_SUBI,
            348 => m68k_insn::M68K_INS_SUBQ,
            349 => m68k_insn::M68K_INS_SUBX,
            350 => m68k_insn::M68K_INS_SWAP,
            351 => m68k_insn::M68K_INS_TAS,
            352 => m68k_insn::M68K_INS_TRAP,
            353 => m68k_insn::M68K_INS_TRAPV,
            354 => m68k_insn::M68K_INS_TRAPT,
            355 => m68k_insn::M68K_INS_TRAPF,
            356 => m68k_insn::M68K_INS_TRAPHI,
            357 => m68k_insn::M68K_INS_TRAPLS,
            358 => m68k_insn::M68K_INS_TRAPCC,
            359 => m68k_insn::M68K_INS_TRAPHS,
            360 => m68k_insn::M68K_INS_TRAPCS,
            361 => m68k_insn::M68K_INS_TRAPLO,
            362 => m68k_insn::M68K_INS_TRAPNE,
            363 => m68k_insn::M68K_INS_TRAPEQ,
            364 => m68k_insn::M68K_INS_TRAPVC,
            365 => m68k_insn::M68K_INS_TRAPVS,
            366 => m68k_insn::M68K_INS_TRAPPL,
            367 => m68k_insn::M68K_INS_TRAPMI,
            368 => m68k_insn::M68K_INS_TRAPGE,
            369 => m68k_insn::M68K_INS_TRAPLT,
            370 => m68k_insn::M68K_INS_TRAPGT,
            371 => m68k_insn::M68K_INS_TRAPLE,
            372 => m68k_insn::M68K_INS_TST,
            373 => m68k_insn::M68K_INS_UNLK,
            374 => m68k_insn::M68K_INS_UNPK,
            375 => m68k_insn::M68K_INS_ENDING,
            _ => m68k_insn::M68K_INS_INVALID,
        }
    }
}
impl From<u32> for mips_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => mips_insn::MIPS_INS_INVALID,
            1 => mips_insn::MIPS_INS_ABSQ_S,
            2 => mips_insn::MIPS_INS_ADD,
            3 => mips_insn::MIPS_INS_ADDIUPC,
            4 => mips_insn::MIPS_INS_ADDIUR1SP,
            5 => mips_insn::MIPS_INS_ADDIUR2,
            6 => mips_insn::MIPS_INS_ADDIUS5,
            7 => mips_insn::MIPS_INS_ADDIUSP,
            8 => mips_insn::MIPS_INS_ADDQH,
            9 => mips_insn::MIPS_INS_ADDQH_R,
            10 => mips_insn::MIPS_INS_ADDQ,
            11 => mips_insn::MIPS_INS_ADDQ_S,
            12 => mips_insn::MIPS_INS_ADDSC,
            13 => mips_insn::MIPS_INS_ADDS_A,
            14 => mips_insn::MIPS_INS_ADDS_S,
            15 => mips_insn::MIPS_INS_ADDS_U,
            16 => mips_insn::MIPS_INS_ADDU16,
            17 => mips_insn::MIPS_INS_ADDUH,
            18 => mips_insn::MIPS_INS_ADDUH_R,
            19 => mips_insn::MIPS_INS_ADDU,
            20 => mips_insn::MIPS_INS_ADDU_S,
            21 => mips_insn::MIPS_INS_ADDVI,
            22 => mips_insn::MIPS_INS_ADDV,
            23 => mips_insn::MIPS_INS_ADDWC,
            24 => mips_insn::MIPS_INS_ADD_A,
            25 => mips_insn::MIPS_INS_ADDI,
            26 => mips_insn::MIPS_INS_ADDIU,
            27 => mips_insn::MIPS_INS_ALIGN,
            28 => mips_insn::MIPS_INS_ALUIPC,
            29 => mips_insn::MIPS_INS_AND,
            30 => mips_insn::MIPS_INS_AND16,
            31 => mips_insn::MIPS_INS_ANDI16,
            32 => mips_insn::MIPS_INS_ANDI,
            33 => mips_insn::MIPS_INS_APPEND,
            34 => mips_insn::MIPS_INS_ASUB_S,
            35 => mips_insn::MIPS_INS_ASUB_U,
            36 => mips_insn::MIPS_INS_AUI,
            37 => mips_insn::MIPS_INS_AUIPC,
            38 => mips_insn::MIPS_INS_AVER_S,
            39 => mips_insn::MIPS_INS_AVER_U,
            40 => mips_insn::MIPS_INS_AVE_S,
            41 => mips_insn::MIPS_INS_AVE_U,
            42 => mips_insn::MIPS_INS_B16,
            43 => mips_insn::MIPS_INS_BADDU,
            44 => mips_insn::MIPS_INS_BAL,
            45 => mips_insn::MIPS_INS_BALC,
            46 => mips_insn::MIPS_INS_BALIGN,
            47 => mips_insn::MIPS_INS_BBIT0,
            48 => mips_insn::MIPS_INS_BBIT032,
            49 => mips_insn::MIPS_INS_BBIT1,
            50 => mips_insn::MIPS_INS_BBIT132,
            51 => mips_insn::MIPS_INS_BC,
            52 => mips_insn::MIPS_INS_BC0F,
            53 => mips_insn::MIPS_INS_BC0FL,
            54 => mips_insn::MIPS_INS_BC0T,
            55 => mips_insn::MIPS_INS_BC0TL,
            56 => mips_insn::MIPS_INS_BC1EQZ,
            57 => mips_insn::MIPS_INS_BC1F,
            58 => mips_insn::MIPS_INS_BC1FL,
            59 => mips_insn::MIPS_INS_BC1NEZ,
            60 => mips_insn::MIPS_INS_BC1T,
            61 => mips_insn::MIPS_INS_BC1TL,
            62 => mips_insn::MIPS_INS_BC2EQZ,
            63 => mips_insn::MIPS_INS_BC2F,
            64 => mips_insn::MIPS_INS_BC2FL,
            65 => mips_insn::MIPS_INS_BC2NEZ,
            66 => mips_insn::MIPS_INS_BC2T,
            67 => mips_insn::MIPS_INS_BC2TL,
            68 => mips_insn::MIPS_INS_BC3F,
            69 => mips_insn::MIPS_INS_BC3FL,
            70 => mips_insn::MIPS_INS_BC3T,
            71 => mips_insn::MIPS_INS_BC3TL,
            72 => mips_insn::MIPS_INS_BCLRI,
            73 => mips_insn::MIPS_INS_BCLR,
            74 => mips_insn::MIPS_INS_BEQ,
            75 => mips_insn::MIPS_INS_BEQC,
            76 => mips_insn::MIPS_INS_BEQL,
            77 => mips_insn::MIPS_INS_BEQZ16,
            78 => mips_insn::MIPS_INS_BEQZALC,
            79 => mips_insn::MIPS_INS_BEQZC,
            80 => mips_insn::MIPS_INS_BGEC,
            81 => mips_insn::MIPS_INS_BGEUC,
            82 => mips_insn::MIPS_INS_BGEZ,
            83 => mips_insn::MIPS_INS_BGEZAL,
            84 => mips_insn::MIPS_INS_BGEZALC,
            85 => mips_insn::MIPS_INS_BGEZALL,
            86 => mips_insn::MIPS_INS_BGEZALS,
            87 => mips_insn::MIPS_INS_BGEZC,
            88 => mips_insn::MIPS_INS_BGEZL,
            89 => mips_insn::MIPS_INS_BGTZ,
            90 => mips_insn::MIPS_INS_BGTZALC,
            91 => mips_insn::MIPS_INS_BGTZC,
            92 => mips_insn::MIPS_INS_BGTZL,
            93 => mips_insn::MIPS_INS_BINSLI,
            94 => mips_insn::MIPS_INS_BINSL,
            95 => mips_insn::MIPS_INS_BINSRI,
            96 => mips_insn::MIPS_INS_BINSR,
            97 => mips_insn::MIPS_INS_BITREV,
            98 => mips_insn::MIPS_INS_BITSWAP,
            99 => mips_insn::MIPS_INS_BLEZ,
            100 => mips_insn::MIPS_INS_BLEZALC,
            101 => mips_insn::MIPS_INS_BLEZC,
            102 => mips_insn::MIPS_INS_BLEZL,
            103 => mips_insn::MIPS_INS_BLTC,
            104 => mips_insn::MIPS_INS_BLTUC,
            105 => mips_insn::MIPS_INS_BLTZ,
            106 => mips_insn::MIPS_INS_BLTZAL,
            107 => mips_insn::MIPS_INS_BLTZALC,
            108 => mips_insn::MIPS_INS_BLTZALL,
            109 => mips_insn::MIPS_INS_BLTZALS,
            110 => mips_insn::MIPS_INS_BLTZC,
            111 => mips_insn::MIPS_INS_BLTZL,
            112 => mips_insn::MIPS_INS_BMNZI,
            113 => mips_insn::MIPS_INS_BMNZ,
            114 => mips_insn::MIPS_INS_BMZI,
            115 => mips_insn::MIPS_INS_BMZ,
            116 => mips_insn::MIPS_INS_BNE,
            117 => mips_insn::MIPS_INS_BNEC,
            118 => mips_insn::MIPS_INS_BNEGI,
            119 => mips_insn::MIPS_INS_BNEG,
            120 => mips_insn::MIPS_INS_BNEL,
            121 => mips_insn::MIPS_INS_BNEZ16,
            122 => mips_insn::MIPS_INS_BNEZALC,
            123 => mips_insn::MIPS_INS_BNEZC,
            124 => mips_insn::MIPS_INS_BNVC,
            125 => mips_insn::MIPS_INS_BNZ,
            126 => mips_insn::MIPS_INS_BOVC,
            127 => mips_insn::MIPS_INS_BPOSGE32,
            128 => mips_insn::MIPS_INS_BREAK,
            129 => mips_insn::MIPS_INS_BREAK16,
            130 => mips_insn::MIPS_INS_BSELI,
            131 => mips_insn::MIPS_INS_BSEL,
            132 => mips_insn::MIPS_INS_BSETI,
            133 => mips_insn::MIPS_INS_BSET,
            134 => mips_insn::MIPS_INS_BZ,
            135 => mips_insn::MIPS_INS_BEQZ,
            136 => mips_insn::MIPS_INS_B,
            137 => mips_insn::MIPS_INS_BNEZ,
            138 => mips_insn::MIPS_INS_BTEQZ,
            139 => mips_insn::MIPS_INS_BTNEZ,
            140 => mips_insn::MIPS_INS_CACHE,
            141 => mips_insn::MIPS_INS_CEIL,
            142 => mips_insn::MIPS_INS_CEQI,
            143 => mips_insn::MIPS_INS_CEQ,
            144 => mips_insn::MIPS_INS_CFC1,
            145 => mips_insn::MIPS_INS_CFCMSA,
            146 => mips_insn::MIPS_INS_CINS,
            147 => mips_insn::MIPS_INS_CINS32,
            148 => mips_insn::MIPS_INS_CLASS,
            149 => mips_insn::MIPS_INS_CLEI_S,
            150 => mips_insn::MIPS_INS_CLEI_U,
            151 => mips_insn::MIPS_INS_CLE_S,
            152 => mips_insn::MIPS_INS_CLE_U,
            153 => mips_insn::MIPS_INS_CLO,
            154 => mips_insn::MIPS_INS_CLTI_S,
            155 => mips_insn::MIPS_INS_CLTI_U,
            156 => mips_insn::MIPS_INS_CLT_S,
            157 => mips_insn::MIPS_INS_CLT_U,
            158 => mips_insn::MIPS_INS_CLZ,
            159 => mips_insn::MIPS_INS_CMPGDU,
            160 => mips_insn::MIPS_INS_CMPGU,
            161 => mips_insn::MIPS_INS_CMPU,
            162 => mips_insn::MIPS_INS_CMP,
            163 => mips_insn::MIPS_INS_COPY_S,
            164 => mips_insn::MIPS_INS_COPY_U,
            165 => mips_insn::MIPS_INS_CTC1,
            166 => mips_insn::MIPS_INS_CTCMSA,
            167 => mips_insn::MIPS_INS_CVT,
            168 => mips_insn::MIPS_INS_C,
            169 => mips_insn::MIPS_INS_CMPI,
            170 => mips_insn::MIPS_INS_DADD,
            171 => mips_insn::MIPS_INS_DADDI,
            172 => mips_insn::MIPS_INS_DADDIU,
            173 => mips_insn::MIPS_INS_DADDU,
            174 => mips_insn::MIPS_INS_DAHI,
            175 => mips_insn::MIPS_INS_DALIGN,
            176 => mips_insn::MIPS_INS_DATI,
            177 => mips_insn::MIPS_INS_DAUI,
            178 => mips_insn::MIPS_INS_DBITSWAP,
            179 => mips_insn::MIPS_INS_DCLO,
            180 => mips_insn::MIPS_INS_DCLZ,
            181 => mips_insn::MIPS_INS_DDIV,
            182 => mips_insn::MIPS_INS_DDIVU,
            183 => mips_insn::MIPS_INS_DERET,
            184 => mips_insn::MIPS_INS_DEXT,
            185 => mips_insn::MIPS_INS_DEXTM,
            186 => mips_insn::MIPS_INS_DEXTU,
            187 => mips_insn::MIPS_INS_DI,
            188 => mips_insn::MIPS_INS_DINS,
            189 => mips_insn::MIPS_INS_DINSM,
            190 => mips_insn::MIPS_INS_DINSU,
            191 => mips_insn::MIPS_INS_DIV,
            192 => mips_insn::MIPS_INS_DIVU,
            193 => mips_insn::MIPS_INS_DIV_S,
            194 => mips_insn::MIPS_INS_DIV_U,
            195 => mips_insn::MIPS_INS_DLSA,
            196 => mips_insn::MIPS_INS_DMFC0,
            197 => mips_insn::MIPS_INS_DMFC1,
            198 => mips_insn::MIPS_INS_DMFC2,
            199 => mips_insn::MIPS_INS_DMOD,
            200 => mips_insn::MIPS_INS_DMODU,
            201 => mips_insn::MIPS_INS_DMTC0,
            202 => mips_insn::MIPS_INS_DMTC1,
            203 => mips_insn::MIPS_INS_DMTC2,
            204 => mips_insn::MIPS_INS_DMUH,
            205 => mips_insn::MIPS_INS_DMUHU,
            206 => mips_insn::MIPS_INS_DMUL,
            207 => mips_insn::MIPS_INS_DMULT,
            208 => mips_insn::MIPS_INS_DMULTU,
            209 => mips_insn::MIPS_INS_DMULU,
            210 => mips_insn::MIPS_INS_DOTP_S,
            211 => mips_insn::MIPS_INS_DOTP_U,
            212 => mips_insn::MIPS_INS_DPADD_S,
            213 => mips_insn::MIPS_INS_DPADD_U,
            214 => mips_insn::MIPS_INS_DPAQX_SA,
            215 => mips_insn::MIPS_INS_DPAQX_S,
            216 => mips_insn::MIPS_INS_DPAQ_SA,
            217 => mips_insn::MIPS_INS_DPAQ_S,
            218 => mips_insn::MIPS_INS_DPAU,
            219 => mips_insn::MIPS_INS_DPAX,
            220 => mips_insn::MIPS_INS_DPA,
            221 => mips_insn::MIPS_INS_DPOP,
            222 => mips_insn::MIPS_INS_DPSQX_SA,
            223 => mips_insn::MIPS_INS_DPSQX_S,
            224 => mips_insn::MIPS_INS_DPSQ_SA,
            225 => mips_insn::MIPS_INS_DPSQ_S,
            226 => mips_insn::MIPS_INS_DPSUB_S,
            227 => mips_insn::MIPS_INS_DPSUB_U,
            228 => mips_insn::MIPS_INS_DPSU,
            229 => mips_insn::MIPS_INS_DPSX,
            230 => mips_insn::MIPS_INS_DPS,
            231 => mips_insn::MIPS_INS_DROTR,
            232 => mips_insn::MIPS_INS_DROTR32,
            233 => mips_insn::MIPS_INS_DROTRV,
            234 => mips_insn::MIPS_INS_DSBH,
            235 => mips_insn::MIPS_INS_DSHD,
            236 => mips_insn::MIPS_INS_DSLL,
            237 => mips_insn::MIPS_INS_DSLL32,
            238 => mips_insn::MIPS_INS_DSLLV,
            239 => mips_insn::MIPS_INS_DSRA,
            240 => mips_insn::MIPS_INS_DSRA32,
            241 => mips_insn::MIPS_INS_DSRAV,
            242 => mips_insn::MIPS_INS_DSRL,
            243 => mips_insn::MIPS_INS_DSRL32,
            244 => mips_insn::MIPS_INS_DSRLV,
            245 => mips_insn::MIPS_INS_DSUB,
            246 => mips_insn::MIPS_INS_DSUBU,
            247 => mips_insn::MIPS_INS_EHB,
            248 => mips_insn::MIPS_INS_EI,
            249 => mips_insn::MIPS_INS_ERET,
            250 => mips_insn::MIPS_INS_EXT,
            251 => mips_insn::MIPS_INS_EXTP,
            252 => mips_insn::MIPS_INS_EXTPDP,
            253 => mips_insn::MIPS_INS_EXTPDPV,
            254 => mips_insn::MIPS_INS_EXTPV,
            255 => mips_insn::MIPS_INS_EXTRV_RS,
            256 => mips_insn::MIPS_INS_EXTRV_R,
            257 => mips_insn::MIPS_INS_EXTRV_S,
            258 => mips_insn::MIPS_INS_EXTRV,
            259 => mips_insn::MIPS_INS_EXTR_RS,
            260 => mips_insn::MIPS_INS_EXTR_R,
            261 => mips_insn::MIPS_INS_EXTR_S,
            262 => mips_insn::MIPS_INS_EXTR,
            263 => mips_insn::MIPS_INS_EXTS,
            264 => mips_insn::MIPS_INS_EXTS32,
            265 => mips_insn::MIPS_INS_ABS,
            266 => mips_insn::MIPS_INS_FADD,
            267 => mips_insn::MIPS_INS_FCAF,
            268 => mips_insn::MIPS_INS_FCEQ,
            269 => mips_insn::MIPS_INS_FCLASS,
            270 => mips_insn::MIPS_INS_FCLE,
            271 => mips_insn::MIPS_INS_FCLT,
            272 => mips_insn::MIPS_INS_FCNE,
            273 => mips_insn::MIPS_INS_FCOR,
            274 => mips_insn::MIPS_INS_FCUEQ,
            275 => mips_insn::MIPS_INS_FCULE,
            276 => mips_insn::MIPS_INS_FCULT,
            277 => mips_insn::MIPS_INS_FCUNE,
            278 => mips_insn::MIPS_INS_FCUN,
            279 => mips_insn::MIPS_INS_FDIV,
            280 => mips_insn::MIPS_INS_FEXDO,
            281 => mips_insn::MIPS_INS_FEXP2,
            282 => mips_insn::MIPS_INS_FEXUPL,
            283 => mips_insn::MIPS_INS_FEXUPR,
            284 => mips_insn::MIPS_INS_FFINT_S,
            285 => mips_insn::MIPS_INS_FFINT_U,
            286 => mips_insn::MIPS_INS_FFQL,
            287 => mips_insn::MIPS_INS_FFQR,
            288 => mips_insn::MIPS_INS_FILL,
            289 => mips_insn::MIPS_INS_FLOG2,
            290 => mips_insn::MIPS_INS_FLOOR,
            291 => mips_insn::MIPS_INS_FMADD,
            292 => mips_insn::MIPS_INS_FMAX_A,
            293 => mips_insn::MIPS_INS_FMAX,
            294 => mips_insn::MIPS_INS_FMIN_A,
            295 => mips_insn::MIPS_INS_FMIN,
            296 => mips_insn::MIPS_INS_MOV,
            297 => mips_insn::MIPS_INS_FMSUB,
            298 => mips_insn::MIPS_INS_FMUL,
            299 => mips_insn::MIPS_INS_MUL,
            300 => mips_insn::MIPS_INS_NEG,
            301 => mips_insn::MIPS_INS_FRCP,
            302 => mips_insn::MIPS_INS_FRINT,
            303 => mips_insn::MIPS_INS_FRSQRT,
            304 => mips_insn::MIPS_INS_FSAF,
            305 => mips_insn::MIPS_INS_FSEQ,
            306 => mips_insn::MIPS_INS_FSLE,
            307 => mips_insn::MIPS_INS_FSLT,
            308 => mips_insn::MIPS_INS_FSNE,
            309 => mips_insn::MIPS_INS_FSOR,
            310 => mips_insn::MIPS_INS_FSQRT,
            311 => mips_insn::MIPS_INS_SQRT,
            312 => mips_insn::MIPS_INS_FSUB,
            313 => mips_insn::MIPS_INS_SUB,
            314 => mips_insn::MIPS_INS_FSUEQ,
            315 => mips_insn::MIPS_INS_FSULE,
            316 => mips_insn::MIPS_INS_FSULT,
            317 => mips_insn::MIPS_INS_FSUNE,
            318 => mips_insn::MIPS_INS_FSUN,
            319 => mips_insn::MIPS_INS_FTINT_S,
            320 => mips_insn::MIPS_INS_FTINT_U,
            321 => mips_insn::MIPS_INS_FTQ,
            322 => mips_insn::MIPS_INS_FTRUNC_S,
            323 => mips_insn::MIPS_INS_FTRUNC_U,
            324 => mips_insn::MIPS_INS_HADD_S,
            325 => mips_insn::MIPS_INS_HADD_U,
            326 => mips_insn::MIPS_INS_HSUB_S,
            327 => mips_insn::MIPS_INS_HSUB_U,
            328 => mips_insn::MIPS_INS_ILVEV,
            329 => mips_insn::MIPS_INS_ILVL,
            330 => mips_insn::MIPS_INS_ILVOD,
            331 => mips_insn::MIPS_INS_ILVR,
            332 => mips_insn::MIPS_INS_INS,
            333 => mips_insn::MIPS_INS_INSERT,
            334 => mips_insn::MIPS_INS_INSV,
            335 => mips_insn::MIPS_INS_INSVE,
            336 => mips_insn::MIPS_INS_J,
            337 => mips_insn::MIPS_INS_JAL,
            338 => mips_insn::MIPS_INS_JALR,
            339 => mips_insn::MIPS_INS_JALRS16,
            340 => mips_insn::MIPS_INS_JALRS,
            341 => mips_insn::MIPS_INS_JALS,
            342 => mips_insn::MIPS_INS_JALX,
            343 => mips_insn::MIPS_INS_JIALC,
            344 => mips_insn::MIPS_INS_JIC,
            345 => mips_insn::MIPS_INS_JR,
            346 => mips_insn::MIPS_INS_JR16,
            347 => mips_insn::MIPS_INS_JRADDIUSP,
            348 => mips_insn::MIPS_INS_JRC,
            349 => mips_insn::MIPS_INS_JALRC,
            350 => mips_insn::MIPS_INS_LB,
            351 => mips_insn::MIPS_INS_LBU16,
            352 => mips_insn::MIPS_INS_LBUX,
            353 => mips_insn::MIPS_INS_LBU,
            354 => mips_insn::MIPS_INS_LD,
            355 => mips_insn::MIPS_INS_LDC1,
            356 => mips_insn::MIPS_INS_LDC2,
            357 => mips_insn::MIPS_INS_LDC3,
            358 => mips_insn::MIPS_INS_LDI,
            359 => mips_insn::MIPS_INS_LDL,
            360 => mips_insn::MIPS_INS_LDPC,
            361 => mips_insn::MIPS_INS_LDR,
            362 => mips_insn::MIPS_INS_LDXC1,
            363 => mips_insn::MIPS_INS_LH,
            364 => mips_insn::MIPS_INS_LHU16,
            365 => mips_insn::MIPS_INS_LHX,
            366 => mips_insn::MIPS_INS_LHU,
            367 => mips_insn::MIPS_INS_LI16,
            368 => mips_insn::MIPS_INS_LL,
            369 => mips_insn::MIPS_INS_LLD,
            370 => mips_insn::MIPS_INS_LSA,
            371 => mips_insn::MIPS_INS_LUXC1,
            372 => mips_insn::MIPS_INS_LUI,
            373 => mips_insn::MIPS_INS_LW,
            374 => mips_insn::MIPS_INS_LW16,
            375 => mips_insn::MIPS_INS_LWC1,
            376 => mips_insn::MIPS_INS_LWC2,
            377 => mips_insn::MIPS_INS_LWC3,
            378 => mips_insn::MIPS_INS_LWL,
            379 => mips_insn::MIPS_INS_LWM16,
            380 => mips_insn::MIPS_INS_LWM32,
            381 => mips_insn::MIPS_INS_LWPC,
            382 => mips_insn::MIPS_INS_LWP,
            383 => mips_insn::MIPS_INS_LWR,
            384 => mips_insn::MIPS_INS_LWUPC,
            385 => mips_insn::MIPS_INS_LWU,
            386 => mips_insn::MIPS_INS_LWX,
            387 => mips_insn::MIPS_INS_LWXC1,
            388 => mips_insn::MIPS_INS_LWXS,
            389 => mips_insn::MIPS_INS_LI,
            390 => mips_insn::MIPS_INS_MADD,
            391 => mips_insn::MIPS_INS_MADDF,
            392 => mips_insn::MIPS_INS_MADDR_Q,
            393 => mips_insn::MIPS_INS_MADDU,
            394 => mips_insn::MIPS_INS_MADDV,
            395 => mips_insn::MIPS_INS_MADD_Q,
            396 => mips_insn::MIPS_INS_MAQ_SA,
            397 => mips_insn::MIPS_INS_MAQ_S,
            398 => mips_insn::MIPS_INS_MAXA,
            399 => mips_insn::MIPS_INS_MAXI_S,
            400 => mips_insn::MIPS_INS_MAXI_U,
            401 => mips_insn::MIPS_INS_MAX_A,
            402 => mips_insn::MIPS_INS_MAX,
            403 => mips_insn::MIPS_INS_MAX_S,
            404 => mips_insn::MIPS_INS_MAX_U,
            405 => mips_insn::MIPS_INS_MFC0,
            406 => mips_insn::MIPS_INS_MFC1,
            407 => mips_insn::MIPS_INS_MFC2,
            408 => mips_insn::MIPS_INS_MFHC1,
            409 => mips_insn::MIPS_INS_MFHI,
            410 => mips_insn::MIPS_INS_MFLO,
            411 => mips_insn::MIPS_INS_MINA,
            412 => mips_insn::MIPS_INS_MINI_S,
            413 => mips_insn::MIPS_INS_MINI_U,
            414 => mips_insn::MIPS_INS_MIN_A,
            415 => mips_insn::MIPS_INS_MIN,
            416 => mips_insn::MIPS_INS_MIN_S,
            417 => mips_insn::MIPS_INS_MIN_U,
            418 => mips_insn::MIPS_INS_MOD,
            419 => mips_insn::MIPS_INS_MODSUB,
            420 => mips_insn::MIPS_INS_MODU,
            421 => mips_insn::MIPS_INS_MOD_S,
            422 => mips_insn::MIPS_INS_MOD_U,
            423 => mips_insn::MIPS_INS_MOVE,
            424 => mips_insn::MIPS_INS_MOVEP,
            425 => mips_insn::MIPS_INS_MOVF,
            426 => mips_insn::MIPS_INS_MOVN,
            427 => mips_insn::MIPS_INS_MOVT,
            428 => mips_insn::MIPS_INS_MOVZ,
            429 => mips_insn::MIPS_INS_MSUB,
            430 => mips_insn::MIPS_INS_MSUBF,
            431 => mips_insn::MIPS_INS_MSUBR_Q,
            432 => mips_insn::MIPS_INS_MSUBU,
            433 => mips_insn::MIPS_INS_MSUBV,
            434 => mips_insn::MIPS_INS_MSUB_Q,
            435 => mips_insn::MIPS_INS_MTC0,
            436 => mips_insn::MIPS_INS_MTC1,
            437 => mips_insn::MIPS_INS_MTC2,
            438 => mips_insn::MIPS_INS_MTHC1,
            439 => mips_insn::MIPS_INS_MTHI,
            440 => mips_insn::MIPS_INS_MTHLIP,
            441 => mips_insn::MIPS_INS_MTLO,
            442 => mips_insn::MIPS_INS_MTM0,
            443 => mips_insn::MIPS_INS_MTM1,
            444 => mips_insn::MIPS_INS_MTM2,
            445 => mips_insn::MIPS_INS_MTP0,
            446 => mips_insn::MIPS_INS_MTP1,
            447 => mips_insn::MIPS_INS_MTP2,
            448 => mips_insn::MIPS_INS_MUH,
            449 => mips_insn::MIPS_INS_MUHU,
            450 => mips_insn::MIPS_INS_MULEQ_S,
            451 => mips_insn::MIPS_INS_MULEU_S,
            452 => mips_insn::MIPS_INS_MULQ_RS,
            453 => mips_insn::MIPS_INS_MULQ_S,
            454 => mips_insn::MIPS_INS_MULR_Q,
            455 => mips_insn::MIPS_INS_MULSAQ_S,
            456 => mips_insn::MIPS_INS_MULSA,
            457 => mips_insn::MIPS_INS_MULT,
            458 => mips_insn::MIPS_INS_MULTU,
            459 => mips_insn::MIPS_INS_MULU,
            460 => mips_insn::MIPS_INS_MULV,
            461 => mips_insn::MIPS_INS_MUL_Q,
            462 => mips_insn::MIPS_INS_MUL_S,
            463 => mips_insn::MIPS_INS_NLOC,
            464 => mips_insn::MIPS_INS_NLZC,
            465 => mips_insn::MIPS_INS_NMADD,
            466 => mips_insn::MIPS_INS_NMSUB,
            467 => mips_insn::MIPS_INS_NOR,
            468 => mips_insn::MIPS_INS_NORI,
            469 => mips_insn::MIPS_INS_NOT16,
            470 => mips_insn::MIPS_INS_NOT,
            471 => mips_insn::MIPS_INS_OR,
            472 => mips_insn::MIPS_INS_OR16,
            473 => mips_insn::MIPS_INS_ORI,
            474 => mips_insn::MIPS_INS_PACKRL,
            475 => mips_insn::MIPS_INS_PAUSE,
            476 => mips_insn::MIPS_INS_PCKEV,
            477 => mips_insn::MIPS_INS_PCKOD,
            478 => mips_insn::MIPS_INS_PCNT,
            479 => mips_insn::MIPS_INS_PICK,
            480 => mips_insn::MIPS_INS_POP,
            481 => mips_insn::MIPS_INS_PRECEQU,
            482 => mips_insn::MIPS_INS_PRECEQ,
            483 => mips_insn::MIPS_INS_PRECEU,
            484 => mips_insn::MIPS_INS_PRECRQU_S,
            485 => mips_insn::MIPS_INS_PRECRQ,
            486 => mips_insn::MIPS_INS_PRECRQ_RS,
            487 => mips_insn::MIPS_INS_PRECR,
            488 => mips_insn::MIPS_INS_PRECR_SRA,
            489 => mips_insn::MIPS_INS_PRECR_SRA_R,
            490 => mips_insn::MIPS_INS_PREF,
            491 => mips_insn::MIPS_INS_PREPEND,
            492 => mips_insn::MIPS_INS_RADDU,
            493 => mips_insn::MIPS_INS_RDDSP,
            494 => mips_insn::MIPS_INS_RDHWR,
            495 => mips_insn::MIPS_INS_REPLV,
            496 => mips_insn::MIPS_INS_REPL,
            497 => mips_insn::MIPS_INS_RINT,
            498 => mips_insn::MIPS_INS_ROTR,
            499 => mips_insn::MIPS_INS_ROTRV,
            500 => mips_insn::MIPS_INS_ROUND,
            501 => mips_insn::MIPS_INS_SAT_S,
            502 => mips_insn::MIPS_INS_SAT_U,
            503 => mips_insn::MIPS_INS_SB,
            504 => mips_insn::MIPS_INS_SB16,
            505 => mips_insn::MIPS_INS_SC,
            506 => mips_insn::MIPS_INS_SCD,
            507 => mips_insn::MIPS_INS_SD,
            508 => mips_insn::MIPS_INS_SDBBP,
            509 => mips_insn::MIPS_INS_SDBBP16,
            510 => mips_insn::MIPS_INS_SDC1,
            511 => mips_insn::MIPS_INS_SDC2,
            512 => mips_insn::MIPS_INS_SDC3,
            513 => mips_insn::MIPS_INS_SDL,
            514 => mips_insn::MIPS_INS_SDR,
            515 => mips_insn::MIPS_INS_SDXC1,
            516 => mips_insn::MIPS_INS_SEB,
            517 => mips_insn::MIPS_INS_SEH,
            518 => mips_insn::MIPS_INS_SELEQZ,
            519 => mips_insn::MIPS_INS_SELNEZ,
            520 => mips_insn::MIPS_INS_SEL,
            521 => mips_insn::MIPS_INS_SEQ,
            522 => mips_insn::MIPS_INS_SEQI,
            523 => mips_insn::MIPS_INS_SH,
            524 => mips_insn::MIPS_INS_SH16,
            525 => mips_insn::MIPS_INS_SHF,
            526 => mips_insn::MIPS_INS_SHILO,
            527 => mips_insn::MIPS_INS_SHILOV,
            528 => mips_insn::MIPS_INS_SHLLV,
            529 => mips_insn::MIPS_INS_SHLLV_S,
            530 => mips_insn::MIPS_INS_SHLL,
            531 => mips_insn::MIPS_INS_SHLL_S,
            532 => mips_insn::MIPS_INS_SHRAV,
            533 => mips_insn::MIPS_INS_SHRAV_R,
            534 => mips_insn::MIPS_INS_SHRA,
            535 => mips_insn::MIPS_INS_SHRA_R,
            536 => mips_insn::MIPS_INS_SHRLV,
            537 => mips_insn::MIPS_INS_SHRL,
            538 => mips_insn::MIPS_INS_SLDI,
            539 => mips_insn::MIPS_INS_SLD,
            540 => mips_insn::MIPS_INS_SLL,
            541 => mips_insn::MIPS_INS_SLL16,
            542 => mips_insn::MIPS_INS_SLLI,
            543 => mips_insn::MIPS_INS_SLLV,
            544 => mips_insn::MIPS_INS_SLT,
            545 => mips_insn::MIPS_INS_SLTI,
            546 => mips_insn::MIPS_INS_SLTIU,
            547 => mips_insn::MIPS_INS_SLTU,
            548 => mips_insn::MIPS_INS_SNE,
            549 => mips_insn::MIPS_INS_SNEI,
            550 => mips_insn::MIPS_INS_SPLATI,
            551 => mips_insn::MIPS_INS_SPLAT,
            552 => mips_insn::MIPS_INS_SRA,
            553 => mips_insn::MIPS_INS_SRAI,
            554 => mips_insn::MIPS_INS_SRARI,
            555 => mips_insn::MIPS_INS_SRAR,
            556 => mips_insn::MIPS_INS_SRAV,
            557 => mips_insn::MIPS_INS_SRL,
            558 => mips_insn::MIPS_INS_SRL16,
            559 => mips_insn::MIPS_INS_SRLI,
            560 => mips_insn::MIPS_INS_SRLRI,
            561 => mips_insn::MIPS_INS_SRLR,
            562 => mips_insn::MIPS_INS_SRLV,
            563 => mips_insn::MIPS_INS_SSNOP,
            564 => mips_insn::MIPS_INS_ST,
            565 => mips_insn::MIPS_INS_SUBQH,
            566 => mips_insn::MIPS_INS_SUBQH_R,
            567 => mips_insn::MIPS_INS_SUBQ,
            568 => mips_insn::MIPS_INS_SUBQ_S,
            569 => mips_insn::MIPS_INS_SUBSUS_U,
            570 => mips_insn::MIPS_INS_SUBSUU_S,
            571 => mips_insn::MIPS_INS_SUBS_S,
            572 => mips_insn::MIPS_INS_SUBS_U,
            573 => mips_insn::MIPS_INS_SUBU16,
            574 => mips_insn::MIPS_INS_SUBUH,
            575 => mips_insn::MIPS_INS_SUBUH_R,
            576 => mips_insn::MIPS_INS_SUBU,
            577 => mips_insn::MIPS_INS_SUBU_S,
            578 => mips_insn::MIPS_INS_SUBVI,
            579 => mips_insn::MIPS_INS_SUBV,
            580 => mips_insn::MIPS_INS_SUXC1,
            581 => mips_insn::MIPS_INS_SW,
            582 => mips_insn::MIPS_INS_SW16,
            583 => mips_insn::MIPS_INS_SWC1,
            584 => mips_insn::MIPS_INS_SWC2,
            585 => mips_insn::MIPS_INS_SWC3,
            586 => mips_insn::MIPS_INS_SWL,
            587 => mips_insn::MIPS_INS_SWM16,
            588 => mips_insn::MIPS_INS_SWM32,
            589 => mips_insn::MIPS_INS_SWP,
            590 => mips_insn::MIPS_INS_SWR,
            591 => mips_insn::MIPS_INS_SWXC1,
            592 => mips_insn::MIPS_INS_SYNC,
            593 => mips_insn::MIPS_INS_SYNCI,
            594 => mips_insn::MIPS_INS_SYSCALL,
            595 => mips_insn::MIPS_INS_TEQ,
            596 => mips_insn::MIPS_INS_TEQI,
            597 => mips_insn::MIPS_INS_TGE,
            598 => mips_insn::MIPS_INS_TGEI,
            599 => mips_insn::MIPS_INS_TGEIU,
            600 => mips_insn::MIPS_INS_TGEU,
            601 => mips_insn::MIPS_INS_TLBP,
            602 => mips_insn::MIPS_INS_TLBR,
            603 => mips_insn::MIPS_INS_TLBWI,
            604 => mips_insn::MIPS_INS_TLBWR,
            605 => mips_insn::MIPS_INS_TLT,
            606 => mips_insn::MIPS_INS_TLTI,
            607 => mips_insn::MIPS_INS_TLTIU,
            608 => mips_insn::MIPS_INS_TLTU,
            609 => mips_insn::MIPS_INS_TNE,
            610 => mips_insn::MIPS_INS_TNEI,
            611 => mips_insn::MIPS_INS_TRUNC,
            612 => mips_insn::MIPS_INS_V3MULU,
            613 => mips_insn::MIPS_INS_VMM0,
            614 => mips_insn::MIPS_INS_VMULU,
            615 => mips_insn::MIPS_INS_VSHF,
            616 => mips_insn::MIPS_INS_WAIT,
            617 => mips_insn::MIPS_INS_WRDSP,
            618 => mips_insn::MIPS_INS_WSBH,
            619 => mips_insn::MIPS_INS_XOR,
            620 => mips_insn::MIPS_INS_XOR16,
            621 => mips_insn::MIPS_INS_XORI,
            622 => mips_insn::MIPS_INS_NOP,
            623 => mips_insn::MIPS_INS_NEGU,
            624 => mips_insn::MIPS_INS_JALR_HB,
            625 => mips_insn::MIPS_INS_JR_HB,
            626 => mips_insn::MIPS_INS_ENDING,
            _ => mips_insn::MIPS_INS_INVALID,
        }
    }
}
impl From<u32> for ppc_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => ppc_insn::PPC_INS_INVALID,
            1 => ppc_insn::PPC_INS_ADD,
            2 => ppc_insn::PPC_INS_ADDC,
            3 => ppc_insn::PPC_INS_ADDE,
            4 => ppc_insn::PPC_INS_ADDI,
            5 => ppc_insn::PPC_INS_ADDIC,
            6 => ppc_insn::PPC_INS_ADDIS,
            7 => ppc_insn::PPC_INS_ADDME,
            8 => ppc_insn::PPC_INS_ADDZE,
            9 => ppc_insn::PPC_INS_AND,
            10 => ppc_insn::PPC_INS_ANDC,
            11 => ppc_insn::PPC_INS_ANDIS,
            12 => ppc_insn::PPC_INS_ANDI,
            13 => ppc_insn::PPC_INS_ATTN,
            14 => ppc_insn::PPC_INS_B,
            15 => ppc_insn::PPC_INS_BA,
            16 => ppc_insn::PPC_INS_BC,
            17 => ppc_insn::PPC_INS_BCCTR,
            18 => ppc_insn::PPC_INS_BCCTRL,
            19 => ppc_insn::PPC_INS_BCL,
            20 => ppc_insn::PPC_INS_BCLR,
            21 => ppc_insn::PPC_INS_BCLRL,
            22 => ppc_insn::PPC_INS_BCTR,
            23 => ppc_insn::PPC_INS_BCTRL,
            24 => ppc_insn::PPC_INS_BCT,
            25 => ppc_insn::PPC_INS_BDNZ,
            26 => ppc_insn::PPC_INS_BDNZA,
            27 => ppc_insn::PPC_INS_BDNZL,
            28 => ppc_insn::PPC_INS_BDNZLA,
            29 => ppc_insn::PPC_INS_BDNZLR,
            30 => ppc_insn::PPC_INS_BDNZLRL,
            31 => ppc_insn::PPC_INS_BDZ,
            32 => ppc_insn::PPC_INS_BDZA,
            33 => ppc_insn::PPC_INS_BDZL,
            34 => ppc_insn::PPC_INS_BDZLA,
            35 => ppc_insn::PPC_INS_BDZLR,
            36 => ppc_insn::PPC_INS_BDZLRL,
            37 => ppc_insn::PPC_INS_BL,
            38 => ppc_insn::PPC_INS_BLA,
            39 => ppc_insn::PPC_INS_BLR,
            40 => ppc_insn::PPC_INS_BLRL,
            41 => ppc_insn::PPC_INS_BRINC,
            42 => ppc_insn::PPC_INS_CMPB,
            43 => ppc_insn::PPC_INS_CMPD,
            44 => ppc_insn::PPC_INS_CMPDI,
            45 => ppc_insn::PPC_INS_CMPLD,
            46 => ppc_insn::PPC_INS_CMPLDI,
            47 => ppc_insn::PPC_INS_CMPLW,
            48 => ppc_insn::PPC_INS_CMPLWI,
            49 => ppc_insn::PPC_INS_CMPW,
            50 => ppc_insn::PPC_INS_CMPWI,
            51 => ppc_insn::PPC_INS_CNTLZD,
            52 => ppc_insn::PPC_INS_CNTLZW,
            53 => ppc_insn::PPC_INS_CREQV,
            54 => ppc_insn::PPC_INS_CRXOR,
            55 => ppc_insn::PPC_INS_CRAND,
            56 => ppc_insn::PPC_INS_CRANDC,
            57 => ppc_insn::PPC_INS_CRNAND,
            58 => ppc_insn::PPC_INS_CRNOR,
            59 => ppc_insn::PPC_INS_CROR,
            60 => ppc_insn::PPC_INS_CRORC,
            61 => ppc_insn::PPC_INS_DCBA,
            62 => ppc_insn::PPC_INS_DCBF,
            63 => ppc_insn::PPC_INS_DCBI,
            64 => ppc_insn::PPC_INS_DCBST,
            65 => ppc_insn::PPC_INS_DCBT,
            66 => ppc_insn::PPC_INS_DCBTST,
            67 => ppc_insn::PPC_INS_DCBZ,
            68 => ppc_insn::PPC_INS_DCBZL,
            69 => ppc_insn::PPC_INS_DCCCI,
            70 => ppc_insn::PPC_INS_DIVD,
            71 => ppc_insn::PPC_INS_DIVDU,
            72 => ppc_insn::PPC_INS_DIVW,
            73 => ppc_insn::PPC_INS_DIVWU,
            74 => ppc_insn::PPC_INS_DSS,
            75 => ppc_insn::PPC_INS_DSSALL,
            76 => ppc_insn::PPC_INS_DST,
            77 => ppc_insn::PPC_INS_DSTST,
            78 => ppc_insn::PPC_INS_DSTSTT,
            79 => ppc_insn::PPC_INS_DSTT,
            80 => ppc_insn::PPC_INS_EQV,
            81 => ppc_insn::PPC_INS_EVABS,
            82 => ppc_insn::PPC_INS_EVADDIW,
            83 => ppc_insn::PPC_INS_EVADDSMIAAW,
            84 => ppc_insn::PPC_INS_EVADDSSIAAW,
            85 => ppc_insn::PPC_INS_EVADDUMIAAW,
            86 => ppc_insn::PPC_INS_EVADDUSIAAW,
            87 => ppc_insn::PPC_INS_EVADDW,
            88 => ppc_insn::PPC_INS_EVAND,
            89 => ppc_insn::PPC_INS_EVANDC,
            90 => ppc_insn::PPC_INS_EVCMPEQ,
            91 => ppc_insn::PPC_INS_EVCMPGTS,
            92 => ppc_insn::PPC_INS_EVCMPGTU,
            93 => ppc_insn::PPC_INS_EVCMPLTS,
            94 => ppc_insn::PPC_INS_EVCMPLTU,
            95 => ppc_insn::PPC_INS_EVCNTLSW,
            96 => ppc_insn::PPC_INS_EVCNTLZW,
            97 => ppc_insn::PPC_INS_EVDIVWS,
            98 => ppc_insn::PPC_INS_EVDIVWU,
            99 => ppc_insn::PPC_INS_EVEQV,
            100 => ppc_insn::PPC_INS_EVEXTSB,
            101 => ppc_insn::PPC_INS_EVEXTSH,
            102 => ppc_insn::PPC_INS_EVLDD,
            103 => ppc_insn::PPC_INS_EVLDDX,
            104 => ppc_insn::PPC_INS_EVLDH,
            105 => ppc_insn::PPC_INS_EVLDHX,
            106 => ppc_insn::PPC_INS_EVLDW,
            107 => ppc_insn::PPC_INS_EVLDWX,
            108 => ppc_insn::PPC_INS_EVLHHESPLAT,
            109 => ppc_insn::PPC_INS_EVLHHESPLATX,
            110 => ppc_insn::PPC_INS_EVLHHOSSPLAT,
            111 => ppc_insn::PPC_INS_EVLHHOSSPLATX,
            112 => ppc_insn::PPC_INS_EVLHHOUSPLAT,
            113 => ppc_insn::PPC_INS_EVLHHOUSPLATX,
            114 => ppc_insn::PPC_INS_EVLWHE,
            115 => ppc_insn::PPC_INS_EVLWHEX,
            116 => ppc_insn::PPC_INS_EVLWHOS,
            117 => ppc_insn::PPC_INS_EVLWHOSX,
            118 => ppc_insn::PPC_INS_EVLWHOU,
            119 => ppc_insn::PPC_INS_EVLWHOUX,
            120 => ppc_insn::PPC_INS_EVLWHSPLAT,
            121 => ppc_insn::PPC_INS_EVLWHSPLATX,
            122 => ppc_insn::PPC_INS_EVLWWSPLAT,
            123 => ppc_insn::PPC_INS_EVLWWSPLATX,
            124 => ppc_insn::PPC_INS_EVMERGEHI,
            125 => ppc_insn::PPC_INS_EVMERGEHILO,
            126 => ppc_insn::PPC_INS_EVMERGELO,
            127 => ppc_insn::PPC_INS_EVMERGELOHI,
            128 => ppc_insn::PPC_INS_EVMHEGSMFAA,
            129 => ppc_insn::PPC_INS_EVMHEGSMFAN,
            130 => ppc_insn::PPC_INS_EVMHEGSMIAA,
            131 => ppc_insn::PPC_INS_EVMHEGSMIAN,
            132 => ppc_insn::PPC_INS_EVMHEGUMIAA,
            133 => ppc_insn::PPC_INS_EVMHEGUMIAN,
            134 => ppc_insn::PPC_INS_EVMHESMF,
            135 => ppc_insn::PPC_INS_EVMHESMFA,
            136 => ppc_insn::PPC_INS_EVMHESMFAAW,
            137 => ppc_insn::PPC_INS_EVMHESMFANW,
            138 => ppc_insn::PPC_INS_EVMHESMI,
            139 => ppc_insn::PPC_INS_EVMHESMIA,
            140 => ppc_insn::PPC_INS_EVMHESMIAAW,
            141 => ppc_insn::PPC_INS_EVMHESMIANW,
            142 => ppc_insn::PPC_INS_EVMHESSF,
            143 => ppc_insn::PPC_INS_EVMHESSFA,
            144 => ppc_insn::PPC_INS_EVMHESSFAAW,
            145 => ppc_insn::PPC_INS_EVMHESSFANW,
            146 => ppc_insn::PPC_INS_EVMHESSIAAW,
            147 => ppc_insn::PPC_INS_EVMHESSIANW,
            148 => ppc_insn::PPC_INS_EVMHEUMI,
            149 => ppc_insn::PPC_INS_EVMHEUMIA,
            150 => ppc_insn::PPC_INS_EVMHEUMIAAW,
            151 => ppc_insn::PPC_INS_EVMHEUMIANW,
            152 => ppc_insn::PPC_INS_EVMHEUSIAAW,
            153 => ppc_insn::PPC_INS_EVMHEUSIANW,
            154 => ppc_insn::PPC_INS_EVMHOGSMFAA,
            155 => ppc_insn::PPC_INS_EVMHOGSMFAN,
            156 => ppc_insn::PPC_INS_EVMHOGSMIAA,
            157 => ppc_insn::PPC_INS_EVMHOGSMIAN,
            158 => ppc_insn::PPC_INS_EVMHOGUMIAA,
            159 => ppc_insn::PPC_INS_EVMHOGUMIAN,
            160 => ppc_insn::PPC_INS_EVMHOSMF,
            161 => ppc_insn::PPC_INS_EVMHOSMFA,
            162 => ppc_insn::PPC_INS_EVMHOSMFAAW,
            163 => ppc_insn::PPC_INS_EVMHOSMFANW,
            164 => ppc_insn::PPC_INS_EVMHOSMI,
            165 => ppc_insn::PPC_INS_EVMHOSMIA,
            166 => ppc_insn::PPC_INS_EVMHOSMIAAW,
            167 => ppc_insn::PPC_INS_EVMHOSMIANW,
            168 => ppc_insn::PPC_INS_EVMHOSSF,
            169 => ppc_insn::PPC_INS_EVMHOSSFA,
            170 => ppc_insn::PPC_INS_EVMHOSSFAAW,
            171 => ppc_insn::PPC_INS_EVMHOSSFANW,
            172 => ppc_insn::PPC_INS_EVMHOSSIAAW,
            173 => ppc_insn::PPC_INS_EVMHOSSIANW,
            174 => ppc_insn::PPC_INS_EVMHOUMI,
            175 => ppc_insn::PPC_INS_EVMHOUMIA,
            176 => ppc_insn::PPC_INS_EVMHOUMIAAW,
            177 => ppc_insn::PPC_INS_EVMHOUMIANW,
            178 => ppc_insn::PPC_INS_EVMHOUSIAAW,
            179 => ppc_insn::PPC_INS_EVMHOUSIANW,
            180 => ppc_insn::PPC_INS_EVMRA,
            181 => ppc_insn::PPC_INS_EVMWHSMF,
            182 => ppc_insn::PPC_INS_EVMWHSMFA,
            183 => ppc_insn::PPC_INS_EVMWHSMI,
            184 => ppc_insn::PPC_INS_EVMWHSMIA,
            185 => ppc_insn::PPC_INS_EVMWHSSF,
            186 => ppc_insn::PPC_INS_EVMWHSSFA,
            187 => ppc_insn::PPC_INS_EVMWHUMI,
            188 => ppc_insn::PPC_INS_EVMWHUMIA,
            189 => ppc_insn::PPC_INS_EVMWLSMIAAW,
            190 => ppc_insn::PPC_INS_EVMWLSMIANW,
            191 => ppc_insn::PPC_INS_EVMWLSSIAAW,
            192 => ppc_insn::PPC_INS_EVMWLSSIANW,
            193 => ppc_insn::PPC_INS_EVMWLUMI,
            194 => ppc_insn::PPC_INS_EVMWLUMIA,
            195 => ppc_insn::PPC_INS_EVMWLUMIAAW,
            196 => ppc_insn::PPC_INS_EVMWLUMIANW,
            197 => ppc_insn::PPC_INS_EVMWLUSIAAW,
            198 => ppc_insn::PPC_INS_EVMWLUSIANW,
            199 => ppc_insn::PPC_INS_EVMWSMF,
            200 => ppc_insn::PPC_INS_EVMWSMFA,
            201 => ppc_insn::PPC_INS_EVMWSMFAA,
            202 => ppc_insn::PPC_INS_EVMWSMFAN,
            203 => ppc_insn::PPC_INS_EVMWSMI,
            204 => ppc_insn::PPC_INS_EVMWSMIA,
            205 => ppc_insn::PPC_INS_EVMWSMIAA,
            206 => ppc_insn::PPC_INS_EVMWSMIAN,
            207 => ppc_insn::PPC_INS_EVMWSSF,
            208 => ppc_insn::PPC_INS_EVMWSSFA,
            209 => ppc_insn::PPC_INS_EVMWSSFAA,
            210 => ppc_insn::PPC_INS_EVMWSSFAN,
            211 => ppc_insn::PPC_INS_EVMWUMI,
            212 => ppc_insn::PPC_INS_EVMWUMIA,
            213 => ppc_insn::PPC_INS_EVMWUMIAA,
            214 => ppc_insn::PPC_INS_EVMWUMIAN,
            215 => ppc_insn::PPC_INS_EVNAND,
            216 => ppc_insn::PPC_INS_EVNEG,
            217 => ppc_insn::PPC_INS_EVNOR,
            218 => ppc_insn::PPC_INS_EVOR,
            219 => ppc_insn::PPC_INS_EVORC,
            220 => ppc_insn::PPC_INS_EVRLW,
            221 => ppc_insn::PPC_INS_EVRLWI,
            222 => ppc_insn::PPC_INS_EVRNDW,
            223 => ppc_insn::PPC_INS_EVSLW,
            224 => ppc_insn::PPC_INS_EVSLWI,
            225 => ppc_insn::PPC_INS_EVSPLATFI,
            226 => ppc_insn::PPC_INS_EVSPLATI,
            227 => ppc_insn::PPC_INS_EVSRWIS,
            228 => ppc_insn::PPC_INS_EVSRWIU,
            229 => ppc_insn::PPC_INS_EVSRWS,
            230 => ppc_insn::PPC_INS_EVSRWU,
            231 => ppc_insn::PPC_INS_EVSTDD,
            232 => ppc_insn::PPC_INS_EVSTDDX,
            233 => ppc_insn::PPC_INS_EVSTDH,
            234 => ppc_insn::PPC_INS_EVSTDHX,
            235 => ppc_insn::PPC_INS_EVSTDW,
            236 => ppc_insn::PPC_INS_EVSTDWX,
            237 => ppc_insn::PPC_INS_EVSTWHE,
            238 => ppc_insn::PPC_INS_EVSTWHEX,
            239 => ppc_insn::PPC_INS_EVSTWHO,
            240 => ppc_insn::PPC_INS_EVSTWHOX,
            241 => ppc_insn::PPC_INS_EVSTWWE,
            242 => ppc_insn::PPC_INS_EVSTWWEX,
            243 => ppc_insn::PPC_INS_EVSTWWO,
            244 => ppc_insn::PPC_INS_EVSTWWOX,
            245 => ppc_insn::PPC_INS_EVSUBFSMIAAW,
            246 => ppc_insn::PPC_INS_EVSUBFSSIAAW,
            247 => ppc_insn::PPC_INS_EVSUBFUMIAAW,
            248 => ppc_insn::PPC_INS_EVSUBFUSIAAW,
            249 => ppc_insn::PPC_INS_EVSUBFW,
            250 => ppc_insn::PPC_INS_EVSUBIFW,
            251 => ppc_insn::PPC_INS_EVXOR,
            252 => ppc_insn::PPC_INS_EXTSB,
            253 => ppc_insn::PPC_INS_EXTSH,
            254 => ppc_insn::PPC_INS_EXTSW,
            255 => ppc_insn::PPC_INS_EIEIO,
            256 => ppc_insn::PPC_INS_FABS,
            257 => ppc_insn::PPC_INS_FADD,
            258 => ppc_insn::PPC_INS_FADDS,
            259 => ppc_insn::PPC_INS_FCFID,
            260 => ppc_insn::PPC_INS_FCFIDS,
            261 => ppc_insn::PPC_INS_FCFIDU,
            262 => ppc_insn::PPC_INS_FCFIDUS,
            263 => ppc_insn::PPC_INS_FCMPU,
            264 => ppc_insn::PPC_INS_FCPSGN,
            265 => ppc_insn::PPC_INS_FCTID,
            266 => ppc_insn::PPC_INS_FCTIDUZ,
            267 => ppc_insn::PPC_INS_FCTIDZ,
            268 => ppc_insn::PPC_INS_FCTIW,
            269 => ppc_insn::PPC_INS_FCTIWUZ,
            270 => ppc_insn::PPC_INS_FCTIWZ,
            271 => ppc_insn::PPC_INS_FDIV,
            272 => ppc_insn::PPC_INS_FDIVS,
            273 => ppc_insn::PPC_INS_FMADD,
            274 => ppc_insn::PPC_INS_FMADDS,
            275 => ppc_insn::PPC_INS_FMR,
            276 => ppc_insn::PPC_INS_FMSUB,
            277 => ppc_insn::PPC_INS_FMSUBS,
            278 => ppc_insn::PPC_INS_FMUL,
            279 => ppc_insn::PPC_INS_FMULS,
            280 => ppc_insn::PPC_INS_FNABS,
            281 => ppc_insn::PPC_INS_FNEG,
            282 => ppc_insn::PPC_INS_FNMADD,
            283 => ppc_insn::PPC_INS_FNMADDS,
            284 => ppc_insn::PPC_INS_FNMSUB,
            285 => ppc_insn::PPC_INS_FNMSUBS,
            286 => ppc_insn::PPC_INS_FRE,
            287 => ppc_insn::PPC_INS_FRES,
            288 => ppc_insn::PPC_INS_FRIM,
            289 => ppc_insn::PPC_INS_FRIN,
            290 => ppc_insn::PPC_INS_FRIP,
            291 => ppc_insn::PPC_INS_FRIZ,
            292 => ppc_insn::PPC_INS_FRSP,
            293 => ppc_insn::PPC_INS_FRSQRTE,
            294 => ppc_insn::PPC_INS_FRSQRTES,
            295 => ppc_insn::PPC_INS_FSEL,
            296 => ppc_insn::PPC_INS_FSQRT,
            297 => ppc_insn::PPC_INS_FSQRTS,
            298 => ppc_insn::PPC_INS_FSUB,
            299 => ppc_insn::PPC_INS_FSUBS,
            300 => ppc_insn::PPC_INS_ICBI,
            301 => ppc_insn::PPC_INS_ICBT,
            302 => ppc_insn::PPC_INS_ICCCI,
            303 => ppc_insn::PPC_INS_ISEL,
            304 => ppc_insn::PPC_INS_ISYNC,
            305 => ppc_insn::PPC_INS_LA,
            306 => ppc_insn::PPC_INS_LBZ,
            307 => ppc_insn::PPC_INS_LBZCIX,
            308 => ppc_insn::PPC_INS_LBZU,
            309 => ppc_insn::PPC_INS_LBZUX,
            310 => ppc_insn::PPC_INS_LBZX,
            311 => ppc_insn::PPC_INS_LD,
            312 => ppc_insn::PPC_INS_LDARX,
            313 => ppc_insn::PPC_INS_LDBRX,
            314 => ppc_insn::PPC_INS_LDCIX,
            315 => ppc_insn::PPC_INS_LDU,
            316 => ppc_insn::PPC_INS_LDUX,
            317 => ppc_insn::PPC_INS_LDX,
            318 => ppc_insn::PPC_INS_LFD,
            319 => ppc_insn::PPC_INS_LFDU,
            320 => ppc_insn::PPC_INS_LFDUX,
            321 => ppc_insn::PPC_INS_LFDX,
            322 => ppc_insn::PPC_INS_LFIWAX,
            323 => ppc_insn::PPC_INS_LFIWZX,
            324 => ppc_insn::PPC_INS_LFS,
            325 => ppc_insn::PPC_INS_LFSU,
            326 => ppc_insn::PPC_INS_LFSUX,
            327 => ppc_insn::PPC_INS_LFSX,
            328 => ppc_insn::PPC_INS_LHA,
            329 => ppc_insn::PPC_INS_LHAU,
            330 => ppc_insn::PPC_INS_LHAUX,
            331 => ppc_insn::PPC_INS_LHAX,
            332 => ppc_insn::PPC_INS_LHBRX,
            333 => ppc_insn::PPC_INS_LHZ,
            334 => ppc_insn::PPC_INS_LHZCIX,
            335 => ppc_insn::PPC_INS_LHZU,
            336 => ppc_insn::PPC_INS_LHZUX,
            337 => ppc_insn::PPC_INS_LHZX,
            338 => ppc_insn::PPC_INS_LI,
            339 => ppc_insn::PPC_INS_LIS,
            340 => ppc_insn::PPC_INS_LMW,
            341 => ppc_insn::PPC_INS_LSWI,
            342 => ppc_insn::PPC_INS_LVEBX,
            343 => ppc_insn::PPC_INS_LVEHX,
            344 => ppc_insn::PPC_INS_LVEWX,
            345 => ppc_insn::PPC_INS_LVSL,
            346 => ppc_insn::PPC_INS_LVSR,
            347 => ppc_insn::PPC_INS_LVX,
            348 => ppc_insn::PPC_INS_LVXL,
            349 => ppc_insn::PPC_INS_LWA,
            350 => ppc_insn::PPC_INS_LWARX,
            351 => ppc_insn::PPC_INS_LWAUX,
            352 => ppc_insn::PPC_INS_LWAX,
            353 => ppc_insn::PPC_INS_LWBRX,
            354 => ppc_insn::PPC_INS_LWZ,
            355 => ppc_insn::PPC_INS_LWZCIX,
            356 => ppc_insn::PPC_INS_LWZU,
            357 => ppc_insn::PPC_INS_LWZUX,
            358 => ppc_insn::PPC_INS_LWZX,
            359 => ppc_insn::PPC_INS_LXSDX,
            360 => ppc_insn::PPC_INS_LXVD2X,
            361 => ppc_insn::PPC_INS_LXVDSX,
            362 => ppc_insn::PPC_INS_LXVW4X,
            363 => ppc_insn::PPC_INS_MBAR,
            364 => ppc_insn::PPC_INS_MCRF,
            365 => ppc_insn::PPC_INS_MCRFS,
            366 => ppc_insn::PPC_INS_MFCR,
            367 => ppc_insn::PPC_INS_MFCTR,
            368 => ppc_insn::PPC_INS_MFDCR,
            369 => ppc_insn::PPC_INS_MFFS,
            370 => ppc_insn::PPC_INS_MFLR,
            371 => ppc_insn::PPC_INS_MFMSR,
            372 => ppc_insn::PPC_INS_MFOCRF,
            373 => ppc_insn::PPC_INS_MFSPR,
            374 => ppc_insn::PPC_INS_MFSR,
            375 => ppc_insn::PPC_INS_MFSRIN,
            376 => ppc_insn::PPC_INS_MFTB,
            377 => ppc_insn::PPC_INS_MFVSCR,
            378 => ppc_insn::PPC_INS_MSYNC,
            379 => ppc_insn::PPC_INS_MTCRF,
            380 => ppc_insn::PPC_INS_MTCTR,
            381 => ppc_insn::PPC_INS_MTDCR,
            382 => ppc_insn::PPC_INS_MTFSB0,
            383 => ppc_insn::PPC_INS_MTFSB1,
            384 => ppc_insn::PPC_INS_MTFSF,
            385 => ppc_insn::PPC_INS_MTFSFI,
            386 => ppc_insn::PPC_INS_MTLR,
            387 => ppc_insn::PPC_INS_MTMSR,
            388 => ppc_insn::PPC_INS_MTMSRD,
            389 => ppc_insn::PPC_INS_MTOCRF,
            390 => ppc_insn::PPC_INS_MTSPR,
            391 => ppc_insn::PPC_INS_MTSR,
            392 => ppc_insn::PPC_INS_MTSRIN,
            393 => ppc_insn::PPC_INS_MTVSCR,
            394 => ppc_insn::PPC_INS_MULHD,
            395 => ppc_insn::PPC_INS_MULHDU,
            396 => ppc_insn::PPC_INS_MULHW,
            397 => ppc_insn::PPC_INS_MULHWU,
            398 => ppc_insn::PPC_INS_MULLD,
            399 => ppc_insn::PPC_INS_MULLI,
            400 => ppc_insn::PPC_INS_MULLW,
            401 => ppc_insn::PPC_INS_NAND,
            402 => ppc_insn::PPC_INS_NEG,
            403 => ppc_insn::PPC_INS_NOP,
            404 => ppc_insn::PPC_INS_ORI,
            405 => ppc_insn::PPC_INS_NOR,
            406 => ppc_insn::PPC_INS_OR,
            407 => ppc_insn::PPC_INS_ORC,
            408 => ppc_insn::PPC_INS_ORIS,
            409 => ppc_insn::PPC_INS_POPCNTD,
            410 => ppc_insn::PPC_INS_POPCNTW,
            411 => ppc_insn::PPC_INS_QVALIGNI,
            412 => ppc_insn::PPC_INS_QVESPLATI,
            413 => ppc_insn::PPC_INS_QVFABS,
            414 => ppc_insn::PPC_INS_QVFADD,
            415 => ppc_insn::PPC_INS_QVFADDS,
            416 => ppc_insn::PPC_INS_QVFCFID,
            417 => ppc_insn::PPC_INS_QVFCFIDS,
            418 => ppc_insn::PPC_INS_QVFCFIDU,
            419 => ppc_insn::PPC_INS_QVFCFIDUS,
            420 => ppc_insn::PPC_INS_QVFCMPEQ,
            421 => ppc_insn::PPC_INS_QVFCMPGT,
            422 => ppc_insn::PPC_INS_QVFCMPLT,
            423 => ppc_insn::PPC_INS_QVFCPSGN,
            424 => ppc_insn::PPC_INS_QVFCTID,
            425 => ppc_insn::PPC_INS_QVFCTIDU,
            426 => ppc_insn::PPC_INS_QVFCTIDUZ,
            427 => ppc_insn::PPC_INS_QVFCTIDZ,
            428 => ppc_insn::PPC_INS_QVFCTIW,
            429 => ppc_insn::PPC_INS_QVFCTIWU,
            430 => ppc_insn::PPC_INS_QVFCTIWUZ,
            431 => ppc_insn::PPC_INS_QVFCTIWZ,
            432 => ppc_insn::PPC_INS_QVFLOGICAL,
            433 => ppc_insn::PPC_INS_QVFMADD,
            434 => ppc_insn::PPC_INS_QVFMADDS,
            435 => ppc_insn::PPC_INS_QVFMR,
            436 => ppc_insn::PPC_INS_QVFMSUB,
            437 => ppc_insn::PPC_INS_QVFMSUBS,
            438 => ppc_insn::PPC_INS_QVFMUL,
            439 => ppc_insn::PPC_INS_QVFMULS,
            440 => ppc_insn::PPC_INS_QVFNABS,
            441 => ppc_insn::PPC_INS_QVFNEG,
            442 => ppc_insn::PPC_INS_QVFNMADD,
            443 => ppc_insn::PPC_INS_QVFNMADDS,
            444 => ppc_insn::PPC_INS_QVFNMSUB,
            445 => ppc_insn::PPC_INS_QVFNMSUBS,
            446 => ppc_insn::PPC_INS_QVFPERM,
            447 => ppc_insn::PPC_INS_QVFRE,
            448 => ppc_insn::PPC_INS_QVFRES,
            449 => ppc_insn::PPC_INS_QVFRIM,
            450 => ppc_insn::PPC_INS_QVFRIN,
            451 => ppc_insn::PPC_INS_QVFRIP,
            452 => ppc_insn::PPC_INS_QVFRIZ,
            453 => ppc_insn::PPC_INS_QVFRSP,
            454 => ppc_insn::PPC_INS_QVFRSQRTE,
            455 => ppc_insn::PPC_INS_QVFRSQRTES,
            456 => ppc_insn::PPC_INS_QVFSEL,
            457 => ppc_insn::PPC_INS_QVFSUB,
            458 => ppc_insn::PPC_INS_QVFSUBS,
            459 => ppc_insn::PPC_INS_QVFTSTNAN,
            460 => ppc_insn::PPC_INS_QVFXMADD,
            461 => ppc_insn::PPC_INS_QVFXMADDS,
            462 => ppc_insn::PPC_INS_QVFXMUL,
            463 => ppc_insn::PPC_INS_QVFXMULS,
            464 => ppc_insn::PPC_INS_QVFXXCPNMADD,
            465 => ppc_insn::PPC_INS_QVFXXCPNMADDS,
            466 => ppc_insn::PPC_INS_QVFXXMADD,
            467 => ppc_insn::PPC_INS_QVFXXMADDS,
            468 => ppc_insn::PPC_INS_QVFXXNPMADD,
            469 => ppc_insn::PPC_INS_QVFXXNPMADDS,
            470 => ppc_insn::PPC_INS_QVGPCI,
            471 => ppc_insn::PPC_INS_QVLFCDUX,
            472 => ppc_insn::PPC_INS_QVLFCDUXA,
            473 => ppc_insn::PPC_INS_QVLFCDX,
            474 => ppc_insn::PPC_INS_QVLFCDXA,
            475 => ppc_insn::PPC_INS_QVLFCSUX,
            476 => ppc_insn::PPC_INS_QVLFCSUXA,
            477 => ppc_insn::PPC_INS_QVLFCSX,
            478 => ppc_insn::PPC_INS_QVLFCSXA,
            479 => ppc_insn::PPC_INS_QVLFDUX,
            480 => ppc_insn::PPC_INS_QVLFDUXA,
            481 => ppc_insn::PPC_INS_QVLFDX,
            482 => ppc_insn::PPC_INS_QVLFDXA,
            483 => ppc_insn::PPC_INS_QVLFIWAX,
            484 => ppc_insn::PPC_INS_QVLFIWAXA,
            485 => ppc_insn::PPC_INS_QVLFIWZX,
            486 => ppc_insn::PPC_INS_QVLFIWZXA,
            487 => ppc_insn::PPC_INS_QVLFSUX,
            488 => ppc_insn::PPC_INS_QVLFSUXA,
            489 => ppc_insn::PPC_INS_QVLFSX,
            490 => ppc_insn::PPC_INS_QVLFSXA,
            491 => ppc_insn::PPC_INS_QVLPCLDX,
            492 => ppc_insn::PPC_INS_QVLPCLSX,
            493 => ppc_insn::PPC_INS_QVLPCRDX,
            494 => ppc_insn::PPC_INS_QVLPCRSX,
            495 => ppc_insn::PPC_INS_QVSTFCDUX,
            496 => ppc_insn::PPC_INS_QVSTFCDUXA,
            497 => ppc_insn::PPC_INS_QVSTFCDUXI,
            498 => ppc_insn::PPC_INS_QVSTFCDUXIA,
            499 => ppc_insn::PPC_INS_QVSTFCDX,
            500 => ppc_insn::PPC_INS_QVSTFCDXA,
            501 => ppc_insn::PPC_INS_QVSTFCDXI,
            502 => ppc_insn::PPC_INS_QVSTFCDXIA,
            503 => ppc_insn::PPC_INS_QVSTFCSUX,
            504 => ppc_insn::PPC_INS_QVSTFCSUXA,
            505 => ppc_insn::PPC_INS_QVSTFCSUXI,
            506 => ppc_insn::PPC_INS_QVSTFCSUXIA,
            507 => ppc_insn::PPC_INS_QVSTFCSX,
            508 => ppc_insn::PPC_INS_QVSTFCSXA,
            509 => ppc_insn::PPC_INS_QVSTFCSXI,
            510 => ppc_insn::PPC_INS_QVSTFCSXIA,
            511 => ppc_insn::PPC_INS_QVSTFDUX,
            512 => ppc_insn::PPC_INS_QVSTFDUXA,
            513 => ppc_insn::PPC_INS_QVSTFDUXI,
            514 => ppc_insn::PPC_INS_QVSTFDUXIA,
            515 => ppc_insn::PPC_INS_QVSTFDX,
            516 => ppc_insn::PPC_INS_QVSTFDXA,
            517 => ppc_insn::PPC_INS_QVSTFDXI,
            518 => ppc_insn::PPC_INS_QVSTFDXIA,
            519 => ppc_insn::PPC_INS_QVSTFIWX,
            520 => ppc_insn::PPC_INS_QVSTFIWXA,
            521 => ppc_insn::PPC_INS_QVSTFSUX,
            522 => ppc_insn::PPC_INS_QVSTFSUXA,
            523 => ppc_insn::PPC_INS_QVSTFSUXI,
            524 => ppc_insn::PPC_INS_QVSTFSUXIA,
            525 => ppc_insn::PPC_INS_QVSTFSX,
            526 => ppc_insn::PPC_INS_QVSTFSXA,
            527 => ppc_insn::PPC_INS_QVSTFSXI,
            528 => ppc_insn::PPC_INS_QVSTFSXIA,
            529 => ppc_insn::PPC_INS_RFCI,
            530 => ppc_insn::PPC_INS_RFDI,
            531 => ppc_insn::PPC_INS_RFI,
            532 => ppc_insn::PPC_INS_RFID,
            533 => ppc_insn::PPC_INS_RFMCI,
            534 => ppc_insn::PPC_INS_RLDCL,
            535 => ppc_insn::PPC_INS_RLDCR,
            536 => ppc_insn::PPC_INS_RLDIC,
            537 => ppc_insn::PPC_INS_RLDICL,
            538 => ppc_insn::PPC_INS_RLDICR,
            539 => ppc_insn::PPC_INS_RLDIMI,
            540 => ppc_insn::PPC_INS_RLWIMI,
            541 => ppc_insn::PPC_INS_RLWINM,
            542 => ppc_insn::PPC_INS_RLWNM,
            543 => ppc_insn::PPC_INS_SC,
            544 => ppc_insn::PPC_INS_SLBIA,
            545 => ppc_insn::PPC_INS_SLBIE,
            546 => ppc_insn::PPC_INS_SLBMFEE,
            547 => ppc_insn::PPC_INS_SLBMTE,
            548 => ppc_insn::PPC_INS_SLD,
            549 => ppc_insn::PPC_INS_SLW,
            550 => ppc_insn::PPC_INS_SRAD,
            551 => ppc_insn::PPC_INS_SRADI,
            552 => ppc_insn::PPC_INS_SRAW,
            553 => ppc_insn::PPC_INS_SRAWI,
            554 => ppc_insn::PPC_INS_SRD,
            555 => ppc_insn::PPC_INS_SRW,
            556 => ppc_insn::PPC_INS_STB,
            557 => ppc_insn::PPC_INS_STBCIX,
            558 => ppc_insn::PPC_INS_STBU,
            559 => ppc_insn::PPC_INS_STBUX,
            560 => ppc_insn::PPC_INS_STBX,
            561 => ppc_insn::PPC_INS_STD,
            562 => ppc_insn::PPC_INS_STDBRX,
            563 => ppc_insn::PPC_INS_STDCIX,
            564 => ppc_insn::PPC_INS_STDCX,
            565 => ppc_insn::PPC_INS_STDU,
            566 => ppc_insn::PPC_INS_STDUX,
            567 => ppc_insn::PPC_INS_STDX,
            568 => ppc_insn::PPC_INS_STFD,
            569 => ppc_insn::PPC_INS_STFDU,
            570 => ppc_insn::PPC_INS_STFDUX,
            571 => ppc_insn::PPC_INS_STFDX,
            572 => ppc_insn::PPC_INS_STFIWX,
            573 => ppc_insn::PPC_INS_STFS,
            574 => ppc_insn::PPC_INS_STFSU,
            575 => ppc_insn::PPC_INS_STFSUX,
            576 => ppc_insn::PPC_INS_STFSX,
            577 => ppc_insn::PPC_INS_STH,
            578 => ppc_insn::PPC_INS_STHBRX,
            579 => ppc_insn::PPC_INS_STHCIX,
            580 => ppc_insn::PPC_INS_STHU,
            581 => ppc_insn::PPC_INS_STHUX,
            582 => ppc_insn::PPC_INS_STHX,
            583 => ppc_insn::PPC_INS_STMW,
            584 => ppc_insn::PPC_INS_STSWI,
            585 => ppc_insn::PPC_INS_STVEBX,
            586 => ppc_insn::PPC_INS_STVEHX,
            587 => ppc_insn::PPC_INS_STVEWX,
            588 => ppc_insn::PPC_INS_STVX,
            589 => ppc_insn::PPC_INS_STVXL,
            590 => ppc_insn::PPC_INS_STW,
            591 => ppc_insn::PPC_INS_STWBRX,
            592 => ppc_insn::PPC_INS_STWCIX,
            593 => ppc_insn::PPC_INS_STWCX,
            594 => ppc_insn::PPC_INS_STWU,
            595 => ppc_insn::PPC_INS_STWUX,
            596 => ppc_insn::PPC_INS_STWX,
            597 => ppc_insn::PPC_INS_STXSDX,
            598 => ppc_insn::PPC_INS_STXVD2X,
            599 => ppc_insn::PPC_INS_STXVW4X,
            600 => ppc_insn::PPC_INS_SUBF,
            601 => ppc_insn::PPC_INS_SUBFC,
            602 => ppc_insn::PPC_INS_SUBFE,
            603 => ppc_insn::PPC_INS_SUBFIC,
            604 => ppc_insn::PPC_INS_SUBFME,
            605 => ppc_insn::PPC_INS_SUBFZE,
            606 => ppc_insn::PPC_INS_SYNC,
            607 => ppc_insn::PPC_INS_TD,
            608 => ppc_insn::PPC_INS_TDI,
            609 => ppc_insn::PPC_INS_TLBIA,
            610 => ppc_insn::PPC_INS_TLBIE,
            611 => ppc_insn::PPC_INS_TLBIEL,
            612 => ppc_insn::PPC_INS_TLBIVAX,
            613 => ppc_insn::PPC_INS_TLBLD,
            614 => ppc_insn::PPC_INS_TLBLI,
            615 => ppc_insn::PPC_INS_TLBRE,
            616 => ppc_insn::PPC_INS_TLBSX,
            617 => ppc_insn::PPC_INS_TLBSYNC,
            618 => ppc_insn::PPC_INS_TLBWE,
            619 => ppc_insn::PPC_INS_TRAP,
            620 => ppc_insn::PPC_INS_TW,
            621 => ppc_insn::PPC_INS_TWI,
            622 => ppc_insn::PPC_INS_VADDCUW,
            623 => ppc_insn::PPC_INS_VADDFP,
            624 => ppc_insn::PPC_INS_VADDSBS,
            625 => ppc_insn::PPC_INS_VADDSHS,
            626 => ppc_insn::PPC_INS_VADDSWS,
            627 => ppc_insn::PPC_INS_VADDUBM,
            628 => ppc_insn::PPC_INS_VADDUBS,
            629 => ppc_insn::PPC_INS_VADDUDM,
            630 => ppc_insn::PPC_INS_VADDUHM,
            631 => ppc_insn::PPC_INS_VADDUHS,
            632 => ppc_insn::PPC_INS_VADDUWM,
            633 => ppc_insn::PPC_INS_VADDUWS,
            634 => ppc_insn::PPC_INS_VAND,
            635 => ppc_insn::PPC_INS_VANDC,
            636 => ppc_insn::PPC_INS_VAVGSB,
            637 => ppc_insn::PPC_INS_VAVGSH,
            638 => ppc_insn::PPC_INS_VAVGSW,
            639 => ppc_insn::PPC_INS_VAVGUB,
            640 => ppc_insn::PPC_INS_VAVGUH,
            641 => ppc_insn::PPC_INS_VAVGUW,
            642 => ppc_insn::PPC_INS_VCFSX,
            643 => ppc_insn::PPC_INS_VCFUX,
            644 => ppc_insn::PPC_INS_VCLZB,
            645 => ppc_insn::PPC_INS_VCLZD,
            646 => ppc_insn::PPC_INS_VCLZH,
            647 => ppc_insn::PPC_INS_VCLZW,
            648 => ppc_insn::PPC_INS_VCMPBFP,
            649 => ppc_insn::PPC_INS_VCMPEQFP,
            650 => ppc_insn::PPC_INS_VCMPEQUB,
            651 => ppc_insn::PPC_INS_VCMPEQUD,
            652 => ppc_insn::PPC_INS_VCMPEQUH,
            653 => ppc_insn::PPC_INS_VCMPEQUW,
            654 => ppc_insn::PPC_INS_VCMPGEFP,
            655 => ppc_insn::PPC_INS_VCMPGTFP,
            656 => ppc_insn::PPC_INS_VCMPGTSB,
            657 => ppc_insn::PPC_INS_VCMPGTSD,
            658 => ppc_insn::PPC_INS_VCMPGTSH,
            659 => ppc_insn::PPC_INS_VCMPGTSW,
            660 => ppc_insn::PPC_INS_VCMPGTUB,
            661 => ppc_insn::PPC_INS_VCMPGTUD,
            662 => ppc_insn::PPC_INS_VCMPGTUH,
            663 => ppc_insn::PPC_INS_VCMPGTUW,
            664 => ppc_insn::PPC_INS_VCTSXS,
            665 => ppc_insn::PPC_INS_VCTUXS,
            666 => ppc_insn::PPC_INS_VEQV,
            667 => ppc_insn::PPC_INS_VEXPTEFP,
            668 => ppc_insn::PPC_INS_VLOGEFP,
            669 => ppc_insn::PPC_INS_VMADDFP,
            670 => ppc_insn::PPC_INS_VMAXFP,
            671 => ppc_insn::PPC_INS_VMAXSB,
            672 => ppc_insn::PPC_INS_VMAXSD,
            673 => ppc_insn::PPC_INS_VMAXSH,
            674 => ppc_insn::PPC_INS_VMAXSW,
            675 => ppc_insn::PPC_INS_VMAXUB,
            676 => ppc_insn::PPC_INS_VMAXUD,
            677 => ppc_insn::PPC_INS_VMAXUH,
            678 => ppc_insn::PPC_INS_VMAXUW,
            679 => ppc_insn::PPC_INS_VMHADDSHS,
            680 => ppc_insn::PPC_INS_VMHRADDSHS,
            681 => ppc_insn::PPC_INS_VMINUD,
            682 => ppc_insn::PPC_INS_VMINFP,
            683 => ppc_insn::PPC_INS_VMINSB,
            684 => ppc_insn::PPC_INS_VMINSD,
            685 => ppc_insn::PPC_INS_VMINSH,
            686 => ppc_insn::PPC_INS_VMINSW,
            687 => ppc_insn::PPC_INS_VMINUB,
            688 => ppc_insn::PPC_INS_VMINUH,
            689 => ppc_insn::PPC_INS_VMINUW,
            690 => ppc_insn::PPC_INS_VMLADDUHM,
            691 => ppc_insn::PPC_INS_VMRGHB,
            692 => ppc_insn::PPC_INS_VMRGHH,
            693 => ppc_insn::PPC_INS_VMRGHW,
            694 => ppc_insn::PPC_INS_VMRGLB,
            695 => ppc_insn::PPC_INS_VMRGLH,
            696 => ppc_insn::PPC_INS_VMRGLW,
            697 => ppc_insn::PPC_INS_VMSUMMBM,
            698 => ppc_insn::PPC_INS_VMSUMSHM,
            699 => ppc_insn::PPC_INS_VMSUMSHS,
            700 => ppc_insn::PPC_INS_VMSUMUBM,
            701 => ppc_insn::PPC_INS_VMSUMUHM,
            702 => ppc_insn::PPC_INS_VMSUMUHS,
            703 => ppc_insn::PPC_INS_VMULESB,
            704 => ppc_insn::PPC_INS_VMULESH,
            705 => ppc_insn::PPC_INS_VMULESW,
            706 => ppc_insn::PPC_INS_VMULEUB,
            707 => ppc_insn::PPC_INS_VMULEUH,
            708 => ppc_insn::PPC_INS_VMULEUW,
            709 => ppc_insn::PPC_INS_VMULOSB,
            710 => ppc_insn::PPC_INS_VMULOSH,
            711 => ppc_insn::PPC_INS_VMULOSW,
            712 => ppc_insn::PPC_INS_VMULOUB,
            713 => ppc_insn::PPC_INS_VMULOUH,
            714 => ppc_insn::PPC_INS_VMULOUW,
            715 => ppc_insn::PPC_INS_VMULUWM,
            716 => ppc_insn::PPC_INS_VNAND,
            717 => ppc_insn::PPC_INS_VNMSUBFP,
            718 => ppc_insn::PPC_INS_VNOR,
            719 => ppc_insn::PPC_INS_VOR,
            720 => ppc_insn::PPC_INS_VORC,
            721 => ppc_insn::PPC_INS_VPERM,
            722 => ppc_insn::PPC_INS_VPKPX,
            723 => ppc_insn::PPC_INS_VPKSHSS,
            724 => ppc_insn::PPC_INS_VPKSHUS,
            725 => ppc_insn::PPC_INS_VPKSWSS,
            726 => ppc_insn::PPC_INS_VPKSWUS,
            727 => ppc_insn::PPC_INS_VPKUHUM,
            728 => ppc_insn::PPC_INS_VPKUHUS,
            729 => ppc_insn::PPC_INS_VPKUWUM,
            730 => ppc_insn::PPC_INS_VPKUWUS,
            731 => ppc_insn::PPC_INS_VPOPCNTB,
            732 => ppc_insn::PPC_INS_VPOPCNTD,
            733 => ppc_insn::PPC_INS_VPOPCNTH,
            734 => ppc_insn::PPC_INS_VPOPCNTW,
            735 => ppc_insn::PPC_INS_VREFP,
            736 => ppc_insn::PPC_INS_VRFIM,
            737 => ppc_insn::PPC_INS_VRFIN,
            738 => ppc_insn::PPC_INS_VRFIP,
            739 => ppc_insn::PPC_INS_VRFIZ,
            740 => ppc_insn::PPC_INS_VRLB,
            741 => ppc_insn::PPC_INS_VRLD,
            742 => ppc_insn::PPC_INS_VRLH,
            743 => ppc_insn::PPC_INS_VRLW,
            744 => ppc_insn::PPC_INS_VRSQRTEFP,
            745 => ppc_insn::PPC_INS_VSEL,
            746 => ppc_insn::PPC_INS_VSL,
            747 => ppc_insn::PPC_INS_VSLB,
            748 => ppc_insn::PPC_INS_VSLD,
            749 => ppc_insn::PPC_INS_VSLDOI,
            750 => ppc_insn::PPC_INS_VSLH,
            751 => ppc_insn::PPC_INS_VSLO,
            752 => ppc_insn::PPC_INS_VSLW,
            753 => ppc_insn::PPC_INS_VSPLTB,
            754 => ppc_insn::PPC_INS_VSPLTH,
            755 => ppc_insn::PPC_INS_VSPLTISB,
            756 => ppc_insn::PPC_INS_VSPLTISH,
            757 => ppc_insn::PPC_INS_VSPLTISW,
            758 => ppc_insn::PPC_INS_VSPLTW,
            759 => ppc_insn::PPC_INS_VSR,
            760 => ppc_insn::PPC_INS_VSRAB,
            761 => ppc_insn::PPC_INS_VSRAD,
            762 => ppc_insn::PPC_INS_VSRAH,
            763 => ppc_insn::PPC_INS_VSRAW,
            764 => ppc_insn::PPC_INS_VSRB,
            765 => ppc_insn::PPC_INS_VSRD,
            766 => ppc_insn::PPC_INS_VSRH,
            767 => ppc_insn::PPC_INS_VSRO,
            768 => ppc_insn::PPC_INS_VSRW,
            769 => ppc_insn::PPC_INS_VSUBCUW,
            770 => ppc_insn::PPC_INS_VSUBFP,
            771 => ppc_insn::PPC_INS_VSUBSBS,
            772 => ppc_insn::PPC_INS_VSUBSHS,
            773 => ppc_insn::PPC_INS_VSUBSWS,
            774 => ppc_insn::PPC_INS_VSUBUBM,
            775 => ppc_insn::PPC_INS_VSUBUBS,
            776 => ppc_insn::PPC_INS_VSUBUDM,
            777 => ppc_insn::PPC_INS_VSUBUHM,
            778 => ppc_insn::PPC_INS_VSUBUHS,
            779 => ppc_insn::PPC_INS_VSUBUWM,
            780 => ppc_insn::PPC_INS_VSUBUWS,
            781 => ppc_insn::PPC_INS_VSUM2SWS,
            782 => ppc_insn::PPC_INS_VSUM4SBS,
            783 => ppc_insn::PPC_INS_VSUM4SHS,
            784 => ppc_insn::PPC_INS_VSUM4UBS,
            785 => ppc_insn::PPC_INS_VSUMSWS,
            786 => ppc_insn::PPC_INS_VUPKHPX,
            787 => ppc_insn::PPC_INS_VUPKHSB,
            788 => ppc_insn::PPC_INS_VUPKHSH,
            789 => ppc_insn::PPC_INS_VUPKLPX,
            790 => ppc_insn::PPC_INS_VUPKLSB,
            791 => ppc_insn::PPC_INS_VUPKLSH,
            792 => ppc_insn::PPC_INS_VXOR,
            793 => ppc_insn::PPC_INS_WAIT,
            794 => ppc_insn::PPC_INS_WRTEE,
            795 => ppc_insn::PPC_INS_WRTEEI,
            796 => ppc_insn::PPC_INS_XOR,
            797 => ppc_insn::PPC_INS_XORI,
            798 => ppc_insn::PPC_INS_XORIS,
            799 => ppc_insn::PPC_INS_XSABSDP,
            800 => ppc_insn::PPC_INS_XSADDDP,
            801 => ppc_insn::PPC_INS_XSCMPODP,
            802 => ppc_insn::PPC_INS_XSCMPUDP,
            803 => ppc_insn::PPC_INS_XSCPSGNDP,
            804 => ppc_insn::PPC_INS_XSCVDPSP,
            805 => ppc_insn::PPC_INS_XSCVDPSXDS,
            806 => ppc_insn::PPC_INS_XSCVDPSXWS,
            807 => ppc_insn::PPC_INS_XSCVDPUXDS,
            808 => ppc_insn::PPC_INS_XSCVDPUXWS,
            809 => ppc_insn::PPC_INS_XSCVSPDP,
            810 => ppc_insn::PPC_INS_XSCVSXDDP,
            811 => ppc_insn::PPC_INS_XSCVUXDDP,
            812 => ppc_insn::PPC_INS_XSDIVDP,
            813 => ppc_insn::PPC_INS_XSMADDADP,
            814 => ppc_insn::PPC_INS_XSMADDMDP,
            815 => ppc_insn::PPC_INS_XSMAXDP,
            816 => ppc_insn::PPC_INS_XSMINDP,
            817 => ppc_insn::PPC_INS_XSMSUBADP,
            818 => ppc_insn::PPC_INS_XSMSUBMDP,
            819 => ppc_insn::PPC_INS_XSMULDP,
            820 => ppc_insn::PPC_INS_XSNABSDP,
            821 => ppc_insn::PPC_INS_XSNEGDP,
            822 => ppc_insn::PPC_INS_XSNMADDADP,
            823 => ppc_insn::PPC_INS_XSNMADDMDP,
            824 => ppc_insn::PPC_INS_XSNMSUBADP,
            825 => ppc_insn::PPC_INS_XSNMSUBMDP,
            826 => ppc_insn::PPC_INS_XSRDPI,
            827 => ppc_insn::PPC_INS_XSRDPIC,
            828 => ppc_insn::PPC_INS_XSRDPIM,
            829 => ppc_insn::PPC_INS_XSRDPIP,
            830 => ppc_insn::PPC_INS_XSRDPIZ,
            831 => ppc_insn::PPC_INS_XSREDP,
            832 => ppc_insn::PPC_INS_XSRSQRTEDP,
            833 => ppc_insn::PPC_INS_XSSQRTDP,
            834 => ppc_insn::PPC_INS_XSSUBDP,
            835 => ppc_insn::PPC_INS_XSTDIVDP,
            836 => ppc_insn::PPC_INS_XSTSQRTDP,
            837 => ppc_insn::PPC_INS_XVABSDP,
            838 => ppc_insn::PPC_INS_XVABSSP,
            839 => ppc_insn::PPC_INS_XVADDDP,
            840 => ppc_insn::PPC_INS_XVADDSP,
            841 => ppc_insn::PPC_INS_XVCMPEQDP,
            842 => ppc_insn::PPC_INS_XVCMPEQSP,
            843 => ppc_insn::PPC_INS_XVCMPGEDP,
            844 => ppc_insn::PPC_INS_XVCMPGESP,
            845 => ppc_insn::PPC_INS_XVCMPGTDP,
            846 => ppc_insn::PPC_INS_XVCMPGTSP,
            847 => ppc_insn::PPC_INS_XVCPSGNDP,
            848 => ppc_insn::PPC_INS_XVCPSGNSP,
            849 => ppc_insn::PPC_INS_XVCVDPSP,
            850 => ppc_insn::PPC_INS_XVCVDPSXDS,
            851 => ppc_insn::PPC_INS_XVCVDPSXWS,
            852 => ppc_insn::PPC_INS_XVCVDPUXDS,
            853 => ppc_insn::PPC_INS_XVCVDPUXWS,
            854 => ppc_insn::PPC_INS_XVCVSPDP,
            855 => ppc_insn::PPC_INS_XVCVSPSXDS,
            856 => ppc_insn::PPC_INS_XVCVSPSXWS,
            857 => ppc_insn::PPC_INS_XVCVSPUXDS,
            858 => ppc_insn::PPC_INS_XVCVSPUXWS,
            859 => ppc_insn::PPC_INS_XVCVSXDDP,
            860 => ppc_insn::PPC_INS_XVCVSXDSP,
            861 => ppc_insn::PPC_INS_XVCVSXWDP,
            862 => ppc_insn::PPC_INS_XVCVSXWSP,
            863 => ppc_insn::PPC_INS_XVCVUXDDP,
            864 => ppc_insn::PPC_INS_XVCVUXDSP,
            865 => ppc_insn::PPC_INS_XVCVUXWDP,
            866 => ppc_insn::PPC_INS_XVCVUXWSP,
            867 => ppc_insn::PPC_INS_XVDIVDP,
            868 => ppc_insn::PPC_INS_XVDIVSP,
            869 => ppc_insn::PPC_INS_XVMADDADP,
            870 => ppc_insn::PPC_INS_XVMADDASP,
            871 => ppc_insn::PPC_INS_XVMADDMDP,
            872 => ppc_insn::PPC_INS_XVMADDMSP,
            873 => ppc_insn::PPC_INS_XVMAXDP,
            874 => ppc_insn::PPC_INS_XVMAXSP,
            875 => ppc_insn::PPC_INS_XVMINDP,
            876 => ppc_insn::PPC_INS_XVMINSP,
            877 => ppc_insn::PPC_INS_XVMSUBADP,
            878 => ppc_insn::PPC_INS_XVMSUBASP,
            879 => ppc_insn::PPC_INS_XVMSUBMDP,
            880 => ppc_insn::PPC_INS_XVMSUBMSP,
            881 => ppc_insn::PPC_INS_XVMULDP,
            882 => ppc_insn::PPC_INS_XVMULSP,
            883 => ppc_insn::PPC_INS_XVNABSDP,
            884 => ppc_insn::PPC_INS_XVNABSSP,
            885 => ppc_insn::PPC_INS_XVNEGDP,
            886 => ppc_insn::PPC_INS_XVNEGSP,
            887 => ppc_insn::PPC_INS_XVNMADDADP,
            888 => ppc_insn::PPC_INS_XVNMADDASP,
            889 => ppc_insn::PPC_INS_XVNMADDMDP,
            890 => ppc_insn::PPC_INS_XVNMADDMSP,
            891 => ppc_insn::PPC_INS_XVNMSUBADP,
            892 => ppc_insn::PPC_INS_XVNMSUBASP,
            893 => ppc_insn::PPC_INS_XVNMSUBMDP,
            894 => ppc_insn::PPC_INS_XVNMSUBMSP,
            895 => ppc_insn::PPC_INS_XVRDPI,
            896 => ppc_insn::PPC_INS_XVRDPIC,
            897 => ppc_insn::PPC_INS_XVRDPIM,
            898 => ppc_insn::PPC_INS_XVRDPIP,
            899 => ppc_insn::PPC_INS_XVRDPIZ,
            900 => ppc_insn::PPC_INS_XVREDP,
            901 => ppc_insn::PPC_INS_XVRESP,
            902 => ppc_insn::PPC_INS_XVRSPI,
            903 => ppc_insn::PPC_INS_XVRSPIC,
            904 => ppc_insn::PPC_INS_XVRSPIM,
            905 => ppc_insn::PPC_INS_XVRSPIP,
            906 => ppc_insn::PPC_INS_XVRSPIZ,
            907 => ppc_insn::PPC_INS_XVRSQRTEDP,
            908 => ppc_insn::PPC_INS_XVRSQRTESP,
            909 => ppc_insn::PPC_INS_XVSQRTDP,
            910 => ppc_insn::PPC_INS_XVSQRTSP,
            911 => ppc_insn::PPC_INS_XVSUBDP,
            912 => ppc_insn::PPC_INS_XVSUBSP,
            913 => ppc_insn::PPC_INS_XVTDIVDP,
            914 => ppc_insn::PPC_INS_XVTDIVSP,
            915 => ppc_insn::PPC_INS_XVTSQRTDP,
            916 => ppc_insn::PPC_INS_XVTSQRTSP,
            917 => ppc_insn::PPC_INS_XXLAND,
            918 => ppc_insn::PPC_INS_XXLANDC,
            919 => ppc_insn::PPC_INS_XXLEQV,
            920 => ppc_insn::PPC_INS_XXLNAND,
            921 => ppc_insn::PPC_INS_XXLNOR,
            922 => ppc_insn::PPC_INS_XXLOR,
            923 => ppc_insn::PPC_INS_XXLORC,
            924 => ppc_insn::PPC_INS_XXLXOR,
            925 => ppc_insn::PPC_INS_XXMRGHW,
            926 => ppc_insn::PPC_INS_XXMRGLW,
            927 => ppc_insn::PPC_INS_XXPERMDI,
            928 => ppc_insn::PPC_INS_XXSEL,
            929 => ppc_insn::PPC_INS_XXSLDWI,
            930 => ppc_insn::PPC_INS_XXSPLTW,
            931 => ppc_insn::PPC_INS_BCA,
            932 => ppc_insn::PPC_INS_BCLA,
            933 => ppc_insn::PPC_INS_SLWI,
            934 => ppc_insn::PPC_INS_SRWI,
            935 => ppc_insn::PPC_INS_SLDI,
            936 => ppc_insn::PPC_INS_BTA,
            937 => ppc_insn::PPC_INS_CRSET,
            938 => ppc_insn::PPC_INS_CRNOT,
            939 => ppc_insn::PPC_INS_CRMOVE,
            940 => ppc_insn::PPC_INS_CRCLR,
            941 => ppc_insn::PPC_INS_MFBR0,
            942 => ppc_insn::PPC_INS_MFBR1,
            943 => ppc_insn::PPC_INS_MFBR2,
            944 => ppc_insn::PPC_INS_MFBR3,
            945 => ppc_insn::PPC_INS_MFBR4,
            946 => ppc_insn::PPC_INS_MFBR5,
            947 => ppc_insn::PPC_INS_MFBR6,
            948 => ppc_insn::PPC_INS_MFBR7,
            949 => ppc_insn::PPC_INS_MFXER,
            950 => ppc_insn::PPC_INS_MFRTCU,
            951 => ppc_insn::PPC_INS_MFRTCL,
            952 => ppc_insn::PPC_INS_MFDSCR,
            953 => ppc_insn::PPC_INS_MFDSISR,
            954 => ppc_insn::PPC_INS_MFDAR,
            955 => ppc_insn::PPC_INS_MFSRR2,
            956 => ppc_insn::PPC_INS_MFSRR3,
            957 => ppc_insn::PPC_INS_MFCFAR,
            958 => ppc_insn::PPC_INS_MFAMR,
            959 => ppc_insn::PPC_INS_MFPID,
            960 => ppc_insn::PPC_INS_MFTBLO,
            961 => ppc_insn::PPC_INS_MFTBHI,
            962 => ppc_insn::PPC_INS_MFDBATU,
            963 => ppc_insn::PPC_INS_MFDBATL,
            964 => ppc_insn::PPC_INS_MFIBATU,
            965 => ppc_insn::PPC_INS_MFIBATL,
            966 => ppc_insn::PPC_INS_MFDCCR,
            967 => ppc_insn::PPC_INS_MFICCR,
            968 => ppc_insn::PPC_INS_MFDEAR,
            969 => ppc_insn::PPC_INS_MFESR,
            970 => ppc_insn::PPC_INS_MFSPEFSCR,
            971 => ppc_insn::PPC_INS_MFTCR,
            972 => ppc_insn::PPC_INS_MFASR,
            973 => ppc_insn::PPC_INS_MFPVR,
            974 => ppc_insn::PPC_INS_MFTBU,
            975 => ppc_insn::PPC_INS_MTCR,
            976 => ppc_insn::PPC_INS_MTBR0,
            977 => ppc_insn::PPC_INS_MTBR1,
            978 => ppc_insn::PPC_INS_MTBR2,
            979 => ppc_insn::PPC_INS_MTBR3,
            980 => ppc_insn::PPC_INS_MTBR4,
            981 => ppc_insn::PPC_INS_MTBR5,
            982 => ppc_insn::PPC_INS_MTBR6,
            983 => ppc_insn::PPC_INS_MTBR7,
            984 => ppc_insn::PPC_INS_MTXER,
            985 => ppc_insn::PPC_INS_MTDSCR,
            986 => ppc_insn::PPC_INS_MTDSISR,
            987 => ppc_insn::PPC_INS_MTDAR,
            988 => ppc_insn::PPC_INS_MTSRR2,
            989 => ppc_insn::PPC_INS_MTSRR3,
            990 => ppc_insn::PPC_INS_MTCFAR,
            991 => ppc_insn::PPC_INS_MTAMR,
            992 => ppc_insn::PPC_INS_MTPID,
            993 => ppc_insn::PPC_INS_MTTBL,
            994 => ppc_insn::PPC_INS_MTTBU,
            995 => ppc_insn::PPC_INS_MTTBLO,
            996 => ppc_insn::PPC_INS_MTTBHI,
            997 => ppc_insn::PPC_INS_MTDBATU,
            998 => ppc_insn::PPC_INS_MTDBATL,
            999 => ppc_insn::PPC_INS_MTIBATU,
            1000 => ppc_insn::PPC_INS_MTIBATL,
            1001 => ppc_insn::PPC_INS_MTDCCR,
            1002 => ppc_insn::PPC_INS_MTICCR,
            1003 => ppc_insn::PPC_INS_MTDEAR,
            1004 => ppc_insn::PPC_INS_MTESR,
            1005 => ppc_insn::PPC_INS_MTSPEFSCR,
            1006 => ppc_insn::PPC_INS_MTTCR,
            1007 => ppc_insn::PPC_INS_NOT,
            1008 => ppc_insn::PPC_INS_MR,
            1009 => ppc_insn::PPC_INS_ROTLD,
            1010 => ppc_insn::PPC_INS_ROTLDI,
            1011 => ppc_insn::PPC_INS_CLRLDI,
            1012 => ppc_insn::PPC_INS_ROTLWI,
            1013 => ppc_insn::PPC_INS_CLRLWI,
            1014 => ppc_insn::PPC_INS_ROTLW,
            1015 => ppc_insn::PPC_INS_SUB,
            1016 => ppc_insn::PPC_INS_SUBC,
            1017 => ppc_insn::PPC_INS_LWSYNC,
            1018 => ppc_insn::PPC_INS_PTESYNC,
            1019 => ppc_insn::PPC_INS_TDLT,
            1020 => ppc_insn::PPC_INS_TDEQ,
            1021 => ppc_insn::PPC_INS_TDGT,
            1022 => ppc_insn::PPC_INS_TDNE,
            1023 => ppc_insn::PPC_INS_TDLLT,
            1024 => ppc_insn::PPC_INS_TDLGT,
            1025 => ppc_insn::PPC_INS_TDU,
            1026 => ppc_insn::PPC_INS_TDLTI,
            1027 => ppc_insn::PPC_INS_TDEQI,
            1028 => ppc_insn::PPC_INS_TDGTI,
            1029 => ppc_insn::PPC_INS_TDNEI,
            1030 => ppc_insn::PPC_INS_TDLLTI,
            1031 => ppc_insn::PPC_INS_TDLGTI,
            1032 => ppc_insn::PPC_INS_TDUI,
            1033 => ppc_insn::PPC_INS_TLBREHI,
            1034 => ppc_insn::PPC_INS_TLBRELO,
            1035 => ppc_insn::PPC_INS_TLBWEHI,
            1036 => ppc_insn::PPC_INS_TLBWELO,
            1037 => ppc_insn::PPC_INS_TWLT,
            1038 => ppc_insn::PPC_INS_TWEQ,
            1039 => ppc_insn::PPC_INS_TWGT,
            1040 => ppc_insn::PPC_INS_TWNE,
            1041 => ppc_insn::PPC_INS_TWLLT,
            1042 => ppc_insn::PPC_INS_TWLGT,
            1043 => ppc_insn::PPC_INS_TWU,
            1044 => ppc_insn::PPC_INS_TWLTI,
            1045 => ppc_insn::PPC_INS_TWEQI,
            1046 => ppc_insn::PPC_INS_TWGTI,
            1047 => ppc_insn::PPC_INS_TWNEI,
            1048 => ppc_insn::PPC_INS_TWLLTI,
            1049 => ppc_insn::PPC_INS_TWLGTI,
            1050 => ppc_insn::PPC_INS_TWUI,
            1051 => ppc_insn::PPC_INS_WAITRSV,
            1052 => ppc_insn::PPC_INS_WAITIMPL,
            1053 => ppc_insn::PPC_INS_XNOP,
            1054 => ppc_insn::PPC_INS_XVMOVDP,
            1055 => ppc_insn::PPC_INS_XVMOVSP,
            1056 => ppc_insn::PPC_INS_XXSPLTD,
            1057 => ppc_insn::PPC_INS_XXMRGHD,
            1058 => ppc_insn::PPC_INS_XXMRGLD,
            1059 => ppc_insn::PPC_INS_XXSWAPD,
            1060 => ppc_insn::PPC_INS_BT,
            1061 => ppc_insn::PPC_INS_BF,
            1062 => ppc_insn::PPC_INS_BDNZT,
            1063 => ppc_insn::PPC_INS_BDNZF,
            1064 => ppc_insn::PPC_INS_BDZF,
            1065 => ppc_insn::PPC_INS_BDZT,
            1066 => ppc_insn::PPC_INS_BFA,
            1067 => ppc_insn::PPC_INS_BDNZTA,
            1068 => ppc_insn::PPC_INS_BDNZFA,
            1069 => ppc_insn::PPC_INS_BDZTA,
            1070 => ppc_insn::PPC_INS_BDZFA,
            1071 => ppc_insn::PPC_INS_BTCTR,
            1072 => ppc_insn::PPC_INS_BFCTR,
            1073 => ppc_insn::PPC_INS_BTCTRL,
            1074 => ppc_insn::PPC_INS_BFCTRL,
            1075 => ppc_insn::PPC_INS_BTL,
            1076 => ppc_insn::PPC_INS_BFL,
            1077 => ppc_insn::PPC_INS_BDNZTL,
            1078 => ppc_insn::PPC_INS_BDNZFL,
            1079 => ppc_insn::PPC_INS_BDZTL,
            1080 => ppc_insn::PPC_INS_BDZFL,
            1081 => ppc_insn::PPC_INS_BTLA,
            1082 => ppc_insn::PPC_INS_BFLA,
            1083 => ppc_insn::PPC_INS_BDNZTLA,
            1084 => ppc_insn::PPC_INS_BDNZFLA,
            1085 => ppc_insn::PPC_INS_BDZTLA,
            1086 => ppc_insn::PPC_INS_BDZFLA,
            1087 => ppc_insn::PPC_INS_BTLR,
            1088 => ppc_insn::PPC_INS_BFLR,
            1089 => ppc_insn::PPC_INS_BDNZTLR,
            1090 => ppc_insn::PPC_INS_BDZTLR,
            1091 => ppc_insn::PPC_INS_BDZFLR,
            1092 => ppc_insn::PPC_INS_BTLRL,
            1093 => ppc_insn::PPC_INS_BFLRL,
            1094 => ppc_insn::PPC_INS_BDNZTLRL,
            1095 => ppc_insn::PPC_INS_BDNZFLRL,
            1096 => ppc_insn::PPC_INS_BDZTLRL,
            1097 => ppc_insn::PPC_INS_BDZFLRL,
            1098 => ppc_insn::PPC_INS_QVFAND,
            1099 => ppc_insn::PPC_INS_QVFCLR,
            1100 => ppc_insn::PPC_INS_QVFANDC,
            1101 => ppc_insn::PPC_INS_QVFCTFB,
            1102 => ppc_insn::PPC_INS_QVFXOR,
            1103 => ppc_insn::PPC_INS_QVFOR,
            1104 => ppc_insn::PPC_INS_QVFNOR,
            1105 => ppc_insn::PPC_INS_QVFEQU,
            1106 => ppc_insn::PPC_INS_QVFNOT,
            1107 => ppc_insn::PPC_INS_QVFORC,
            1108 => ppc_insn::PPC_INS_QVFNAND,
            1109 => ppc_insn::PPC_INS_QVFSET,
            1110 => ppc_insn::PPC_INS_ENDING,
            _ => ppc_insn::PPC_INS_INVALID,
        }
    }
}
impl From<u32> for sparc_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => sparc_insn::SPARC_INS_INVALID,
            1 => sparc_insn::SPARC_INS_ADDCC,
            2 => sparc_insn::SPARC_INS_ADDX,
            3 => sparc_insn::SPARC_INS_ADDXCC,
            4 => sparc_insn::SPARC_INS_ADDXC,
            5 => sparc_insn::SPARC_INS_ADDXCCC,
            6 => sparc_insn::SPARC_INS_ADD,
            7 => sparc_insn::SPARC_INS_ALIGNADDR,
            8 => sparc_insn::SPARC_INS_ALIGNADDRL,
            9 => sparc_insn::SPARC_INS_ANDCC,
            10 => sparc_insn::SPARC_INS_ANDNCC,
            11 => sparc_insn::SPARC_INS_ANDN,
            12 => sparc_insn::SPARC_INS_AND,
            13 => sparc_insn::SPARC_INS_ARRAY16,
            14 => sparc_insn::SPARC_INS_ARRAY32,
            15 => sparc_insn::SPARC_INS_ARRAY8,
            16 => sparc_insn::SPARC_INS_B,
            17 => sparc_insn::SPARC_INS_JMP,
            18 => sparc_insn::SPARC_INS_BMASK,
            19 => sparc_insn::SPARC_INS_FB,
            20 => sparc_insn::SPARC_INS_BRGEZ,
            21 => sparc_insn::SPARC_INS_BRGZ,
            22 => sparc_insn::SPARC_INS_BRLEZ,
            23 => sparc_insn::SPARC_INS_BRLZ,
            24 => sparc_insn::SPARC_INS_BRNZ,
            25 => sparc_insn::SPARC_INS_BRZ,
            26 => sparc_insn::SPARC_INS_BSHUFFLE,
            27 => sparc_insn::SPARC_INS_CALL,
            28 => sparc_insn::SPARC_INS_CASX,
            29 => sparc_insn::SPARC_INS_CAS,
            30 => sparc_insn::SPARC_INS_CMASK16,
            31 => sparc_insn::SPARC_INS_CMASK32,
            32 => sparc_insn::SPARC_INS_CMASK8,
            33 => sparc_insn::SPARC_INS_CMP,
            34 => sparc_insn::SPARC_INS_EDGE16,
            35 => sparc_insn::SPARC_INS_EDGE16L,
            36 => sparc_insn::SPARC_INS_EDGE16LN,
            37 => sparc_insn::SPARC_INS_EDGE16N,
            38 => sparc_insn::SPARC_INS_EDGE32,
            39 => sparc_insn::SPARC_INS_EDGE32L,
            40 => sparc_insn::SPARC_INS_EDGE32LN,
            41 => sparc_insn::SPARC_INS_EDGE32N,
            42 => sparc_insn::SPARC_INS_EDGE8,
            43 => sparc_insn::SPARC_INS_EDGE8L,
            44 => sparc_insn::SPARC_INS_EDGE8LN,
            45 => sparc_insn::SPARC_INS_EDGE8N,
            46 => sparc_insn::SPARC_INS_FABSD,
            47 => sparc_insn::SPARC_INS_FABSQ,
            48 => sparc_insn::SPARC_INS_FABSS,
            49 => sparc_insn::SPARC_INS_FADDD,
            50 => sparc_insn::SPARC_INS_FADDQ,
            51 => sparc_insn::SPARC_INS_FADDS,
            52 => sparc_insn::SPARC_INS_FALIGNDATA,
            53 => sparc_insn::SPARC_INS_FAND,
            54 => sparc_insn::SPARC_INS_FANDNOT1,
            55 => sparc_insn::SPARC_INS_FANDNOT1S,
            56 => sparc_insn::SPARC_INS_FANDNOT2,
            57 => sparc_insn::SPARC_INS_FANDNOT2S,
            58 => sparc_insn::SPARC_INS_FANDS,
            59 => sparc_insn::SPARC_INS_FCHKSM16,
            60 => sparc_insn::SPARC_INS_FCMPD,
            61 => sparc_insn::SPARC_INS_FCMPEQ16,
            62 => sparc_insn::SPARC_INS_FCMPEQ32,
            63 => sparc_insn::SPARC_INS_FCMPGT16,
            64 => sparc_insn::SPARC_INS_FCMPGT32,
            65 => sparc_insn::SPARC_INS_FCMPLE16,
            66 => sparc_insn::SPARC_INS_FCMPLE32,
            67 => sparc_insn::SPARC_INS_FCMPNE16,
            68 => sparc_insn::SPARC_INS_FCMPNE32,
            69 => sparc_insn::SPARC_INS_FCMPQ,
            70 => sparc_insn::SPARC_INS_FCMPS,
            71 => sparc_insn::SPARC_INS_FDIVD,
            72 => sparc_insn::SPARC_INS_FDIVQ,
            73 => sparc_insn::SPARC_INS_FDIVS,
            74 => sparc_insn::SPARC_INS_FDMULQ,
            75 => sparc_insn::SPARC_INS_FDTOI,
            76 => sparc_insn::SPARC_INS_FDTOQ,
            77 => sparc_insn::SPARC_INS_FDTOS,
            78 => sparc_insn::SPARC_INS_FDTOX,
            79 => sparc_insn::SPARC_INS_FEXPAND,
            80 => sparc_insn::SPARC_INS_FHADDD,
            81 => sparc_insn::SPARC_INS_FHADDS,
            82 => sparc_insn::SPARC_INS_FHSUBD,
            83 => sparc_insn::SPARC_INS_FHSUBS,
            84 => sparc_insn::SPARC_INS_FITOD,
            85 => sparc_insn::SPARC_INS_FITOQ,
            86 => sparc_insn::SPARC_INS_FITOS,
            87 => sparc_insn::SPARC_INS_FLCMPD,
            88 => sparc_insn::SPARC_INS_FLCMPS,
            89 => sparc_insn::SPARC_INS_FLUSHW,
            90 => sparc_insn::SPARC_INS_FMEAN16,
            91 => sparc_insn::SPARC_INS_FMOVD,
            92 => sparc_insn::SPARC_INS_FMOVQ,
            93 => sparc_insn::SPARC_INS_FMOVRDGEZ,
            94 => sparc_insn::SPARC_INS_FMOVRQGEZ,
            95 => sparc_insn::SPARC_INS_FMOVRSGEZ,
            96 => sparc_insn::SPARC_INS_FMOVRDGZ,
            97 => sparc_insn::SPARC_INS_FMOVRQGZ,
            98 => sparc_insn::SPARC_INS_FMOVRSGZ,
            99 => sparc_insn::SPARC_INS_FMOVRDLEZ,
            100 => sparc_insn::SPARC_INS_FMOVRQLEZ,
            101 => sparc_insn::SPARC_INS_FMOVRSLEZ,
            102 => sparc_insn::SPARC_INS_FMOVRDLZ,
            103 => sparc_insn::SPARC_INS_FMOVRQLZ,
            104 => sparc_insn::SPARC_INS_FMOVRSLZ,
            105 => sparc_insn::SPARC_INS_FMOVRDNZ,
            106 => sparc_insn::SPARC_INS_FMOVRQNZ,
            107 => sparc_insn::SPARC_INS_FMOVRSNZ,
            108 => sparc_insn::SPARC_INS_FMOVRDZ,
            109 => sparc_insn::SPARC_INS_FMOVRQZ,
            110 => sparc_insn::SPARC_INS_FMOVRSZ,
            111 => sparc_insn::SPARC_INS_FMOVS,
            112 => sparc_insn::SPARC_INS_FMUL8SUX16,
            113 => sparc_insn::SPARC_INS_FMUL8ULX16,
            114 => sparc_insn::SPARC_INS_FMUL8X16,
            115 => sparc_insn::SPARC_INS_FMUL8X16AL,
            116 => sparc_insn::SPARC_INS_FMUL8X16AU,
            117 => sparc_insn::SPARC_INS_FMULD,
            118 => sparc_insn::SPARC_INS_FMULD8SUX16,
            119 => sparc_insn::SPARC_INS_FMULD8ULX16,
            120 => sparc_insn::SPARC_INS_FMULQ,
            121 => sparc_insn::SPARC_INS_FMULS,
            122 => sparc_insn::SPARC_INS_FNADDD,
            123 => sparc_insn::SPARC_INS_FNADDS,
            124 => sparc_insn::SPARC_INS_FNAND,
            125 => sparc_insn::SPARC_INS_FNANDS,
            126 => sparc_insn::SPARC_INS_FNEGD,
            127 => sparc_insn::SPARC_INS_FNEGQ,
            128 => sparc_insn::SPARC_INS_FNEGS,
            129 => sparc_insn::SPARC_INS_FNHADDD,
            130 => sparc_insn::SPARC_INS_FNHADDS,
            131 => sparc_insn::SPARC_INS_FNOR,
            132 => sparc_insn::SPARC_INS_FNORS,
            133 => sparc_insn::SPARC_INS_FNOT1,
            134 => sparc_insn::SPARC_INS_FNOT1S,
            135 => sparc_insn::SPARC_INS_FNOT2,
            136 => sparc_insn::SPARC_INS_FNOT2S,
            137 => sparc_insn::SPARC_INS_FONE,
            138 => sparc_insn::SPARC_INS_FONES,
            139 => sparc_insn::SPARC_INS_FOR,
            140 => sparc_insn::SPARC_INS_FORNOT1,
            141 => sparc_insn::SPARC_INS_FORNOT1S,
            142 => sparc_insn::SPARC_INS_FORNOT2,
            143 => sparc_insn::SPARC_INS_FORNOT2S,
            144 => sparc_insn::SPARC_INS_FORS,
            145 => sparc_insn::SPARC_INS_FPACK16,
            146 => sparc_insn::SPARC_INS_FPACK32,
            147 => sparc_insn::SPARC_INS_FPACKFIX,
            148 => sparc_insn::SPARC_INS_FPADD16,
            149 => sparc_insn::SPARC_INS_FPADD16S,
            150 => sparc_insn::SPARC_INS_FPADD32,
            151 => sparc_insn::SPARC_INS_FPADD32S,
            152 => sparc_insn::SPARC_INS_FPADD64,
            153 => sparc_insn::SPARC_INS_FPMERGE,
            154 => sparc_insn::SPARC_INS_FPSUB16,
            155 => sparc_insn::SPARC_INS_FPSUB16S,
            156 => sparc_insn::SPARC_INS_FPSUB32,
            157 => sparc_insn::SPARC_INS_FPSUB32S,
            158 => sparc_insn::SPARC_INS_FQTOD,
            159 => sparc_insn::SPARC_INS_FQTOI,
            160 => sparc_insn::SPARC_INS_FQTOS,
            161 => sparc_insn::SPARC_INS_FQTOX,
            162 => sparc_insn::SPARC_INS_FSLAS16,
            163 => sparc_insn::SPARC_INS_FSLAS32,
            164 => sparc_insn::SPARC_INS_FSLL16,
            165 => sparc_insn::SPARC_INS_FSLL32,
            166 => sparc_insn::SPARC_INS_FSMULD,
            167 => sparc_insn::SPARC_INS_FSQRTD,
            168 => sparc_insn::SPARC_INS_FSQRTQ,
            169 => sparc_insn::SPARC_INS_FSQRTS,
            170 => sparc_insn::SPARC_INS_FSRA16,
            171 => sparc_insn::SPARC_INS_FSRA32,
            172 => sparc_insn::SPARC_INS_FSRC1,
            173 => sparc_insn::SPARC_INS_FSRC1S,
            174 => sparc_insn::SPARC_INS_FSRC2,
            175 => sparc_insn::SPARC_INS_FSRC2S,
            176 => sparc_insn::SPARC_INS_FSRL16,
            177 => sparc_insn::SPARC_INS_FSRL32,
            178 => sparc_insn::SPARC_INS_FSTOD,
            179 => sparc_insn::SPARC_INS_FSTOI,
            180 => sparc_insn::SPARC_INS_FSTOQ,
            181 => sparc_insn::SPARC_INS_FSTOX,
            182 => sparc_insn::SPARC_INS_FSUBD,
            183 => sparc_insn::SPARC_INS_FSUBQ,
            184 => sparc_insn::SPARC_INS_FSUBS,
            185 => sparc_insn::SPARC_INS_FXNOR,
            186 => sparc_insn::SPARC_INS_FXNORS,
            187 => sparc_insn::SPARC_INS_FXOR,
            188 => sparc_insn::SPARC_INS_FXORS,
            189 => sparc_insn::SPARC_INS_FXTOD,
            190 => sparc_insn::SPARC_INS_FXTOQ,
            191 => sparc_insn::SPARC_INS_FXTOS,
            192 => sparc_insn::SPARC_INS_FZERO,
            193 => sparc_insn::SPARC_INS_FZEROS,
            194 => sparc_insn::SPARC_INS_JMPL,
            195 => sparc_insn::SPARC_INS_LDD,
            196 => sparc_insn::SPARC_INS_LD,
            197 => sparc_insn::SPARC_INS_LDQ,
            198 => sparc_insn::SPARC_INS_LDSB,
            199 => sparc_insn::SPARC_INS_LDSH,
            200 => sparc_insn::SPARC_INS_LDSW,
            201 => sparc_insn::SPARC_INS_LDUB,
            202 => sparc_insn::SPARC_INS_LDUH,
            203 => sparc_insn::SPARC_INS_LDX,
            204 => sparc_insn::SPARC_INS_LZCNT,
            205 => sparc_insn::SPARC_INS_MEMBAR,
            206 => sparc_insn::SPARC_INS_MOVDTOX,
            207 => sparc_insn::SPARC_INS_MOV,
            208 => sparc_insn::SPARC_INS_MOVRGEZ,
            209 => sparc_insn::SPARC_INS_MOVRGZ,
            210 => sparc_insn::SPARC_INS_MOVRLEZ,
            211 => sparc_insn::SPARC_INS_MOVRLZ,
            212 => sparc_insn::SPARC_INS_MOVRNZ,
            213 => sparc_insn::SPARC_INS_MOVRZ,
            214 => sparc_insn::SPARC_INS_MOVSTOSW,
            215 => sparc_insn::SPARC_INS_MOVSTOUW,
            216 => sparc_insn::SPARC_INS_MULX,
            217 => sparc_insn::SPARC_INS_NOP,
            218 => sparc_insn::SPARC_INS_ORCC,
            219 => sparc_insn::SPARC_INS_ORNCC,
            220 => sparc_insn::SPARC_INS_ORN,
            221 => sparc_insn::SPARC_INS_OR,
            222 => sparc_insn::SPARC_INS_PDIST,
            223 => sparc_insn::SPARC_INS_PDISTN,
            224 => sparc_insn::SPARC_INS_POPC,
            225 => sparc_insn::SPARC_INS_RD,
            226 => sparc_insn::SPARC_INS_RESTORE,
            227 => sparc_insn::SPARC_INS_RETT,
            228 => sparc_insn::SPARC_INS_SAVE,
            229 => sparc_insn::SPARC_INS_SDIVCC,
            230 => sparc_insn::SPARC_INS_SDIVX,
            231 => sparc_insn::SPARC_INS_SDIV,
            232 => sparc_insn::SPARC_INS_SETHI,
            233 => sparc_insn::SPARC_INS_SHUTDOWN,
            234 => sparc_insn::SPARC_INS_SIAM,
            235 => sparc_insn::SPARC_INS_SLLX,
            236 => sparc_insn::SPARC_INS_SLL,
            237 => sparc_insn::SPARC_INS_SMULCC,
            238 => sparc_insn::SPARC_INS_SMUL,
            239 => sparc_insn::SPARC_INS_SRAX,
            240 => sparc_insn::SPARC_INS_SRA,
            241 => sparc_insn::SPARC_INS_SRLX,
            242 => sparc_insn::SPARC_INS_SRL,
            243 => sparc_insn::SPARC_INS_STBAR,
            244 => sparc_insn::SPARC_INS_STB,
            245 => sparc_insn::SPARC_INS_STD,
            246 => sparc_insn::SPARC_INS_ST,
            247 => sparc_insn::SPARC_INS_STH,
            248 => sparc_insn::SPARC_INS_STQ,
            249 => sparc_insn::SPARC_INS_STX,
            250 => sparc_insn::SPARC_INS_SUBCC,
            251 => sparc_insn::SPARC_INS_SUBX,
            252 => sparc_insn::SPARC_INS_SUBXCC,
            253 => sparc_insn::SPARC_INS_SUB,
            254 => sparc_insn::SPARC_INS_SWAP,
            255 => sparc_insn::SPARC_INS_TADDCCTV,
            256 => sparc_insn::SPARC_INS_TADDCC,
            257 => sparc_insn::SPARC_INS_T,
            258 => sparc_insn::SPARC_INS_TSUBCCTV,
            259 => sparc_insn::SPARC_INS_TSUBCC,
            260 => sparc_insn::SPARC_INS_UDIVCC,
            261 => sparc_insn::SPARC_INS_UDIVX,
            262 => sparc_insn::SPARC_INS_UDIV,
            263 => sparc_insn::SPARC_INS_UMULCC,
            264 => sparc_insn::SPARC_INS_UMULXHI,
            265 => sparc_insn::SPARC_INS_UMUL,
            266 => sparc_insn::SPARC_INS_UNIMP,
            267 => sparc_insn::SPARC_INS_FCMPED,
            268 => sparc_insn::SPARC_INS_FCMPEQ,
            269 => sparc_insn::SPARC_INS_FCMPES,
            270 => sparc_insn::SPARC_INS_WR,
            271 => sparc_insn::SPARC_INS_XMULX,
            272 => sparc_insn::SPARC_INS_XMULXHI,
            273 => sparc_insn::SPARC_INS_XNORCC,
            274 => sparc_insn::SPARC_INS_XNOR,
            275 => sparc_insn::SPARC_INS_XORCC,
            276 => sparc_insn::SPARC_INS_XOR,
            277 => sparc_insn::SPARC_INS_RET,
            278 => sparc_insn::SPARC_INS_RETL,
            279 => sparc_insn::SPARC_INS_ENDING,
            _ => sparc_insn::SPARC_INS_INVALID,
        }
    }
}
impl From<u32> for sysz_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => sysz_insn::SYSZ_INS_INVALID,
            1 => sysz_insn::SYSZ_INS_A,
            2 => sysz_insn::SYSZ_INS_ADB,
            3 => sysz_insn::SYSZ_INS_ADBR,
            4 => sysz_insn::SYSZ_INS_AEB,
            5 => sysz_insn::SYSZ_INS_AEBR,
            6 => sysz_insn::SYSZ_INS_AFI,
            7 => sysz_insn::SYSZ_INS_AG,
            8 => sysz_insn::SYSZ_INS_AGF,
            9 => sysz_insn::SYSZ_INS_AGFI,
            10 => sysz_insn::SYSZ_INS_AGFR,
            11 => sysz_insn::SYSZ_INS_AGHI,
            12 => sysz_insn::SYSZ_INS_AGHIK,
            13 => sysz_insn::SYSZ_INS_AGR,
            14 => sysz_insn::SYSZ_INS_AGRK,
            15 => sysz_insn::SYSZ_INS_AGSI,
            16 => sysz_insn::SYSZ_INS_AH,
            17 => sysz_insn::SYSZ_INS_AHI,
            18 => sysz_insn::SYSZ_INS_AHIK,
            19 => sysz_insn::SYSZ_INS_AHY,
            20 => sysz_insn::SYSZ_INS_AIH,
            21 => sysz_insn::SYSZ_INS_AL,
            22 => sysz_insn::SYSZ_INS_ALC,
            23 => sysz_insn::SYSZ_INS_ALCG,
            24 => sysz_insn::SYSZ_INS_ALCGR,
            25 => sysz_insn::SYSZ_INS_ALCR,
            26 => sysz_insn::SYSZ_INS_ALFI,
            27 => sysz_insn::SYSZ_INS_ALG,
            28 => sysz_insn::SYSZ_INS_ALGF,
            29 => sysz_insn::SYSZ_INS_ALGFI,
            30 => sysz_insn::SYSZ_INS_ALGFR,
            31 => sysz_insn::SYSZ_INS_ALGHSIK,
            32 => sysz_insn::SYSZ_INS_ALGR,
            33 => sysz_insn::SYSZ_INS_ALGRK,
            34 => sysz_insn::SYSZ_INS_ALHSIK,
            35 => sysz_insn::SYSZ_INS_ALR,
            36 => sysz_insn::SYSZ_INS_ALRK,
            37 => sysz_insn::SYSZ_INS_ALY,
            38 => sysz_insn::SYSZ_INS_AR,
            39 => sysz_insn::SYSZ_INS_ARK,
            40 => sysz_insn::SYSZ_INS_ASI,
            41 => sysz_insn::SYSZ_INS_AXBR,
            42 => sysz_insn::SYSZ_INS_AY,
            43 => sysz_insn::SYSZ_INS_BCR,
            44 => sysz_insn::SYSZ_INS_BRC,
            45 => sysz_insn::SYSZ_INS_BRCL,
            46 => sysz_insn::SYSZ_INS_CGIJ,
            47 => sysz_insn::SYSZ_INS_CGRJ,
            48 => sysz_insn::SYSZ_INS_CIJ,
            49 => sysz_insn::SYSZ_INS_CLGIJ,
            50 => sysz_insn::SYSZ_INS_CLGRJ,
            51 => sysz_insn::SYSZ_INS_CLIJ,
            52 => sysz_insn::SYSZ_INS_CLRJ,
            53 => sysz_insn::SYSZ_INS_CRJ,
            54 => sysz_insn::SYSZ_INS_BER,
            55 => sysz_insn::SYSZ_INS_JE,
            56 => sysz_insn::SYSZ_INS_JGE,
            57 => sysz_insn::SYSZ_INS_LOCE,
            58 => sysz_insn::SYSZ_INS_LOCGE,
            59 => sysz_insn::SYSZ_INS_LOCGRE,
            60 => sysz_insn::SYSZ_INS_LOCRE,
            61 => sysz_insn::SYSZ_INS_STOCE,
            62 => sysz_insn::SYSZ_INS_STOCGE,
            63 => sysz_insn::SYSZ_INS_BHR,
            64 => sysz_insn::SYSZ_INS_BHER,
            65 => sysz_insn::SYSZ_INS_JHE,
            66 => sysz_insn::SYSZ_INS_JGHE,
            67 => sysz_insn::SYSZ_INS_LOCHE,
            68 => sysz_insn::SYSZ_INS_LOCGHE,
            69 => sysz_insn::SYSZ_INS_LOCGRHE,
            70 => sysz_insn::SYSZ_INS_LOCRHE,
            71 => sysz_insn::SYSZ_INS_STOCHE,
            72 => sysz_insn::SYSZ_INS_STOCGHE,
            73 => sysz_insn::SYSZ_INS_JH,
            74 => sysz_insn::SYSZ_INS_JGH,
            75 => sysz_insn::SYSZ_INS_LOCH,
            76 => sysz_insn::SYSZ_INS_LOCGH,
            77 => sysz_insn::SYSZ_INS_LOCGRH,
            78 => sysz_insn::SYSZ_INS_LOCRH,
            79 => sysz_insn::SYSZ_INS_STOCH,
            80 => sysz_insn::SYSZ_INS_STOCGH,
            81 => sysz_insn::SYSZ_INS_CGIJNLH,
            82 => sysz_insn::SYSZ_INS_CGRJNLH,
            83 => sysz_insn::SYSZ_INS_CIJNLH,
            84 => sysz_insn::SYSZ_INS_CLGIJNLH,
            85 => sysz_insn::SYSZ_INS_CLGRJNLH,
            86 => sysz_insn::SYSZ_INS_CLIJNLH,
            87 => sysz_insn::SYSZ_INS_CLRJNLH,
            88 => sysz_insn::SYSZ_INS_CRJNLH,
            89 => sysz_insn::SYSZ_INS_CGIJE,
            90 => sysz_insn::SYSZ_INS_CGRJE,
            91 => sysz_insn::SYSZ_INS_CIJE,
            92 => sysz_insn::SYSZ_INS_CLGIJE,
            93 => sysz_insn::SYSZ_INS_CLGRJE,
            94 => sysz_insn::SYSZ_INS_CLIJE,
            95 => sysz_insn::SYSZ_INS_CLRJE,
            96 => sysz_insn::SYSZ_INS_CRJE,
            97 => sysz_insn::SYSZ_INS_CGIJNLE,
            98 => sysz_insn::SYSZ_INS_CGRJNLE,
            99 => sysz_insn::SYSZ_INS_CIJNLE,
            100 => sysz_insn::SYSZ_INS_CLGIJNLE,
            101 => sysz_insn::SYSZ_INS_CLGRJNLE,
            102 => sysz_insn::SYSZ_INS_CLIJNLE,
            103 => sysz_insn::SYSZ_INS_CLRJNLE,
            104 => sysz_insn::SYSZ_INS_CRJNLE,
            105 => sysz_insn::SYSZ_INS_CGIJH,
            106 => sysz_insn::SYSZ_INS_CGRJH,
            107 => sysz_insn::SYSZ_INS_CIJH,
            108 => sysz_insn::SYSZ_INS_CLGIJH,
            109 => sysz_insn::SYSZ_INS_CLGRJH,
            110 => sysz_insn::SYSZ_INS_CLIJH,
            111 => sysz_insn::SYSZ_INS_CLRJH,
            112 => sysz_insn::SYSZ_INS_CRJH,
            113 => sysz_insn::SYSZ_INS_CGIJNL,
            114 => sysz_insn::SYSZ_INS_CGRJNL,
            115 => sysz_insn::SYSZ_INS_CIJNL,
            116 => sysz_insn::SYSZ_INS_CLGIJNL,
            117 => sysz_insn::SYSZ_INS_CLGRJNL,
            118 => sysz_insn::SYSZ_INS_CLIJNL,
            119 => sysz_insn::SYSZ_INS_CLRJNL,
            120 => sysz_insn::SYSZ_INS_CRJNL,
            121 => sysz_insn::SYSZ_INS_CGIJHE,
            122 => sysz_insn::SYSZ_INS_CGRJHE,
            123 => sysz_insn::SYSZ_INS_CIJHE,
            124 => sysz_insn::SYSZ_INS_CLGIJHE,
            125 => sysz_insn::SYSZ_INS_CLGRJHE,
            126 => sysz_insn::SYSZ_INS_CLIJHE,
            127 => sysz_insn::SYSZ_INS_CLRJHE,
            128 => sysz_insn::SYSZ_INS_CRJHE,
            129 => sysz_insn::SYSZ_INS_CGIJNHE,
            130 => sysz_insn::SYSZ_INS_CGRJNHE,
            131 => sysz_insn::SYSZ_INS_CIJNHE,
            132 => sysz_insn::SYSZ_INS_CLGIJNHE,
            133 => sysz_insn::SYSZ_INS_CLGRJNHE,
            134 => sysz_insn::SYSZ_INS_CLIJNHE,
            135 => sysz_insn::SYSZ_INS_CLRJNHE,
            136 => sysz_insn::SYSZ_INS_CRJNHE,
            137 => sysz_insn::SYSZ_INS_CGIJL,
            138 => sysz_insn::SYSZ_INS_CGRJL,
            139 => sysz_insn::SYSZ_INS_CIJL,
            140 => sysz_insn::SYSZ_INS_CLGIJL,
            141 => sysz_insn::SYSZ_INS_CLGRJL,
            142 => sysz_insn::SYSZ_INS_CLIJL,
            143 => sysz_insn::SYSZ_INS_CLRJL,
            144 => sysz_insn::SYSZ_INS_CRJL,
            145 => sysz_insn::SYSZ_INS_CGIJNH,
            146 => sysz_insn::SYSZ_INS_CGRJNH,
            147 => sysz_insn::SYSZ_INS_CIJNH,
            148 => sysz_insn::SYSZ_INS_CLGIJNH,
            149 => sysz_insn::SYSZ_INS_CLGRJNH,
            150 => sysz_insn::SYSZ_INS_CLIJNH,
            151 => sysz_insn::SYSZ_INS_CLRJNH,
            152 => sysz_insn::SYSZ_INS_CRJNH,
            153 => sysz_insn::SYSZ_INS_CGIJLE,
            154 => sysz_insn::SYSZ_INS_CGRJLE,
            155 => sysz_insn::SYSZ_INS_CIJLE,
            156 => sysz_insn::SYSZ_INS_CLGIJLE,
            157 => sysz_insn::SYSZ_INS_CLGRJLE,
            158 => sysz_insn::SYSZ_INS_CLIJLE,
            159 => sysz_insn::SYSZ_INS_CLRJLE,
            160 => sysz_insn::SYSZ_INS_CRJLE,
            161 => sysz_insn::SYSZ_INS_CGIJNE,
            162 => sysz_insn::SYSZ_INS_CGRJNE,
            163 => sysz_insn::SYSZ_INS_CIJNE,
            164 => sysz_insn::SYSZ_INS_CLGIJNE,
            165 => sysz_insn::SYSZ_INS_CLGRJNE,
            166 => sysz_insn::SYSZ_INS_CLIJNE,
            167 => sysz_insn::SYSZ_INS_CLRJNE,
            168 => sysz_insn::SYSZ_INS_CRJNE,
            169 => sysz_insn::SYSZ_INS_CGIJLH,
            170 => sysz_insn::SYSZ_INS_CGRJLH,
            171 => sysz_insn::SYSZ_INS_CIJLH,
            172 => sysz_insn::SYSZ_INS_CLGIJLH,
            173 => sysz_insn::SYSZ_INS_CLGRJLH,
            174 => sysz_insn::SYSZ_INS_CLIJLH,
            175 => sysz_insn::SYSZ_INS_CLRJLH,
            176 => sysz_insn::SYSZ_INS_CRJLH,
            177 => sysz_insn::SYSZ_INS_BLR,
            178 => sysz_insn::SYSZ_INS_BLER,
            179 => sysz_insn::SYSZ_INS_JLE,
            180 => sysz_insn::SYSZ_INS_JGLE,
            181 => sysz_insn::SYSZ_INS_LOCLE,
            182 => sysz_insn::SYSZ_INS_LOCGLE,
            183 => sysz_insn::SYSZ_INS_LOCGRLE,
            184 => sysz_insn::SYSZ_INS_LOCRLE,
            185 => sysz_insn::SYSZ_INS_STOCLE,
            186 => sysz_insn::SYSZ_INS_STOCGLE,
            187 => sysz_insn::SYSZ_INS_BLHR,
            188 => sysz_insn::SYSZ_INS_JLH,
            189 => sysz_insn::SYSZ_INS_JGLH,
            190 => sysz_insn::SYSZ_INS_LOCLH,
            191 => sysz_insn::SYSZ_INS_LOCGLH,
            192 => sysz_insn::SYSZ_INS_LOCGRLH,
            193 => sysz_insn::SYSZ_INS_LOCRLH,
            194 => sysz_insn::SYSZ_INS_STOCLH,
            195 => sysz_insn::SYSZ_INS_STOCGLH,
            196 => sysz_insn::SYSZ_INS_JL,
            197 => sysz_insn::SYSZ_INS_JGL,
            198 => sysz_insn::SYSZ_INS_LOCL,
            199 => sysz_insn::SYSZ_INS_LOCGL,
            200 => sysz_insn::SYSZ_INS_LOCGRL,
            201 => sysz_insn::SYSZ_INS_LOCRL,
            202 => sysz_insn::SYSZ_INS_LOC,
            203 => sysz_insn::SYSZ_INS_LOCG,
            204 => sysz_insn::SYSZ_INS_LOCGR,
            205 => sysz_insn::SYSZ_INS_LOCR,
            206 => sysz_insn::SYSZ_INS_STOCL,
            207 => sysz_insn::SYSZ_INS_STOCGL,
            208 => sysz_insn::SYSZ_INS_BNER,
            209 => sysz_insn::SYSZ_INS_JNE,
            210 => sysz_insn::SYSZ_INS_JGNE,
            211 => sysz_insn::SYSZ_INS_LOCNE,
            212 => sysz_insn::SYSZ_INS_LOCGNE,
            213 => sysz_insn::SYSZ_INS_LOCGRNE,
            214 => sysz_insn::SYSZ_INS_LOCRNE,
            215 => sysz_insn::SYSZ_INS_STOCNE,
            216 => sysz_insn::SYSZ_INS_STOCGNE,
            217 => sysz_insn::SYSZ_INS_BNHR,
            218 => sysz_insn::SYSZ_INS_BNHER,
            219 => sysz_insn::SYSZ_INS_JNHE,
            220 => sysz_insn::SYSZ_INS_JGNHE,
            221 => sysz_insn::SYSZ_INS_LOCNHE,
            222 => sysz_insn::SYSZ_INS_LOCGNHE,
            223 => sysz_insn::SYSZ_INS_LOCGRNHE,
            224 => sysz_insn::SYSZ_INS_LOCRNHE,
            225 => sysz_insn::SYSZ_INS_STOCNHE,
            226 => sysz_insn::SYSZ_INS_STOCGNHE,
            227 => sysz_insn::SYSZ_INS_JNH,
            228 => sysz_insn::SYSZ_INS_JGNH,
            229 => sysz_insn::SYSZ_INS_LOCNH,
            230 => sysz_insn::SYSZ_INS_LOCGNH,
            231 => sysz_insn::SYSZ_INS_LOCGRNH,
            232 => sysz_insn::SYSZ_INS_LOCRNH,
            233 => sysz_insn::SYSZ_INS_STOCNH,
            234 => sysz_insn::SYSZ_INS_STOCGNH,
            235 => sysz_insn::SYSZ_INS_BNLR,
            236 => sysz_insn::SYSZ_INS_BNLER,
            237 => sysz_insn::SYSZ_INS_JNLE,
            238 => sysz_insn::SYSZ_INS_JGNLE,
            239 => sysz_insn::SYSZ_INS_LOCNLE,
            240 => sysz_insn::SYSZ_INS_LOCGNLE,
            241 => sysz_insn::SYSZ_INS_LOCGRNLE,
            242 => sysz_insn::SYSZ_INS_LOCRNLE,
            243 => sysz_insn::SYSZ_INS_STOCNLE,
            244 => sysz_insn::SYSZ_INS_STOCGNLE,
            245 => sysz_insn::SYSZ_INS_BNLHR,
            246 => sysz_insn::SYSZ_INS_JNLH,
            247 => sysz_insn::SYSZ_INS_JGNLH,
            248 => sysz_insn::SYSZ_INS_LOCNLH,
            249 => sysz_insn::SYSZ_INS_LOCGNLH,
            250 => sysz_insn::SYSZ_INS_LOCGRNLH,
            251 => sysz_insn::SYSZ_INS_LOCRNLH,
            252 => sysz_insn::SYSZ_INS_STOCNLH,
            253 => sysz_insn::SYSZ_INS_STOCGNLH,
            254 => sysz_insn::SYSZ_INS_JNL,
            255 => sysz_insn::SYSZ_INS_JGNL,
            256 => sysz_insn::SYSZ_INS_LOCNL,
            257 => sysz_insn::SYSZ_INS_LOCGNL,
            258 => sysz_insn::SYSZ_INS_LOCGRNL,
            259 => sysz_insn::SYSZ_INS_LOCRNL,
            260 => sysz_insn::SYSZ_INS_STOCNL,
            261 => sysz_insn::SYSZ_INS_STOCGNL,
            262 => sysz_insn::SYSZ_INS_BNOR,
            263 => sysz_insn::SYSZ_INS_JNO,
            264 => sysz_insn::SYSZ_INS_JGNO,
            265 => sysz_insn::SYSZ_INS_LOCNO,
            266 => sysz_insn::SYSZ_INS_LOCGNO,
            267 => sysz_insn::SYSZ_INS_LOCGRNO,
            268 => sysz_insn::SYSZ_INS_LOCRNO,
            269 => sysz_insn::SYSZ_INS_STOCNO,
            270 => sysz_insn::SYSZ_INS_STOCGNO,
            271 => sysz_insn::SYSZ_INS_BOR,
            272 => sysz_insn::SYSZ_INS_JO,
            273 => sysz_insn::SYSZ_INS_JGO,
            274 => sysz_insn::SYSZ_INS_LOCO,
            275 => sysz_insn::SYSZ_INS_LOCGO,
            276 => sysz_insn::SYSZ_INS_LOCGRO,
            277 => sysz_insn::SYSZ_INS_LOCRO,
            278 => sysz_insn::SYSZ_INS_STOCO,
            279 => sysz_insn::SYSZ_INS_STOCGO,
            280 => sysz_insn::SYSZ_INS_STOC,
            281 => sysz_insn::SYSZ_INS_STOCG,
            282 => sysz_insn::SYSZ_INS_BASR,
            283 => sysz_insn::SYSZ_INS_BR,
            284 => sysz_insn::SYSZ_INS_BRAS,
            285 => sysz_insn::SYSZ_INS_BRASL,
            286 => sysz_insn::SYSZ_INS_J,
            287 => sysz_insn::SYSZ_INS_JG,
            288 => sysz_insn::SYSZ_INS_BRCT,
            289 => sysz_insn::SYSZ_INS_BRCTG,
            290 => sysz_insn::SYSZ_INS_C,
            291 => sysz_insn::SYSZ_INS_CDB,
            292 => sysz_insn::SYSZ_INS_CDBR,
            293 => sysz_insn::SYSZ_INS_CDFBR,
            294 => sysz_insn::SYSZ_INS_CDGBR,
            295 => sysz_insn::SYSZ_INS_CDLFBR,
            296 => sysz_insn::SYSZ_INS_CDLGBR,
            297 => sysz_insn::SYSZ_INS_CEB,
            298 => sysz_insn::SYSZ_INS_CEBR,
            299 => sysz_insn::SYSZ_INS_CEFBR,
            300 => sysz_insn::SYSZ_INS_CEGBR,
            301 => sysz_insn::SYSZ_INS_CELFBR,
            302 => sysz_insn::SYSZ_INS_CELGBR,
            303 => sysz_insn::SYSZ_INS_CFDBR,
            304 => sysz_insn::SYSZ_INS_CFEBR,
            305 => sysz_insn::SYSZ_INS_CFI,
            306 => sysz_insn::SYSZ_INS_CFXBR,
            307 => sysz_insn::SYSZ_INS_CG,
            308 => sysz_insn::SYSZ_INS_CGDBR,
            309 => sysz_insn::SYSZ_INS_CGEBR,
            310 => sysz_insn::SYSZ_INS_CGF,
            311 => sysz_insn::SYSZ_INS_CGFI,
            312 => sysz_insn::SYSZ_INS_CGFR,
            313 => sysz_insn::SYSZ_INS_CGFRL,
            314 => sysz_insn::SYSZ_INS_CGH,
            315 => sysz_insn::SYSZ_INS_CGHI,
            316 => sysz_insn::SYSZ_INS_CGHRL,
            317 => sysz_insn::SYSZ_INS_CGHSI,
            318 => sysz_insn::SYSZ_INS_CGR,
            319 => sysz_insn::SYSZ_INS_CGRL,
            320 => sysz_insn::SYSZ_INS_CGXBR,
            321 => sysz_insn::SYSZ_INS_CH,
            322 => sysz_insn::SYSZ_INS_CHF,
            323 => sysz_insn::SYSZ_INS_CHHSI,
            324 => sysz_insn::SYSZ_INS_CHI,
            325 => sysz_insn::SYSZ_INS_CHRL,
            326 => sysz_insn::SYSZ_INS_CHSI,
            327 => sysz_insn::SYSZ_INS_CHY,
            328 => sysz_insn::SYSZ_INS_CIH,
            329 => sysz_insn::SYSZ_INS_CL,
            330 => sysz_insn::SYSZ_INS_CLC,
            331 => sysz_insn::SYSZ_INS_CLFDBR,
            332 => sysz_insn::SYSZ_INS_CLFEBR,
            333 => sysz_insn::SYSZ_INS_CLFHSI,
            334 => sysz_insn::SYSZ_INS_CLFI,
            335 => sysz_insn::SYSZ_INS_CLFXBR,
            336 => sysz_insn::SYSZ_INS_CLG,
            337 => sysz_insn::SYSZ_INS_CLGDBR,
            338 => sysz_insn::SYSZ_INS_CLGEBR,
            339 => sysz_insn::SYSZ_INS_CLGF,
            340 => sysz_insn::SYSZ_INS_CLGFI,
            341 => sysz_insn::SYSZ_INS_CLGFR,
            342 => sysz_insn::SYSZ_INS_CLGFRL,
            343 => sysz_insn::SYSZ_INS_CLGHRL,
            344 => sysz_insn::SYSZ_INS_CLGHSI,
            345 => sysz_insn::SYSZ_INS_CLGR,
            346 => sysz_insn::SYSZ_INS_CLGRL,
            347 => sysz_insn::SYSZ_INS_CLGXBR,
            348 => sysz_insn::SYSZ_INS_CLHF,
            349 => sysz_insn::SYSZ_INS_CLHHSI,
            350 => sysz_insn::SYSZ_INS_CLHRL,
            351 => sysz_insn::SYSZ_INS_CLI,
            352 => sysz_insn::SYSZ_INS_CLIH,
            353 => sysz_insn::SYSZ_INS_CLIY,
            354 => sysz_insn::SYSZ_INS_CLR,
            355 => sysz_insn::SYSZ_INS_CLRL,
            356 => sysz_insn::SYSZ_INS_CLST,
            357 => sysz_insn::SYSZ_INS_CLY,
            358 => sysz_insn::SYSZ_INS_CPSDR,
            359 => sysz_insn::SYSZ_INS_CR,
            360 => sysz_insn::SYSZ_INS_CRL,
            361 => sysz_insn::SYSZ_INS_CS,
            362 => sysz_insn::SYSZ_INS_CSG,
            363 => sysz_insn::SYSZ_INS_CSY,
            364 => sysz_insn::SYSZ_INS_CXBR,
            365 => sysz_insn::SYSZ_INS_CXFBR,
            366 => sysz_insn::SYSZ_INS_CXGBR,
            367 => sysz_insn::SYSZ_INS_CXLFBR,
            368 => sysz_insn::SYSZ_INS_CXLGBR,
            369 => sysz_insn::SYSZ_INS_CY,
            370 => sysz_insn::SYSZ_INS_DDB,
            371 => sysz_insn::SYSZ_INS_DDBR,
            372 => sysz_insn::SYSZ_INS_DEB,
            373 => sysz_insn::SYSZ_INS_DEBR,
            374 => sysz_insn::SYSZ_INS_DL,
            375 => sysz_insn::SYSZ_INS_DLG,
            376 => sysz_insn::SYSZ_INS_DLGR,
            377 => sysz_insn::SYSZ_INS_DLR,
            378 => sysz_insn::SYSZ_INS_DSG,
            379 => sysz_insn::SYSZ_INS_DSGF,
            380 => sysz_insn::SYSZ_INS_DSGFR,
            381 => sysz_insn::SYSZ_INS_DSGR,
            382 => sysz_insn::SYSZ_INS_DXBR,
            383 => sysz_insn::SYSZ_INS_EAR,
            384 => sysz_insn::SYSZ_INS_FIDBR,
            385 => sysz_insn::SYSZ_INS_FIDBRA,
            386 => sysz_insn::SYSZ_INS_FIEBR,
            387 => sysz_insn::SYSZ_INS_FIEBRA,
            388 => sysz_insn::SYSZ_INS_FIXBR,
            389 => sysz_insn::SYSZ_INS_FIXBRA,
            390 => sysz_insn::SYSZ_INS_FLOGR,
            391 => sysz_insn::SYSZ_INS_IC,
            392 => sysz_insn::SYSZ_INS_ICY,
            393 => sysz_insn::SYSZ_INS_IIHF,
            394 => sysz_insn::SYSZ_INS_IIHH,
            395 => sysz_insn::SYSZ_INS_IIHL,
            396 => sysz_insn::SYSZ_INS_IILF,
            397 => sysz_insn::SYSZ_INS_IILH,
            398 => sysz_insn::SYSZ_INS_IILL,
            399 => sysz_insn::SYSZ_INS_IPM,
            400 => sysz_insn::SYSZ_INS_L,
            401 => sysz_insn::SYSZ_INS_LA,
            402 => sysz_insn::SYSZ_INS_LAA,
            403 => sysz_insn::SYSZ_INS_LAAG,
            404 => sysz_insn::SYSZ_INS_LAAL,
            405 => sysz_insn::SYSZ_INS_LAALG,
            406 => sysz_insn::SYSZ_INS_LAN,
            407 => sysz_insn::SYSZ_INS_LANG,
            408 => sysz_insn::SYSZ_INS_LAO,
            409 => sysz_insn::SYSZ_INS_LAOG,
            410 => sysz_insn::SYSZ_INS_LARL,
            411 => sysz_insn::SYSZ_INS_LAX,
            412 => sysz_insn::SYSZ_INS_LAXG,
            413 => sysz_insn::SYSZ_INS_LAY,
            414 => sysz_insn::SYSZ_INS_LB,
            415 => sysz_insn::SYSZ_INS_LBH,
            416 => sysz_insn::SYSZ_INS_LBR,
            417 => sysz_insn::SYSZ_INS_LCDBR,
            418 => sysz_insn::SYSZ_INS_LCEBR,
            419 => sysz_insn::SYSZ_INS_LCGFR,
            420 => sysz_insn::SYSZ_INS_LCGR,
            421 => sysz_insn::SYSZ_INS_LCR,
            422 => sysz_insn::SYSZ_INS_LCXBR,
            423 => sysz_insn::SYSZ_INS_LD,
            424 => sysz_insn::SYSZ_INS_LDEB,
            425 => sysz_insn::SYSZ_INS_LDEBR,
            426 => sysz_insn::SYSZ_INS_LDGR,
            427 => sysz_insn::SYSZ_INS_LDR,
            428 => sysz_insn::SYSZ_INS_LDXBR,
            429 => sysz_insn::SYSZ_INS_LDXBRA,
            430 => sysz_insn::SYSZ_INS_LDY,
            431 => sysz_insn::SYSZ_INS_LE,
            432 => sysz_insn::SYSZ_INS_LEDBR,
            433 => sysz_insn::SYSZ_INS_LEDBRA,
            434 => sysz_insn::SYSZ_INS_LER,
            435 => sysz_insn::SYSZ_INS_LEXBR,
            436 => sysz_insn::SYSZ_INS_LEXBRA,
            437 => sysz_insn::SYSZ_INS_LEY,
            438 => sysz_insn::SYSZ_INS_LFH,
            439 => sysz_insn::SYSZ_INS_LG,
            440 => sysz_insn::SYSZ_INS_LGB,
            441 => sysz_insn::SYSZ_INS_LGBR,
            442 => sysz_insn::SYSZ_INS_LGDR,
            443 => sysz_insn::SYSZ_INS_LGF,
            444 => sysz_insn::SYSZ_INS_LGFI,
            445 => sysz_insn::SYSZ_INS_LGFR,
            446 => sysz_insn::SYSZ_INS_LGFRL,
            447 => sysz_insn::SYSZ_INS_LGH,
            448 => sysz_insn::SYSZ_INS_LGHI,
            449 => sysz_insn::SYSZ_INS_LGHR,
            450 => sysz_insn::SYSZ_INS_LGHRL,
            451 => sysz_insn::SYSZ_INS_LGR,
            452 => sysz_insn::SYSZ_INS_LGRL,
            453 => sysz_insn::SYSZ_INS_LH,
            454 => sysz_insn::SYSZ_INS_LHH,
            455 => sysz_insn::SYSZ_INS_LHI,
            456 => sysz_insn::SYSZ_INS_LHR,
            457 => sysz_insn::SYSZ_INS_LHRL,
            458 => sysz_insn::SYSZ_INS_LHY,
            459 => sysz_insn::SYSZ_INS_LLC,
            460 => sysz_insn::SYSZ_INS_LLCH,
            461 => sysz_insn::SYSZ_INS_LLCR,
            462 => sysz_insn::SYSZ_INS_LLGC,
            463 => sysz_insn::SYSZ_INS_LLGCR,
            464 => sysz_insn::SYSZ_INS_LLGF,
            465 => sysz_insn::SYSZ_INS_LLGFR,
            466 => sysz_insn::SYSZ_INS_LLGFRL,
            467 => sysz_insn::SYSZ_INS_LLGH,
            468 => sysz_insn::SYSZ_INS_LLGHR,
            469 => sysz_insn::SYSZ_INS_LLGHRL,
            470 => sysz_insn::SYSZ_INS_LLH,
            471 => sysz_insn::SYSZ_INS_LLHH,
            472 => sysz_insn::SYSZ_INS_LLHR,
            473 => sysz_insn::SYSZ_INS_LLHRL,
            474 => sysz_insn::SYSZ_INS_LLIHF,
            475 => sysz_insn::SYSZ_INS_LLIHH,
            476 => sysz_insn::SYSZ_INS_LLIHL,
            477 => sysz_insn::SYSZ_INS_LLILF,
            478 => sysz_insn::SYSZ_INS_LLILH,
            479 => sysz_insn::SYSZ_INS_LLILL,
            480 => sysz_insn::SYSZ_INS_LMG,
            481 => sysz_insn::SYSZ_INS_LNDBR,
            482 => sysz_insn::SYSZ_INS_LNEBR,
            483 => sysz_insn::SYSZ_INS_LNGFR,
            484 => sysz_insn::SYSZ_INS_LNGR,
            485 => sysz_insn::SYSZ_INS_LNR,
            486 => sysz_insn::SYSZ_INS_LNXBR,
            487 => sysz_insn::SYSZ_INS_LPDBR,
            488 => sysz_insn::SYSZ_INS_LPEBR,
            489 => sysz_insn::SYSZ_INS_LPGFR,
            490 => sysz_insn::SYSZ_INS_LPGR,
            491 => sysz_insn::SYSZ_INS_LPR,
            492 => sysz_insn::SYSZ_INS_LPXBR,
            493 => sysz_insn::SYSZ_INS_LR,
            494 => sysz_insn::SYSZ_INS_LRL,
            495 => sysz_insn::SYSZ_INS_LRV,
            496 => sysz_insn::SYSZ_INS_LRVG,
            497 => sysz_insn::SYSZ_INS_LRVGR,
            498 => sysz_insn::SYSZ_INS_LRVR,
            499 => sysz_insn::SYSZ_INS_LT,
            500 => sysz_insn::SYSZ_INS_LTDBR,
            501 => sysz_insn::SYSZ_INS_LTEBR,
            502 => sysz_insn::SYSZ_INS_LTG,
            503 => sysz_insn::SYSZ_INS_LTGF,
            504 => sysz_insn::SYSZ_INS_LTGFR,
            505 => sysz_insn::SYSZ_INS_LTGR,
            506 => sysz_insn::SYSZ_INS_LTR,
            507 => sysz_insn::SYSZ_INS_LTXBR,
            508 => sysz_insn::SYSZ_INS_LXDB,
            509 => sysz_insn::SYSZ_INS_LXDBR,
            510 => sysz_insn::SYSZ_INS_LXEB,
            511 => sysz_insn::SYSZ_INS_LXEBR,
            512 => sysz_insn::SYSZ_INS_LXR,
            513 => sysz_insn::SYSZ_INS_LY,
            514 => sysz_insn::SYSZ_INS_LZDR,
            515 => sysz_insn::SYSZ_INS_LZER,
            516 => sysz_insn::SYSZ_INS_LZXR,
            517 => sysz_insn::SYSZ_INS_MADB,
            518 => sysz_insn::SYSZ_INS_MADBR,
            519 => sysz_insn::SYSZ_INS_MAEB,
            520 => sysz_insn::SYSZ_INS_MAEBR,
            521 => sysz_insn::SYSZ_INS_MDB,
            522 => sysz_insn::SYSZ_INS_MDBR,
            523 => sysz_insn::SYSZ_INS_MDEB,
            524 => sysz_insn::SYSZ_INS_MDEBR,
            525 => sysz_insn::SYSZ_INS_MEEB,
            526 => sysz_insn::SYSZ_INS_MEEBR,
            527 => sysz_insn::SYSZ_INS_MGHI,
            528 => sysz_insn::SYSZ_INS_MH,
            529 => sysz_insn::SYSZ_INS_MHI,
            530 => sysz_insn::SYSZ_INS_MHY,
            531 => sysz_insn::SYSZ_INS_MLG,
            532 => sysz_insn::SYSZ_INS_MLGR,
            533 => sysz_insn::SYSZ_INS_MS,
            534 => sysz_insn::SYSZ_INS_MSDB,
            535 => sysz_insn::SYSZ_INS_MSDBR,
            536 => sysz_insn::SYSZ_INS_MSEB,
            537 => sysz_insn::SYSZ_INS_MSEBR,
            538 => sysz_insn::SYSZ_INS_MSFI,
            539 => sysz_insn::SYSZ_INS_MSG,
            540 => sysz_insn::SYSZ_INS_MSGF,
            541 => sysz_insn::SYSZ_INS_MSGFI,
            542 => sysz_insn::SYSZ_INS_MSGFR,
            543 => sysz_insn::SYSZ_INS_MSGR,
            544 => sysz_insn::SYSZ_INS_MSR,
            545 => sysz_insn::SYSZ_INS_MSY,
            546 => sysz_insn::SYSZ_INS_MVC,
            547 => sysz_insn::SYSZ_INS_MVGHI,
            548 => sysz_insn::SYSZ_INS_MVHHI,
            549 => sysz_insn::SYSZ_INS_MVHI,
            550 => sysz_insn::SYSZ_INS_MVI,
            551 => sysz_insn::SYSZ_INS_MVIY,
            552 => sysz_insn::SYSZ_INS_MVST,
            553 => sysz_insn::SYSZ_INS_MXBR,
            554 => sysz_insn::SYSZ_INS_MXDB,
            555 => sysz_insn::SYSZ_INS_MXDBR,
            556 => sysz_insn::SYSZ_INS_N,
            557 => sysz_insn::SYSZ_INS_NC,
            558 => sysz_insn::SYSZ_INS_NG,
            559 => sysz_insn::SYSZ_INS_NGR,
            560 => sysz_insn::SYSZ_INS_NGRK,
            561 => sysz_insn::SYSZ_INS_NI,
            562 => sysz_insn::SYSZ_INS_NIHF,
            563 => sysz_insn::SYSZ_INS_NIHH,
            564 => sysz_insn::SYSZ_INS_NIHL,
            565 => sysz_insn::SYSZ_INS_NILF,
            566 => sysz_insn::SYSZ_INS_NILH,
            567 => sysz_insn::SYSZ_INS_NILL,
            568 => sysz_insn::SYSZ_INS_NIY,
            569 => sysz_insn::SYSZ_INS_NR,
            570 => sysz_insn::SYSZ_INS_NRK,
            571 => sysz_insn::SYSZ_INS_NY,
            572 => sysz_insn::SYSZ_INS_O,
            573 => sysz_insn::SYSZ_INS_OC,
            574 => sysz_insn::SYSZ_INS_OG,
            575 => sysz_insn::SYSZ_INS_OGR,
            576 => sysz_insn::SYSZ_INS_OGRK,
            577 => sysz_insn::SYSZ_INS_OI,
            578 => sysz_insn::SYSZ_INS_OIHF,
            579 => sysz_insn::SYSZ_INS_OIHH,
            580 => sysz_insn::SYSZ_INS_OIHL,
            581 => sysz_insn::SYSZ_INS_OILF,
            582 => sysz_insn::SYSZ_INS_OILH,
            583 => sysz_insn::SYSZ_INS_OILL,
            584 => sysz_insn::SYSZ_INS_OIY,
            585 => sysz_insn::SYSZ_INS_OR,
            586 => sysz_insn::SYSZ_INS_ORK,
            587 => sysz_insn::SYSZ_INS_OY,
            588 => sysz_insn::SYSZ_INS_PFD,
            589 => sysz_insn::SYSZ_INS_PFDRL,
            590 => sysz_insn::SYSZ_INS_RISBG,
            591 => sysz_insn::SYSZ_INS_RISBHG,
            592 => sysz_insn::SYSZ_INS_RISBLG,
            593 => sysz_insn::SYSZ_INS_RLL,
            594 => sysz_insn::SYSZ_INS_RLLG,
            595 => sysz_insn::SYSZ_INS_RNSBG,
            596 => sysz_insn::SYSZ_INS_ROSBG,
            597 => sysz_insn::SYSZ_INS_RXSBG,
            598 => sysz_insn::SYSZ_INS_S,
            599 => sysz_insn::SYSZ_INS_SDB,
            600 => sysz_insn::SYSZ_INS_SDBR,
            601 => sysz_insn::SYSZ_INS_SEB,
            602 => sysz_insn::SYSZ_INS_SEBR,
            603 => sysz_insn::SYSZ_INS_SG,
            604 => sysz_insn::SYSZ_INS_SGF,
            605 => sysz_insn::SYSZ_INS_SGFR,
            606 => sysz_insn::SYSZ_INS_SGR,
            607 => sysz_insn::SYSZ_INS_SGRK,
            608 => sysz_insn::SYSZ_INS_SH,
            609 => sysz_insn::SYSZ_INS_SHY,
            610 => sysz_insn::SYSZ_INS_SL,
            611 => sysz_insn::SYSZ_INS_SLB,
            612 => sysz_insn::SYSZ_INS_SLBG,
            613 => sysz_insn::SYSZ_INS_SLBR,
            614 => sysz_insn::SYSZ_INS_SLFI,
            615 => sysz_insn::SYSZ_INS_SLG,
            616 => sysz_insn::SYSZ_INS_SLBGR,
            617 => sysz_insn::SYSZ_INS_SLGF,
            618 => sysz_insn::SYSZ_INS_SLGFI,
            619 => sysz_insn::SYSZ_INS_SLGFR,
            620 => sysz_insn::SYSZ_INS_SLGR,
            621 => sysz_insn::SYSZ_INS_SLGRK,
            622 => sysz_insn::SYSZ_INS_SLL,
            623 => sysz_insn::SYSZ_INS_SLLG,
            624 => sysz_insn::SYSZ_INS_SLLK,
            625 => sysz_insn::SYSZ_INS_SLR,
            626 => sysz_insn::SYSZ_INS_SLRK,
            627 => sysz_insn::SYSZ_INS_SLY,
            628 => sysz_insn::SYSZ_INS_SQDB,
            629 => sysz_insn::SYSZ_INS_SQDBR,
            630 => sysz_insn::SYSZ_INS_SQEB,
            631 => sysz_insn::SYSZ_INS_SQEBR,
            632 => sysz_insn::SYSZ_INS_SQXBR,
            633 => sysz_insn::SYSZ_INS_SR,
            634 => sysz_insn::SYSZ_INS_SRA,
            635 => sysz_insn::SYSZ_INS_SRAG,
            636 => sysz_insn::SYSZ_INS_SRAK,
            637 => sysz_insn::SYSZ_INS_SRK,
            638 => sysz_insn::SYSZ_INS_SRL,
            639 => sysz_insn::SYSZ_INS_SRLG,
            640 => sysz_insn::SYSZ_INS_SRLK,
            641 => sysz_insn::SYSZ_INS_SRST,
            642 => sysz_insn::SYSZ_INS_ST,
            643 => sysz_insn::SYSZ_INS_STC,
            644 => sysz_insn::SYSZ_INS_STCH,
            645 => sysz_insn::SYSZ_INS_STCY,
            646 => sysz_insn::SYSZ_INS_STD,
            647 => sysz_insn::SYSZ_INS_STDY,
            648 => sysz_insn::SYSZ_INS_STE,
            649 => sysz_insn::SYSZ_INS_STEY,
            650 => sysz_insn::SYSZ_INS_STFH,
            651 => sysz_insn::SYSZ_INS_STG,
            652 => sysz_insn::SYSZ_INS_STGRL,
            653 => sysz_insn::SYSZ_INS_STH,
            654 => sysz_insn::SYSZ_INS_STHH,
            655 => sysz_insn::SYSZ_INS_STHRL,
            656 => sysz_insn::SYSZ_INS_STHY,
            657 => sysz_insn::SYSZ_INS_STMG,
            658 => sysz_insn::SYSZ_INS_STRL,
            659 => sysz_insn::SYSZ_INS_STRV,
            660 => sysz_insn::SYSZ_INS_STRVG,
            661 => sysz_insn::SYSZ_INS_STY,
            662 => sysz_insn::SYSZ_INS_SXBR,
            663 => sysz_insn::SYSZ_INS_SY,
            664 => sysz_insn::SYSZ_INS_TM,
            665 => sysz_insn::SYSZ_INS_TMHH,
            666 => sysz_insn::SYSZ_INS_TMHL,
            667 => sysz_insn::SYSZ_INS_TMLH,
            668 => sysz_insn::SYSZ_INS_TMLL,
            669 => sysz_insn::SYSZ_INS_TMY,
            670 => sysz_insn::SYSZ_INS_X,
            671 => sysz_insn::SYSZ_INS_XC,
            672 => sysz_insn::SYSZ_INS_XG,
            673 => sysz_insn::SYSZ_INS_XGR,
            674 => sysz_insn::SYSZ_INS_XGRK,
            675 => sysz_insn::SYSZ_INS_XI,
            676 => sysz_insn::SYSZ_INS_XIHF,
            677 => sysz_insn::SYSZ_INS_XILF,
            678 => sysz_insn::SYSZ_INS_XIY,
            679 => sysz_insn::SYSZ_INS_XR,
            680 => sysz_insn::SYSZ_INS_XRK,
            681 => sysz_insn::SYSZ_INS_XY,
            682 => sysz_insn::SYSZ_INS_ENDING,
            _ => sysz_insn::SYSZ_INS_INVALID,
        }
    }
}
impl From<u32> for tms320c64x_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => tms320c64x_insn::TMS320C64X_INS_INVALID,
            1 => tms320c64x_insn::TMS320C64X_INS_ABS,
            2 => tms320c64x_insn::TMS320C64X_INS_ABS2,
            3 => tms320c64x_insn::TMS320C64X_INS_ADD,
            4 => tms320c64x_insn::TMS320C64X_INS_ADD2,
            5 => tms320c64x_insn::TMS320C64X_INS_ADD4,
            6 => tms320c64x_insn::TMS320C64X_INS_ADDAB,
            7 => tms320c64x_insn::TMS320C64X_INS_ADDAD,
            8 => tms320c64x_insn::TMS320C64X_INS_ADDAH,
            9 => tms320c64x_insn::TMS320C64X_INS_ADDAW,
            10 => tms320c64x_insn::TMS320C64X_INS_ADDK,
            11 => tms320c64x_insn::TMS320C64X_INS_ADDKPC,
            12 => tms320c64x_insn::TMS320C64X_INS_ADDU,
            13 => tms320c64x_insn::TMS320C64X_INS_AND,
            14 => tms320c64x_insn::TMS320C64X_INS_ANDN,
            15 => tms320c64x_insn::TMS320C64X_INS_AVG2,
            16 => tms320c64x_insn::TMS320C64X_INS_AVGU4,
            17 => tms320c64x_insn::TMS320C64X_INS_B,
            18 => tms320c64x_insn::TMS320C64X_INS_BDEC,
            19 => tms320c64x_insn::TMS320C64X_INS_BITC4,
            20 => tms320c64x_insn::TMS320C64X_INS_BNOP,
            21 => tms320c64x_insn::TMS320C64X_INS_BPOS,
            22 => tms320c64x_insn::TMS320C64X_INS_CLR,
            23 => tms320c64x_insn::TMS320C64X_INS_CMPEQ,
            24 => tms320c64x_insn::TMS320C64X_INS_CMPEQ2,
            25 => tms320c64x_insn::TMS320C64X_INS_CMPEQ4,
            26 => tms320c64x_insn::TMS320C64X_INS_CMPGT,
            27 => tms320c64x_insn::TMS320C64X_INS_CMPGT2,
            28 => tms320c64x_insn::TMS320C64X_INS_CMPGTU4,
            29 => tms320c64x_insn::TMS320C64X_INS_CMPLT,
            30 => tms320c64x_insn::TMS320C64X_INS_CMPLTU,
            31 => tms320c64x_insn::TMS320C64X_INS_DEAL,
            32 => tms320c64x_insn::TMS320C64X_INS_DOTP2,
            33 => tms320c64x_insn::TMS320C64X_INS_DOTPN2,
            34 => tms320c64x_insn::TMS320C64X_INS_DOTPNRSU2,
            35 => tms320c64x_insn::TMS320C64X_INS_DOTPRSU2,
            36 => tms320c64x_insn::TMS320C64X_INS_DOTPSU4,
            37 => tms320c64x_insn::TMS320C64X_INS_DOTPU4,
            38 => tms320c64x_insn::TMS320C64X_INS_EXT,
            39 => tms320c64x_insn::TMS320C64X_INS_EXTU,
            40 => tms320c64x_insn::TMS320C64X_INS_GMPGTU,
            41 => tms320c64x_insn::TMS320C64X_INS_GMPY4,
            42 => tms320c64x_insn::TMS320C64X_INS_LDB,
            43 => tms320c64x_insn::TMS320C64X_INS_LDBU,
            44 => tms320c64x_insn::TMS320C64X_INS_LDDW,
            45 => tms320c64x_insn::TMS320C64X_INS_LDH,
            46 => tms320c64x_insn::TMS320C64X_INS_LDHU,
            47 => tms320c64x_insn::TMS320C64X_INS_LDNDW,
            48 => tms320c64x_insn::TMS320C64X_INS_LDNW,
            49 => tms320c64x_insn::TMS320C64X_INS_LDW,
            50 => tms320c64x_insn::TMS320C64X_INS_LMBD,
            51 => tms320c64x_insn::TMS320C64X_INS_MAX2,
            52 => tms320c64x_insn::TMS320C64X_INS_MAXU4,
            53 => tms320c64x_insn::TMS320C64X_INS_MIN2,
            54 => tms320c64x_insn::TMS320C64X_INS_MINU4,
            55 => tms320c64x_insn::TMS320C64X_INS_MPY,
            56 => tms320c64x_insn::TMS320C64X_INS_MPY2,
            57 => tms320c64x_insn::TMS320C64X_INS_MPYH,
            58 => tms320c64x_insn::TMS320C64X_INS_MPYHI,
            59 => tms320c64x_insn::TMS320C64X_INS_MPYHIR,
            60 => tms320c64x_insn::TMS320C64X_INS_MPYHL,
            61 => tms320c64x_insn::TMS320C64X_INS_MPYHLU,
            62 => tms320c64x_insn::TMS320C64X_INS_MPYHSLU,
            63 => tms320c64x_insn::TMS320C64X_INS_MPYHSU,
            64 => tms320c64x_insn::TMS320C64X_INS_MPYHU,
            65 => tms320c64x_insn::TMS320C64X_INS_MPYHULS,
            66 => tms320c64x_insn::TMS320C64X_INS_MPYHUS,
            67 => tms320c64x_insn::TMS320C64X_INS_MPYLH,
            68 => tms320c64x_insn::TMS320C64X_INS_MPYLHU,
            69 => tms320c64x_insn::TMS320C64X_INS_MPYLI,
            70 => tms320c64x_insn::TMS320C64X_INS_MPYLIR,
            71 => tms320c64x_insn::TMS320C64X_INS_MPYLSHU,
            72 => tms320c64x_insn::TMS320C64X_INS_MPYLUHS,
            73 => tms320c64x_insn::TMS320C64X_INS_MPYSU,
            74 => tms320c64x_insn::TMS320C64X_INS_MPYSU4,
            75 => tms320c64x_insn::TMS320C64X_INS_MPYU,
            76 => tms320c64x_insn::TMS320C64X_INS_MPYU4,
            77 => tms320c64x_insn::TMS320C64X_INS_MPYUS,
            78 => tms320c64x_insn::TMS320C64X_INS_MVC,
            79 => tms320c64x_insn::TMS320C64X_INS_MVD,
            80 => tms320c64x_insn::TMS320C64X_INS_MVK,
            81 => tms320c64x_insn::TMS320C64X_INS_MVKL,
            82 => tms320c64x_insn::TMS320C64X_INS_MVKLH,
            83 => tms320c64x_insn::TMS320C64X_INS_NOP,
            84 => tms320c64x_insn::TMS320C64X_INS_NORM,
            85 => tms320c64x_insn::TMS320C64X_INS_OR,
            86 => tms320c64x_insn::TMS320C64X_INS_PACK2,
            87 => tms320c64x_insn::TMS320C64X_INS_PACKH2,
            88 => tms320c64x_insn::TMS320C64X_INS_PACKH4,
            89 => tms320c64x_insn::TMS320C64X_INS_PACKHL2,
            90 => tms320c64x_insn::TMS320C64X_INS_PACKL4,
            91 => tms320c64x_insn::TMS320C64X_INS_PACKLH2,
            92 => tms320c64x_insn::TMS320C64X_INS_ROTL,
            93 => tms320c64x_insn::TMS320C64X_INS_SADD,
            94 => tms320c64x_insn::TMS320C64X_INS_SADD2,
            95 => tms320c64x_insn::TMS320C64X_INS_SADDU4,
            96 => tms320c64x_insn::TMS320C64X_INS_SADDUS2,
            97 => tms320c64x_insn::TMS320C64X_INS_SAT,
            98 => tms320c64x_insn::TMS320C64X_INS_SET,
            99 => tms320c64x_insn::TMS320C64X_INS_SHFL,
            100 => tms320c64x_insn::TMS320C64X_INS_SHL,
            101 => tms320c64x_insn::TMS320C64X_INS_SHLMB,
            102 => tms320c64x_insn::TMS320C64X_INS_SHR,
            103 => tms320c64x_insn::TMS320C64X_INS_SHR2,
            104 => tms320c64x_insn::TMS320C64X_INS_SHRMB,
            105 => tms320c64x_insn::TMS320C64X_INS_SHRU,
            106 => tms320c64x_insn::TMS320C64X_INS_SHRU2,
            107 => tms320c64x_insn::TMS320C64X_INS_SMPY,
            108 => tms320c64x_insn::TMS320C64X_INS_SMPY2,
            109 => tms320c64x_insn::TMS320C64X_INS_SMPYH,
            110 => tms320c64x_insn::TMS320C64X_INS_SMPYHL,
            111 => tms320c64x_insn::TMS320C64X_INS_SMPYLH,
            112 => tms320c64x_insn::TMS320C64X_INS_SPACK2,
            113 => tms320c64x_insn::TMS320C64X_INS_SPACKU4,
            114 => tms320c64x_insn::TMS320C64X_INS_SSHL,
            115 => tms320c64x_insn::TMS320C64X_INS_SSHVL,
            116 => tms320c64x_insn::TMS320C64X_INS_SSHVR,
            117 => tms320c64x_insn::TMS320C64X_INS_SSUB,
            118 => tms320c64x_insn::TMS320C64X_INS_STB,
            119 => tms320c64x_insn::TMS320C64X_INS_STDW,
            120 => tms320c64x_insn::TMS320C64X_INS_STH,
            121 => tms320c64x_insn::TMS320C64X_INS_STNDW,
            122 => tms320c64x_insn::TMS320C64X_INS_STNW,
            123 => tms320c64x_insn::TMS320C64X_INS_STW,
            124 => tms320c64x_insn::TMS320C64X_INS_SUB,
            125 => tms320c64x_insn::TMS320C64X_INS_SUB2,
            126 => tms320c64x_insn::TMS320C64X_INS_SUB4,
            127 => tms320c64x_insn::TMS320C64X_INS_SUBAB,
            128 => tms320c64x_insn::TMS320C64X_INS_SUBABS4,
            129 => tms320c64x_insn::TMS320C64X_INS_SUBAH,
            130 => tms320c64x_insn::TMS320C64X_INS_SUBAW,
            131 => tms320c64x_insn::TMS320C64X_INS_SUBC,
            132 => tms320c64x_insn::TMS320C64X_INS_SUBU,
            133 => tms320c64x_insn::TMS320C64X_INS_SWAP4,
            134 => tms320c64x_insn::TMS320C64X_INS_UNPKHU4,
            135 => tms320c64x_insn::TMS320C64X_INS_UNPKLU4,
            136 => tms320c64x_insn::TMS320C64X_INS_XOR,
            137 => tms320c64x_insn::TMS320C64X_INS_XPND2,
            138 => tms320c64x_insn::TMS320C64X_INS_XPND4,
            139 => tms320c64x_insn::TMS320C64X_INS_IDLE,
            140 => tms320c64x_insn::TMS320C64X_INS_MV,
            141 => tms320c64x_insn::TMS320C64X_INS_NEG,
            142 => tms320c64x_insn::TMS320C64X_INS_NOT,
            143 => tms320c64x_insn::TMS320C64X_INS_SWAP2,
            144 => tms320c64x_insn::TMS320C64X_INS_ZERO,
            145 => tms320c64x_insn::TMS320C64X_INS_ENDING,
            _ => tms320c64x_insn::TMS320C64X_INS_INVALID,
        }
    }
}
impl From<u32> for x86_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => x86_insn::X86_INS_INVALID,
            1 => x86_insn::X86_INS_AAA,
            2 => x86_insn::X86_INS_AAD,
            3 => x86_insn::X86_INS_AAM,
            4 => x86_insn::X86_INS_AAS,
            5 => x86_insn::X86_INS_FABS,
            6 => x86_insn::X86_INS_ADC,
            7 => x86_insn::X86_INS_ADCX,
            8 => x86_insn::X86_INS_ADD,
            9 => x86_insn::X86_INS_ADDPD,
            10 => x86_insn::X86_INS_ADDPS,
            11 => x86_insn::X86_INS_ADDSD,
            12 => x86_insn::X86_INS_ADDSS,
            13 => x86_insn::X86_INS_ADDSUBPD,
            14 => x86_insn::X86_INS_ADDSUBPS,
            15 => x86_insn::X86_INS_FADD,
            16 => x86_insn::X86_INS_FIADD,
            17 => x86_insn::X86_INS_FADDP,
            18 => x86_insn::X86_INS_ADOX,
            19 => x86_insn::X86_INS_AESDECLAST,
            20 => x86_insn::X86_INS_AESDEC,
            21 => x86_insn::X86_INS_AESENCLAST,
            22 => x86_insn::X86_INS_AESENC,
            23 => x86_insn::X86_INS_AESIMC,
            24 => x86_insn::X86_INS_AESKEYGENASSIST,
            25 => x86_insn::X86_INS_AND,
            26 => x86_insn::X86_INS_ANDN,
            27 => x86_insn::X86_INS_ANDNPD,
            28 => x86_insn::X86_INS_ANDNPS,
            29 => x86_insn::X86_INS_ANDPD,
            30 => x86_insn::X86_INS_ANDPS,
            31 => x86_insn::X86_INS_ARPL,
            32 => x86_insn::X86_INS_BEXTR,
            33 => x86_insn::X86_INS_BLCFILL,
            34 => x86_insn::X86_INS_BLCI,
            35 => x86_insn::X86_INS_BLCIC,
            36 => x86_insn::X86_INS_BLCMSK,
            37 => x86_insn::X86_INS_BLCS,
            38 => x86_insn::X86_INS_BLENDPD,
            39 => x86_insn::X86_INS_BLENDPS,
            40 => x86_insn::X86_INS_BLENDVPD,
            41 => x86_insn::X86_INS_BLENDVPS,
            42 => x86_insn::X86_INS_BLSFILL,
            43 => x86_insn::X86_INS_BLSI,
            44 => x86_insn::X86_INS_BLSIC,
            45 => x86_insn::X86_INS_BLSMSK,
            46 => x86_insn::X86_INS_BLSR,
            47 => x86_insn::X86_INS_BOUND,
            48 => x86_insn::X86_INS_BSF,
            49 => x86_insn::X86_INS_BSR,
            50 => x86_insn::X86_INS_BSWAP,
            51 => x86_insn::X86_INS_BT,
            52 => x86_insn::X86_INS_BTC,
            53 => x86_insn::X86_INS_BTR,
            54 => x86_insn::X86_INS_BTS,
            55 => x86_insn::X86_INS_BZHI,
            56 => x86_insn::X86_INS_CALL,
            57 => x86_insn::X86_INS_CBW,
            58 => x86_insn::X86_INS_CDQ,
            59 => x86_insn::X86_INS_CDQE,
            60 => x86_insn::X86_INS_FCHS,
            61 => x86_insn::X86_INS_CLAC,
            62 => x86_insn::X86_INS_CLC,
            63 => x86_insn::X86_INS_CLD,
            64 => x86_insn::X86_INS_CLFLUSH,
            65 => x86_insn::X86_INS_CLFLUSHOPT,
            66 => x86_insn::X86_INS_CLGI,
            67 => x86_insn::X86_INS_CLI,
            68 => x86_insn::X86_INS_CLTS,
            69 => x86_insn::X86_INS_CLWB,
            70 => x86_insn::X86_INS_CMC,
            71 => x86_insn::X86_INS_CMOVA,
            72 => x86_insn::X86_INS_CMOVAE,
            73 => x86_insn::X86_INS_CMOVB,
            74 => x86_insn::X86_INS_CMOVBE,
            75 => x86_insn::X86_INS_FCMOVBE,
            76 => x86_insn::X86_INS_FCMOVB,
            77 => x86_insn::X86_INS_CMOVE,
            78 => x86_insn::X86_INS_FCMOVE,
            79 => x86_insn::X86_INS_CMOVG,
            80 => x86_insn::X86_INS_CMOVGE,
            81 => x86_insn::X86_INS_CMOVL,
            82 => x86_insn::X86_INS_CMOVLE,
            83 => x86_insn::X86_INS_FCMOVNBE,
            84 => x86_insn::X86_INS_FCMOVNB,
            85 => x86_insn::X86_INS_CMOVNE,
            86 => x86_insn::X86_INS_FCMOVNE,
            87 => x86_insn::X86_INS_CMOVNO,
            88 => x86_insn::X86_INS_CMOVNP,
            89 => x86_insn::X86_INS_FCMOVNU,
            90 => x86_insn::X86_INS_CMOVNS,
            91 => x86_insn::X86_INS_CMOVO,
            92 => x86_insn::X86_INS_CMOVP,
            93 => x86_insn::X86_INS_FCMOVU,
            94 => x86_insn::X86_INS_CMOVS,
            95 => x86_insn::X86_INS_CMP,
            96 => x86_insn::X86_INS_CMPSB,
            97 => x86_insn::X86_INS_CMPSQ,
            98 => x86_insn::X86_INS_CMPSW,
            99 => x86_insn::X86_INS_CMPXCHG16B,
            100 => x86_insn::X86_INS_CMPXCHG,
            101 => x86_insn::X86_INS_CMPXCHG8B,
            102 => x86_insn::X86_INS_COMISD,
            103 => x86_insn::X86_INS_COMISS,
            104 => x86_insn::X86_INS_FCOMP,
            105 => x86_insn::X86_INS_FCOMIP,
            106 => x86_insn::X86_INS_FCOMI,
            107 => x86_insn::X86_INS_FCOM,
            108 => x86_insn::X86_INS_FCOS,
            109 => x86_insn::X86_INS_CPUID,
            110 => x86_insn::X86_INS_CQO,
            111 => x86_insn::X86_INS_CRC32,
            112 => x86_insn::X86_INS_CVTDQ2PD,
            113 => x86_insn::X86_INS_CVTDQ2PS,
            114 => x86_insn::X86_INS_CVTPD2DQ,
            115 => x86_insn::X86_INS_CVTPD2PS,
            116 => x86_insn::X86_INS_CVTPS2DQ,
            117 => x86_insn::X86_INS_CVTPS2PD,
            118 => x86_insn::X86_INS_CVTSD2SI,
            119 => x86_insn::X86_INS_CVTSD2SS,
            120 => x86_insn::X86_INS_CVTSI2SD,
            121 => x86_insn::X86_INS_CVTSI2SS,
            122 => x86_insn::X86_INS_CVTSS2SD,
            123 => x86_insn::X86_INS_CVTSS2SI,
            124 => x86_insn::X86_INS_CVTTPD2DQ,
            125 => x86_insn::X86_INS_CVTTPS2DQ,
            126 => x86_insn::X86_INS_CVTTSD2SI,
            127 => x86_insn::X86_INS_CVTTSS2SI,
            128 => x86_insn::X86_INS_CWD,
            129 => x86_insn::X86_INS_CWDE,
            130 => x86_insn::X86_INS_DAA,
            131 => x86_insn::X86_INS_DAS,
            132 => x86_insn::X86_INS_DATA16,
            133 => x86_insn::X86_INS_DEC,
            134 => x86_insn::X86_INS_DIV,
            135 => x86_insn::X86_INS_DIVPD,
            136 => x86_insn::X86_INS_DIVPS,
            137 => x86_insn::X86_INS_FDIVR,
            138 => x86_insn::X86_INS_FIDIVR,
            139 => x86_insn::X86_INS_FDIVRP,
            140 => x86_insn::X86_INS_DIVSD,
            141 => x86_insn::X86_INS_DIVSS,
            142 => x86_insn::X86_INS_FDIV,
            143 => x86_insn::X86_INS_FIDIV,
            144 => x86_insn::X86_INS_FDIVP,
            145 => x86_insn::X86_INS_DPPD,
            146 => x86_insn::X86_INS_DPPS,
            147 => x86_insn::X86_INS_RET,
            148 => x86_insn::X86_INS_ENCLS,
            149 => x86_insn::X86_INS_ENCLU,
            150 => x86_insn::X86_INS_ENTER,
            151 => x86_insn::X86_INS_EXTRACTPS,
            152 => x86_insn::X86_INS_EXTRQ,
            153 => x86_insn::X86_INS_F2XM1,
            154 => x86_insn::X86_INS_LCALL,
            155 => x86_insn::X86_INS_LJMP,
            156 => x86_insn::X86_INS_FBLD,
            157 => x86_insn::X86_INS_FBSTP,
            158 => x86_insn::X86_INS_FCOMPP,
            159 => x86_insn::X86_INS_FDECSTP,
            160 => x86_insn::X86_INS_FEMMS,
            161 => x86_insn::X86_INS_FFREE,
            162 => x86_insn::X86_INS_FICOM,
            163 => x86_insn::X86_INS_FICOMP,
            164 => x86_insn::X86_INS_FINCSTP,
            165 => x86_insn::X86_INS_FLDCW,
            166 => x86_insn::X86_INS_FLDENV,
            167 => x86_insn::X86_INS_FLDL2E,
            168 => x86_insn::X86_INS_FLDL2T,
            169 => x86_insn::X86_INS_FLDLG2,
            170 => x86_insn::X86_INS_FLDLN2,
            171 => x86_insn::X86_INS_FLDPI,
            172 => x86_insn::X86_INS_FNCLEX,
            173 => x86_insn::X86_INS_FNINIT,
            174 => x86_insn::X86_INS_FNOP,
            175 => x86_insn::X86_INS_FNSTCW,
            176 => x86_insn::X86_INS_FNSTSW,
            177 => x86_insn::X86_INS_FPATAN,
            178 => x86_insn::X86_INS_FPREM,
            179 => x86_insn::X86_INS_FPREM1,
            180 => x86_insn::X86_INS_FPTAN,
            181 => x86_insn::X86_INS_FFREEP,
            182 => x86_insn::X86_INS_FRNDINT,
            183 => x86_insn::X86_INS_FRSTOR,
            184 => x86_insn::X86_INS_FNSAVE,
            185 => x86_insn::X86_INS_FSCALE,
            186 => x86_insn::X86_INS_FSETPM,
            187 => x86_insn::X86_INS_FSINCOS,
            188 => x86_insn::X86_INS_FNSTENV,
            189 => x86_insn::X86_INS_FXAM,
            190 => x86_insn::X86_INS_FXRSTOR,
            191 => x86_insn::X86_INS_FXRSTOR64,
            192 => x86_insn::X86_INS_FXSAVE,
            193 => x86_insn::X86_INS_FXSAVE64,
            194 => x86_insn::X86_INS_FXTRACT,
            195 => x86_insn::X86_INS_FYL2X,
            196 => x86_insn::X86_INS_FYL2XP1,
            197 => x86_insn::X86_INS_MOVAPD,
            198 => x86_insn::X86_INS_MOVAPS,
            199 => x86_insn::X86_INS_ORPD,
            200 => x86_insn::X86_INS_ORPS,
            201 => x86_insn::X86_INS_VMOVAPD,
            202 => x86_insn::X86_INS_VMOVAPS,
            203 => x86_insn::X86_INS_XORPD,
            204 => x86_insn::X86_INS_XORPS,
            205 => x86_insn::X86_INS_GETSEC,
            206 => x86_insn::X86_INS_HADDPD,
            207 => x86_insn::X86_INS_HADDPS,
            208 => x86_insn::X86_INS_HLT,
            209 => x86_insn::X86_INS_HSUBPD,
            210 => x86_insn::X86_INS_HSUBPS,
            211 => x86_insn::X86_INS_IDIV,
            212 => x86_insn::X86_INS_FILD,
            213 => x86_insn::X86_INS_IMUL,
            214 => x86_insn::X86_INS_IN,
            215 => x86_insn::X86_INS_INC,
            216 => x86_insn::X86_INS_INSB,
            217 => x86_insn::X86_INS_INSERTPS,
            218 => x86_insn::X86_INS_INSERTQ,
            219 => x86_insn::X86_INS_INSD,
            220 => x86_insn::X86_INS_INSW,
            221 => x86_insn::X86_INS_INT,
            222 => x86_insn::X86_INS_INT1,
            223 => x86_insn::X86_INS_INT3,
            224 => x86_insn::X86_INS_INTO,
            225 => x86_insn::X86_INS_INVD,
            226 => x86_insn::X86_INS_INVEPT,
            227 => x86_insn::X86_INS_INVLPG,
            228 => x86_insn::X86_INS_INVLPGA,
            229 => x86_insn::X86_INS_INVPCID,
            230 => x86_insn::X86_INS_INVVPID,
            231 => x86_insn::X86_INS_IRET,
            232 => x86_insn::X86_INS_IRETD,
            233 => x86_insn::X86_INS_IRETQ,
            234 => x86_insn::X86_INS_FISTTP,
            235 => x86_insn::X86_INS_FIST,
            236 => x86_insn::X86_INS_FISTP,
            237 => x86_insn::X86_INS_UCOMISD,
            238 => x86_insn::X86_INS_UCOMISS,
            239 => x86_insn::X86_INS_VCOMISD,
            240 => x86_insn::X86_INS_VCOMISS,
            241 => x86_insn::X86_INS_VCVTSD2SS,
            242 => x86_insn::X86_INS_VCVTSI2SD,
            243 => x86_insn::X86_INS_VCVTSI2SS,
            244 => x86_insn::X86_INS_VCVTSS2SD,
            245 => x86_insn::X86_INS_VCVTTSD2SI,
            246 => x86_insn::X86_INS_VCVTTSD2USI,
            247 => x86_insn::X86_INS_VCVTTSS2SI,
            248 => x86_insn::X86_INS_VCVTTSS2USI,
            249 => x86_insn::X86_INS_VCVTUSI2SD,
            250 => x86_insn::X86_INS_VCVTUSI2SS,
            251 => x86_insn::X86_INS_VUCOMISD,
            252 => x86_insn::X86_INS_VUCOMISS,
            253 => x86_insn::X86_INS_JAE,
            254 => x86_insn::X86_INS_JA,
            255 => x86_insn::X86_INS_JBE,
            256 => x86_insn::X86_INS_JB,
            257 => x86_insn::X86_INS_JCXZ,
            258 => x86_insn::X86_INS_JECXZ,
            259 => x86_insn::X86_INS_JE,
            260 => x86_insn::X86_INS_JGE,
            261 => x86_insn::X86_INS_JG,
            262 => x86_insn::X86_INS_JLE,
            263 => x86_insn::X86_INS_JL,
            264 => x86_insn::X86_INS_JMP,
            265 => x86_insn::X86_INS_JNE,
            266 => x86_insn::X86_INS_JNO,
            267 => x86_insn::X86_INS_JNP,
            268 => x86_insn::X86_INS_JNS,
            269 => x86_insn::X86_INS_JO,
            270 => x86_insn::X86_INS_JP,
            271 => x86_insn::X86_INS_JRCXZ,
            272 => x86_insn::X86_INS_JS,
            273 => x86_insn::X86_INS_KANDB,
            274 => x86_insn::X86_INS_KANDD,
            275 => x86_insn::X86_INS_KANDNB,
            276 => x86_insn::X86_INS_KANDND,
            277 => x86_insn::X86_INS_KANDNQ,
            278 => x86_insn::X86_INS_KANDNW,
            279 => x86_insn::X86_INS_KANDQ,
            280 => x86_insn::X86_INS_KANDW,
            281 => x86_insn::X86_INS_KMOVB,
            282 => x86_insn::X86_INS_KMOVD,
            283 => x86_insn::X86_INS_KMOVQ,
            284 => x86_insn::X86_INS_KMOVW,
            285 => x86_insn::X86_INS_KNOTB,
            286 => x86_insn::X86_INS_KNOTD,
            287 => x86_insn::X86_INS_KNOTQ,
            288 => x86_insn::X86_INS_KNOTW,
            289 => x86_insn::X86_INS_KORB,
            290 => x86_insn::X86_INS_KORD,
            291 => x86_insn::X86_INS_KORQ,
            292 => x86_insn::X86_INS_KORTESTB,
            293 => x86_insn::X86_INS_KORTESTD,
            294 => x86_insn::X86_INS_KORTESTQ,
            295 => x86_insn::X86_INS_KORTESTW,
            296 => x86_insn::X86_INS_KORW,
            297 => x86_insn::X86_INS_KSHIFTLB,
            298 => x86_insn::X86_INS_KSHIFTLD,
            299 => x86_insn::X86_INS_KSHIFTLQ,
            300 => x86_insn::X86_INS_KSHIFTLW,
            301 => x86_insn::X86_INS_KSHIFTRB,
            302 => x86_insn::X86_INS_KSHIFTRD,
            303 => x86_insn::X86_INS_KSHIFTRQ,
            304 => x86_insn::X86_INS_KSHIFTRW,
            305 => x86_insn::X86_INS_KUNPCKBW,
            306 => x86_insn::X86_INS_KXNORB,
            307 => x86_insn::X86_INS_KXNORD,
            308 => x86_insn::X86_INS_KXNORQ,
            309 => x86_insn::X86_INS_KXNORW,
            310 => x86_insn::X86_INS_KXORB,
            311 => x86_insn::X86_INS_KXORD,
            312 => x86_insn::X86_INS_KXORQ,
            313 => x86_insn::X86_INS_KXORW,
            314 => x86_insn::X86_INS_LAHF,
            315 => x86_insn::X86_INS_LAR,
            316 => x86_insn::X86_INS_LDDQU,
            317 => x86_insn::X86_INS_LDMXCSR,
            318 => x86_insn::X86_INS_LDS,
            319 => x86_insn::X86_INS_FLDZ,
            320 => x86_insn::X86_INS_FLD1,
            321 => x86_insn::X86_INS_FLD,
            322 => x86_insn::X86_INS_LEA,
            323 => x86_insn::X86_INS_LEAVE,
            324 => x86_insn::X86_INS_LES,
            325 => x86_insn::X86_INS_LFENCE,
            326 => x86_insn::X86_INS_LFS,
            327 => x86_insn::X86_INS_LGDT,
            328 => x86_insn::X86_INS_LGS,
            329 => x86_insn::X86_INS_LIDT,
            330 => x86_insn::X86_INS_LLDT,
            331 => x86_insn::X86_INS_LMSW,
            332 => x86_insn::X86_INS_OR,
            333 => x86_insn::X86_INS_SUB,
            334 => x86_insn::X86_INS_XOR,
            335 => x86_insn::X86_INS_LODSB,
            336 => x86_insn::X86_INS_LODSD,
            337 => x86_insn::X86_INS_LODSQ,
            338 => x86_insn::X86_INS_LODSW,
            339 => x86_insn::X86_INS_LOOP,
            340 => x86_insn::X86_INS_LOOPE,
            341 => x86_insn::X86_INS_LOOPNE,
            342 => x86_insn::X86_INS_RETF,
            343 => x86_insn::X86_INS_RETFQ,
            344 => x86_insn::X86_INS_LSL,
            345 => x86_insn::X86_INS_LSS,
            346 => x86_insn::X86_INS_LTR,
            347 => x86_insn::X86_INS_XADD,
            348 => x86_insn::X86_INS_LZCNT,
            349 => x86_insn::X86_INS_MASKMOVDQU,
            350 => x86_insn::X86_INS_MAXPD,
            351 => x86_insn::X86_INS_MAXPS,
            352 => x86_insn::X86_INS_MAXSD,
            353 => x86_insn::X86_INS_MAXSS,
            354 => x86_insn::X86_INS_MFENCE,
            355 => x86_insn::X86_INS_MINPD,
            356 => x86_insn::X86_INS_MINPS,
            357 => x86_insn::X86_INS_MINSD,
            358 => x86_insn::X86_INS_MINSS,
            359 => x86_insn::X86_INS_CVTPD2PI,
            360 => x86_insn::X86_INS_CVTPI2PD,
            361 => x86_insn::X86_INS_CVTPI2PS,
            362 => x86_insn::X86_INS_CVTPS2PI,
            363 => x86_insn::X86_INS_CVTTPD2PI,
            364 => x86_insn::X86_INS_CVTTPS2PI,
            365 => x86_insn::X86_INS_EMMS,
            366 => x86_insn::X86_INS_MASKMOVQ,
            367 => x86_insn::X86_INS_MOVD,
            368 => x86_insn::X86_INS_MOVDQ2Q,
            369 => x86_insn::X86_INS_MOVNTQ,
            370 => x86_insn::X86_INS_MOVQ2DQ,
            371 => x86_insn::X86_INS_MOVQ,
            372 => x86_insn::X86_INS_PABSB,
            373 => x86_insn::X86_INS_PABSD,
            374 => x86_insn::X86_INS_PABSW,
            375 => x86_insn::X86_INS_PACKSSDW,
            376 => x86_insn::X86_INS_PACKSSWB,
            377 => x86_insn::X86_INS_PACKUSWB,
            378 => x86_insn::X86_INS_PADDB,
            379 => x86_insn::X86_INS_PADDD,
            380 => x86_insn::X86_INS_PADDQ,
            381 => x86_insn::X86_INS_PADDSB,
            382 => x86_insn::X86_INS_PADDSW,
            383 => x86_insn::X86_INS_PADDUSB,
            384 => x86_insn::X86_INS_PADDUSW,
            385 => x86_insn::X86_INS_PADDW,
            386 => x86_insn::X86_INS_PALIGNR,
            387 => x86_insn::X86_INS_PANDN,
            388 => x86_insn::X86_INS_PAND,
            389 => x86_insn::X86_INS_PAVGB,
            390 => x86_insn::X86_INS_PAVGW,
            391 => x86_insn::X86_INS_PCMPEQB,
            392 => x86_insn::X86_INS_PCMPEQD,
            393 => x86_insn::X86_INS_PCMPEQW,
            394 => x86_insn::X86_INS_PCMPGTB,
            395 => x86_insn::X86_INS_PCMPGTD,
            396 => x86_insn::X86_INS_PCMPGTW,
            397 => x86_insn::X86_INS_PEXTRW,
            398 => x86_insn::X86_INS_PHADDSW,
            399 => x86_insn::X86_INS_PHADDW,
            400 => x86_insn::X86_INS_PHADDD,
            401 => x86_insn::X86_INS_PHSUBD,
            402 => x86_insn::X86_INS_PHSUBSW,
            403 => x86_insn::X86_INS_PHSUBW,
            404 => x86_insn::X86_INS_PINSRW,
            405 => x86_insn::X86_INS_PMADDUBSW,
            406 => x86_insn::X86_INS_PMADDWD,
            407 => x86_insn::X86_INS_PMAXSW,
            408 => x86_insn::X86_INS_PMAXUB,
            409 => x86_insn::X86_INS_PMINSW,
            410 => x86_insn::X86_INS_PMINUB,
            411 => x86_insn::X86_INS_PMOVMSKB,
            412 => x86_insn::X86_INS_PMULHRSW,
            413 => x86_insn::X86_INS_PMULHUW,
            414 => x86_insn::X86_INS_PMULHW,
            415 => x86_insn::X86_INS_PMULLW,
            416 => x86_insn::X86_INS_PMULUDQ,
            417 => x86_insn::X86_INS_POR,
            418 => x86_insn::X86_INS_PSADBW,
            419 => x86_insn::X86_INS_PSHUFB,
            420 => x86_insn::X86_INS_PSHUFW,
            421 => x86_insn::X86_INS_PSIGNB,
            422 => x86_insn::X86_INS_PSIGND,
            423 => x86_insn::X86_INS_PSIGNW,
            424 => x86_insn::X86_INS_PSLLD,
            425 => x86_insn::X86_INS_PSLLQ,
            426 => x86_insn::X86_INS_PSLLW,
            427 => x86_insn::X86_INS_PSRAD,
            428 => x86_insn::X86_INS_PSRAW,
            429 => x86_insn::X86_INS_PSRLD,
            430 => x86_insn::X86_INS_PSRLQ,
            431 => x86_insn::X86_INS_PSRLW,
            432 => x86_insn::X86_INS_PSUBB,
            433 => x86_insn::X86_INS_PSUBD,
            434 => x86_insn::X86_INS_PSUBQ,
            435 => x86_insn::X86_INS_PSUBSB,
            436 => x86_insn::X86_INS_PSUBSW,
            437 => x86_insn::X86_INS_PSUBUSB,
            438 => x86_insn::X86_INS_PSUBUSW,
            439 => x86_insn::X86_INS_PSUBW,
            440 => x86_insn::X86_INS_PUNPCKHBW,
            441 => x86_insn::X86_INS_PUNPCKHDQ,
            442 => x86_insn::X86_INS_PUNPCKHWD,
            443 => x86_insn::X86_INS_PUNPCKLBW,
            444 => x86_insn::X86_INS_PUNPCKLDQ,
            445 => x86_insn::X86_INS_PUNPCKLWD,
            446 => x86_insn::X86_INS_PXOR,
            447 => x86_insn::X86_INS_MONITOR,
            448 => x86_insn::X86_INS_MONTMUL,
            449 => x86_insn::X86_INS_MOV,
            450 => x86_insn::X86_INS_MOVABS,
            451 => x86_insn::X86_INS_MOVBE,
            452 => x86_insn::X86_INS_MOVDDUP,
            453 => x86_insn::X86_INS_MOVDQA,
            454 => x86_insn::X86_INS_MOVDQU,
            455 => x86_insn::X86_INS_MOVHLPS,
            456 => x86_insn::X86_INS_MOVHPD,
            457 => x86_insn::X86_INS_MOVHPS,
            458 => x86_insn::X86_INS_MOVLHPS,
            459 => x86_insn::X86_INS_MOVLPD,
            460 => x86_insn::X86_INS_MOVLPS,
            461 => x86_insn::X86_INS_MOVMSKPD,
            462 => x86_insn::X86_INS_MOVMSKPS,
            463 => x86_insn::X86_INS_MOVNTDQA,
            464 => x86_insn::X86_INS_MOVNTDQ,
            465 => x86_insn::X86_INS_MOVNTI,
            466 => x86_insn::X86_INS_MOVNTPD,
            467 => x86_insn::X86_INS_MOVNTPS,
            468 => x86_insn::X86_INS_MOVNTSD,
            469 => x86_insn::X86_INS_MOVNTSS,
            470 => x86_insn::X86_INS_MOVSB,
            471 => x86_insn::X86_INS_MOVSD,
            472 => x86_insn::X86_INS_MOVSHDUP,
            473 => x86_insn::X86_INS_MOVSLDUP,
            474 => x86_insn::X86_INS_MOVSQ,
            475 => x86_insn::X86_INS_MOVSS,
            476 => x86_insn::X86_INS_MOVSW,
            477 => x86_insn::X86_INS_MOVSX,
            478 => x86_insn::X86_INS_MOVSXD,
            479 => x86_insn::X86_INS_MOVUPD,
            480 => x86_insn::X86_INS_MOVUPS,
            481 => x86_insn::X86_INS_MOVZX,
            482 => x86_insn::X86_INS_MPSADBW,
            483 => x86_insn::X86_INS_MUL,
            484 => x86_insn::X86_INS_MULPD,
            485 => x86_insn::X86_INS_MULPS,
            486 => x86_insn::X86_INS_MULSD,
            487 => x86_insn::X86_INS_MULSS,
            488 => x86_insn::X86_INS_MULX,
            489 => x86_insn::X86_INS_FMUL,
            490 => x86_insn::X86_INS_FIMUL,
            491 => x86_insn::X86_INS_FMULP,
            492 => x86_insn::X86_INS_MWAIT,
            493 => x86_insn::X86_INS_NEG,
            494 => x86_insn::X86_INS_NOP,
            495 => x86_insn::X86_INS_NOT,
            496 => x86_insn::X86_INS_OUT,
            497 => x86_insn::X86_INS_OUTSB,
            498 => x86_insn::X86_INS_OUTSD,
            499 => x86_insn::X86_INS_OUTSW,
            500 => x86_insn::X86_INS_PACKUSDW,
            501 => x86_insn::X86_INS_PAUSE,
            502 => x86_insn::X86_INS_PAVGUSB,
            503 => x86_insn::X86_INS_PBLENDVB,
            504 => x86_insn::X86_INS_PBLENDW,
            505 => x86_insn::X86_INS_PCLMULQDQ,
            506 => x86_insn::X86_INS_PCMPEQQ,
            507 => x86_insn::X86_INS_PCMPESTRI,
            508 => x86_insn::X86_INS_PCMPESTRM,
            509 => x86_insn::X86_INS_PCMPGTQ,
            510 => x86_insn::X86_INS_PCMPISTRI,
            511 => x86_insn::X86_INS_PCMPISTRM,
            512 => x86_insn::X86_INS_PCOMMIT,
            513 => x86_insn::X86_INS_PDEP,
            514 => x86_insn::X86_INS_PEXT,
            515 => x86_insn::X86_INS_PEXTRB,
            516 => x86_insn::X86_INS_PEXTRD,
            517 => x86_insn::X86_INS_PEXTRQ,
            518 => x86_insn::X86_INS_PF2ID,
            519 => x86_insn::X86_INS_PF2IW,
            520 => x86_insn::X86_INS_PFACC,
            521 => x86_insn::X86_INS_PFADD,
            522 => x86_insn::X86_INS_PFCMPEQ,
            523 => x86_insn::X86_INS_PFCMPGE,
            524 => x86_insn::X86_INS_PFCMPGT,
            525 => x86_insn::X86_INS_PFMAX,
            526 => x86_insn::X86_INS_PFMIN,
            527 => x86_insn::X86_INS_PFMUL,
            528 => x86_insn::X86_INS_PFNACC,
            529 => x86_insn::X86_INS_PFPNACC,
            530 => x86_insn::X86_INS_PFRCPIT1,
            531 => x86_insn::X86_INS_PFRCPIT2,
            532 => x86_insn::X86_INS_PFRCP,
            533 => x86_insn::X86_INS_PFRSQIT1,
            534 => x86_insn::X86_INS_PFRSQRT,
            535 => x86_insn::X86_INS_PFSUBR,
            536 => x86_insn::X86_INS_PFSUB,
            537 => x86_insn::X86_INS_PHMINPOSUW,
            538 => x86_insn::X86_INS_PI2FD,
            539 => x86_insn::X86_INS_PI2FW,
            540 => x86_insn::X86_INS_PINSRB,
            541 => x86_insn::X86_INS_PINSRD,
            542 => x86_insn::X86_INS_PINSRQ,
            543 => x86_insn::X86_INS_PMAXSB,
            544 => x86_insn::X86_INS_PMAXSD,
            545 => x86_insn::X86_INS_PMAXUD,
            546 => x86_insn::X86_INS_PMAXUW,
            547 => x86_insn::X86_INS_PMINSB,
            548 => x86_insn::X86_INS_PMINSD,
            549 => x86_insn::X86_INS_PMINUD,
            550 => x86_insn::X86_INS_PMINUW,
            551 => x86_insn::X86_INS_PMOVSXBD,
            552 => x86_insn::X86_INS_PMOVSXBQ,
            553 => x86_insn::X86_INS_PMOVSXBW,
            554 => x86_insn::X86_INS_PMOVSXDQ,
            555 => x86_insn::X86_INS_PMOVSXWD,
            556 => x86_insn::X86_INS_PMOVSXWQ,
            557 => x86_insn::X86_INS_PMOVZXBD,
            558 => x86_insn::X86_INS_PMOVZXBQ,
            559 => x86_insn::X86_INS_PMOVZXBW,
            560 => x86_insn::X86_INS_PMOVZXDQ,
            561 => x86_insn::X86_INS_PMOVZXWD,
            562 => x86_insn::X86_INS_PMOVZXWQ,
            563 => x86_insn::X86_INS_PMULDQ,
            564 => x86_insn::X86_INS_PMULHRW,
            565 => x86_insn::X86_INS_PMULLD,
            566 => x86_insn::X86_INS_POP,
            567 => x86_insn::X86_INS_POPAW,
            568 => x86_insn::X86_INS_POPAL,
            569 => x86_insn::X86_INS_POPCNT,
            570 => x86_insn::X86_INS_POPF,
            571 => x86_insn::X86_INS_POPFD,
            572 => x86_insn::X86_INS_POPFQ,
            573 => x86_insn::X86_INS_PREFETCH,
            574 => x86_insn::X86_INS_PREFETCHNTA,
            575 => x86_insn::X86_INS_PREFETCHT0,
            576 => x86_insn::X86_INS_PREFETCHT1,
            577 => x86_insn::X86_INS_PREFETCHT2,
            578 => x86_insn::X86_INS_PREFETCHW,
            579 => x86_insn::X86_INS_PSHUFD,
            580 => x86_insn::X86_INS_PSHUFHW,
            581 => x86_insn::X86_INS_PSHUFLW,
            582 => x86_insn::X86_INS_PSLLDQ,
            583 => x86_insn::X86_INS_PSRLDQ,
            584 => x86_insn::X86_INS_PSWAPD,
            585 => x86_insn::X86_INS_PTEST,
            586 => x86_insn::X86_INS_PUNPCKHQDQ,
            587 => x86_insn::X86_INS_PUNPCKLQDQ,
            588 => x86_insn::X86_INS_PUSH,
            589 => x86_insn::X86_INS_PUSHAW,
            590 => x86_insn::X86_INS_PUSHAL,
            591 => x86_insn::X86_INS_PUSHF,
            592 => x86_insn::X86_INS_PUSHFD,
            593 => x86_insn::X86_INS_PUSHFQ,
            594 => x86_insn::X86_INS_RCL,
            595 => x86_insn::X86_INS_RCPPS,
            596 => x86_insn::X86_INS_RCPSS,
            597 => x86_insn::X86_INS_RCR,
            598 => x86_insn::X86_INS_RDFSBASE,
            599 => x86_insn::X86_INS_RDGSBASE,
            600 => x86_insn::X86_INS_RDMSR,
            601 => x86_insn::X86_INS_RDPMC,
            602 => x86_insn::X86_INS_RDRAND,
            603 => x86_insn::X86_INS_RDSEED,
            604 => x86_insn::X86_INS_RDTSC,
            605 => x86_insn::X86_INS_RDTSCP,
            606 => x86_insn::X86_INS_ROL,
            607 => x86_insn::X86_INS_ROR,
            608 => x86_insn::X86_INS_RORX,
            609 => x86_insn::X86_INS_ROUNDPD,
            610 => x86_insn::X86_INS_ROUNDPS,
            611 => x86_insn::X86_INS_ROUNDSD,
            612 => x86_insn::X86_INS_ROUNDSS,
            613 => x86_insn::X86_INS_RSM,
            614 => x86_insn::X86_INS_RSQRTPS,
            615 => x86_insn::X86_INS_RSQRTSS,
            616 => x86_insn::X86_INS_SAHF,
            617 => x86_insn::X86_INS_SAL,
            618 => x86_insn::X86_INS_SALC,
            619 => x86_insn::X86_INS_SAR,
            620 => x86_insn::X86_INS_SARX,
            621 => x86_insn::X86_INS_SBB,
            622 => x86_insn::X86_INS_SCASB,
            623 => x86_insn::X86_INS_SCASD,
            624 => x86_insn::X86_INS_SCASQ,
            625 => x86_insn::X86_INS_SCASW,
            626 => x86_insn::X86_INS_SETAE,
            627 => x86_insn::X86_INS_SETA,
            628 => x86_insn::X86_INS_SETBE,
            629 => x86_insn::X86_INS_SETB,
            630 => x86_insn::X86_INS_SETE,
            631 => x86_insn::X86_INS_SETGE,
            632 => x86_insn::X86_INS_SETG,
            633 => x86_insn::X86_INS_SETLE,
            634 => x86_insn::X86_INS_SETL,
            635 => x86_insn::X86_INS_SETNE,
            636 => x86_insn::X86_INS_SETNO,
            637 => x86_insn::X86_INS_SETNP,
            638 => x86_insn::X86_INS_SETNS,
            639 => x86_insn::X86_INS_SETO,
            640 => x86_insn::X86_INS_SETP,
            641 => x86_insn::X86_INS_SETS,
            642 => x86_insn::X86_INS_SFENCE,
            643 => x86_insn::X86_INS_SGDT,
            644 => x86_insn::X86_INS_SHA1MSG1,
            645 => x86_insn::X86_INS_SHA1MSG2,
            646 => x86_insn::X86_INS_SHA1NEXTE,
            647 => x86_insn::X86_INS_SHA1RNDS4,
            648 => x86_insn::X86_INS_SHA256MSG1,
            649 => x86_insn::X86_INS_SHA256MSG2,
            650 => x86_insn::X86_INS_SHA256RNDS2,
            651 => x86_insn::X86_INS_SHL,
            652 => x86_insn::X86_INS_SHLD,
            653 => x86_insn::X86_INS_SHLX,
            654 => x86_insn::X86_INS_SHR,
            655 => x86_insn::X86_INS_SHRD,
            656 => x86_insn::X86_INS_SHRX,
            657 => x86_insn::X86_INS_SHUFPD,
            658 => x86_insn::X86_INS_SHUFPS,
            659 => x86_insn::X86_INS_SIDT,
            660 => x86_insn::X86_INS_FSIN,
            661 => x86_insn::X86_INS_SKINIT,
            662 => x86_insn::X86_INS_SLDT,
            663 => x86_insn::X86_INS_SMSW,
            664 => x86_insn::X86_INS_SQRTPD,
            665 => x86_insn::X86_INS_SQRTPS,
            666 => x86_insn::X86_INS_SQRTSD,
            667 => x86_insn::X86_INS_SQRTSS,
            668 => x86_insn::X86_INS_FSQRT,
            669 => x86_insn::X86_INS_STAC,
            670 => x86_insn::X86_INS_STC,
            671 => x86_insn::X86_INS_STD,
            672 => x86_insn::X86_INS_STGI,
            673 => x86_insn::X86_INS_STI,
            674 => x86_insn::X86_INS_STMXCSR,
            675 => x86_insn::X86_INS_STOSB,
            676 => x86_insn::X86_INS_STOSD,
            677 => x86_insn::X86_INS_STOSQ,
            678 => x86_insn::X86_INS_STOSW,
            679 => x86_insn::X86_INS_STR,
            680 => x86_insn::X86_INS_FST,
            681 => x86_insn::X86_INS_FSTP,
            682 => x86_insn::X86_INS_FSTPNCE,
            683 => x86_insn::X86_INS_FXCH,
            684 => x86_insn::X86_INS_SUBPD,
            685 => x86_insn::X86_INS_SUBPS,
            686 => x86_insn::X86_INS_FSUBR,
            687 => x86_insn::X86_INS_FISUBR,
            688 => x86_insn::X86_INS_FSUBRP,
            689 => x86_insn::X86_INS_SUBSD,
            690 => x86_insn::X86_INS_SUBSS,
            691 => x86_insn::X86_INS_FSUB,
            692 => x86_insn::X86_INS_FISUB,
            693 => x86_insn::X86_INS_FSUBP,
            694 => x86_insn::X86_INS_SWAPGS,
            695 => x86_insn::X86_INS_SYSCALL,
            696 => x86_insn::X86_INS_SYSENTER,
            697 => x86_insn::X86_INS_SYSEXIT,
            698 => x86_insn::X86_INS_SYSRET,
            699 => x86_insn::X86_INS_T1MSKC,
            700 => x86_insn::X86_INS_TEST,
            701 => x86_insn::X86_INS_UD2,
            702 => x86_insn::X86_INS_FTST,
            703 => x86_insn::X86_INS_TZCNT,
            704 => x86_insn::X86_INS_TZMSK,
            705 => x86_insn::X86_INS_FUCOMIP,
            706 => x86_insn::X86_INS_FUCOMI,
            707 => x86_insn::X86_INS_FUCOMPP,
            708 => x86_insn::X86_INS_FUCOMP,
            709 => x86_insn::X86_INS_FUCOM,
            710 => x86_insn::X86_INS_UD2B,
            711 => x86_insn::X86_INS_UNPCKHPD,
            712 => x86_insn::X86_INS_UNPCKHPS,
            713 => x86_insn::X86_INS_UNPCKLPD,
            714 => x86_insn::X86_INS_UNPCKLPS,
            715 => x86_insn::X86_INS_VADDPD,
            716 => x86_insn::X86_INS_VADDPS,
            717 => x86_insn::X86_INS_VADDSD,
            718 => x86_insn::X86_INS_VADDSS,
            719 => x86_insn::X86_INS_VADDSUBPD,
            720 => x86_insn::X86_INS_VADDSUBPS,
            721 => x86_insn::X86_INS_VAESDECLAST,
            722 => x86_insn::X86_INS_VAESDEC,
            723 => x86_insn::X86_INS_VAESENCLAST,
            724 => x86_insn::X86_INS_VAESENC,
            725 => x86_insn::X86_INS_VAESIMC,
            726 => x86_insn::X86_INS_VAESKEYGENASSIST,
            727 => x86_insn::X86_INS_VALIGND,
            728 => x86_insn::X86_INS_VALIGNQ,
            729 => x86_insn::X86_INS_VANDNPD,
            730 => x86_insn::X86_INS_VANDNPS,
            731 => x86_insn::X86_INS_VANDPD,
            732 => x86_insn::X86_INS_VANDPS,
            733 => x86_insn::X86_INS_VBLENDMPD,
            734 => x86_insn::X86_INS_VBLENDMPS,
            735 => x86_insn::X86_INS_VBLENDPD,
            736 => x86_insn::X86_INS_VBLENDPS,
            737 => x86_insn::X86_INS_VBLENDVPD,
            738 => x86_insn::X86_INS_VBLENDVPS,
            739 => x86_insn::X86_INS_VBROADCASTF128,
            740 => x86_insn::X86_INS_VBROADCASTI32X4,
            741 => x86_insn::X86_INS_VBROADCASTI64X4,
            742 => x86_insn::X86_INS_VBROADCASTSD,
            743 => x86_insn::X86_INS_VBROADCASTSS,
            744 => x86_insn::X86_INS_VCOMPRESSPD,
            745 => x86_insn::X86_INS_VCOMPRESSPS,
            746 => x86_insn::X86_INS_VCVTDQ2PD,
            747 => x86_insn::X86_INS_VCVTDQ2PS,
            748 => x86_insn::X86_INS_VCVTPD2DQX,
            749 => x86_insn::X86_INS_VCVTPD2DQ,
            750 => x86_insn::X86_INS_VCVTPD2PSX,
            751 => x86_insn::X86_INS_VCVTPD2PS,
            752 => x86_insn::X86_INS_VCVTPD2UDQ,
            753 => x86_insn::X86_INS_VCVTPH2PS,
            754 => x86_insn::X86_INS_VCVTPS2DQ,
            755 => x86_insn::X86_INS_VCVTPS2PD,
            756 => x86_insn::X86_INS_VCVTPS2PH,
            757 => x86_insn::X86_INS_VCVTPS2UDQ,
            758 => x86_insn::X86_INS_VCVTSD2SI,
            759 => x86_insn::X86_INS_VCVTSD2USI,
            760 => x86_insn::X86_INS_VCVTSS2SI,
            761 => x86_insn::X86_INS_VCVTSS2USI,
            762 => x86_insn::X86_INS_VCVTTPD2DQX,
            763 => x86_insn::X86_INS_VCVTTPD2DQ,
            764 => x86_insn::X86_INS_VCVTTPD2UDQ,
            765 => x86_insn::X86_INS_VCVTTPS2DQ,
            766 => x86_insn::X86_INS_VCVTTPS2UDQ,
            767 => x86_insn::X86_INS_VCVTUDQ2PD,
            768 => x86_insn::X86_INS_VCVTUDQ2PS,
            769 => x86_insn::X86_INS_VDIVPD,
            770 => x86_insn::X86_INS_VDIVPS,
            771 => x86_insn::X86_INS_VDIVSD,
            772 => x86_insn::X86_INS_VDIVSS,
            773 => x86_insn::X86_INS_VDPPD,
            774 => x86_insn::X86_INS_VDPPS,
            775 => x86_insn::X86_INS_VERR,
            776 => x86_insn::X86_INS_VERW,
            777 => x86_insn::X86_INS_VEXP2PD,
            778 => x86_insn::X86_INS_VEXP2PS,
            779 => x86_insn::X86_INS_VEXPANDPD,
            780 => x86_insn::X86_INS_VEXPANDPS,
            781 => x86_insn::X86_INS_VEXTRACTF128,
            782 => x86_insn::X86_INS_VEXTRACTF32X4,
            783 => x86_insn::X86_INS_VEXTRACTF64X4,
            784 => x86_insn::X86_INS_VEXTRACTI128,
            785 => x86_insn::X86_INS_VEXTRACTI32X4,
            786 => x86_insn::X86_INS_VEXTRACTI64X4,
            787 => x86_insn::X86_INS_VEXTRACTPS,
            788 => x86_insn::X86_INS_VFMADD132PD,
            789 => x86_insn::X86_INS_VFMADD132PS,
            790 => x86_insn::X86_INS_VFMADDPD,
            791 => x86_insn::X86_INS_VFMADD213PD,
            792 => x86_insn::X86_INS_VFMADD231PD,
            793 => x86_insn::X86_INS_VFMADDPS,
            794 => x86_insn::X86_INS_VFMADD213PS,
            795 => x86_insn::X86_INS_VFMADD231PS,
            796 => x86_insn::X86_INS_VFMADDSD,
            797 => x86_insn::X86_INS_VFMADD213SD,
            798 => x86_insn::X86_INS_VFMADD132SD,
            799 => x86_insn::X86_INS_VFMADD231SD,
            800 => x86_insn::X86_INS_VFMADDSS,
            801 => x86_insn::X86_INS_VFMADD213SS,
            802 => x86_insn::X86_INS_VFMADD132SS,
            803 => x86_insn::X86_INS_VFMADD231SS,
            804 => x86_insn::X86_INS_VFMADDSUB132PD,
            805 => x86_insn::X86_INS_VFMADDSUB132PS,
            806 => x86_insn::X86_INS_VFMADDSUBPD,
            807 => x86_insn::X86_INS_VFMADDSUB213PD,
            808 => x86_insn::X86_INS_VFMADDSUB231PD,
            809 => x86_insn::X86_INS_VFMADDSUBPS,
            810 => x86_insn::X86_INS_VFMADDSUB213PS,
            811 => x86_insn::X86_INS_VFMADDSUB231PS,
            812 => x86_insn::X86_INS_VFMSUB132PD,
            813 => x86_insn::X86_INS_VFMSUB132PS,
            814 => x86_insn::X86_INS_VFMSUBADD132PD,
            815 => x86_insn::X86_INS_VFMSUBADD132PS,
            816 => x86_insn::X86_INS_VFMSUBADDPD,
            817 => x86_insn::X86_INS_VFMSUBADD213PD,
            818 => x86_insn::X86_INS_VFMSUBADD231PD,
            819 => x86_insn::X86_INS_VFMSUBADDPS,
            820 => x86_insn::X86_INS_VFMSUBADD213PS,
            821 => x86_insn::X86_INS_VFMSUBADD231PS,
            822 => x86_insn::X86_INS_VFMSUBPD,
            823 => x86_insn::X86_INS_VFMSUB213PD,
            824 => x86_insn::X86_INS_VFMSUB231PD,
            825 => x86_insn::X86_INS_VFMSUBPS,
            826 => x86_insn::X86_INS_VFMSUB213PS,
            827 => x86_insn::X86_INS_VFMSUB231PS,
            828 => x86_insn::X86_INS_VFMSUBSD,
            829 => x86_insn::X86_INS_VFMSUB213SD,
            830 => x86_insn::X86_INS_VFMSUB132SD,
            831 => x86_insn::X86_INS_VFMSUB231SD,
            832 => x86_insn::X86_INS_VFMSUBSS,
            833 => x86_insn::X86_INS_VFMSUB213SS,
            834 => x86_insn::X86_INS_VFMSUB132SS,
            835 => x86_insn::X86_INS_VFMSUB231SS,
            836 => x86_insn::X86_INS_VFNMADD132PD,
            837 => x86_insn::X86_INS_VFNMADD132PS,
            838 => x86_insn::X86_INS_VFNMADDPD,
            839 => x86_insn::X86_INS_VFNMADD213PD,
            840 => x86_insn::X86_INS_VFNMADD231PD,
            841 => x86_insn::X86_INS_VFNMADDPS,
            842 => x86_insn::X86_INS_VFNMADD213PS,
            843 => x86_insn::X86_INS_VFNMADD231PS,
            844 => x86_insn::X86_INS_VFNMADDSD,
            845 => x86_insn::X86_INS_VFNMADD213SD,
            846 => x86_insn::X86_INS_VFNMADD132SD,
            847 => x86_insn::X86_INS_VFNMADD231SD,
            848 => x86_insn::X86_INS_VFNMADDSS,
            849 => x86_insn::X86_INS_VFNMADD213SS,
            850 => x86_insn::X86_INS_VFNMADD132SS,
            851 => x86_insn::X86_INS_VFNMADD231SS,
            852 => x86_insn::X86_INS_VFNMSUB132PD,
            853 => x86_insn::X86_INS_VFNMSUB132PS,
            854 => x86_insn::X86_INS_VFNMSUBPD,
            855 => x86_insn::X86_INS_VFNMSUB213PD,
            856 => x86_insn::X86_INS_VFNMSUB231PD,
            857 => x86_insn::X86_INS_VFNMSUBPS,
            858 => x86_insn::X86_INS_VFNMSUB213PS,
            859 => x86_insn::X86_INS_VFNMSUB231PS,
            860 => x86_insn::X86_INS_VFNMSUBSD,
            861 => x86_insn::X86_INS_VFNMSUB213SD,
            862 => x86_insn::X86_INS_VFNMSUB132SD,
            863 => x86_insn::X86_INS_VFNMSUB231SD,
            864 => x86_insn::X86_INS_VFNMSUBSS,
            865 => x86_insn::X86_INS_VFNMSUB213SS,
            866 => x86_insn::X86_INS_VFNMSUB132SS,
            867 => x86_insn::X86_INS_VFNMSUB231SS,
            868 => x86_insn::X86_INS_VFRCZPD,
            869 => x86_insn::X86_INS_VFRCZPS,
            870 => x86_insn::X86_INS_VFRCZSD,
            871 => x86_insn::X86_INS_VFRCZSS,
            872 => x86_insn::X86_INS_VORPD,
            873 => x86_insn::X86_INS_VORPS,
            874 => x86_insn::X86_INS_VXORPD,
            875 => x86_insn::X86_INS_VXORPS,
            876 => x86_insn::X86_INS_VGATHERDPD,
            877 => x86_insn::X86_INS_VGATHERDPS,
            878 => x86_insn::X86_INS_VGATHERPF0DPD,
            879 => x86_insn::X86_INS_VGATHERPF0DPS,
            880 => x86_insn::X86_INS_VGATHERPF0QPD,
            881 => x86_insn::X86_INS_VGATHERPF0QPS,
            882 => x86_insn::X86_INS_VGATHERPF1DPD,
            883 => x86_insn::X86_INS_VGATHERPF1DPS,
            884 => x86_insn::X86_INS_VGATHERPF1QPD,
            885 => x86_insn::X86_INS_VGATHERPF1QPS,
            886 => x86_insn::X86_INS_VGATHERQPD,
            887 => x86_insn::X86_INS_VGATHERQPS,
            888 => x86_insn::X86_INS_VHADDPD,
            889 => x86_insn::X86_INS_VHADDPS,
            890 => x86_insn::X86_INS_VHSUBPD,
            891 => x86_insn::X86_INS_VHSUBPS,
            892 => x86_insn::X86_INS_VINSERTF128,
            893 => x86_insn::X86_INS_VINSERTF32X4,
            894 => x86_insn::X86_INS_VINSERTF32X8,
            895 => x86_insn::X86_INS_VINSERTF64X2,
            896 => x86_insn::X86_INS_VINSERTF64X4,
            897 => x86_insn::X86_INS_VINSERTI128,
            898 => x86_insn::X86_INS_VINSERTI32X4,
            899 => x86_insn::X86_INS_VINSERTI32X8,
            900 => x86_insn::X86_INS_VINSERTI64X2,
            901 => x86_insn::X86_INS_VINSERTI64X4,
            902 => x86_insn::X86_INS_VINSERTPS,
            903 => x86_insn::X86_INS_VLDDQU,
            904 => x86_insn::X86_INS_VLDMXCSR,
            905 => x86_insn::X86_INS_VMASKMOVDQU,
            906 => x86_insn::X86_INS_VMASKMOVPD,
            907 => x86_insn::X86_INS_VMASKMOVPS,
            908 => x86_insn::X86_INS_VMAXPD,
            909 => x86_insn::X86_INS_VMAXPS,
            910 => x86_insn::X86_INS_VMAXSD,
            911 => x86_insn::X86_INS_VMAXSS,
            912 => x86_insn::X86_INS_VMCALL,
            913 => x86_insn::X86_INS_VMCLEAR,
            914 => x86_insn::X86_INS_VMFUNC,
            915 => x86_insn::X86_INS_VMINPD,
            916 => x86_insn::X86_INS_VMINPS,
            917 => x86_insn::X86_INS_VMINSD,
            918 => x86_insn::X86_INS_VMINSS,
            919 => x86_insn::X86_INS_VMLAUNCH,
            920 => x86_insn::X86_INS_VMLOAD,
            921 => x86_insn::X86_INS_VMMCALL,
            922 => x86_insn::X86_INS_VMOVQ,
            923 => x86_insn::X86_INS_VMOVDDUP,
            924 => x86_insn::X86_INS_VMOVD,
            925 => x86_insn::X86_INS_VMOVDQA32,
            926 => x86_insn::X86_INS_VMOVDQA64,
            927 => x86_insn::X86_INS_VMOVDQA,
            928 => x86_insn::X86_INS_VMOVDQU16,
            929 => x86_insn::X86_INS_VMOVDQU32,
            930 => x86_insn::X86_INS_VMOVDQU64,
            931 => x86_insn::X86_INS_VMOVDQU8,
            932 => x86_insn::X86_INS_VMOVDQU,
            933 => x86_insn::X86_INS_VMOVHLPS,
            934 => x86_insn::X86_INS_VMOVHPD,
            935 => x86_insn::X86_INS_VMOVHPS,
            936 => x86_insn::X86_INS_VMOVLHPS,
            937 => x86_insn::X86_INS_VMOVLPD,
            938 => x86_insn::X86_INS_VMOVLPS,
            939 => x86_insn::X86_INS_VMOVMSKPD,
            940 => x86_insn::X86_INS_VMOVMSKPS,
            941 => x86_insn::X86_INS_VMOVNTDQA,
            942 => x86_insn::X86_INS_VMOVNTDQ,
            943 => x86_insn::X86_INS_VMOVNTPD,
            944 => x86_insn::X86_INS_VMOVNTPS,
            945 => x86_insn::X86_INS_VMOVSD,
            946 => x86_insn::X86_INS_VMOVSHDUP,
            947 => x86_insn::X86_INS_VMOVSLDUP,
            948 => x86_insn::X86_INS_VMOVSS,
            949 => x86_insn::X86_INS_VMOVUPD,
            950 => x86_insn::X86_INS_VMOVUPS,
            951 => x86_insn::X86_INS_VMPSADBW,
            952 => x86_insn::X86_INS_VMPTRLD,
            953 => x86_insn::X86_INS_VMPTRST,
            954 => x86_insn::X86_INS_VMREAD,
            955 => x86_insn::X86_INS_VMRESUME,
            956 => x86_insn::X86_INS_VMRUN,
            957 => x86_insn::X86_INS_VMSAVE,
            958 => x86_insn::X86_INS_VMULPD,
            959 => x86_insn::X86_INS_VMULPS,
            960 => x86_insn::X86_INS_VMULSD,
            961 => x86_insn::X86_INS_VMULSS,
            962 => x86_insn::X86_INS_VMWRITE,
            963 => x86_insn::X86_INS_VMXOFF,
            964 => x86_insn::X86_INS_VMXON,
            965 => x86_insn::X86_INS_VPABSB,
            966 => x86_insn::X86_INS_VPABSD,
            967 => x86_insn::X86_INS_VPABSQ,
            968 => x86_insn::X86_INS_VPABSW,
            969 => x86_insn::X86_INS_VPACKSSDW,
            970 => x86_insn::X86_INS_VPACKSSWB,
            971 => x86_insn::X86_INS_VPACKUSDW,
            972 => x86_insn::X86_INS_VPACKUSWB,
            973 => x86_insn::X86_INS_VPADDB,
            974 => x86_insn::X86_INS_VPADDD,
            975 => x86_insn::X86_INS_VPADDQ,
            976 => x86_insn::X86_INS_VPADDSB,
            977 => x86_insn::X86_INS_VPADDSW,
            978 => x86_insn::X86_INS_VPADDUSB,
            979 => x86_insn::X86_INS_VPADDUSW,
            980 => x86_insn::X86_INS_VPADDW,
            981 => x86_insn::X86_INS_VPALIGNR,
            982 => x86_insn::X86_INS_VPANDD,
            983 => x86_insn::X86_INS_VPANDND,
            984 => x86_insn::X86_INS_VPANDNQ,
            985 => x86_insn::X86_INS_VPANDN,
            986 => x86_insn::X86_INS_VPANDQ,
            987 => x86_insn::X86_INS_VPAND,
            988 => x86_insn::X86_INS_VPAVGB,
            989 => x86_insn::X86_INS_VPAVGW,
            990 => x86_insn::X86_INS_VPBLENDD,
            991 => x86_insn::X86_INS_VPBLENDMB,
            992 => x86_insn::X86_INS_VPBLENDMD,
            993 => x86_insn::X86_INS_VPBLENDMQ,
            994 => x86_insn::X86_INS_VPBLENDMW,
            995 => x86_insn::X86_INS_VPBLENDVB,
            996 => x86_insn::X86_INS_VPBLENDW,
            997 => x86_insn::X86_INS_VPBROADCASTB,
            998 => x86_insn::X86_INS_VPBROADCASTD,
            999 => x86_insn::X86_INS_VPBROADCASTMB2Q,
            1000 => x86_insn::X86_INS_VPBROADCASTMW2D,
            1001 => x86_insn::X86_INS_VPBROADCASTQ,
            1002 => x86_insn::X86_INS_VPBROADCASTW,
            1003 => x86_insn::X86_INS_VPCLMULQDQ,
            1004 => x86_insn::X86_INS_VPCMOV,
            1005 => x86_insn::X86_INS_VPCMPB,
            1006 => x86_insn::X86_INS_VPCMPD,
            1007 => x86_insn::X86_INS_VPCMPEQB,
            1008 => x86_insn::X86_INS_VPCMPEQD,
            1009 => x86_insn::X86_INS_VPCMPEQQ,
            1010 => x86_insn::X86_INS_VPCMPEQW,
            1011 => x86_insn::X86_INS_VPCMPESTRI,
            1012 => x86_insn::X86_INS_VPCMPESTRM,
            1013 => x86_insn::X86_INS_VPCMPGTB,
            1014 => x86_insn::X86_INS_VPCMPGTD,
            1015 => x86_insn::X86_INS_VPCMPGTQ,
            1016 => x86_insn::X86_INS_VPCMPGTW,
            1017 => x86_insn::X86_INS_VPCMPISTRI,
            1018 => x86_insn::X86_INS_VPCMPISTRM,
            1019 => x86_insn::X86_INS_VPCMPQ,
            1020 => x86_insn::X86_INS_VPCMPUB,
            1021 => x86_insn::X86_INS_VPCMPUD,
            1022 => x86_insn::X86_INS_VPCMPUQ,
            1023 => x86_insn::X86_INS_VPCMPUW,
            1024 => x86_insn::X86_INS_VPCMPW,
            1025 => x86_insn::X86_INS_VPCOMB,
            1026 => x86_insn::X86_INS_VPCOMD,
            1027 => x86_insn::X86_INS_VPCOMPRESSD,
            1028 => x86_insn::X86_INS_VPCOMPRESSQ,
            1029 => x86_insn::X86_INS_VPCOMQ,
            1030 => x86_insn::X86_INS_VPCOMUB,
            1031 => x86_insn::X86_INS_VPCOMUD,
            1032 => x86_insn::X86_INS_VPCOMUQ,
            1033 => x86_insn::X86_INS_VPCOMUW,
            1034 => x86_insn::X86_INS_VPCOMW,
            1035 => x86_insn::X86_INS_VPCONFLICTD,
            1036 => x86_insn::X86_INS_VPCONFLICTQ,
            1037 => x86_insn::X86_INS_VPERM2F128,
            1038 => x86_insn::X86_INS_VPERM2I128,
            1039 => x86_insn::X86_INS_VPERMD,
            1040 => x86_insn::X86_INS_VPERMI2D,
            1041 => x86_insn::X86_INS_VPERMI2PD,
            1042 => x86_insn::X86_INS_VPERMI2PS,
            1043 => x86_insn::X86_INS_VPERMI2Q,
            1044 => x86_insn::X86_INS_VPERMIL2PD,
            1045 => x86_insn::X86_INS_VPERMIL2PS,
            1046 => x86_insn::X86_INS_VPERMILPD,
            1047 => x86_insn::X86_INS_VPERMILPS,
            1048 => x86_insn::X86_INS_VPERMPD,
            1049 => x86_insn::X86_INS_VPERMPS,
            1050 => x86_insn::X86_INS_VPERMQ,
            1051 => x86_insn::X86_INS_VPERMT2D,
            1052 => x86_insn::X86_INS_VPERMT2PD,
            1053 => x86_insn::X86_INS_VPERMT2PS,
            1054 => x86_insn::X86_INS_VPERMT2Q,
            1055 => x86_insn::X86_INS_VPEXPANDD,
            1056 => x86_insn::X86_INS_VPEXPANDQ,
            1057 => x86_insn::X86_INS_VPEXTRB,
            1058 => x86_insn::X86_INS_VPEXTRD,
            1059 => x86_insn::X86_INS_VPEXTRQ,
            1060 => x86_insn::X86_INS_VPEXTRW,
            1061 => x86_insn::X86_INS_VPGATHERDD,
            1062 => x86_insn::X86_INS_VPGATHERDQ,
            1063 => x86_insn::X86_INS_VPGATHERQD,
            1064 => x86_insn::X86_INS_VPGATHERQQ,
            1065 => x86_insn::X86_INS_VPHADDBD,
            1066 => x86_insn::X86_INS_VPHADDBQ,
            1067 => x86_insn::X86_INS_VPHADDBW,
            1068 => x86_insn::X86_INS_VPHADDDQ,
            1069 => x86_insn::X86_INS_VPHADDD,
            1070 => x86_insn::X86_INS_VPHADDSW,
            1071 => x86_insn::X86_INS_VPHADDUBD,
            1072 => x86_insn::X86_INS_VPHADDUBQ,
            1073 => x86_insn::X86_INS_VPHADDUBW,
            1074 => x86_insn::X86_INS_VPHADDUDQ,
            1075 => x86_insn::X86_INS_VPHADDUWD,
            1076 => x86_insn::X86_INS_VPHADDUWQ,
            1077 => x86_insn::X86_INS_VPHADDWD,
            1078 => x86_insn::X86_INS_VPHADDWQ,
            1079 => x86_insn::X86_INS_VPHADDW,
            1080 => x86_insn::X86_INS_VPHMINPOSUW,
            1081 => x86_insn::X86_INS_VPHSUBBW,
            1082 => x86_insn::X86_INS_VPHSUBDQ,
            1083 => x86_insn::X86_INS_VPHSUBD,
            1084 => x86_insn::X86_INS_VPHSUBSW,
            1085 => x86_insn::X86_INS_VPHSUBWD,
            1086 => x86_insn::X86_INS_VPHSUBW,
            1087 => x86_insn::X86_INS_VPINSRB,
            1088 => x86_insn::X86_INS_VPINSRD,
            1089 => x86_insn::X86_INS_VPINSRQ,
            1090 => x86_insn::X86_INS_VPINSRW,
            1091 => x86_insn::X86_INS_VPLZCNTD,
            1092 => x86_insn::X86_INS_VPLZCNTQ,
            1093 => x86_insn::X86_INS_VPMACSDD,
            1094 => x86_insn::X86_INS_VPMACSDQH,
            1095 => x86_insn::X86_INS_VPMACSDQL,
            1096 => x86_insn::X86_INS_VPMACSSDD,
            1097 => x86_insn::X86_INS_VPMACSSDQH,
            1098 => x86_insn::X86_INS_VPMACSSDQL,
            1099 => x86_insn::X86_INS_VPMACSSWD,
            1100 => x86_insn::X86_INS_VPMACSSWW,
            1101 => x86_insn::X86_INS_VPMACSWD,
            1102 => x86_insn::X86_INS_VPMACSWW,
            1103 => x86_insn::X86_INS_VPMADCSSWD,
            1104 => x86_insn::X86_INS_VPMADCSWD,
            1105 => x86_insn::X86_INS_VPMADDUBSW,
            1106 => x86_insn::X86_INS_VPMADDWD,
            1107 => x86_insn::X86_INS_VPMASKMOVD,
            1108 => x86_insn::X86_INS_VPMASKMOVQ,
            1109 => x86_insn::X86_INS_VPMAXSB,
            1110 => x86_insn::X86_INS_VPMAXSD,
            1111 => x86_insn::X86_INS_VPMAXSQ,
            1112 => x86_insn::X86_INS_VPMAXSW,
            1113 => x86_insn::X86_INS_VPMAXUB,
            1114 => x86_insn::X86_INS_VPMAXUD,
            1115 => x86_insn::X86_INS_VPMAXUQ,
            1116 => x86_insn::X86_INS_VPMAXUW,
            1117 => x86_insn::X86_INS_VPMINSB,
            1118 => x86_insn::X86_INS_VPMINSD,
            1119 => x86_insn::X86_INS_VPMINSQ,
            1120 => x86_insn::X86_INS_VPMINSW,
            1121 => x86_insn::X86_INS_VPMINUB,
            1122 => x86_insn::X86_INS_VPMINUD,
            1123 => x86_insn::X86_INS_VPMINUQ,
            1124 => x86_insn::X86_INS_VPMINUW,
            1125 => x86_insn::X86_INS_VPMOVDB,
            1126 => x86_insn::X86_INS_VPMOVDW,
            1127 => x86_insn::X86_INS_VPMOVM2B,
            1128 => x86_insn::X86_INS_VPMOVM2D,
            1129 => x86_insn::X86_INS_VPMOVM2Q,
            1130 => x86_insn::X86_INS_VPMOVM2W,
            1131 => x86_insn::X86_INS_VPMOVMSKB,
            1132 => x86_insn::X86_INS_VPMOVQB,
            1133 => x86_insn::X86_INS_VPMOVQD,
            1134 => x86_insn::X86_INS_VPMOVQW,
            1135 => x86_insn::X86_INS_VPMOVSDB,
            1136 => x86_insn::X86_INS_VPMOVSDW,
            1137 => x86_insn::X86_INS_VPMOVSQB,
            1138 => x86_insn::X86_INS_VPMOVSQD,
            1139 => x86_insn::X86_INS_VPMOVSQW,
            1140 => x86_insn::X86_INS_VPMOVSXBD,
            1141 => x86_insn::X86_INS_VPMOVSXBQ,
            1142 => x86_insn::X86_INS_VPMOVSXBW,
            1143 => x86_insn::X86_INS_VPMOVSXDQ,
            1144 => x86_insn::X86_INS_VPMOVSXWD,
            1145 => x86_insn::X86_INS_VPMOVSXWQ,
            1146 => x86_insn::X86_INS_VPMOVUSDB,
            1147 => x86_insn::X86_INS_VPMOVUSDW,
            1148 => x86_insn::X86_INS_VPMOVUSQB,
            1149 => x86_insn::X86_INS_VPMOVUSQD,
            1150 => x86_insn::X86_INS_VPMOVUSQW,
            1151 => x86_insn::X86_INS_VPMOVZXBD,
            1152 => x86_insn::X86_INS_VPMOVZXBQ,
            1153 => x86_insn::X86_INS_VPMOVZXBW,
            1154 => x86_insn::X86_INS_VPMOVZXDQ,
            1155 => x86_insn::X86_INS_VPMOVZXWD,
            1156 => x86_insn::X86_INS_VPMOVZXWQ,
            1157 => x86_insn::X86_INS_VPMULDQ,
            1158 => x86_insn::X86_INS_VPMULHRSW,
            1159 => x86_insn::X86_INS_VPMULHUW,
            1160 => x86_insn::X86_INS_VPMULHW,
            1161 => x86_insn::X86_INS_VPMULLD,
            1162 => x86_insn::X86_INS_VPMULLQ,
            1163 => x86_insn::X86_INS_VPMULLW,
            1164 => x86_insn::X86_INS_VPMULUDQ,
            1165 => x86_insn::X86_INS_VPORD,
            1166 => x86_insn::X86_INS_VPORQ,
            1167 => x86_insn::X86_INS_VPOR,
            1168 => x86_insn::X86_INS_VPPERM,
            1169 => x86_insn::X86_INS_VPROTB,
            1170 => x86_insn::X86_INS_VPROTD,
            1171 => x86_insn::X86_INS_VPROTQ,
            1172 => x86_insn::X86_INS_VPROTW,
            1173 => x86_insn::X86_INS_VPSADBW,
            1174 => x86_insn::X86_INS_VPSCATTERDD,
            1175 => x86_insn::X86_INS_VPSCATTERDQ,
            1176 => x86_insn::X86_INS_VPSCATTERQD,
            1177 => x86_insn::X86_INS_VPSCATTERQQ,
            1178 => x86_insn::X86_INS_VPSHAB,
            1179 => x86_insn::X86_INS_VPSHAD,
            1180 => x86_insn::X86_INS_VPSHAQ,
            1181 => x86_insn::X86_INS_VPSHAW,
            1182 => x86_insn::X86_INS_VPSHLB,
            1183 => x86_insn::X86_INS_VPSHLD,
            1184 => x86_insn::X86_INS_VPSHLQ,
            1185 => x86_insn::X86_INS_VPSHLW,
            1186 => x86_insn::X86_INS_VPSHUFB,
            1187 => x86_insn::X86_INS_VPSHUFD,
            1188 => x86_insn::X86_INS_VPSHUFHW,
            1189 => x86_insn::X86_INS_VPSHUFLW,
            1190 => x86_insn::X86_INS_VPSIGNB,
            1191 => x86_insn::X86_INS_VPSIGND,
            1192 => x86_insn::X86_INS_VPSIGNW,
            1193 => x86_insn::X86_INS_VPSLLDQ,
            1194 => x86_insn::X86_INS_VPSLLD,
            1195 => x86_insn::X86_INS_VPSLLQ,
            1196 => x86_insn::X86_INS_VPSLLVD,
            1197 => x86_insn::X86_INS_VPSLLVQ,
            1198 => x86_insn::X86_INS_VPSLLW,
            1199 => x86_insn::X86_INS_VPSRAD,
            1200 => x86_insn::X86_INS_VPSRAQ,
            1201 => x86_insn::X86_INS_VPSRAVD,
            1202 => x86_insn::X86_INS_VPSRAVQ,
            1203 => x86_insn::X86_INS_VPSRAW,
            1204 => x86_insn::X86_INS_VPSRLDQ,
            1205 => x86_insn::X86_INS_VPSRLD,
            1206 => x86_insn::X86_INS_VPSRLQ,
            1207 => x86_insn::X86_INS_VPSRLVD,
            1208 => x86_insn::X86_INS_VPSRLVQ,
            1209 => x86_insn::X86_INS_VPSRLW,
            1210 => x86_insn::X86_INS_VPSUBB,
            1211 => x86_insn::X86_INS_VPSUBD,
            1212 => x86_insn::X86_INS_VPSUBQ,
            1213 => x86_insn::X86_INS_VPSUBSB,
            1214 => x86_insn::X86_INS_VPSUBSW,
            1215 => x86_insn::X86_INS_VPSUBUSB,
            1216 => x86_insn::X86_INS_VPSUBUSW,
            1217 => x86_insn::X86_INS_VPSUBW,
            1218 => x86_insn::X86_INS_VPTESTMD,
            1219 => x86_insn::X86_INS_VPTESTMQ,
            1220 => x86_insn::X86_INS_VPTESTNMD,
            1221 => x86_insn::X86_INS_VPTESTNMQ,
            1222 => x86_insn::X86_INS_VPTEST,
            1223 => x86_insn::X86_INS_VPUNPCKHBW,
            1224 => x86_insn::X86_INS_VPUNPCKHDQ,
            1225 => x86_insn::X86_INS_VPUNPCKHQDQ,
            1226 => x86_insn::X86_INS_VPUNPCKHWD,
            1227 => x86_insn::X86_INS_VPUNPCKLBW,
            1228 => x86_insn::X86_INS_VPUNPCKLDQ,
            1229 => x86_insn::X86_INS_VPUNPCKLQDQ,
            1230 => x86_insn::X86_INS_VPUNPCKLWD,
            1231 => x86_insn::X86_INS_VPXORD,
            1232 => x86_insn::X86_INS_VPXORQ,
            1233 => x86_insn::X86_INS_VPXOR,
            1234 => x86_insn::X86_INS_VRCP14PD,
            1235 => x86_insn::X86_INS_VRCP14PS,
            1236 => x86_insn::X86_INS_VRCP14SD,
            1237 => x86_insn::X86_INS_VRCP14SS,
            1238 => x86_insn::X86_INS_VRCP28PD,
            1239 => x86_insn::X86_INS_VRCP28PS,
            1240 => x86_insn::X86_INS_VRCP28SD,
            1241 => x86_insn::X86_INS_VRCP28SS,
            1242 => x86_insn::X86_INS_VRCPPS,
            1243 => x86_insn::X86_INS_VRCPSS,
            1244 => x86_insn::X86_INS_VRNDSCALEPD,
            1245 => x86_insn::X86_INS_VRNDSCALEPS,
            1246 => x86_insn::X86_INS_VRNDSCALESD,
            1247 => x86_insn::X86_INS_VRNDSCALESS,
            1248 => x86_insn::X86_INS_VROUNDPD,
            1249 => x86_insn::X86_INS_VROUNDPS,
            1250 => x86_insn::X86_INS_VROUNDSD,
            1251 => x86_insn::X86_INS_VROUNDSS,
            1252 => x86_insn::X86_INS_VRSQRT14PD,
            1253 => x86_insn::X86_INS_VRSQRT14PS,
            1254 => x86_insn::X86_INS_VRSQRT14SD,
            1255 => x86_insn::X86_INS_VRSQRT14SS,
            1256 => x86_insn::X86_INS_VRSQRT28PD,
            1257 => x86_insn::X86_INS_VRSQRT28PS,
            1258 => x86_insn::X86_INS_VRSQRT28SD,
            1259 => x86_insn::X86_INS_VRSQRT28SS,
            1260 => x86_insn::X86_INS_VRSQRTPS,
            1261 => x86_insn::X86_INS_VRSQRTSS,
            1262 => x86_insn::X86_INS_VSCATTERDPD,
            1263 => x86_insn::X86_INS_VSCATTERDPS,
            1264 => x86_insn::X86_INS_VSCATTERPF0DPD,
            1265 => x86_insn::X86_INS_VSCATTERPF0DPS,
            1266 => x86_insn::X86_INS_VSCATTERPF0QPD,
            1267 => x86_insn::X86_INS_VSCATTERPF0QPS,
            1268 => x86_insn::X86_INS_VSCATTERPF1DPD,
            1269 => x86_insn::X86_INS_VSCATTERPF1DPS,
            1270 => x86_insn::X86_INS_VSCATTERPF1QPD,
            1271 => x86_insn::X86_INS_VSCATTERPF1QPS,
            1272 => x86_insn::X86_INS_VSCATTERQPD,
            1273 => x86_insn::X86_INS_VSCATTERQPS,
            1274 => x86_insn::X86_INS_VSHUFPD,
            1275 => x86_insn::X86_INS_VSHUFPS,
            1276 => x86_insn::X86_INS_VSQRTPD,
            1277 => x86_insn::X86_INS_VSQRTPS,
            1278 => x86_insn::X86_INS_VSQRTSD,
            1279 => x86_insn::X86_INS_VSQRTSS,
            1280 => x86_insn::X86_INS_VSTMXCSR,
            1281 => x86_insn::X86_INS_VSUBPD,
            1282 => x86_insn::X86_INS_VSUBPS,
            1283 => x86_insn::X86_INS_VSUBSD,
            1284 => x86_insn::X86_INS_VSUBSS,
            1285 => x86_insn::X86_INS_VTESTPD,
            1286 => x86_insn::X86_INS_VTESTPS,
            1287 => x86_insn::X86_INS_VUNPCKHPD,
            1288 => x86_insn::X86_INS_VUNPCKHPS,
            1289 => x86_insn::X86_INS_VUNPCKLPD,
            1290 => x86_insn::X86_INS_VUNPCKLPS,
            1291 => x86_insn::X86_INS_VZEROALL,
            1292 => x86_insn::X86_INS_VZEROUPPER,
            1293 => x86_insn::X86_INS_WAIT,
            1294 => x86_insn::X86_INS_WBINVD,
            1295 => x86_insn::X86_INS_WRFSBASE,
            1296 => x86_insn::X86_INS_WRGSBASE,
            1297 => x86_insn::X86_INS_WRMSR,
            1298 => x86_insn::X86_INS_XABORT,
            1299 => x86_insn::X86_INS_XACQUIRE,
            1300 => x86_insn::X86_INS_XBEGIN,
            1301 => x86_insn::X86_INS_XCHG,
            1302 => x86_insn::X86_INS_XCRYPTCBC,
            1303 => x86_insn::X86_INS_XCRYPTCFB,
            1304 => x86_insn::X86_INS_XCRYPTCTR,
            1305 => x86_insn::X86_INS_XCRYPTECB,
            1306 => x86_insn::X86_INS_XCRYPTOFB,
            1307 => x86_insn::X86_INS_XEND,
            1308 => x86_insn::X86_INS_XGETBV,
            1309 => x86_insn::X86_INS_XLATB,
            1310 => x86_insn::X86_INS_XRELEASE,
            1311 => x86_insn::X86_INS_XRSTOR,
            1312 => x86_insn::X86_INS_XRSTOR64,
            1313 => x86_insn::X86_INS_XRSTORS,
            1314 => x86_insn::X86_INS_XRSTORS64,
            1315 => x86_insn::X86_INS_XSAVE,
            1316 => x86_insn::X86_INS_XSAVE64,
            1317 => x86_insn::X86_INS_XSAVEC,
            1318 => x86_insn::X86_INS_XSAVEC64,
            1319 => x86_insn::X86_INS_XSAVEOPT,
            1320 => x86_insn::X86_INS_XSAVEOPT64,
            1321 => x86_insn::X86_INS_XSAVES,
            1322 => x86_insn::X86_INS_XSAVES64,
            1323 => x86_insn::X86_INS_XSETBV,
            1324 => x86_insn::X86_INS_XSHA1,
            1325 => x86_insn::X86_INS_XSHA256,
            1326 => x86_insn::X86_INS_XSTORE,
            1327 => x86_insn::X86_INS_XTEST,
            1328 => x86_insn::X86_INS_FDISI8087_NOP,
            1329 => x86_insn::X86_INS_FENI8087_NOP,
            1330 => x86_insn::X86_INS_CMPSS,
            1331 => x86_insn::X86_INS_CMPEQSS,
            1332 => x86_insn::X86_INS_CMPLTSS,
            1333 => x86_insn::X86_INS_CMPLESS,
            1334 => x86_insn::X86_INS_CMPUNORDSS,
            1335 => x86_insn::X86_INS_CMPNEQSS,
            1336 => x86_insn::X86_INS_CMPNLTSS,
            1337 => x86_insn::X86_INS_CMPNLESS,
            1338 => x86_insn::X86_INS_CMPORDSS,
            1339 => x86_insn::X86_INS_CMPSD,
            1340 => x86_insn::X86_INS_CMPEQSD,
            1341 => x86_insn::X86_INS_CMPLTSD,
            1342 => x86_insn::X86_INS_CMPLESD,
            1343 => x86_insn::X86_INS_CMPUNORDSD,
            1344 => x86_insn::X86_INS_CMPNEQSD,
            1345 => x86_insn::X86_INS_CMPNLTSD,
            1346 => x86_insn::X86_INS_CMPNLESD,
            1347 => x86_insn::X86_INS_CMPORDSD,
            1348 => x86_insn::X86_INS_CMPPS,
            1349 => x86_insn::X86_INS_CMPEQPS,
            1350 => x86_insn::X86_INS_CMPLTPS,
            1351 => x86_insn::X86_INS_CMPLEPS,
            1352 => x86_insn::X86_INS_CMPUNORDPS,
            1353 => x86_insn::X86_INS_CMPNEQPS,
            1354 => x86_insn::X86_INS_CMPNLTPS,
            1355 => x86_insn::X86_INS_CMPNLEPS,
            1356 => x86_insn::X86_INS_CMPORDPS,
            1357 => x86_insn::X86_INS_CMPPD,
            1358 => x86_insn::X86_INS_CMPEQPD,
            1359 => x86_insn::X86_INS_CMPLTPD,
            1360 => x86_insn::X86_INS_CMPLEPD,
            1361 => x86_insn::X86_INS_CMPUNORDPD,
            1362 => x86_insn::X86_INS_CMPNEQPD,
            1363 => x86_insn::X86_INS_CMPNLTPD,
            1364 => x86_insn::X86_INS_CMPNLEPD,
            1365 => x86_insn::X86_INS_CMPORDPD,
            1366 => x86_insn::X86_INS_VCMPSS,
            1367 => x86_insn::X86_INS_VCMPEQSS,
            1368 => x86_insn::X86_INS_VCMPLTSS,
            1369 => x86_insn::X86_INS_VCMPLESS,
            1370 => x86_insn::X86_INS_VCMPUNORDSS,
            1371 => x86_insn::X86_INS_VCMPNEQSS,
            1372 => x86_insn::X86_INS_VCMPNLTSS,
            1373 => x86_insn::X86_INS_VCMPNLESS,
            1374 => x86_insn::X86_INS_VCMPORDSS,
            1375 => x86_insn::X86_INS_VCMPEQ_UQSS,
            1376 => x86_insn::X86_INS_VCMPNGESS,
            1377 => x86_insn::X86_INS_VCMPNGTSS,
            1378 => x86_insn::X86_INS_VCMPFALSESS,
            1379 => x86_insn::X86_INS_VCMPNEQ_OQSS,
            1380 => x86_insn::X86_INS_VCMPGESS,
            1381 => x86_insn::X86_INS_VCMPGTSS,
            1382 => x86_insn::X86_INS_VCMPTRUESS,
            1383 => x86_insn::X86_INS_VCMPEQ_OSSS,
            1384 => x86_insn::X86_INS_VCMPLT_OQSS,
            1385 => x86_insn::X86_INS_VCMPLE_OQSS,
            1386 => x86_insn::X86_INS_VCMPUNORD_SSS,
            1387 => x86_insn::X86_INS_VCMPNEQ_USSS,
            1388 => x86_insn::X86_INS_VCMPNLT_UQSS,
            1389 => x86_insn::X86_INS_VCMPNLE_UQSS,
            1390 => x86_insn::X86_INS_VCMPORD_SSS,
            1391 => x86_insn::X86_INS_VCMPEQ_USSS,
            1392 => x86_insn::X86_INS_VCMPNGE_UQSS,
            1393 => x86_insn::X86_INS_VCMPNGT_UQSS,
            1394 => x86_insn::X86_INS_VCMPFALSE_OSSS,
            1395 => x86_insn::X86_INS_VCMPNEQ_OSSS,
            1396 => x86_insn::X86_INS_VCMPGE_OQSS,
            1397 => x86_insn::X86_INS_VCMPGT_OQSS,
            1398 => x86_insn::X86_INS_VCMPTRUE_USSS,
            1399 => x86_insn::X86_INS_VCMPSD,
            1400 => x86_insn::X86_INS_VCMPEQSD,
            1401 => x86_insn::X86_INS_VCMPLTSD,
            1402 => x86_insn::X86_INS_VCMPLESD,
            1403 => x86_insn::X86_INS_VCMPUNORDSD,
            1404 => x86_insn::X86_INS_VCMPNEQSD,
            1405 => x86_insn::X86_INS_VCMPNLTSD,
            1406 => x86_insn::X86_INS_VCMPNLESD,
            1407 => x86_insn::X86_INS_VCMPORDSD,
            1408 => x86_insn::X86_INS_VCMPEQ_UQSD,
            1409 => x86_insn::X86_INS_VCMPNGESD,
            1410 => x86_insn::X86_INS_VCMPNGTSD,
            1411 => x86_insn::X86_INS_VCMPFALSESD,
            1412 => x86_insn::X86_INS_VCMPNEQ_OQSD,
            1413 => x86_insn::X86_INS_VCMPGESD,
            1414 => x86_insn::X86_INS_VCMPGTSD,
            1415 => x86_insn::X86_INS_VCMPTRUESD,
            1416 => x86_insn::X86_INS_VCMPEQ_OSSD,
            1417 => x86_insn::X86_INS_VCMPLT_OQSD,
            1418 => x86_insn::X86_INS_VCMPLE_OQSD,
            1419 => x86_insn::X86_INS_VCMPUNORD_SSD,
            1420 => x86_insn::X86_INS_VCMPNEQ_USSD,
            1421 => x86_insn::X86_INS_VCMPNLT_UQSD,
            1422 => x86_insn::X86_INS_VCMPNLE_UQSD,
            1423 => x86_insn::X86_INS_VCMPORD_SSD,
            1424 => x86_insn::X86_INS_VCMPEQ_USSD,
            1425 => x86_insn::X86_INS_VCMPNGE_UQSD,
            1426 => x86_insn::X86_INS_VCMPNGT_UQSD,
            1427 => x86_insn::X86_INS_VCMPFALSE_OSSD,
            1428 => x86_insn::X86_INS_VCMPNEQ_OSSD,
            1429 => x86_insn::X86_INS_VCMPGE_OQSD,
            1430 => x86_insn::X86_INS_VCMPGT_OQSD,
            1431 => x86_insn::X86_INS_VCMPTRUE_USSD,
            1432 => x86_insn::X86_INS_VCMPPS,
            1433 => x86_insn::X86_INS_VCMPEQPS,
            1434 => x86_insn::X86_INS_VCMPLTPS,
            1435 => x86_insn::X86_INS_VCMPLEPS,
            1436 => x86_insn::X86_INS_VCMPUNORDPS,
            1437 => x86_insn::X86_INS_VCMPNEQPS,
            1438 => x86_insn::X86_INS_VCMPNLTPS,
            1439 => x86_insn::X86_INS_VCMPNLEPS,
            1440 => x86_insn::X86_INS_VCMPORDPS,
            1441 => x86_insn::X86_INS_VCMPEQ_UQPS,
            1442 => x86_insn::X86_INS_VCMPNGEPS,
            1443 => x86_insn::X86_INS_VCMPNGTPS,
            1444 => x86_insn::X86_INS_VCMPFALSEPS,
            1445 => x86_insn::X86_INS_VCMPNEQ_OQPS,
            1446 => x86_insn::X86_INS_VCMPGEPS,
            1447 => x86_insn::X86_INS_VCMPGTPS,
            1448 => x86_insn::X86_INS_VCMPTRUEPS,
            1449 => x86_insn::X86_INS_VCMPEQ_OSPS,
            1450 => x86_insn::X86_INS_VCMPLT_OQPS,
            1451 => x86_insn::X86_INS_VCMPLE_OQPS,
            1452 => x86_insn::X86_INS_VCMPUNORD_SPS,
            1453 => x86_insn::X86_INS_VCMPNEQ_USPS,
            1454 => x86_insn::X86_INS_VCMPNLT_UQPS,
            1455 => x86_insn::X86_INS_VCMPNLE_UQPS,
            1456 => x86_insn::X86_INS_VCMPORD_SPS,
            1457 => x86_insn::X86_INS_VCMPEQ_USPS,
            1458 => x86_insn::X86_INS_VCMPNGE_UQPS,
            1459 => x86_insn::X86_INS_VCMPNGT_UQPS,
            1460 => x86_insn::X86_INS_VCMPFALSE_OSPS,
            1461 => x86_insn::X86_INS_VCMPNEQ_OSPS,
            1462 => x86_insn::X86_INS_VCMPGE_OQPS,
            1463 => x86_insn::X86_INS_VCMPGT_OQPS,
            1464 => x86_insn::X86_INS_VCMPTRUE_USPS,
            1465 => x86_insn::X86_INS_VCMPPD,
            1466 => x86_insn::X86_INS_VCMPEQPD,
            1467 => x86_insn::X86_INS_VCMPLTPD,
            1468 => x86_insn::X86_INS_VCMPLEPD,
            1469 => x86_insn::X86_INS_VCMPUNORDPD,
            1470 => x86_insn::X86_INS_VCMPNEQPD,
            1471 => x86_insn::X86_INS_VCMPNLTPD,
            1472 => x86_insn::X86_INS_VCMPNLEPD,
            1473 => x86_insn::X86_INS_VCMPORDPD,
            1474 => x86_insn::X86_INS_VCMPEQ_UQPD,
            1475 => x86_insn::X86_INS_VCMPNGEPD,
            1476 => x86_insn::X86_INS_VCMPNGTPD,
            1477 => x86_insn::X86_INS_VCMPFALSEPD,
            1478 => x86_insn::X86_INS_VCMPNEQ_OQPD,
            1479 => x86_insn::X86_INS_VCMPGEPD,
            1480 => x86_insn::X86_INS_VCMPGTPD,
            1481 => x86_insn::X86_INS_VCMPTRUEPD,
            1482 => x86_insn::X86_INS_VCMPEQ_OSPD,
            1483 => x86_insn::X86_INS_VCMPLT_OQPD,
            1484 => x86_insn::X86_INS_VCMPLE_OQPD,
            1485 => x86_insn::X86_INS_VCMPUNORD_SPD,
            1486 => x86_insn::X86_INS_VCMPNEQ_USPD,
            1487 => x86_insn::X86_INS_VCMPNLT_UQPD,
            1488 => x86_insn::X86_INS_VCMPNLE_UQPD,
            1489 => x86_insn::X86_INS_VCMPORD_SPD,
            1490 => x86_insn::X86_INS_VCMPEQ_USPD,
            1491 => x86_insn::X86_INS_VCMPNGE_UQPD,
            1492 => x86_insn::X86_INS_VCMPNGT_UQPD,
            1493 => x86_insn::X86_INS_VCMPFALSE_OSPD,
            1494 => x86_insn::X86_INS_VCMPNEQ_OSPD,
            1495 => x86_insn::X86_INS_VCMPGE_OQPD,
            1496 => x86_insn::X86_INS_VCMPGT_OQPD,
            1497 => x86_insn::X86_INS_VCMPTRUE_USPD,
            1498 => x86_insn::X86_INS_UD0,
            1499 => x86_insn::X86_INS_ENDBR32,
            1500 => x86_insn::X86_INS_ENDBR64,
            1501 => x86_insn::X86_INS_ENDING,
            _ => x86_insn::X86_INS_INVALID,
        }
    }
}
impl From<u32> for xcore_insn {
    fn from(id: u32) -> Self {
        match id {
            0 => xcore_insn::XCORE_INS_INVALID,
            1 => xcore_insn::XCORE_INS_ADD,
            2 => xcore_insn::XCORE_INS_ANDNOT,
            3 => xcore_insn::XCORE_INS_AND,
            4 => xcore_insn::XCORE_INS_ASHR,
            5 => xcore_insn::XCORE_INS_BAU,
            6 => xcore_insn::XCORE_INS_BITREV,
            7 => xcore_insn::XCORE_INS_BLA,
            8 => xcore_insn::XCORE_INS_BLAT,
            9 => xcore_insn::XCORE_INS_BL,
            10 => xcore_insn::XCORE_INS_BF,
            11 => xcore_insn::XCORE_INS_BT,
            12 => xcore_insn::XCORE_INS_BU,
            13 => xcore_insn::XCORE_INS_BRU,
            14 => xcore_insn::XCORE_INS_BYTEREV,
            15 => xcore_insn::XCORE_INS_CHKCT,
            16 => xcore_insn::XCORE_INS_CLRE,
            17 => xcore_insn::XCORE_INS_CLRPT,
            18 => xcore_insn::XCORE_INS_CLRSR,
            19 => xcore_insn::XCORE_INS_CLZ,
            20 => xcore_insn::XCORE_INS_CRC8,
            21 => xcore_insn::XCORE_INS_CRC32,
            22 => xcore_insn::XCORE_INS_DCALL,
            23 => xcore_insn::XCORE_INS_DENTSP,
            24 => xcore_insn::XCORE_INS_DGETREG,
            25 => xcore_insn::XCORE_INS_DIVS,
            26 => xcore_insn::XCORE_INS_DIVU,
            27 => xcore_insn::XCORE_INS_DRESTSP,
            28 => xcore_insn::XCORE_INS_DRET,
            29 => xcore_insn::XCORE_INS_ECALLF,
            30 => xcore_insn::XCORE_INS_ECALLT,
            31 => xcore_insn::XCORE_INS_EDU,
            32 => xcore_insn::XCORE_INS_EEF,
            33 => xcore_insn::XCORE_INS_EET,
            34 => xcore_insn::XCORE_INS_EEU,
            35 => xcore_insn::XCORE_INS_ENDIN,
            36 => xcore_insn::XCORE_INS_ENTSP,
            37 => xcore_insn::XCORE_INS_EQ,
            38 => xcore_insn::XCORE_INS_EXTDP,
            39 => xcore_insn::XCORE_INS_EXTSP,
            40 => xcore_insn::XCORE_INS_FREER,
            41 => xcore_insn::XCORE_INS_FREET,
            42 => xcore_insn::XCORE_INS_GETD,
            43 => xcore_insn::XCORE_INS_GET,
            44 => xcore_insn::XCORE_INS_GETN,
            45 => xcore_insn::XCORE_INS_GETR,
            46 => xcore_insn::XCORE_INS_GETSR,
            47 => xcore_insn::XCORE_INS_GETST,
            48 => xcore_insn::XCORE_INS_GETTS,
            49 => xcore_insn::XCORE_INS_INCT,
            50 => xcore_insn::XCORE_INS_INIT,
            51 => xcore_insn::XCORE_INS_INPW,
            52 => xcore_insn::XCORE_INS_INSHR,
            53 => xcore_insn::XCORE_INS_INT,
            54 => xcore_insn::XCORE_INS_IN,
            55 => xcore_insn::XCORE_INS_KCALL,
            56 => xcore_insn::XCORE_INS_KENTSP,
            57 => xcore_insn::XCORE_INS_KRESTSP,
            58 => xcore_insn::XCORE_INS_KRET,
            59 => xcore_insn::XCORE_INS_LADD,
            60 => xcore_insn::XCORE_INS_LD16S,
            61 => xcore_insn::XCORE_INS_LD8U,
            62 => xcore_insn::XCORE_INS_LDA16,
            63 => xcore_insn::XCORE_INS_LDAP,
            64 => xcore_insn::XCORE_INS_LDAW,
            65 => xcore_insn::XCORE_INS_LDC,
            66 => xcore_insn::XCORE_INS_LDW,
            67 => xcore_insn::XCORE_INS_LDIVU,
            68 => xcore_insn::XCORE_INS_LMUL,
            69 => xcore_insn::XCORE_INS_LSS,
            70 => xcore_insn::XCORE_INS_LSUB,
            71 => xcore_insn::XCORE_INS_LSU,
            72 => xcore_insn::XCORE_INS_MACCS,
            73 => xcore_insn::XCORE_INS_MACCU,
            74 => xcore_insn::XCORE_INS_MJOIN,
            75 => xcore_insn::XCORE_INS_MKMSK,
            76 => xcore_insn::XCORE_INS_MSYNC,
            77 => xcore_insn::XCORE_INS_MUL,
            78 => xcore_insn::XCORE_INS_NEG,
            79 => xcore_insn::XCORE_INS_NOT,
            80 => xcore_insn::XCORE_INS_OR,
            81 => xcore_insn::XCORE_INS_OUTCT,
            82 => xcore_insn::XCORE_INS_OUTPW,
            83 => xcore_insn::XCORE_INS_OUTSHR,
            84 => xcore_insn::XCORE_INS_OUTT,
            85 => xcore_insn::XCORE_INS_OUT,
            86 => xcore_insn::XCORE_INS_PEEK,
            87 => xcore_insn::XCORE_INS_REMS,
            88 => xcore_insn::XCORE_INS_REMU,
            89 => xcore_insn::XCORE_INS_RETSP,
            90 => xcore_insn::XCORE_INS_SETCLK,
            91 => xcore_insn::XCORE_INS_SET,
            92 => xcore_insn::XCORE_INS_SETC,
            93 => xcore_insn::XCORE_INS_SETD,
            94 => xcore_insn::XCORE_INS_SETEV,
            95 => xcore_insn::XCORE_INS_SETN,
            96 => xcore_insn::XCORE_INS_SETPSC,
            97 => xcore_insn::XCORE_INS_SETPT,
            98 => xcore_insn::XCORE_INS_SETRDY,
            99 => xcore_insn::XCORE_INS_SETSR,
            100 => xcore_insn::XCORE_INS_SETTW,
            101 => xcore_insn::XCORE_INS_SETV,
            102 => xcore_insn::XCORE_INS_SEXT,
            103 => xcore_insn::XCORE_INS_SHL,
            104 => xcore_insn::XCORE_INS_SHR,
            105 => xcore_insn::XCORE_INS_SSYNC,
            106 => xcore_insn::XCORE_INS_ST16,
            107 => xcore_insn::XCORE_INS_ST8,
            108 => xcore_insn::XCORE_INS_STW,
            109 => xcore_insn::XCORE_INS_SUB,
            110 => xcore_insn::XCORE_INS_SYNCR,
            111 => xcore_insn::XCORE_INS_TESTCT,
            112 => xcore_insn::XCORE_INS_TESTLCL,
            113 => xcore_insn::XCORE_INS_TESTWCT,
            114 => xcore_insn::XCORE_INS_TSETMR,
            115 => xcore_insn::XCORE_INS_START,
            116 => xcore_insn::XCORE_INS_WAITEF,
            117 => xcore_insn::XCORE_INS_WAITET,
            118 => xcore_insn::XCORE_INS_WAITEU,
            119 => xcore_insn::XCORE_INS_XOR,
            120 => xcore_insn::XCORE_INS_ZEXT,
            121 => xcore_insn::XCORE_INS_ENDING,
            _ => xcore_insn::XCORE_INS_INVALID,
        }
    }
}
