#define XERR "sshcron"
#include "sshcron.ih"

// ssh-cron, when run in the foreground, acts like when running as daemon.
// e.g., send it signals via another ssh-cron process using options like
// --list (cf. request.cc). 

    // by Fork, run.cc

void SSHCron::childProcess()
{
    if (not d_options.foreground())
        prepareDaemon();                   // Fork member
    else
        cout << "Issue a --terminate command using a separate `" <<
                                d_options.basename() << "' process" << endl;  

    Cron cron{ d_passphrase };
    d_passphrase = string{};

    cron.fork();

    throw 0;                    // correctly end the child process at main
}
