from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


abbrev_cwd = _Mock()

bdb = _Mock()

error = _Mock()

get_default_editor = _Mock()

get_pasted_lines = _Mock()

get_stream_enc = _Mock()

line_magic = _Mock()

magics_class = _Mock()

num_ini_spaces = _Mock()

os = _Mock()

print_function = _Mock()

py3compat = _Mock()

set_term_title = _Mock()

skip_doctest = _Mock()

strip_email_quotes = _Mock()

sys = _Mock()

toggle_set_term_title = _Mock()

warn = _Mock()

default_banner = 'Python 2.7.8 (default, Oct 18 2014, 12:50:18) \nType "copyright", "credits" or "license" for more information.\n\nIPython 2.3.0 -- An enhanced Interactive Python.\n?         -> Introduction and overview of IPython\'s features.\n%quickref -> Quick reference.\nhelp      -> Python\'s own help system.\nobject?   -> Details about \'object\', use \'object??\' for extra details.\n'

interactive_usage = '\nIPython -- An enhanced Interactive Python\n=========================================\n\nIPython offers a combination of convenient shell features, special commands\nand a history mechanism for both input (command history) and output (results\ncaching, similar to Mathematica). It is intended to be a fully compatible\nreplacement for the standard Python interpreter, while offering vastly\nimproved functionality and flexibility.\n\nAt your system command line, type \'ipython -h\' to see the command line\noptions available. This document only describes interactive features.\n\nMAIN FEATURES\n-------------\n\n* Access to the standard Python help. As of Python 2.1, a help system is\n  available with access to object docstrings and the Python manuals. Simply\n  type \'help\' (no quotes) to access it.\n\n* Magic commands: type %magic for information on the magic subsystem.\n\n* System command aliases, via the %alias command or the configuration file(s).\n\n* Dynamic object information:\n\n  Typing ?word or word? prints detailed information about an object.  If\n  certain strings in the object are too long (docstrings, code, etc.) they get\n  snipped in the center for brevity.\n\n  Typing ??word or word?? gives access to the full information without\n  snipping long strings. Long strings are sent to the screen through the less\n  pager if longer than the screen, printed otherwise.\n\n  The ?/?? system gives access to the full source code for any object (if\n  available), shows function prototypes and other useful information.\n\n  If you just want to see an object\'s docstring, type \'%pdoc object\' (without\n  quotes, and without % if you have automagic on).\n\n  Both %pdoc and ?/?? give you access to documentation even on things which are\n  not explicitely defined. Try for example typing {}.get? or after import os,\n  type os.path.abspath??. The magic functions %pdef, %source and %file operate\n  similarly.\n\n* Completion in the local namespace, by typing TAB at the prompt.\n\n  At any time, hitting tab will complete any available python commands or\n  variable names, and show you a list of the possible completions if there\'s\n  no unambiguous one. It will also complete filenames in the current directory.\n\n  This feature requires the readline and rlcomplete modules, so it won\'t work\n  if your Python lacks readline support (such as under Windows).\n\n* Search previous command history in two ways (also requires readline):\n\n  - Start typing, and then use Ctrl-p (previous,up) and Ctrl-n (next,down) to\n    search through only the history items that match what you\'ve typed so\n    far. If you use Ctrl-p/Ctrl-n at a blank prompt, they just behave like\n    normal arrow keys.\n\n  - Hit Ctrl-r: opens a search prompt. Begin typing and the system searches\n    your history for lines that match what you\'ve typed so far, completing as\n    much as it can.\n\n  - %hist: search history by index (this does *not* require readline).\n\n* Persistent command history across sessions.\n\n* Logging of input with the ability to save and restore a working session.\n\n* System escape with !. Typing !ls will run \'ls\' in the current directory.\n\n* The reload command does a \'deep\' reload of a module: changes made to the\n  module since you imported will actually be available without having to exit.\n\n* Verbose and colored exception traceback printouts. See the magic xmode and\n  xcolor functions for details (just type %magic).\n\n* Input caching system:\n\n  IPython offers numbered prompts (In/Out) with input and output caching. All\n  input is saved and can be retrieved as variables (besides the usual arrow\n  key recall).\n\n  The following GLOBAL variables always exist (so don\'t overwrite them!):\n  _i: stores previous input.\n  _ii: next previous.\n  _iii: next-next previous.\n  _ih : a list of all input _ih[n] is the input from line n.\n\n  Additionally, global variables named _i<n> are dynamically created (<n>\n  being the prompt counter), such that _i<n> == _ih[<n>]\n\n  For example, what you typed at prompt 14 is available as _i14 and _ih[14].\n\n  You can create macros which contain multiple input lines from this history,\n  for later re-execution, with the %macro function.\n\n  The history function %hist allows you to see any part of your input history\n  by printing a range of the _i variables. Note that inputs which contain\n  magic functions (%) appear in the history with a prepended comment. This is\n  because they aren\'t really valid Python code, so you can\'t exec them.\n\n* Output caching system:\n\n  For output that is returned from actions, a system similar to the input\n  cache exists but using _ instead of _i. Only actions that produce a result\n  (NOT assignments, for example) are cached. If you are familiar with\n  Mathematica, IPython\'s _ variables behave exactly like Mathematica\'s %\n  variables.\n\n  The following GLOBAL variables always exist (so don\'t overwrite them!):\n  _ (one underscore): previous output.\n  __ (two underscores): next previous.\n  ___ (three underscores): next-next previous.\n\n  Global variables named _<n> are dynamically created (<n> being the prompt\n  counter), such that the result of output <n> is always available as _<n>.\n\n  Finally, a global dictionary named _oh exists with entries for all lines\n  which generated output.\n\n* Directory history:\n\n  Your history of visited directories is kept in the global list _dh, and the\n  magic %cd command can be used to go to any entry in that list.\n\n* Auto-parentheses and auto-quotes (adapted from Nathan Gray\'s LazyPython)\n\n  1. Auto-parentheses\n        \n     Callable objects (i.e. functions, methods, etc) can be invoked like\n     this (notice the commas between the arguments)::\n       \n         In [1]: callable_ob arg1, arg2, arg3\n       \n     and the input will be translated to this::\n       \n         callable_ob(arg1, arg2, arg3)\n       \n     This feature is off by default (in rare cases it can produce\n     undesirable side-effects), but you can activate it at the command-line\n     by starting IPython with `--autocall 1`, set it permanently in your\n     configuration file, or turn on at runtime with `%autocall 1`.\n\n     You can force auto-parentheses by using \'/\' as the first character\n     of a line.  For example::\n       \n          In [1]: /globals             # becomes \'globals()\'\n       \n     Note that the \'/\' MUST be the first character on the line!  This\n     won\'t work::\n       \n          In [2]: print /globals    # syntax error\n\n     In most cases the automatic algorithm should work, so you should\n     rarely need to explicitly invoke /. One notable exception is if you\n     are trying to call a function with a list of tuples as arguments (the\n     parenthesis will confuse IPython)::\n       \n          In [1]: zip (1,2,3),(4,5,6)  # won\'t work\n       \n     but this will work::\n       \n          In [2]: /zip (1,2,3),(4,5,6)\n          ------> zip ((1,2,3),(4,5,6))\n          Out[2]= [(1, 4), (2, 5), (3, 6)]\n\n     IPython tells you that it has altered your command line by\n     displaying the new command line preceded by -->.  e.g.::\n       \n          In [18]: callable list\n          -------> callable (list)\n\n  2. Auto-Quoting\n    \n     You can force auto-quoting of a function\'s arguments by using \',\' as\n     the first character of a line.  For example::\n       \n          In [1]: ,my_function /home/me   # becomes my_function("/home/me")\n\n     If you use \';\' instead, the whole argument is quoted as a single\n     string (while \',\' splits on whitespace)::\n       \n          In [2]: ,my_function a b c   # becomes my_function("a","b","c")\n          In [3]: ;my_function a b c   # becomes my_function("a b c")\n\n     Note that the \',\' MUST be the first character on the line!  This\n     won\'t work::\n       \n          In [4]: x = ,my_function /home/me    # syntax error\n'

class CBool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class ClipboardEmpty(_Mock):
  pass


class IPythonInputSplitter(_Mock):
  pass
  _full_dedent = False
  encoding = ''
  indent_spaces = 0
  source = ''
  source_raw = ''
  transformer_accumulating = False
  within_python_line = False

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class InteractiveShell(_Mock):
  pass
  default_user_namespaces = True

class InteractiveShellABC(_Mock):
  pass
  _abc_negative_cache_version = 62

class Magics(_Mock):
  pass
  registered = False

class SList(_Mock):
  pass


class TerminalInteractiveShell(_Mock):
  pass
  default_user_namespaces = True

class TerminalMagics(_Mock):
  pass
  registered = True

class TryNext(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class UsageError(_Mock):
  pass


