from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


absolute_import = _Mock()

check_pairs = _Mock()

contextmanager = _Mock()

dec = _Mock()

default_argv = _Mock()

default_config = _Mock()

doctest_deco = _Mock()

full_path = _Mock()

get_ipython_cmd = _Mock()

get_output_error_code = _Mock()

help_all_output_test = _Mock()

help_output_test = _Mock()

ipexec = _Mock()

ipexec_validate = _Mock()

list_strings = _Mock()

make_tempfile = _Mock()

monkeypatch = _Mock()

mute_warn = _Mock()

nt = _Mock()

os = _Mock()

parse_test_output = _Mock()

py3compat = _Mock()

re = _Mock()

skipdoctest = _Mock()

sys = _Mock()

temp_pyfile = _Mock()

tempfile = _Mock()

DEFAULT_ENCODING = 'utf-8'

PIPE = -1

has_nose = _Mock()

notprinted_msg = 'Did not find {0!r} in printed output (on {1}):\n-------\n{2!s}\n-------\n'

pair_fail_msg = 'Testing {0}\n\nIn:\n  {1!r}\nExpected:\n  {2!r}\nGot:\n  {3!r}\n'

printed_msg = 'Found {0!r} in printed output (on {1}):\n-------\n{2!s}\n-------\n'

class AssertNotPrints(_Mock):
  pass


class AssertPrints(_Mock):
  pass


class Config(_Mock):
  pass


class MyStringIO(_Mock):
  pass


class Popen(_Mock):
  pass
  _child_created = False

class StringIO(_Mock):
  pass


class Tee(_Mock):
  pass


class TempFileMixin(_Mock):
  pass


class _re_type(_Mock):
  pass


