/*
 * Decompiled with CFR 0.152.
 */
import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.ConnectionLostException;
import Ice.FacetNotExistException;
import Ice.Identity;
import Ice.NotRegisteredException;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.OperationNotExistException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownUserException;
import Test.A;
import Test.B;
import Test.C;
import Test.D;
import Test.ThrowerPrx;
import Test.ThrowerPrxHelper;
import Test.WrongOperationPrxHelper;
import java.io.PrintStream;

public class AllTests {
    private static void test(boolean bl) {
        if (!bl) {
            throw new RuntimeException();
        }
    }

    public static ThrowerPrx allTests(Communicator communicator, PrintStream printStream) {
        Object object;
        printStream.print("testing object adapter registration exceptions... ");
        Object object2 = communicator.createObjectAdapter("TestAdapter0");
        try {
            object = communicator.createObjectAdapter("TestAdapter0");
            AllTests.test(false);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        communicator.getProperties().setProperty("TestAdapter0.Endpoints", "");
        try {
            object = communicator.createObjectAdapterWithEndpoints("TestAdapter0", "ssl -h foo -p 12011 -t 10000");
            AllTests.test(false);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        AllTests.test(communicator.getProperties().getProperty("TestAdapter0.Endpoints").equals(""));
        ((ObjectAdapter)object2).deactivate();
        printStream.println("ok");
        printStream.print("testing servant registration exceptions... ");
        object2 = communicator.createObjectAdapter("TestAdapter1");
        object = new EmptyI();
        ((ObjectAdapter)object2).add((Ice.Object)object, communicator.stringToIdentity("x"));
        try {
            ((ObjectAdapter)object2).add((Ice.Object)object, communicator.stringToIdentity("x"));
            AllTests.test(false);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        ((ObjectAdapter)object2).remove(communicator.stringToIdentity("x"));
        try {
            ((ObjectAdapter)object2).remove(communicator.stringToIdentity("x"));
            AllTests.test(false);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        ((ObjectAdapter)object2).deactivate();
        printStream.println("ok");
        printStream.print("testing stringToProxy... ");
        printStream.flush();
        object2 = communicator.getProperties().getPropertyWithDefault("Test.Proxy", "thrower:default -p 12010 -t 10000");
        object = communicator.stringToProxy((String)object2);
        AllTests.test(object != null);
        printStream.println("ok");
        printStream.print("testing checked cast... ");
        printStream.flush();
        ThrowerPrx throwerPrx = ThrowerPrxHelper.checkedCast((ObjectPrx)object);
        AllTests.test(throwerPrx != null);
        AllTests.test(throwerPrx.equals(object));
        printStream.println("ok");
        printStream.print("catching exact types... ");
        printStream.flush();
        try {
            throwerPrx.throwAasA(1);
            AllTests.test(false);
        }
        catch (A a) {
            AllTests.test(a.aMem == 1);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        try {
            throwerPrx.throwAorDasAorD(1);
            AllTests.test(false);
        }
        catch (A a) {
            AllTests.test(a.aMem == 1);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        try {
            throwerPrx.throwAorDasAorD(-1);
            AllTests.test(false);
        }
        catch (D d) {
            AllTests.test(d.dMem == -1);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        try {
            throwerPrx.throwBasB(1, 2);
            AllTests.test(false);
        }
        catch (B b) {
            AllTests.test(b.aMem == 1);
            AllTests.test(b.bMem == 2);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        try {
            throwerPrx.throwCasC(1, 2, 3);
            AllTests.test(false);
        }
        catch (C c) {
            AllTests.test(c.aMem == 1);
            AllTests.test(c.bMem == 2);
            AllTests.test(c.cMem == 3);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("catching base types... ");
        printStream.flush();
        try {
            throwerPrx.throwBasB(1, 2);
            AllTests.test(false);
        }
        catch (A a) {
            AllTests.test(a.aMem == 1);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        try {
            throwerPrx.throwCasC(1, 2, 3);
            AllTests.test(false);
        }
        catch (B b) {
            AllTests.test(b.aMem == 1);
            AllTests.test(b.bMem == 2);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("catching derived types... ");
        printStream.flush();
        try {
            throwerPrx.throwBasA(1, 2);
            AllTests.test(false);
        }
        catch (B b) {
            AllTests.test(b.aMem == 1);
            AllTests.test(b.bMem == 2);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        try {
            throwerPrx.throwCasA(1, 2, 3);
            AllTests.test(false);
        }
        catch (C c) {
            AllTests.test(c.aMem == 1);
            AllTests.test(c.bMem == 2);
            AllTests.test(c.cMem == 3);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        try {
            throwerPrx.throwCasB(1, 2, 3);
            AllTests.test(false);
        }
        catch (C c) {
            AllTests.test(c.aMem == 1);
            AllTests.test(c.bMem == 2);
            AllTests.test(c.cMem == 3);
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        if (throwerPrx.supportsUndeclaredExceptions()) {
            printStream.print("catching unknown user exception... ");
            printStream.flush();
            try {
                throwerPrx.throwUndeclaredA(1);
                AllTests.test(false);
            }
            catch (UnknownUserException unknownUserException) {
            }
            catch (Exception exception) {
                AllTests.test(false);
            }
            try {
                throwerPrx.throwUndeclaredB(1, 2);
                AllTests.test(false);
            }
            catch (UnknownUserException unknownUserException) {
            }
            catch (Exception exception) {
                AllTests.test(false);
            }
            try {
                throwerPrx.throwUndeclaredC(1, 2, 3);
                AllTests.test(false);
            }
            catch (UnknownUserException unknownUserException) {
            }
            catch (Exception exception) {
                AllTests.test(false);
            }
            printStream.println("ok");
        }
        if (throwerPrx.supportsAssertException()) {
            printStream.print("testing assert in the server... ");
            printStream.flush();
            try {
                throwerPrx.throwAssertException();
                AllTests.test(false);
            }
            catch (ConnectionLostException connectionLostException) {
            }
            catch (Exception exception) {
                AllTests.test(false);
            }
            printStream.println("ok");
        }
        printStream.print("catching object not exist exception... ");
        printStream.flush();
        Object object3 = communicator.stringToIdentity("does not exist");
        try {
            ThrowerPrx throwerPrx2 = ThrowerPrxHelper.uncheckedCast(throwerPrx.ice_identity((Identity)object3));
            throwerPrx2.ice_ping();
            AllTests.test(false);
        }
        catch (ObjectNotExistException objectNotExistException) {
            AllTests.test(objectNotExistException.id.equals(object3));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("catching facet not exist exception... ");
        printStream.flush();
        try {
            object3 = ThrowerPrxHelper.uncheckedCast(throwerPrx, "no such facet");
            try {
                object3.ice_ping();
                AllTests.test(false);
            }
            catch (FacetNotExistException facetNotExistException) {
                AllTests.test(facetNotExistException.facet.equals("no such facet"));
            }
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("catching operation not exist exception... ");
        printStream.flush();
        try {
            object3 = WrongOperationPrxHelper.uncheckedCast(throwerPrx);
            object3.noSuchOperation();
            AllTests.test(false);
        }
        catch (OperationNotExistException operationNotExistException) {
            AllTests.test(operationNotExistException.operation.equals("noSuchOperation"));
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("catching unknown local exception... ");
        printStream.flush();
        try {
            throwerPrx.throwLocalException();
            AllTests.test(false);
        }
        catch (UnknownLocalException unknownLocalException) {
        }
        catch (Exception exception) {
            AllTests.test(false);
        }
        printStream.println("ok");
        printStream.print("catching unknown non-Ice exception... ");
        printStream.flush();
        try {
            throwerPrx.throwNonIceException();
            AllTests.test(false);
        }
        catch (UnknownException unknownException) {
            // empty catch block
        }
        printStream.println("ok");
        return throwerPrx;
    }
}

