/*	$NetBSD: imx6_iomuxreg.h,v 1.4 2017/06/09 18:14:59 ryo Exp $	*/

/*
 * Copyright (c) 2014 Ryo Shimizu <ryo@nerv.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX6_IOMUXREG_H_
#define _ARM_IMX_IMX6_IOMUXREG_H_

#define IOMUX_GPR0					0x00000000
#define IOMUX_GPR1					0x00000004
#define  IOMUX_GPR1_CFG_L1_CLK_REMOVAL_EN	__BIT(31)
#define  IOMUX_GPR1_APP_CLK_REQ_N		__BIT(30)
#define  IOMUX_GPR1_APP_REQ_EXIT_L1		__BIT(28)
#define  IOMUX_GPR1_APP_READY_ENTR_L23		__BIT(27)
#define  IOMUX_GPR1_APP_REQ_ENTR_L1		__BIT(26)
#define  IOMUX_GPR1_MIPI_COLOR_SW		__BIT(25)
#define  IOMUX_GPR1_MIPI_DPI_OFF		__BIT(24)
#define  IOMUX_GPR1_EXC_MON			__BIT(22)
#define  IOMUX_GPR1_ENET_CLK_SEL		__BIT(21)
#define  IOMUX_GPR1_MIPI_IPU2_MUX		__BIT(20)
#define  IOMUX_GPR1_MIPI_IPU1_MUX		__BIT(19)
#define  IOMUX_GPR1_TEST_POWERDOWN		__BIT(18)
#define  IOMUX_GPR1_IPU_VPU_MUX			__BIT(17)
#define  IOMUX_GPR1_REF_SSP_EN			__BIT(16)
#define  IOMUX_GPR1_USB_EXP_MODE		__BIT(15)
#define  IOMUX_GPR1_SYS_INT			__BIT(14)
#define  IOMUX_GPR1_USB_OTG_ID_SEL		__BIT(13)
#define  IOMUX_GPR1_GINT			__BIT(12)
#define  IOMUX_GPR1_ADDRS3			__BITS(11, 10)
#define  IOMUX_GPR1_ACT_CS3			__BIT(9)
#define  IOMUX_GPR1_ADDRS2			__BITS(8, 7)
#define  IOMUX_GPR1_ACT_CS2			__BIT(6)
#define  IOMUX_GPR1_ADDRS1			__BITS(5, 4)
#define  IOMUX_GPR1_ACT_CS1			__BIT(3)
#define  IOMUX_GPR1_ADDRS0			__BITS(2, 1)
#define  IOMUX_GPR1_ACT_CS0			__BIT(0)
#define IOMUX_GPR2					0x00000008
#define IOMUX_GPR3					0x0000000c
#define IOMUX_GPR4					0x00000010
#define IOMUX_GPR5					0x00000014
#define IOMUX_GPR6					0x00000018
#define IOMUX_GPR7					0x0000001c
#define IOMUX_GPR8					0x00000020
#define  IOMUX_GPR8_PCS_TX_SWING_LOW		__BITS(31, 25)
#define  IOMUX_GPR8_PCS_TX_SWING_FULL		__BITS(24, 18)
#define  IOMUX_GPR8_PCS_TX_DEEMPH_GEN2_6DB	__BITS(17, 12)
#define  IOMUX_GPR8_PCS_TX_DEEMPH_GEN2_3P5DB	__BITS(11, 6)
#define  IOMUX_GPR8_PCS_TX_DEEMPH_GEN1		__BITS(5, 0)
#define IOMUX_GPR9					0x00000024
#define IOMUX_GPR10					0x00000028
#define IOMUX_GPR11					0x0000002c
#define IOMUX_GPR12					0x00000030
#define  IOMUX_GPR12_ARMP_IPG_CLK_EN		__BIT(27)
#define  IOMUX_GPR12_ARMP_AHB_CLK_EN		__BIT(26)
#define  IOMUX_GPR12_ARMP_ATB_CLK_EN		__BIT(25)
#define  IOMUX_GPR12_ARMP_APB_CLK_EN		__BIT(24)
#define  IOMUX_GPR12_PCIE_CTL_7			__BITS(23, 21)
#define  IOMUX_GPR12_DIA_STATUS_BUS_SELECT	__BITS(20, 17)
#define  IOMUX_GPR12_APPS_PM_XMT_TURNOFF	__BIT(16)
#define  IOMUX_GPR12_DEVICE_TYPE		__BITS(15, 12)
#define  IOMUX_GPR12_DEVICE_TYPE_PCIE_EP	(0 << 12)
#define  IOMUX_GPR12_DEVICE_TYPE_PCIE_RC	(2 << 12)
#define  IOMUX_GPR12_APP_INIT_RST		__BIT(11)
#define  IOMUX_GPR12_APP_LTSSM_ENABLE		__BIT(10)
#define  IOMUX_GPR12_APPS_PM_XMT_PME		__BIT(9)
#define  IOMUX_GPR12_LOS_LEVEL			__BITS(8, 4)
#define  IOMUX_GPR12_USDHC_DBG_MUX		__BITS(3, 2)
#define IOMUX_GPR13					0x00000034
#define  IOMUX_GPR13_SDMA_STOP_REQ		__BIT(30)
#define  IOMUX_GPR13_CAN2_STOP_REQ		__BIT(29)
#define  IOMUX_GPR13_CAN1_STOP_REQ		__BIT(28)
#define  IOMUX_GPR13_ENET_STOP_REQ		__BIT(27)
#define  IOMUX_GPR13_SATA_PHY_8(n)		__SHIFTIN(n, __BITS(26, 24))
#define  IOMUX_GPR13_SATA_PHY_7(n)		__SHIFTIN(n, __BITS(23, 19))
#define  IOMUX_GPR13_SATA_PHY_6(n)		__SHIFTIN(n, __BITS(18, 16))
#define  IOMUX_GPR13_SATA_SPEED(n)		__SHIFTIN(n, __BIT(15))
#define  IOMUX_GPR13_SATA_PHY_5(n)		__SHIFTIN(n, __BIT(14))
#define  IOMUX_GPR13_SATA_PHY_4(n)		__SHIFTIN(n, __BITS(13, 11))
#define  IOMUX_GPR13_SATA_PHY_3(n)		__SHIFTIN(n, __BITS(10, 7))
#define  IOMUX_GPR13_SATA_PHY_2(n)		__SHIFTIN(n, __BITS(6, 2))
#define  IOMUX_GPR13_SATA_PHY_1(n)		__SHIFTIN(n, __BIT(1))
#define  IOMUX_GPR13_SATA_PHY_0(n)		__SHIFTIN(n, __BIT(0))

/* for iMX6Dual/Quad */
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1			0x0000004c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2			0x00000050
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0			0x00000054
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC			0x00000058
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0			0x0000005c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1			0x00000060
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2			0x00000064
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3			0x00000068
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL		0x0000006c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0			0x00000070
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL		0x00000074
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1			0x00000078
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2			0x0000007c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3			0x00000080
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC			0x00000084
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR25			0x00000088
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_EB2_B			0x0000008c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA16			0x00000090
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA17			0x00000094
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA18			0x00000098
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA19			0x0000009c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA20			0x000000a0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA21			0x000000a4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA22			0x000000a8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA23			0x000000ac
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_EB3_B			0x000000b0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA24			0x000000b4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA25			0x000000b8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA26			0x000000bc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA27			0x000000c0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA28			0x000000c4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA29			0x000000c8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA30			0x000000cc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA31			0x000000d0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR24			0x000000d4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR23			0x000000d8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR22			0x000000dc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR21			0x000000e0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR20			0x000000e4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR19			0x000000e8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR18			0x000000ec
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR17			0x000000f0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR16			0x000000f4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_CS0_B			0x000000f8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_CS1_B			0x000000fc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_OE_B			0x00000100
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_RW			0x00000104
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_LBA_B			0x00000108
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_EB0_B			0x0000010c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_EB1_B			0x00000110
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD00			0x00000114
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD01			0x00000118
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD02			0x0000011c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD03			0x00000120
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD04			0x00000124
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD05			0x00000128
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD06			0x0000012c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD07			0x00000130
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD08			0x00000134
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD09			0x00000138
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD10			0x0000013c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD11			0x00000140
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD12			0x00000144
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD13			0x00000148
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD14			0x0000014c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_AD15			0x00000150
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_WAIT_B			0x00000154
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_EIM_BCLK			0x00000158
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DI0_DISP_CLK		0x0000015c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15			0x00000160
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02			0x00000164
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03			0x00000168
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04			0x0000016c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA00		0x00000170
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA01		0x00000174
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA02		0x00000178
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA03		0x0000017c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA04		0x00000180
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA05		0x00000184
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA06		0x00000188
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA07		0x0000018c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA08		0x00000190
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA09		0x00000194
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA10		0x00000198
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA11		0x0000019c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA12		0x000001a0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA13		0x000001a4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA14		0x000001a8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA15		0x000001ac
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16		0x000001b0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA17		0x000001b4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA18		0x000001b8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA19		0x000001bc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA20		0x000001c0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA21		0x000001c4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA22		0x000001c8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA23		0x000001cc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO			0x000001d0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_REF_CLK		0x000001d4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_ER			0x000001d8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV		0x000001dc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1		0x000001e0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA0		0x000001e4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN			0x000001e8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA1		0x000001ec
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA0		0x000001f0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC			0x000001f4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_COL0			0x000001f8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW0			0x000001fc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_COL1			0x00000200
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW1			0x00000204
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_COL2			0x00000208
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW2			0x0000020c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_COL3			0x00000210
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW3			0x00000214
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_COL4			0x00000218
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW4			0x0000021c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO00			0x00000220
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO01			0x00000224
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO09			0x00000228
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO03			0x0000022c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO06			0x00000230
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO02			0x00000234
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO04			0x00000238
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO05			0x0000023c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO07			0x00000240
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO08			0x00000244
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO16			0x00000248
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO17			0x0000024c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO18			0x00000250
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_GPIO19			0x00000254
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_PIXCLK		0x00000258
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_HSYNC			0x0000025c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA_EN		0x00000260
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_VSYNC			0x00000264
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA04		0x00000268
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA05		0x0000026c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA06		0x00000270
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA07		0x00000274
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA08		0x00000278
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA09		0x0000027c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA10		0x00000280
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA11		0x00000284
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA12		0x00000288
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA13		0x0000028c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA14		0x00000290
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA15		0x00000294
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA16		0x00000298
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA17		0x0000029c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA18		0x000002a0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA19		0x000002a4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA7			0x000002a8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA6			0x000002ac
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA5			0x000002b0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA4			0x000002b4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_CMD			0x000002b8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_CLK			0x000002bc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA0			0x000002c0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA1			0x000002c4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA2			0x000002c8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA3			0x000002cc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD3_RESET			0x000002d0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_CLE			0x000002d4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_ALE			0x000002d8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_WP_B			0x000002dc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_READY_B		0x000002e0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_CS0_B			0x000002e4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_CS1_B			0x000002e8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_CS2_B			0x000002ec
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_CS3_B			0x000002f0
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_CMD			0x000002f4
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_CLK			0x000002f8
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA00		0x000002fc
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA01		0x00000300
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA02		0x00000304
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA03		0x00000308
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA04		0x0000030c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA05		0x00000310
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA06		0x00000314
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA07		0x00000318
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA0			0x0000031c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA1			0x00000320
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA2			0x00000324
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA3			0x00000328
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA4			0x0000032c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA5			0x00000330
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA6			0x00000334
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA7			0x00000338
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA1			0x0000033c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA0			0x00000340
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA3			0x00000344
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD1_CMD			0x00000348
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA2			0x0000034c
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD1_CLK			0x00000350
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD2_CLK			0x00000354
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD2_CMD			0x00000358
#define IMX6DQ_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3			0x0000035c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1			0x00000360
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2			0x00000364
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0			0x00000368
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC			0x0000036c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0			0x00000370
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1			0x00000374
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2			0x00000378
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3			0x0000037c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL		0x00000380
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0			0x00000384
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL		0x00000388
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1			0x0000038c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2			0x00000390
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3			0x00000394
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC			0x00000398
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR25			0x0000039c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_EB2_B			0x000003a0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA16			0x000003a4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA17			0x000003a8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA18			0x000003ac
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA19			0x000003b0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA20			0x000003b4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA21			0x000003b8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA22			0x000003bc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA23			0x000003c0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_EB3_B			0x000003c4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA24			0x000003c8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA25			0x000003cc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA26			0x000003d0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA27			0x000003d4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA28			0x000003d8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA29			0x000003dc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA30			0x000003e0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA31			0x000003e4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR24			0x000003e8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR23			0x000003ec
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR22			0x000003f0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR21			0x000003f4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR20			0x000003f8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR19			0x000003fc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR18			0x00000400
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR17			0x00000404
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR16			0x00000408
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_CS0_B			0x0000040c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_CS1_B			0x00000410
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_OE_B			0x00000414
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_RW			0x00000418
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_LBA_B			0x0000041c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_EB0_B			0x00000420
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_EB1_B			0x00000424
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD00			0x00000428
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD01			0x0000042c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD02			0x00000430
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD03			0x00000434
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD04			0x00000438
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD05			0x0000043c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD06			0x00000440
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD07			0x00000444
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD08			0x00000448
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD09			0x0000044c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD10			0x00000450
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD11			0x00000454
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD12			0x00000458
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD13			0x0000045c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD14			0x00000460
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_AD15			0x00000464
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_WAIT_B			0x00000468
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_EIM_BCLK			0x0000046c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK		0x00000470
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15			0x00000474
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02			0x00000478
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03			0x0000047c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04			0x00000480
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00		0x00000484
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01		0x00000488
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02		0x0000048c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03		0x00000490
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04		0x00000494
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05		0x00000498
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06		0x0000049c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07		0x000004a0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08		0x000004a4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09		0x000004a8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10		0x000004ac
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11		0x000004b0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12		0x000004b4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13		0x000004b8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14		0x000004bc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15		0x000004c0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16		0x000004c4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17		0x000004c8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18		0x000004cc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19		0x000004d0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA20		0x000004d4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA21		0x000004d8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA22		0x000004dc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA23		0x000004e0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO			0x000004e4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK		0x000004e8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_ER			0x000004ec
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV		0x000004f0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1		0x000004f4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA0		0x000004f8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN			0x000004fc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA1		0x00000500
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0		0x00000504
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC			0x00000508
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P		0x0000050c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5			0x00000510
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4			0x00000514
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P		0x00000518
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P		0x0000051c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3			0x00000520
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P		0x00000524
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2			0x00000528
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00		0x0000052c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01		0x00000530
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02		0x00000534
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03		0x00000538
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04		0x0000053c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05		0x00000540
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06		0x00000544
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07		0x00000548
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08		0x0000054c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09		0x00000550
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10		0x00000554
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11		0x00000558
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12		0x0000055c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13		0x00000560
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14		0x00000564
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15		0x00000568
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_B			0x0000056c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_B			0x00000570
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_B			0x00000574
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_B			0x00000578
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET			0x0000057c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0			0x00000580
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1			0x00000584
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P		0x00000588
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2			0x0000058c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0		0x00000590
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P		0x00000594
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1		0x00000598
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0			0x0000059c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1			0x000005a0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_B		0x000005a4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P		0x000005a8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0			0x000005ac
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P		0x000005b0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1			0x000005b4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P		0x000005b8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6			0x000005bc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P		0x000005c0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7			0x000005c4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_COL0			0x000005c8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW0			0x000005cc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_COL1			0x000005d0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW1			0x000005d4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_COL2			0x000005d8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW2			0x000005dc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_COL3			0x000005e0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW3			0x000005e4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_COL4			0x000005e8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW4			0x000005ec
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO00			0x000005f0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO01			0x000005f4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO09			0x000005f8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO03			0x000005fc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO06			0x00000600
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO02			0x00000604
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO04			0x00000608
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO05			0x0000060c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO07			0x00000610
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO08			0x00000614
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO16			0x00000618
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO17			0x0000061c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO18			0x00000620
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_GPIO19			0x00000624
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK		0x00000628
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC			0x0000062c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA_EN		0x00000630
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC			0x00000634
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04		0x00000638
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05		0x0000063c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06		0x00000640
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07		0x00000644
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08		0x00000648
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09		0x0000064c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10		0x00000650
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11		0x00000654
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12		0x00000658
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13		0x0000065c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14		0x00000660
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15		0x00000664
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16		0x00000668
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17		0x0000066c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18		0x00000670
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19		0x00000674
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_JTAG_TMS			0x00000678
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_JTAG_MOD			0x0000067c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_JTAG_TRSTB			0x00000680
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_JTAG_TDI			0x00000684
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_JTAG_TCK			0x00000688
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_JTAG_TDO			0x0000068c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA7			0x00000690
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA6			0x00000694
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA5			0x00000698
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA4			0x0000069c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_CMD			0x000006a0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_CLK			0x000006a4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA0			0x000006a8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA1			0x000006ac
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA2			0x000006b0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA3			0x000006b4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD3_RESET			0x000006b8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_CLE			0x000006bc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_ALE			0x000006c0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_WP_B			0x000006c4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_READY_B		0x000006c8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_CS0_B			0x000006cc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_CS1_B			0x000006d0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_CS2_B			0x000006d4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B			0x000006d8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_CMD			0x000006dc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_CLK			0x000006e0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA00		0x000006e4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA01		0x000006e8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA02		0x000006ec
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA03		0x000006f0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA04		0x000006f4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA05		0x000006f8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA06		0x000006fc
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA07		0x00000700
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA0			0x00000704
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA1			0x00000708
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA2			0x0000070c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA3			0x00000710
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA4			0x00000714
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA5			0x00000718
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA6			0x0000071c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA7			0x00000720
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA1			0x00000724
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA0			0x00000728
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA3			0x0000072c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD1_CMD			0x00000730
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA2			0x00000734
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD1_CLK			0x00000738
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK			0x0000073c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD			0x00000740
#define IMX6DQ_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3			0x00000744
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_B7DS			0x00000748
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_ADDDS			0x0000074c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL		0x00000750
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_TERM_CTL0			0x00000754
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_DDRPKE			0x00000758
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_TERM_CTL1			0x0000075c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_TERM_CTL2			0x00000760
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_TERM_CTL3			0x00000764
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_DDRPK			0x00000768
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_TERM_CTL4			0x0000076c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_DDRHYS			0x00000770
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_DDRMODE			0x00000774
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_TERM_CTL5			0x00000778
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_TERM_CTL6			0x0000077c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_TERM_CTL7			0x00000780
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_B0DS			0x00000784
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_B1DS			0x00000788
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_CTLDS			0x0000078c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII		0x00000790
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_B2DS			0x00000794
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE			0x00000798
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_B3DS			0x0000079c
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_B4DS			0x000007a0
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_B5DS			0x000007a4
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_B6DS			0x000007a8
#define IMX6DQ_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM			0x000007ac
#define IMX6DQ_IOMUXC_ASRC_ASRCK_CLOCK_6_SELECT_INPUT		0x000007b0
#define IMX6DQ_IOMUXC_AUD4_INPUT_DA_AMX_SELECT_INPUT		0x000007b4
#define IMX6DQ_IOMUXC_AUD4_INPUT_DB_AMX_SELECT_INPUT		0x000007b8
#define IMX6DQ_IOMUXC_AUD4_INPUT_RXCLK_AMX_SELECT_INPUT		0x000007bc
#define IMX6DQ_IOMUXC_AUD4_INPUT_RXFS_AMX_SELECT_INPUT		0x000007c0
#define IMX6DQ_IOMUXC_AUD4_INPUT_TXCLK_AMX_SELECT_INPUT		0x000007c4
#define IMX6DQ_IOMUXC_AUD4_INPUT_TXFS_AMX_SELECT_INPUT		0x000007c8
#define IMX6DQ_IOMUXC_AUD5_INPUT_DA_AMX_SELECT_INPUT		0x000007cc
#define IMX6DQ_IOMUXC_AUD5_INPUT_DB_AMX_SELECT_INPUT		0x000007d0
#define IMX6DQ_IOMUXC_AUD5_INPUT_RXCLK_AMX_SELECT_INPUT		0x000007d4
#define IMX6DQ_IOMUXC_AUD5_INPUT_RXFS_AMX_SELECT_INPUT		0x000007d8
#define IMX6DQ_IOMUXC_AUD5_INPUT_TXCLK_AMX_SELECT_INPUT		0x000007dc
#define IMX6DQ_IOMUXC_AUD5_INPUT_TXFS_AMX_SELECT_INPUT		0x000007e0
#define IMX6DQ_IOMUXC_FLEXCAN1_RX_SELECT_INPUT			0x000007e4
#define IMX6DQ_IOMUXC_FLEXCAN2_RX_SELECT_INPUT			0x000007e8
#define IMX6DQ_IOMUXC_CCM_PMIC_READY_SELECT_INPUT		0x000007f0
#define IMX6DQ_IOMUXC_ECSPI1_CSPI_CLK_IN_SELECT_INPUT		0x000007f4
#define IMX6DQ_IOMUXC_ECSPI1_MISO_SELECT_INPUT			0x000007f8
#define IMX6DQ_IOMUXC_ECSPI1_MOSI_SELECT_INPUT			0x000007fc
#define IMX6DQ_IOMUXC_ECSPI1_SS0_SELECT_INPUT			0x00000800
#define IMX6DQ_IOMUXC_ECSPI1_SS1_SELECT_INPUT			0x00000804
#define IMX6DQ_IOMUXC_ECSPI1_SS2_SELECT_INPUT			0x00000808
#define IMX6DQ_IOMUXC_ECSPI1_SS3_SELECT_INPUT			0x0000080c
#define IMX6DQ_IOMUXC_ECSPI2_CSPI_CLK_IN_SELECT_INPUT		0x00000810
#define IMX6DQ_IOMUXC_ECSPI2_MISO_SELECT_INPUT			0x00000814
#define IMX6DQ_IOMUXC_ECSPI2_MOSI_SELECT_INPUT			0x00000818
#define IMX6DQ_IOMUXC_ECSPI2_SS0_SELECT_INPUT			0x0000081c
#define IMX6DQ_IOMUXC_ECSPI2_SS1_SELECT_INPUT			0x00000820
#define IMX6DQ_IOMUXC_ECSPI4_SS0_SELECT_INPUT			0x00000824
#define IMX6DQ_IOMUXC_ECSPI5_CSPI_CLK_IN_SELECT_INPUT		0x00000828
#define IMX6DQ_IOMUXC_ECSPI5_MISO_SELECT_INPUT			0x0000082c
#define IMX6DQ_IOMUXC_ECSPI5_MOSI_SELECT_INPUT			0x00000830
#define IMX6DQ_IOMUXC_ECSPI5_SS0_SELECT_INPUT			0x00000834
#define IMX6DQ_IOMUXC_ECSPI5_SS1_SELECT_INPUT			0x00000838
#define IMX6DQ_IOMUXC_ENET_REF_CLK_SELECT_INPUT			0x0000083c
#define IMX6DQ_IOMUXC_ENET_MAC0_MDIO_SELECT_INPUT		0x00000840
#define IMX6DQ_IOMUXC_ENET_MAC0_RX_CLK_SELECT_INPUT		0x00000844
#define IMX6DQ_IOMUXC_ENET_MAC0_RX_DATA0_SELECT_INPUT		0x00000848
#define IMX6DQ_IOMUXC_ENET_MAC0_RX_DATA1_SELECT_INPUT		0x0000084c
#define IMX6DQ_IOMUXC_ENET_MAC0_RX_DATA2_SELECT_INPUT		0x00000850
#define IMX6DQ_IOMUXC_ENET_MAC0_RX_DATA3_SELECT_INPUT		0x00000854
#define IMX6DQ_IOMUXC_ENET_MAC0_RX_EN_SELECT_INPUT		0x00000858
#define IMX6DQ_IOMUXC_ESAI_RX_FS_SELECT_INPUT			0x0000085c
#define IMX6DQ_IOMUXC_ESAI_TX_FS_SELECT_INPUT			0x00000860
#define IMX6DQ_IOMUXC_ESAI_RX_HF_CLK_SELECT_INPUT		0x00000864
#define IMX6DQ_IOMUXC_ESAI_TX_HF_CLK_SELECT_INPUT		0x00000868
#define IMX6DQ_IOMUXC_ESAI_RX_CLK_SELECT_INPUT			0x0000086c
#define IMX6DQ_IOMUXC_ESAI_TX_CLK_SELECT_INPUT			0x00000870
#define IMX6DQ_IOMUXC_ESAI_SDO0_SELECT_INPUT			0x00000874
#define IMX6DQ_IOMUXC_ESAI_SDO1_SELECT_INPUT			0x00000878
#define IMX6DQ_IOMUXC_ESAI_SDO2_SDI3_SELECT_INPUT		0x0000087c
#define IMX6DQ_IOMUXC_ESAI_SDO3_SDI2_SELECT_INPUT		0x00000880
#define IMX6DQ_IOMUXC_ESAI_SDO4_SDI1_SELECT_INPUT		0x00000884
#define IMX6DQ_IOMUXC_ESAI_SDO5_SDI0_SELECT_INPUT		0x00000888
#define IMX6DQ_IOMUXC_HDMI_ICECIN_SELECT_INPUT			0x0000088c
#define IMX6DQ_IOMUXC_HDMI_II2C_CLKIN_SELECT_INPUT		0x00000890
#define IMX6DQ_IOMUXC_HDMI_II2C_DATAIN_SELECT_INPUT		0x00000894
#define IMX6DQ_IOMUXC_I2C1_SCL_IN_SELECT_INPUT			0x00000898
#define IMX6DQ_IOMUXC_I2C1_SDA_IN_SELECT_INPUT			0x0000089c
#define IMX6DQ_IOMUXC_I2C2_SCL_IN_SELECT_INPUT			0x000008a0
#define IMX6DQ_IOMUXC_I2C2_SDA_IN_SELECT_INPUT			0x000008a4
#define IMX6DQ_IOMUXC_I2C3_SCL_IN_SELECT_INPUT			0x000008a8
#define IMX6DQ_IOMUXC_I2C3_SDA_IN_SELECT_INPUT			0x000008ac
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA10_SELECT_INPUT		0x000008b0
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA11_SELECT_INPUT		0x000008b4
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA12_SELECT_INPUT		0x000008b8
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA13_SELECT_INPUT		0x000008bc
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA14_SELECT_INPUT		0x000008c0
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA15_SELECT_INPUT		0x000008c4
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA16_SELECT_INPUT		0x000008c8
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA17_SELECT_INPUT		0x000008cc
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA18_SELECT_INPUT		0x000008d0
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA19_SELECT_INPUT		0x000008d4
#define IMX6DQ_IOMUXC_IPU2_SENS1_DATA_EN_SELECT_INPUT		0x000008d8
#define IMX6DQ_IOMUXC_IPU2_SENS1_HSYNC_SELECT_INPUT		0x000008dc
#define IMX6DQ_IOMUXC_IPU2_SENS1_PIX_CLK_SELECT_INPUT		0x000008e0
#define IMX6DQ_IOMUXC_IPU2_SENS1_VSYNC_SELECT_INPUT		0x000008e4
#define IMX6DQ_IOMUXC_KEY_COL5_SELECT_INPUT			0x000008e8
#define IMX6DQ_IOMUXC_KEY_COL6_SELECT_INPUT			0x000008ec
#define IMX6DQ_IOMUXC_KEY_COL7_SELECT_INPUT			0x000008f0
#define IMX6DQ_IOMUXC_KEY_ROW5_SELECT_INPUT			0x000008f4
#define IMX6DQ_IOMUXC_KEY_ROW6_SELECT_INPUT			0x000008f8
#define IMX6DQ_IOMUXC_KEY_ROW7_SELECT_INPUT			0x000008fc
#define IMX6DQ_IOMUXC_MLB_MLB_CLK_IN_SELECT_INPUT		0x00000900
#define IMX6DQ_IOMUXC_MLB_MLB_DATA_IN_SELECT_INPUT		0x00000904
#define IMX6DQ_IOMUXC_MLB_MLB_SIG_IN_SELECT_INPUT		0x00000908
#define IMX6DQ_IOMUXC_SDMA_EVENTS14_SELECT_INPUT		0x0000090c
#define IMX6DQ_IOMUXC_SDMA_EVENTS15_SELECT_INPUT		0x00000910
#define IMX6DQ_IOMUXC_SPDIF_SPDIF_IN1_SELECT_INPUT		0x00000914
#define IMX6DQ_IOMUXC_SPDIF_TX_CLK2_SELECT_INPUT		0x00000918
#define IMX6DQ_IOMUXC_UART1_UART_RTS_B_SELECT_INPUT		0x0000091c
#define IMX6DQ_IOMUXC_UART1_UART_RX_DATA_SELECT_INPUT		0x00000920
#define IMX6DQ_IOMUXC_UART2_UART_RTS_B_SELECT_INPUT		0x00000924
#define IMX6DQ_IOMUXC_UART2_UART_RX_DATA_SELECT_INPUT		0x00000928
#define IMX6DQ_IOMUXC_UART3_UART_RTS_B_SELECT_INPUT		0x0000092c
#define IMX6DQ_IOMUXC_UART3_UART_RX_DATA_SELECT_INPUT		0x00000930
#define IMX6DQ_IOMUXC_UART4_UART_RTS_B_SELECT_INPUT		0x00000934
#define IMX6DQ_IOMUXC_UART4_UART_RX_DATA_SELECT_INPUT		0x00000938
#define IMX6DQ_IOMUXC_UART5_UART_RTS_B_SELECT_INPUT		0x0000093c
#define IMX6DQ_IOMUXC_UART5_UART_RX_DATA_SELECT_INPUT		0x00000940
#define IMX6DQ_IOMUXC_USB_OTG_OC_SELECT_INPUT			0x00000944
#define IMX6DQ_IOMUXC_USB_H1_OC_SELECT_INPUT			0x00000948

/* for iMX6Solo/DualLite */
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA10		0x0000004c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA11		0x00000050
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA12		0x00000054
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA13		0x00000058
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA14		0x0000005c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA15		0x00000060
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA16		0x00000064
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA17		0x00000068
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA18		0x0000006c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA19		0x00000070
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA04		0x00000074
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA05		0x00000078
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA06		0x0000007c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA07		0x00000080
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA08		0x00000084
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA09		0x00000088
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA_EN		0x0000008c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_HSYNC		0x00000090
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_PIXCLK		0x00000094
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_CSI0_VSYNC		0x00000098
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DI0_DISP_CLK		0x0000009c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15			0x000000a0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02			0x000000a4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03			0x000000a8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04			0x000000ac
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA00		0x000000b0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA01		0x000000b4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA10		0x000000b8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA11		0x000000bc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA12		0x000000c0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA13		0x000000c4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA14		0x000000c8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA15		0x000000cc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16		0x000000d0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA17		0x000000d4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA18		0x000000d8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA19		0x000000dc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA02		0x000000e0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA20		0x000000e4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA21		0x000000e8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA22		0x000000ec
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA23		0x000000f0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA03		0x000000f4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA04		0x000000f8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA05		0x000000fc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA06		0x00000100
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA07		0x00000104
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA08		0x00000108
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA09		0x0000010c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR16		0x00000110
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR17		0x00000114
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR18		0x00000118
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR19		0x0000011c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR20		0x00000120
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR21		0x00000124
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR22		0x00000128
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR23		0x0000012c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR24		0x00000130
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_ADDR25		0x00000134
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_BCLK			0x00000138
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_CS0_B			0x0000013c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_CS1_B			0x00000140
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA16		0x00000144
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA17		0x00000148
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA18		0x0000014c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA19		0x00000150
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA20		0x00000154
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA21		0x00000158
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA22		0x0000015c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA23		0x00000160
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA24		0x00000164
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA25		0x00000168
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA26		0x0000016c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA27		0x00000170
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA28		0x00000174
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA29		0x00000178
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA30		0x0000017c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_DATA31		0x00000180
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD00			0x00000184
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD01			0x00000188
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD10			0x0000018c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD11			0x00000190
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD12			0x00000194
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD13			0x00000198
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD14			0x0000019c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD15			0x000001a0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD02			0x000001a4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD03			0x000001a8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD04			0x000001ac
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD05			0x000001b0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD06			0x000001b4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD07			0x000001b8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD08			0x000001bc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_AD09			0x000001c0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_EB0_B			0x000001c4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_EB1_B			0x000001c8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_EB2_B			0x000001cc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_EB3_B			0x000001d0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_LBA_B			0x000001d4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_OE_B			0x000001d8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_RW			0x000001dc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_EIM_WAIT_B		0x000001e0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV		0x000001e4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC			0x000001e8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO			0x000001ec
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_REF_CLK		0x000001f0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_ER		0x000001f4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA0		0x000001f8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1		0x000001fc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN		0x00000200
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA0		0x00000204
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA1		0x00000208
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO00			0x0000020c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO01			0x00000210
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO16			0x00000214
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO17			0x00000218
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO18			0x0000021c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO19			0x00000220
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO02			0x00000224
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO03			0x00000228
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO04			0x0000022c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO05			0x00000230
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO06			0x00000234
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO07			0x00000238
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO08			0x0000023c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_GPIO09			0x00000240
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL0			0x00000244
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL1			0x00000248
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL2			0x0000024c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL3			0x00000250
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL4			0x00000254
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW0			0x00000258
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW1			0x0000025c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW2			0x00000260
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW3			0x00000264
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW4			0x00000268
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_ALE			0x0000026c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_CLE			0x00000270
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_CS0_B		0x00000274
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_CS1_B		0x00000278
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_CS2_B		0x0000027c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_CS3_B		0x00000280
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA00		0x00000284
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA01		0x00000288
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA02		0x0000028c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA03		0x00000290
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA04		0x00000294
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA05		0x00000298
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA06		0x0000029c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA07		0x000002a0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_READY_B		0x000002a4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_NAND_WP_B			0x000002a8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0			0x000002ac
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1			0x000002b0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2			0x000002b4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3			0x000002b8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL		0x000002bc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC			0x000002c0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0			0x000002c4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1			0x000002c8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2			0x000002cc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3			0x000002d0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL		0x000002d4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC			0x000002d8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD1_CLK			0x000002dc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD1_CMD			0x000002e0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA0			0x000002e4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA1			0x000002e8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA2			0x000002ec
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA3			0x000002f0
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD2_CLK			0x000002f4
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD2_CMD			0x000002f8
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0			0x000002fc
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1			0x00000300
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2			0x00000304
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3			0x00000308
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_CLK			0x0000030c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_CMD			0x00000310
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA0			0x00000314
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA1			0x00000318
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA2			0x0000031c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA3			0x00000320
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA4			0x00000324
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA5			0x00000328
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA6			0x0000032c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA7			0x00000330
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD3_RESET			0x00000334
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_CLK			0x00000338
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_CMD			0x0000033c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA0			0x00000340
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA1			0x00000344
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA2			0x00000348
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA3			0x0000034c
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA4			0x00000350
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA5			0x00000354
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA6			0x00000358
#define IMX6SDL_IOMUXC_SW_MUX_CTL_PAD_SD4_DATA7			0x0000035c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10		0x00000360
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11		0x00000364
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12		0x00000368
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13		0x0000036c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14		0x00000370
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15		0x00000374
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16		0x00000378
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17		0x0000037c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18		0x00000380
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19		0x00000384
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04		0x00000388
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05		0x0000038c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06		0x00000390
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07		0x00000394
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08		0x00000398
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09		0x0000039c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA_EN		0x000003a0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC		0x000003a4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK		0x000003a8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC		0x000003ac
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK		0x000003b0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15			0x000003b4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02			0x000003b8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03			0x000003bc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04			0x000003c0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00		0x000003c4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01		0x000003c8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10		0x000003cc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11		0x000003d0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12		0x000003d4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13		0x000003d8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14		0x000003dc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15		0x000003e0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16		0x000003e4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17		0x000003e8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18		0x000003ec
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19		0x000003f0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02		0x000003f4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA20		0x000003f8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA21		0x000003fc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA22		0x00000400
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA23		0x00000404
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03		0x00000408
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04		0x0000040c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05		0x00000410
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06		0x00000414
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07		0x00000418
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08		0x0000041c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09		0x00000420
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00		0x00000424
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01		0x00000428
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10		0x0000042c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11		0x00000430
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12		0x00000434
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13		0x00000438
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14		0x0000043c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15		0x00000440
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02		0x00000444
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03		0x00000448
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04		0x0000044c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05		0x00000450
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06		0x00000454
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07		0x00000458
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08		0x0000045c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09		0x00000460
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_B		0x00000464
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_B		0x00000468
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_B		0x0000046c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0			0x00000470
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1			0x00000474
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2			0x00000478
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3			0x0000047c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4			0x00000480
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5			0x00000484
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6			0x00000488
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7			0x0000048c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_B		0x00000490
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET		0x00000494
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0		0x00000498
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1		0x0000049c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2		0x000004a0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0		0x000004a4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1		0x000004a8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P		0x000004ac
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P		0x000004b0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0			0x000004b4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1			0x000004b8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P		0x000004bc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P		0x000004c0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P		0x000004c4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P		0x000004c8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P		0x000004cc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P		0x000004d0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P		0x000004d4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P		0x000004d8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_B		0x000004dc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR16		0x000004e0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR17		0x000004e4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR18		0x000004e8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR19		0x000004ec
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR20		0x000004f0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR21		0x000004f4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR22		0x000004f8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR23		0x000004fc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR24		0x00000500
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_ADDR25		0x00000504
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_BCLK			0x00000508
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_CS0_B			0x0000050c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_CS1_B			0x00000510
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA16		0x00000514
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA17		0x00000518
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA18		0x0000051c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA19		0x00000520
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA20		0x00000524
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA21		0x00000528
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA22		0x0000052c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA23		0x00000530
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA24		0x00000534
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA25		0x00000538
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA26		0x0000053c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA27		0x00000540
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA28		0x00000544
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA29		0x00000548
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA30		0x0000054c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_DATA31		0x00000550
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD00			0x00000554
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD01			0x00000558
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD10			0x0000055c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD11			0x00000560
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD12			0x00000564
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD13			0x00000568
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD14			0x0000056c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD15			0x00000570
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD02			0x00000574
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD03			0x00000578
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD04			0x0000057c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD05			0x00000580
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD06			0x00000584
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD07			0x00000588
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD08			0x0000058c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_AD09			0x00000590
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_EB0_B			0x00000594
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_EB1_B			0x00000598
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_EB2_B			0x0000059c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_EB3_B			0x000005a0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_LBA_B			0x000005a4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_OE_B			0x000005a8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_RW			0x000005ac
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_EIM_WAIT_B		0x000005b0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV		0x000005b4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC			0x000005b8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO			0x000005bc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK		0x000005c0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_ER		0x000005c4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA0		0x000005c8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1		0x000005cc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN		0x000005d0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0		0x000005d4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA1		0x000005d8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO00			0x000005dc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO01			0x000005e0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO16			0x000005e4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO17			0x000005e8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO18			0x000005ec
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO19			0x000005f0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO02			0x000005f4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO03			0x000005f8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO04			0x000005fc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO05			0x00000600
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO06			0x00000604
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO07			0x00000608
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO08			0x0000060c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_GPIO09			0x00000610
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_JTAG_MOD			0x00000614
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TCK			0x00000618
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TDI			0x0000061c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TDO			0x00000620
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TMS			0x00000624
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TRSTB		0x00000628
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL0			0x0000062c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL1			0x00000630
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL2			0x00000634
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL3			0x00000638
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL4			0x0000063c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW0			0x00000640
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW1			0x00000644
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW2			0x00000648
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW3			0x0000064c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW4			0x00000650
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_ALE			0x00000654
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_CLE			0x00000658
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_CS0_B		0x0000065c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_CS1_B		0x00000660
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_CS2_B		0x00000664
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B		0x00000668
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA00		0x0000066c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA01		0x00000670
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA02		0x00000674
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA03		0x00000678
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA04		0x0000067c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA05		0x00000680
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA06		0x00000684
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA07		0x00000688
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_READY_B		0x0000068c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_NAND_WP_B			0x00000690
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0			0x00000694
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1			0x00000698
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2			0x0000069c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3			0x000006a0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL		0x000006a4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC			0x000006a8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0			0x000006ac
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1			0x000006b0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2			0x000006b4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3			0x000006b8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL		0x000006bc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC			0x000006c0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD1_CLK			0x000006c4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD1_CMD			0x000006c8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA0			0x000006cc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA1			0x000006d0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA2			0x000006d4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA3			0x000006d8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK			0x000006dc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD			0x000006e0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0			0x000006e4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1			0x000006e8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2			0x000006ec
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3			0x000006f0
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_CLK			0x000006f4
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_CMD			0x000006f8
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA0			0x000006fc
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA1			0x00000700
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA2			0x00000704
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA3			0x00000708
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA4			0x0000070c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA5			0x00000710
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA6			0x00000714
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA7			0x00000718
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD3_RESET			0x0000071c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_CLK			0x00000720
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_CMD			0x00000724
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA0			0x00000728
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA1			0x0000072c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA2			0x00000730
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA3			0x00000734
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA4			0x00000738
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA5			0x0000073c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA6			0x00000740
#define IMX6SDL_IOMUXC_SW_PAD_CTL_PAD_SD4_DATA7			0x00000744
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_B7DS			0x00000748
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_ADDDS			0x0000074c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL		0x00000750
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_DDRPKE			0x00000754
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_DDRPK			0x00000758
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_DDRHYS			0x0000075c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_DDRMODE			0x00000760
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_B0DS			0x00000764
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII		0x00000768
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_CTLDS			0x0000076c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_B1DS			0x00000770
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE			0x00000774
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_B2DS			0x00000778
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_B3DS			0x0000077c
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_B4DS			0x00000780
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_B5DS			0x00000784
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM		0x00000788
#define IMX6SDL_IOMUXC_SW_PAD_CTL_GRP_B6DS			0x0000078c
#define IMX6SDL_IOMUXC_ANALOG_USB_OTG_ID_SELECT_INPUT		0x00000790
#define IMX6SDL_IOMUXC_ASRC_ASRCK_CLOCK_6_SELECT_INPUT		0x00000794
#define IMX6SDL_IOMUXC_AUD4_INPUT_DA_AMX_SELECT_INPUT		0x00000798
#define IMX6SDL_IOMUXC_AUD4_INPUT_DB_AMX_SELECT_INPUT		0x0000079c
#define IMX6SDL_IOMUXC_AUD4_INPUT_RXCLK_AMX_SELECT_INPUT	0x000007a0
#define IMX6SDL_IOMUXC_AUD4_INPUT_RXFS_AMX_SELECT_INPUT		0x000007a4
#define IMX6SDL_IOMUXC_AUD4_INPUT_TXCLK_AMX_SELECT_INPUT	0x000007a8
#define IMX6SDL_IOMUXC_AUD4_INPUT_TXFS_AMX_SELECT_INPUT		0x000007ac
#define IMX6SDL_IOMUXC_AUD5_INPUT_DA_AMX_SELECT_INPUT		0x000007b0
#define IMX6SDL_IOMUXC_AUD5_INPUT_DB_AMX_SELECT_INPUT		0x000007b4
#define IMX6SDL_IOMUXC_AUD5_INPUT_RXCLK_AMX_SELECT_INPUT	0x000007b8
#define IMX6SDL_IOMUXC_AUD5_INPUT_RXFS_AMX_SELECT_INPUT		0x000007bc
#define IMX6SDL_IOMUXC_AUD5_INPUT_TXCLK_AMX_SELECT_INPUT	0x000007c0
#define IMX6SDL_IOMUXC_AUD5_INPUT_TXFS_AMX_SELECT_INPUT		0x000007c4
#define IMX6SDL_IOMUXC_FLEXCAN1_RX_SELECT_INPUT			0x000007c8
#define IMX6SDL_IOMUXC_FLEXCAN2_RX_SELECT_INPUT			0x000007cc
#define IMX6SDL_IOMUXC_CCM_PMIC_READY_SELECT_INPUT		0x000007d4
#define IMX6SDL_IOMUXC_ECSPI1_CSPI_CLK_IN_SELECT_INPUT		0x000007d8
#define IMX6SDL_IOMUXC_ECSPI1_MISO_SELECT_INPUT			0x000007dc
#define IMX6SDL_IOMUXC_ECSPI1_MOSI_SELECT_INPUT			0x000007e0
#define IMX6SDL_IOMUXC_ECSPI1_SS0_SELECT_INPUT			0x000007e4
#define IMX6SDL_IOMUXC_ECSPI1_SS1_SELECT_INPUT			0x000007e8
#define IMX6SDL_IOMUXC_ECSPI1_SS2_SELECT_INPUT			0x000007ec
#define IMX6SDL_IOMUXC_ECSPI1_SS3_SELECT_INPUT			0x000007f0
#define IMX6SDL_IOMUXC_ECSPI2_CSPI_CLK_IN_SELECT_INPUT		0x000007f4
#define IMX6SDL_IOMUXC_ECSPI2_MISO_SELECT_INPUT			0x000007f8
#define IMX6SDL_IOMUXC_ECSPI2_MOSI_SELECT_INPUT			0x000007fc
#define IMX6SDL_IOMUXC_ECSPI2_SS0_SELECT_INPUT			0x00000800
#define IMX6SDL_IOMUXC_ECSPI2_SS1_SELECT_INPUT			0x00000804
#define IMX6SDL_IOMUXC_ECSPI4_SS0_SELECT_INPUT			0x00000808
#define IMX6SDL_IOMUXC_ENET_REF_CLK_SELECT_INPUT		0x0000080c
#define IMX6SDL_IOMUXC_ENET_MAC0_MDIO_SELECT_INPUT		0x00000810
#define IMX6SDL_IOMUXC_ENET_MAC0_RX_CLK_SELECT_INPUT		0x00000814
#define IMX6SDL_IOMUXC_ENET_MAC0_RX_DATA0_SELECT_INPUT		0x00000818
#define IMX6SDL_IOMUXC_ENET_MAC0_RX_DATA1_SELECT_INPUT		0x0000081c
#define IMX6SDL_IOMUXC_ENET_MAC0_RX_DATA2_SELECT_INPUT		0x00000820
#define IMX6SDL_IOMUXC_ENET_MAC0_RX_DATA3_SELECT_INPUT		0x00000824
#define IMX6SDL_IOMUXC_ENET_MAC0_RX_EN_SELECT_INPUT		0x00000828
#define IMX6SDL_IOMUXC_ESAI_RX_FS_SELECT_INPUT			0x0000082c
#define IMX6SDL_IOMUXC_ESAI_TX_FS_SELECT_INPUT			0x00000830
#define IMX6SDL_IOMUXC_ESAI_RX_HF_CLK_SELECT_INPUT		0x00000834
#define IMX6SDL_IOMUXC_ESAI_TX_HF_CLK_SELECT_INPUT		0x00000838
#define IMX6SDL_IOMUXC_ESAI_RX_CLK_SELECT_INPUT			0x0000083c
#define IMX6SDL_IOMUXC_ESAI_TX_CLK_SELECT_INPUT			0x00000840
#define IMX6SDL_IOMUXC_ESAI_SDO0_SELECT_INPUT			0x00000844
#define IMX6SDL_IOMUXC_ESAI_SDO1_SELECT_INPUT			0x00000848
#define IMX6SDL_IOMUXC_ESAI_SDO2_SDI3_SELECT_INPUT		0x0000084c
#define IMX6SDL_IOMUXC_ESAI_SDO3_SDI2_SELECT_INPUT		0x00000850
#define IMX6SDL_IOMUXC_ESAI_SDO4_SDI1_SELECT_INPUT		0x00000854
#define IMX6SDL_IOMUXC_ESAI_SDO5_SDI0_SELECT_INPUT		0x00000858
#define IMX6SDL_IOMUXC_HDMI_ICECIN_SELECT_INPUT			0x0000085c
#define IMX6SDL_IOMUXC_HDMI_II2C_CLKIN_SELECT_INPUT		0x00000860
#define IMX6SDL_IOMUXC_HDMI_II2C_DATAIN_SELECT_INPUT		0x00000864
#define IMX6SDL_IOMUXC_I2C1_SCL_IN_SELECT_INPUT			0x00000868
#define IMX6SDL_IOMUXC_I2C1_SDA_IN_SELECT_INPUT			0x0000086c
#define IMX6SDL_IOMUXC_I2C2_SCL_IN_SELECT_INPUT			0x00000870
#define IMX6SDL_IOMUXC_I2C2_SDA_IN_SELECT_INPUT			0x00000874
#define IMX6SDL_IOMUXC_I2C3_SCL_IN_SELECT_INPUT			0x00000878
#define IMX6SDL_IOMUXC_I2C3_SDA_IN_SELECT_INPUT			0x0000087c
#define IMX6SDL_IOMUXC_I2C4_SCL_IN_SELECT_INPUT			0x00000880
#define IMX6SDL_IOMUXC_I2C4_SDA_IN_SELECT_INPUT			0x00000884
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA10_SELECT_INPUT		0x00000888
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA11_SELECT_INPUT		0x0000088c
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA12_SELECT_INPUT		0x00000890
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA13_SELECT_INPUT		0x00000894
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA14_SELECT_INPUT		0x00000898
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA15_SELECT_INPUT		0x0000089c
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA16_SELECT_INPUT		0x000008a0
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA17_SELECT_INPUT		0x000008a4
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA18_SELECT_INPUT		0x000008a8
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA19_SELECT_INPUT		0x000008ac
#define IMX6SDL_IOMUXC_IPU1_SENS1_DATA_EN_SELECT_INPUT		0x000008b0
#define IMX6SDL_IOMUXC_IPU1_SENS1_HSYNC_SELECT_INPUT		0x000008b4
#define IMX6SDL_IOMUXC_IPU1_SENS1_PIX_CLK_SELECT_INPUT		0x000008b8
#define IMX6SDL_IOMUXC_IPU1_SENS1_VSYNC_SELECT_INPUT		0x000008bc
#define IMX6SDL_IOMUXC_KEY_COL5_SELECT_INPUT			0x000008c0
#define IMX6SDL_IOMUXC_KEY_COL6_SELECT_INPUT			0x000008c4
#define IMX6SDL_IOMUXC_KEY_COL7_SELECT_INPUT			0x000008c8
#define IMX6SDL_IOMUXC_KEY_ROW5_SELECT_INPUT			0x000008cc
#define IMX6SDL_IOMUXC_KEY_ROW6_SELECT_INPUT			0x000008d0
#define IMX6SDL_IOMUXC_KEY_ROW7_SELECT_INPUT			0x000008d4
#define IMX6SDL_IOMUXC_MLB_MLB_CLK_IN_SELECT_INPUT		0x000008dc
#define IMX6SDL_IOMUXC_MLB_MLB_DATA_IN_SELECT_INPUT		0x000008e0
#define IMX6SDL_IOMUXC_MLB_MLB_SIG_IN_SELECT_INPUT		0x000008e4
#define IMX6SDL_IOMUXC_SDMA_EVENTS14_SELECT_INPUT		0x000008e8
#define IMX6SDL_IOMUXC_SDMA_EVENTS15_SELECT_INPUT		0x000008ec
#define IMX6SDL_IOMUXC_SPDIF_SPDIF_IN1_SELECT_INPUT		0x000008f0
#define IMX6SDL_IOMUXC_SPDIF_TX_CLK2_SELECT_INPUT		0x000008f4
#define IMX6SDL_IOMUXC_UART1_UART_RTS_B_SELECT_INPUT		0x000008f8
#define IMX6SDL_IOMUXC_UART1_UART_RX_DATA_SELECT_INPUT		0x000008fc
#define IMX6SDL_IOMUXC_UART2_UART_RTS_B_SELECT_INPUT		0x00000900
#define IMX6SDL_IOMUXC_UART2_UART_RX_DATA_SELECT_INPUT		0x00000904
#define IMX6SDL_IOMUXC_UART3_UART_RTS_B_SELECT_INPUT		0x00000908
#define IMX6SDL_IOMUXC_UART3_UART_RX_DATA_SELECT_INPUT		0x0000090c
#define IMX6SDL_IOMUXC_UART4_UART_RTS_B_SELECT_INPUT		0x00000910
#define IMX6SDL_IOMUXC_UART4_UART_RX_DATA_SELECT_INPUT		0x00000914
#define IMX6SDL_IOMUXC_UART5_UART_RTS_B_SELECT_INPUT		0x00000918
#define IMX6SDL_IOMUXC_UART5_UART_RX_DATA_SELECT_INPUT		0x0000091c
#define IMX6SDL_IOMUXC_USB_OTG_OC_SELECT_INPUT			0x00000920
#define IMX6SDL_IOMUXC_USB_H1_OC_SELECT_INPUT			0x00000924
#define IMX6SDL_IOMUXC_USDHC1_CARD_CLK_IN_SELECT_INPUT		0x00000928
#define IMX6SDL_IOMUXC_USDHC1_WP_ON_SELECT_INPUT		0x0000092c
#define IMX6SDL_IOMUXC_USDHC2_CARD_CLK_IN_SELECT_INPUT		0x00000930
#define IMX6SDL_IOMUXC_USDHC3_CARD_CLK_IN_SELECT_INPUT		0x00000934
#define IMX6SDL_IOMUXC_USDHC4_CARD_CLK_IN_SELECT_INPUT		0x00000938

/* for iMX6SoloLite */
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_AUD_MCLK			0x0000004c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_AUD_RXC			0x00000050
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_AUD_RXD			0x00000054
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_AUD_RXFS			0x00000058
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_AUD_TXC			0x0000005c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_AUD_TXD			0x00000060
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_AUD_TXFS			0x00000064
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MISO		0x00000068
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI		0x0000006c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK		0x00000070
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SS0			0x00000074
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MISO		0x00000078
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MOSI		0x0000007c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SCLK		0x00000080
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SS0			0x00000084
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0			0x00000088
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1			0x0000008c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00		0x00000090
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01		0x00000094
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA10		0x00000098
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA11		0x0000009c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA12		0x000000a0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA13		0x000000a4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA14		0x000000a8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA15		0x000000ac
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02		0x000000b0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03		0x000000b4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04		0x000000b8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05		0x000000bc
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06		0x000000c0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07		0x000000c4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA08		0x000000c8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA09		0x000000cc
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK			0x000000d0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE			0x000000d4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL			0x000000d8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP			0x000000dc
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_COM		0x000000e0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL0		0x000000e4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL1		0x000000e8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL2		0x000000ec
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL3		0x000000f0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_IRQ		0x000000f4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_STAT		0x000000f8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_WAKE		0x000000fc
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0			0x00000100
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1			0x00000104
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2			0x00000108
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3			0x0000010c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK			0x00000110
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE			0x00000114
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE			0x00000118
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR			0x0000011c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM0			0x00000120
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM1			0x00000124
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_CRS_DV			0x00000128
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_MDC			0x0000012c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_MDIO			0x00000130
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_REF_CLK		0x00000134
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_ER			0x00000138
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA0		0x0000013c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA1		0x00000140
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_CLK			0x00000144
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_EN			0x00000148
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA0		0x0000014c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA1		0x00000150
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_USB_H_DATA			0x00000154
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_USB_H_STROBE		0x00000158
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_I2C1_SCL			0x0000015c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_I2C1_SDA			0x00000160
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_I2C2_SCL			0x00000164
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_I2C2_SDA			0x00000168
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL0			0x0000016c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL1			0x00000170
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL2			0x00000174
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL3			0x00000178
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL4			0x0000017c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL5			0x00000180
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL6			0x00000184
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_COL7			0x00000188
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW0			0x0000018c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW1			0x00000190
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW2			0x00000194
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW3			0x00000198
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW4			0x0000019c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW5			0x000001a0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW6			0x000001a4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_KEY_ROW7			0x000001a8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_CLK			0x000001ac
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00			0x000001b0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01			0x000001b4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10			0x000001b8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11			0x000001bc
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12			0x000001c0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13			0x000001c4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14			0x000001c8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15			0x000001cc
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16			0x000001d0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17			0x000001d4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18			0x000001d8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19			0x000001dc
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02			0x000001e0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20			0x000001e4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21			0x000001e8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22			0x000001ec
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23			0x000001f0
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03			0x000001f4
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04			0x000001f8
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05			0x000001fc
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06			0x00000200
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07			0x00000204
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08			0x00000208
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09			0x0000020c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE			0x00000210
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC			0x00000214
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_RESET			0x00000218
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC			0x0000021c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_PWM1			0x00000220
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_REF_CLK_24M		0x00000224
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_REF_CLK_32K		0x00000228
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_CLK			0x0000022c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_CMD			0x00000230
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA0			0x00000234
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA1			0x00000238
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA2			0x0000023c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA3			0x00000240
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA4			0x00000244
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA5			0x00000248
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA6			0x0000024c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA7			0x00000250
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_CLK			0x00000254
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_CMD			0x00000258
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0			0x0000025c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1			0x00000260
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2			0x00000264
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3			0x00000268
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA4			0x0000026c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA5			0x00000270
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA6			0x00000274
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA7			0x00000278
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD2_RESET			0x0000027c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD3_CLK			0x00000280
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD3_CMD			0x00000284
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA0			0x00000288
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA1			0x0000028c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA2			0x00000290
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_SD3_DATA3			0x00000294
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_UART1_RXD			0x00000298
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_UART1_TXD			0x0000029c
#define IMX6SL_IOMUXC_SW_MUX_CTL_PAD_WDOG_B			0x000002a0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_AUD_MCLK			0x000002a4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_AUD_RXC			0x000002a8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_AUD_RXD			0x000002ac
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_AUD_RXFS			0x000002b0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_AUD_TXC			0x000002b4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_AUD_TXD			0x000002b8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_AUD_TXFS			0x000002bc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00		0x000002c0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01		0x000002c4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10		0x000002c8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11		0x000002cc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12		0x000002d0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13		0x000002d4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14		0x000002d8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15		0x000002dc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02		0x000002e0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03		0x000002e4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04		0x000002e8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05		0x000002ec
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06		0x000002f0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07		0x000002f4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08		0x000002f8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09		0x000002fc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_B			0x00000300
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_B			0x00000304
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_B			0x00000308
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0			0x0000030c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1			0x00000310
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2			0x00000314
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3			0x00000318
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_B			0x0000031c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET			0x00000320
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0			0x00000324
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1			0x00000328
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2			0x0000032c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0		0x00000330
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1		0x00000334
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P		0x00000338
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0			0x0000033c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1			0x00000340
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P		0x00000344
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P		0x00000348
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P		0x0000034c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P		0x00000350
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_B		0x00000354
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MISO		0x00000358
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI		0x0000035c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK		0x00000360
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SS0			0x00000364
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MISO		0x00000368
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MOSI		0x0000036c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SCLK		0x00000370
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SS0			0x00000374
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0			0x00000378
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1			0x0000037c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00		0x00000380
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01		0x00000384
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10		0x00000388
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11		0x0000038c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12		0x00000390
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13		0x00000394
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14		0x00000398
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15		0x0000039c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02		0x000003a0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03		0x000003a4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04		0x000003a8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05		0x000003ac
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06		0x000003b0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07		0x000003b4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08		0x000003b8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09		0x000003bc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK			0x000003c0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE			0x000003c4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL			0x000003c8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP			0x000003cc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM		0x000003d0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0		0x000003d4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1		0x000003d8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2		0x000003dc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3		0x000003e0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ		0x000003e4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT		0x000003e8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE		0x000003ec
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0			0x000003f0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1			0x000003f4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2			0x000003f8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3			0x000003fc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK			0x00000400
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE			0x00000404
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE			0x00000408
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR			0x0000040c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0			0x00000410
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1			0x00000414
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV			0x00000418
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC			0x0000041c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO			0x00000420
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK		0x00000424
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER			0x00000428
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0		0x0000042c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1		0x00000430
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK			0x00000434
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN			0x00000438
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0		0x0000043c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1		0x00000440
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_USB_H_DATA			0x00000444
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_USB_H_STROBE		0x00000448
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_I2C1_SCL			0x0000044c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_I2C1_SDA			0x00000450
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_I2C2_SCL			0x00000454
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_I2C2_SDA			0x00000458
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_JTAG_MOD			0x0000045c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TCK			0x00000460
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TDI			0x00000464
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TDO			0x00000468
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TMS			0x0000046c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TRSTB			0x00000470
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL0			0x00000474
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL1			0x00000478
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL2			0x0000047c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL3			0x00000480
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL4			0x00000484
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL5			0x00000488
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL6			0x0000048c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_COL7			0x00000490
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW0			0x00000494
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW1			0x00000498
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW2			0x0000049c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW3			0x000004a0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW4			0x000004a4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW5			0x000004a8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW6			0x000004ac
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_KEY_ROW7			0x000004b0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK			0x000004b4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00			0x000004b8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01			0x000004bc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10			0x000004c0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11			0x000004c4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12			0x000004c8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13			0x000004cc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14			0x000004d0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15			0x000004d4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16			0x000004d8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17			0x000004dc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18			0x000004e0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19			0x000004e4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02			0x000004e8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20			0x000004ec
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21			0x000004f0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22			0x000004f4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23			0x000004f8
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03			0x000004fc
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04			0x00000500
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05			0x00000504
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06			0x00000508
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07			0x0000050c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08			0x00000510
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09			0x00000514
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE			0x00000518
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC			0x0000051c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET			0x00000520
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC			0x00000524
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_PWM1			0x00000528
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_REF_CLK_24M		0x0000052c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_REF_CLK_32K		0x00000530
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_CLK			0x00000534
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_CMD			0x00000538
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA0			0x0000053c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA1			0x00000540
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA2			0x00000544
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA3			0x00000548
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA4			0x0000054c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA5			0x00000550
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA6			0x00000554
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA7			0x00000558
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK			0x0000055c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD			0x00000560
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0			0x00000564
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1			0x00000568
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2			0x0000056c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3			0x00000570
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA4			0x00000574
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA5			0x00000578
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6			0x0000057c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7			0x00000580
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET			0x00000584
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD3_CLK			0x00000588
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD3_CMD			0x0000058c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA0			0x00000590
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA1			0x00000594
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA2			0x00000598
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_SD3_DATA3			0x0000059c
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_UART1_RXD			0x000005a0
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_UART1_TXD			0x000005a4
#define IMX6SL_IOMUXC_SW_PAD_CTL_PAD_WDOG_B			0x000005a8
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_ADDDS			0x000005ac
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL		0x000005b0
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_DDRPKE			0x000005b4
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_DDRPK			0x000005b8
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_DDRHYS			0x000005bc
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_DDRMODE			0x000005c0
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_B0DS			0x000005c4
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_CTLDS			0x000005c8
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_B1DS			0x000005cc
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE			0x000005d0
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_B2DS			0x000005d4
#define IMX6SL_IOMUXC_SW_PAD_CTL_GRP_B3DS			0x000005d8
#define IMX6SL_IOMUXC_ANALOG_USB_OTG_ID_SELECT_INPUT		0x000005dc
#define IMX6SL_IOMUXC_ANALOG_USB_H1_ID_SELECT_INPUT		0x000005e0
#define IMX6SL_IOMUXC_AUD4_INPUT_DA_AMX_SELECT_INPUT		0x000005e4
#define IMX6SL_IOMUXC_AUD4_INPUT_DB_AMX_SELECT_INPUT		0x000005e8
#define IMX6SL_IOMUXC_AUD4_INPUT_RXCLK_AMX_SELECT_INPUT		0x000005ec
#define IMX6SL_IOMUXC_AUD4_INPUT_RXFS_AMX_SELECT_INPUT		0x000005f0
#define IMX6SL_IOMUXC_AUD4_INPUT_TXCLK_AMX_SELECT_INPUT		0x000005f4
#define IMX6SL_IOMUXC_AUD4_INPUT_TXFS_AMX_SELECT_INPUT		0x000005f8
#define IMX6SL_IOMUXC_AUD5_INPUT_DA_AMX_SELECT_INPUT		0x000005fc
#define IMX6SL_IOMUXC_AUD5_INPUT_DB_AMX_SELECT_INPUT		0x00000600
#define IMX6SL_IOMUXC_AUD5_INPUT_RXCLK_AMX_SELECT_INPUT		0x00000604
#define IMX6SL_IOMUXC_AUD5_INPUT_RXFS_AMX_SELECT_INPUT		0x00000608
#define IMX6SL_IOMUXC_AUD5_INPUT_TXCLK_AMX_SELECT_INPUT		0x0000060c
#define IMX6SL_IOMUXC_AUD5_INPUT_TXFS_AMX_SELECT_INPUT		0x00000610
#define IMX6SL_IOMUXC_AUD6_INPUT_DA_AMX_SELECT_INPUT		0x00000614
#define IMX6SL_IOMUXC_AUD6_INPUT_DB_AMX_SELECT_INPUT		0x00000618
#define IMX6SL_IOMUXC_AUD6_INPUT_RXCLK_AMX_SELECT_INPUT		0x0000061c
#define IMX6SL_IOMUXC_AUD6_INPUT_RXFS_AMX_SELECT_INPUT		0x00000620
#define IMX6SL_IOMUXC_AUD6_INPUT_TXCLK_AMX_SELECT_INPUT		0x00000624
#define IMX6SL_IOMUXC_AUD6_INPUT_TXFS_AMX_SELECT_INPUT		0x00000628
#define IMX6SL_IOMUXC_CCM_PMIC_READY_SELECT_INPUT		0x0000062c
#define IMX6SL_IOMUXC_CSI_CSI_DATA00_SELECT_INPUT		0x00000630
#define IMX6SL_IOMUXC_CSI_CSI_DATA01_SELECT_INPUT		0x00000634
#define IMX6SL_IOMUXC_CSI_CSI_DATA02_SELECT_INPUT		0x00000638
#define IMX6SL_IOMUXC_CSI_CSI_DATA03_SELECT_INPUT		0x0000063c
#define IMX6SL_IOMUXC_CSI_CSI_DATA04_SELECT_INPUT		0x00000640
#define IMX6SL_IOMUXC_CSI_CSI_DATA05_SELECT_INPUT		0x00000644
#define IMX6SL_IOMUXC_CSI_CSI_DATA06_SELECT_INPUT		0x00000648
#define IMX6SL_IOMUXC_CSI_CSI_DATA07_SELECT_INPUT		0x0000064c
#define IMX6SL_IOMUXC_CSI_CSI_DATA08_SELECT_INPUT		0x00000650
#define IMX6SL_IOMUXC_CSI_CSI_DATA09_SELECT_INPUT		0x00000654
#define IMX6SL_IOMUXC_CSI_CSI_DATA10_SELECT_INPUT		0x00000658
#define IMX6SL_IOMUXC_CSI_CSI_DATA11_SELECT_INPUT		0x0000065c
#define IMX6SL_IOMUXC_CSI_CSI_DATA12_SELECT_INPUT		0x00000660
#define IMX6SL_IOMUXC_CSI_CSI_DATA13_SELECT_INPUT		0x00000664
#define IMX6SL_IOMUXC_CSI_CSI_DATA14_SELECT_INPUT		0x00000668
#define IMX6SL_IOMUXC_CSI_CSI_DATA15_SELECT_INPUT		0x0000066c
#define IMX6SL_IOMUXC_CSI_CSI_HSYNC_SELECT_INPUT		0x00000670
#define IMX6SL_IOMUXC_CSI_CSI_PIXCLK_SELECT_INPUT		0x00000674
#define IMX6SL_IOMUXC_CSI_CSI_VSYNC_SELECT_INPUT		0x00000678
#define IMX6SL_IOMUXC_ECSPI1_CSPI_CLK_IN_SELECT_INPUT		0x0000067c
#define IMX6SL_IOMUXC_ECSPI1_DATAREADY_B_SELECT_INPUT		0x00000680
#define IMX6SL_IOMUXC_ECSPI1_MISO_SELECT_INPUT			0x00000684
#define IMX6SL_IOMUXC_ECSPI1_MOSI_SELECT_INPUT			0x00000688
#define IMX6SL_IOMUXC_ECSPI1_SS0_SELECT_INPUT			0x0000068c
#define IMX6SL_IOMUXC_ECSPI1_SS1_SELECT_INPUT			0x00000690
#define IMX6SL_IOMUXC_ECSPI1_SS2_SELECT_INPUT			0x00000694
#define IMX6SL_IOMUXC_ECSPI1_SS3_SELECT_INPUT			0x00000698
#define IMX6SL_IOMUXC_ECSPI2_CSPI_CLK_IN_SELECT_INPUT		0x0000069c
#define IMX6SL_IOMUXC_ECSPI2_MISO_SELECT_INPUT			0x000006a0
#define IMX6SL_IOMUXC_ECSPI2_MOSI_SELECT_INPUT			0x000006a4
#define IMX6SL_IOMUXC_ECSPI2_SS0_SELECT_INPUT			0x000006a8
#define IMX6SL_IOMUXC_ECSPI2_SS1_SELECT_INPUT			0x000006ac
#define IMX6SL_IOMUXC_ECSPI3_CSPI_CLK_IN_SELECT_INPUT		0x000006b0
#define IMX6SL_IOMUXC_ECSPI3_DATAREADY_B_SELECT_INPUT		0x000006b4
#define IMX6SL_IOMUXC_ECSPI3_MISO_SELECT_INPUT			0x000006b8
#define IMX6SL_IOMUXC_ECSPI3_MOSI_SELECT_INPUT			0x000006bc
#define IMX6SL_IOMUXC_ECSPI3_SS0_SELECT_INPUT			0x000006c0
#define IMX6SL_IOMUXC_ECSPI3_SS1_SELECT_INPUT			0x000006c4
#define IMX6SL_IOMUXC_ECSPI3_SS2_SELECT_INPUT			0x000006c8
#define IMX6SL_IOMUXC_ECSPI3_SS3_SELECT_INPUT			0x000006cc
#define IMX6SL_IOMUXC_ECSPI4_CSPI_CLK_IN_SELECT_INPUT		0x000006d0
#define IMX6SL_IOMUXC_ECSPI4_MISO_SELECT_INPUT			0x000006d4
#define IMX6SL_IOMUXC_ECSPI4_MOSI_SELECT_INPUT			0x000006d8
#define IMX6SL_IOMUXC_ECSPI4_SS0_SELECT_INPUT			0x000006dc
#define IMX6SL_IOMUXC_ECSPI4_SS1_SELECT_INPUT			0x000006e0
#define IMX6SL_IOMUXC_ECSPI4_SS2_SELECT_INPUT			0x000006e4
#define IMX6SL_IOMUXC_EPDC_EPDC_PWR_IRQ_SELECT_INPUT		0x000006e8
#define IMX6SL_IOMUXC_EPDC_EPDC_PWR_STAT_SELECT_INPUT		0x000006ec
#define IMX6SL_IOMUXC_FEC_FEC_COL_SELECT_INPUT			0x000006f0
#define IMX6SL_IOMUXC_FEC_FEC_MDI_SELECT_INPUT			0x000006f4
#define IMX6SL_IOMUXC_FEC_FEC_RX_DATA0_SELECT_INPUT		0x000006f8
#define IMX6SL_IOMUXC_FEC_FEC_RX_DATA1_SELECT_INPUT		0x000006fc
#define IMX6SL_IOMUXC_FEC_FEC_RX_CLK_SELECT_INPUT		0x00000700
#define IMX6SL_IOMUXC_FEC_FEC_RX_DV_SELECT_INPUT		0x00000704
#define IMX6SL_IOMUXC_FEC_FEC_RX_ER_SELECT_INPUT		0x00000708
#define IMX6SL_IOMUXC_FEC_FEC_TX_CLK_SELECT_INPUT		0x0000070c
#define IMX6SL_IOMUXC_GPT_CAPIN1_SELECT_INPUT			0x00000710
#define IMX6SL_IOMUXC_GPT_CAPIN2_SELECT_INPUT			0x00000714
#define IMX6SL_IOMUXC_GPT_CLKIN_SELECT_INPUT			0x00000718
#define IMX6SL_IOMUXC_I2C1_SCL_IN_SELECT_INPUT			0x0000071c
#define IMX6SL_IOMUXC_I2C1_SDA_IN_SELECT_INPUT			0x00000720
#define IMX6SL_IOMUXC_I2C2_SCL_IN_SELECT_INPUT			0x00000724
#define IMX6SL_IOMUXC_I2C2_SDA_IN_SELECT_INPUT			0x00000728
#define IMX6SL_IOMUXC_I2C3_SCL_IN_SELECT_INPUT			0x0000072c
#define IMX6SL_IOMUXC_I2C3_SDA_IN_SELECT_INPUT			0x00000730
#define IMX6SL_IOMUXC_KEY_COL0_SELECT_INPUT			0x00000734
#define IMX6SL_IOMUXC_KEY_COL1_SELECT_INPUT			0x00000738
#define IMX6SL_IOMUXC_KEY_COL2_SELECT_INPUT			0x0000073c
#define IMX6SL_IOMUXC_KEY_COL3_SELECT_INPUT			0x00000740
#define IMX6SL_IOMUXC_KEY_COL4_SELECT_INPUT			0x00000744
#define IMX6SL_IOMUXC_KEY_COL5_SELECT_INPUT			0x00000748
#define IMX6SL_IOMUXC_KEY_COL6_SELECT_INPUT			0x0000074c
#define IMX6SL_IOMUXC_KEY_COL7_SELECT_INPUT			0x00000750
#define IMX6SL_IOMUXC_KEY_ROW0_SELECT_INPUT			0x00000754
#define IMX6SL_IOMUXC_KEY_ROW1_SELECT_INPUT			0x00000758
#define IMX6SL_IOMUXC_KEY_ROW2_SELECT_INPUT			0x0000075c
#define IMX6SL_IOMUXC_KEY_ROW3_SELECT_INPUT			0x00000760
#define IMX6SL_IOMUXC_KEY_ROW4_SELECT_INPUT			0x00000764
#define IMX6SL_IOMUXC_KEY_ROW5_SELECT_INPUT			0x00000768
#define IMX6SL_IOMUXC_KEY_ROW6_SELECT_INPUT			0x0000076c
#define IMX6SL_IOMUXC_KEY_ROW7_SELECT_INPUT			0x00000770
#define IMX6SL_IOMUXC_LCD_BUSY_SELECT_INPUT			0x00000774
#define IMX6SL_IOMUXC_LCD_DATA00_SELECT_INPUT			0x00000778
#define IMX6SL_IOMUXC_LCD_DATA01_SELECT_INPUT			0x0000077c
#define IMX6SL_IOMUXC_LCD_DATA02_SELECT_INPUT			0x00000780
#define IMX6SL_IOMUXC_LCD_DATA03_SELECT_INPUT			0x00000784
#define IMX6SL_IOMUXC_LCD_DATA04_SELECT_INPUT			0x00000788
#define IMX6SL_IOMUXC_LCD_DATA05_SELECT_INPUT			0x0000078c
#define IMX6SL_IOMUXC_LCD_DATA06_SELECT_INPUT			0x00000790
#define IMX6SL_IOMUXC_LCD_DATA07_SELECT_INPUT			0x00000794
#define IMX6SL_IOMUXC_LCD_DATA08_SELECT_INPUT			0x00000798
#define IMX6SL_IOMUXC_LCD_DATA09_SELECT_INPUT			0x0000079c
#define IMX6SL_IOMUXC_LCD_DATA10_SELECT_INPUT			0x000007a0
#define IMX6SL_IOMUXC_LCD_DATA11_SELECT_INPUT			0x000007a4
#define IMX6SL_IOMUXC_LCD_DATA12_SELECT_INPUT			0x000007a8
#define IMX6SL_IOMUXC_LCD_DATA13_SELECT_INPUT			0x000007ac
#define IMX6SL_IOMUXC_LCD_DATA14_SELECT_INPUT			0x000007b0
#define IMX6SL_IOMUXC_LCD_DATA15_SELECT_INPUT			0x000007b4
#define IMX6SL_IOMUXC_LCD_DATA16_SELECT_INPUT			0x000007b8
#define IMX6SL_IOMUXC_LCD_DATA17_SELECT_INPUT			0x000007bc
#define IMX6SL_IOMUXC_LCD_DATA18_SELECT_INPUT			0x000007c0
#define IMX6SL_IOMUXC_LCD_DATA19_SELECT_INPUT			0x000007c4
#define IMX6SL_IOMUXC_LCD_DATA20_SELECT_INPUT			0x000007c8
#define IMX6SL_IOMUXC_LCD_DATA21_SELECT_INPUT			0x000007cc
#define IMX6SL_IOMUXC_LCD_DATA22_SELECT_INPUT			0x000007d0
#define IMX6SL_IOMUXC_LCD_DATA23_SELECT_INPUT			0x000007d4
#define IMX6SL_IOMUXC_SPDIF_SPDIF_IN1_SELECT_INPUT		0x000007f0
#define IMX6SL_IOMUXC_SPDIF_TX_CLK2_SELECT_INPUT		0x000007f4
#define IMX6SL_IOMUXC_UART1_UART_RTS_B_SELECT_INPUT		0x000007f8
#define IMX6SL_IOMUXC_UART1_UART_RX_DATA_SELECT_INPUT		0x000007fc
#define IMX6SL_IOMUXC_UART2_UART_RTS_B_SELECT_INPUT		0x00000800
#define IMX6SL_IOMUXC_UART2_UART_RX_DATA_SELECT_INPUT		0x00000804
#define IMX6SL_IOMUXC_UART3_UART_RTS_B_SELECT_INPUT		0x00000808
#define IMX6SL_IOMUXC_UART3_UART_RX_DATA_SELECT_INPUT		0x0000080c
#define IMX6SL_IOMUXC_UART4_UART_RTS_B_SELECT_INPUT		0x00000810
#define IMX6SL_IOMUXC_UART4_UART_RX_DATA_SELECT_INPUT		0x00000814
#define IMX6SL_IOMUXC_UART5_UART_RTS_B_SELECT_INPUT		0x00000818
#define IMX6SL_IOMUXC_UART5_UART_RX_DATA_SELECT_INPUT		0x0000081c
#define IMX6SL_IOMUXC_USB_OTG2_OC_SELECT_INPUT			0x00000820
#define IMX6SL_IOMUXC_USB_OTG1_OC_SELECT_INPUT			0x00000824
#define IMX6SL_IOMUXC_USDHC1_CARD_DET_SELECT_INPUT		0x00000828
#define IMX6SL_IOMUXC_USDHC1_WP_ON_SELECT_INPUT			0x0000082c
#define IMX6SL_IOMUXC_USDHC2_CARD_DET_SELECT_INPUT		0x00000830
#define IMX6SL_IOMUXC_USDHC2_WP_ON_SELECT_INPUT			0x00000834
#define IMX6SL_IOMUXC_USDHC3_CARD_DET_SELECT_INPUT		0x00000838
#define IMX6SL_IOMUXC_USDHC3_DATA4_IN_SELECT_INPUT		0x0000083c
#define IMX6SL_IOMUXC_USDHC3_DATA5_IN_SELECT_INPUT		0x00000840
#define IMX6SL_IOMUXC_USDHC3_DATA6_IN_SELECT_INPUT		0x00000844
#define IMX6SL_IOMUXC_USDHC3_DATA7_IN_SELECT_INPUT		0x00000848
#define IMX6SL_IOMUXC_USDHC3_WP_ON_SELECT_INPUT			0x0000084c
#define IMX6SL_IOMUXC_USDHC4_CARD_CLK_IN_SELECT_INPUT		0x00000850
#define IMX6SL_IOMUXC_USDHC4_CARD_DET_SELECT_INPUT		0x00000854
#define IMX6SL_IOMUXC_USDHC4_CMD_IN_SELECT_INPUT		0x00000858
#define IMX6SL_IOMUXC_USDHC4_DATA0_IN_SELECT_INPUT		0x0000085c
#define IMX6SL_IOMUXC_USDHC4_DATA1_IN_SELECT_INPUT		0x00000860
#define IMX6SL_IOMUXC_USDHC4_DATA2_IN_SELECT_INPUT		0x00000864
#define IMX6SL_IOMUXC_USDHC4_DATA3_IN_SELECT_INPUT		0x00000868
#define IMX6SL_IOMUXC_USDHC4_DATA4_IN_SELECT_INPUT		0x0000086c
#define IMX6SL_IOMUXC_USDHC4_DATA5_IN_SELECT_INPUT		0x00000870
#define IMX6SL_IOMUXC_USDHC4_DATA6_IN_SELECT_INPUT		0x00000874
#define IMX6SL_IOMUXC_USDHC4_DATA7_IN_SELECT_INPUT		0x00000878
#define IMX6SL_IOMUXC_USDHC4_WP_ON_SELECT_INPUT			0x0000087c
#define IMX6SL_IOMUXC_EIM_DTACK_B_SELECT_INPUT			0x00000880
#define IMX6SL_IOMUXC_EIM_WAIT_B_SELECT_INPUT			0x00000884

/* for iMX6UltraLight */
#define IMX6UL_IOMUX_GPR0					0x00004000
#define IMX6UL_IOMUX_GPR1					0x00004004
#define  IMX6UL_IOMUX_GPR1_ARMA7_CLK_AHB_EN			__BIT(26)
#define  IMX6UL_IOMUX_GPR1_ARMA7_CLK_ATB_EN			__BIT(25)
#define  IMX6UL_IOMUX_GPR1_ARMA7_CLK_APB_DBG_EN			__BIT(24)
#define  IMX6UL_IOMUX_GPR1_TZASC1_BOOT_LOCK			__BIT(23)
#define  IMX6UL_IOMUX_GPR1_EXC_MON				__BIT(22)
#define  IMX6UL_IOMUX_GPR1_SAI3_MCLK_DIR			__BIT(21)
#define  IMX6UL_IOMUX_GPR1_SAI2_MCLK_DIR			__BIT(20)
#define  IMX6UL_IOMUX_GPR1_SAI1_MCLK_DIR			__BIT(19)
#define  IMX6UL_IOMUX_GPR1_ENET2_TX_CLK_DIR			__BIT(18)
#define  IMX6UL_IOMUX_GPR1_ENET1_TX_CLK_DIR			__BIT(17)
#define  IMX6UL_IOMUX_GPR1_ADD_DS				__BIT(16)
#define  IMX6UL_IOMUX_GPR1_USB_EXP_MODE				__BIT(15)
#define  IMX6UL_IOMUX_GPR1_ENET2_CLK_SEL			__BIT(14)
#define  IMX6UL_IOMUX_GPR1_ENET1_CLK_SEL			__BIT(13)
#define  IMX6UL_IOMUX_GPR1_GINT					__BIT(12)
#define IMX6UL_IOMUX_GPR2					0x00004008
#define IMX6UL_IOMUX_GPR3					0x0000400c
#define IMX6UL_IOMUX_GPR4					0x00004010
#define IMX6UL_IOMUX_GPR5					0x00004014
#define IMX6UL_IOMUX_GPR9					0x00004024
#define IMX6UL_IOMUX_GPR10					0x00004028
#define IMX6UL_IOMUX_GPR14					0x00004038
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_BOOT_MODE0			0x00000014
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_BOOT_MODE1			0x00000018
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER0		0x0000001c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER1		0x00000020
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER2		0x00000024
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER3		0x00000028
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER4		0x0000002c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER5		0x00000030
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER6		0x00000034
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER7		0x00000038
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER8		0x0000003c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER9		0x00000040
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_JTAG_MOD			0x00000044
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_JTAG_TMS			0x00000048
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_JTAG_TDO			0x0000004c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_JTAG_TDI			0x00000050
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_JTAG_TCK			0x00000054
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_JTAG_TRST_B		0x00000058
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO00			0x0000005c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO01			0x00000060
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO02			0x00000064
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO03			0x00000068
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO04			0x0000006c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO05			0x00000070
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO06			0x00000074
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO07			0x00000078
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO08			0x0000007c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO09			0x00000080
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA		0x00000084
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA		0x00000088
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART1_CTS_B		0x0000008c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART1_RTS_B		0x00000090
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART2_TX_DATA		0x00000094
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART2_RX_DATA		0x00000098
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART2_CTS_B		0x0000009c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART2_RTS_B		0x000000a0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART3_TX_DATA		0x000000a4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART3_RX_DATA		0x000000a8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART3_CTS_B		0x000000ac
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART3_RTS_B		0x000000b0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART4_TX_DATA		0x000000b4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART4_RX_DATA		0x000000b8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART5_TX_DATA		0x000000bc
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_UART5_RX_DATA		0x000000c0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET1_RX_DATA0		0x000000c4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET1_RX_DATA1		0x000000c8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET1_RX_EN		0x000000cc
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET1_TX_DATA0		0x000000d0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET1_TX_DATA1		0x000000d4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET1_TX_EN		0x000000d8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET1_TX_CLK		0x000000dc
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET1_RX_ER		0x000000e0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET2_RX_DATA0		0x000000e4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET2_RX_DATA1		0x000000e8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET2_RX_EN		0x000000ec
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET2_TX_DATA0		0x000000f0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET2_TX_DATA1		0x000000f4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET2_TX_EN		0x000000f8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET2_TX_CLK		0x000000fc
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_ENET2_RX_ER		0x00000100
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_CLK			0x00000104
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE			0x00000108
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC			0x0000010c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC			0x00000110
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_RESET			0x00000114
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00			0x00000118
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01			0x0000011c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02			0x00000120
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03			0x00000124
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04			0x00000128
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05			0x0000012c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06			0x00000130
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07			0x00000134
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08			0x00000138
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09			0x0000013c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10			0x00000140
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11			0x00000144
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12			0x00000148
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13			0x0000014c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14			0x00000150
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15			0x00000154
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16			0x00000158
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17			0x0000015c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18			0x00000160
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19			0x00000164
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20			0x00000168
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21			0x0000016c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22			0x00000170
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23			0x00000174
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_RE_B			0x00000178
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_WE_B			0x0000017c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA00		0x00000180
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA01		0x00000184
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA02		0x00000188
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA03		0x0000018c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA04		0x00000190
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA05		0x00000194
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA06		0x00000198
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DATA07		0x0000019c
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_ALE			0x000001a0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_WP_B			0x000001a4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_READY_B		0x000001a8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_CE0_B			0x000001ac
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_CE1_B			0x000001b0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_CLE			0x000001b4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_NAND_DQS			0x000001b8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SD1_CMD			0x000001bc
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SD1_CLK			0x000001c0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA0			0x000001c4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA1			0x000001c8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA2			0x000001cc
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_SD1_DATA3			0x000001d0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_MCLK			0x000001d4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_PIXCLK			0x000001d8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_VSYNC			0x000001dc
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_HSYNC			0x000001e0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_DATA00			0x000001e4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_DATA01			0x000001e8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_DATA02			0x000001ec
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_DATA03			0x000001f0
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_DATA04			0x000001f4
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_DATA05			0x000001f8
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_DATA06			0x000001fc
#define IMX6UL_IOMUXC_SW_MUX_CTL_PAD_CSI_DATA07			0x00000200
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00		0x00000204
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01		0x00000208
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02		0x0000020c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03		0x00000210
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04		0x00000214
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05		0x00000218
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06		0x0000021c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07		0x00000220
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08		0x00000224
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09		0x00000228
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10		0x0000022c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11		0x00000230
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12		0x00000234
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13		0x00000238
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14		0x0000023c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15		0x00000240
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0			0x00000244
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1			0x00000248
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_B			0x0000024c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_B			0x00000250
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_B			0x00000254
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_B			0x00000258
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_B		0x0000025c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0			0x00000260
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1			0x00000264
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0			0x00000268
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1			0x0000026c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2			0x00000270
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0		0x00000274
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1		0x00000278
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P		0x0000027c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P		0x00000280
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P		0x00000284
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET			0x00000288
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_TEST_MODE			0x0000028c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_POR_B			0x00000290
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ONOFF			0x00000294
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_PMIC_ON_REQ		0x00000298
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CCM_PMIC_STBY_REQ		0x0000029c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_BOOT_MODE0			0x000002a0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_BOOT_MODE1			0x000002a4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER0		0x000002a8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER1		0x000002ac
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER2		0x000002b0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER3		0x000002b4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER4		0x000002b8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER5		0x000002bc
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER6		0x000002c0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER7		0x000002c4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER8		0x000002c8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SNVS_TAMPER9		0x000002cc
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_JTAG_MOD			0x000002d0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TMS			0x000002d4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TDO			0x000002d8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TDI			0x000002dc
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TCK			0x000002e0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_JTAG_TRST_B		0x000002e4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO00			0x000002e8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO01			0x000002ec
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO02			0x000002f0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO03			0x000002f4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO04			0x000002f8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO05			0x000002fc
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO06			0x00000300
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO07			0x00000304
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO08			0x00000308
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_GPIO1_IO09			0x0000030c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART1_TX_DATA		0x00000310
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART1_RX_DATA		0x00000314
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART1_CTS_B		0x00000318
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART1_RTS_B		0x0000031c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART2_TX_DATA		0x00000320
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART2_RX_DATA		0x00000324
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART2_CTS_B		0x00000328
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART2_RTS_B		0x0000032c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART3_TX_DATA		0x00000330
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART3_RX_DATA		0x00000334
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART3_CTS_B		0x00000338
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART3_RTS_B		0x0000033c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART4_TX_DATA		0x00000340
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART4_RX_DATA		0x00000344
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART5_TX_DATA		0x00000348
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_UART5_RX_DATA		0x0000034c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET1_RX_DATA0		0x00000350
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET1_RX_DATA1		0x00000354
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET1_RX_EN		0x00000358
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET1_TX_DATA0		0x0000035c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET1_TX_DATA1		0x00000360
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET1_TX_EN		0x00000364
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET1_TX_CLK		0x00000368
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET1_RX_ER		0x0000036c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET2_RX_DATA0		0x00000370
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET2_RX_DATA1		0x00000374
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET2_RX_EN		0x00000378
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET2_TX_DATA0		0x0000037c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET2_TX_DATA1		0x00000380
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET2_TX_EN		0x00000384
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET2_TX_CLK		0x00000388
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_ENET2_RX_ER		0x0000038c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK			0x00000390
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE			0x00000394
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC			0x00000398
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC			0x0000039c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET			0x000003a0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00			0x000003a4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01			0x000003a8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02			0x000003ac
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03			0x000003b0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04			0x000003b4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05			0x000003b8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06			0x000003bc
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07			0x000003c0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08			0x000003c4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09			0x000003c8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10			0x000003cc
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11			0x000003d0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12			0x000003d4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13			0x000003d8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14			0x000003dc
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15			0x000003e0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16			0x000003e4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17			0x000003e8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18			0x000003ec
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19			0x000003f0
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20			0x000003f4
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21			0x000003f8
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22			0x000003fc
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23			0x00000400
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_RE_B			0x00000404
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_WE_B			0x00000408
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA00		0x0000040c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA01		0x00000410
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA02		0x00000414
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA03		0x00000418
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA04		0x0000041c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA05		0x00000420
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA06		0x00000424
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DATA07		0x00000428
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_ALE			0x0000042c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_WP_B			0x00000430
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_READY_B		0x00000434
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_CE0_B			0x00000438
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_CE1_B			0x0000043c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_CLE			0x00000440
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_NAND_DQS			0x00000444
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SD1_CMD			0x00000448
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SD1_CLK			0x0000044c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA0			0x00000450
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA1			0x00000454
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA2			0x00000458
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_SD1_DATA3			0x0000045c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_MCLK			0x00000460
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_PIXCLK			0x00000464
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_VSYNC			0x00000468
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_HSYNC			0x0000046c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_DATA00			0x00000470
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_DATA01			0x00000474
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_DATA02			0x00000478
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_DATA03			0x0000047c
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_DATA04			0x00000480
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_DATA05			0x00000484
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_DATA06			0x00000488
#define IMX6UL_IOMUXC_SW_PAD_CTL_PAD_CSI_DATA07			0x0000048c
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_ADDDS			0x00000490
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL		0x00000494
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_B0DS			0x00000498
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_DDRPK			0x0000049c
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_CTLDS			0x000004a0
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_B1DS			0x000004a4
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_DDRHYS			0x000004a8
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_DDRPKE			0x000004ac
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_DDRMODE			0x000004b0
#define IMX6UL_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE			0x000004b4
#define IMX6UL_IOMUXC_USB_OTG1_ID_SELECT_INPUT			0x000004b8
#define IMX6UL_IOMUXC_USB_OTG2_ID_SELECT_INPUT			0x000004bc
#define IMX6UL_IOMUXC_CCM_PMIC_READY_SELECT_INPUT		0x000004c0
#define IMX6UL_IOMUXC_CSI_DATA02_SELECT_INPUT			0x000004c4
#define IMX6UL_IOMUXC_CSI_DATA03_SELECT_INPUT			0x000004c8
#define IMX6UL_IOMUXC_CSI_DATA05_SELECT_INPUT			0x000004cc
#define IMX6UL_IOMUXC_CSI_DATA00_SELECT_INPUT			0x000004d0
#define IMX6UL_IOMUXC_CSI_DATA01_SELECT_INPUT			0x000004d4
#define IMX6UL_IOMUXC_CSI_DATA04_SELECT_INPUT			0x000004d8
#define IMX6UL_IOMUXC_CSI_DATA06_SELECT_INPUT			0x000004dc
#define IMX6UL_IOMUXC_CSI_DATA07_SELECT_INPUT			0x000004e0
#define IMX6UL_IOMUXC_CSI_DATA08_SELECT_INPUT			0x000004e4
#define IMX6UL_IOMUXC_CSI_DATA09_SELECT_INPUT			0x000004e8
#define IMX6UL_IOMUXC_CSI_DATA10_SELECT_INPUT			0x000004ec
#define IMX6UL_IOMUXC_CSI_DATA11_SELECT_INPUT			0x000004f0
#define IMX6UL_IOMUXC_CSI_DATA12_SELECT_INPUT			0x000004f4
#define IMX6UL_IOMUXC_CSI_DATA13_SELECT_INPUT			0x000004f8
#define IMX6UL_IOMUXC_CSI_DATA14_SELECT_INPUT			0x000004fc
#define IMX6UL_IOMUXC_CSI_DATA15_SELECT_INPUT			0x00000500
#define IMX6UL_IOMUXC_CSI_DATA16_SELECT_INPUT			0x00000504
#define IMX6UL_IOMUXC_CSI_DATA17_SELECT_INPUT			0x00000508
#define IMX6UL_IOMUXC_CSI_DATA18_SELECT_INPUT			0x0000050c
#define IMX6UL_IOMUXC_CSI_DATA19_SELECT_INPUT			0x00000510
#define IMX6UL_IOMUXC_CSI_DATA20_SELECT_INPUT			0x00000514
#define IMX6UL_IOMUXC_CSI_DATA21_SELECT_INPUT			0x00000518
#define IMX6UL_IOMUXC_CSI_DATA22_SELECT_INPUT			0x0000051c
#define IMX6UL_IOMUXC_CSI_DATA23_SELECT_INPUT			0x00000520
#define IMX6UL_IOMUXC_CSI_HSYNC_SELECT_INPUT			0x00000524
#define IMX6UL_IOMUXC_CSI_PIXCLK_SELECT_INPUT			0x00000528
#define IMX6UL_IOMUXC_CSI_VSYNC_SELECT_INPUT			0x0000052c
#define IMX6UL_IOMUXC_CSI_FIELD_SELECT_INPUT			0x00000530
#define IMX6UL_IOMUXC_ECSPI1_SCLK_SELECT_INPUT			0x00000534
#define IMX6UL_IOMUXC_ECSPI1_MISO_SELECT_INPUT			0x00000538
#define IMX6UL_IOMUXC_ECSPI1_MOSI_SELECT_INPUT			0x0000053c
#define IMX6UL_IOMUXC_ECSPI1_SS0_B_SELECT_INPUT			0x00000540
#define IMX6UL_IOMUXC_ECSPI2_SCLK_SELECT_INPUT			0x00000544
#define IMX6UL_IOMUXC_ECSPI2_MISO_SELECT_INPUT			0x00000548
#define IMX6UL_IOMUXC_ECSPI2_MOSI_SELECT_INPUT			0x0000054c
#define IMX6UL_IOMUXC_ECSPI2_SS0_B_SELECT_INPUT			0x00000550
#define IMX6UL_IOMUXC_ECSPI3_SCLK_SELECT_INPUT			0x00000554
#define IMX6UL_IOMUXC_ECSPI3_MISO_SELECT_INPUT			0x00000558
#define IMX6UL_IOMUXC_ECSPI3_MOSI_SELECT_INPUT			0x0000055c
#define IMX6UL_IOMUXC_ECSPI3_SS0_B_SELECT_INPUT			0x00000560
#define IMX6UL_IOMUXC_ECSPI4_SCLK_SELECT_INPUT			0x00000564
#define IMX6UL_IOMUXC_ECSPI4_MISO_SELECT_INPUT			0x00000568
#define IMX6UL_IOMUXC_ECSPI4_MOSI_SELECT_INPUT			0x0000056c
#define IMX6UL_IOMUXC_ECSPI4_SS0_B_SELECT_INPUT			0x00000570
#define IMX6UL_IOMUXC_ENET1_REF_CLK1_SELECT_INPUT		0x00000574
#define IMX6UL_IOMUXC_ENET1_MAC0_MDIO_SELECT_INPUT		0x00000578
#define IMX6UL_IOMUXC_ENET2_REF_CLK2_SELECT_INPUT		0x0000057c
#define IMX6UL_IOMUXC_ENET2_MAC0_MDIO_SELECT_INPUT		0x00000580
#define IMX6UL_IOMUXC_FLEXCAN1_RX_SELECT_INPUT			0x00000584
#define IMX6UL_IOMUXC_FLEXCAN2_RX_SELECT_INPUT			0x00000588
#define IMX6UL_IOMUXC_GPT1_CAPTURE1_SELECT_INPUT		0x0000058c
#define IMX6UL_IOMUXC_GPT1_CAPTURE2_SELECT_INPUT		0x00000590
#define IMX6UL_IOMUXC_GPT1_CLK_SELECT_INPUT			0x00000594
#define IMX6UL_IOMUXC_GPT2_CAPTURE1_SELECT_INPUT		0x00000598
#define IMX6UL_IOMUXC_GPT2_CAPTURE2_SELECT_INPUT		0x0000059c
#define IMX6UL_IOMUXC_GPT2_CLK_SELECT_INPUT			0x000005a0
#define IMX6UL_IOMUXC_I2C1_SCL_SELECT_INPUT			0x000005a4
#define IMX6UL_IOMUXC_I2C1_SDA_SELECT_INPUT			0x000005a8
#define IMX6UL_IOMUXC_I2C2_SCL_SELECT_INPUT			0x000005ac
#define IMX6UL_IOMUXC_I2C2_SDA_SELECT_INPUT			0x000005b0
#define IMX6UL_IOMUXC_I2C3_SCL_SELECT_INPUT			0x000005b4
#define IMX6UL_IOMUXC_I2C3_SDA_SELECT_INPUT			0x000005b8
#define IMX6UL_IOMUXC_I2C4_SCL_SELECT_INPUT			0x000005bc
#define IMX6UL_IOMUXC_I2C4_SDA_SELECT_INPUT			0x000005c0
#define IMX6UL_IOMUXC_KPP_COL0_SELECT_INPUT			0x000005c4
#define IMX6UL_IOMUXC_KPP_COL1_SELECT_INPUT			0x000005c8
#define IMX6UL_IOMUXC_KPP_COL2_SELECT_INPUT			0x000005cc
#define IMX6UL_IOMUXC_KPP_ROW0_SELECT_INPUT			0x000005d0
#define IMX6UL_IOMUXC_KPP_ROW1_SELECT_INPUT			0x000005d4
#define IMX6UL_IOMUXC_KPP_ROW2_SELECT_INPUT			0x000005d8
#define IMX6UL_IOMUXC_LCD_BUSY_SELECT_INPUT			0x000005dc
#define IMX6UL_IOMUXC_SAI1_MCLK_SELECT_INPUT			0x000005e0
#define IMX6UL_IOMUXC_SAI1_RX_DATA_SELECT_INPUT			0x000005e4
#define IMX6UL_IOMUXC_SAI1_TX_BCLK_SELECT_INPUT			0x000005e8
#define IMX6UL_IOMUXC_SAI1_TX_SYNC_SELECT_INPUT			0x000005ec
#define IMX6UL_IOMUXC_SAI2_MCLK_SELECT_INPUT			0x000005f0
#define IMX6UL_IOMUXC_SAI2_RX_DATA_SELECT_INPUT			0x000005f4
#define IMX6UL_IOMUXC_SAI2_TX_BCLK_SELECT_INPUT			0x000005f8
#define IMX6UL_IOMUXC_SAI2_TX_SYNC_SELECT_INPUT			0x000005fc
#define IMX6UL_IOMUXC_SAI3_MCLK_SELECT_INPUT			0x00000600
#define IMX6UL_IOMUXC_SAI3_RX_DATA_SELECT_INPUT			0x00000604
#define IMX6UL_IOMUXC_SAI3_TX_BCLK_SELECT_INPUT			0x00000608
#define IMX6UL_IOMUXC_SAI3_TX_SYNC_SELECT_INPUT			0x0000060c
#define IMX6UL_IOMUXC_SDMA_EVENTS0_SELECT_INPUT			0x00000610
#define IMX6UL_IOMUXC_SDMA_EVENTS1_SELECT_INPUT			0x00000614
#define IMX6UL_IOMUXC_SPDIF_IN_SELECT_INPUT			0x00000618
#define IMX6UL_IOMUXC_SPDIF_EXT_CLK_SELECT_INPUT		0x0000061c
#define IMX6UL_IOMUXC_UART1_RTS_B_SELECT_INPUT			0x00000620
#define IMX6UL_IOMUXC_UART1_RX_DATA_SELECT_INPUT		0x00000624
#define IMX6UL_IOMUXC_UART2_RTS_B_SELECT_INPUT			0x00000628
#define IMX6UL_IOMUXC_UART2_RX_DATA_SELECT_INPUT		0x0000062c
#define IMX6UL_IOMUXC_UART3_RTS_B_SELECT_INPUT			0x00000630
#define IMX6UL_IOMUXC_UART3_RX_DATA_SELECT_INPUT		0x00000634
#define IMX6UL_IOMUXC_UART4_RTS_B_SELECT_INPUT			0x00000638
#define IMX6UL_IOMUXC_UART4_RX_DATA_SELECT_INPUT		0x0000063c
#define IMX6UL_IOMUXC_UART5_RTS_B_SELECT_INPUT			0x00000640
#define IMX6UL_IOMUXC_UART5_RX_DATA_SELECT_INPUT		0x00000644
#define IMX6UL_IOMUXC_UART6_RTS_B_SELECT_INPUT			0x00000648
#define IMX6UL_IOMUXC_UART6_RX_DATA_SELECT_INPUT		0x0000064c
#define IMX6UL_IOMUXC_UART7_RTS_B_SELECT_INPUT			0x00000650
#define IMX6UL_IOMUXC_UART7_RX_DATA_SELECT_INPUT		0x00000654
#define IMX6UL_IOMUXC_UART8_RTS_B_SELECT_INPUT			0x00000658
#define IMX6UL_IOMUXC_UART8_RX_DATA_SELECT_INPUT		0x0000065c
#define IMX6UL_IOMUXC_USB_OTG2_OC_SELECT_INPUT			0x00000660
#define IMX6UL_IOMUXC_USB_OTG_OC_SELECT_INPUT			0x00000664
#define IMX6UL_IOMUXC_USDHC1_CD_B_SELECT_INPUT			0x00000668
#define IMX6UL_IOMUXC_USDHC1_WP_SELECT_INPUT			0x0000066c
#define IMX6UL_IOMUXC_USDHC2_CLK_SELECT_INPUT			0x00000670
#define IMX6UL_IOMUXC_USDHC2_CD_B_SELECT_INPUT			0x00000674
#define IMX6UL_IOMUXC_USDHC2_CMD_SELECT_INPUT			0x00000678
#define IMX6UL_IOMUXC_USDHC2_DATA0_SELECT_INPUT			0x0000067c
#define IMX6UL_IOMUXC_USDHC2_DATA1_SELECT_INPUT			0x00000680
#define IMX6UL_IOMUXC_USDHC2_DATA2_SELECT_INPUT			0x00000684
#define IMX6UL_IOMUXC_USDHC2_DATA3_SELECT_INPUT			0x00000688
#define IMX6UL_IOMUXC_USDHC2_DATA4_SELECT_INPUT			0x0000068c
#define IMX6UL_IOMUXC_USDHC2_DATA5_SELECT_INPUT			0x00000690
#define IMX6UL_IOMUXC_USDHC2_DATA6_SELECT_INPUT			0x00000694
#define IMX6UL_IOMUXC_USDHC2_DATA7_SELECT_INPUT			0x00000698
#define IMX6UL_IOMUXC_USDHC2_WP_SELECT_INPUT			0x0000069c


/* IOMUXC_SW_MUX_CTL_PAD_xxx */
#define IOMUX_CONFIG_SION	__BIT(4)
#define IOMUX_CONFIG_ALT0	0
#define IOMUX_CONFIG_ALT1	1
#define IOMUX_CONFIG_ALT2	2
#define IOMUX_CONFIG_ALT3	3
#define IOMUX_CONFIG_ALT4	4
#define IOMUX_CONFIG_ALT5	5
#define IOMUX_CONFIG_ALT6	6
#define IOMUX_CONFIG_ALT7	7
/* IOMUXC_SW_PAD_CTL_PAD_xxx */
#define PAD_CTL_DDR_SEL_MASK	__BITS(19, 18)
#define PAD_CTL_DDR_SEL_0	__SHIFTIN(0, PAD_CTL_DDR_SEL_MASK)
#define PAD_CTL_DDR_SEL_1	__SHIFTIN(1, PAD_CTL_DDR_SEL_MASK)
#define PAD_CTL_DDR_SEL_2	__SHIFTIN(2, PAD_CTL_DDR_SEL_MASK)
#define PAD_CTL_DDR_SEL_3	__SHIFTIN(3, PAD_CTL_DDR_SEL_MASK)
#define PAD_CTL_HYS		__BIT(16)
#define PAD_CTL_PUS_MASK	__BITS(15, 14)
#define PAD_CTL_PUS_100K_PD	__SHIFTIN(0x0, PAD_CTL_PUS_MASK)
#define PAD_CTL_PUS_47K_PU	__SHIFTIN(0x1, PAD_CTL_PUS_MASK)
#define PAD_CTL_PUS_100K_PU	__SHIFTIN(0x2, PAD_CTL_PUS_MASK)
#define PAD_CTL_PUS_22K_PU	__SHIFTIN(0x3, PAD_CTL_PUS_MASK)
#define PAD_CTL_PUE		__BIT(13)
#define PAD_CTL_PKE		__BIT(12)
#define PAD_CTL_PULL		(PAD_CTL_PKE|PAD_CTL_PUE)
#define PAD_CTL_KEEPER		(PAD_CTL_PKE|0)
#define PAD_CTL_ODE		__BIT(11)
#define PAD_CTL_ODT		__BITS(10, 8)
#define PAD_CTL_SPEED_MASK	__BITS(7, 6)
#define PAD_CTL_SPEED_LOW50MHZ	__SHIFTIN(0, PAD_CTL_SPEED_MASK)
#define PAD_CTL_SPEED_50MHZ	__SHIFTIN(1, PAD_CTL_SPEED_MASK)
#define PAD_CTL_SPEED_100MHZ	__SHIFTIN(2, PAD_CTL_SPEED_MASK)
#define PAD_CTL_SPEED_200MHZ	__SHIFTIN(3, PAD_CTL_SPEED_MASK)
#define PAD_CTL_DSE_MASK	__BITS(5, 3)
#define PAD_CTL_DSE_HIZ		__SHIFTIN(0x0, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_290OHM	__SHIFTIN(0x1, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_240OHM	__SHIFTIN(0x1, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_121OHM	__SHIFTIN(0x2, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_120OHM	__SHIFTIN(0x2, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_80OHM	__SHIFTIN(0x3, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_76OHM	__SHIFTIN(0x3, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_60OHM	__SHIFTIN(0x4, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_48OHM	__SHIFTIN(0x5, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_47OHM	__SHIFTIN(0x4, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_45OHM	__SHIFTIN(0x5, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_40OHM	__SHIFTIN(0x6, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_37OHM	__SHIFTIN(0x6, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_34OHM	__SHIFTIN(0x7, PAD_CTL_DSE_MASK)
#define PAD_CTL_DSE_31OHM	__SHIFTIN(0x7, PAD_CTL_DSE_MASK)
#define PAD_CTL_SRE		__BIT(0)
#define PAD_CTL_SRE_SLOW	0
#define PAD_CTL_SRE_FAST	PAD_CTL_SRE
/* IOMUXC_SW_PAD_CTL_PAD_xxx */
#define INPUT_DAISY_0		0
#define INPUT_DAISY_1		1
#define INPUT_DAISY_2		2
#define INPUT_DAISY_3		3
#define INPUT_DAISY_4		4
#define INPUT_DAISY_5		5
#define INPUT_DAISY_6		6
#define INPUT_DAISY_7		7

/*
 * IOMUX index macro
 */
#define IOMUX_PIN_TO_MUX_ADDRESS(pin)	(((pin) >> 16) & 0xffff)
#define IOMUX_PIN_TO_PAD_ADDRESS(pin)	(((pin) >>  0) & 0xffff)
#define IOMUX_MUX_NONE	0xffff
#define IOMUX_PAD_NONE	0xffff
#define IOMUX_PIN(mux_adr, pad_adr)		\
	(((mux_adr) << 16) | (((pad_adr) << 0)))
#define MUX_PIN(prefix, name)				\
	IOMUX_PIN(prefix##_IOMUXC_SW_MUX_CTL_PAD_##name,	\
	    prefix##_IOMUXC_SW_PAD_CTL_PAD_##name)

#endif /* _ARM_IMX_IMX6_IOMUXREG_H_ */
